# Generated by Django 4.2.14 on 2025-03-13 13:02

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('locations', '0006_merge_20250129_1542'),
        ('base', '0018_merge_20250307_1944'),
        ('procedures', '0008_merge_20250218_1723'),
        ('devices', '0007_alter_device_status_and_more'),
        ('patients', '0007_patientorganizationreference'),
        ('careplans', '0006_careplandevicerequestreference'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('organizations', '0004_organizationcodeablereference'),
        ('practitioners', '0011_practitionerrolereference'),
        ('provenances', '0001_initial'),
        ('encounters', '0009_encounterepisodeofcarereference'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='DeviceDispenseReceiverReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_receiver_reference_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_receiver_reference_location', to='locations.location')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_receiver_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_receiver_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_receiver_reference_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDispensePerformerActorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_actor_reference_device_care_team', to='careteams.careteam')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_actor_reference_device', to='devices.device')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_actor_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_actor_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_actor_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_actor_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_actor_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_actor_reference_device_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDispensePerformer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('actor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_actor', to='devicedispenses.devicedispenseperformeractorreference')),
                ('function', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_performer_function', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDispense',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('in-progress', 'In Progress'), ('completed', 'Completed'), ('entered-in-error', 'Entered in Error'), ('stopped', 'Stopped'), ('on-hold', 'On Hold'), ('cancelled', 'Cancelled'), ('preparation', 'Preparation'), ('declined', 'Declined')], max_length=255, null=True)),
                ('prepared_date', models.DateTimeField(null=True)),
                ('when_handed_over', models.DateTimeField(null=True)),
                ('usage_instruction', models.TextField(null=True)),
                ('based_on', models.ManyToManyField(blank=True, related_name='device_dispense_based_on', to='careplans.careplandevicerequestreference')),
                ('category', models.ManyToManyField(blank=True, related_name='device_dispense_category', to='base.codeableconcept')),
                ('destination', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_destination', to='locations.locationreference')),
                ('encounter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_encounter', to='encounters.encounterreference')),
                ('event_history', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_event_history', to='provenances.provenancereference')),
                ('identifier', models.ManyToManyField(blank=True, related_name='device_dispense_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_location', to='locations.locationreference')),
                ('note', models.ManyToManyField(blank=True, related_name='device_dispense_note', to='base.annotation')),
                ('part_of', models.ManyToManyField(blank=True, related_name='device_dispense_part_of', to='procedures.procedurereference')),
                ('performer', models.ManyToManyField(blank=True, related_name='device_dispense_performer', to='devicedispenses.devicedispenseperformer')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_quantity', to='base.simplequantity')),
                ('receiver', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_dispense_receiver', to='devicedispenses.devicedispensereceiverreference')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
