# Generated by Django 4.2.14 on 2025-01-27 13:40

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0008_alter_extendedcontactdetail_address_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='DeviceDefinition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('description', models.TextField(null=True)),
                ('part_number', models.CharField(max_length=255, null=True)),
                ('model_number', models.CharField(max_length=255, null=True)),
                ('publisher', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_codeable_reference_concept', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionMarketDistribution',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sub_jurisdiction', models.CharField(max_length=255, null=True)),
                ('market_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionRegulatoryIdentifier',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('type', models.CharField(choices=[('BASIC', 'basic'), ('MASTER', 'master'), ('LICENSE', 'license')], max_length=255)),
                ('device_identifier', models.CharField(max_length=255)),
                ('issuer', models.CharField(max_length=255)),
                ('jurisdiction', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceVersion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value', models.CharField(max_length=255, null=True)),
                ('component', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_version_component', to='base.identifier')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_version_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionUdiDeviceIdentifier',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('device_identifier', models.CharField(max_length=255)),
                ('issuer', models.CharField(max_length=255)),
                ('jurisdiction', models.CharField(max_length=255)),
                ('market_distribution', models.ManyToManyField(blank=True, to='devicedefinitions.devicedefinitionmarketdistribution')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device_definition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_reference_device_definition', to='devicedefinitions.devicedefinition')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionProperty',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value_string', models.CharField(max_length=255, null=True)),
                ('value_boolean', models.BooleanField(null=True)),
                ('value_integer', models.IntegerField(null=True)),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_property_type', to='base.codeableconcept')),
                ('value_attachment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_property_value_attachment', to='base.attachment')),
                ('value_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_property_value_code', to='base.codeableconcept')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_property_value_quantity', to='base.quantity')),
                ('value_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_property_value_range', to='base.range')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionPackagingDistributor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=255)),
                ('organization_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_packaging_distributor_organization_reference', to='base.organizationreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionPackaging',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('count', models.IntegerField(null=True)),
                ('distributor', models.ManyToManyField(blank=True, related_name='device_definition_packaging_distributor', to='devicedefinitions.devicedefinitionpackagingdistributor')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_packaging_identifier', to='base.identifier')),
                ('packaging', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_packaging_packaging', to='devicedefinitions.devicedefinitionpackaging')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_packaging_type', to='base.codeableconcept')),
                ('udi_device_identifier', models.ManyToManyField(blank=True, related_name='device_definition_packaging_udihistory', to='devicedefinitions.devicedefinitionudideviceidentifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionMaterial',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('alternate', models.BooleanField(null=True)),
                ('allergenic_indicator', models.BooleanField(null=True)),
                ('substance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_material_substance', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionLink',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('related_device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_link_related_device', to='devicedefinitions.devicedefinitioncodeablereference')),
                ('relation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_link_relation', to='base.coding')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionHasPart',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('count', models.IntegerField(null=True)),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_has_part_reference', to='devicedefinitions.devicedefinitionreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionGuideline',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('usage_instruction', models.TextField(null=True)),
                ('intended_use', models.CharField(max_length=255, null=True)),
                ('contraindication', models.ManyToManyField(blank=True, related_name='device_definition_guideline_contraindication', to='base.codeableconcept')),
                ('indication', models.ManyToManyField(blank=True, related_name='device_definition_guideline_indication', to='base.codeableconcept')),
                ('related_artifact', models.ManyToManyField(blank=True, related_name='device_definition_guideline_related_artifact', to='base.relatedartifact')),
                ('use_context', models.ManyToManyField(blank=True, related_name='device_definition_guideline_use_context', to='base.usagecontext')),
                ('warning', models.ManyToManyField(blank=True, related_name='device_definition_guideline_warning', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionDeviceName',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=255)),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_device_name_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionCorrectiveAction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('recall', models.BooleanField(null=True)),
                ('scope', models.CharField(choices=[('model', 'model'), ('lot_numbers', 'lot_numbers'), ('serial_numbers', 'serial_numbers')], max_length=255, null=True)),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_corrective_action_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionConformsTo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('version', models.CharField(max_length=255, null=True)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_conforms_to_category', to='base.codeableconcept')),
                ('source', models.ManyToManyField(blank=True, related_name='device_definition_conforms_to_source', to='base.relatedartifact')),
                ('specification', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_conforms_to_specification', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='devicedefinitioncodeablereference',
            name='reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_codeable_reference_reference', to='devicedefinitions.devicedefinitionreference'),
        ),
        migrations.CreateModel(
            name='DeviceDefinitionClassification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('justification', models.ManyToManyField(blank=True, related_name='device_definition_classification_jurisdication', to='base.relatedartifact')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_classification_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceDefinitionChargeItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('count', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_charge_item_count', to='base.quantity')),
                ('effective_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definition_charge_item_effective_period', to='base.period')),
                ('use_context', models.ManyToManyField(blank=True, related_name='device_definition_charge_item_use_context', to='base.usagecontext')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='charge_item',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_charge_item', to='devicedefinitions.devicedefinitionchargeitem'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='classification',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_classification', to='devicedefinitions.devicedefinitionclassification'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='conforms_to',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_conforms_to', to='devicedefinitions.devicedefinitionconformsto'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='contact',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_contact', to='base.contactdetail'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='corrective_action',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definitions_corrective_action', to='devicedefinitions.devicedefinitioncorrectiveaction'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='device_name',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_device_name', to='devicedefinitions.devicedefinitiondevicename'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='device_version',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_device_version', to='devicedefinitions.deviceversion'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='guideline',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definitions_guideline', to='devicedefinitions.devicedefinitionguideline'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='has_part',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_has_part', to='devicedefinitions.devicedefinitionhaspart'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='language_code',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definitions_language_code', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='link',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_link', to='devicedefinitions.devicedefinitionlink'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='manufacturer',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definitions_manufacturer', to='base.organizationreference'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='material',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_material', to='devicedefinitions.devicedefinitionmaterial'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='packaging',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_packaging', to='devicedefinitions.devicedefinitionpackaging'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='property',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_property', to='devicedefinitions.devicedefinitionproperty'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='regulatory_identifier',
            field=models.ManyToManyField(blank=True, to='devicedefinitions.devicedefinitionregulatoryidentifier'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='safety',
            field=models.ManyToManyField(blank=True, related_name='device_definitions_safety', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='shelf_life_storage',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definitions_shelf_life_storage', to='base.productshelflife'),
        ),
        migrations.AddField(
            model_name='devicedefinition',
            name='udi_device_identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_definitions_udi_device_identifier', to='devicedefinitions.devicedefinitionudideviceidentifier'),
        ),
    ]
