# Generated by Django 4.2.14 on 2025-03-14 12:42

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('patients', '0007_patientorganizationreference'),
        ('devices', '0007_alter_device_status_and_more'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('practitioners', '0011_practitionerrolereference'),
        ('bodystructures', '0006_bodystructurecodeablereference'),
        ('base', '0018_merge_20250307_1944'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='DeviceAssociationSubjectReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_association_subject_reference_device', to='devices.device')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_association_subject_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_association_subject_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_association_subject_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_association_subject_reference_practitioner', to='practitioners.practitioner')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='device_association_subject_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceAssociationOperationOperatorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='device_association_operation_operator_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='device_association_operation_operator_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='device_association_operation_operator_reference_practitioner', to='practitioners.practitioner')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='device_association_operation_operator_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceAssociationOperation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('operator', models.ManyToManyField(blank=True, related_name='device_association_operation_operator', to='deviceassociations.deviceassociationoperationoperatorreference')),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_association_operation_period', to='base.period')),
                ('status', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_association_operation_status', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeviceAssociation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('implanted', 'Implanted'), ('explanted', 'Explanted'), ('attached', 'Attached'), ('entered-in-error', 'Entered in Error'), ('unknown', 'Unknown')], default='implanted', max_length=20)),
                ('body_structure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_association_body_structure', to='bodystructures.bodystructurereference')),
                ('category', models.ManyToManyField(blank=True, related_name='device_association_category', to='base.codeableconcept')),
                ('device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='device_association_device', to='devices.devicereference')),
                ('identifier', models.ManyToManyField(blank=True, related_name='device_association_identifier', to='base.identifier')),
                ('operation', models.ManyToManyField(blank=True, related_name='device_association_operation', to='deviceassociations.deviceassociationoperation')),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='device_association_period', to='base.period')),
                ('status_reason', models.ManyToManyField(blank=True, related_name='device_association_status_reason', to='base.codeableconcept')),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='device_association_subject', to='deviceassociations.deviceassociationsubjectreference')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
