# Generated by Django 4.2.14 on 2025-02-05 12:58

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('base', '0010_expression_relativetime'),
        ('nutritionproducts', '0003_remove_nutritionproductnutrients_allergen'),
        ('procedures', '0001_initial'),
        ('organizations', '0003_organization_endpoint'),
        ('encounters', '0008_alter_encounterlocation_location'),
        ('devices', '0007_alter_device_status_and_more'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
        ('locations', '0006_merge_20250129_1542'),
        ('medications', '0004_medicationreference_medicationcodeablereference'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('substances', '0002_substancecodeablereference'),
        ('patients', '0007_patientorganizationreference'),
    ]

    operations = [
        migrations.CreateModel(
            name='DetectedIssueSubjectReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_device', to='devices.device')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_location', to='locations.location')),
                ('medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_medication', to='medications.medication')),
                ('nutrition_product', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_nutrition_product', to='nutritionproducts.nutritionproduct')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_practitioner', to='practitioners.practitioner')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_procedure', to='procedures.procedure')),
                ('substance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_subject_reference_substance', to='substances.substance')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DetectedIssueMitigation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('date', models.DateTimeField(null=True)),
                ('action', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_mitigation_action', to='base.codeableconcept')),
                ('author', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_mitigation_author', to='practitioners.practitionerpractitionerrolereference')),
                ('note', models.ManyToManyField(blank=True, related_name='detected_issue_mitigation_note', to='base.annotation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DetectedIssueEvidence',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_evidence_code', to='base.codeableconcept')),
                ('detail', models.ManyToManyField(blank=True, related_name='detected_issue_evidence_detail', to='base.reference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DetectedIssueAuthorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_author_reference_device', to='devices.device')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_author_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_author_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_author_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_author_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_author_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DetectedIssue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('preliminary', 'Preliminary'), ('final', 'Final'), ('entered-in-error', 'Entered in Error'), ('mitigated', 'Mitigated')], max_length=255, null=True)),
                ('severity', models.CharField(choices=[('high', 'High'), ('moderate', 'Moderate'), ('low', 'Low')], max_length=255, null=True)),
                ('identified_date_time', models.DateTimeField(null=True)),
                ('detail', models.TextField(null=True)),
                ('reference', models.URLField(null=True)),
                ('author', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_author', to='detectedissues.detectedissueauthorreference')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_category', to='base.codeableconcept')),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_code', to='base.codeableconcept')),
                ('encounter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_encounter', to='encounters.encounterreference')),
                ('evidence', models.ManyToManyField(blank=True, related_name='detected_issue_evidence', to='detectedissues.detectedissueevidence')),
                ('identified_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='base.period')),
                ('identifier', models.ManyToManyField(blank=True, related_name='detected_issue_identifier', to='base.identifier')),
                ('implicated', models.ManyToManyField(blank=True, related_name='detected_issue_implicated', to='base.reference')),
                ('mitigation', models.ManyToManyField(blank=True, related_name='detected_issue_mitigation', to='detectedissues.detectedissuemitigation')),
                ('subject', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='detected_issue_patient', to='detectedissues.detectedissuesubjectreference')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
