# Generated by Django 4.2.14 on 2025-02-20 12:45

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('patients', '0007_patientorganizationreference'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('base', '0013_money'),
    ]

    operations = [
        migrations.CreateModel(
            name='CoverageEligibilityResponseRequesterReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_requester_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_requester_reference_organization', to='base.organizationreference')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_requester_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_requester_reference_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityResponseInsuranceItemBenefit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('allowed_string', models.CharField(max_length=255, null=True)),
                ('allowed_unsigned_int', models.PositiveIntegerField(null=True)),
                ('used_string', models.CharField(max_length=255, null=True)),
                ('used_unsigned_int', models.PositiveIntegerField(null=True)),
                ('allowed_money', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_item_benefit_allowed_money', to='base.money')),
                ('type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_item_benefit_type', to='base.codeableconcept')),
                ('used_money', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_item_benefit_used_money', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityResponseInsuranceItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('excluded', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=255, null=True)),
                ('description', models.TextField(null=True)),
                ('authorization_required', models.BooleanField(default=False)),
                ('authorization_url', models.URLField(null=True)),
                ('authorization_supporting', models.ManyToManyField(blank=True, related_name='coverage_eligibility_response_insurance_item_authorization_supporting', to='base.codeableconcept')),
                ('benefit', models.ManyToManyField(blank=True, related_name='coverage_eligibility_response_insurance_item_benefit', to='coverageeligibilityresponses.coverageeligibilityresponseinsuranceitembenefit')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_item_category', to='base.codeableconcept')),
                ('modifier', models.ManyToManyField(related_name='coverage_eligibility_response_insurance_item_modifier', to='base.codeableconcept')),
                ('network', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_item_network', to='base.codeableconcept')),
                ('product_or_service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_item_product_or_service', to='base.codeableconcept')),
                ('provider', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_item_provider', to='practitioners.practitionerpractitionerrolereference')),
                ('term', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_item_term', to='base.codeableconcept')),
                ('unit', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_item_unit_price', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityResponseInsurance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('inforce', models.BooleanField(default=False)),
                ('benefit_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurance_benefit_period', to='base.period')),
                ('item', models.ManyToManyField(blank=True, related_name='coverage_eligibility_response_insurance_item', to='coverageeligibilityresponses.coverageeligibilityresponseinsuranceitem')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityResponseEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('when_date_time', models.DateTimeField(null=True)),
                ('type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_event_type', to='base.codeableconcept')),
                ('when_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_event_when_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityResponseError',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('expression', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_error_code', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityResponse',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('active', 'Active'), ('cancelled', 'Cancelled'), ('draft', 'Draft'), ('entered-in-error', 'Entered in Error')], default='active', max_length=255)),
                ('purpose', models.CharField(choices=[('auth-requirements', 'Auth Requirements'), ('benefits', 'Benefits'), ('discovery', 'Discovery'), ('validation', 'Validation')], default='auth-requirements', max_length=255)),
                ('serviced_date', models.DateField(null=True)),
                ('created', models.DateTimeField(null=True)),
                ('outcome', models.CharField(choices=[('queued', 'Queued'), ('complete', 'Complete'), ('error', 'Error'), ('partial', 'Partial')], default='queued', max_length=255)),
                ('disposition', models.TextField(null=True)),
                ('pre_auth_ref', models.CharField(max_length=255, null=True)),
                ('error', models.ManyToManyField(blank=True, related_name='coverage_eligibility_response_error', to='coverageeligibilityresponses.coverageeligibilityresponseerror')),
                ('event', models.ManyToManyField(blank=True, related_name='coverage_eligibility_response_event', to='coverageeligibilityresponses.coverageeligibilityresponseevent')),
                ('form', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_form', to='base.codeableconcept')),
                ('identifier', models.ManyToManyField(blank=True, related_name='coverage_eligibility_response_identifier', to='base.identifier')),
                ('insurance', models.ManyToManyField(blank=True, related_name='coverage_eligibility_response_insurance', to='coverageeligibilityresponses.coverageeligibilityresponseinsurance')),
                ('insurer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_insurer', to='base.organizationreference')),
                ('patient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_patient', to='patients.patientreference')),
                ('requestor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_requestor', to='coverageeligibilityresponses.coverageeligibilityresponserequesterreference')),
                ('serviced_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_response_serviced_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
