# Generated by Django 4.2.14 on 2025-02-20 11:29

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('base', '0013_money'),
        ('organizations', '0003_organization_endpoint'),
        ('locations', '0006_merge_20250129_1542'),
        ('conditions', '0006_merge_20250217_1423'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('patients', '0007_patientorganizationreference'),
    ]

    operations = [
        migrations.CreateModel(
            name='CoverageEligibilityRequestDiagnosis',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('diagnosis_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_diagnosis_codeable_concept', to='base.codeableconcept')),
                ('diagnosis_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_diagnosis_reference', to='conditions.conditionreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityRequestInsurance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('focal', models.BooleanField(default=False)),
                ('business_arrangement', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityRequestSupportingInfoInformationReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_supporting_info_information_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityRequestSupportingInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField()),
                ('applies_to_all', models.BooleanField(default=False)),
                ('information', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_supporting_info_information', to='coverageeligibilityrequests.coverageeligibilityrequestsupportinginfoinformationreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityRequestProviderReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_provider_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_provider_reference_organization', to='organizations.organization')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_provider_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_provider_reference_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityRequestItemDetailReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_item_detail_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityRequestItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('supporting_info_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_item_category', to='base.codeableconcept')),
                ('detail', models.ManyToManyField(blank=True, related_name='coverage_eligibility_request_item_detail', to='coverageeligibilityrequests.coverageeligibilityrequestitemdetailreference')),
                ('diagnosis', models.ManyToManyField(blank=True, related_name='coverage_eligibility_request_item_diagnosis', to='coverageeligibilityrequests.coverageeligibilityrequestdiagnosis')),
                ('facility', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_item_facility', to='locations.locationorganizationreference')),
                ('modifier', models.ManyToManyField(blank=True, related_name='coverage_eligibility_request_item_modifier', to='base.codeableconcept')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_item_product_or_service', to='base.codeableconcept')),
                ('provider', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_item_provider', to='practitioners.practitionerpractitionerrolereference')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_item_quantity', to='base.simplequantity')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_item_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityRequestEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('when_date_time', models.DateTimeField(null=True)),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_event_type', to='base.codeableconcept')),
                ('when_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_event_when_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CoverageEligibilityRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('active', 'Active'), ('cancelled', 'Cancelled'), ('draft', 'Draft'), ('entered-in-error', 'Entered in Error')], max_length=255)),
                ('purpose', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(choices=[('auth-requirements', 'Auth Requirements'), ('benefits', 'Benefits'), ('discovery', 'Discovery'), ('validation', 'Validation')], max_length=255), null=True, size=None)),
                ('service_date', models.DateField(null=True)),
                ('created', models.DateTimeField(null=True)),
                ('enterer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_enterer', to='practitioners.practitionerpractitionerrolereference')),
                ('event', models.ManyToManyField(blank=True, related_name='coverage_eligibility_request_event', to='coverageeligibilityrequests.coverageeligibilityrequestevent')),
                ('facility', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_facility', to='locations.locationreference')),
                ('identifier', models.ManyToManyField(blank=True, related_name='coverage_eligibility_request_identifier', to='base.identifier')),
                ('insurance', models.ManyToManyField(blank=True, related_name='coverage_eligibility_request_insurance', to='coverageeligibilityrequests.coverageeligibilityrequestinsurance')),
                ('insurer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_insurer', to='base.organizationreference')),
                ('item', models.ManyToManyField(blank=True, related_name='coverage_eligibility_request_item', to='coverageeligibilityrequests.coverageeligibilityrequestitem')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_patient', to='patients.patientreference')),
                ('priority', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_priority', to='base.codeableconcept')),
                ('provider', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_provider', to='coverageeligibilityrequests.coverageeligibilityrequestproviderreference')),
                ('service_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='coverage_eligibility_request_service_period', to='base.period')),
                ('supporting_info', models.ManyToManyField(blank=True, related_name='coverage_eligibility_request_supporting_info', to='coverageeligibilityrequests.coverageeligibilityrequestsupportinginfo')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
