# Generated by Django 4.2.14 on 2025-02-19 11:53

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('patients', '0007_patientorganizationreference'),
        ('encounters', '0009_encounterepisodeofcarereference'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
        ('locations', '0006_merge_20250129_1542'),
        ('diagnosticreports', '0005_diagnosticreportdocumentreferencereference'),
        ('devices', '0007_alter_device_status_and_more'),
        ('organizations', '0003_organization_endpoint'),
        ('provenances', '0001_initial'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('conditions', '0006_merge_20250217_1423'),
        ('substances', '0002_substancecodeablereference'),
        ('observations', '0008_alter_observationcodeablereference_concept_and_more'),
        ('base', '0014_signaturewhenreference_signatureonbehalfofreference_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='Contract',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('url', models.URLField(null=True)),
                ('version', models.CharField(max_length=255, null=True)),
                ('status', models.CharField(choices=[('amended', 'Amended'), ('appended', 'Appended'), ('cancelled', 'Cancelled'), ('disputed', 'Disputed'), ('entered-in-error', 'Entered in Error'), ('executed', 'Executed'), ('executable', 'Executable'), ('negotiable', 'Negotiable'), ('offered', 'Offered'), ('rejected', 'Rejected'), ('renewed', 'Renewed'), ('revoked', 'Revoked'), ('resolved', 'Resolved'), ('terminated', 'Terminated')], max_length=255, null=True)),
                ('instantiates_uri', models.URLField(null=True)),
                ('issued', models.DateTimeField(null=True)),
                ('name', models.CharField(max_length=255, null=True)),
                ('title', models.CharField(max_length=255, null=True)),
                ('subtitle', models.CharField(max_length=255, null=True)),
                ('alias', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('applies', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_applies', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermSecurityLabel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('number', models.IntegerField(null=True)),
                ('category', models.ManyToManyField(blank=True, related_name='contract_term_security_label_category', to='base.coding')),
                ('classification', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_security_label_classification', to='base.coding')),
                ('control', models.ManyToManyField(blank=True, related_name='contract_term_security_label_control', to='base.coding')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermOfferPartyReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_reference_device', to='devices.device')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermOfferParty',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_reference', to='contracts.contracttermofferpartyreference')),
                ('role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_party_role', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermOfferAnswer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value_boolean', models.BooleanField(null=True)),
                ('value_decimal', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('value_integer', models.IntegerField(null=True)),
                ('value_date', models.DateField(null=True)),
                ('value_date_time', models.DateTimeField(null=True)),
                ('value_time', models.TimeField(null=True)),
                ('value_string', models.CharField(max_length=255, null=True)),
                ('value_uri', models.URLField(null=True)),
                ('text', models.TextField(null=True)),
                ('link_id', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('security_label_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('value_attachment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_answer_attachment', to='base.attachment')),
                ('value_coding', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_answer_coding', to='base.coding')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_answer_quantity', to='base.quantity')),
                ('value_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_answer_reference', to='base.reference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermOffer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('text', models.TextField(null=True)),
                ('link_id', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('security_label_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('answer', models.ManyToManyField(blank=True, related_name='contract_term_offer_answer', to='contracts.contracttermofferanswer')),
                ('decision', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_decision', to='base.codeableconcept')),
                ('decision_mode', models.ManyToManyField(blank=True, related_name='contract_term_offer_decision_mode', to='base.codeableconcept')),
                ('identifier', models.ManyToManyField(blank=True, related_name='contract_term_offer_identifier', to='base.identifier')),
                ('party', models.ManyToManyField(blank=True, related_name='contract_term_offer_party', to='contracts.contracttermofferparty')),
                ('topic', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_topic', to='base.reference')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermAssetValuedItemResponsibleReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_responsible_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_responsible_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_responsible_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_responsible_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_responsible_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_responsible_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermAssetValuedItemRecipientReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_recipient_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_recipient_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_recipient_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_recipient_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_recipient_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_tem_asset_valued_item_recipient_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermAssetValuedItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('effective_time', models.DateTimeField(null=True)),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('points', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('payment', models.CharField(max_length=255, null=True)),
                ('payment_date', models.DateTimeField(null=True)),
                ('link_id', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('security_label_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('entity_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_valued_item_entity_codeable_concept', to='base.codeableconcept')),
                ('entity_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_valued_item_entity_reference', to='base.reference')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_valued_item_identifier', to='base.identifier')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_valued_item_net', to='base.money')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_valued_item_quantity', to='base.simplequantity')),
                ('recipient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_valued_item_recipient', to='contracts.contracttermassetvalueditemrecipientreference')),
                ('responsible', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_valued_item_responsible', to='contracts.contracttermassetvalueditemresponsiblereference')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_valued_item_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermAssetContext',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('text', models.TextField(null=True)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_context_code', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_context_reference', to='base.reference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermAsset',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('condition', models.TextField(null=True)),
                ('text', models.TextField(null=True)),
                ('link_id', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('security_label_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('answer', models.ManyToManyField(blank=True, related_name='contract_term_asset_answer', to='contracts.contracttermofferanswer')),
                ('context', models.ManyToManyField(blank=True, related_name='contract_term_asset_context', to='contracts.contracttermassetcontext')),
                ('period', models.ManyToManyField(blank=True, related_name='contract_term_asset_period', to='base.period')),
                ('period_type', models.ManyToManyField(blank=True, related_name='contract_term_asset_period_type', to='base.codeableconcept')),
                ('relationship', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_relationship', to='base.coding')),
                ('scope', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_asset_scope', to='base.codeableconcept')),
                ('subtype', models.ManyToManyField(blank=True, related_name='contract_term_asset_subtype', to='base.codeableconcept')),
                ('type', models.ManyToManyField(blank=True, related_name='contract_term_asset_type', to='base.codeableconcept')),
                ('type_reference', models.ManyToManyField(blank=True, related_name='contract_term_asset_type_reference', to='base.reference')),
                ('use_period', models.ManyToManyField(blank=True, related_name='contract_term_asset_use_period', to='base.period')),
                ('valued_item', models.ManyToManyField(blank=True, related_name='contract_term_asset_valued_item', to='contracts.contracttermassetvalueditem')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermActionSubjectReferenceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_reference_reference_device', to='devices.device')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_reference_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_reference_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_reference_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_reference_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_reference_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_reference_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_reference_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermActionSubject',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_reference', to='contracts.contracttermactionsubjectreferencereference')),
                ('role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject_role', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermActionRequesterReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_requester_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_requester_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_requester_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_requester_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_requester_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_requester_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_requester_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermActionReasonReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('condition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_reason_reference_condition', to='conditions.condition')),
                ('diagnostic_report', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_reason_reference_diagnostic_report', to='diagnosticreports.diagnosticreport')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_reason_reference_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_reason_reference_observation', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermActionReasonCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_reason_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_reason_codeable_reference_reference', to='contracts.contracttermactionreasonreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermActionPerformerReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_care_team', to='careteams.careteam')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_device', to='devices.device')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_location', to='locations.location')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_related_person', to='relatedpersons.relatedperson')),
                ('substance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_reference_substance', to='substances.substance')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTermAction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('do_not_perform', models.BooleanField(default=False)),
                ('link_id', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('context_link_id', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('occurrence_date_time', models.DateTimeField(null=True)),
                ('requester_link_id', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('performer_link_id', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('reason_link_id', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('security_label_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('context', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_context', to='encounters.encounterepisodeofcarereference')),
                ('intent', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_intent', to='base.codeableconcept')),
                ('note', models.ManyToManyField(blank=True, related_name='contract_term_action_note', to='base.annotation')),
                ('occurrence_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_occurrence_period', to='base.period')),
                ('occurrence_timing', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_occurrence_timing', to='base.timing')),
                ('performer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer', to='contracts.contracttermactionperformerreference')),
                ('performer_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_performer_role', to='base.codeableconcept')),
                ('performer_type', models.ManyToManyField(blank=True, related_name='contract_term_action_performer_type', to='base.codeableconcept')),
                ('reason', models.ManyToManyField(blank=True, related_name='contract_term_action_reason', to='contracts.contracttermactionreasoncodeablereference')),
                ('requester', models.ManyToManyField(blank=True, related_name='contract_term_action_requester', to='contracts.contracttermactionrequesterreference')),
                ('status', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_status', to='base.codeableconcept')),
                ('subject', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_subject', to='contracts.contracttermactionsubject')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_action_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractTerm',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('issued', models.DateTimeField(null=True)),
                ('text', models.TextField(null=True)),
                ('action', models.ManyToManyField(blank=True, related_name='contract_term_action', to='contracts.contracttermaction')),
                ('applies', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_applies', to='base.period')),
                ('asset', models.ManyToManyField(blank=True, related_name='contract_term_asset', to='contracts.contracttermasset')),
                ('group', models.ManyToManyField(blank=True, to='contracts.contractterm')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_identifier', to='base.identifier')),
                ('offer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_offer', to='contracts.contracttermoffer')),
                ('security_label', models.ManyToManyField(blank=True, related_name='contract_term_security_label', to='contracts.contracttermsecuritylabel')),
                ('sub_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_sub_type', to='base.codeableconcept')),
                ('topic_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_topic_codeable_concept', to='base.codeableconcept')),
                ('topic_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_topic_reference', to='base.reference')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_term_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractSignerPartyReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_signer_party_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_signer_party_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_signer_party_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_signer_party_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_signer_party_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_signer_party_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractSigner',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('party', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_signer_party', to='contracts.contractsignerpartyreference')),
                ('signature', models.ManyToManyField(blank=True, related_name='contract_signer_signature', to='base.signature')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_signer_type', to='base.coding')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractRule',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('content_attachment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_rule_content_attachment', to='base.attachment')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('contract', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_reference_contract', to='contracts.contract')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractLegallyBindingReferenceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('contract', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_legally_binding_reference_reference_contract', to='contracts.contract')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_legally_binding_reference_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractLegalContentReferenceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_legal_content_reference_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractLegal',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('content_attachment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_legal_content_attachment', to='base.attachment')),
                ('content_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_legal_content_reference', to='contracts.contractlegalcontentreferencereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractFriendlyContentReferenceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_friendly_content_reference_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractFriendly',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('content_attachment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_friendly_content_attachment', to='base.attachment')),
                ('content_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_friendly_content_reference', to='contracts.contractfriendlycontentreferencereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractContentDefinitionPublisherReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_content_definition_publisher_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_content_definition_publisher_reference_organization', to='organizations.organization')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_content_definition_publisher_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_content_definition_publisher_reference_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractContentDefinition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('publication_date', models.DateTimeField(null=True)),
                ('publication_status', models.CharField(choices=[('amended', 'Amended'), ('appended', 'Appended'), ('cancelled', 'Cancelled'), ('disputed', 'Disputed'), ('entered-in-error', 'Entered in Error'), ('executed', 'Executed'), ('executable', 'Executable'), ('negotiable', 'Negotiable'), ('offered', 'Offered'), ('rejected', 'Rejected'), ('renewed', 'Renewed'), ('revoked', 'Revoked'), ('resolved', 'Resolved'), ('terminated', 'Terminated')], max_length=255, null=True)),
                ('copyright', models.TextField(null=True)),
                ('publisher', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_content_definition_publisher', to='contracts.contractcontentdefinitionpublisherreference')),
                ('sub_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_content_definition_sub_type', to='base.codeableconcept')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_content_definition_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContractAuthorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_author_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_author_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_author_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_author_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_author_reference_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='contract',
            name='author',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_author', to='contracts.contractauthorreference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='authority',
            field=models.ManyToManyField(blank=True, related_name='contract_authority', to='base.organizationreference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='content_definition',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_content_definition', to='contracts.contractcontentdefinition'),
        ),
        migrations.AddField(
            model_name='contract',
            name='content_derivative',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_content_derivative', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='contract',
            name='domain',
            field=models.ManyToManyField(blank=True, related_name='contract_domain', to='locations.locationreference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='expiration_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_expiration_type', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='contract',
            name='friendly',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_friendly', to='contracts.contractfriendly'),
        ),
        migrations.AddField(
            model_name='contract',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='contract_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='contract',
            name='instantiates_canonical',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_instantiates_canonical', to='contracts.contractreference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='legal',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_legal', to='contracts.contractlegal'),
        ),
        migrations.AddField(
            model_name='contract',
            name='legal_state',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_legal_state', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='contract',
            name='legally_binding_attachment',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_legally_binding_attachment', to='base.attachment'),
        ),
        migrations.AddField(
            model_name='contract',
            name='legally_binding_reference',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_legally_binding_reference', to='contracts.contractlegallybindingreferencereference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='relevant_history',
            field=models.ManyToManyField(blank=True, related_name='contract_relevant_history', to='provenances.provenancereference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='rule',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_rule', to='contracts.contractrule'),
        ),
        migrations.AddField(
            model_name='contract',
            name='scope',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_scope', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='contract',
            name='signer',
            field=models.ManyToManyField(blank=True, related_name='contract_signer', to='contracts.contractsigner'),
        ),
        migrations.AddField(
            model_name='contract',
            name='site',
            field=models.ManyToManyField(blank=True, related_name='contract_site', to='locations.locationreference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='sub_type',
            field=models.ManyToManyField(blank=True, related_name='contract_sub_type', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='contract',
            name='subject',
            field=models.ManyToManyField(blank=True, related_name='contract_subject', to='base.reference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='supporting_info',
            field=models.ManyToManyField(blank=True, related_name='contract_supporting_info', to='base.reference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='term',
            field=models.ManyToManyField(blank=True, related_name='contract_term', to='contracts.contractterm'),
        ),
        migrations.AddField(
            model_name='contract',
            name='topic_codeable_concept',
            field=models.ManyToManyField(blank=True, related_name='contract_topic_codeable_concept', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='contract',
            name='topic_reference',
            field=models.ManyToManyField(blank=True, related_name='contract_topic_reference', to='base.reference'),
        ),
        migrations.AddField(
            model_name='contract',
            name='type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='contract_type', to='base.codeableconcept'),
        ),
    ]
