# Generated by Django 4.2.14 on 2025-02-12 11:40

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('encounters', '0008_alter_encounterlocation_location'),
        ('observations', '0006_alter_observation_instantiates_reference_and_more'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('conditions', '0002_alter_conditioncodeablereference_concept_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='ClinicalImpression',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('preparation', 'Preparation'), ('in-progress', 'In Progress'), ('not-done', 'Not Done'), ('on-hold', 'On Hold'), ('stopped', 'Stopped'), ('completed', 'Completed'), ('entered-in-error', 'Entered in Error'), ('unknown', 'Unknown')], max_length=255, null=True)),
                ('description', models.TextField(null=True)),
                ('effective_date_time', models.DateTimeField(null=True)),
                ('date', models.DateTimeField(null=True)),
                ('protocol', django.contrib.postgres.fields.ArrayField(base_field=models.URLField(), null=True, size=None)),
                ('summary', models.TextField(null=True)),
                ('change_pattern', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_change_pattern', to='base.codeableconcept')),
                ('effective_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_effective_period', to='base.period')),
                ('encounter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_encounter', to='encounters.encounterreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClinicalImpressionReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('clinical_impression', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_reference_clinical_impression', to='clinicalimpressions.clinicalimpression')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClinicalImpressionFindingItemReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('condition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_finding_item_reference_condition', to='conditions.condition')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_finding_item_reference_identifier', to='base.identifier')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_finding_item_reference_observation', to='observations.observation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClinicalImpressionFindingItemCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_finding_item_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_finding_item_codeable_reference_reference', to='clinicalimpressions.clinicalimpressionfindingitemreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClinicalImpressionFinding',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('basis', models.TextField(null=True)),
                ('item', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_finding_item', to='clinicalimpressions.clinicalimpressionfindingitemcodeablereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='clinicalimpression',
            name='finding',
            field=models.ManyToManyField(blank=True, related_name='clinical_impression_finding', to='clinicalimpressions.clinicalimpressionfinding'),
        ),
        migrations.AddField(
            model_name='clinicalimpression',
            name='identifier',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='clinicalimpression',
            name='note',
            field=models.ManyToManyField(blank=True, related_name='clinical_impression_note', to='base.annotation'),
        ),
        migrations.AddField(
            model_name='clinicalimpression',
            name='performer',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_performer', to='practitioners.practitionerpractitionerrolereference'),
        ),
        migrations.AddField(
            model_name='clinicalimpression',
            name='previous',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='clinical_impression_previous', to='clinicalimpressions.clinicalimpressionreference'),
        ),
    ]
