# Generated by Django 4.2.14 on 2025-02-26 12:29

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('visionprescriptions', '0001_initial'),
        ('bodystructures', '0006_bodystructurecodeablereference'),
        ('locations', '0006_merge_20250129_1542'),
        ('devices', '0007_alter_device_status_and_more'),
        ('organizations', '0003_organization_endpoint'),
        ('servicerequests', '0005_servicerequestplandefinitionreference_and_more'),
        ('nutritionorders', '0005_rename_instantiated_nutritionorder_instantiates_and_more'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('patients', '0007_patientorganizationreference'),
        ('encounters', '0009_encounterepisodeofcarereference'),
        ('procedures', '0008_merge_20250218_1723'),
        ('base', '0015_delete_monetarycomponent'),
        ('medicationrequests', '0006_alter_medicationrequest_event_history_and_more'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
    ]

    operations = [
        migrations.CreateModel(
            name='Claim',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_created=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('active', 'Active'), ('cancelled', 'Cancelled'), ('draft', 'Draft'), ('entered-in-error', 'Entered in Error')], default='draft', max_length=255)),
                ('use', models.CharField(choices=[('claim', 'Claim'), ('preauthorization', 'Preauthorization'), ('predetermination', 'Predetermination')], default='claim', max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('claim', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_reference_claim', to='claims.claim')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimSupportingInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField(null=True)),
                ('timing_date', models.DateField(null=True)),
                ('value_boolean', models.BooleanField(null=True)),
                ('value_string', models.CharField(max_length=255, null=True)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_supporting_info_category', to='base.codeableconcept')),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_supporting_info_code', to='base.codeableconcept')),
                ('reason', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_supporting_info_reason', to='base.codeableconcept')),
                ('timing_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_supporting_info_timing_period', to='base.period')),
                ('value_attachment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_supporting_info_value_attachment', to='base.attachment')),
                ('value_identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_supporting_info_value_identifier', to='base.identifier')),
                ('value_quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_supporting_info_value_quantity', to='base.quantity')),
                ('value_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_supporting_info_value_reference', to='base.reference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimRelated',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('claim', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_related_claim', to='claims.claimreference')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_related_reference', to='base.identifier')),
                ('relationship', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_related_relationship', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimProviderReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_provider_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_provider_reference_organization', to='organizations.organization')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_provider_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_provider_reference_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimProcedure',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField(null=True)),
                ('date', models.DateField(null=True)),
                ('procedure_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_procedure_procedure_codeable_concept', to='base.codeableconcept')),
                ('procedure_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_procedure_procedure_reference', to='procedures.procedurereference')),
                ('type', models.ManyToManyField(blank=True, related_name='claim_procedure_type', to='base.codeableconcept')),
                ('udi', models.ManyToManyField(blank=True, related_name='claim_procedure_udi', to='devices.devicereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimPrescriptionReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_prescription_reference_identifier', to='base.identifier')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_prescription_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('vision_prescription', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_prescription_reference_vision_prescription', to='visionprescriptions.visionprescription')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimPayeePartyReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_payee_party_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_payee_party_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_payee_party_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_payee_party_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_payee_party_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_payee_party_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimPayee',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('party', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_payee_party', to='claims.claimpayeepartyreference')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_payee_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimOriginalPrescriptionReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_original_prescription_reference_identifier', to='base.identifier')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_original_prescription_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('vision_prescription', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_original_prescription_reference_vision_prescription', to='visionprescriptions.visionprescription')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimItemRequestReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_request_reference_identifier', to='base.identifier')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_request_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('nutrition_order', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_request_reference_nutrition_order', to='nutritionorders.nutritionorder')),
                ('service_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_request_reference_service_request', to='servicerequests.servicerequest')),
                ('vision_prescription', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_request_reference_vision_prescription', to='visionprescriptions.visionprescription')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimItemDetailSubDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField(null=True)),
                ('factor', models.FloatField(null=True)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_sub_detail_category', to='base.codeableconcept')),
                ('modifier', models.ManyToManyField(blank=True, related_name='claim_item_detail_sub_detail_modifier', to='base.codeableconcept')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_sub_detail_net', to='base.money')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_sub_detail_patient_paid', to='base.money')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_sub_detail_product_or_service', to='base.codeableconcept')),
                ('product_or_service_end', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_sub_detail_product_or_service_end', to='base.codeableconcept')),
                ('program_code', models.ManyToManyField(blank=True, related_name='claim_item_detail_sub_detail_program_code', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_sub_detail_quantity', to='base.simplequantity')),
                ('revenue', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_sub_detail_revenue', to='base.codeableconcept')),
                ('tax', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_sub_detail_tax', to='base.money')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='claim_item_detail_sub_detail_trace_number', to='base.identifier')),
                ('udi', models.ManyToManyField(blank=True, related_name='claim_item_detail_sub_detail_udi', to='devices.devicereference')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_sub_detail_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimItemDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField(null=True)),
                ('factor', models.FloatField(null=True)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_category', to='base.codeableconcept')),
                ('modifier', models.ManyToManyField(blank=True, related_name='claim_item_detail_modifier', to='base.codeableconcept')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_net', to='base.money')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_patient_paid', to='base.money')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_product_or_service', to='base.codeableconcept')),
                ('program_code', models.ManyToManyField(blank=True, related_name='claim_item_detail_program_code', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_quantity', to='base.simplequantity')),
                ('revenue', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_revenue', to='base.codeableconcept')),
                ('sub_detail', models.ManyToManyField(blank=True, related_name='claim_item_detail_sub_detail', to='claims.claimitemdetailsubdetail')),
                ('tax', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_tax', to='base.money')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='claim_item_detail_trace_number', to='base.identifier')),
                ('udi', models.ManyToManyField(blank=True, related_name='claim_item_detail_udi', to='devices.devicereference')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_detail_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimItemBodySIte',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('site', models.ManyToManyField(blank=True, related_name='claim_item_body_site', to='bodystructures.bodystructurecodeablereference')),
                ('sub_site', models.ManyToManyField(blank=True, related_name='claim_item_sub_site', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField(null=True)),
                ('care_team_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('diagnosis_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('procedure_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('information_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('serviced_date', models.DateField(null=True)),
                ('factor', models.FloatField(null=True)),
                ('body_site', models.ManyToManyField(blank=True, related_name='claim_item_body_site', to='claims.claimitembodysite')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_category', to='base.codeableconcept')),
                ('detail', models.ManyToManyField(blank=True, related_name='claim_item_detail', to='claims.claimitemdetail')),
                ('encounter', models.ManyToManyField(blank=True, related_name='claim_item_encounter', to='encounters.encounterreference')),
                ('location_address', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_location_address', to='base.address')),
                ('location_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_location_codeable_concept', to='base.codeableconcept')),
                ('location_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_location_reference', to='locations.locationreference')),
                ('modifier', models.ManyToManyField(blank=True, related_name='claim_item_modifier', to='base.codeableconcept')),
                ('net', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_net', to='base.money')),
                ('patient_paid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_patient_paid', to='base.money')),
                ('product_or_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_product_or_service', to='base.codeableconcept')),
                ('product_or_service_end', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_product_or_service_end', to='base.codeableconcept')),
                ('program_code', models.ManyToManyField(blank=True, related_name='claim_item_program_code', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_quantity', to='base.simplequantity')),
                ('request', models.ManyToManyField(blank=True, related_name='claim_item_request', to='claims.claimitemrequestreference')),
                ('revenue', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_revenue', to='base.codeableconcept')),
                ('serviced_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_serviced_period', to='base.period')),
                ('tax', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_tax', to='base.money')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='claim_item_trace_number', to='base.identifier')),
                ('udi', models.ManyToManyField(blank=True, related_name='claim_item_udi', to='devices.devicereference')),
                ('unit_price', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_item_unit_price', to='base.money')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimInsurance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField(null=True)),
                ('focal', models.BooleanField(default=False)),
                ('business_arrangement', models.CharField(max_length=255, null=True)),
                ('pre_auth_ref', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_insurance_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('when_date_time', models.DateTimeField(null=True)),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_event_type', to='base.codeableconcept')),
                ('when_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_event_when_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimEntererReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_enterer_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_enterer_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_enterer_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_enterer_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_enterer_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimDiagnosis',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField(null=True)),
                ('diagnosis_codeable_concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_diagnosis_diagnosis_codeable_concept', to='base.codeableconcept')),
                ('diagnosis_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_diagnosis_diagnosis_reference', to='base.reference')),
                ('on_admission', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_diagnosis_on_admission', to='base.codeableconcept')),
                ('type', models.ManyToManyField(blank=True, related_name='claim_diagnosis_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimCareTeamProviderReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_care_team_provider_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_care_team_provider_reference_organization', to='organizations.organization')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_care_team_provider_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_care_team_provider_reference_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimCareTeam',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField(null=True)),
                ('responsible', models.BooleanField(default=False)),
                ('provider', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_care_team_provider', to='claims.claimcareteamproviderreference')),
                ('role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_care_team_role', to='base.codeableconcept')),
                ('specialty', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_care_team_specialty', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimAccident',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('date', models.DateField(null=True)),
                ('location_address', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_accident_location_address', to='base.address')),
                ('location_reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_accident_location_reference', to='locations.locationreference')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_accident_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='claim',
            name='accident',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_accident', to='claims.claimaccident'),
        ),
        migrations.AddField(
            model_name='claim',
            name='billable_period',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_billable_period', to='base.period'),
        ),
        migrations.AddField(
            model_name='claim',
            name='care_team',
            field=models.ManyToManyField(blank=True, related_name='claim_care_team', to='claims.claimcareteam'),
        ),
        migrations.AddField(
            model_name='claim',
            name='diagnosis',
            field=models.ManyToManyField(blank=True, related_name='claim_diagnosis', to='claims.claimdiagnosis'),
        ),
        migrations.AddField(
            model_name='claim',
            name='diagnosis_related_group',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_diagnosis_related_group', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='claim',
            name='encounter',
            field=models.ManyToManyField(blank=True, related_name='claim_encounter', to='encounters.encounterreference'),
        ),
        migrations.AddField(
            model_name='claim',
            name='enterer',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_enterer', to='claims.claimentererreference'),
        ),
        migrations.AddField(
            model_name='claim',
            name='event',
            field=models.ManyToManyField(blank=True, related_name='claim_event', to='claims.claimevent'),
        ),
        migrations.AddField(
            model_name='claim',
            name='facility',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_facility', to='locations.locationorganizationreference'),
        ),
        migrations.AddField(
            model_name='claim',
            name='funds_reserve',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_funds_reserve', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='claim',
            name='identifier',
            field=models.ManyToManyField(blank=True, related_name='claim_identifier', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='claim',
            name='insurance',
            field=models.ManyToManyField(blank=True, related_name='claim_insurance', to='claims.claiminsurance'),
        ),
        migrations.AddField(
            model_name='claim',
            name='insurer',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_insurer', to='base.organizationreference'),
        ),
        migrations.AddField(
            model_name='claim',
            name='item',
            field=models.ManyToManyField(blank=True, related_name='claim_item', to='claims.claimitem'),
        ),
        migrations.AddField(
            model_name='claim',
            name='original_prescription',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_original_prescription', to='claims.claimoriginalprescriptionreference'),
        ),
        migrations.AddField(
            model_name='claim',
            name='patient',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_patient', to='patients.patientreference'),
        ),
        migrations.AddField(
            model_name='claim',
            name='patient_paid',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_patient_paid', to='base.money'),
        ),
        migrations.AddField(
            model_name='claim',
            name='payee',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_payee', to='claims.claimpayee'),
        ),
        migrations.AddField(
            model_name='claim',
            name='prescription',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_prescription', to='claims.claimprescriptionreference'),
        ),
        migrations.AddField(
            model_name='claim',
            name='priority',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_priority', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='claim',
            name='procedure',
            field=models.ManyToManyField(blank=True, related_name='claim_procedure', to='claims.claimprocedure'),
        ),
        migrations.AddField(
            model_name='claim',
            name='provider',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_provider', to='claims.claimproviderreference'),
        ),
        migrations.AddField(
            model_name='claim',
            name='referral',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_referral', to='servicerequests.servicerequestreference'),
        ),
        migrations.AddField(
            model_name='claim',
            name='related',
            field=models.ManyToManyField(blank=True, related_name='claim_related', to='claims.claimrelated'),
        ),
        migrations.AddField(
            model_name='claim',
            name='sub_type',
            field=models.ManyToManyField(blank=True, related_name='claim_sub_type', to='base.codeableconcept'),
        ),
        migrations.AddField(
            model_name='claim',
            name='supporting_info',
            field=models.ManyToManyField(blank=True, related_name='claim_supporting_info', to='claims.claimsupportinginfo'),
        ),
        migrations.AddField(
            model_name='claim',
            name='total',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_total', to='base.money'),
        ),
        migrations.AddField(
            model_name='claim',
            name='trace_number',
            field=models.ManyToManyField(blank=True, related_name='claim_trace_number', to='base.identifier'),
        ),
        migrations.AddField(
            model_name='claim',
            name='type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_type', to='base.codeableconcept'),
        ),
    ]
