# Generated by Django 4.2.14 on 2025-03-10 11:10

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('practitioners', '0011_practitionerrolereference'),
        ('base', '0018_merge_20250307_1944'),
    ]

    operations = [
        migrations.CreateModel(
            name='ClaimResponse',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('active', 'Active'), ('cancelled', 'Cancelled'), ('draft', 'Draft'), ('entered-in-error', 'Entered in Error')], default='active', max_length=255)),
                ('use', models.CharField(choices=[('claim', 'Claim'), ('preauthorization', 'Preauthorization'), ('predetermination', 'Predetermination')], default='claim', max_length=255)),
                ('created', models.DateTimeField(null=True)),
                ('outcome', models.CharField(choices=[('queued', 'Queued'), ('complete', 'Complete'), ('error', 'Error'), ('partial', 'Partial')], max_length=255, null=True)),
                ('disposition', models.TextField(null=True)),
                ('pre_auth_ref', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseAddItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('item_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('detail_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('sub_detail_sequence', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('serviced_date', models.DateField(null=True)),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseAddItemBodySite',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseAddItemDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseAddItemDetailSubDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('factor', models.DecimalField(decimal_places=2, max_digits=10, null=True)),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseAddItemProviderReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseAddItemRequestReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseError',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('item_sequence', models.IntegerField(null=True)),
                ('detail_sequence', models.IntegerField(null=True)),
                ('sub_detail_sequence', models.IntegerField(null=True)),
                ('expression', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('when_date_time', models.DateTimeField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseItemAdjudication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('amount', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_item_adjudication_amount', to='base.money')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_item_adjudication_category', to='base.codeableconcept')),
                ('quantity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_item_adjudication_quantity', to='base.quantity')),
                ('reason', models.ManyToManyField(blank=True, related_name='claim_response_item_adjudication_reason', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseTotal',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('amount', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_total_amount', to='base.money')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_total_category', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseRequestorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_requestor_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_requestor_organization', to='base.organizationreference')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_requestor_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_requestor_practitioner_role', to='practitioners.practitionerrole')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('claim_response', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_reference_claim_response', to='claimresponses.claimresponse')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseProcessNote',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('number', models.IntegerField(null=True)),
                ('text', models.TextField(null=True)),
                ('language', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_process_note_language', to='base.codeableconcept')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_process_note_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponsePayment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('date', models.DateField(null=True)),
                ('adjustment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_payment_adjustment', to='base.money')),
                ('adjustment_reason', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_payment_adjustment_reason', to='base.codeableconcept')),
                ('amount', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_payment_amount', to='base.money')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_payment_identifier', to='base.identifier')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_payment_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseItemReviewOutcome',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('pre_auth_ref', models.CharField(max_length=255, null=True)),
                ('decision', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_item_review_outcome_decision', to='base.codeableconcept')),
                ('pre_auth_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_item_review_outcome_pre_auth_period', to='base.period')),
                ('reason', models.ManyToManyField(blank=True, related_name='claim_response_item_review_outcome_reason', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseItemDetailSubDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sub_detail_sequence', models.IntegerField()),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('adjudication', models.ManyToManyField(blank=True, related_name='claim_response_item_detail_sub_detail_adjudication', to='claimresponses.claimresponseitemadjudication')),
                ('review_outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_item_detail_sub_detail_review_outcome', to='claimresponses.claimresponseitemreviewoutcome')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='claim_response_item_detail_sub_detail_trace_number', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseItemDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('detail_sequence', models.IntegerField()),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('adjudication', models.ManyToManyField(blank=True, related_name='claim_response_item_detail_adjudication', to='claimresponses.claimresponseitemadjudication')),
                ('review_outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_item_detail_review_outcome', to='claimresponses.claimresponseitemreviewoutcome')),
                ('sub_detail', models.ManyToManyField(blank=True, related_name='claim_response_item_detail_sub_detail', to='claimresponses.claimresponseitemdetailsubdetail')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='claim_response_item_detail_trace_number', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('item_sequence', models.IntegerField()),
                ('note_number', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('adjudication', models.ManyToManyField(blank=True, related_name='claim_response_item_adjudication', to='base.codeableconcept')),
                ('detail', models.ManyToManyField(blank=True, related_name='claim_response_item_detail', to='claimresponses.claimresponseitemdetail')),
                ('review_outcome', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_item_review_outcome', to='claimresponses.claimresponseitemreviewoutcome')),
                ('trace_number', models.ManyToManyField(blank=True, related_name='claim_response_item_trace_number', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ClaimResponseInsurance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField()),
                ('focal', models.BooleanField()),
                ('business_arrangement', models.CharField(max_length=255, null=True)),
                ('claim_response', models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, related_name='claim_response_insurance_claim_response', to='claimresponses.claimresponsereference')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
