# Generated by Django 4.2.14 on 2025-02-27 11:54

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("medicationrequests", "0006_alter_medicationrequest_event_history_and_more"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("observations", "0008_alter_observationcodeablereference_concept_and_more"),
        ("procedures", "0008_merge_20250218_1723"),
        ("devices", "0007_alter_device_status_and_more"),
        ("organizations", "0003_organization_endpoint"),
        (
            "bodystructures",
            "0005_remove_bodystructure_imaging_bodystructure_image_and_more",
        ),
        ("conditions", "0006_merge_20250217_1423"),
        ("healthcareservices", "0006_remove_healthcareservice_endpoint"),
        ("servicerequests", "0005_servicerequestplandefinitionreference_and_more"),
        ("substances", "0002_substancecodeablereference"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        ("careteams", "0004_remove_careteamparticipant_role_and_more"),
        ("patients", "0007_patientorganizationreference"),
        ("base", "0013_money"),
        (
            "medicationadministrations",
            "0004_medicationadministration_based_on_and_more",
        ),
        ("accounts", "0007_account_billing_status_account_currency"),
        ("practitioners", "0010_practitionerrole_endpoint"),
        ("diagnosticreports", "0005_diagnosticreportdocumentreferencereference"),
        (
            "medicationdispenses",
            "0003_rename_medicatoindispensereceiverreference_medicationdispensereceiverreference_and_more",
        ),
        ("encounters", "0009_encounterepisodeofcarereference"),
    ]

    operations = [
        migrations.CreateModel(
            name="ChargeItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "definition_uri",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.URLField(null=True), null=True, size=None
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("planned", "Planned"),
                            ("billable", "Billable"),
                            ("not-billable", "Not Billable"),
                            ("aborted", "Aborted"),
                            ("billed", "Billed"),
                            ("entered-in-error", "Entered in Error"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("occurrence_date_time", models.DateTimeField(null=True)),
                ("entered_date", models.DateTimeField(null=True)),
                (
                    "account",
                    models.ManyToManyField(
                        blank=True,
                        related_name="charge_item_account",
                        to="accounts.accountreference",
                    ),
                ),
                (
                    "body_site",
                    models.ManyToManyField(
                        blank=True,
                        related_name="charge_item_body_site",
                        to="bodystructures.bodystructurereference",
                    ),
                ),
                (
                    "code",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_code",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "cost_center",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_cost_center",
                        to="base.organizationreference",
                    ),
                ),
                (
                    "encounter",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_encounter",
                        to="encounters.encounterreference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CharItemReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "charge_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_reference_charge_item",
                        to="chargeitems.chargeitem",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_reference_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ChargeItemServiceReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "diagnostic_report",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_service_reference_diagnostic_report",
                        to="diagnosticreports.diagnosticreport",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_service_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication_administration",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_service_reference_medication_administration",
                        to="medicationadministrations.medicationadministration",
                    ),
                ),
                (
                    "medication_dispense",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_service_reference_medication_dispense",
                        to="medicationdispenses.medicationdispense",
                    ),
                ),
                (
                    "medication_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_service_reference_medication_request",
                        to="medicationrequests.medicationrequest",
                    ),
                ),
                (
                    "observation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_service_reference_observation",
                        to="observations.observation",
                    ),
                ),
                (
                    "procedure",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_service_reference_procedure",
                        to="procedures.procedure",
                    ),
                ),
                (
                    "service_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_service_reference_service_request",
                        to="servicerequests.servicerequest",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ChargeItemReasonReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "condition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_reason_reference_condition",
                        to="conditions.condition",
                    ),
                ),
                (
                    "diagnostic_report",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_reason_reference_diagnostic_report",
                        to="diagnosticreports.diagnosticreport",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_reason_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "observation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_reason_reference_observation",
                        to="observations.observation",
                    ),
                ),
                (
                    "procedure",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_reason_reference_procedure",
                        to="procedures.procedure",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ChargeItemProductReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_product_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_product_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_product_reference_medication",
                        to="medications.medication",
                    ),
                ),
                (
                    "substance",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_product_reference_substance",
                        to="substances.substance",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ChargeItemPerformerActorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor_reference_care_team",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor_reference_device",
                        to="devices.device",
                    ),
                ),
                (
                    "healthcare_service",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor_reference_healthcare_service",
                        to="healthcareservices.healthcareservice",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor_reference_organization",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor_reference_patient",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor_reference_practitioner",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor_reference_practitioner_role",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor_reference_related_person",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ChargeItemPerformer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "actor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_actor",
                        to="chargeitems.chargeitemperformeractorreference",
                    ),
                ),
                (
                    "function",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_performer_function",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ChargeItemEntererReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "condition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_enterer_reference_condition",
                        to="conditions.condition",
                    ),
                ),
                (
                    "diagnostic_report",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_enterer_reference_diagnostic_report",
                        to="diagnosticreports.diagnosticreport",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_enterer_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "observation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_enterer_reference_observation",
                        to="observations.observation",
                    ),
                ),
                (
                    "procedure",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="charge_item_enterer_reference_procedure",
                        to="procedures.procedure",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="enterer",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="charge_item_enterer",
                to="chargeitems.chargeitementererreference",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="identifier",
            field=models.ManyToManyField(
                blank=True, related_name="charge_item_identifier", to="base.identifier"
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="note",
            field=models.ManyToManyField(
                blank=True, related_name="charge_item_note", to="base.annotation"
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="occurrence_period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="charge_item_occurrence_period",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="occurrence_timing",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="charge_item_occurrence_timing",
                to="base.timing",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="override_reason",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="charge_item_override_reason",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="part_of",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="charge_item_reference_part_of",
                to="chargeitems.charitemreference",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="performer",
            field=models.ManyToManyField(
                blank=True,
                related_name="charge_item_performer",
                to="chargeitems.chargeitemperformer",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="performing_organization",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="charge_item_performing_organization",
                to="base.organizationreference",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="product",
            field=models.ManyToManyField(
                blank=True,
                related_name="charge_item_product",
                to="chargeitems.chargeitemproductreference",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="quantity",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="charge_item_quantity",
                to="base.quantity",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="reason",
            field=models.ManyToManyField(
                blank=True,
                related_name="charge_item_reason",
                to="chargeitems.chargeitemreasonreference",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="requesting_organization",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="charge_item_requesting_organization",
                to="base.organizationreference",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="service",
            field=models.ManyToManyField(
                blank=True,
                related_name="charge_item_service",
                to="chargeitems.chargeitemservicereference",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="charge_item_subject",
                to="patients.patientgroupreference",
            ),
        ),
        migrations.AddField(
            model_name="chargeitem",
            name="supporting_information",
            field=models.ManyToManyField(
                blank=True,
                related_name="charge_item_supporting_information",
                to="base.reference",
            ),
        ),
    ]
