# Generated by Django 4.2.14 on 2025-01-22 15:47

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("organizations", "0001_initial"),
        ("base", "0005_codeablereference"),
        ("encounters", "0008_alter_encounterlocation_location"),
        ("patients", "0006_patientgroupreference_group_and_more"),
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("careteams", "0004_remove_careteamparticipant_role_and_more"),
        ("medicationrequests", "0006_alter_medicationrequest_event_history_and_more"),
        ("conditions", "0002_alter_conditioncodeablereference_concept_and_more"),
        ("practitioners", "0008_practitionerpractitionerrolereference"),
        ("appointments", "0008_appointment_based_on_appointment_reason_and_more"),
        ("servicerequests", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="CarePlan",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("title", models.CharField(max_length=255)),
                ("description", models.TextField()),
                ("created", models.DateTimeField(null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CustodianContributorReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="devices.device",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="custodian_contributor_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CarePlanReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_plan",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_reference_care_plan",
                        to="careplans.careplan",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_reference_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CarePlanPlannedActivityReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "appointment",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_planned_activity_reference_appointment",
                        to="appointments.appointment",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="base.identifier",
                    ),
                ),
                (
                    "medication_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_planned_activity_reference_medication_request",
                        to="medicationrequests.medicationrequest",
                    ),
                ),
                (
                    "service_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_planned_activity_reference_service_request",
                        to="servicerequests.servicerequest",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CarePlanBasedOnReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_plan",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_based_on_care_plan",
                        to="careplans.careplan",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_based_on_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "service_request",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_based_on_service_request",
                        to="servicerequests.servicerequest",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CarePlanAddressReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "condition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="conditions.condition",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_address_reference_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CarePlanActivity",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "performer_activity",
                    models.ManyToManyField(
                        blank=True,
                        related_name="care_plan_activity_performer_activity",
                        to="base.codeablereference",
                    ),
                ),
                (
                    "planned_activity_reference",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="care_plan_activity_planned_activity_reference",
                        to="careplans.careplanplannedactivityreference",
                    ),
                ),
                (
                    "progress",
                    models.ManyToManyField(
                        blank=True,
                        related_name="care_plan_activity_progress",
                        to="base.annotation",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="careplan",
            name="activity",
            field=models.ManyToManyField(
                blank=True,
                related_name="care_plan_activity",
                to="careplans.careplanactivity",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="addresses",
            field=models.ManyToManyField(
                blank=True,
                related_name="care_plan_addresses",
                to="careplans.careplanaddressreference",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="based_on",
            field=models.ManyToManyField(
                blank=True,
                related_name="care_plan_based_on",
                to="careplans.careplanbasedonreference",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="category",
            field=models.ManyToManyField(
                blank=True, related_name="care_plan_category", to="base.codeableconcept"
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="contributor",
            field=models.ManyToManyField(
                blank=True,
                related_name="care_plan_contributor",
                to="careplans.custodiancontributorreference",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="custodian",
            field=models.ManyToManyField(
                blank=True,
                related_name="care_plan_author",
                to="careplans.custodiancontributorreference",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="encounter",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="care_plan_encounter",
                to="encounters.encounterreference",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="goal",
            field=models.ManyToManyField(
                blank=True, related_name="care_plan_goal", to="base.reference"
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="identifier",
            field=models.ManyToManyField(
                blank=True, related_name="care_plan_identifier", to="base.identifier"
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="intent",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="care_plan_intent",
                to="base.coding",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="part_of",
            field=models.ManyToManyField(
                blank=True,
                related_name="care_plan_part_of",
                to="careplans.careplanreference",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="care_plan_period",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="replaces",
            field=models.ManyToManyField(
                blank=True,
                related_name="care_plan_replaces",
                to="careplans.careplanreference",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="status",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="care_plan_status",
                to="base.coding",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="care_plan_subject",
                to="patients.patientgroupreference",
            ),
        ),
        migrations.AddField(
            model_name="careplan",
            name="supporting_info",
            field=models.ManyToManyField(
                blank=True,
                related_name="care_plan_supporting_info",
                to="base.reference",
            ),
        ),
    ]
