# Generated by Django 4.2.14 on 2025-03-18 17:22

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("patients", "0007_patientorganizationreference"),
        ("servicerequests", "0005_servicerequestplandefinitionreference_and_more"),
        ("base", "0018_merge_20250307_1944"),
        ("locations", "0006_merge_20250129_1542"),
        ("practitioners", "0011_practitionerrolereference"),
    ]

    operations = [
        migrations.CreateModel(
            name="BiologicallyDerivedProductDispense",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("preparation", "Preparation"),
                            ("in-person", "In Person"),
                            ("allocated", "Allocated"),
                            ("issued", "Issued"),
                            ("unfulfilled", "Unfulfilled"),
                            ("returned", "Returned"),
                            ("entered-in-error", "Entered in Error"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("prepared_date", models.DateTimeField(null=True)),
                ("when_handed_over", models.DateTimeField(null=True)),
                ("usage_instruction", models.CharField(max_length=255, null=True)),
                (
                    "based_on",
                    models.ManyToManyField(
                        blank=True,
                        related_name="biologicallyderivedproductdispense_based_on",
                        to="servicerequests.servicerequestreference",
                    ),
                ),
                (
                    "destination",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="biologicallyderivedproductdispense_destination",
                        to="locations.locationreference",
                    ),
                ),
                (
                    "identifier",
                    models.ManyToManyField(
                        blank=True,
                        related_name="biologicallyderivedproductdispense_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="biologicallyderivedproductdispense_location",
                        to="locations.locationreference",
                    ),
                ),
                (
                    "match_status",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="biologicallyderivedproductdispense_match_status",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "note",
                    models.ManyToManyField(
                        blank=True,
                        related_name="biologicallyderivedproductdispense_note",
                        to="base.annotation",
                    ),
                ),
                (
                    "original_relationship_type",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="biologicallyderivedproductdispense_original_relationship_type",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="BiologicallyDerivedProductDispenseReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "biologically_derived_product_dispense",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="biologicallyderivedproductdispense_reference_biologicallyderivedproductdispense",
                        to="biologicallyderivedproductdispenses.biologicallyderivedproductdispense",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="biologicallyderivedproductdispense_reference_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="BiologicallyDerivedProductDispensePerformer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "actor",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="biologicallyderivedproductdispense_performer_actor",
                        to="practitioners.practitionerreference",
                    ),
                ),
                (
                    "function",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="biologicallyderivedproductdispense_performer_function",
                        to="base.codeableconcept",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="biologicallyderivedproductdispense",
            name="part_of",
            field=models.ManyToManyField(
                blank=True,
                related_name="biologicallyderivedproductdispense_part_of",
                to="biologicallyderivedproductdispenses.biologicallyderivedproductdispensereference",
            ),
        ),
        migrations.AddField(
            model_name="biologicallyderivedproductdispense",
            name="patient",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="biologicallyderivedproductdispense_patient",
                to="patients.patientreference",
            ),
        ),
        migrations.AddField(
            model_name="biologicallyderivedproductdispense",
            name="performer",
            field=models.ManyToManyField(
                blank=True,
                related_name="biologicallyderivedproductdispense_performer",
                to="biologicallyderivedproductdispenses.biologicallyderivedproductdispenseperformer",
            ),
        ),
        migrations.AddField(
            model_name="biologicallyderivedproductdispense",
            name="product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="biologicallyderivedproductdispense_product",
                to="biologicallyderivedproductdispenses.biologicallyderivedproductdispensereference",
            ),
        ),
        migrations.AddField(
            model_name="biologicallyderivedproductdispense",
            name="quantity",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="biologicallyderivedproductdispense_quantity",
                to="base.quantity",
            ),
        ),
    ]
