# Generated by Django 4.2.14 on 2025-01-06 22:48

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('use', models.CharField(choices=[('home', 'home'), ('work', 'work'), ('temp', 'temp'), ('old', 'old'), ('billing', 'billing')], max_length=10, null=True)),
                ('type', models.CharField(choices=[('postal', 'postal'), ('physical', 'physical'), ('both', 'both')], max_length=10, null=True)),
                ('text', models.CharField(blank=True, max_length=255, null=True)),
                ('line', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(blank=True, max_length=255, null=True), null=True, size=None)),
                ('city', models.CharField(blank=True, max_length=255, null=True)),
                ('district', models.CharField(blank=True, max_length=255, null=True)),
                ('state', models.CharField(blank=True, max_length=255, null=True)),
                ('postal_code', models.CharField(blank=True, max_length=255, null=True)),
                ('country', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Annotation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('author_string', models.CharField(max_length=255, null=True)),
                ('time', models.DateTimeField(null=True)),
                ('text', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Attachment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('content_type', models.CharField(blank=True, max_length=255, null=True)),
                ('language', models.CharField(blank=True, max_length=255, null=True)),
                ('data', models.TextField(blank=True, null=True)),
                ('url', models.URLField(blank=True, null=True)),
                ('size', models.BigIntegerField(blank=True, null=True)),
                ('hash', models.BinaryField(blank=True, null=True)),
                ('creation', models.DateTimeField(blank=True, null=True)),
                ('height', models.PositiveIntegerField(blank=True, null=True)),
                ('width', models.PositiveIntegerField(blank=True, null=True)),
                ('frames', models.PositiveIntegerField(blank=True, null=True)),
                ('duration', models.DecimalField(blank=True, decimal_places=2, max_digits=1000, null=True)),
                ('pages', models.PositiveIntegerField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Availability',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AvailableTime',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('days_of_week', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(choices=[('mon', 'Monday'), ('tue', 'Tuesday'), ('wed', 'Wednesday'), ('thu', 'Thursday'), ('fri', 'Friday'), ('sat', 'Saturday'), ('sun', 'Sunday')], max_length=255), null=True, size=None)),
                ('all_day', models.BooleanField(default=False)),
                ('available_start_time', models.TimeField(null=True)),
                ('available_end_time', models.TimeField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CodeableConcept',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('text', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Coding',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('system', models.CharField(max_length=255, null=True)),
                ('version', models.CharField(max_length=255, null=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('user_selected', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ConnectionType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.CharField(max_length=255, null=True)),
                ('system', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('definition', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ContactPoint',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('system', models.CharField(blank=True, choices=[('phone', 'phone'), ('fax', 'fax'), ('email', 'email'), ('sms', 'sms'), ('url', 'url'), ('other', 'other')], help_text='Telecommunications form for contact point.', max_length=10, null=True)),
                ('value', models.CharField(blank=True, max_length=255, null=True)),
                ('use', models.CharField(blank=True, choices=[('home', 'home'), ('work', 'work'), ('temp', 'temp'), ('old', 'old'), ('mobile', 'mobile')], max_length=10, null=True)),
                ('rank', models.PositiveIntegerField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Endpoint',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('active', 'active'), ('limited', 'limited'), ('suspended', 'suspended'), ('error', 'error'), ('off', 'off'), ('entered-in-error', 'entered-in-error')], max_length=255, null=True)),
                ('name', models.CharField(max_length=255, null=True)),
                ('environmental_type', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(choices=[('development', 'development'), ('test', 'test'), ('production', 'production'), ('staging', 'staging'), ('training', 'training')], max_length=255), null=True, size=None)),
                ('address', models.CharField(max_length=255, null=True)),
                ('header', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('public_key', models.TextField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EndpointReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ExtendedContactDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('system', models.CharField(blank=True, choices=[('phone', 'phone'), ('fax', 'fax'), ('email', 'email'), ('sms', 'sms'), ('url', 'url'), ('other', 'other')], help_text='Telecommunications form for contact point.', max_length=10, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HumanName',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('use', models.CharField(choices=[('usual', 'usual'), ('official', 'official'), ('temp', 'temp'), ('nickname', 'nickname'), ('anonymous', 'anonymous'), ('old', 'old'), ('maiden', 'maiden')], max_length=255, null=True)),
                ('text', models.TextField(null=True)),
                ('family', models.CharField(max_length=255, null=True)),
                ('given', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('prefix', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
                ('suffix', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), null=True, size=None)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Identifier',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('use', models.CharField(max_length=255, null=True)),
                ('system', models.CharField(max_length=255, null=True)),
                ('value', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='NotAvailableTime',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OrganizationReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='organization_reference_identifier', to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Period',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('start', models.DateTimeField(null=True)),
                ('end', models.DateTimeField(null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Quantity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value', models.DecimalField(decimal_places=2, max_digits=1000, null=True)),
                ('comparator', models.CharField(choices=[('eq', 'Equal'), ('ne', 'Not Equal'), ('gt', 'Greater Than'), ('lt', 'Less Than'), ('ge', 'Greater or Equal'), ('le', 'Less or Equal')], max_length=255, null=True)),
                ('unit', models.CharField(max_length=255, null=True)),
                ('system', models.CharField(max_length=255, null=True)),
                ('code', models.CharField(max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VirtualServiceDetailAddress',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('address_url', models.URLField(max_length=255, null=True)),
                ('address_string', models.TextField(null=True)),
                ('address_contact_point', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='virtual_service_detail_address_contact_point', to='base.contactpoint')),
                ('address_extended_contact_detail', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='virtual_service_detail_address_extended_contact_detail', to='base.extendedcontactdetail')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VirtualServiceDetails',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('additional_info', django.contrib.postgres.fields.ArrayField(base_field=models.URLField(max_length=255), null=True, size=None)),
                ('max_participants', models.PositiveIntegerField(null=True)),
                ('session_key', models.CharField(max_length=255, null=True)),
                ('address', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='virtual_service_details_address', to='base.virtualservicedetailaddress')),
                ('channel_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='virtual_service_details_channel_type', to='base.coding')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Reference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='base.identifier')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Range',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('high', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='range_high', to='base.quantity')),
                ('low', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='range_low', to='base.quantity')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Qualification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='qualification_code', to='base.codeableconcept')),
                ('identifier', models.ManyToManyField(blank=True, related_name='qualification_identifier', to='base.identifier')),
                ('issuer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='qualification_issuer', to='base.organizationreference')),
                ('period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='qualification_period', to='base.period')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Payload',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('profile_uri', django.contrib.postgres.fields.ArrayField(base_field=models.URLField(max_length=255), null=True, size=None)),
                ('profile_canonical', django.contrib.postgres.fields.ArrayField(base_field=models.URLField(max_length=255), null=True, size=None)),
                ('type', models.ManyToManyField(blank=True, related_name='payload_type', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
