# Generated by Django 4.2.14 on 2025-02-06 12:56

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('encounters', '0008_alter_encounterlocation_location'),
        ('base', '0010_expression_relativetime'),
        ('organizations', '0003_organization_endpoint'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('patients', '0007_patientorganizationreference'),
    ]

    operations = [
        migrations.CreateModel(
            name='AllergyIntoleranceRecorderReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_recorder_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_recorder_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_recorder_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_recorder_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_recorder_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_recorder_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AllergyIntoleranceReaction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('description', models.TextField(null=True)),
                ('onset', models.DateTimeField(null=True)),
                ('severity', models.CharField(choices=[('mild', 'Mild'), ('moderate', 'Moderate'), ('severe', 'Severe')], max_length=255, null=True)),
                ('exposure_route', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_reaction_exposure_route', to='base.codeableconcept')),
                ('note', models.ManyToManyField(blank=True, related_name='allergy_intolerance_reaction_note', to='base.annotation')),
                ('substance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_reaction_substance', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AllergyIntoleranceAsserterReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_asserter_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_asserter_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_asserter_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_asserter_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_asserter_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AllergyIntolerance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('category', models.CharField(choices=[('food', 'Food'), ('medication', 'Medication'), ('environment', 'Environment'), ('biologic', 'Biologic')], max_length=255, null=True)),
                ('criticality', models.CharField(choices=[('low', 'Low'), ('high', 'High'), ('unable-to-assess', 'Unable to Assess')], max_length=255, null=True)),
                ('onset_date_time', models.DateTimeField(null=True)),
                ('onset_string', models.CharField(max_length=255, null=True)),
                ('recorded_date', models.DateTimeField(null=True)),
                ('last_reaction_occurrence', models.DateTimeField(null=True)),
                ('asserter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_asserter', to='allergyintolerances.allergyintoleranceasserterreference')),
                ('clinical_status', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_clinical_status', to='base.codeableconcept')),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_code', to='base.codeableconcept')),
                ('encounter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_encounter', to='encounters.encounterreference')),
                ('identifier', models.ManyToManyField(blank=True, related_name='allergy_intolerance_identifier', to='base.identifier')),
                ('note', models.ManyToManyField(blank=True, related_name='allergy_intolerance_note', to='base.annotation')),
                ('onset_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_onset_period', to='base.period')),
                ('onset_range', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_onset_range', to='base.range')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_patient', to='patients.patientreference')),
                ('reaction', models.ManyToManyField(blank=True, related_name='allergy_intolerance_reaction', to='allergyintolerances.allergyintolerancereaction')),
                ('recorder', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_recorder', to='allergyintolerances.allergyintolerancerecorderreference')),
                ('type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_type', to='base.codeableconcept')),
                ('verification_status', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='allergy_intolerance_verification_status', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
