# Generated by Django 4.2.14 on 2025-02-10 13:34

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('conditions', '0006_merge_20250217_1423'),
        ('relatedpersons', '0002_relatedperson_communication_relatedperson_gender'),
        ('allergyintolerances', '0003_allergyintolerance_onset_age'),
        ('devices', '0007_alter_device_status_and_more'),
        ('familymemberhistories', '0002_alter_familymemberhistoryparticipantactorreference_organization'),
        ('encounters', '0008_alter_encounterlocation_location'),
        ('observations', '0006_alter_observation_instantiates_reference_and_more'),
        ('groups', '0004_group_code_group_combination_method_and_more'),
        ('medications', '0004_medicationreference_medicationcodeablereference'),
        ('procedures', '0001_initial'),
        ('base', '0012_alter_repeat_duration_unit_alter_repeat_period_unit'),
        ('patients', '0007_patientorganizationreference'),
        ('substances', '0002_substancecodeablereference'),
        ('careteams', '0004_remove_careteamparticipant_role_and_more'),
        ('medicationadministrations', '0004_medicationadministration_based_on_and_more'),
        ('practitioners', '0010_practitionerrole_endpoint'),
        ('locations', '0006_merge_20250129_1542'),
        ('biologicallyderivedproducts', '0001_initial'),
        ('medicationrequests', '0006_alter_medicationrequest_event_history_and_more'),
        ('organizations', '0003_organization_endpoint'),
    ]

    operations = [
        migrations.CreateModel(
            name='AdverseEventSuspectEntityAuthorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_author_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_author_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_author_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_author_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_author_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventSuspectEntityInstanceReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('biollogically_derived_product', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_instance_reference_biologically_derived_product', to='biologicallyderivedproducts.biologicallyderivedproduct')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_instance_reference_device', to='devices.device')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_instance_reference_identifier', to='base.identifier')),
                ('medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_instance_reference_medication', to='medications.medication')),
                ('medication_administration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_instance_reference_medication_administration', to='medicationadministrations.medicationadministration')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_instance_reference_procedure', to='procedures.procedure')),
                ('substance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_instance_reference_substance', to='substances.substance')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventSuspectEntityInstanceCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_instance_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_instance_codeable_reference_reference', to='adverseevents.adverseeventsuspectentityinstancereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventSuspectEntityCausality',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('assessment_method', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_causality_assessment', to='base.codeableconcept')),
                ('author', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_causality_author', to='adverseevents.adverseeventsuspectentityauthorreference')),
                ('entity_relatedness', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_suspect_entity_causality_entity_relatedness', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventSuspectEntity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('causality', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_suspect_entity_causality', to='adverseevents.adverseeventsuspectentitycausality')),
                ('instance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_suspect_entity_instance', to='adverseevents.adverseeventsuspectentityinstancecodeablereference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventSupportingInfoReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('allergy_intolerance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_supporting_info_reference_allergy_intolerance', to='allergyintolerances.allergyintolerance')),
                ('condition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_supporting_info_reference_condition', to='conditions.condition')),
                ('family_member_history', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_supporting_info_reference_family_member_history', to='familymemberhistories.familymemberhistory')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_supporting_info_reference_identifier', to='base.identifier')),
                ('medication_administration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_supporting_info_reference_medication_administration', to='medicationadministrations.medicationadministration')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_supporting_info_reference_observation', to='observations.observation')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_supporting_info_reference_procedure', to='procedures.procedure')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventSupportingInfoCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_supporting_info_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_supporting_info_codeable_reference_reference', to='adverseevents.adverseeventsupportinginforeference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventSubjectReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_subject_reference_group', to='groups.group')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_subject_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_subject_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_subject_reference_practitioner', to='practitioners.practitioner')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_subject_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventRecorderReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_recorder_reference_identifier', to='base.identifier')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_recorder_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_recorder_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_recorder_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_recorder_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventPreventiveActionReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_preventive_action_reference_identifier', to='base.identifier')),
                ('medication_administration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_preventive_action_reference_medication_administration', to='medicationadministrations.medicationadministration')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_preventive_action_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_preventive_action_reference_procedure', to='procedures.procedure')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventPreventiveActionCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_preventive_action_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_preventive_action_codeable_reference_reference', to='adverseevents.adverseeventpreventiveactionreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventParticipantActorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('care_team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_participant_actor_reference_care_team', to='careteams.careteam')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_participant_actor_reference_device', to='devices.device')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_participant_actor_reference_identifier', to='base.identifier')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_participant_actor_reference_organization', to='organizations.organization')),
                ('patient', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_participant_actor_reference_patient', to='patients.patient')),
                ('practitioner', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_participant_actor_reference_practitioner', to='practitioners.practitioner')),
                ('practitioner_role', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_participant_actor_reference_practitioner_role', to='practitioners.practitionerrole')),
                ('related_person', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_participant_actor_reference_related_person', to='relatedpersons.relatedperson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventParticipant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('actor', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_participant_actor', to='adverseevents.adverseeventparticipantactorreference')),
                ('function', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_participant_function', to='base.codeableconcept')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventMitigatingActionReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_mitigating_action_reference_identifier', to='base.identifier')),
                ('medication_administration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_mitigating_action_reference_medication_administration', to='medicationadministrations.medicationadministration')),
                ('medication_request', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_mitigating_action_reference_medication_request', to='medicationrequests.medicationrequest')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_mitigating_action_reference_procedure', to='procedures.procedure')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventMitigatingActionCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_mitigating_action_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_mitigating_action_codeable_reference_reference', to='adverseevents.adverseeventmitigatingactionreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventContributingFactorReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reference', models.CharField(max_length=255, null=True)),
                ('type', models.CharField(max_length=255, null=True)),
                ('display', models.CharField(max_length=255, null=True)),
                ('allergy_intolerance', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_reference_allergy_intolerance', to='allergyintolerances.allergyintolerance')),
                ('condition', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_reference_condition', to='conditions.condition')),
                ('device', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_reference_device', to='devices.device')),
                ('family_member_history', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_reference_family_member_history', to='familymemberhistories.familymemberhistory')),
                ('identifier', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_reference_identifier', to='base.identifier')),
                ('medication_administration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_reference_medication_administration', to='medicationadministrations.medicationadministration')),
                ('observation', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_reference_observation', to='observations.observation')),
                ('procedure', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_reference_procedure', to='procedures.procedure')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEventContributingFactorCodeableReference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('concept', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_codeable_reference_concept', to='base.codeableconcept')),
                ('reference', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='adverse_event_contributing_factor_codeable_reference_reference', to='adverseevents.adverseeventcontributingfactorreference')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AdverseEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(choices=[('in-progress', 'in-progress'), ('completed', 'completed'), ('entered-in-error', 'entered-in-error'), ('unknown', 'unknown')], max_length=255)),
                ('actuality', models.CharField(choices=[('actual', 'actual'), ('potential', 'potential')], max_length=255)),
                ('cause_date_time', models.DateTimeField(null=True)),
                ('effect_date_time', models.DateTimeField(null=True)),
                ('detected', models.DateTimeField(null=True)),
                ('recorded_date', models.DateTimeField(null=True)),
                ('expected_in_research_study', models.BooleanField(default=False)),
                ('category', models.ManyToManyField(blank=True, related_name='adverse_event_category', to='base.codeableconcept')),
                ('cause_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_cause_period', to='base.period')),
                ('code', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_code', to='base.codeableconcept')),
                ('contributing_factor', models.ManyToManyField(blank=True, related_name='adverse_event_contributing_factor', to='adverseevents.adverseeventcontributingfactorcodeablereference')),
                ('effect_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_effect_period', to='base.period')),
                ('encounter', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_encounter', to='encounters.encounterreference')),
                ('identifier', models.ManyToManyField(blank=True, related_name='adverse_event_identifier', to='base.identifier')),
                ('location', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_location', to='locations.locationreference')),
                ('mitigating_action', models.ManyToManyField(blank=True, related_name='adverse_event_mitigating_action', to='adverseevents.adverseeventmitigatingactioncodeablereference')),
                ('note', models.ManyToManyField(blank=True, related_name='adverse_event_note', to='base.annotation')),
                ('outcome', models.ManyToManyField(blank=True, related_name='adverse_event_outcome', to='base.codeableconcept')),
                ('participant', models.ManyToManyField(blank=True, related_name='adverse_event_participant', to='adverseevents.adverseeventparticipant')),
                ('preventive_action', models.ManyToManyField(blank=True, related_name='adverse_event_preventive_action', to='adverseevents.adverseeventpreventiveactioncodeablereference')),
                ('recorder', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='adverse_event_recorder', to='adverseevents.adverseeventrecorderreference')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
