# Generated by Django 4.2.14 on 2025-03-17 16:23

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("relatedpersons", "0002_relatedperson_communication_relatedperson_gender"),
        ("healthcareservices", "0006_remove_healthcareservice_endpoint"),
        ("careteams", "0004_remove_careteamparticipant_role_and_more"),
        ("organizations", "0004_organizationcodeablereference"),
        ("medications", "0004_medicationreference_medicationcodeablereference"),
        ("patients", "0007_patientorganizationreference"),
        ("endpoints", "0006_alter_endpoint_connection_type"),
        ("devices", "0007_alter_device_status_and_more"),
        ("devicedefinitions", "0002_devicedefinitiondeviceversion_and_more"),
        ("practitioners", "0011_practitionerrolereference"),
        ("substances", "0002_substancecodeablereference"),
        ("base", "0018_merge_20250307_1944"),
        ("locations", "0006_merge_20250129_1542"),
        ("groups", "0004_group_code_group_combination_method_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="ActivityDefinition",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("url", models.URLField(null=True)),
                ("version", models.CharField(max_length=255, null=True)),
                (
                    "version_algorithm_string",
                    models.CharField(max_length=255, null=True),
                ),
                ("name", models.CharField(max_length=255, null=True)),
                ("title", models.CharField(max_length=255, null=True)),
                ("subtitle", models.CharField(max_length=255, null=True)),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("draft", "Draft"),
                            ("active", "Active"),
                            ("retired", "Retired"),
                            ("unknown", "Unknown"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("experimental", models.BooleanField(null=True)),
                ("date", models.DateField(null=True)),
                ("publisher", models.CharField(max_length=255, null=True)),
                ("description", models.TextField(null=True)),
                ("purpose", models.TextField(null=True)),
                ("usage", models.TextField(null=True)),
                ("copyright", models.TextField(null=True)),
                ("copyright_label", models.TextField(null=True)),
                ("approval_date", models.DateField(null=True)),
                ("last_review_date", models.DateField(null=True)),
                (
                    "kind",
                    models.CharField(
                        choices=[
                            ("appointment", "Appointment"),
                            ("care-plan", "Care Plan"),
                            ("claim", "Claim"),
                            ("communication-request", "Communication Request"),
                            (
                                "coverage-eligibility-request",
                                "Coverage Eligibility Request",
                            ),
                            ("device-request", "Device Request"),
                            ("enrollment-request", "Enrollment Request"),
                            (
                                "immunization-recommendation",
                                "Immunization Recommendation",
                            ),
                            ("medication-request", "Medication Request"),
                            ("nutrition-order", "Nutrition Order"),
                            ("request-orchestration", "Request Orchestration"),
                            ("service-request", "Service Request"),
                            ("supply-request", "Supply Request"),
                            ("task", "Task"),
                            ("transport", "Transport"),
                            ("vision-prescription", "Vision Prescription"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "intent",
                    models.CharField(
                        choices=[
                            ("proposal", "Proposal"),
                            ("plan", "Plan"),
                            ("directive", "Directive"),
                            ("order", "Order"),
                            ("original-order", "Original Order"),
                            ("reflex-order", "Reflex Order"),
                            ("filter-order", "Filter Order"),
                            ("instance-order", "Instance Order"),
                            ("option", "Option"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "priority",
                    models.CharField(
                        choices=[
                            ("routine", "Routine"),
                            ("urgency", "Urgency"),
                            ("asap", "ASAP"),
                            ("stat", "STAT"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                ("do_not_perform", models.BooleanField(null=True)),
                ("as_needed_boolean", models.BooleanField(null=True)),
                (
                    "as_needed_codeable_concept",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_as_needed_codeable_concept",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "author",
                    models.ManyToManyField(
                        blank=True,
                        related_name="activity_definition_author",
                        to="base.contactdetail",
                    ),
                ),
                (
                    "body_site",
                    models.ManyToManyField(
                        blank=True,
                        related_name="activity_definition_body_site",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "code",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_code",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "contact",
                    models.ManyToManyField(
                        blank=True,
                        related_name="activity_definition_contact",
                        to="base.contactdetail",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ActivityDefinitionSubjectReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_subject_reference_group",
                        to="groups.group",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_subject_reference_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ActivityDefinitionReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "activity_definition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_reference",
                        to="activitydefinitions.activitydefinition",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_reference_identifier",
                        to="base.identifier",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ActivityDefinitionProductReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_product_reference_identifier",
                        to="base.identifier",
                    ),
                ),
                (
                    "medication",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_product_reference_medication",
                        to="medications.medication",
                    ),
                ),
                (
                    "substance",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_product_reference_substance",
                        to="substances.substance",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ActivityDefinitionParticipantTypeReference",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("reference", models.CharField(max_length=255, null=True)),
                ("type", models.CharField(max_length=255, null=True)),
                ("display", models.CharField(max_length=255, null=True)),
                (
                    "care_team",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_practitioner_type_reference_identifier",
                        to="careteams.careteam",
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_device_reference_identifier",
                        to="devices.device",
                    ),
                ),
                (
                    "device_definition",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_device_definition_reference_identifier",
                        to="devicedefinitions.devicedefinition",
                    ),
                ),
                (
                    "endpoint",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_endpoint_reference_identifier",
                        to="endpoints.endpoint",
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_group_reference_identifier",
                        to="groups.group",
                    ),
                ),
                (
                    "healthcare_service",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_healthcare_service_reference_identifier",
                        to="healthcareservices.healthcareservice",
                    ),
                ),
                (
                    "identifier",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_participant_type_reference",
                        to="base.identifier",
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_location_reference_identifier",
                        to="locations.location",
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_organization_reference_identifier",
                        to="organizations.organization",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_patient_reference_identifier",
                        to="patients.patient",
                    ),
                ),
                (
                    "practitioner",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_practitioner_reference_identifier",
                        to="practitioners.practitioner",
                    ),
                ),
                (
                    "practitioner_role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_practitioner_role_reference_identifier",
                        to="practitioners.practitionerrole",
                    ),
                ),
                (
                    "related_person",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_related_person_reference_identifier",
                        to="relatedpersons.relatedperson",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ActivityDefinitionParticipant",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("careteam", "Care Team"),
                            ("device", "Device"),
                            ("group", "Group"),
                            ("healthcareservice", "Healthcare Service"),
                            ("location", "Location"),
                            ("organization", "Organization"),
                            ("patient", "Patient"),
                            ("practitioner", "Practitioner"),
                            ("practitionerrole", "Practitioner Role"),
                            ("relatedperson", "Related Person"),
                        ],
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_participant_location",
                        to="locations.locationreference",
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_participant_role",
                        to="base.codeableconcept",
                    ),
                ),
                (
                    "type_reference",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_participant_type_reference",
                        to="activitydefinitions.activitydefinitionparticipanttypereference",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ActivityDefinitionDynamicValue",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("path", models.CharField(max_length=255, null=True)),
                (
                    "expression",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="activity_definition_dynamic_value_expression",
                        to="base.expression",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="dynamic_value",
            field=models.ManyToManyField(
                blank=True,
                related_name="activity_definition_note",
                to="activitydefinitions.activitydefinitiondynamicvalue",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="editor",
            field=models.ManyToManyField(
                blank=True,
                related_name="activity_definition_editor",
                to="base.contactdetail",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="effective_period",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_period",
                to="base.period",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="endorser",
            field=models.ManyToManyField(
                blank=True,
                related_name="activity_definition_endorser",
                to="base.contactdetail",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="identifier",
            field=models.ManyToManyField(
                blank=True,
                related_name="activity_definition_identifier",
                to="base.identifier",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="jurisdiction",
            field=models.ManyToManyField(
                blank=True,
                related_name="activity_definition_jurisdiction",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_location",
                to="locations.locationreference",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="participant",
            field=models.ManyToManyField(
                blank=True,
                related_name="activity_definition_participant",
                to="activitydefinitions.activitydefinitionparticipant",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="product_codeable_concept",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_product_codeable_concept",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="product_reference",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_product_reference",
                to="activitydefinitions.activitydefinitionproductreference",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="quantity",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_quantity",
                to="base.simplequantity",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="reviewer",
            field=models.ManyToManyField(
                blank=True,
                related_name="activity_definition_reviewer",
                to="base.contactdetail",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="subject_codealbe_concept",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_subject_codeable_concept",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="subject_reference",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_subject_reference",
                to="activitydefinitions.activitydefinitionsubjectreference",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="timing_age",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_timing_age",
                to="base.age",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="timing_duration",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_timing_duration",
                to="base.duration",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="timing_range",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_timing_range",
                to="base.range",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="timing_timing",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_timing_timing",
                to="base.timing",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="topic",
            field=models.ManyToManyField(
                blank=True,
                related_name="activity_definition_topic",
                to="base.codeableconcept",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="use_context",
            field=models.ManyToManyField(
                blank=True,
                related_name="activity_definition_use_context",
                to="base.usagecontext",
            ),
        ),
        migrations.AddField(
            model_name="activitydefinition",
            name="version_algorithm_coding",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="activity_definition_version_algorithm_coding",
                to="base.coding",
            ),
        ),
    ]
