"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VSCodeFargate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const acm = require("@aws-cdk/aws-certificatemanager");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const patterns = require("@aws-cdk/aws-ecs-patterns");
const efs = require("@aws-cdk/aws-efs");
const logs = require("@aws-cdk/aws-logs");
const route53 = require("@aws-cdk/aws-route53");
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class VSCodeFargate extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const stack = cdk.Stack.of(this);
        const hostedZone = route53.HostedZone.fromLookup(this, 'HostedZone', {
            domainName: props.domainName,
        });
        const certificate = new acm.Certificate(this, 'Certificate', {
            domainName: `${props.subdomain}.${props.domainName}`,
            validation: acm.CertificateValidation.fromDns(hostedZone),
        });
        const vpc = (_b = props.vpc) !== null && _b !== void 0 ? _b : new ec2.Vpc(this, 'Vpc', {
            natGateways: 1,
        });
        const cluster = new ecs.Cluster(this, 'Cluster', {
            vpc,
        });
        const fileSystem = new efs.FileSystem(this, 'EfsFileSystem', {
            vpc,
            lifecyclePolicy: efs.LifecyclePolicy.AFTER_30_DAYS,
            performanceMode: efs.PerformanceMode.GENERAL_PURPOSE,
        });
        const volume = {
            name: 'myHomeVolume',
            efsVolumeConfiguration: {
                fileSystemId: fileSystem.fileSystemId,
            },
        };
        const secret = new secretsmanager.Secret(this, 'Secret');
        const loadBalancedFargateService = new patterns.ApplicationLoadBalancedFargateService(this, 'Service', {
            assignPublicIp: true,
            certificate,
            cluster,
            cpu: 1024,
            domainName: `${props.subdomain}.${props.domainName}`,
            domainZone: hostedZone,
            memoryLimitMiB: 2048,
            platformVersion: ecs.FargatePlatformVersion.VERSION1_4,
            publicLoadBalancer: true,
            redirectHTTP: true,
            taskImageOptions: {
                containerPort: 8443,
                secrets: {
                    PASSWORD: ecs.Secret.fromSecretsManager(secret),
                },
                image: ecs.ContainerImage.fromRegistry('ghcr.io/linuxserver/code-server'),
                logDriver: new ecs.AwsLogDriver({
                    streamPrefix: 'app',
                    logGroup: new logs.LogGroup(this, 'LogGroup', {
                        logGroupName: `/app/${stack.stackName}/${id}`,
                        retention: logs.RetentionDays.TWO_MONTHS,
                    }),
                }),
            },
        });
        loadBalancedFargateService.taskDefinition.addVolume(volume);
        loadBalancedFargateService.service.connections.allowFrom(fileSystem, ec2.Port.tcp(2049));
        loadBalancedFargateService.service.connections.allowTo(fileSystem, ec2.Port.tcp(2049));
        const mountPoint = {
            readOnly: true,
            containerPath: '/efs',
            sourceVolume: volume.name,
        };
        (_c = loadBalancedFargateService.taskDefinition.defaultContainer) === null || _c === void 0 ? void 0 : _c.addMountPoints(mountPoint);
        loadBalancedFargateService.targetGroup.configureHealthCheck({
            path: '/login',
        });
        this.endpoint = loadBalancedFargateService.loadBalancer.loadBalancerDnsName;
    }
}
exports.VSCodeFargate = VSCodeFargate;
_a = JSII_RTTI_SYMBOL_1;
VSCodeFargate[_a] = { fqn: "cdk-vscode-fargate.VSCodeFargate", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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