// Copyright (c) Mito
import React from 'react';
import { classNames } from '../../utils/classNames';
import { getToolbarItemIcon } from './utils';
/**
 * The ToolbarButton component is used to create each
 * button in the Toolbar.
 */
const ToolbarButton = (props) => {
    const highlightToobarItemClass = props.highlightToolbarButton === true ? 'toolbar-button-draw-attention' : '';
    return (React.createElement("div", { className: 'toolbar-button-container', id: props.id, onClick: props.action.actionFunction },
        React.createElement("button", { className: classNames('toolbar-button', 'vertical-align-content', highlightToobarItemClass), type: "button" },
            React.createElement("span", { title: props.action.tooltip },
                React.createElement("div", { className: 'toolbar-button-icon-container' }, getToolbarItemIcon(props.toolbarButtonType)),
                React.createElement("p", { className: 'toolbar-button-label' }, props.action.shortTitle))),
        props.children !== undefined && props.children));
};
export default ToolbarButton;
//# sourceMappingURL=ToolbarButton.js.map