// Copyright (c) Mito
import React from 'react';
// Import css
import "../../../css/FormulaBar.css";
import "../../../css/mito.css";
import { getFullFormula } from './celleditor/cellEditorUtils';
import { getCellDataFromCellIndexes } from './utils';
import Col from '../spacing/Col';
import Row from '../spacing/Row';
import { calculateCurrentSheetView } from './sheetViewUtils';
import CellEditor from './celleditor/CellEditor';
import { getDisplayColumnHeader } from '../../utils/columnHeaders';
const FormulaBar = (props) => {
    var _a, _b;
    const rowIndex = props.selection.startingRowIndex;
    const colIndex = props.selection.startingColumnIndex;
    const { columnHeader, columnFormula, cellValue } = getCellDataFromCellIndexes(props.sheetData, rowIndex, colIndex);
    const originalFormulaBarValue = '' + (columnFormula !== undefined && columnFormula !== '' ? columnFormula : (cellValue !== undefined ? cellValue : ''));
    const cellEditingCellData = props.editorState === undefined ? undefined : getCellDataFromCellIndexes(props.sheetData, props.editorState.rowIndex, props.editorState.columnIndex);
    const formulaBarColumnHeader = props.editorState === undefined ? columnHeader : cellEditingCellData === null || cellEditingCellData === void 0 ? void 0 : cellEditingCellData.columnHeader;
    let formulaBarValue = '';
    if (props.editorState === undefined) {
        // If the formula bar is a cell, display the cell value. If it is a column header, display the column header
        if (rowIndex == -1 && columnHeader !== undefined) {
            formulaBarValue = getDisplayColumnHeader(columnHeader);
        }
        else {
            formulaBarValue = originalFormulaBarValue;
        }
    }
    else {
        // If we're editing, display the formula
        formulaBarValue = getFullFormula(props.editorState.formula, formulaBarColumnHeader || '', props.editorState.pendingSelectedColumns);
    }
    const currentSheetView = calculateCurrentSheetView(props.gridState);
    return (React.createElement(Row, { align: 'center', 
        // Add a border to the top and bottom of the formula bar
        style: {
            borderTop: '1px solid var(--mito-border)',
            borderBottom: '1px solid var(--mito-border)',
            background: 'white'
        }, suppressTopBottomMargin: true },
        React.createElement(Col, { offset: .5 },
            React.createElement("p", { className: "formula-bar-column-header text-header-3 text-overflow-hide" }, formulaBarColumnHeader)),
        React.createElement(Col, null,
            React.createElement("div", { className: "formula-bar-vertical-line" })),
        React.createElement(Col, { flex: '1' },
            ((_a = props.editorState) === null || _a === void 0 ? void 0 : _a.editorLocation) === 'formula bar' &&
                React.createElement(CellEditor, { sheetData: props.sheetData, sheetIndex: props.sheetIndex, gridState: props.gridState, editorState: props.editorState, setEditorState: props.setEditorState, setGridState: props.setGridState, setUIState: props.setUIState, scrollAndRenderedContainerRef: props.scrollAndRenderedContainerRef, containerRef: props.containerRef, mitoAPI: props.mitoAPI, currentSheetView: currentSheetView, closeOpenEditingPopups: props.closeOpenEditingPopups }),
            ((_b = props.editorState) === null || _b === void 0 ? void 0 : _b.editorLocation) !== 'formula bar' &&
                React.createElement("div", { className: "formula-bar-formula text-header-3 text-overflow-hide element-width-block", onDoubleClick: () => {
                        console.log('setting the row index to: ', rowIndex);
                        props.setEditorState({
                            rowIndex: rowIndex,
                            columnIndex: colIndex,
                            formula: formulaBarValue,
                            arrowKeysScrollInFormula: true,
                            editorLocation: 'formula bar'
                        });
                    } }, formulaBarValue))));
};
export default FormulaBar;
//# sourceMappingURL=FormulaBar.js.map