import React from 'react';
import TextButton from '../elements/TextButton';
import { TaskpaneType } from '../taskpanes/taskpanes';
/**
 *
 * A wrapper around divs to displayed centered in the grid
 *
 * @param props - the children you want to display in the center of the grid
 */
const GridDataEmptyContainer = (props) => {
    return (React.createElement("div", { className: 'endo-grid-empty-container' },
        React.createElement("div", { className: 'endo-grid-empty-text-container' }, props.children)));
};
const EmptyGridMessages = (props) => {
    return (React.createElement(React.Fragment, null,
        props.sheetData === undefined &&
            React.createElement(GridDataEmptyContainer, null,
                React.createElement("div", null,
                    React.createElement(TextButton, { variant: 'dark', width: 'medium', onClick: () => {
                            props.setUIState(prevUIState => {
                                return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.IMPORT } });
                            });
                            void props.mitoAPI.log('clicked_empty_grid_import_button');
                        } }, "Import Files")),
                React.createElement("p", { className: 'mt-5px text-body-1' },
                    "Or pass dataframes directly into the ",
                    React.createElement("code", null, "mitosheet.sheet()"),
                    " call above.")),
        props.sheetData !== undefined && props.sheetData.numRows === 0 && props.sheetData.numColumns === 0 &&
            React.createElement(GridDataEmptyContainer, null,
                React.createElement("p", { className: 'text-body-1' }, "No data in dataframe.")),
        props.sheetData !== undefined && props.sheetData.numRows > 0 && props.sheetData.numColumns === 0 &&
            React.createElement(GridDataEmptyContainer, null,
                React.createElement("p", { className: 'text-body-1' }, "No columns in dataframe.")),
        props.sheetData !== undefined && props.sheetData.numRows === 0 && props.sheetData.numColumns > 0 &&
            React.createElement(GridDataEmptyContainer, null,
                React.createElement("p", { className: 'text-body-1' }, "No rows in dataframe."))));
};
export default EmptyGridMessages;
//# sourceMappingURL=EmptyGridMessages.js.map