"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecurityConfiguration = exports.JobBookmarksEncryptionMode = exports.CloudWatchEncryptionMode = exports.S3EncryptionMode = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const kms = require("@aws-cdk/aws-kms");
const cdk = require("@aws-cdk/core");
const glue_generated_1 = require("./glue.generated");
/**
 * (experimental) Encryption mode for S3.
 *
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_S3Encryption.html#Glue-Type-S3Encryption-S3EncryptionMode
 * @experimental
 */
var S3EncryptionMode;
(function (S3EncryptionMode) {
    S3EncryptionMode["S3_MANAGED"] = "SSE-S3";
    S3EncryptionMode["KMS"] = "SSE-KMS";
})(S3EncryptionMode = exports.S3EncryptionMode || (exports.S3EncryptionMode = {}));
/**
 * Encryption mode for CloudWatch Logs.
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_CloudWatchEncryption.html#Glue-Type-CloudWatchEncryption-CloudWatchEncryptionMode
 */
var CloudWatchEncryptionMode;
(function (CloudWatchEncryptionMode) {
    CloudWatchEncryptionMode["KMS"] = "SSE-KMS";
})(CloudWatchEncryptionMode = exports.CloudWatchEncryptionMode || (exports.CloudWatchEncryptionMode = {}));
/**
 * Encryption mode for Job Bookmarks.
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_JobBookmarksEncryption.html#Glue-Type-JobBookmarksEncryption-JobBookmarksEncryptionMode
 */
var JobBookmarksEncryptionMode;
(function (JobBookmarksEncryptionMode) {
    JobBookmarksEncryptionMode["CLIENT_SIDE_KMS"] = "CSE-KMS";
})(JobBookmarksEncryptionMode = exports.JobBookmarksEncryptionMode || (exports.JobBookmarksEncryptionMode = {}));
/**
 * (experimental) A security configuration is a set of security properties that can be used by AWS Glue to encrypt data at rest.
 *
 * The following scenarios show some of the ways that you can use a security configuration.
 * - Attach a security configuration to an AWS Glue crawler to write encrypted Amazon CloudWatch Logs.
 * - Attach a security configuration to an extract, transform, and load (ETL) job to write encrypted Amazon Simple Storage Service (Amazon S3) targets and encrypted CloudWatch Logs.
 * - Attach a security configuration to an ETL job to write its jobs bookmarks as encrypted Amazon S3 data.
 * - Attach a security configuration to a development endpoint to write encrypted Amazon S3 targets.
 *
 * @experimental
 */
class SecurityConfiguration extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id, {
            physicalName: props.securityConfigurationName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_glue_SecurityConfigurationProps(props);
        if (!props.s3Encryption && !props.cloudWatchEncryption && !props.jobBookmarksEncryption) {
            throw new Error('One of cloudWatchEncryption, jobBookmarksEncryption or s3Encryption must be defined');
        }
        const kmsKeyCreationRequired = (props.s3Encryption && props.s3Encryption.mode === S3EncryptionMode.KMS && !props.s3Encryption.kmsKey) ||
            (props.cloudWatchEncryption && !props.cloudWatchEncryption.kmsKey) ||
            (props.jobBookmarksEncryption && !props.jobBookmarksEncryption.kmsKey);
        const autoCreatedKmsKey = kmsKeyCreationRequired ? new kms.Key(this, 'Key') : undefined;
        let cloudWatchEncryption;
        if (props.cloudWatchEncryption) {
            this.cloudWatchEncryptionKey = props.cloudWatchEncryption.kmsKey || autoCreatedKmsKey;
            cloudWatchEncryption = {
                cloudWatchEncryptionMode: props.cloudWatchEncryption.mode,
                kmsKeyArn: (_b = this.cloudWatchEncryptionKey) === null || _b === void 0 ? void 0 : _b.keyArn,
            };
        }
        let jobBookmarksEncryption;
        if (props.jobBookmarksEncryption) {
            this.jobBookmarksEncryptionKey = props.jobBookmarksEncryption.kmsKey || autoCreatedKmsKey;
            jobBookmarksEncryption = {
                jobBookmarksEncryptionMode: props.jobBookmarksEncryption.mode,
                kmsKeyArn: (_c = this.jobBookmarksEncryptionKey) === null || _c === void 0 ? void 0 : _c.keyArn,
            };
        }
        let s3Encryptions;
        if (props.s3Encryption) {
            if (props.s3Encryption.mode === S3EncryptionMode.KMS) {
                this.s3EncryptionKey = props.s3Encryption.kmsKey || autoCreatedKmsKey;
            }
            // NOTE: CloudFormations errors out if array is of length > 1. That's why the props don't expose an array
            s3Encryptions = [{
                    s3EncryptionMode: props.s3Encryption.mode,
                    kmsKeyArn: (_d = this.s3EncryptionKey) === null || _d === void 0 ? void 0 : _d.keyArn,
                }];
        }
        const resource = new glue_generated_1.CfnSecurityConfiguration(this, 'Resource', {
            name: props.securityConfigurationName,
            encryptionConfiguration: {
                cloudWatchEncryption,
                jobBookmarksEncryption,
                s3Encryptions,
            },
        });
        this.securityConfigurationName = this.getResourceNameAttribute(resource.ref);
    }
    /**
     * (experimental) Creates a Connection construct that represents an external security configuration.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param securityConfigurationName name of external security configuration.
     * @experimental
     */
    static fromSecurityConfigurationName(scope, id, securityConfigurationName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.securityConfigurationName = securityConfigurationName;
            }
        }
        return new Import(scope, id);
    }
}
exports.SecurityConfiguration = SecurityConfiguration;
_a = JSII_RTTI_SYMBOL_1;
SecurityConfiguration[_a] = { fqn: "@aws-cdk/aws-glue.SecurityConfiguration", version: "1.144.0" };
//# sourceMappingURL=data:application/json;base64,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