from ttkbootstrap.localization.msgcat import MessageCatalog

MESSAGES = []


def initialize_localities():
    """Load all custom msg files."""
    for m in MESSAGES:
        m.initialize()


class LocaleMsgs:
    """A helper class to allow loading the library message catalog
    without having to package library resources which can cause
    problems with creating distributable applications with some
    packagers."""

    def __init__(self, locale, *msgs):
        self.locale = locale
        self.messages = msgs

    def initialize(self):
        """Initialize this locale in the MessageCatalog"""
        from itertools import chain

        messages = list(chain(*self.messages))
        MessageCatalog.set_many(self.locale, *messages)


MESSAGES.append(
    # CZECH translation
    LocaleMsgs(
        "cs",
        ("Continue", "Pokračovat"),
        ("Retry", "Znovu"),
        ("Delete", "Vymazat"),
        ("Next", "Další"),
        ("Prev", "Předchozí"),
        ("Yes", "Ano"),
        ("No", "Ne"),
        ("Open", "Otevřený"),
        ("Close", "Zavřít"),
        ("Add", "Přidat"),
        ("Remove", "Odstranit"),
        ("Submit", "Podat"),
        ("Family", "Rodina"),
        ("Weight", "Hmotnost"),
        ("Slant", "Sklonit"),
        ("Effects", "Účinky"),
        ("Preview", "Náhled"),
        ("Size", "Velikost"),
    )
)
MESSAGES.append(
    # DANISH translation
    LocaleMsgs(
        "da",
        ("Continue", "Fortsætte"),
        ("Retry", "Prøv"),
        ("Delete", "Slette"),
        ("Next", "Næste"),
        ("Prev", "Forrige"),
        ("Yes", "Ja"),
        ("No", "Nej"),
        ("Open", "Åben"),
        ("Close", "Lukke"),
        ("Add", "Tilføje"),
        ("Remove", "Fjerne"),
        ("Submit", "Indsende"),
        ("Family", "Familie"),
        ("Weight", "Vægt"),
        ("Slant", "Drejning"),
        ("Effects", "Effekter"),
        ("Size", "Størrelse"),
    )
)
MESSAGES.append(
    # SPANISH translation
    LocaleMsgs(
        "es",
        ("Cancel", "Cancelar"),
        ("Retry", "Reintentar"),
        ("Delete", "Borrar"),
        ("Next", "Próximo"),
        ("Prev", "Anterior"),
        ("Yes", "Sí"),
        ("Open", "Abrir"),
        ("Close", "Cerrar"),
        ("Add", "Agregar"),
        ("Remove", "Eliminar"),
        ("Submit", "Enviar"),
        ("Family", "Familia"),
        ("Weight", "Peso"),
        ("Slant", "Inclinación"),
        ("Effects", "Efectos"),
        ("Preview", "Vista previa"),
        ("Size", "Tamaño"),
    )
)
MESSAGES.append(
    # PORTUGUESE - BRAZIL translation   
    LocaleMsgs(
        "pt_br",
        ("Retry", "Repetir"),
        ("Delete", "Excluir"),
        ("Next", "Próximo"),
        ("Prev", "Anterior"),
        ("Yes", "Sim"),
        ("No", "Não"),
        ("Open", "Abrir"),
        ("Close", "Fechar"),
        ("Add", "Adicionar"),
        ("Remove", "Remover"),
        ("Submit", "Enviar"),
        ("Family", "Família"),
        ("Weight", "Espessura"),
        ("Slant", "Estilo"),
        ("Effects", "Efeitos"),
        ("Preview", "Visualizar"),
        ("Size", "Tamanho"),
        ("Should be of data type", "Deve ser do tipo de dados"),
        ("Invalid data type", "Tipo de dados inválido"),
        ("Number cannot be greater than", "O número não deve ser maior que"),
        ("Out of range", "Fora do limite"),
        ("Previous", "Anterior"),
        (
            "The quick brown fox jumps over the lazy dog.",
            "A rápida raposa marrom pula sobre o cachorro preguiçoso.",
        ),
        ("Font Selector", "Seletor de Fontes"),
        ("normal", "normal"),
        ("bold", "negrito"),
        ("roman", "romano"),
        ("italic", "itálico"),
        ("underline", "sublinhado"),
        ("overstrike", "taxado"),
        ("Color Chooser", "Seletor de Cores"),
        ("Advanced", "Avançado"),
        ("Themed", "Tema"),
        ("Standard", "Básicas"),
        ("Current", "Atual"),
        ("New", "Nova"),
        ("Hue", "Matiz"),
        ("Sat", "Sat"),
        ("Lum", "Lum"),
        ("Hex", "Hex"),
        ("Red", "Vermelho"),
        ("Green", "Verde"),
        ("Blue", "Azul"),
        ("color dropper", "Selecionador de cores (conta-gotas)"),
        ("Cancel", "Cancelar"),
        ("Search", "Buscar"),
        ("Page", "Página"),
        ("of", "de"),
        ("⎌", "↺"),
        ("Reset table", "Resetar Tabela"),
        ("Columns", "Colunas"),
        ("Move", "Mover"),
        ("Align", "Alinhar"),
        ("Hide column", "Ocultar coluna"),
        ("Delete column", "Excluir coluna"),
        ("Show All", "Exibir todas"),
        ("Move to left", "Mover para esquerda"),
        ("Move to right", "Mover para direira"),
        ("Move to first", "Mover para o início"),
        ("Move to last", "Mover para o fim"),
        ("Align left", "Alinhar à esquerda"),
        ("Align center", "Alinhar ao centro"),
        ("Align right", "Alinhar à direita"),
        ("Sort", "Classificar"),
        ("Filter", "Filtrar"),
        ("Export", "Exportar"),
        ("Delete selected rows", "Excluir linhas selecionadas"),
        ("Sort Ascending", "Ordem crescente"),
        ("Sort Descending", "Ordem decrescente"),
        ("Clear filters", "Limpar filtros"),
        ("Filter by cell's value", "Filtrar pelo valor da célula"),
        ("Hide select rows", "Ocultar linha selecionada"),
        ("Show only select rows", "Exibir somente as linhas selecionadas"),
        ("Export all records", "Exportar todos os dados"),
        ("Export current page", "Exportar página atual"),
        ("Export current selection", "Exportar seleção atual"),
        ("Export records in filter", "Exportar dados do filtro"),
        ("Move up", "Mover para cima"),
        ("Move down", "Mover para baixo"),
        ("Move to top", "Mover para o início"),
        ("Move to bottom", "Mover para o fim"),
        ("Mo", "S"),
        ("Tu", "T"),
        ("We", "Q"),
        ("Th", "Q"),
        ("Fr", "S"),
        ("Sa", "S"),
        ("Su", "D"),
    )
)
MESSAGES.append(
    # CHINESE - CHINA translation
    LocaleMsgs(
        "zh_cn",
        ("&Abort", "&中止"),
        ("&About...", "&关于……"),
        ("All Files", "所有文件"),
        ("Application Error", "应用程序错误"),
        ("&Apply", "&添加"),
        ("Bold", "粗体"),
        ("Bold Italic", "加粗斜体"),
        ("&Blue", "&蓝色"),
        ("Cancel", "取消"),
        ("&Cancel", "&取消"),
        (
            'Cannot change to the directory %1\$s.\nPermission denied.',
            '无法更改目录 %1\$s。\n访问被拒绝。',
        ),
        ("Choose Directory", "选择文件夹"),
        ("Cl&ear", "清&除"),
        ("&Clear Console", "&清除终端"),
        ("Color", "颜色"),
        ("Console", "终端"),
        ("&Copy", "&复制"),
        ("Cu&t", "剪&切"),
        ("&Delete", "&删除"),
        ("Details >>", "详细信息 >>"),
        ('Directory %1\$s does not exist.', '目录 %1\$s 不存在。'),
        ("&Directory:", "&目录："),
        ("&Edit", "&编辑"),
        ("Effects", "效果"),
        ("Error: %1\$s", "错误： %1\$s"),
        ("E&xit", "退&出"),
        ("&File", "&文件"),
        (
            'File %1\$s already exists.\nDo you want to overwrite it?',
            '文件 %1\$s 已经存在。\n您想要覆盖它吗？',
        ),
        ('File %1\$s already exists.\n\n', '文件 %1\$s 已经存在。\n\n'),
        ('File %1\$s does not exist.', '文件 %1\$s 不存在。'),
        ("File &name:", "文件&名："),
        ("File &names:", "文件&名："),
        ("Files of &type:", "文件&类型："),
        ("Fi&les:", "文&件："),
        ("&Filter", "&过滤"),
        ("Fil&ter:", "过&滤："),
        ("Font", "字体"),
        ("&Font:", "&字体："),
        ("Font st&yle:", "字体&样式："),
        ("&Green", "&绿色"),
        ("&Help", "&帮助"),
        ("Hi", "你好"),
        ("&Hide Console", "&隐藏终端"),
        ("&Ignore", "&忽略"),
        ('Invalid file name %1\$s.', '无效的文件名 %1\$s。'),
        ("Italic", "斜体"),
        ("Log Files", "日志文件"),
        ("&No", "&取消"),
        ("No", "取消"),
        ("&OK", "&确定"),
        ("OK", "确定"),
        ("Ok", "确定"),
        ("Open", "打开"),
        ("&Open", "&打开"),
        ("Open Multiple Files", "打开多个文件"),
        ("P&aste", "粘&贴"),
        ("&Quit", "&退出"),
        ("&Red", "红色"),
        ("Regular", "规则"),
        ("Replace existing file?", "替换已有文件？"),
        ("&Retry", "&重试"),
        ("Sample", "样式"),
        ("&Save", "&保存"),
        ("Save As", "另存为"),
        ("Save To Log", "保存到日志"),
        ("Select Log File", "选择日志文件"),
        ("Select a file to source", "选择一个源文件"),
        ("&Selection:", "&选择："),
        ("&Size:", "&大小："),
        ("Show &Hidden Directories", "显示&隐藏目录"),
        ("Show &Hidden Files and Directories", "显示&隐藏文件和目录"),
        ("Skip Messages", "跳过信息"),
        ("&Source...", "&来源……"),
        ("Stri&keout", "删&除线"),
        ("Tcl Scripts", "Tcl脚本"),
        ("Tcl for Windows", "适用于Windows的Tcl"),
        ("Text Files", "文本文档"),
        ("&Underline", "&下划线"),
        ("&Yes", "&确定"),
        ("abort", "中止"),
        ("blue", "蓝色"),
        ("cancel", "取消"),
        ("extension", "拓展"),
        ("extensions", "拓展"),
        ("green", "绿色"),
        ("ignore", "忽略"),
        ("ok", "确定"),
        ("red", "红色"),
        ("retry", "重试"),
        ("Retry", "重试"),
        ("yes", "确认"),
        ("Yes", "确认"),
        ("Should be of data type", "应为数据类型"),
        ("Invalid data type", "无效数据类型"),
        ("Number cannot be greater than", "数字不能大于"),
        ("Out of range", "超出范围"),
        ("Submit", "提交"),
        ("Delete", "删除"),
        ("Next", "下一步"),
        ("Previous", "以前的"),
        ("Open", "打开"),
        ("Close", "关闭"),
        ("Add", "添加"),
        ("Remove", "移除"),
        ("Family", "组"),
        ("Weight", "重量"),
        ("Slant", "倾斜"),
        ("Effects", "效果"),
        ("Preview", "预览"),
        ("Size", "大小"),
        ("The quick brown fox jumps over the lazy dog.", "敏捷的棕色狐狸跳过懒惰的狗。"),
        ("Print", "输出"),
        ("Printer", "打印机"),
        ("Letter ", "信 "),
        ("Legal ", "合法的 "),
        ("A4", "A4"),
        ("Grayscale", "灰度"),
        ("RGB", "RGB"),
        ("Options", "设置"),
        ("Copies", "复制"),
        ("Paper", "纸"),
        ("Scale", "规模"),
        ("Orientation", "方向"),
        ("Portrait", "竖向"),
        ("Landscape", "横向"),
        ("Output", "输出"),
    )
)
