# Generated by Django 4.0.4 on 2022-05-06 06:47

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import re


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Label',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Scentific name')),
                ('taxonomic_rank', models.CharField(choices=[('order', 'Order'), ('family', 'Family'), ('genus', 'Genus'), ('species_group', 'Spec Group'), ('species', 'Species')], default='species', max_length=255, verbose_name='Taxonomic Rank')),
                ('phonetic_name', models.CharField(blank=True, max_length=255, null=True, verbose_name='Phonetic name')),
                ('phonetic_name_language', models.CharField(choices=[('de', 'German'), ('en', 'English'), ('undefined', 'Undefined')], default='undefined', max_length=255, verbose_name='Phonetic lanugage')),
                ('authors', models.CharField(blank=True, max_length=255, null=True, verbose_name='Authors')),
                ('kr_nr', models.CharField(blank=True, max_length=255, null=True, unique=True, validators=[django.core.validators.RegexValidator(message='K+R numbers should be alpha-numeric only!', regex=re.compile('[A-Za-z0-9]+'))], verbose_name='K+R-Nr.')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('last_update', models.DateTimeField(auto_now=True, verbose_name='Last modified at')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='labeltree.label', verbose_name='Parent')),
            ],
            options={
                'verbose_name': 'Label',
                'verbose_name_plural': 'Labels',
                'unique_together': {('name', 'taxonomic_rank')},
            },
        ),
    ]
