# coding: utf-8

"""
    Aspose.ThreeD Cloud API Reference

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re
from . import SaveOptions

class GLTFSaveOption(SaveOptions):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'pretty_print': 'bool',
        'embed_assets': 'bool',
        'use_common_materials': 'bool',
        'flip_tex_coord_v': 'bool',
        'buffer_file': 'bool',
        'save_extras': 'bool',
        'draco_compression': 'bool',
        'file_content_type': 'FileContentType'
    }

    attribute_map = {
        'pretty_print': 'PrettyPrint',
        'embed_assets': 'EmbedAssets',
        'use_common_materials': 'UseCommonMaterials',
        'flip_tex_coord_v': 'FlipTexCoordV',
        'buffer_file': 'BufferFile',
        'save_extras': 'SaveExtras',
        'draco_compression': 'DracoCompression',
        'file_content_type': 'FileContentType'
    }
    
    @staticmethod
    def get_swagger_types():
        return dict(GLTFSaveOption.swagger_types, **SaveOptions.get_swagger_types())
    
    @staticmethod
    def get_attribute_map():
        return dict(GLTFSaveOption.attribute_map, **SaveOptions.get_attribute_map())
    
    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self, pretty_print=None, embed_assets=None, use_common_materials=None, flip_tex_coord_v=None, buffer_file=None, save_extras=None, draco_compression=None, file_content_type=None, **kw):
        super(GLTFSaveOption, self).__init__(**kw)
		    
        """
        GLTFSaveOption - a model defined in Swagger
        """

        self.container['pretty_print'] = None
        self.container['embed_assets'] = None
        self.container['use_common_materials'] = None
        self.container['flip_tex_coord_v'] = None
        self.container['buffer_file'] = None
        self.container['save_extras'] = None
        self.container['draco_compression'] = None
        self.container['file_content_type'] = None

        if pretty_print is not None:
          self.pretty_print = pretty_print
        if embed_assets is not None:
          self.embed_assets = embed_assets
        if use_common_materials is not None:
          self.use_common_materials = use_common_materials
        if flip_tex_coord_v is not None:
          self.flip_tex_coord_v = flip_tex_coord_v
        if buffer_file is not None:
          self.buffer_file = buffer_file
        if save_extras is not None:
          self.save_extras = save_extras
        if draco_compression is not None:
          self.draco_compression = draco_compression
        if file_content_type is not None:
          self.file_content_type = file_content_type

    @property
    def pretty_print(self):
        """
        Gets the pretty_print of this GLTFSaveOption.
        The JSON content of GLTF file is indented for human reading, default value is false.

        :return: The pretty_print of this GLTFSaveOption.
        :rtype: bool
        """
        return self.container['pretty_print']

    @pretty_print.setter
    def pretty_print(self, pretty_print):
        """
        Sets the pretty_print of this GLTFSaveOption.
        The JSON content of GLTF file is indented for human reading, default value is false.

        :param pretty_print: The pretty_print of this GLTFSaveOption.
        :type: bool
        """

        self.container['pretty_print'] = pretty_print

    @property
    def embed_assets(self):
        """
        Gets the embed_assets of this GLTFSaveOption.
        Embed all external assets as base64 into single file in ASCII mode, default value is false.

        :return: The embed_assets of this GLTFSaveOption.
        :rtype: bool
        """
        return self.container['embed_assets']

    @embed_assets.setter
    def embed_assets(self, embed_assets):
        """
        Sets the embed_assets of this GLTFSaveOption.
        Embed all external assets as base64 into single file in ASCII mode, default value is false.

        :param embed_assets: The embed_assets of this GLTFSaveOption.
        :type: bool
        """

        self.container['embed_assets'] = embed_assets

    @property
    def use_common_materials(self):
        """
        Gets the use_common_materials of this GLTFSaveOption.
        Serialize materials using KHR common material extensions, default value is false. Set this to false will cause Aspose.3D export a set of vertex/fragment shader if Aspose.ThreeD.Formats.GLTFSaveOptions.ExportShaders

        :return: The use_common_materials of this GLTFSaveOption.
        :rtype: bool
        """
        return self.container['use_common_materials']

    @use_common_materials.setter
    def use_common_materials(self, use_common_materials):
        """
        Sets the use_common_materials of this GLTFSaveOption.
        Serialize materials using KHR common material extensions, default value is false. Set this to false will cause Aspose.3D export a set of vertex/fragment shader if Aspose.ThreeD.Formats.GLTFSaveOptions.ExportShaders

        :param use_common_materials: The use_common_materials of this GLTFSaveOption.
        :type: bool
        """

        self.container['use_common_materials'] = use_common_materials

    @property
    def flip_tex_coord_v(self):
        """
        Gets the flip_tex_coord_v of this GLTFSaveOption.
        Flip texture coordinate v(t) component, default value is true.

        :return: The flip_tex_coord_v of this GLTFSaveOption.
        :rtype: bool
        """
        return self.container['flip_tex_coord_v']

    @flip_tex_coord_v.setter
    def flip_tex_coord_v(self, flip_tex_coord_v):
        """
        Sets the flip_tex_coord_v of this GLTFSaveOption.
        Flip texture coordinate v(t) component, default value is true.

        :param flip_tex_coord_v: The flip_tex_coord_v of this GLTFSaveOption.
        :type: bool
        """

        self.container['flip_tex_coord_v'] = flip_tex_coord_v

    @property
    def buffer_file(self):
        """
        Gets the buffer_file of this GLTFSaveOption.
        The file name of the external buffer file used to store binary data. If this file is not specified, Aspose.3D will generate a name for you. This is ignored when export glTF in binary mode.

        :return: The buffer_file of this GLTFSaveOption.
        :rtype: bool
        """
        return self.container['buffer_file']

    @buffer_file.setter
    def buffer_file(self, buffer_file):
        """
        Sets the buffer_file of this GLTFSaveOption.
        The file name of the external buffer file used to store binary data. If this file is not specified, Aspose.3D will generate a name for you. This is ignored when export glTF in binary mode.

        :param buffer_file: The buffer_file of this GLTFSaveOption.
        :type: bool
        """

        self.container['buffer_file'] = buffer_file

    @property
    def save_extras(self):
        """
        Gets the save_extras of this GLTFSaveOption.
        Save scene object's dynamic properties into 'extra' fields in the generated glTF file. This is useful to provide application-specific data. Default value is false..

        :return: The save_extras of this GLTFSaveOption.
        :rtype: bool
        """
        return self.container['save_extras']

    @save_extras.setter
    def save_extras(self, save_extras):
        """
        Sets the save_extras of this GLTFSaveOption.
        Save scene object's dynamic properties into 'extra' fields in the generated glTF file. This is useful to provide application-specific data. Default value is false..

        :param save_extras: The save_extras of this GLTFSaveOption.
        :type: bool
        """

        self.container['save_extras'] = save_extras

    @property
    def draco_compression(self):
        """
        Gets the draco_compression of this GLTFSaveOption.
        Gets or sets whether to enable draco compression.

        :return: The draco_compression of this GLTFSaveOption.
        :rtype: bool
        """
        return self.container['draco_compression']

    @draco_compression.setter
    def draco_compression(self, draco_compression):
        """
        Sets the draco_compression of this GLTFSaveOption.
        Gets or sets whether to enable draco compression.

        :param draco_compression: The draco_compression of this GLTFSaveOption.
        :type: bool
        """

        self.container['draco_compression'] = draco_compression

    @property
    def file_content_type(self):
        """
        Gets the file_content_type of this GLTFSaveOption.
        Gets or sets  of the FileContent type.

        :return: The file_content_type of this GLTFSaveOption.
        :rtype: FileContentType
        """
        return self.container['file_content_type']

    @file_content_type.setter
    def file_content_type(self, file_content_type):
        """
        Sets the file_content_type of this GLTFSaveOption.
        Gets or sets  of the FileContent type.

        :param file_content_type: The file_content_type of this GLTFSaveOption.
        :type: FileContentType
        """

        self.container['file_content_type'] = file_content_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, GLTFSaveOption):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
