# coding: utf-8

"""
    Aspose.3D Cloud API Reference

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: 3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from aspose3dcloud.apis.o_auth_api import OAuthApi

class ThreeDCloudApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    #def __init__(self, api_client=None):
    def __init__(self,grant_type,appsid,appkey,api_client=None):    
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client
            self.access_token=self.get_access_token(grant_type,appsid,appkey)
            
        self.api_client.set_default_header("Authorization", "Bearer " + self.access_token)

    def get_access_token(self,grant_type,appsid,appkey):
        authApiClient=ApiClient('https://api-qa.aspose.cloud')
        client=OAuthApi(authApiClient)
        auth_data=client.o_auth_post(grant_type, appsid, appkey)
        return auth_data.access_token
                               

    def copy_file(self, src_path, dest_path, **kwargs):
        """
        Copy file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_file(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source file path e.g. '/folder/file.ext' (required)
        :param str dest_path: Destination file path (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :param str version_id: File version ID to copy
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.copy_file_with_http_info(src_path, dest_path, **kwargs)
        else:
            (data) = self.copy_file_with_http_info(src_path, dest_path, **kwargs)
            return data

    def copy_file_with_http_info(self, src_path, dest_path, **kwargs):
        """
        Copy file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_file_with_http_info(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source file path e.g. '/folder/file.ext' (required)
        :param str dest_path: Destination file path (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :param str version_id: File version ID to copy
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'dest_path', 'src_storage_name', 'dest_storage_name', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `copy_file`")
        # verify the required parameter 'dest_path' is set
        if ('dest_path' not in params) or (params['dest_path'] is None):
            raise ValueError("Missing the required parameter `dest_path` when calling `copy_file`")


        collection_formats = {}

        path_params = {}
        if 'src_path' in params:
            path_params['srcPath'] = params['src_path']

        query_params = []
        if 'dest_path' in params:
            query_params.append(('destPath', params['dest_path']))
        if 'src_storage_name' in params:
            query_params.append(('srcStorageName', params['src_storage_name']))
        if 'dest_storage_name' in params:
            query_params.append(('destStorageName', params['dest_storage_name']))
        if 'version_id' in params:
            query_params.append(('versionId', params['version_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/file/copy/{srcPath}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def copy_folder(self, src_path, dest_path, **kwargs):
        """
        Copy folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_folder(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source folder path e.g. '/src' (required)
        :param str dest_path: Destination folder path e.g. '/dst' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.copy_folder_with_http_info(src_path, dest_path, **kwargs)
        else:
            (data) = self.copy_folder_with_http_info(src_path, dest_path, **kwargs)
            return data

    def copy_folder_with_http_info(self, src_path, dest_path, **kwargs):
        """
        Copy folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_folder_with_http_info(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source folder path e.g. '/src' (required)
        :param str dest_path: Destination folder path e.g. '/dst' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'dest_path', 'src_storage_name', 'dest_storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `copy_folder`")
        # verify the required parameter 'dest_path' is set
        if ('dest_path' not in params) or (params['dest_path'] is None):
            raise ValueError("Missing the required parameter `dest_path` when calling `copy_folder`")


        collection_formats = {}

        path_params = {}
        if 'src_path' in params:
            path_params['srcPath'] = params['src_path']

        query_params = []
        if 'dest_path' in params:
            query_params.append(('destPath', params['dest_path']))
        if 'src_storage_name' in params:
            query_params.append(('srcStorageName', params['src_storage_name']))
        if 'dest_storage_name' in params:
            query_params.append(('destStorageName', params['dest_storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/folder/copy/{srcPath}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_folder(self, path, **kwargs):
        """
        Create the folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_folder(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path to create e.g. 'folder_1/folder_2/' (required)
        :param str storage_name: Storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_folder_with_http_info(path, **kwargs)
        else:
            (data) = self.create_folder_with_http_info(path, **kwargs)
            return data

    def create_folder_with_http_info(self, path, **kwargs):
        """
        Create the folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_folder_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path to create e.g. 'folder_1/folder_2/' (required)
        :param str storage_name: Storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `create_folder`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/folder/{path}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_file(self, path, **kwargs):
        """
        Delete file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/folder/file.ext' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID to delete
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_file_with_http_info(path, **kwargs)
        else:
            (data) = self.delete_file_with_http_info(path, **kwargs)
            return data

    def delete_file_with_http_info(self, path, **kwargs):
        """
        Delete file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_file_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/folder/file.ext' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID to delete
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `delete_file`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))
        if 'version_id' in params:
            query_params.append(('versionId', params['version_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/file/{path}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_folder(self, path, **kwargs):
        """
        Delete folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_folder(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path e.g. '/folder' (required)
        :param str storage_name: Storage name
        :param bool recursive: Enable to delete folders, subfolders and files
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_folder_with_http_info(path, **kwargs)
        else:
            (data) = self.delete_folder_with_http_info(path, **kwargs)
            return data

    def delete_folder_with_http_info(self, path, **kwargs):
        """
        Delete folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_folder_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path e.g. '/folder' (required)
        :param str storage_name: Storage name
        :param bool recursive: Enable to delete folders, subfolders and files
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name', 'recursive']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `delete_folder`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))
        if 'recursive' in params:
            query_params.append(('recursive', params['recursive']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/folder/{path}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_nodes(self, name, objectaddressingpath, **kwargs):
        """
        Delete nodes from scene,nodes are addressed by Object Addressing Path
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_nodes(name, objectaddressingpath, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file. (required)
        :param str objectaddressingpath: The object addressing path. (required)
        :param str folder: The folder of the source file.
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_nodes_with_http_info(name, objectaddressingpath, **kwargs)
        else:
            (data) = self.delete_nodes_with_http_info(name, objectaddressingpath, **kwargs)
            return data

    def delete_nodes_with_http_info(self, name, objectaddressingpath, **kwargs):
        """
        Delete nodes from scene,nodes are addressed by Object Addressing Path
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_nodes_with_http_info(name, objectaddressingpath, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file. (required)
        :param str objectaddressingpath: The object addressing path. (required)
        :param str folder: The folder of the source file.
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'objectaddressingpath', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_nodes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_nodes`")
        # verify the required parameter 'objectaddressingpath' is set
        if ('objectaddressingpath' not in params) or (params['objectaddressingpath'] is None):
            raise ValueError("Missing the required parameter `objectaddressingpath` when calling `delete_nodes`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'objectaddressingpath' in params:
            query_params.append(('objectaddressingpath', params['objectaddressingpath']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/nodes', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def download_file(self, path, **kwargs):
        """
        Download file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_file(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/folder/file.ext' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID to download
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.download_file_with_http_info(path, **kwargs)
        else:
            (data) = self.download_file_with_http_info(path, **kwargs)
            return data

    def download_file_with_http_info(self, path, **kwargs):
        """
        Download file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.download_file_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/folder/file.ext' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID to download
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `download_file`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))
        if 'version_id' in params:
            query_params.append(('versionId', params['version_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/file/{path}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_disc_usage(self, **kwargs):
        """
        Get disc usage
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_disc_usage(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str storage_name: Storage name
        :return: DiscUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_disc_usage_with_http_info(**kwargs)
        else:
            (data) = self.get_disc_usage_with_http_info(**kwargs)
            return data

    def get_disc_usage_with_http_info(self, **kwargs):
        """
        Get disc usage
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_disc_usage_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str storage_name: Storage name
        :return: DiscUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_disc_usage" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/disc', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='DiscUsage',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_file_versions(self, path, **kwargs):
        """
        Get file versions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_versions(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/file.ext' (required)
        :param str storage_name: Storage name
        :return: FileVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_file_versions_with_http_info(path, **kwargs)
        else:
            (data) = self.get_file_versions_with_http_info(path, **kwargs)
            return data

    def get_file_versions_with_http_info(self, path, **kwargs):
        """
        Get file versions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_file_versions_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File path e.g. '/file.ext' (required)
        :param str storage_name: Storage name
        :return: FileVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_file_versions`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/version/{path}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FileVersions',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_files_list(self, path, **kwargs):
        """
        Get all files and folders within a folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_files_list(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path e.g. '/folder' (required)
        :param str storage_name: Storage name
        :return: FilesList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_files_list_with_http_info(path, **kwargs)
        else:
            (data) = self.get_files_list_with_http_info(path, **kwargs)
            return data

    def get_files_list_with_http_info(self, path, **kwargs):
        """
        Get all files and folders within a folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_files_list_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Folder path e.g. '/folder' (required)
        :param str storage_name: Storage name
        :return: FilesList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `get_files_list`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/folder/{path}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FilesList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def move_file(self, src_path, dest_path, **kwargs):
        """
        Move file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_file(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source file path e.g. '/src.ext' (required)
        :param str dest_path: Destination file path e.g. '/dest.ext' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :param str version_id: File version ID to move
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.move_file_with_http_info(src_path, dest_path, **kwargs)
        else:
            (data) = self.move_file_with_http_info(src_path, dest_path, **kwargs)
            return data

    def move_file_with_http_info(self, src_path, dest_path, **kwargs):
        """
        Move file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_file_with_http_info(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Source file path e.g. '/src.ext' (required)
        :param str dest_path: Destination file path e.g. '/dest.ext' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :param str version_id: File version ID to move
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'dest_path', 'src_storage_name', 'dest_storage_name', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `move_file`")
        # verify the required parameter 'dest_path' is set
        if ('dest_path' not in params) or (params['dest_path'] is None):
            raise ValueError("Missing the required parameter `dest_path` when calling `move_file`")


        collection_formats = {}

        path_params = {}
        if 'src_path' in params:
            path_params['srcPath'] = params['src_path']

        query_params = []
        if 'dest_path' in params:
            query_params.append(('destPath', params['dest_path']))
        if 'src_storage_name' in params:
            query_params.append(('srcStorageName', params['src_storage_name']))
        if 'dest_storage_name' in params:
            query_params.append(('destStorageName', params['dest_storage_name']))
        if 'version_id' in params:
            query_params.append(('versionId', params['version_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/file/move/{srcPath}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def move_folder(self, src_path, dest_path, **kwargs):
        """
        Move folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_folder(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Folder path to move e.g. '/folder' (required)
        :param str dest_path: Destination folder path to move to e.g '/dst' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.move_folder_with_http_info(src_path, dest_path, **kwargs)
        else:
            (data) = self.move_folder_with_http_info(src_path, dest_path, **kwargs)
            return data

    def move_folder_with_http_info(self, src_path, dest_path, **kwargs):
        """
        Move folder
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_folder_with_http_info(src_path, dest_path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str src_path: Folder path to move e.g. '/folder' (required)
        :param str dest_path: Destination folder path to move to e.g '/dst' (required)
        :param str src_storage_name: Source storage name
        :param str dest_storage_name: Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['src_path', 'dest_path', 'src_storage_name', 'dest_storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if ('src_path' not in params) or (params['src_path'] is None):
            raise ValueError("Missing the required parameter `src_path` when calling `move_folder`")
        # verify the required parameter 'dest_path' is set
        if ('dest_path' not in params) or (params['dest_path'] is None):
            raise ValueError("Missing the required parameter `dest_path` when calling `move_folder`")


        collection_formats = {}

        path_params = {}
        if 'src_path' in params:
            path_params['srcPath'] = params['src_path']

        query_params = []
        if 'dest_path' in params:
            query_params.append(('destPath', params['dest_path']))
        if 'src_storage_name' in params:
            query_params.append(('srcStorageName', params['src_storage_name']))
        if 'dest_storage_name' in params:
            query_params.append(('destStorageName', params['dest_storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/folder/move/{srcPath}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def o_auth_post(self, grant_type, client_id, client_secret, **kwargs):
        """
        Get Access token
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.o_auth_post(grant_type, client_id, client_secret, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grant_type: Grant Type (required)
        :param str client_id: App SID (required)
        :param str client_secret: App Key (required)
        :return: AccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.o_auth_post_with_http_info(grant_type, client_id, client_secret, **kwargs)
        else:
            (data) = self.o_auth_post_with_http_info(grant_type, client_id, client_secret, **kwargs)
            return data

    def o_auth_post_with_http_info(self, grant_type, client_id, client_secret, **kwargs):
        """
        Get Access token
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.o_auth_post_with_http_info(grant_type, client_id, client_secret, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grant_type: Grant Type (required)
        :param str client_id: App SID (required)
        :param str client_secret: App Key (required)
        :return: AccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grant_type', 'client_id', 'client_secret']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method o_auth_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'grant_type' is set
        if ('grant_type' not in params) or (params['grant_type'] is None):
            raise ValueError("Missing the required parameter `grant_type` when calling `o_auth_post`")
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `o_auth_post`")
        # verify the required parameter 'client_secret' is set
        if ('client_secret' not in params) or (params['client_secret'] is None):
            raise ValueError("Missing the required parameter `client_secret` when calling `o_auth_post`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'grant_type' in params:
            form_params.append(('grant_type', params['grant_type']))
        if 'client_id' in params:
            form_params.append(('client_id', params['client_id']))
        if 'client_secret' in params:
            form_params.append(('client_secret', params['client_secret']))

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/connect/token', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='AccessTokenResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def object_exists(self, path, **kwargs):
        """
        Check if file or folder exists
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.object_exists(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File or folder path e.g. '/file.ext' or '/folder' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID
        :return: ObjectExist
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.object_exists_with_http_info(path, **kwargs)
        else:
            (data) = self.object_exists_with_http_info(path, **kwargs)
            return data

    def object_exists_with_http_info(self, path, **kwargs):
        """
        Check if file or folder exists
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.object_exists_with_http_info(path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: File or folder path e.g. '/file.ext' or '/folder' (required)
        :param str storage_name: Storage name
        :param str version_id: File version ID
        :return: ObjectExist
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'storage_name', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method object_exists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `object_exists`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))
        if 'version_id' in params:
            query_params.append(('versionId', params['version_id']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/exist/{path}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ObjectExist',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_convert_by_format(self, name, newformat, newfilename, **kwargs):
        """
        Convert file on server to other formats with fileformat parameter             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_convert_by_format(name, newformat, newfilename, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file. (required)
        :param str newformat: The format of the new file. (required)
        :param str newfilename: The name of the new file. (required)
        :param str folder: The folder of the source file.
        :param bool is_overwrite: Overwrite the source file? true or false.
        :param str storage: The storage type.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_convert_by_format_with_http_info(name, newformat, newfilename, **kwargs)
        else:
            (data) = self.post_convert_by_format_with_http_info(name, newformat, newfilename, **kwargs)
            return data

    def post_convert_by_format_with_http_info(self, name, newformat, newfilename, **kwargs):
        """
        Convert file on server to other formats with fileformat parameter             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_convert_by_format_with_http_info(name, newformat, newfilename, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file. (required)
        :param str newformat: The format of the new file. (required)
        :param str newfilename: The name of the new file. (required)
        :param str folder: The folder of the source file.
        :param bool is_overwrite: Overwrite the source file? true or false.
        :param str storage: The storage type.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'newformat', 'newfilename', 'folder', 'is_overwrite', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_convert_by_format" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_convert_by_format`")
        # verify the required parameter 'newformat' is set
        if ('newformat' not in params) or (params['newformat'] is None):
            raise ValueError("Missing the required parameter `newformat` when calling `post_convert_by_format`")
        # verify the required parameter 'newfilename' is set
        if ('newfilename' not in params) or (params['newfilename'] is None):
            raise ValueError("Missing the required parameter `newfilename` when calling `post_convert_by_format`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'newformat' in params:
            query_params.append(('newformat', params['newformat']))
        if 'newfilename' in params:
            query_params.append(('newfilename', params['newfilename']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'is_overwrite' in params:
            query_params.append(('IsOverwrite', params['is_overwrite']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/saveas/newformat', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_convert_by_opt(self, name, save_options, newfilename, **kwargs):
        """
        Convert file on server to other formats with saveOption parameter             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_convert_by_opt(name, save_options, newfilename, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file. (required)
        :param SaveOptions save_options: The saveOptions to save the file (required)
        :param str newfilename: The name of the new file (required)
        :param str folder: The folder of the source file
        :param bool is_overwrite: Overwrite the source file? true or false
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_convert_by_opt_with_http_info(name, save_options, newfilename, **kwargs)
        else:
            (data) = self.post_convert_by_opt_with_http_info(name, save_options, newfilename, **kwargs)
            return data

    def post_convert_by_opt_with_http_info(self, name, save_options, newfilename, **kwargs):
        """
        Convert file on server to other formats with saveOption parameter             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_convert_by_opt_with_http_info(name, save_options, newfilename, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file. (required)
        :param SaveOptions save_options: The saveOptions to save the file (required)
        :param str newfilename: The name of the new file (required)
        :param str folder: The folder of the source file
        :param bool is_overwrite: Overwrite the source file? true or false
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'save_options', 'newfilename', 'folder', 'is_overwrite', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_convert_by_opt" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_convert_by_opt`")
        # verify the required parameter 'save_options' is set
        if ('save_options' not in params) or (params['save_options'] is None):
            raise ValueError("Missing the required parameter `save_options` when calling `post_convert_by_opt`")
        # verify the required parameter 'newfilename' is set
        if ('newfilename' not in params) or (params['newfilename'] is None):
            raise ValueError("Missing the required parameter `newfilename` when calling `post_convert_by_opt`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'newfilename' in params:
            query_params.append(('newfilename', params['newfilename']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'is_overwrite' in params:
            query_params.append(('IsOverwrite', params['is_overwrite']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'save_options' in params:
            body_params = params['save_options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/saveas/saveoption', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_create(self, format, **kwargs):
        """
        Create new file with specified format.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_create(format, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str format: The format of the new file. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_create_with_http_info(format, **kwargs)
        else:
            (data) = self.post_create_with_http_info(format, **kwargs)
            return data

    def post_create_with_http_info(self, format, **kwargs):
        """
        Create new file with specified format.             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_create_with_http_info(format, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str format: The format of the new file. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['format']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'format' is set
        if ('format' not in params) or (params['format'] is None):
            raise ValueError("Missing the required parameter `format` when calling `post_create`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['multipart/form-data'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/new', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_model(self, name, modeldata, **kwargs):
        """
        Parametric Modeling, Create a Entity with size and located in ...
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_model(name, modeldata, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file. (required)
        :param ModelData modeldata: ModelData struct. (required)
        :param str newformat: new format of the source file.
        :param str folder: The folder of the source file.
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_model_with_http_info(name, modeldata, **kwargs)
        else:
            (data) = self.post_model_with_http_info(name, modeldata, **kwargs)
            return data

    def post_model_with_http_info(self, name, modeldata, **kwargs):
        """
        Parametric Modeling, Create a Entity with size and located in ...
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_model_with_http_info(name, modeldata, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file. (required)
        :param ModelData modeldata: ModelData struct. (required)
        :param str newformat: new format of the source file.
        :param str folder: The folder of the source file.
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'modeldata', 'newformat', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_model" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_model`")
        # verify the required parameter 'modeldata' is set
        if ('modeldata' not in params) or (params['modeldata'] is None):
            raise ValueError("Missing the required parameter `modeldata` when calling `post_model`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'newformat' in params:
            query_params.append(('newformat', params['newformat']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'modeldata' in params:
            body_params = params['modeldata']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/root', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_pdf_raw_data(self, name, multifileprefix, **kwargs):
        """
        Extract raw data(without any modification) from a password protected PDF file             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_pdf_raw_data(name, multifileprefix, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The PDF file's mame (required)
        :param str multifileprefix: The file name for generated raw date (required)
        :param str password: The password to open the PDF
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_pdf_raw_data_with_http_info(name, multifileprefix, **kwargs)
        else:
            (data) = self.post_pdf_raw_data_with_http_info(name, multifileprefix, **kwargs)
            return data

    def post_pdf_raw_data_with_http_info(self, name, multifileprefix, **kwargs):
        """
        Extract raw data(without any modification) from a password protected PDF file             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_pdf_raw_data_with_http_info(name, multifileprefix, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The PDF file's mame (required)
        :param str multifileprefix: The file name for generated raw date (required)
        :param str password: The password to open the PDF
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'multifileprefix', 'password', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_pdf_raw_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_pdf_raw_data`")
        # verify the required parameter 'multifileprefix' is set
        if ('multifileprefix' not in params) or (params['multifileprefix'] is None):
            raise ValueError("Missing the required parameter `multifileprefix` when calling `post_pdf_raw_data`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'multifileprefix' in params:
            query_params.append(('multifileprefix', params['multifileprefix']))
        if 'password' in params:
            query_params.append(('password', params['password']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/extract/rawdata', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_save_as_part(self, name, objectaddressingpath, newformat, newfilename, **kwargs):
        """
        Convert part of the file into different format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_save_as_part(name, objectaddressingpath, newformat, newfilename, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file (required)
        :param str objectaddressingpath: The object addressing path (required)
        :param str newformat: The format of the new file (required)
        :param str newfilename: The name of the new file (required)
        :param str folder: The folder of the source file
        :param bool is_overwrite: Overwrite the source file? true or false
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_save_as_part_with_http_info(name, objectaddressingpath, newformat, newfilename, **kwargs)
        else:
            (data) = self.post_save_as_part_with_http_info(name, objectaddressingpath, newformat, newfilename, **kwargs)
            return data

    def post_save_as_part_with_http_info(self, name, objectaddressingpath, newformat, newfilename, **kwargs):
        """
        Convert part of the file into different format
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_save_as_part_with_http_info(name, objectaddressingpath, newformat, newfilename, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The name of the source file (required)
        :param str objectaddressingpath: The object addressing path (required)
        :param str newformat: The format of the new file (required)
        :param str newfilename: The name of the new file (required)
        :param str folder: The folder of the source file
        :param bool is_overwrite: Overwrite the source file? true or false
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'objectaddressingpath', 'newformat', 'newfilename', 'folder', 'is_overwrite', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_save_as_part" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_save_as_part`")
        # verify the required parameter 'objectaddressingpath' is set
        if ('objectaddressingpath' not in params) or (params['objectaddressingpath'] is None):
            raise ValueError("Missing the required parameter `objectaddressingpath` when calling `post_save_as_part`")
        # verify the required parameter 'newformat' is set
        if ('newformat' not in params) or (params['newformat'] is None):
            raise ValueError("Missing the required parameter `newformat` when calling `post_save_as_part`")
        # verify the required parameter 'newfilename' is set
        if ('newfilename' not in params) or (params['newfilename'] is None):
            raise ValueError("Missing the required parameter `newfilename` when calling `post_save_as_part`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'objectaddressingpath' in params:
            query_params.append(('objectaddressingpath', params['objectaddressingpath']))
        if 'newformat' in params:
            query_params.append(('newformat', params['newformat']))
        if 'newfilename' in params:
            query_params.append(('newfilename', params['newfilename']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'is_overwrite' in params:
            query_params.append(('IsOverwrite', params['is_overwrite']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/saveas/part', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_scene_to_file(self, name, multifileprefix, **kwargs):
        """
        Extract and save in different format             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_scene_to_file(name, multifileprefix, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The PDF file's mame (required)
        :param str multifileprefix: The file name for extracted scene (required)
        :param str newformat: The format of new file
        :param str password: The password to open the PDF
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_scene_to_file_with_http_info(name, multifileprefix, **kwargs)
        else:
            (data) = self.post_scene_to_file_with_http_info(name, multifileprefix, **kwargs)
            return data

    def post_scene_to_file_with_http_info(self, name, multifileprefix, **kwargs):
        """
        Extract and save in different format             
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_scene_to_file_with_http_info(name, multifileprefix, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The PDF file's mame (required)
        :param str multifileprefix: The file name for extracted scene (required)
        :param str newformat: The format of new file
        :param str password: The password to open the PDF
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'multifileprefix', 'newformat', 'password', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_scene_to_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_scene_to_file`")
        # verify the required parameter 'multifileprefix' is set
        if ('multifileprefix' not in params) or (params['multifileprefix'] is None):
            raise ValueError("Missing the required parameter `multifileprefix` when calling `post_scene_to_file`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'multifileprefix' in params:
            query_params.append(('multifileprefix', params['multifileprefix']))
        if 'newformat' in params:
            query_params.append(('newformat', params['newformat']))
        if 'password' in params:
            query_params.append(('password', params['password']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/extract/scene', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_triangulate_new(self, name, newfilename, newformat, **kwargs):
        """
        Triangulate whole file and save to the different file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_triangulate_new(name, newfilename, newformat, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The file's mame (required)
        :param str newfilename: The new file's mame (required)
        :param str newformat: The new file's format (required)
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_triangulate_new_with_http_info(name, newfilename, newformat, **kwargs)
        else:
            (data) = self.post_triangulate_new_with_http_info(name, newfilename, newformat, **kwargs)
            return data

    def post_triangulate_new_with_http_info(self, name, newfilename, newformat, **kwargs):
        """
        Triangulate whole file and save to the different file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_triangulate_new_with_http_info(name, newfilename, newformat, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The file's mame (required)
        :param str newfilename: The new file's mame (required)
        :param str newformat: The new file's format (required)
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'newfilename', 'newformat', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_triangulate_new" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_triangulate_new`")
        # verify the required parameter 'newfilename' is set
        if ('newfilename' not in params) or (params['newfilename'] is None):
            raise ValueError("Missing the required parameter `newfilename` when calling `post_triangulate_new`")
        # verify the required parameter 'newformat' is set
        if ('newformat' not in params) or (params['newformat'] is None):
            raise ValueError("Missing the required parameter `newformat` when calling `post_triangulate_new`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'newfilename' in params:
            query_params.append(('newfilename', params['newfilename']))
        if 'newformat' in params:
            query_params.append(('newformat', params['newformat']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/triangulate/new', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_triangulate_original(self, name, **kwargs):
        """
        Triangulate whole file and save to original file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_triangulate_original(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The file's mame (required)
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_triangulate_original_with_http_info(name, **kwargs)
        else:
            (data) = self.post_triangulate_original_with_http_info(name, **kwargs)
            return data

    def post_triangulate_original_with_http_info(self, name, **kwargs):
        """
        Triangulate whole file and save to original file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_triangulate_original_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The file's mame (required)
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_triangulate_original" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_triangulate_original`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/triangulate/original', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_triangulate_part(self, name, objectaddressingpath, newfilename, newformat, **kwargs):
        """
        Triangulate part of the scene(Specified by OAP) and save the scene to different file 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_triangulate_part(name, objectaddressingpath, newfilename, newformat, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The file's mame (required)
        :param str objectaddressingpath: The node or mesh getted by OAP. (required)
        :param str newfilename: The new file's mame (required)
        :param str newformat: The new file's format (required)
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_triangulate_part_with_http_info(name, objectaddressingpath, newfilename, newformat, **kwargs)
        else:
            (data) = self.post_triangulate_part_with_http_info(name, objectaddressingpath, newfilename, newformat, **kwargs)
            return data

    def post_triangulate_part_with_http_info(self, name, objectaddressingpath, newfilename, newformat, **kwargs):
        """
        Triangulate part of the scene(Specified by OAP) and save the scene to different file 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_triangulate_part_with_http_info(name, objectaddressingpath, newfilename, newformat, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: The file's mame (required)
        :param str objectaddressingpath: The node or mesh getted by OAP. (required)
        :param str newfilename: The new file's mame (required)
        :param str newformat: The new file's format (required)
        :param str folder: The folder for source file
        :param str storage: The storage type
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'objectaddressingpath', 'newfilename', 'newformat', 'folder', 'storage']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_triangulate_part" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `post_triangulate_part`")
        # verify the required parameter 'objectaddressingpath' is set
        if ('objectaddressingpath' not in params) or (params['objectaddressingpath'] is None):
            raise ValueError("Missing the required parameter `objectaddressingpath` when calling `post_triangulate_part`")
        # verify the required parameter 'newfilename' is set
        if ('newfilename' not in params) or (params['newfilename'] is None):
            raise ValueError("Missing the required parameter `newfilename` when calling `post_triangulate_part`")
        # verify the required parameter 'newformat' is set
        if ('newformat' not in params) or (params['newformat'] is None):
            raise ValueError("Missing the required parameter `newformat` when calling `post_triangulate_part`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))
        if 'objectaddressingpath' in params:
            query_params.append(('objectaddressingpath', params['objectaddressingpath']))
        if 'newfilename' in params:
            query_params.append(('newfilename', params['newfilename']))
        if 'newformat' in params:
            query_params.append(('newformat', params['newformat']))
        if 'folder' in params:
            query_params.append(('folder', params['folder']))
        if 'storage' in params:
            query_params.append(('storage', params['storage']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/triangulate/part', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='file',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def storage_exists(self, storage_name, **kwargs):
        """
        Check if storage exists
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.storage_exists(storage_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str storage_name: Storage name (required)
        :return: StorageExist
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.storage_exists_with_http_info(storage_name, **kwargs)
        else:
            (data) = self.storage_exists_with_http_info(storage_name, **kwargs)
            return data

    def storage_exists_with_http_info(self, storage_name, **kwargs):
        """
        Check if storage exists
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.storage_exists_with_http_info(storage_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str storage_name: Storage name (required)
        :return: StorageExist
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method storage_exists" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storage_name' is set
        if ('storage_name' not in params) or (params['storage_name'] is None):
            raise ValueError("Missing the required parameter `storage_name` when calling `storage_exists`")


        collection_formats = {}

        path_params = {}
        if 'storage_name' in params:
            path_params['storageName'] = params['storage_name']

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/{storageName}/exist', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='StorageExist',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def upload_file(self, path, file, **kwargs):
        """
        Upload file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_file(path, file, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Path where to upload including filename and extension e.g. /file.ext or /Folder 1/file.ext             If the content is multipart and path does not contains the file name it tries to get them from filename parameter             from Content-Disposition header.              (required)
        :param file file: File to upload (required)
        :param str storage_name: Storage name
        :return: FilesUploadResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.upload_file_with_http_info(path, file, **kwargs)
        else:
            (data) = self.upload_file_with_http_info(path, file, **kwargs)
            return data

    def upload_file_with_http_info(self, path, file, **kwargs):
        """
        Upload file
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_file_with_http_info(path, file, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str path: Path where to upload including filename and extension e.g. /file.ext or /Folder 1/file.ext             If the content is multipart and path does not contains the file name it tries to get them from filename parameter             from Content-Disposition header.              (required)
        :param file file: File to upload (required)
        :param str storage_name: Storage name
        :return: FilesUploadResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['path', 'file', 'storage_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if ('path' not in params) or (params['path'] is None):
            raise ValueError("Missing the required parameter `path` when calling `upload_file`")
        # verify the required parameter 'file' is set
        if ('file' not in params) or (params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `upload_file`")


        collection_formats = {}

        path_params = {}
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = []
        if 'storage_name' in params:
            query_params.append(('storageName', params['storage_name']))

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['File'] = params['file']

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = ['JWT']

        return self.api_client.call_api('/3d/storage/file/{path}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FilesUploadResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
