# Generated by Django 2.0.3 on 2019-03-21 21:21

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import simple_history.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('payer_source_system', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='CXSemanticDataKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('semantic_key', models.TextField(unique=True)),
                ('display_name', models.TextField()),
                ('description', models.TextField()),
                ('key_value_type', models.TextField(choices=[('string', 'string'), ('numeric', 'numeric'), ('date', 'date'), ('datetime', 'datetime'), ('object', 'object'), ('list', 'list'), ('decimal', 'decimal'), ('boolean', 'boolean')])),
            ],
            options={
                'db_table': 'cx_semantic_data_key',
            },
        ),
        migrations.CreateModel(
            name='CXSemanticEventKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('semantic_key', models.TextField(unique=True)),
                ('display_name', models.TextField()),
                ('description', models.TextField()),
                ('why_captured', models.TextField()),
                ('is_primary_feature_key', models.BooleanField()),
                ('event_object', models.TextField()),
                ('event_action', models.TextField()),
                ('feature', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='payer_source_system.CXProductFeature')),
            ],
            options={
                'db_table': 'cx_semantic_event_key',
            },
        ),
        migrations.CreateModel(
            name='HistoricalCXSemanticDataKey',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('semantic_key', models.TextField(db_index=True)),
                ('display_name', models.TextField()),
                ('description', models.TextField()),
                ('key_value_type', models.TextField(choices=[('string', 'string'), ('numeric', 'numeric'), ('date', 'date'), ('datetime', 'datetime'), ('object', 'object'), ('list', 'list'), ('decimal', 'decimal'), ('boolean', 'boolean')])),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical cx semantic data key',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_cx_semantic_data_key',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalCXSemanticEventKey',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('semantic_key', models.TextField(db_index=True)),
                ('display_name', models.TextField()),
                ('description', models.TextField()),
                ('why_captured', models.TextField()),
                ('is_primary_feature_key', models.BooleanField()),
                ('event_object', models.TextField()),
                ('event_action', models.TextField()),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('feature', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.CXProductFeature')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical cx semantic event key',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_cx_semantic_event_key',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPayerConsumerDataKey',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('key_value_type', models.TextField(choices=[('string', 'string'), ('numeric', 'numeric'), ('date', 'date'), ('datetime', 'datetime'), ('object', 'object'), ('list', 'list'), ('decimal', 'decimal'), ('boolean', 'boolean')])),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('configuration', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.PayerSourceSystem')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('semantic_data_key', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='semantic_key_registry.CXSemanticDataKey')),
            ],
            options={
                'verbose_name': 'historical payer consumer data key',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_payer_consumer_data_key',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPayerConsumerEventDataKey',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('key_value_type', models.TextField(choices=[('string', 'string'), ('numeric', 'numeric'), ('date', 'date'), ('datetime', 'datetime'), ('object', 'object'), ('list', 'list'), ('decimal', 'decimal'), ('boolean', 'boolean')])),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('configuration', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.PayerSourceSystem')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('semantic_event_key', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='semantic_key_registry.CXSemanticEventKey')),
            ],
            options={
                'verbose_name': 'historical payer consumer event data key',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_payer_consumer_event_data_key',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPayerConsumerEventKey',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('configuration', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.PayerSourceSystem')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('semantic_event_key', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='semantic_key_registry.CXSemanticEventKey')),
            ],
            options={
                'verbose_name': 'historical payer consumer event key',
                'get_latest_by': 'history_date',
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_payer_consumer_event_key',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='PayerConsumerDataKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('key_value_type', models.TextField(choices=[('string', 'string'), ('numeric', 'numeric'), ('date', 'date'), ('datetime', 'datetime'), ('object', 'object'), ('list', 'list'), ('decimal', 'decimal'), ('boolean', 'boolean')])),
                ('configuration', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='payer_source_system.PayerSourceSystem')),
                ('semantic_data_key', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='semantic_key_registry.CXSemanticDataKey')),
            ],
            options={
                'db_table': 'payer_consumer_data_key',
            },
        ),
        migrations.CreateModel(
            name='PayerConsumerEventDataKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('key_value_type', models.TextField(choices=[('string', 'string'), ('numeric', 'numeric'), ('date', 'date'), ('datetime', 'datetime'), ('object', 'object'), ('list', 'list'), ('decimal', 'decimal'), ('boolean', 'boolean')])),
                ('configuration', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='payer_source_system.PayerSourceSystem')),
                ('semantic_event_key', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='semantic_key_registry.CXSemanticEventKey')),
            ],
            options={
                'db_table': 'payer_consumer_event_data_key',
            },
        ),
        migrations.CreateModel(
            name='PayerConsumerEventKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('configuration', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='payer_source_system.PayerSourceSystem')),
                ('semantic_event_key', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='semantic_key_registry.CXSemanticEventKey')),
            ],
            options={
                'db_table': 'payer_consumer_event_key',
            },
        ),
        migrations.AlterUniqueTogether(
            name='payerconsumereventkey',
            unique_together={('semantic_event_key', 'configuration')},
        ),
        migrations.AlterUniqueTogether(
            name='payerconsumereventdatakey',
            unique_together={('semantic_event_key', 'configuration')},
        ),
        migrations.AlterUniqueTogether(
            name='payerconsumerdatakey',
            unique_together={('semantic_data_key', 'configuration')},
        ),
    ]
