# Generated by Django 2.0.3 on 2019-03-21 21:21

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import simple_history.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('payer_source_system', '0001_initial'),
        ('semantic_key_registry', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='CXProposition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('operator', models.TextField(choices=[('==', 'equal to'), ('!=', 'not equal to'), ('is', 'is'), ('is not', 'is not'), ('>', 'greater than'), ('>=', 'greater than or equal to'), ('<', 'less than'), ('<=', 'less than or equal to'), ('in', 'in'), ('not in', 'not in')])),
                ('predicate_val', models.TextField(blank=True, null=True)),
                ('argument_attribute', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='proposition_to_semantic_data_key', to='semantic_key_registry.CXSemanticDataKey')),
            ],
            options={
                'db_table': 'cx_proposition',
            },
        ),
        migrations.CreateModel(
            name='CXRuleAction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('display_name', models.TextField(unique=True)),
                ('description', models.TextField()),
                ('rule_action_type', models.TextField(choices=[('cohort', 'cohort'), ('goal', 'goal'), ('recommendation', 'recommendation'), ('inference', 'inference'), ('aggregation', 'aggregation'), ('workflow', 'workflow')])),
            ],
            options={
                'db_table': 'cx_rule_action',
            },
        ),
        migrations.CreateModel(
            name='HistoricalPayerRule',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('start', models.DateTimeField(null=True)),
                ('termination', models.DateTimeField(null=True)),
                ('name', models.TextField(blank=True, null=True)),
                ('description', models.TextField()),
                ('prop_chain', models.TextField()),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('payer', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.CXPayer')),
                ('rule_action', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='rule_sets.CXRuleAction')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_cx_rule',
                'get_latest_by': 'history_date',
                'verbose_name': 'historical payer rule',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPayerRuleSet',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('start', models.DateTimeField(null=True)),
                ('termination', models.DateTimeField(null=True)),
                ('name', models.TextField()),
                ('description', models.TextField()),
                ('rule_set_type', models.TextField(choices=[('cohort', 'cohort'), ('goal', 'goal'), ('recommendation', 'recommendation'), ('inference', 'inference'), ('aggregation', 'aggregation'), ('workflow', 'workflow')])),
                ('pre_process_id', models.TextField()),
                ('post_process_id', models.TextField()),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('payer', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.CXPayer')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_payer_rule_set',
                'get_latest_by': 'history_date',
                'verbose_name': 'historical payer rule set',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPayerRuleSetRuleSequence',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('sequence', models.IntegerField()),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('payer', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.CXPayer')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_payer_rule_set_rule_sequence',
                'get_latest_by': 'history_date',
                'verbose_name': 'historical payer rule set rule sequence',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalTrigger',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('payer', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.CXPayer')),
                ('semantic_event_key', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='semantic_key_registry.CXSemanticEventKey')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_trigger',
                'get_latest_by': 'history_date',
                'verbose_name': 'historical trigger',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalTriggerRuleSet',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'db_table': 'simplehistory_trigger_rule_set',
                'get_latest_by': 'history_date',
                'verbose_name': 'historical trigger rule set',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='PayerRule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('start', models.DateTimeField(null=True)),
                ('termination', models.DateTimeField(null=True)),
                ('name', models.TextField(blank=True, null=True)),
                ('description', models.TextField()),
                ('prop_chain', models.TextField()),
                ('payer', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='payer_source_system.CXPayer')),
                ('rule_action', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='rule_to_rule_action', to='rule_sets.CXRuleAction')),
            ],
            options={
                'db_table': 'payer_rule',
            },
        ),
        migrations.CreateModel(
            name='PayerRuleSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('start', models.DateTimeField(null=True)),
                ('termination', models.DateTimeField(null=True)),
                ('name', models.TextField()),
                ('description', models.TextField()),
                ('rule_set_type', models.TextField(choices=[('cohort', 'cohort'), ('goal', 'goal'), ('recommendation', 'recommendation'), ('inference', 'inference'), ('aggregation', 'aggregation'), ('workflow', 'workflow')])),
                ('pre_process_id', models.TextField()),
                ('post_process_id', models.TextField()),
            ],
            options={
                'db_table': 'payer_rule_set',
            },
        ),
        migrations.CreateModel(
            name='PayerRuleSetRuleSequence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('sequence', models.IntegerField()),
                ('payer', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='payer_source_system.CXPayer')),
                ('rule', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='rule_sequence_to_rule', to='rule_sets.PayerRule')),
                ('rule_set', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='rule_sequence_to_rule_set', to='rule_sets.PayerRuleSet')),
            ],
            options={
                'db_table': 'payer_rule_set_rule_sequence',
            },
        ),
        migrations.CreateModel(
            name='Trigger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('payer', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='payer_source_system.CXPayer')),
                ('semantic_event_key', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='semantic_event_key_to_trigger', to='semantic_key_registry.CXSemanticEventKey')),
            ],
            options={
                'db_table': 'cx_trigger',
            },
        ),
        migrations.CreateModel(
            name='TriggerRuleSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('rule_set', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='trigger_to_rule_set', to='rule_sets.PayerRuleSet')),
                ('trigger', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='trigger_rule_set_to_trigger', to='rule_sets.Trigger')),
            ],
            options={
                'db_table': 'cx_trigger_rule_set',
            },
        ),
        migrations.AddField(
            model_name='payerruleset',
            name='ordered_rules',
            field=models.ManyToManyField(through='rule_sets.PayerRuleSetRuleSequence', to='rule_sets.PayerRule'),
        ),
        migrations.AddField(
            model_name='payerruleset',
            name='payer',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='payer_source_system.CXPayer'),
        ),
        migrations.AddField(
            model_name='historicaltriggerruleset',
            name='rule_set',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='rule_sets.PayerRuleSet'),
        ),
        migrations.AddField(
            model_name='historicaltriggerruleset',
            name='trigger',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='rule_sets.Trigger'),
        ),
        migrations.AddField(
            model_name='historicalpayerrulesetrulesequence',
            name='rule',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='rule_sets.PayerRule'),
        ),
        migrations.AddField(
            model_name='historicalpayerrulesetrulesequence',
            name='rule_set',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='rule_sets.PayerRuleSet'),
        ),
        migrations.AlterUniqueTogether(
            name='trigger',
            unique_together={('payer', 'semantic_event_key')},
        ),
        migrations.AlterUniqueTogether(
            name='payerrulesetrulesequence',
            unique_together={('rule_set', 'rule')},
        ),
    ]
