# Generated by Django 2.0.3 on 2019-03-21 15:12

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import simple_history.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='CXPayer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('name', models.TextField(unique=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'db_table': 'cx_payer',
            },
        ),
        migrations.CreateModel(
            name='CXProduct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('name', models.TextField(unique=True)),
                ('description', models.TextField(null=True)),
            ],
            options={
                'db_table': 'cx_product',
            },
        ),
        migrations.CreateModel(
            name='CXProductFeature',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('master_feature', models.TextField()),
                ('feature', models.TextField()),
                ('product', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='payer_source_system.CXProduct')),
            ],
            options={
                'db_table': 'cx_product_feature',
            },
        ),
        migrations.CreateModel(
            name='HistoricalCXProductFeature',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('master_feature', models.TextField()),
                ('feature', models.TextField()),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('product', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.CXProduct')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical cx product feature',
                'db_table': 'simplehistory_cx_product_feature',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPayerSourceSystem',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, editable=False)),
                ('last_updated', models.DateTimeField(blank=True, editable=False)),
                ('description', models.TextField(null=True)),
                ('source_system_name', models.TextField(db_index=True, null=True)),
                ('is_active', models.BooleanField(default=False)),
                ('system_type', models.TextField(choices=[('back_office', 'back_office'), ('consumer_facing', 'consumer_facing')], null=True)),
                ('consumer_type', models.TextField(choices=[('member', 'member'), ('broker', 'broker'), ('lead', 'lead'), ('employee', 'employee'), ('provider', 'provider')], null=True)),
                ('referrer_url', models.TextField(null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('payer', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.CXPayer')),
                ('product', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='payer_source_system.CXProduct')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical payer source system',
                'db_table': 'simplehistory_payer_source_system',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='PayerSourceSystem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('description', models.TextField(null=True)),
                ('source_system_name', models.TextField(null=True, unique=True)),
                ('is_active', models.BooleanField(default=False)),
                ('system_type', models.TextField(choices=[('back_office', 'back_office'), ('consumer_facing', 'consumer_facing')], null=True)),
                ('consumer_type', models.TextField(choices=[('member', 'member'), ('broker', 'broker'), ('lead', 'lead'), ('employee', 'employee'), ('provider', 'provider')], null=True)),
                ('referrer_url', models.TextField(null=True)),
                ('payer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='payer', to='payer_source_system.CXPayer')),
                ('product', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='product', to='payer_source_system.CXProduct')),
            ],
            options={
                'db_table': 'payer_source_system',
            },
        ),
        migrations.AlterUniqueTogether(
            name='cxproductfeature',
            unique_together={('master_feature', 'feature')},
        ),
    ]
