"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const database_secret_1 = require("./database-secret");
const database_query_1 = require("./private/database-query");
const handler_name_1 = require("./private/database-query-provider/handler-name");
const privileges_1 = require("./private/privileges");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const constructs_1 = require("constructs");
class UserBase extends constructs_1.Construct {
    /**
     * (experimental) Grant this user privilege to access a table.
     *
     * @experimental
     */
    addTablePrivileges(table, ...actions) {
        if (!this.privileges) {
            this.privileges = new privileges_1.UserTablePrivileges(this, 'TablePrivileges', {
                ...this.databaseProps,
                user: this,
            });
        }
        this.privileges.addPrivileges(table, ...actions);
    }
}
/**
 * (experimental) A user in a Redshift cluster.
 *
 * @experimental
 */
class User extends UserBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.databaseProps = props;
        this.cluster = props.cluster;
        this.databaseName = props.databaseName;
        const username = (_b = props.username) !== null && _b !== void 0 ? _b : cdk.Names.uniqueId(this).toLowerCase();
        const secret = new database_secret_1.DatabaseSecret(this, 'Secret', {
            username,
            encryptionKey: props.encryptionKey,
        });
        const attachedSecret = secret.attach(props.cluster);
        this.password = attachedSecret.secretValueFromJson('password');
        this.resource = new database_query_1.DatabaseQuery(this, 'Resource', {
            ...this.databaseProps,
            handler: handler_name_1.HandlerName.User,
            properties: {
                username,
                passwordSecretArn: attachedSecret.secretArn,
            },
        });
        attachedSecret.grantRead(this.resource);
        this.username = this.resource.getAttString('username');
    }
    /**
     * (experimental) Specify a Redshift user using credentials that already exist.
     *
     * @experimental
     */
    static fromUserAttributes(scope, id, attrs) {
        return new class extends UserBase {
            constructor() {
                super(...arguments);
                this.username = attrs.username;
                this.password = attrs.password;
                this.cluster = attrs.cluster;
                this.databaseName = attrs.databaseName;
                this.databaseProps = attrs;
            }
        }(scope, id);
    }
    /**
     * (experimental) Apply the given removal policy to this resource.
     *
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     *
     * The resource can be destroyed (`RemovalPolicy.DESTROY`), or left in your AWS
     * account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).
     *
     * This resource is destroyed by default.
     *
     * @experimental
     */
    applyRemovalPolicy(policy) {
        this.resource.applyRemovalPolicy(policy);
    }
}
exports.User = User;
_a = JSII_RTTI_SYMBOL_1;
User[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.User", version: "2.0.0-alpha.7" };
//# sourceMappingURL=data:application/json;base64,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