/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.ResultSet;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.pgsimple.common.BaseTableReader;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityMapper;

public class EntityTableReader<T extends Entity>
extends BaseTableReader<T> {
    private EntityMapper<T> entityMapper;
    private String sql;

    public EntityTableReader(DatabaseContext dbCtx, EntityMapper<T> entityBuilder) {
        super(dbCtx);
        this.entityMapper = entityBuilder;
        this.sql = entityBuilder.getSqlSelect(false, false) + " ORDER BY e.id";
    }

    public EntityTableReader(DatabaseContext dbCtx, EntityMapper<T> entityBuilder, String constraintTable) {
        super(dbCtx);
        this.entityMapper = entityBuilder;
        this.sql = entityBuilder.getSqlSelect(false, false) + " INNER JOIN " + constraintTable + " c ON e.id = c.id ORDER BY e.id";
    }

    @Override
    protected ResultSet createResultSet(DatabaseContext queryDbCtx) {
        return queryDbCtx.executeQuery(this.sql);
    }

    @Override
    protected BaseTableReader.ReadResult<T> createNextValue(ResultSet resultSet) {
        T entity = this.entityMapper.parseRecord(resultSet);
        return new BaseTableReader.ReadResult<T>(true, entity);
    }
}

