/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.pipeline.common;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.common.Task;

public class PipeTasks {
    private static final Logger LOG = Logger.getLogger(PipeTasks.class.getName());
    private Map<String, Task> namedTasks = new HashMap<String, Task>();
    private Deque<Task> defaultTasks = new ArrayDeque<Task>();

    public void putTask(String taskId, String pipeName, Task task) {
        if (this.namedTasks.containsKey(pipeName)) {
            throw new OsmosisRuntimeException("Task " + taskId + " cannot write to pipe " + pipeName + " because the pipe is already being written to.");
        }
        this.namedTasks.put(pipeName, task);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Task \"" + taskId + "\" produced pipe \"" + pipeName + "\"");
        }
    }

    public void putTask(String taskId, Task task) {
        this.defaultTasks.push(task);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Task \"" + taskId + "\" produced unnamed pipe stored at level " + this.defaultTasks.size() + " in the default pipe stack.");
        }
    }

    private boolean verifyPipeType(Class<? extends Task> requiredTaskType, Task task) {
        return requiredTaskType.isInstance(task);
    }

    public Task retrieveTask(String taskId, String pipeName, Class<? extends Task> requiredTaskType) {
        if (!this.namedTasks.containsKey(pipeName)) {
            throw new OsmosisRuntimeException("No pipe named " + pipeName + " is available as input for task " + taskId + ".");
        }
        Task task = this.namedTasks.remove(pipeName);
        if (!this.verifyPipeType(requiredTaskType, task)) {
            throw new OsmosisRuntimeException("Task " + taskId + " does not support data provided by input pipe " + pipeName + ".");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Task \"" + taskId + "\" consumed pipe \"" + pipeName + "\"");
        }
        return task;
    }

    public Task retrieveTask(String taskId, Class<? extends Task> requiredTaskType) {
        int defaultTaskCount = this.defaultTasks.size();
        if (defaultTaskCount == 0) {
            throw new OsmosisRuntimeException("No default pipes are available as input for task " + taskId + ".");
        }
        Task task = this.defaultTasks.pop();
        if (!this.verifyPipeType(requiredTaskType, task)) {
            throw new OsmosisRuntimeException("Task " + taskId + " does not support data provided by default pipe stored at level " + (this.defaultTasks.size() + 1) + " in the default pipe stack.");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Task \"" + taskId + "\" consumed unnamed pipe stored at level " + defaultTaskCount + " in the default pipe stack.");
        }
        return task;
    }

    public int size() {
        return this.namedTasks.size() + this.defaultTasks.size();
    }

    public int defaultTaskSize() {
        return this.defaultTasks.size();
    }

    public Set<String> getPipeNames() {
        return this.namedTasks.keySet();
    }
}

