/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;

public final class LatLongUtils {
    public static final double EQUATORIAL_RADIUS = 6378137.0;
    public static final double INVERSE_FLATTENING = 298.257223563;
    public static final double POLAR_RADIUS = 6356752.3142;
    public static final double LATITUDE_MAX = 90.0;
    public static final double LATITUDE_MIN = -90.0;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double LONGITUDE_MIN = -180.0;
    private static final double CONVERSION_FACTOR = 1000000.0;
    private static final String DELIMITER = ",";

    public static boolean contains(LatLong[] latLongs, LatLong latLong) {
        boolean result = false;
        int i = 0;
        int j = latLongs.length - 1;
        while (i < latLongs.length) {
            if (latLongs[i].latitude > latLong.latitude != latLongs[j].latitude > latLong.latitude && latLong.longitude < (latLongs[j].longitude - latLongs[i].longitude) * (latLong.latitude - latLongs[i].latitude) / (latLongs[j].latitude - latLongs[i].latitude) + latLongs[i].longitude) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public static boolean contains(List<LatLong> latLongs, LatLong latLong) {
        boolean result = false;
        int i = 0;
        int j = latLongs.size() - 1;
        while (i < latLongs.size()) {
            if (latLongs.get((int)i).latitude > latLong.latitude != latLongs.get((int)j).latitude > latLong.latitude && latLong.longitude < (latLongs.get((int)j).longitude - latLongs.get((int)i).longitude) * (latLong.latitude - latLongs.get((int)i).latitude) / (latLongs.get((int)j).latitude - latLongs.get((int)i).latitude) + latLongs.get((int)i).longitude) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public static int degreesToMicrodegrees(double coordinate) {
        return (int)(coordinate * 1000000.0);
    }

    public static LatLong destinationPoint(LatLong start, double distance, float bearing) {
        double theta = Math.toRadians(bearing);
        double delta = distance / 6378137.0;
        double phi1 = Math.toRadians(start.latitude);
        double lambda1 = Math.toRadians(start.longitude);
        double phi2 = Math.asin(Math.sin(phi1) * Math.cos(delta) + Math.cos(phi1) * Math.sin(delta) * Math.cos(theta));
        double lambda2 = lambda1 + Math.atan2(Math.sin(theta) * Math.sin(delta) * Math.cos(phi1), Math.cos(delta) - Math.sin(phi1) * Math.sin(phi2));
        return new LatLong(Math.toDegrees(phi2), Math.toDegrees(lambda2));
    }

    public static double distance(LatLong latLong1, LatLong latLong2) {
        return Math.hypot(latLong1.longitude - latLong2.longitude, latLong1.latitude - latLong2.latitude);
    }

    public static double distanceSegmentPoint(double startX, double startY, double endX, double endY, double pointX, double pointY) {
        Point nearest = LatLongUtils.nearestSegmentPoint(startX, startY, endX, endY, pointX, pointY);
        return Math.hypot(nearest.x - pointX, nearest.y - pointY);
    }

    public static LatLong fromString(String latLongString) {
        double[] coordinates = LatLongUtils.parseCoordinateString(latLongString, 2);
        return new LatLong(coordinates[0], coordinates[1]);
    }

    public static boolean isClosedWay(LatLong[] latLongs) {
        return latLongs[0].distance(latLongs[latLongs.length - 1]) < 1.0E-9;
    }

    public static double latitudeDistance(int meters) {
        return (double)(meters * 360) / 4.007501668557849E7;
    }

    public static double longitudeDistance(int meters, double latitude) {
        return (double)(meters * 360) / (4.007501668557849E7 * Math.cos(Math.toRadians(latitude)));
    }

    public static double microdegreesToDegrees(int coordinate) {
        return (double)coordinate / 1000000.0;
    }

    public static Point nearestSegmentPoint(double startX, double startY, double endX, double endY, double pointX, double pointY) {
        double xDiff = endX - startX;
        double yDiff = endY - startY;
        double length2 = xDiff * xDiff + yDiff * yDiff;
        if (length2 == 0.0) {
            return new Point(startX, startY);
        }
        double t = ((pointX - startX) * (endX - startX) + (pointY - startY) * (endY - startY)) / length2;
        if (t < 0.0) {
            return new Point(startX, startY);
        }
        if (t > 1.0) {
            return new Point(endX, endY);
        }
        return new Point(startX + t * (endX - startX), startY + t * (endY - startY));
    }

    public static double[] parseCoordinateString(String coordinatesString, int numberOfCoordinates) {
        StringTokenizer stringTokenizer = new StringTokenizer(coordinatesString, DELIMITER, true);
        boolean isDelimiter = true;
        ArrayList<String> tokens = new ArrayList<String>(numberOfCoordinates);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            boolean bl = isDelimiter = !isDelimiter;
            if (isDelimiter) continue;
            tokens.add(token);
        }
        if (isDelimiter) {
            throw new IllegalArgumentException("invalid coordinate delimiter: " + coordinatesString);
        }
        if (tokens.size() != numberOfCoordinates) {
            throw new IllegalArgumentException("invalid number of coordinate values: " + coordinatesString);
        }
        double[] coordinates = new double[numberOfCoordinates];
        for (int i = 0; i < numberOfCoordinates; ++i) {
            coordinates[i] = Double.parseDouble((String)tokens.get(i));
        }
        return coordinates;
    }

    public static double sphericalDistance(LatLong latLong1, LatLong latLong2) {
        double dLat = Math.toRadians(latLong2.latitude - latLong1.latitude);
        double dLon = Math.toRadians(latLong2.longitude - latLong1.longitude);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(latLong1.latitude)) * Math.cos(Math.toRadians(latLong2.latitude)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return c * 6378137.0;
    }

    public static double validateLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude: " + latitude);
        }
        return latitude;
    }

    public static double validateLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude: " + longitude);
        }
        return longitude;
    }

    public static double vincentyDistance(LatLong latLong1, LatLong latLong2) {
        double lambdaP;
        double C2;
        double f = 0.0033528106647474805;
        double L = Math.toRadians(latLong2.getLongitude() - latLong1.getLongitude());
        double U1 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(latLong1.getLatitude())));
        double U2 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(latLong2.getLatitude())));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double iterLimit = 100.0;
        double cosSqAlpha = 0.0;
        double sinSigma = 0.0;
        double cosSigma = 0.0;
        double cos2SigmaM = 0.0;
        double sigma = 0.0;
        double sinLambda = 0.0;
        double sinAlpha = 0.0;
        double cosLambda = 0.0;
        do {
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) != 0.0) continue;
            return 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C2 = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha)))) * f * sinAlpha * ((sigma = Math.atan2(sinSigma, cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda)) + C2 * sinSigma * ((cos2SigmaM = (cosSqAlpha = 1.0 - (sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma) * sinAlpha) != 0.0 ? cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha : 0.0) + C2 * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
        if (iterLimit == 0.0) {
            return 0.0;
        }
        double uSq = cosSqAlpha * (Math.pow(6378137.0, 2.0) - Math.pow(6356752.3142, 2.0)) / Math.pow(6356752.3142, 2.0);
        double A2 = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        double s2 = 6356752.3142 * A2 * (sigma - deltaSigma);
        return s2;
    }

    public static byte zoomForBounds(Dimension dimension, BoundingBox boundingBox, int tileSize) {
        double pixelYMin;
        double pixelYMax;
        double zoomY;
        double pixelXMin;
        long mapSize = MercatorProjection.getMapSize((byte)0, tileSize);
        double pixelXMax = MercatorProjection.longitudeToPixelX(boundingBox.maxLongitude, mapSize);
        double zoomX = -Math.log(Math.abs(pixelXMax - (pixelXMin = MercatorProjection.longitudeToPixelX(boundingBox.minLongitude, mapSize))) / (double)dimension.width) / Math.log(2.0);
        double zoom = Math.floor(Math.min(zoomX, zoomY = -Math.log(Math.abs((pixelYMax = MercatorProjection.latitudeToPixelY(boundingBox.maxLatitude, mapSize)) - (pixelYMin = MercatorProjection.latitudeToPixelY(boundingBox.minLatitude, mapSize))) / (double)dimension.height) / Math.log(2.0)));
        if (zoom < 0.0) {
            return 0;
        }
        if (zoom > 127.0) {
            return 127;
        }
        return (byte)zoom;
    }

    private LatLongUtils() {
        throw new IllegalStateException();
    }
}

