/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.common;

import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.common.CompressionMethodDeriver;

public abstract class XmlTaskManagerFactory
extends TaskManagerFactory {
    private static final String ARG_COMPRESSION_METHOD = "compressionMethod";
    private static final String ARG_ENCODING_HACK = "encodingHack";
    private static final boolean DEFAULT_ENCODING_HACK = false;

    protected CompressionMethod getCompressionMethodArgument(TaskConfiguration taskConfig, String fileName) {
        CompressionMethod result;
        String rawValue = this.getStringArgument(taskConfig, ARG_COMPRESSION_METHOD, "auto").toLowerCase();
        if ("none".equals(rawValue)) {
            result = CompressionMethod.None;
        } else if ("gzip".equals(rawValue)) {
            result = CompressionMethod.GZip;
        } else if ("bzip2".equals(rawValue)) {
            result = CompressionMethod.BZip2;
        } else if ("auto".equals(rawValue)) {
            result = new CompressionMethodDeriver().deriveCompressionMethod(fileName);
        } else {
            throw new OsmosisRuntimeException("Argument compressionMethod for task " + taskConfig.getId() + " must be one of none, gzip, bzip2 or auto.");
        }
        return result;
    }

    protected boolean getProdEncodingHackArgument(TaskConfiguration taskConfig) {
        return this.getBooleanArgument(taskConfig, ARG_ENCODING_HACK, false);
    }
}

