# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ContactChannelTargetInfo',
    'ContactContactTargetInfo',
    'ContactStage',
    'ContactTargets',
]

@pulumi.output_type
class ContactChannelTargetInfo(dict):
    """
    Information about the contact channel that SSM Incident Manager uses to engage the contact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelId":
            suggest = "channel_id"
        elif key == "retryIntervalInMinutes":
            suggest = "retry_interval_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactChannelTargetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactChannelTargetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactChannelTargetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_id: str,
                 retry_interval_in_minutes: int):
        """
        Information about the contact channel that SSM Incident Manager uses to engage the contact.
        :param str channel_id: The Amazon Resource Name (ARN) of the contact channel.
        :param int retry_interval_in_minutes: The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
        """
        pulumi.set(__self__, "channel_id", channel_id)
        pulumi.set(__self__, "retry_interval_in_minutes", retry_interval_in_minutes)

    @property
    @pulumi.getter(name="channelId")
    def channel_id(self) -> str:
        """
        The Amazon Resource Name (ARN) of the contact channel.
        """
        return pulumi.get(self, "channel_id")

    @property
    @pulumi.getter(name="retryIntervalInMinutes")
    def retry_interval_in_minutes(self) -> int:
        """
        The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
        """
        return pulumi.get(self, "retry_interval_in_minutes")


@pulumi.output_type
class ContactContactTargetInfo(dict):
    """
    The contact that SSM Incident Manager is engaging during an incident.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactId":
            suggest = "contact_id"
        elif key == "isEssential":
            suggest = "is_essential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactContactTargetInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactContactTargetInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactContactTargetInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_id: str,
                 is_essential: bool):
        """
        The contact that SSM Incident Manager is engaging during an incident.
        :param str contact_id: The Amazon Resource Name (ARN) of the contact.
        :param bool is_essential: A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        """
        pulumi.set(__self__, "contact_id", contact_id)
        pulumi.set(__self__, "is_essential", is_essential)

    @property
    @pulumi.getter(name="contactId")
    def contact_id(self) -> str:
        """
        The Amazon Resource Name (ARN) of the contact.
        """
        return pulumi.get(self, "contact_id")

    @property
    @pulumi.getter(name="isEssential")
    def is_essential(self) -> bool:
        """
        A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
        """
        return pulumi.get(self, "is_essential")


@pulumi.output_type
class ContactStage(dict):
    """
    A set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInMinutes":
            suggest = "duration_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactStage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactStage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactStage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_in_minutes: int,
                 targets: Optional[Sequence['outputs.ContactTargets']] = None):
        """
        A set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.
        :param int duration_in_minutes: The time to wait until beginning the next stage.
        :param Sequence['ContactTargets'] targets: The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        pulumi.set(__self__, "duration_in_minutes", duration_in_minutes)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter(name="durationInMinutes")
    def duration_in_minutes(self) -> int:
        """
        The time to wait until beginning the next stage.
        """
        return pulumi.get(self, "duration_in_minutes")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.ContactTargets']]:
        """
        The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class ContactTargets(dict):
    """
    The contacts or contact methods that the escalation plan or engagement plan is engaging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "channelTargetInfo":
            suggest = "channel_target_info"
        elif key == "contactTargetInfo":
            suggest = "contact_target_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 channel_target_info: Optional['outputs.ContactChannelTargetInfo'] = None,
                 contact_target_info: Optional['outputs.ContactContactTargetInfo'] = None):
        """
        The contacts or contact methods that the escalation plan or engagement plan is engaging.
        """
        if channel_target_info is not None:
            pulumi.set(__self__, "channel_target_info", channel_target_info)
        if contact_target_info is not None:
            pulumi.set(__self__, "contact_target_info", contact_target_info)

    @property
    @pulumi.getter(name="channelTargetInfo")
    def channel_target_info(self) -> Optional['outputs.ContactChannelTargetInfo']:
        return pulumi.get(self, "channel_target_info")

    @property
    @pulumi.getter(name="contactTargetInfo")
    def contact_target_info(self) -> Optional['outputs.ContactContactTargetInfo']:
        return pulumi.get(self, "contact_target_info")


