# coding: utf-8

"""
    LMK API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, Field, StrictStr, validator
from lmk.generated.models.actor_response import ActorResponse
from lmk.generated.models.create_session_request_state import CreateSessionRequestState

class SessionResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    state: CreateSessionRequestState = ...
    session_id: StrictStr = Field(..., alias="sessionId")
    name: StrictStr = ...
    type: StrictStr = ...
    created_at: StrictStr = Field(..., alias="createdAt")
    created_by_actor: ActorResponse = Field(..., alias="createdByActor")
    last_updated_at: StrictStr = Field(..., alias="lastUpdatedAt")
    last_updated_by_actor: ActorResponse = Field(..., alias="lastUpdatedByActor")
    ended_at: Optional[StrictStr] = Field(..., alias="endedAt")
    ended_by_actor: Optional[Any] = Field(..., alias="endedByActor")
    __properties = ["state", "sessionId", "name", "type", "createdAt", "createdByActor", "lastUpdatedAt", "lastUpdatedByActor", "endedAt", "endedByActor"]

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('jupyter', 'process', 'none'):
            raise ValueError("must validate the enum values ('jupyter', 'process', 'none')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SessionResponse:
        """Create an instance of SessionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by_actor
        if self.created_by_actor:
            _dict['createdByActor'] = self.created_by_actor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_updated_by_actor
        if self.last_updated_by_actor:
            _dict['lastUpdatedByActor'] = self.last_updated_by_actor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ended_by_actor
        if self.ended_by_actor:
            _dict['endedByActor'] = self.ended_by_actor.to_dict()
        # set to None if ended_at (nullable) is None
        if self.ended_at is None:
            _dict['endedAt'] = None

        # set to None if ended_by_actor (nullable) is None
        if self.ended_by_actor is None:
            _dict['endedByActor'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SessionResponse:
        """Create an instance of SessionResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SessionResponse.parse_obj(obj)

        _obj = SessionResponse.parse_obj({
            "state": CreateSessionRequestState.from_dict(obj.get("state")) if obj.get("state") is not None else None,
            "session_id": obj.get("sessionId"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "created_at": obj.get("createdAt"),
            "created_by_actor": ActorResponse.from_dict(obj.get("createdByActor")) if obj.get("createdByActor") is not None else None,
            "last_updated_at": obj.get("lastUpdatedAt"),
            "last_updated_by_actor": ActorResponse.from_dict(obj.get("lastUpdatedByActor")) if obj.get("lastUpdatedByActor") is not None else None,
            "ended_at": obj.get("endedAt"),
            "ended_by_actor": ActorResponse.from_dict(obj.get("endedByActor")) if obj.get("endedByActor") is not None else None
        })
        return _obj

