# coding: utf-8

"""
    LMK API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, validator
from lmk.generated.models.actor_response import ActorResponse
from lmk.generated.models.notification_channel_info import NotificationChannelInfo

class EventResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    event_id: StrictStr = Field(..., alias="eventId")
    session_id: Optional[StrictStr] = Field(None, alias="sessionId")
    user_id: StrictStr = Field(..., alias="userId")
    actor: ActorResponse = ...
    message: StrictStr = ...
    content_type: StrictStr = Field(..., alias="contentType")
    channels: List[NotificationChannelInfo] = ...
    created_at: StrictStr = Field(..., alias="createdAt")
    __properties = ["eventId", "sessionId", "userId", "actor", "message", "contentType", "channels", "createdAt"]

    @validator('content_type')
    def content_type_validate_enum(cls, v):
        if v not in ('text/plain', 'text/markdown'):
            raise ValueError("must validate the enum values ('text/plain', 'text/markdown')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventResponse:
        """Create an instance of EventResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of actor
        if self.actor:
            _dict['actor'] = self.actor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in channels (list)
        _items = []
        if self.channels:
            for _item in self.channels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['channels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EventResponse:
        """Create an instance of EventResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EventResponse.parse_obj(obj)

        _obj = EventResponse.parse_obj({
            "event_id": obj.get("eventId"),
            "session_id": obj.get("sessionId"),
            "user_id": obj.get("userId"),
            "actor": ActorResponse.from_dict(obj.get("actor")) if obj.get("actor") is not None else None,
            "message": obj.get("message"),
            "content_type": obj.get("contentType"),
            "channels": [NotificationChannelInfo.from_dict(_item) for _item in obj.get("channels")] if obj.get("channels") is not None else None,
            "created_at": obj.get("createdAt")
        })
        return _obj

