# **Bigeye CLI**
Version: 0.4.0
## Installation

**Setting up your local/build environment**  
Mac with Pyenv

1. Install [brew](https://brew.sh/)
2. Install [pyenv](https://formulae.brew.sh/formula/pyenv)
3. Install python and define a default global:

```text
pyenv install 3.9.13
pyenv global 3.9.13
```

Conda  
Install [conda](https://conda.io/projects/conda/en/latest/user-guide/install/index.html)  
Create environment with python3.9 or greater

```text
conda create -n bigeye_env python=3.9
conda activate bigeye_env
```

Linux  
Most linux distributes include a default python distribution and we recommend using that default.

**Installing Bigeye-CLI**

You can install the Bigeye-CLI from your command line with the following command:

```text
pip3 install bigeye-cli
```

## Configuration

Before using the Bigeye CLI, you will need to configure your Bigeye credentials and workspaces. You can do this in the following ways:

- Configuration Command
- Environment Variables
- Credentials and Configuration Files

### Configuration Command
The quickest way to get started using the Bigeye CLI is to run the `bigeye configure` command. This command will walk you through the options to establish default credentials and configurations for the Bigeye CLI.


```console
$ bigeye configure
```

Using the bigeye configure command, there are two ways to authenticate: basic authentication and browser authentication.

#### Basic Authentication

If you select basic authentication, the CLI will prompt you to enter your Bigeye username and password. This will create a default credential file at ~/.bigeye/credentials. This credential will be used for all CLI commands  
unless an environment variable is explicitly provided.

#### Browser Authentication

Alternatively, you can use browser authentication (Linux/Mac OS only). Login to your bigeye workspace on a Chrome, Chromium or  
Firefox browser. Run **bigeye configure** and select browser_auth when prompted in the CLI and follow the  
instructions. If you use Chrome profiles, make sure to specify the profile email address you are logged into.

Note: Your authentication will only be valid so long as your browser session is active. Not supported with SSO enabled.

### Environment Variables

You can create an environment variable for your workspace credential and configuration files, this is helpful if you would like to store your credential and configuration files some place other than their default locations (~/.bigeye). You can do this by adding the following to your ~/.bashrc or ~/.zshrc file. Please review the format of these files in the below sections.

```shell
export BIGEYE_API_CRED_FILE=/some/path/to/credentials.ini
export BIGEYE_API_CONFIG_FILE=/some/path/to/config.ini
```

### Credentials and Configuration Files

Lastly, if you want to specify the credential per command, you can always pass a -b parameter with the file path for the desired credential. You can pass a -c parameter with the file path for the desired configuration.

_Sample credentials file:_

```ini Text
[DEFAULT]
base_url = https://app.bigeye.com
user = some_user@bigeye.com
password = fakepassword1234
```

_Sample configuration file:_

```ini
[DEFAULT]
workspace_id = 123
```

#### Configuration Options

The configuration files can help to simplify other CLI commands by defining common options in one file. See  
the table below for the complete list of configuration options.

| **Key**                | **Description**                                                                                     | **Type**      | **Example**                            |
| ---------------------- | --------------------------------------------------------------------------------------------------- | ------------- | -------------------------------------- |
| workspace_id           | The id for the workspace [Required]                                                                 | Int           | 123                                    |
| use_default_credential | Whether or not a unique credential is required for this workspace. Default: True                    | Bool          | True                                   |
| bigconfig_input_path   | The path(s) to bigconfig files that are used for the given workspace.                               | List[strings] | path/bigconfig.yml,path2/bigconfig.yml |
| bigconfig_output_path  | The path used to output bigconfig PLAN reports and FIXME files.                                     | String        | output/bigconfig_reports/              |
| bigconfig_strict_mode  | API errors cause an exception if True. (Validation errors still cause an exception). Default: False | Bool          | False                                  |
| bigconfig_auto_approve | Bigconfig applies should be allowed to run without excplit plan approvals. Default: False           | Bool          | False                                  |


The configuration options above can be manually set directly in your config.ini files or you can utilize the below command to set the config values.

```console
$ bigeye configure set <setting_key> <value> [OPTIONAL WORKSPACE]
$ bigeye configure set bigconfig_input_path path/bigconfig.yml,path2/bigconfig -w data-science
```

To view the current value of any specific configuration you can either open the config.ini file or utilize the below command.

```console
$ bigeye configure get <setting_key> [OPTIONAL WORKSPACE]
$ bigeye configure get bigconfig_input_path -w data-science
```

### Multi-Workspace Support

The credential and configuration files are designed to allow Bigeye CLI users to easily switch between their Bigeye workspaces. Each file enforces the idea of a `DEFAULT` section. All subsequent CLI commands will inherit the properties defined in the `DEFAULT`section unless they are directed otherwise. Every command in the Bigeye CLI has the ability to provide a `--workspace` (`-w`) option to override the use of the default workspace.

To setup a non-default workspace, run the following command:

```console
$ bigeye configure -w data-science
```

Or, open up the files and manually edit them based on your setup. Here are some samples. 

_Sample configuration file with multiple workspaces:_

```ini
[DEFAULT]
workspace_id = 123
bigconfig_input_path = absolute_path/bigconfig.yml,absolute_path2/bigconfig.yml
bigconfig_output_path = absolute_path/output/

[workspace data-science]
workspace_id = 234
use_default_credential = True
bigconfig_input_path = absolute_path/ds/bigconfig.yml,absolute_path2/ds/bigconfig.yml

[workspace dev]
workspace_id = 100
use_default_credential = False
bigconfig_auto_approve = True
bigconfig_input_path = absolute_path/bigconfig.yml,absolute_path2/bigconfig.yml
```

_Sample credentials file with multiple workspaces:_

```ini
[DEFAULT]
base_url = https://app.bigeye.com
user = some_user@bigeye.com
password = fakepassword1234

[dev]
base_url = https://app.bigeye.com
user = some_user@bigeye.com
password = fakepassword1234
```

**Note:** Most use cases will only require you to have a single `DEFAULT` credential that all workspaces can utilize. Running the `bigeye configure -w <workspace-name>` command for a non-default workspace will prompt you to inherit the credentials from default or create a new set of credentials. A workspace credential is only required if the `use_default_credential` setting is set to False in the configuration of the corresponding workspace.

# CLI Documentation# `bigeye configure`

Configuration Commands for Bigeye CLI

**Usage**:

```console
$ bigeye configure [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `set`: Set any specific configuration settings.
* `get`: Get any specific configuration settings.
* `list`: List all configured workspaces.

## `bigeye configure set`

Set any specific configuration settings.

**Usage**:

```console
$ bigeye configure set [OPTIONS] [SETTING_KEY] [SETTING_VALUE]
```

**Arguments**:

* `[SETTING_KEY]`: The name of the configuration setting.
* `[SETTING_VALUE]`: The value of the configuration setting.

**Options**:

* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `--help`: Show this message and exit.

## `bigeye configure get`

Get any specific configuration settings.

**Usage**:

```console
$ bigeye configure get [OPTIONS] [SETTING_KEY]
```

**Arguments**:

* `[SETTING_KEY]`: The name of the configuration setting.

**Options**:

* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `--help`: Show this message and exit.

## `bigeye configure list`

List all configured workspaces.

**Usage**:

```console
$ bigeye configure list [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `--help`: Show this message and exit.

# `bigeye workspace`

Workspace Commands for Bigeye CLI

**Usage**:

```console
$ bigeye workspace [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `unschedule-all-metrics`: Unschedule all metrics in a workspace.
* `schedule-all-metrics`: Schedule all metrics in a workspace.
* `create-named-schedule`: Create a named, cron based schedule
* `upsert-named-schedule`: Create a named, cron based schedule.
* `delete-named-schedule`: Delete a named schedule.
* `export-named-schedule`: Export cron schedule to yaml file
* `invite-user`: Invite a user to a workspace.
* `edit-user`: Edit an existing user&#x27;s access to groups.
* `delete-user`: Deletes a users account.
* `upsert-workspace`: Create or update a workspace.
* `delete-workspace`: Delete a workspace.
* `upsert-group`: Create or update a group.
* `edit-group-access`: Edit the workspaces that a group can access.
* `delete-group`: Delete a group.

## `bigeye workspace unschedule-all-metrics`

Unschedule all metrics in a workspace.

**Usage**:

```console
$ bigeye workspace unschedule-all-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `--help`: Show this message and exit.

## `bigeye workspace schedule-all-metrics`

Schedule all metrics in a workspace.

**Usage**:

```console
$ bigeye workspace schedule-all-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-type, --time_interval_type INTEGER`: Time interval type.
 UNDEFINED_TIME_INTERVAL_TYPE:0
HOURS_TIME_INTERVAL_TYPE:1
MINUTES_TIME_INTERVAL_TYPE:2
SECONDS_TIME_INTERVAL_TYPE:3
DAYS_TIME_INTERVAL_TYPE:4
WEEKDAYS_TIME_INTERVAL_TYPE:5
MARKET_DAYS_TIME_INTERVAL_TYPE:6
MONTHS_TIME_INTERVAL_TYPE:7  [default: 1]
* `-value, --interval_value INTEGER`: Number of intervals to set on all metric schedules.  If 0 use unschedule all metrics.  [required]
* `--help`: Show this message and exit.

## `bigeye workspace create-named-schedule`

Create a named, cron based schedule

**Usage**:

```console
$ bigeye workspace create-named-schedule [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-sn, --name TEXT`: The user defined name of the schedule  [required]
* `-c, --cron TEXT`: The cron string to define the schedule  [required]
* `--help`: Show this message and exit.

## `bigeye workspace upsert-named-schedule`

Create a named, cron based schedule. Files have priority over arguments

**Usage**:

```console
$ bigeye workspace upsert-named-schedule [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-sn, --name TEXT`: The user defined name of the schedule
* `-c, --cron TEXT`: The cron string to define the schedule
* `-sf, --schedule_file TEXT`: A yaml file containing a schedule definition.
* `--help`: Show this message and exit.

## `bigeye workspace delete-named-schedule`

Delete a named schedule.

**Usage**:

```console
$ bigeye workspace delete-named-schedule [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-sn, --name TEXT`: The user defined name of the schedule  [required]
* `--help`: Show this message and exit.

## `bigeye workspace export-named-schedule`

Export cron schedule to yaml file

**Usage**:

```console
$ bigeye workspace export-named-schedule [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-sn, --name TEXT`: The name of the schedule(s) to export. None means all
* `-op, --output_path TEXT`: Path to output files. None means current directory
* `--help`: Show this message and exit.

## `bigeye workspace invite-user`

Invite a user to a workspace.

**Usage**:

```console
$ bigeye workspace invite-user [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-name, --user_name TEXT`: User name.  [required]
* `-email, --user_email TEXT`: Email where invite will be sent.  [required]
* `-group, --group_name TEXT`: The names of the groups that the user should belong to. E.g. -group team1 -group team2
* `--help`: Show this message and exit.

## `bigeye workspace edit-user`

Edit an existing user&#x27;s access to groups.

**Usage**:

```console
$ bigeye workspace edit-user [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-name, --user_name TEXT`: User name.
* `-email, --user_email TEXT`: User email.
* `-group, --group_name TEXT`: The names of the groups that should be edited for this users access. E.g. -group team1 -group team2  [required]
* `-op, --operation INTEGER`: Operation type.
 GROUP_USER_OPERATION_UNSPECIFIED:0
GROUP_USER_OPERATION_ADD:1
GROUP_USER_OPERATION_REMOVE:2  [default: 1]
* `--help`: Show this message and exit.

## `bigeye workspace delete-user`

Deletes a users account.

**Usage**:

```console
$ bigeye workspace delete-user [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-name, --user_name TEXT`: User name.
* `-email, --user_email TEXT`: User email.
* `--help`: Show this message and exit.

## `bigeye workspace upsert-workspace`

Create or update a workspace.

**Usage**:

```console
$ bigeye workspace upsert-workspace [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-name, --workspace_name TEXT`: Workspace name.  [required]
* `-id, --workspace_id INTEGER`: Workspace ID.
* `--help`: Show this message and exit.

## `bigeye workspace delete-workspace`

Delete a workspace.

**Usage**:

```console
$ bigeye workspace delete-workspace [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-name, --workspace_name TEXT`: Workspace name.  [required]
* `--help`: Show this message and exit.

## `bigeye workspace upsert-group`

Create or update a group.

**Usage**:

```console
$ bigeye workspace upsert-group [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-name, --group_name TEXT`: Group name.  [required]
* `-id, --group_id INTEGER`: Group ID.
* `--help`: Show this message and exit.

## `bigeye workspace edit-group-access`

Edit the workspaces that a group can access.

**Usage**:

```console
$ bigeye workspace edit-group-access [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-name, --group-name TEXT`: Group name.  [required]
* `-id, --group-id INTEGER`: Group ID.
* `-wn, --workspace-name TEXT`: List of workspace names to edit access. E.g. -wn workspace1 -wn workspace2  [required]
* `-access, --access-level TEXT`: The access this group should have to the workspaces provided. Must be `View`, `Edit`, or `Manage`  [default: Edit]
* `-op, --operation INTEGER`: Operation type.
 ROLE_OPERATION_UNSPECIFIED:0
ROLE_OPERATION_GRANT:1
ROLE_OPERATION_REVOKE:2  [default: 1]
* `--help`: Show this message and exit.

## `bigeye workspace delete-group`

Delete a group.

**Usage**:

```console
$ bigeye workspace delete-group [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-name, --group_name TEXT`: Group name.  [required]
* `--help`: Show this message and exit.

# `bigeye bigconfig`

Bigconfig Commands for Bigeye CLI

**Usage**:

```console
$ bigeye bigconfig [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `plan`: Executes a plan for purging sources or...
* `apply`: Applies a purge of deployed metrics or...
* `export`: Exports existing metrics into a valid...

## `bigeye bigconfig plan`

Executes a plan for purging sources or processing bigconfig files in the input path/current
working directory.

**Usage**:

```console
$ bigeye bigconfig plan [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-ip, --input_path TEXT`: List of paths containing Bigconfig files or pointing to a Bigconfig file. E.g. -ip path1 -ip path2. If no input path is defined then current working directory will be used.
* `-op, --output_path TEXT`: Output path where reports and fixme files will be saved. If no output path is defined then current working directory will be used.
* `-psn, --purge_source_name TEXT`: List of source names to purge  E.g. -psn source_1 -psn source_2.
* `-purge_all, --purge_all_sources`: Purge all sources: True or False.
* `-nq, --no_queue`: Don&#x27;t submit to queue: True or False. [DEPRECATED]
* `-r, --recursive`: Search all input directories recursively.
* `-strict, --strict_mode`: API errors cause an exception if True. (Validation errors still cause an exception)
* `-cicd, --cicd_report`: Add the report to a pull request. (Github only)
* `--help`: Show this message and exit.

## `bigeye bigconfig apply`

Applies a purge of deployed metrics or applies Bigconfig files from the input path/current working directory to
the Bigeye workspace.

**Usage**:

```console
$ bigeye bigconfig apply [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-ip, --input_path TEXT`: List of paths containing Bigconfig files or pointing to a Bigconfig file. E.g. -ip path1 -ip path2. If no input path is defined then current working directory will be used.
* `-op, --output_path TEXT`: Output path where reports and fixme files will be saved. If no output path is defined then current working directory will be used.
* `-psn, --purge_source_name TEXT`: List of source names to purge  E.g. -psn source_1 -psn source_2.
* `-purge_all, --purge_all_sources`: Purge all sources: True or False.
* `-nq, --no_queue`: Don&#x27;t submit to queue: True or False. [DEPRECATED]
* `-r, --recursive`: Search all input directories recursively.
* `-strict, --strict_mode`: API errors cause an exception if True. (Validation errors still cause an exception)
* `-auto_approve, --auto_approve`: Explicit plan approval is not needed prior to execution.
* `--help`: Show this message and exit.

## `bigeye bigconfig export`

Exports existing metrics into a valid Bigconfig file.

**Usage**:

```console
$ bigeye bigconfig export [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-op, --output_path TEXT`: Output path where reports and fixme files will be saved. If no output path is defined then current working directory will be used.
* `-cid, --collection_id INTEGER`: Collection ID of metrics to be exported.
* `-tid, --table_id INTEGER`: Table ID of metrics to be exported.
* `-mid, --metric_id INTEGER`: Metric ID of metrics to be exported.
* `--help`: Show this message and exit.

# `bigeye catalog`

Catalog Commands for Bigeye CLI

**Usage**:

```console
$ bigeye catalog [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `regen-autometrics`: Regenerates Autometrics by warehouse id OR...
* `delete-metrics`: Delete metrics in a warehouse id, by...
* `rebuild`: Rebuilds/Reprofiles a source by warehouse...
* `get-table-info`: Outputs table info to a file for an entire...
* `get-metric-info`: Outputs metric info to a file.
* `run-metrics`: Runs metrics by warehouse id, schema...
* `add-source`: Adds a source to specified Bigeye workspace.
* `delete-source`: Delete a source from specified Bigeye...
* `backfill-autothresholds`: Backfills autothresholds by warehouse id,...
* `backfill-metrics`: Backfills metrics by warehouse id, schema...
* `schedule-all-metrics`: Updates schedule for all metrics in a...
* `unschedule-all-metrics`: Unschedule all metrics by warehouse,...
* `set-metric-time`: Sets metric times from a list of possible...
* `unset-metric-time`: Unsets metric times for whole warehouse or...
* `get-metric-queries`: Gets the debug queries for all metrics by...
* `upsert-template`: Create or update a template for a source.
* `export-metric-template`: Export metric templates to yaml files
* `get-all-metric-templates`: Retrieve all metric templates and output...
* `delete-template`: Delete a template.
* `upsert-virtual-table`: Create or update a virtual table.
* `delete-virtual-table`: Delete a virtual table.
* `export-virtual-table`: Export virtual table to yaml file
* `ingest-owners-from-dbt`: Ingest table owners from dbt manifest.json...
* `ingest-dbt-core-run-info`: Ingest manifest.json and run_results.json...
* `track-schema-changes`: Track schema changes for sources on demand...

## `bigeye catalog regen-autometrics`

Regenerates Autometrics by warehouse id OR warehouse id and list of schema names OR list of table ids.

**Usage**:

```console
$ bigeye catalog regen-autometrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID.  If none will look for Table IDs.  If value then will pull all table ids for warehouse
* `-sn, --schema_name TEXT`: List of Schema Names  E.g. -sn schema_1 -sn schema_2.  Do not include warehouse name -- GREENE_HOMES_DEMO_STANDARD.CONFORMED is fully qualified and CONFORMED is the schema name.
* `-tid, --table_id INTEGER`: List of Table IDs.  E.g. -tid 123 -tid 124
* `--help`: Show this message and exit.

## `bigeye catalog delete-metrics`

Delete metrics in a warehouse id, by schema names, or by table_ids.  Also, can filter by multipe
metric types.

**Usage**:

```console
$ bigeye catalog delete-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.
* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124
* `-m, --metric_type TEXT`: Delete by name of the metric type.UNDEFINED_PREDEFINED_METRIC_NAME, PERCENT_NULL, COUNT_NULL, PERCENT_EMPTY_STRING, COUNT_EMPTY_STRING, PERCENT_UNIQUE, PERCENT_VALUE_IN_LIST, AVERAGE, MIN, MAX, SUM, COUNT_ROWS, COUNT_DISTINCT, HOURS_SINCE_MAX_DATE, HOURS_SINCE_MAX_TIMESTAMP, COUNT_TRUE, PERCENT_TRUE, COUNT_FALSE, PERCENT_FALSE, COUNT_USA_PHONE, PERCENT_USA_PHONE, COUNT_USA_ZIP_CODE, PERCENT_USA_ZIP_CODE, PERCENT_UUID, COUNT_TIMESTAMP_STRING, PERCENT_TIMESTAMP_STRING, COUNT_DUPLICATES, COUNT_USA_STATE_CODE, PERCENT_USA_STATE_CODE, VARIANCE, SKEW, KURTOSIS, GEOMETRIC_MEAN, HARMONIC_MEAN, COUNT_UUID, COUNT_CUSIP, PERCENT_CUSIP, COUNT_SEDOL, PERCENT_SEDOL, COUNT_ISIN, PERCENT_ISIN, COUNT_LEI, PERCENT_LEI, COUNT_FIGI, PERCENT_FIGI, COUNT_PERM_ID, PERCENT_PERM_ID, COUNT_NAN, PERCENT_NAN, COUNT_LONGITUDE, PERCENT_LONGITUDE, COUNT_LATITUDE, PERCENT_LATITUDE, COUNT_NOT_IN_FUTURE, PERCENT_NOT_IN_FUTURE, COUNT_DATE_NOT_IN_FUTURE, PERCENT_DATE_NOT_IN_FUTURE, MEDIAN, PERCENTILE, COUNT_NOT_NULL, STRING_LENGTH_AVERAGE, STRING_LENGTH_MIN, STRING_LENGTH_MAX, COUNT_SSN, PERCENT_SSN, COUNT_EMAIL, PERCENT_EMAIL, ROWS_INSERTED, HOURS_SINCE_LAST_LOAD, COUNT_READ_QUERIES, PERCENT_NOT_NULL, FRESHNESS, VOLUME, FRESHNESS_DATA, VOLUME_DATA, COUNT_VALUE_IN_LIST
* `--help`: Show this message and exit.

## `bigeye catalog rebuild`

Rebuilds/Reprofiles a source by warehouse id or a schema by warehouse id and schema name.

**Usage**:

```console
$ bigeye catalog rebuild [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID  [required]
* `-sn, --schema_name TEXT`: Schema Name
* `--help`: Show this message and exit.

## `bigeye catalog get-table-info`

Outputs table info to a file for an entire warehouse, certain schemas, or certain tables.

**Usage**:

```console
$ bigeye catalog get-table-info [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.
* `-tid, --table_id INTEGER`: Table IDs. E.g. -tid 123 -tid 124
* `-tn, --table_name TEXT`: Table Namess. E.g. -tn some_table -tn some_other_table
* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]
* `--help`: Show this message and exit.

## `bigeye catalog get-metric-info`

Outputs metric info to a file.  Includes metric configuration and details about recent runs.

**Usage**:

```console
$ bigeye catalog get-metric-info [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.
* `-tid, --table_id INTEGER`: Table IDs. E.g. -tid 123 -tid 124or schema names.
* `-ms, --metric_status [HEALTHY|ALERTING|FAILED|UNKNOWN]`: Used to query metric of particular status.
* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]
* `--conf_only`: Output only the metric configuration.
* `--help`: Show this message and exit.

## `bigeye catalog run-metrics`

Runs metrics by warehouse id, schema names, and/or table ids

**Usage**:

```console
$ bigeye catalog run-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.
* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124
* `-q, --queue`: Submit the batch to a queue. (Recommended for larger batches)
* `--help`: Show this message and exit.

## `bigeye catalog add-source`

Adds a source to specified Bigeye workspace.  Supports either source configs stored in AWS Secrets manager OR
locally in file.

**Usage**:

```console
$ bigeye catalog add-source [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-sn, --secret_name TEXT`: The name of the secret to retrieve from AWS Secrets Manager
* `-srn, --secret_region_name TEXT`: AWS Secret Manager Region Name  [default: us-west-2]
* `-sccf, --source_catalog_config_file TEXT`: The file containing the necessary parameters for adding a source to Bigeye.
* `--help`: Show this message and exit.

## `bigeye catalog delete-source`

Delete a source from specified Bigeye workspace.

**Usage**:

```console
$ bigeye catalog delete-source [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: The ID of the warehouse to delete.
* `--help`: Show this message and exit.

## `bigeye catalog backfill-autothresholds`

Backfills autothresholds by warehouse id, schema names, and/or table ids.

**Usage**:

```console
$ bigeye catalog backfill-autothresholds [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.
* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124
* `--help`: Show this message and exit.

## `bigeye catalog backfill-metrics`

Backfills metrics by warehouse id, schema names, and/or table ids.

**Usage**:

```console
$ bigeye catalog backfill-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.
* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124
* `--delete_history`: Delete metric run history
* `-q, --queue`: Submit the batch to a queue. (Recommended for larger batches)
* `--help`: Show this message and exit.

## `bigeye catalog schedule-all-metrics`

Updates schedule for all metrics in a warehouse.

**Usage**:

```console
$ bigeye catalog schedule-all-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-type, --time_interval_type INTEGER`: Time interval type.
 UNDEFINED_TIME_INTERVAL_TYPE:0
HOURS_TIME_INTERVAL_TYPE:1
MINUTES_TIME_INTERVAL_TYPE:2
SECONDS_TIME_INTERVAL_TYPE:3
DAYS_TIME_INTERVAL_TYPE:4
WEEKDAYS_TIME_INTERVAL_TYPE:5
MARKET_DAYS_TIME_INTERVAL_TYPE:6
MONTHS_TIME_INTERVAL_TYPE:7  [default: 1]
* `-value, --interval_value INTEGER`: Number of intervals to set on all metric schedules.  If 0 use unschedule all metrics.  [required]
* `--help`: Show this message and exit.

## `bigeye catalog unschedule-all-metrics`

Unschedule all metrics by warehouse, schema or tables.

**Usage**:

```console
$ bigeye catalog unschedule-all-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-sn, --schema_name TEXT`: List of Schema Name.  E.g. -sn schema_1.
* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124
* `--help`: Show this message and exit.

## `bigeye catalog set-metric-time`

Sets metric times from a list of possible metric column names.  Can set for whole warehouse or for a list of
table IDs.

**Usage**:

```console
$ bigeye catalog set-metric-time [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-sid, --schema_id INTEGER`: Schema ID
* `-tid, --table_id INTEGER`: List of table IDs.
* `-cn, --metric_column_name TEXT`: Possible metric column names.  [required]
* `-r, --replace`: replace metric times if already present on tables?  Default is false.
* `--help`: Show this message and exit.

## `bigeye catalog unset-metric-time`

Unsets metric times for whole warehouse or for a list og table IDs.

**Usage**:

```console
$ bigeye catalog unset-metric-time [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-tid, --table_id INTEGER`: List of table IDs.
* `--help`: Show this message and exit.

## `bigeye catalog get-metric-queries`

Gets the debug queries for all metrics by warehouse id, schema names, or table ids.

**Usage**:

```console
$ bigeye catalog get-metric-queries [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse ID
* `-sn, --schema_name TEXT`: List of Schema Names.  E.g. -sn schema_1 -sn schema_2.
* `-tid, --table_id INTEGER`: Table IDs.  E.g. -tid 123 -tid 124
* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]
* `--help`: Show this message and exit.

## `bigeye catalog upsert-template`

Create or update a template for a source. Files have priority over arguments

**Usage**:

```console
$ bigeye catalog upsert-template [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-sn, --source_name TEXT`: The name of the source where the template will be defined
* `-tn, --name TEXT`: The user defined name of the template
* `-tb, --body TEXT`: The string to define the template
* `-rt, --returns [SimpleFieldType.BOOLEAN|SimpleFieldType.NUMERIC]`: The data type returned by the template; i.e. NUMERIC, BOOLEAN
* `-p, --params TEXT`: A list of key/value pairs for parameters; ex. -p column=COLUMN_REFERENCE -p table=STRING
* `-tf, --template_file TEXT`: A file containing a template definition.
* `--help`: Show this message and exit.

## `bigeye catalog export-metric-template`

Export metric templates to yaml files

**Usage**:

```console
$ bigeye catalog export-metric-template [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-tn, --name TEXT`: The name of the template(s) to export. None means all
* `-op, --output_path TEXT`: Path to output files. None means current directory
* `--help`: Show this message and exit.

## `bigeye catalog get-all-metric-templates`

Retrieve all metric templates and output to a file.

**Usage**:

```console
$ bigeye catalog get-all-metric-templates [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-ps, --page_size INTEGER`: How many results to return per page  [default: 0]
* `-s, --search TEXT`: A search string to narrow results
* `-op, --output_path TEXT`: The path to output templates
* `-fn, --file_name TEXT`: User defined file name
* `--help`: Show this message and exit.

## `bigeye catalog delete-template`

Delete a template.

**Usage**:

```console
$ bigeye catalog delete-template [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-tid, --template_id INTEGER`: The ID of the metric template
* `-tn, --name TEXT`: The name of the metric template
* `--help`: Show this message and exit.

## `bigeye catalog upsert-virtual-table`

Create or update a virtual table. Files have priority over arguments

**Usage**:

```console
$ bigeye catalog upsert-virtual-table [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-vtn, --table_name TEXT`: The name of the virtual table
* `-s, --sql TEXT`: The SQL to define the table
* `-sn, --source_name TEXT`: The name of the source where the virtual table will be defined
* `-u, --update`: Create if false. Update if true.
* `-tf, --table_file TEXT`: A yaml file containing a template definition.
* `--help`: Show this message and exit.

## `bigeye catalog delete-virtual-table`

Delete a virtual table.

**Usage**:

```console
$ bigeye catalog delete-virtual-table [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-vtn, --table_name TEXT`: The name of the virtual table  [required]
* `-sn, --source_name TEXT`: The name of the source that contains the virtual table  [required]
* `--help`: Show this message and exit.

## `bigeye catalog export-virtual-table`

Export virtual table to yaml file

**Usage**:

```console
$ bigeye catalog export-virtual-table [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-vtn, --name TEXT`: The name of the virtual table(s) to export. None means all
* `-op, --output_path TEXT`: Path to output files. None means current directory
* `--help`: Show this message and exit.

## `bigeye catalog ingest-owners-from-dbt`

Ingest table owners from dbt manifest.json file.

**Usage**:

```console
$ bigeye catalog ingest-owners-from-dbt [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-mf, --manifest_file TEXT`: The path to the dbt manifest file.
* `-sn, --source_name TEXT`: The name of the source in Bigeye where owners will be ingested.
* `-sid, --source_id INTEGER`: The id of the source in Bigeye where owners will be ingested.
* `--help`: Show this message and exit.

## `bigeye catalog ingest-dbt-core-run-info`

Ingest manifest.json and run_results.json from different dbt commands.

**Usage**:

```console
$ bigeye catalog ingest-dbt-core-run-info [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-tp, --target_path TEXT`: The path to the target directory created with dbt run, build, and test commands.  [default: ./target]
* `-pn, --project_name TEXT`: The name of the dbt project. Will attempt to parse from metadata section of manifest.json, if not present
* `-jn, --job_name TEXT`: The name of the dbt job.
* `-jid, --job_run_id TEXT`: The ID of the dbt job run.
* `-purl, --project_url TEXT`: The URL of the project.
* `-jurl, --job_url TEXT`: The URL of the job.
* `-jrurl, --job_run_url TEXT`: The URL of the job run.
* `--help`: Show this message and exit.

## `bigeye catalog track-schema-changes`

Track schema changes for sources on demand or every n hour(s) and notify specified channels.
Environment variables SMTP_USER and SMTP_PASSWORD MUST be set if using email notification.

**Usage**:

```console
$ bigeye catalog track-schema-changes [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-src, --source TEXT`: A list of source names to track. (None will track changes from all sources)
* `-s, --since TEXT`: Track schema changes from this date. (Formatted as yyyy-MM-dd)  [default: 1970-01-01]
* `-f, --frequency INTEGER`: Every n hours to check for schema changes. (None will only run the check once)  [default: 0]
* `-ct, --change_type [CREATED|DELETED|TYPE_CHANGED]`: The types of changes to track; i.e additions, changes, deletions. (None will track all types)  [default: DELETED, CREATED, TYPE_CHANGED]
* `-nc, --channel TEXT`: A list of notification channels; e.g. -nc email@mydomain.com -nc #slack_channel -nc https://www.webhook.com
* `-smtp, --server TEXT`: The server to send emails.
* `-p, --port INTEGER`: The server port to send emails.  [default: 587]
* `-t, --token TEXT`: The token to utilize the Slack web client. (Will attempt to use environment variable SLACK_BOT_TOKEN, if not set)
* `--help`: Show this message and exit.

# `bigeye metric`

Metric Commands for Bigeye CLI

**Usage**:

```console
$ bigeye metric [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `run`: Run metric by id(s)
* `get-info`: Outputs metric info to a file.
* `upsert-from-path`: Upsert multiple metrics from files stored...
* `upsert`: Upsert single metric from file.
* `get-metric-queries`: Gets the debug queries for all metrics by...
* `dbt-tests-to-metrics`: Convert tests in a dbt schema.yml to...

## `bigeye metric run`

Run metric by id(s)

**Usage**:

```console
$ bigeye metric run [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-mid, --metric_id INTEGER`: Metric Ids.  [required]
* `-q, --queue`: Submit the batch to a queue. (Recommended for larger batches)
* `--help`: Show this message and exit.

## `bigeye metric get-info`

Outputs metric info to a file.  Includes metric configuration and details about recent runs.

**Usage**:

```console
$ bigeye metric get-info [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-mid, --metric_id INTEGER`: Metric Ids.  [required]
* `-ms, --metric_status [HEALTHY|ALERTING|FAILED|UNKNOWN]`: Used to query metric of particular status.
* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]
* `--conf_only`: Output only the metric configuration.
* `--help`: Show this message and exit.

## `bigeye metric upsert-from-path`

Upsert multiple metrics from files stored in path.

**Usage**:

```console
$ bigeye metric upsert-from-path [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-twid, --target_warehouse_id INTEGER`: Deploy Metrics to target Warehouse ID.  [required]
* `-sp, --source_path TEXT`: Source path file containing the metrics to migrate.  [required]
* `-srct, --set_row_creation_time`: Set the row creation time in target warehouse for tables found in source path.
* `-uc, --update_collections`: Update existing collections to include new metrics from target warehouse.
* `--help`: Show this message and exit.

## `bigeye metric upsert`

Upsert single metric from file.

**Usage**:

```console
$ bigeye metric upsert [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-f, --file TEXT`: File containing SimpleUpsedrtMetricRequest or MetricConfiguration  [required]
* `-t, --file_type [SIMPLE|FULL]`: Metric File Type.  Simple conforms to SimpleUpsertMetricRequest and Full conforms to MetricConfiguration  [required]
* `-wid, --warehouse_id INTEGER`: (Optional) Warehouse ID.  If specified it will reduce the text based search for the table.warehouse
* `-mid, --metric_id INTEGER`: (Optional) Metric Id.  If specified it will reduce the text based search for existing metric.
* `--help`: Show this message and exit.

## `bigeye metric get-metric-queries`

Gets the debug queries for all metrics by warehouse id, schema names, or table ids.

**Usage**:

```console
$ bigeye metric get-metric-queries [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-mid, --metric_id INTEGER`: Metric Ids.  [required]
* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]
* `--help`: Show this message and exit.

## `bigeye metric dbt-tests-to-metrics`

Convert tests in a dbt schema.yml to metrics in Bigeye

**Usage**:

```console
$ bigeye metric dbt-tests-to-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wn, --warehouse_name TEXT`: The name of the source to deploy metrics  [required]
* `-sn, --schema_name TEXT`: The name of the schema to deploy metrics  [required]
* `-sf, --schema_file TEXT`: The path to the dbt schema file  [required]
* `-auto, --use_auto`: Use autothresholds over default constant
* `-bigconfig, --to_bigconfig`: Convert the dbt tests to bigconfig.
* `-op, --output_path TEXT`: Output path where bigconfig file will be saved. If no output path is defined then current working directory will be used. Requires --to_bigconfig to be true.  [default: /Users/christian/Projects/semantic-data-platform/bigeye-integrations/bigeye-cli]
* `--help`: Show this message and exit.

# `bigeye issues`

Issues Commands for Bigeye CLI

**Usage**:

```console
$ bigeye issues [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `get-issues`: Gets issues and writes info to files.
* `update-issue`: Updates an issue in Bigeye and returns the...

## `bigeye issues get-issues`

Gets issues and writes info to files.

**Usage**:

```console
$ bigeye issues get-issues [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-wid, --warehouse_id INTEGER`: Warehouse IDs.
* `-sn, --schema_name TEXT`: Schema names
* `-mid, --metric_id INTEGER`: Metric IDs.
* `-cid, --collection_id INTEGER`: Collection IDs
* `-iid, --issue_id INTEGER`: Issue IDs
* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]
* `--help`: Show this message and exit.

## `bigeye issues update-issue`

Updates an issue in Bigeye and returns the Issue object from the protobuff.

**Usage**:

```console
$ bigeye issues update-issue [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-iid, --issue_id INTEGER`: Issue ID  [required]
* `-status, --issue_status TEXT`: The status update. Options are ACKNOWLEDGED or CLOSED.
* `-by, --updated_by TEXT`: The user providing the update.
* `-m, --message TEXT`: The message to attach to the issue.
* `-cl, --closing_label TEXT`: Used to train Bigeye when closing an issue. Options are TRUE_POSITIVE, FALSE_POSITIVE, EXPECTED.
* `--help`: Show this message and exit.

# `bigeye deltas`

Deltas Commands for Bigeye CLI

**Usage**:

```console
$ bigeye deltas [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `suggest-deltas`: Suggests and creates Deltas with default...
* `create-delta`: Creates deltas between tables from a...
* `run-delta`: Runs a delta by Delta ID.
* `create-template`: Create a template delta configuration file...
* `cicd`: Creates a delta based on...

## `bigeye deltas suggest-deltas`

Suggests and creates Deltas with default behavior and outputs all Simple Delta Configurations to a file.

**Usage**:

```console
$ bigeye deltas suggest-deltas [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-source, --source_selector TEXT`: The pattern of tables in the source to select. Wildcard (*) indicates all tables or all schemas, e.g. source_1.*.* would be all schemas in source_1.  [required]
* `-target, --target_selector TEXT`: The pattern of tables in the target to select. Wildcard (*) indicates all tables or all schemas, e.g. source_2.*.* would be all schemas in source_2.  [required]
* `-mt, --match_type [strict|fuzzy]`: How to match tables between the source and target destinations. Strict will only create relations if table names match exactly, Fuzzy will attempt to create relations using a fuzzy match.  [default: strict]
* `-op, --output_path TEXT`: File to write the delta configuration.  [required]
* `--help`: Show this message and exit.

## `bigeye deltas create-delta`

Creates deltas between tables from a Simple Delta configuration file that contains multiple delta configurations.
Enforces 1:1 column comparisons by case-insensitive column names if no column mappings are declared in
configuration.

**Usage**:

```console
$ bigeye deltas create-delta [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-dc, --delta_conf TEXT`: Simple Delta configuration file.  [required]
* `-ul, --update_lineage`: Should lineage between source and target be checked/created if doesn&#x27;t exist.
* `--help`: Show this message and exit.

## `bigeye deltas run-delta`

Runs a delta by Delta ID.

**Usage**:

```console
$ bigeye deltas run-delta [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-did, --delta_id INTEGER`: Id of delta.  [required]
* `-ar, --await_results`: Should command wait for delta run to complete, default False.
* `--help`: Show this message and exit.

## `bigeye deltas create-template`

Create a template delta configuration file based on table names.

**Usage**:

```console
$ bigeye deltas create-template [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-stn, --source_table_name TEXT`: The fully qualified name of the source table  [required]
* `-ttn, --target_table_name TEXT`: The fully qualified name of the target table  [required]
* `-op, --output_path TEXT`: Path to write the template.  [required]
* `--help`: Show this message and exit.

## `bigeye deltas cicd`

Creates a delta based on SimpleDeltaConfiguration and integrates the results with the provided VCS vendor.

**Usage**:

```console
$ bigeye deltas cicd [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-dcc, --delta_cicd_config TEXT`: The yaml file containing the parameters for the DeltaCICDConfig class  [required]
* `--help`: Show this message and exit.

# `bigeye collections`

Collections Commands for Bigeye CLI

**Usage**:

```console
$ bigeye collections [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `add-metric`: Add metric to a Collection.
* `get-metric-info`: Get metric info for all metrics in...
* `migrate-from-json`: Loads metrics from Collection oriented...
* `backfill-metrics`: Backfill all metrics in a Collection.
* `run-metrics`: Run all metrics in a Collection.
* `get-metric-queries`: Gets the debug queries for all metrics by...

## `bigeye collections add-metric`

Add metric to a Collection.

**Usage**:

```console
$ bigeye collections add-metric [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-mid, --metric_id INTEGER`: Metric ID  [required]
* `-cid, --collection_id INTEGER`: Collection ID  [required]
* `--help`: Show this message and exit.

## `bigeye collections get-metric-info`

Get metric info for all metrics in Collection.

**Usage**:

```console
$ bigeye collections get-metric-info [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `--from_collections`: Scrapes all Collections in customer workspace for Metric Info.
* `--collection_ids INTEGER`: Collection IDs.  Scrape certain Collections for Metric Info.
* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]
* `--help`: Show this message and exit.

## `bigeye collections migrate-from-json`

Loads metrics from Collection oriented metric info output.  Used to migrate metrics from one warehouse to
another, identical, warehouse

**Usage**:

```console
$ bigeye collections migrate-from-json [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-twid, --target_warehouse_id INTEGER`: Deploy Metrics to target Warehouse ID.  [required]
* `-ip, --input_path TEXT`: Path to read from.  [required]
* `-kn, --keep_notifications`: Keep Notifications from versioned or templated metric configuration.
* `-kid, --keep_ids`: Keep Metric and Collection IDs from versioned or templated metric configuration.  If kept this would update existing metrics and collections.  If not kept it would create new.
* `--help`: Show this message and exit.

## `bigeye collections backfill-metrics`

Backfill all metrics in a Collection.

**Usage**:

```console
$ bigeye collections backfill-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `--from_collections`: Scrapes all Collections in customer workspace for Metric Info.
* `--collection_ids INTEGER`: Collection IDs.  Scrape certain Collections for Metric Info.
* `--delete_history`: Delete metric run history
* `-q, --queue`: Submit the batch to a queue. (Recommended for larger batches)
* `--help`: Show this message and exit.

## `bigeye collections run-metrics`

Run all metrics in a Collection.

**Usage**:

```console
$ bigeye collections run-metrics [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-cid, --collection_id INTEGER`: Collection ID  [required]
* `-q, --queue`: Submit the batch to a queue. (Recommended for larger batches)
* `--help`: Show this message and exit.

## `bigeye collections get-metric-queries`

Gets the debug queries for all metrics by warehouse id, schema names, or table ids.

**Usage**:

```console
$ bigeye collections get-metric-queries [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-cid, --collection_id INTEGER`: Collection ID  [required]
* `-op, --output_path TEXT`: File to write the failed metric configurations to.  [required]
* `--help`: Show this message and exit.

# `bigeye lineage`

Lineage Commands for Bigeye CLI

**Usage**:

```console
$ bigeye lineage [OPTIONS] COMMAND [ARGS]...
```

**Options**:

* `--install-completion`: Install completion for the current shell.
* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.
* `--help`: Show this message and exit.

**Commands**:

* `create-node`: Create a lineage node for an entity
* `delete-node`: Delete a lineage node for an entity
* `create-relation`: Create a lineage relationship for 2 entities
* `delete-relation`: Deletes a single relationship based on...
* `infer-relations`: Given an upstream and downstream path,...

## `bigeye lineage create-node`

Create a lineage node for an entity

**Usage**:

```console
$ bigeye lineage create-node [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-en, --entity_name TEXT`: The fully qualified table name or name of the tableau workbook  [required]
* `-in, --int_name TEXT`: The name of the BI connection (required for entities outside of Bigeye)
* `--help`: Show this message and exit.

## `bigeye lineage delete-node`

Delete a lineage node for an entity

**Usage**:

```console
$ bigeye lineage delete-node [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-en, --entity_name TEXT`: The fully qualified table name or name of the tableau workbook  [required]
* `-in, --int_name TEXT`: The name of the BI connection (required for entities outside of Bigeye)
* `--help`: Show this message and exit.

## `bigeye lineage create-relation`

Create a lineage relationship for 2 entities

**Usage**:

```console
$ bigeye lineage create-relation [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-up, --upstream TEXT`: The fully qualified table name  [required]
* `-down, --downstream TEXT`: The fully qualified table name  [required]
* `-co, --column_overrides TEXT`: The list of column overrides, formatted as upstream_column_name:downstream_column_name
* `--help`: Show this message and exit.

## `bigeye lineage delete-relation`

Deletes a single relationship based on relation ID or all relationships for a node by name.

**Usage**:

```console
$ bigeye lineage delete-relation [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-en, --entity_name TEXT`: The fully qualified table name or name of the tableau workbook
* `-rid, --relation_id INTEGER`: The relationship ID to delete  [default: 0]
* `-in, --int_name TEXT`: The name of the BI connection (required for entities outside of Bigeye)
* `--help`: Show this message and exit.

## `bigeye lineage infer-relations`

Given an upstream and downstream path, infers lineage based on table/column names and creates the edges.

**Usage**:

```console
$ bigeye lineage infer-relations [OPTIONS]
```

**Options**:

* `-b, --bigeye_conf TEXT`: Bigeye Credential File Path  [env var: BIGEYE_API_CRED_FILE]
* `-c, --config_file TEXT`: Bigeye CLI Configuration File Path  [env var: BIGEYE_API_CONFIG_FILE]
* `-w, --workspace TEXT`: Name of the workspace configuration.  [env var: BIGEYE_WORKSPACE; default: DEFAULT]
* `-upstream, --upstream_selector TEXT`: The pattern of tables in the upstream source to select. Wildcard (*) indicates all tables or all schemas, e.g. source_1.*.* would be all schemas in source_1.
* `-downstream, --downstream_selector TEXT`: The pattern of tables in the downstream source to select. Wildcard (*) indicates all tables or all schemas, e.g. source_2.*.* would be all schemas in source_2.
* `-mt, --match_type [strict|fuzzy]`: How to match tables between the source and target destinations. Strict will only create relations if table names match exactly, Fuzzy will attempt to create relations using a fuzzy match.  [default: strict]
* `-lc, --lineage_conf TEXT`: The path to a Simple Lineage configuration file.
* `-purge, --purge_lineage`: Purge all lineage edges.
* `--help`: Show this message and exit.

