# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tum_exam_scripts', 'tum_exam_scripts.logic', 'tum_exam_scripts.utils']

package_data = \
{'': ['*']}

install_requires = \
['helium>=3.0.8,<4.0.0',
 'keyring>=23.11.0,<24.0.0',
 'tqdm>=4.64.1,<5.0.0',
 'typer>=0.7.0,<0.8.0']

entry_points = \
{'console_scripts': ['tum-exam-scripts = tum_exam_scripts.main:app']}

setup_kwargs = {
    'name': 'tum-exam-scripts',
    'version': '0.1.7',
    'description': '',
    'long_description': "# TUMExam Scripts\n\n## TL;DR\n\n```shell\npip3 install tum-exam-scripts --upgrade\ntum-exam-scripts install-linux-driver\ntum-exam-scripts store-password-in-password-manager your-informatics-username\ntum-exam-scripts open-printing-page your-informatics-username\ntum-exam-scripts pdf send-all-booklets --batch-size 50 /path/to/exams\ntum-exam-scripts pdf send-attendee-list /path/to/attendeelist.pdf\ntum-exam-scripts pdf send-room-layout /path/to/roomplan.pdf\ntum-exam-scripts pdf send-seat-plan /path/to/seatplan-a3.pdf\n```\n\n## Commands\n\n```shell\n$ tum-exam-scripts --help\n\n Usage: tum-exam-scripts [OPTIONS] COMMAND [ARGS]...\n\n A collection of useful commands to print TUMExams. You can find the source code under https://gitlab.lrz.de/i4/software/tum-exam-scripts\n\n╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --version                     Version                                                                                                                                                                                                      │\n│ --install-completion          Install completion for the current shell.                                                                                                                                                                    │\n│ --show-completion             Show completion for the current shell, to copy it or customize the installation.                                                                                                                             │\n│ --help                        Show this message and exit.                                                                                                                                                                                  │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Commands ─────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ install-linux-driver                This snippet downloads the Linux driver for the printers and makes them available under $driver_name This is needed as the macOS driver cannot handle the booklets. Please change the command on mac   │\n│                                     for printing the exams from `-dfollowme` to `-dfollowmepdd`!!!                                                                                                                                         │\n│ open-printing-page                  Open the page we need to send the PDFs to the FollowMe printer.                                                                                                                                        │\n│ pdf                                 Subgroup with the PDF printing commands.                                                                                                                                                               │\n│ store-password-in-password-manager  Stores the password in the password manager.                                                                                                                                                           │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n### Install Linux Driver\n\n```shell\n$ tum-exam-scripts install-linux-driver --help\n\n Usage: tum-exam-scripts install-linux-driver [OPTIONS]\n\n This snippet downloads the Linux driver for the printers and makes them available under $driver_name This is needed as the macOS driver cannot handle the booklets. Please change the command on mac for printing the exams from\n `-dfollowme` to `-dfollowmepdd`!!!\n\n╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --driver-name  -d      TEXT  Name of the driver [default: followmeppd]                                                                                                                                                                     │\n│ --password     -p      TEXT  Your user password. NOTE: The user should have 'sudo' privileges. [default: None]                                                                                                                             │\n│ --help                       Show this message and exit.                                                                                                                                                                                   │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n#### Install Linux Driver: Example\n\n```shell\ntum-exam-scripts install-linux-driver\n```\n\n### Store Password in Password Manager\n\nWe need the informatics username and the corresponding password to login into the printing page.\nThus, we store it in the system's password manager.\n\n```shell\n$ tum-exam-scripts store-password-in-password-manager --help\n\n Usage: tum-exam-scripts store-password-in-password-manager\n            [OPTIONS] [USER_NAME]\n\n Stores the password in the password manager.\n\n╭─ Arguments ────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│   user_name      [USER_NAME]  The username for your informatics account, i.e., the first letters of your lastname. [default: None]                                                                                                         │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --password  -p      TEXT  The password for your informatics account [default: None]                                                                                                                                                        │\n│ --force     -f            If true, we will overwrite existing passwords.                                                                                                                                                                   │\n│ --help                    Show this message and exit.                                                                                                                                                                                      │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n#### Store Password in Password Manager: Example\n\n```shell\ntum-exam-scripts store-password-in-password-manager stoecklp\n```\n\n### Open the Printing Page\n\nTo print the documents via Wi-Fi with the FollowMe service, we need to open the informatics printing page.\nThis website has to stay open the whole time you are sending exam sheets to the printers.\n\n\n```shell\n$ tum-exam-scripts open-printing-page --help\n\n Usage: tum-exam-scripts open-printing-page [OPTIONS] [USER_NAME]\n\n Open the page we need to send the PDFs to the FollowMe printer.\n\n╭─ Arguments ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│   user_name      [USER_NAME]  The username for your informatics account, i.e., the first letters of your lastname. [default: None]                   │\n╰──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Options ────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --browser   -b      [chrome|firefox]  The browser to start. [default: firefox]                                                                       │\n│ --password  -p      TEXT              The password for your informatics account. If you do not pass a password, we will use the password stored in   │\n│                                       the password manager.                                                                                          │\n│                                       [default: None]                                                                                                │\n│ --help                                Show this message and exit.                                                                                    │\n╰──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n#### Open the Printing Page: Example\n\n```shell\ntum-exam-scripts open-printing-page stoecklp\n```\n\n### PDF Commands\n\nI grouped all the PDF sending commands into a subgroup called `pdf`.\n\n```shell\n\n Usage: tum-exam-scripts pdf [OPTIONS] COMMAND [ARGS]...\n\n Subgroup with the PDF printing commands.\n\n╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --help          Show this message and exit.                                                                                                                                                                                                │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Commands ─────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ send-all-booklets                                   Send all booklets to the printing server.                                                                                                                                              │\n│ send-attendee-list                                  Send the attendee list to the server.                                                                                                                                                  │\n│ send-room-layout                                    Print the room plans in A3. You have to put them at the doors of the lecture hall.                                                                                                     │\n│ send-seat-plan                                      Print the seat plans in A3. You have to put them at the doors of the lecture hall.                                                                                                     │\n│ send-specific-booklets                              Send only specific PDFs to the server. You can pass multiple files.                                                                                                                    │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n\n#### Send All Booklets\n\n```shell\n$ tum-exam-scripts pdf send-all-booklets --help\n\n Usage: tum-exam-scripts pdf send-all-booklets [OPTIONS] [INPUT_DIRECTORY]\n\n Send all booklets to the printing server.\n Example:     tum-exam-scripts send-all-booklets /path/to/exams/\n\n╭─ Arguments ────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│   input_directory      [INPUT_DIRECTORY]  The directory with the exams from the TUMExam website. [default: .]                                                                                                                              │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --driver-name  -d      TEXT     Name of the driver [default: followmeppd]                                                                                                                                                                  │\n│ --batch-size   -b      INTEGER  If you add a batch size, the process will stop after so many exams and wait for you to continue.You can you this so start all jobs on a printer, then send the next batch, and start these exams on        │\n│                                 another printer.                                                                                                                                                                                           │\n│                                 [default: None]                                                                                                                                                                                            │\n│ --help                          Show this message and exit.                                                                                                                                                                                │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n##### Send All Booklets: Example\n\n```shell\ntum-exam-scripts pdf send-all-booklets .\n```\n\n#### Send Specific Booklets\n\n```shell\n$ tum-exam-scripts pdf send-specific-booklets --help\n\n Usage: tum-exam-scripts pdf send-specific-booklets [OPTIONS] [PDF_FILE]...\n\n Send only specific PDFs to the server. You can pass multiple files.\n Example:     tum-exam-scripts send-specific-booklets /path/to/E0007-book.pdf /path/to/E0009-book.pdf\n\n╭─ Arguments ────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│   pdf_file      [PDF_FILE]...  The directory with the exams from the TUMExam website. [default: None]                                                                                                                                      │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --driver-name  -d      TEXT  Name of the driver [default: followmeppd]                                                                                                                                                                     │\n│ --help                       Show this message and exit.                                                                                                                                                                                   │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n##### Send Specific Booklets: Example\n\n```shell\ntum-exam-scripts pdf send-specific-booklets /path/to/E0007-book.pdf /path/to/E0009-book.pdf\n```\n\n#### Send Attendee List\n\n```shell\n$ tum-exam-scripts pdf send-attendee-list --help\n\n Usage: tum-exam-scripts pdf send-attendee-list [OPTIONS] [ATTEND_LIST]\n\n Send the attendee list to the server.\n Example:     tum-exam-scripts send-attendee-list /path/to/attendeelist.pdf\n\n╭─ Arguments ────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│   attend_list      [ATTEND_LIST]  The attendee list from the TUMExam endterm_lists folder. [default: attendeelist.pdf]                                                                                                                     │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --driver-name  -d      TEXT  Name of the driver [default: followmeppd]                                                                                                                                                                     │\n│ --help                       Show this message and exit.                                                                                                                                                                                   │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n#### Send Attendee List: Example\n\n```shell\ntum-exam-scripts send-attendee-list /path/to/attendeelist.pdf\n```\n\n#### Send Room Layout\n\n```shell\n$ tum-exam-scripts pdf send-room-layout --help\n\n Usage: tum-exam-scripts pdf send-room-layout [OPTIONS] [ROOM_PLAN]\n\n Print the room plans in A3. You have to put them at the doors of the lecture hall.\n\n╭─ Arguments ────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│   room_plan      [ROOM_PLAN]  The room plan in A3 from the TUMExam endterm_lists folder. [default: roomplan.pdf]                                                                                                                           │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --driver-name       -d      TEXT     Name of the driver [default: followmeppd]                                                                                                                                                             │\n│ --number-of-copies  -n      INTEGER  The number of copies you want to print. [default: 3]                                                                                                                                                  │\n│ --help                               Show this message and exit.                                                                                                                                                                           │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n##### Send Room Layout: Example\n\n```shell\ntum-exam-scripts pdf send-room-layout /path/to/roomplan.pdf\n```\n\n\n#### Send Seat Plan\n\n```shell\n$ tum-exam-scripts pdf send-seat-plan --help\n\n Usage: tum-exam-scripts pdf send-seat-plan [OPTIONS] [SEAT_PLAN]\n\n Print the seat plans in A3. You have to put them at the doors of the lecture hall.\n\n╭─ Arguments ────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│   seat_plan      [SEAT_PLAN]  The seat plan in A3 from the TUMExam endterm_lists folder. [default: seatplan-a3.pdf]                                                                                                                        │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n╭─ Options ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│ --driver-name       -d      TEXT     Name of the driver [default: followmeppd]                                                                                                                                                             │\n│ --number-of-copies  -n      INTEGER  The number of copies you want to print. [default: 3]                                                                                                                                                  │\n│ --help                               Show this message and exit.                                                                                                                                                                           │\n╰────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n##### Send Seat Plan: Example\n\n```shell\ntum-exam-scripts pdf send-seat-plan /path/to/seatplan-a3.pdf\n```\n\n## Contact\n\nIf you have any question, please contact [Patrick Stöckle](mailto:patrick.stoeckle@tum.de?subject=GitLab%3A%20TUMExam%20Scripts&body=Hi%2C%0AI%20have%20the%20following%20question%20regarding%20the%20TUMExam%20Scripts%20library%3A).\n",
    'author': 'Patrick Stöckle',
    'author_email': 'patrick.stoeckle@tum.de',
    'maintainer': 'Patrick Stöckle',
    'maintainer_email': 'patrick.stoeckle@tum.de',
    'url': 'https://github.com/pstoeckle/TUMExam-Scripts',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
