"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomResourceProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const _1 = require(".");
__exportStar(require("./function"), exports);
class CustomResourceProvider extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.scope = scope;
        this.functionConstruct = this.createFunctionConstruct(id);
        this.providerFramework = this.createProviderFramework(id);
    }
    createFunctionConstruct(id) {
        const { roleArn, roleExternalId, roleSessionName } = this.props;
        const functionConstruct = new _1.FunctionConstruct(this.scope, `${id}FunctionConstruct`, {
            roleArn,
            roleExternalId,
            roleSessionName,
        });
        return functionConstruct;
    }
    createProviderFramework(id) {
        const provider = new custom_resources_1.Provider(this.scope, `${id}Provider`, {
            onEventHandler: this.functionConstruct.gFunction(),
        });
        return provider;
    }
    gProviderFramework() {
        return this.providerFramework;
    }
}
exports.CustomResourceProvider = CustomResourceProvider;
_a = JSII_RTTI_SYMBOL_1;
CustomResourceProvider[_a] = { fqn: "halloumi-cross-account-parameter-store.CustomResourceProvider", version: "1.0.1" };
//# sourceMappingURL=data:application/json;base64,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