"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HalloumiCrossAccountParameterStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
__exportStar(require("./resources/provider"), exports);
class HalloumiCrossAccountParameterStore extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.scope = scope;
        this.providerFramework = props.customResourceProvider.gProviderFramework();
        this.createParameterManager(id);
    }
    createParameterManager(id) {
        const { parameterName, parameterValue, parameterDescription } = this.props;
        const parameterManagerCustomResource = new aws_cdk_lib_1.CustomResource(this.scope, `${id}CustomResource`, {
            serviceToken: this.providerFramework.serviceToken,
            properties: {
                PARAMETER_NAME: parameterName,
                PARAMETER_VALUE: parameterValue,
                PARAMETER_DESCRIPTION: parameterDescription,
            },
        });
        return parameterManagerCustomResource;
    }
}
exports.HalloumiCrossAccountParameterStore = HalloumiCrossAccountParameterStore;
_a = JSII_RTTI_SYMBOL_1;
HalloumiCrossAccountParameterStore[_a] = { fqn: "halloumi-cross-account-parameter-store.HalloumiCrossAccountParameterStore", version: "1.0.1" };
//# sourceMappingURL=data:application/json;base64,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