# pylint: skip-file
"""This module contains implemtation of F18.

When using it, please cite :cite:`Blumlein:2009ta`.
Mellin transform is defined with the convention x^(N).
"""
import numba as nb
import numpy as np


@nb.njit(cache=True)
def F18(n, S1, S2, S3):
    """Implements eq 9.36 of :cite:`Blumlein:2009ta`"""
    return (
        0.7502092979013981
        - 0.9999999952263307
        * (
            n
            * (
                -1.0 / np.power(1.0 + n, 5)
                + 1.0823232337111381 / (1.0 + n)
                - (1.0 * S1) / np.power(1.0 + n, 4)
                - (1.0 * (0.5 * np.power(S1, 2) + 0.5 * S2)) / np.power(1.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666 * np.power(S1, 3)
                        + 0.5 * S1 * S2
                        + 0.3333333333333333 * S3
                    )
                )
                / np.power(1.0 + n, 2)
            )
            + (
                0.16666666666666666 * np.power(1 / (1.0 + n) + S1, 3)
                + 0.5 * (1 / (1.0 + n) + S1) * (np.power(1.0 + n, -2) + S2)
                + 0.3333333333333333 * (np.power(1.0 + n, -3) + S3)
            )
            / (1.0 + n)
        )
        + 0.49999902059348167
        * (
            (
                0.16666666666666666 * np.power(1 / (1.0 + n) + 1 / (2.0 + n) + S1, 3)
                + 0.5
                * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)
                * (np.power(1.0 + n, -2) + np.power(2.0 + n, -2) + S2)
                + 0.3333333333333333
                * (np.power(1.0 + n, -3) + np.power(2.0 + n, -3) + S3)
            )
            / (2.0 + n)
            + n
            * (
                -1.0 / np.power(2.0 + n, 5)
                + 1.0823232337111381 / (2.0 + n)
                - (1.0 * (1 / (1.0 + n) + S1)) / np.power(2.0 + n, 4)
                - (
                    1.0
                    * (
                        0.5 * np.power(1 / (1.0 + n) + S1, 2)
                        + 0.5 * (np.power(1.0 + n, -2) + S2)
                    )
                )
                / np.power(2.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666 * np.power(1 / (1.0 + n) + S1, 3)
                        + 0.5 * (1 / (1.0 + n) + S1) * (np.power(1.0 + n, -2) + S2)
                        + 0.3333333333333333 * (np.power(1.0 + n, -3) + S3)
                    )
                )
                / np.power(2.0 + n, 2)
            )
        )
        - 0.3332995604546604
        * (
            (
                0.16666666666666666
                * np.power(
                    1 / (1.0 + n)
                    + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                    + S1,
                    3,
                )
                + 0.5
                * (
                    1 / (1.0 + n)
                    + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                    + S1
                )
                * (
                    np.power(1.0 + n, -2)
                    + (5.0 + 6.0 * (1.0 + n) + 2.0 * np.power(1.0 + n, 2))
                    / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                    + S2
                )
                + 0.3333333333333333
                * (
                    np.power(1.0 + n, -3)
                    + (
                        (3.0 + 2.0 * (1.0 + n))
                        * (3.0 + 3.0 * (1.0 + n) + np.power(1.0 + n, 2))
                    )
                    / (np.power(2.0 + n, 3) * np.power(3.0 + n, 3))
                    + S3
                )
            )
            / (3.0 + n)
            + n
            * (
                -1.0 / np.power(3.0 + n, 5)
                + 1.0823232337111381 / (3.0 + n)
                - (1.0 * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)) / np.power(3.0 + n, 4)
                - (
                    1.0
                    * (
                        0.5 * np.power(1 / (1.0 + n) + 1 / (2.0 + n) + S1, 2)
                        + 0.5 * (np.power(1.0 + n, -2) + np.power(2.0 + n, -2) + S2)
                    )
                )
                / np.power(3.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666
                        * np.power(1 / (1.0 + n) + 1 / (2.0 + n) + S1, 3)
                        + 0.5
                        * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)
                        * (np.power(1.0 + n, -2) + np.power(2.0 + n, -2) + S2)
                        + 0.3333333333333333
                        * (np.power(1.0 + n, -3) + np.power(2.0 + n, -3) + S3)
                    )
                )
                / np.power(3.0 + n, 2)
            )
        )
        + 0.24954082848379078
        * (
            (
                0.16666666666666666
                * np.power(
                    1 / (1.0 + n)
                    + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                    + S1,
                    3,
                )
                + 0.5
                * (
                    1 / (1.0 + n)
                    + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                    + S1
                )
                * (
                    np.power(1.0 + n, -2)
                    + (
                        49.0
                        + 96.0 * (1.0 + n)
                        + 72.0 * np.power(1.0 + n, 2)
                        + 24.0 * np.power(1.0 + n, 3)
                        + 3.0 * np.power(1.0 + n, 4)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                    )
                    + S2
                )
                + 0.3333333333333333
                * (
                    np.power(1.0 + n, -3)
                    + (
                        251.0
                        + 684.0 * (1.0 + n)
                        + 795.0 * np.power(1.0 + n, 2)
                        + 504.0 * np.power(1.0 + n, 3)
                        + 183.0 * np.power(1.0 + n, 4)
                        + 36.0 * np.power(1.0 + n, 5)
                        + 3.0 * np.power(1.0 + n, 6)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                    )
                    + S3
                )
            )
            / (4.0 + n)
            + n
            * (
                -1.0 / np.power(4.0 + n, 5)
                + 1.0823232337111381 / (4.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                        + S1
                    )
                )
                / np.power(4.0 + n, 4)
                - (
                    1.0
                    * (
                        0.5
                        * np.power(
                            1 / (1.0 + n)
                            + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                            + S1,
                            2,
                        )
                        + 0.5
                        * (
                            np.power(1.0 + n, -2)
                            + (5.0 + 6.0 * (1.0 + n) + 2.0 * np.power(1.0 + n, 2))
                            / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                            + S2
                        )
                    )
                )
                / np.power(4.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666
                        * np.power(
                            1 / (1.0 + n)
                            + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                            + S1,
                            3,
                        )
                        + 0.5
                        * (
                            1 / (1.0 + n)
                            + (3.0 + 2.0 * (1.0 + n)) / ((2.0 + n) * (3.0 + n))
                            + S1
                        )
                        * (
                            np.power(1.0 + n, -2)
                            + (5.0 + 6.0 * (1.0 + n) + 2.0 * np.power(1.0 + n, 2))
                            / (np.power(2.0 + n, 2) * np.power(3.0 + n, 2))
                            + S2
                        )
                        + 0.3333333333333333
                        * (
                            np.power(1.0 + n, -3)
                            + (
                                (3.0 + 2.0 * (1.0 + n))
                                * (3.0 + 3.0 * (1.0 + n) + np.power(1.0 + n, 2))
                            )
                            / (np.power(2.0 + n, 3) * np.power(3.0 + n, 3))
                            + S3
                        )
                    )
                )
                / np.power(4.0 + n, 2)
            )
        )
        - 0.1967571967137462
        * (
            (
                0.16666666666666666
                * np.power(
                    1 / (1.0 + n)
                    + (
                        2.0
                        * (5.0 + 2.0 * (1.0 + n))
                        * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                    + S1,
                    3,
                )
                + 0.5
                * (
                    1 / (1.0 + n)
                    + (
                        2.0
                        * (5.0 + 2.0 * (1.0 + n))
                        * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                    + S1
                )
                * (
                    np.power(1.0 + n, -2)
                    + (
                        2.0
                        * (
                            410.0
                            + 1030.0 * (1.0 + n)
                            + 1081.0 * np.power(1.0 + n, 2)
                            + 600.0 * np.power(1.0 + n, 3)
                            + 185.0 * np.power(1.0 + n, 4)
                            + 30.0 * np.power(1.0 + n, 5)
                            + 2.0 * np.power(1.0 + n, 6)
                        )
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                    )
                    + S2
                )
                + 0.3333333333333333
                * (
                    np.power(1.0 + n, -3)
                    + (
                        2.0
                        * (5.0 + 2.0 * (1.0 + n))
                        * (
                            1628.0
                            + 5050.0 * (1.0 + n)
                            + 6935.0 * np.power(1.0 + n, 2)
                            + 5495.0 * np.power(1.0 + n, 3)
                            + 2737.0 * np.power(1.0 + n, 4)
                            + 875.0 * np.power(1.0 + n, 5)
                            + 175.0 * np.power(1.0 + n, 6)
                            + 20.0 * np.power(1.0 + n, 7)
                            + np.power(1.0 + n, 8)
                        )
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                    )
                    + S3
                )
            )
            / (5.0 + n)
            + n
            * (
                -1.0 / np.power(5.0 + n, 5)
                + 1.0823232337111381 / (5.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                        + S1
                    )
                )
                / np.power(5.0 + n, 4)
                - (
                    1.0
                    * (
                        0.5
                        * np.power(
                            1 / (1.0 + n)
                            + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                            / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                            + S1,
                            2,
                        )
                        + 0.5
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                49.0
                                + 96.0 * (1.0 + n)
                                + 72.0 * np.power(1.0 + n, 2)
                                + 24.0 * np.power(1.0 + n, 3)
                                + 3.0 * np.power(1.0 + n, 4)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                            )
                            + S2
                        )
                    )
                )
                / np.power(5.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666
                        * np.power(
                            1 / (1.0 + n)
                            + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                            / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                            + S1,
                            3,
                        )
                        + 0.5
                        * (
                            1 / (1.0 + n)
                            + (11.0 + 12.0 * (1.0 + n) + 3.0 * np.power(1.0 + n, 2))
                            / ((2.0 + n) * (3.0 + n) * (4.0 + n))
                            + S1
                        )
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                49.0
                                + 96.0 * (1.0 + n)
                                + 72.0 * np.power(1.0 + n, 2)
                                + 24.0 * np.power(1.0 + n, 3)
                                + 3.0 * np.power(1.0 + n, 4)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                            )
                            + S2
                        )
                        + 0.3333333333333333
                        * (
                            np.power(1.0 + n, -3)
                            + (
                                251.0
                                + 684.0 * (1.0 + n)
                                + 795.0 * np.power(1.0 + n, 2)
                                + 504.0 * np.power(1.0 + n, 3)
                                + 183.0 * np.power(1.0 + n, 4)
                                + 36.0 * np.power(1.0 + n, 5)
                                + 3.0 * np.power(1.0 + n, 6)
                            )
                            / (
                                np.power(2.0 + n, 3)
                                * np.power(3.0 + n, 3)
                                * np.power(4.0 + n, 3)
                            )
                            + S3
                        )
                    )
                )
                / np.power(5.0 + n, 2)
            )
        )
        + 0.1530503487172192
        * (
            (
                0.16666666666666666
                * np.power(
                    1 / (1.0 + n)
                    + (
                        274.0
                        + 450.0 * (1.0 + n)
                        + 255.0 * np.power(1.0 + n, 2)
                        + 60.0 * np.power(1.0 + n, 3)
                        + 5.0 * np.power(1.0 + n, 4)
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                    + S1,
                    3,
                )
                + 0.5
                * (
                    1 / (1.0 + n)
                    + (
                        274.0
                        + 450.0 * (1.0 + n)
                        + 255.0 * np.power(1.0 + n, 2)
                        + 60.0 * np.power(1.0 + n, 3)
                        + 5.0 * np.power(1.0 + n, 4)
                    )
                    / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                    + S1
                )
                * (
                    np.power(1.0 + n, -2)
                    + (
                        21076.0
                        + 62100.0 * (1.0 + n)
                        + 79650.0 * np.power(1.0 + n, 2)
                        + 57660.0 * np.power(1.0 + n, 3)
                        + 25685.0 * np.power(1.0 + n, 4)
                        + 7200.0 * np.power(1.0 + n, 5)
                        + 1240.0 * np.power(1.0 + n, 6)
                        + 120.0 * np.power(1.0 + n, 7)
                        + 5.0 * np.power(1.0 + n, 8)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                    )
                    + S2
                )
                + 0.3333333333333333
                * (
                    np.power(1.0 + n, -3)
                    + (
                        2.048824e6
                        + 8.4339e6 * (1.0 + n)
                        + 1.595433e7 * np.power(1.0 + n, 2)
                        + 1.831824e7 * np.power(1.0 + n, 3)
                        + 1.419519e7 * np.power(1.0 + n, 4)
                        + 7.80975e6 * np.power(1.0 + n, 5)
                        + 3.124155e6 * np.power(1.0 + n, 6)
                        + 914760.0 * np.power(1.0 + n, 7)
                        + 194445.0 * np.power(1.0 + n, 8)
                        + 29250.0 * np.power(1.0 + n, 9)
                        + 2955.0 * np.power(1.0 + n, 10)
                        + 180.0 * np.power(1.0 + n, 11)
                        + 5.0 * np.power(1.0 + n, 12)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                    )
                    + S3
                )
            )
            / (6.0 + n)
            + n
            * (
                -1.0 / np.power(6.0 + n, 5)
                + 1.0823232337111381 / (6.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            2.0
                            * (5.0 + 2.0 * (1.0 + n))
                            * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                        + S1
                    )
                )
                / np.power(6.0 + n, 4)
                - (
                    1.0
                    * (
                        0.5
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                2.0
                                * (5.0 + 2.0 * (1.0 + n))
                                * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                            )
                            / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                            + S1,
                            2,
                        )
                        + 0.5
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                2.0
                                * (
                                    410.0
                                    + 1030.0 * (1.0 + n)
                                    + 1081.0 * np.power(1.0 + n, 2)
                                    + 600.0 * np.power(1.0 + n, 3)
                                    + 185.0 * np.power(1.0 + n, 4)
                                    + 30.0 * np.power(1.0 + n, 5)
                                    + 2.0 * np.power(1.0 + n, 6)
                                )
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                            )
                            + S2
                        )
                    )
                )
                / np.power(6.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                2.0
                                * (5.0 + 2.0 * (1.0 + n))
                                * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                            )
                            / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                            + S1,
                            3,
                        )
                        + 0.5
                        * (
                            1 / (1.0 + n)
                            + (
                                2.0
                                * (5.0 + 2.0 * (1.0 + n))
                                * (5.0 + 5.0 * (1.0 + n) + np.power(1.0 + n, 2))
                            )
                            / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n))
                            + S1
                        )
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                2.0
                                * (
                                    410.0
                                    + 1030.0 * (1.0 + n)
                                    + 1081.0 * np.power(1.0 + n, 2)
                                    + 600.0 * np.power(1.0 + n, 3)
                                    + 185.0 * np.power(1.0 + n, 4)
                                    + 30.0 * np.power(1.0 + n, 5)
                                    + 2.0 * np.power(1.0 + n, 6)
                                )
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                            )
                            + S2
                        )
                        + 0.3333333333333333
                        * (
                            np.power(1.0 + n, -3)
                            + (
                                2.0
                                * (5.0 + 2.0 * (1.0 + n))
                                * (
                                    1628.0
                                    + 5050.0 * (1.0 + n)
                                    + 6935.0 * np.power(1.0 + n, 2)
                                    + 5495.0 * np.power(1.0 + n, 3)
                                    + 2737.0 * np.power(1.0 + n, 4)
                                    + 875.0 * np.power(1.0 + n, 5)
                                    + 175.0 * np.power(1.0 + n, 6)
                                    + 20.0 * np.power(1.0 + n, 7)
                                    + np.power(1.0 + n, 8)
                                )
                            )
                            / (
                                np.power(2.0 + n, 3)
                                * np.power(3.0 + n, 3)
                                * np.power(4.0 + n, 3)
                                * np.power(5.0 + n, 3)
                            )
                            + S3
                        )
                    )
                )
                / np.power(6.0 + n, 2)
            )
        )
        - 0.10602798528818422
        * (
            (
                0.16666666666666666
                * np.power(
                    1 / (1.0 + n)
                    + (
                        (7.0 + 2.0 * (1.0 + n))
                        * (
                            252.0
                            + 392.0 * (1.0 + n)
                            + 203.0 * np.power(1.0 + n, 2)
                            + 42.0 * np.power(1.0 + n, 3)
                            + 3.0 * np.power(1.0 + n, 4)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                    )
                    + S1,
                    3,
                )
                + 0.5
                * (
                    1 / (1.0 + n)
                    + (
                        (7.0 + 2.0 * (1.0 + n))
                        * (
                            252.0
                            + 392.0 * (1.0 + n)
                            + 203.0 * np.power(1.0 + n, 2)
                            + 42.0 * np.power(1.0 + n, 3)
                            + 3.0 * np.power(1.0 + n, 4)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                    )
                    + S1
                )
                * (
                    np.power(1.0 + n, -2)
                    + (
                        773136.0
                        + 2.554272e6 * (1.0 + n)
                        + 3.762752e6 * np.power(1.0 + n, 2)
                        + 3.23736e6 * np.power(1.0 + n, 3)
                        + 1.797035e6 * np.power(1.0 + n, 4)
                        + 671790.0 * np.power(1.0 + n, 5)
                        + 171248.0 * np.power(1.0 + n, 6)
                        + 29400.0 * np.power(1.0 + n, 7)
                        + 3255.0 * np.power(1.0 + n, 8)
                        + 210.0 * np.power(1.0 + n, 9)
                        + 6.0 * np.power(1.0 + n, 10)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                        * np.power(7.0 + n, 2)
                    )
                    + S2
                )
                + 0.3333333333333333
                * (
                    np.power(1.0 + n, -3)
                    + (
                        (7.0 + 2.0 * (1.0 + n))
                        * (
                            6.3467712e7
                            + 2.75413824e8 * (1.0 + n)
                            + 5.54256432e8 * np.power(1.0 + n, 2)
                            + 6.84826352e8 * np.power(1.0 + n, 3)
                            + 5.79544028e8 * np.power(1.0 + n, 4)
                            + 3.54873092e8 * np.power(1.0 + n, 5)
                            + 1.61970683e8 * np.power(1.0 + n, 6)
                            + 5.5932611e7 * np.power(1.0 + n, 7)
                            + 1.4676674e7 * np.power(1.0 + n, 8)
                            + 2.911041e6 * np.power(1.0 + n, 9)
                            + 429534.0 * np.power(1.0 + n, 10)
                            + 45717.0 * np.power(1.0 + n, 11)
                            + 3318.0 * np.power(1.0 + n, 12)
                            + 147.0 * np.power(1.0 + n, 13)
                            + 3.0 * np.power(1.0 + n, 14)
                        )
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                    )
                    + S3
                )
            )
            / (7.0 + n)
            + n
            * (
                -1.0 / np.power(7.0 + n, 5)
                + 1.0823232337111381 / (7.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            274.0
                            + 450.0 * (1.0 + n)
                            + 255.0 * np.power(1.0 + n, 2)
                            + 60.0 * np.power(1.0 + n, 3)
                            + 5.0 * np.power(1.0 + n, 4)
                        )
                        / ((2.0 + n) * (3.0 + n) * (4.0 + n) * (5.0 + n) * (6.0 + n))
                        + S1
                    )
                )
                / np.power(7.0 + n, 4)
                - (
                    1.0
                    * (
                        0.5
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                274.0
                                + 450.0 * (1.0 + n)
                                + 255.0 * np.power(1.0 + n, 2)
                                + 60.0 * np.power(1.0 + n, 3)
                                + 5.0 * np.power(1.0 + n, 4)
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                            )
                            + S1,
                            2,
                        )
                        + 0.5
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                21076.0
                                + 62100.0 * (1.0 + n)
                                + 79650.0 * np.power(1.0 + n, 2)
                                + 57660.0 * np.power(1.0 + n, 3)
                                + 25685.0 * np.power(1.0 + n, 4)
                                + 7200.0 * np.power(1.0 + n, 5)
                                + 1240.0 * np.power(1.0 + n, 6)
                                + 120.0 * np.power(1.0 + n, 7)
                                + 5.0 * np.power(1.0 + n, 8)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                            )
                            + S2
                        )
                    )
                )
                / np.power(7.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                274.0
                                + 450.0 * (1.0 + n)
                                + 255.0 * np.power(1.0 + n, 2)
                                + 60.0 * np.power(1.0 + n, 3)
                                + 5.0 * np.power(1.0 + n, 4)
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                            )
                            + S1,
                            3,
                        )
                        + 0.5
                        * (
                            1 / (1.0 + n)
                            + (
                                274.0
                                + 450.0 * (1.0 + n)
                                + 255.0 * np.power(1.0 + n, 2)
                                + 60.0 * np.power(1.0 + n, 3)
                                + 5.0 * np.power(1.0 + n, 4)
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                            )
                            + S1
                        )
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                21076.0
                                + 62100.0 * (1.0 + n)
                                + 79650.0 * np.power(1.0 + n, 2)
                                + 57660.0 * np.power(1.0 + n, 3)
                                + 25685.0 * np.power(1.0 + n, 4)
                                + 7200.0 * np.power(1.0 + n, 5)
                                + 1240.0 * np.power(1.0 + n, 6)
                                + 120.0 * np.power(1.0 + n, 7)
                                + 5.0 * np.power(1.0 + n, 8)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                            )
                            + S2
                        )
                        + 0.3333333333333333
                        * (
                            np.power(1.0 + n, -3)
                            + (
                                2.048824e6
                                + 8.4339e6 * (1.0 + n)
                                + 1.595433e7 * np.power(1.0 + n, 2)
                                + 1.831824e7 * np.power(1.0 + n, 3)
                                + 1.419519e7 * np.power(1.0 + n, 4)
                                + 7.80975e6 * np.power(1.0 + n, 5)
                                + 3.124155e6 * np.power(1.0 + n, 6)
                                + 914760.0 * np.power(1.0 + n, 7)
                                + 194445.0 * np.power(1.0 + n, 8)
                                + 29250.0 * np.power(1.0 + n, 9)
                                + 2955.0 * np.power(1.0 + n, 10)
                                + 180.0 * np.power(1.0 + n, 11)
                                + 5.0 * np.power(1.0 + n, 12)
                            )
                            / (
                                np.power(2.0 + n, 3)
                                * np.power(3.0 + n, 3)
                                * np.power(4.0 + n, 3)
                                * np.power(5.0 + n, 3)
                                * np.power(6.0 + n, 3)
                            )
                            + S3
                        )
                    )
                )
                / np.power(7.0 + n, 2)
            )
        )
        + 0.056951717764149916
        * (
            (
                0.16666666666666666
                * np.power(
                    1 / (1.0 + n)
                    + (
                        13068.0
                        + 26264.0 * (1.0 + n)
                        + 20307.0 * np.power(1.0 + n, 2)
                        + 7840.0 * np.power(1.0 + n, 3)
                        + 1610.0 * np.power(1.0 + n, 4)
                        + 168.0 * np.power(1.0 + n, 5)
                        + 7.0 * np.power(1.0 + n, 6)
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                    )
                    + S1,
                    3,
                )
                + 0.5
                * (
                    1 / (1.0 + n)
                    + (
                        13068.0
                        + 26264.0 * (1.0 + n)
                        + 20307.0 * np.power(1.0 + n, 2)
                        + 7840.0 * np.power(1.0 + n, 3)
                        + 1610.0 * np.power(1.0 + n, 4)
                        + 168.0 * np.power(1.0 + n, 5)
                        + 7.0 * np.power(1.0 + n, 6)
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                    )
                    + S1
                )
                * (
                    np.power(1.0 + n, -2)
                    + (
                        3.8402064e7
                        + 1.38523392e8 * (1.0 + n)
                        + 2.26358048e8 * np.power(1.0 + n, 2)
                        + 2.20651312e8 * np.power(1.0 + n, 3)
                        + 1.42622963e8 * np.power(1.0 + n, 4)
                        + 6.434848e7 * np.power(1.0 + n, 5)
                        + 2.07774e7 * np.power(1.0 + n, 6)
                        + 4.838848e6 * np.power(1.0 + n, 7)
                        + 807086.0 * np.power(1.0 + n, 8)
                        + 94080.0 * np.power(1.0 + n, 9)
                        + 7280.0 * np.power(1.0 + n, 10)
                        + 336.0 * np.power(1.0 + n, 11)
                        + 7.0 * np.power(1.0 + n, 12)
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                        * np.power(7.0 + n, 2)
                        * np.power(8.0 + n, 2)
                    )
                    + S2
                )
                + 0.3333333333333333
                * (
                    np.power(1.0 + n, -3)
                    + (
                        1.52759224512e11
                        + 7.72859090304e11 * (1.0 + n)
                        + 1.840340570544e12 * np.power(1.0 + n, 2)
                        + 2.738393029568e12 * np.power(1.0 + n, 3)
                        + 2.850741832092e12 * np.power(1.0 + n, 4)
                        + 2.203027167432e12 * np.power(1.0 + n, 5)
                        + 1.308849323187e12 * np.power(1.0 + n, 6)
                        + 6.10929168192e11 * np.power(1.0 + n, 7)
                        + 2.2702816521e11 * np.power(1.0 + n, 8)
                        + 6.7650709672e10 * np.power(1.0 + n, 9)
                        + 1.6200316881e10 * np.power(1.0 + n, 10)
                        + 3.110018688e9 * np.power(1.0 + n, 11)
                        + 4.75055e8 * np.power(1.0 + n, 12)
                        + 5.6957208e7 * np.power(1.0 + n, 13)
                        + 5.242629e6 * np.power(1.0 + n, 14)
                        + 357504.0 * np.power(1.0 + n, 15)
                        + 17010.0 * np.power(1.0 + n, 16)
                        + 504.0 * np.power(1.0 + n, 17)
                        + 7.0 * np.power(1.0 + n, 18)
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                        * np.power(8.0 + n, 3)
                    )
                    + S3
                )
            )
            / (8.0 + n)
            + n
            * (
                -1.0 / np.power(8.0 + n, 5)
                + 1.0823232337111381 / (8.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            (7.0 + 2.0 * (1.0 + n))
                            * (
                                252.0
                                + 392.0 * (1.0 + n)
                                + 203.0 * np.power(1.0 + n, 2)
                                + 42.0 * np.power(1.0 + n, 3)
                                + 3.0 * np.power(1.0 + n, 4)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(8.0 + n, 4)
                - (
                    1.0
                    * (
                        0.5
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                (7.0 + 2.0 * (1.0 + n))
                                * (
                                    252.0
                                    + 392.0 * (1.0 + n)
                                    + 203.0 * np.power(1.0 + n, 2)
                                    + 42.0 * np.power(1.0 + n, 3)
                                    + 3.0 * np.power(1.0 + n, 4)
                                )
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                            )
                            + S1,
                            2,
                        )
                        + 0.5
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                773136.0
                                + 2.554272e6 * (1.0 + n)
                                + 3.762752e6 * np.power(1.0 + n, 2)
                                + 3.23736e6 * np.power(1.0 + n, 3)
                                + 1.797035e6 * np.power(1.0 + n, 4)
                                + 671790.0 * np.power(1.0 + n, 5)
                                + 171248.0 * np.power(1.0 + n, 6)
                                + 29400.0 * np.power(1.0 + n, 7)
                                + 3255.0 * np.power(1.0 + n, 8)
                                + 210.0 * np.power(1.0 + n, 9)
                                + 6.0 * np.power(1.0 + n, 10)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                                * np.power(7.0 + n, 2)
                            )
                            + S2
                        )
                    )
                )
                / np.power(8.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                (7.0 + 2.0 * (1.0 + n))
                                * (
                                    252.0
                                    + 392.0 * (1.0 + n)
                                    + 203.0 * np.power(1.0 + n, 2)
                                    + 42.0 * np.power(1.0 + n, 3)
                                    + 3.0 * np.power(1.0 + n, 4)
                                )
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                            )
                            + S1,
                            3,
                        )
                        + 0.5
                        * (
                            1 / (1.0 + n)
                            + (
                                (7.0 + 2.0 * (1.0 + n))
                                * (
                                    252.0
                                    + 392.0 * (1.0 + n)
                                    + 203.0 * np.power(1.0 + n, 2)
                                    + 42.0 * np.power(1.0 + n, 3)
                                    + 3.0 * np.power(1.0 + n, 4)
                                )
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                            )
                            + S1
                        )
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                773136.0
                                + 2.554272e6 * (1.0 + n)
                                + 3.762752e6 * np.power(1.0 + n, 2)
                                + 3.23736e6 * np.power(1.0 + n, 3)
                                + 1.797035e6 * np.power(1.0 + n, 4)
                                + 671790.0 * np.power(1.0 + n, 5)
                                + 171248.0 * np.power(1.0 + n, 6)
                                + 29400.0 * np.power(1.0 + n, 7)
                                + 3255.0 * np.power(1.0 + n, 8)
                                + 210.0 * np.power(1.0 + n, 9)
                                + 6.0 * np.power(1.0 + n, 10)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                                * np.power(7.0 + n, 2)
                            )
                            + S2
                        )
                        + 0.3333333333333333
                        * (
                            np.power(1.0 + n, -3)
                            + (
                                (7.0 + 2.0 * (1.0 + n))
                                * (
                                    6.3467712e7
                                    + 2.75413824e8 * (1.0 + n)
                                    + 5.54256432e8 * np.power(1.0 + n, 2)
                                    + 6.84826352e8 * np.power(1.0 + n, 3)
                                    + 5.79544028e8 * np.power(1.0 + n, 4)
                                    + 3.54873092e8 * np.power(1.0 + n, 5)
                                    + 1.61970683e8 * np.power(1.0 + n, 6)
                                    + 5.5932611e7 * np.power(1.0 + n, 7)
                                    + 1.4676674e7 * np.power(1.0 + n, 8)
                                    + 2.911041e6 * np.power(1.0 + n, 9)
                                    + 429534.0 * np.power(1.0 + n, 10)
                                    + 45717.0 * np.power(1.0 + n, 11)
                                    + 3318.0 * np.power(1.0 + n, 12)
                                    + 147.0 * np.power(1.0 + n, 13)
                                    + 3.0 * np.power(1.0 + n, 14)
                                )
                            )
                            / (
                                np.power(2.0 + n, 3)
                                * np.power(3.0 + n, 3)
                                * np.power(4.0 + n, 3)
                                * np.power(5.0 + n, 3)
                                * np.power(6.0 + n, 3)
                                * np.power(7.0 + n, 3)
                            )
                            + S3
                        )
                    )
                )
                / np.power(8.0 + n, 2)
            )
        )
        - 0.019847559824380426
        * (
            (
                0.16666666666666666
                * np.power(
                    1 / (1.0 + n)
                    + (
                        4.0
                        * (9.0 + 2.0 * (1.0 + n))
                        * (
                            3044.0
                            + 5886.0 * (1.0 + n)
                            + 4299.0 * np.power(1.0 + n, 2)
                            + 1539.0 * np.power(1.0 + n, 3)
                            + 288.0 * np.power(1.0 + n, 4)
                            + 27.0 * np.power(1.0 + n, 5)
                            + np.power(1.0 + n, 6)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                    )
                    + S1,
                    3,
                )
                + 0.5
                * (
                    1 / (1.0 + n)
                    + (
                        4.0
                        * (9.0 + 2.0 * (1.0 + n))
                        * (
                            3044.0
                            + 5886.0 * (1.0 + n)
                            + 4299.0 * np.power(1.0 + n, 2)
                            + 1539.0 * np.power(1.0 + n, 3)
                            + 288.0 * np.power(1.0 + n, 4)
                            + 27.0 * np.power(1.0 + n, 5)
                            + np.power(1.0 + n, 6)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                    )
                    + S1
                )
                * (
                    np.power(1.0 + n, -2)
                    + (
                        4.0
                        * (
                            6.20783424e8
                            + 2.402913888e9 * (1.0 + n)
                            + 4.261208648e9 * np.power(1.0 + n, 2)
                            + 4.5733464e9 * np.power(1.0 + n, 3)
                            + 3.31344237e9 * np.power(1.0 + n, 4)
                            + 1.713293694e9 * np.power(1.0 + n, 5)
                            + 6.51986769e8 * np.power(1.0 + n, 6)
                            + 1.85551632e8 * np.power(1.0 + n, 7)
                            + 3.9703709e7 * np.power(1.0 + n, 8)
                            + 6.360228e6 * np.power(1.0 + n, 9)
                            + 751317.0 * np.power(1.0 + n, 10)
                            + 63504.0 * np.power(1.0 + n, 11)
                            + 3633.0 * np.power(1.0 + n, 12)
                            + 126.0 * np.power(1.0 + n, 13)
                            + 2.0 * np.power(1.0 + n, 14)
                        )
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                        * np.power(7.0 + n, 2)
                        * np.power(8.0 + n, 2)
                        * np.power(9.0 + n, 2)
                    )
                    + S2
                )
                + 0.3333333333333333
                * (
                    np.power(1.0 + n, -3)
                    + (
                        4.0
                        * (9.0 + 2.0 * (1.0 + n))
                        * (
                            2.176131861504e12
                            + 1.135056707712e13 * (1.0 + n)
                            + 2.7974661270464e13 * np.power(1.0 + n, 2)
                            + 4.3284545841312e13 * np.power(1.0 + n, 3)
                            + 4.7115984701808e13 * np.power(1.0 + n, 4)
                            + 3.8323387681704e13 * np.power(1.0 + n, 5)
                            + 2.4153337475604e13 * np.power(1.0 + n, 6)
                            + 1.2072584201292e13 * np.power(1.0 + n, 7)
                            + 4.858675624797e12 * np.power(1.0 + n, 8)
                            + 1.589624084295e12 * np.power(1.0 + n, 9)
                            + 4.25052833112e11 * np.power(1.0 + n, 10)
                            + 9.304706925e10 * np.power(1.0 + n, 11)
                            + 1.6646348871e10 * np.power(1.0 + n, 12)
                            + 2.420753526e9 * np.power(1.0 + n, 13)
                            + 2.8338678e8 * np.power(1.0 + n, 14)
                            + 2.6298432e7 * np.power(1.0 + n, 15)
                            + 1.889595e6 * np.power(1.0 + n, 16)
                            + 101331.0 * np.power(1.0 + n, 17)
                            + 3816.0 * np.power(1.0 + n, 18)
                            + 90.0 * np.power(1.0 + n, 19)
                            + np.power(1.0 + n, 20)
                        )
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                        * np.power(8.0 + n, 3)
                        * np.power(9.0 + n, 3)
                    )
                    + S3
                )
            )
            / (9.0 + n)
            + n
            * (
                -1.0 / np.power(9.0 + n, 5)
                + 1.0823232337111381 / (9.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            13068.0
                            + 26264.0 * (1.0 + n)
                            + 20307.0 * np.power(1.0 + n, 2)
                            + 7840.0 * np.power(1.0 + n, 3)
                            + 1610.0 * np.power(1.0 + n, 4)
                            + 168.0 * np.power(1.0 + n, 5)
                            + 7.0 * np.power(1.0 + n, 6)
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(9.0 + n, 4)
                - (
                    1.0
                    * (
                        0.5
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                13068.0
                                + 26264.0 * (1.0 + n)
                                + 20307.0 * np.power(1.0 + n, 2)
                                + 7840.0 * np.power(1.0 + n, 3)
                                + 1610.0 * np.power(1.0 + n, 4)
                                + 168.0 * np.power(1.0 + n, 5)
                                + 7.0 * np.power(1.0 + n, 6)
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                                * (8.0 + n)
                            )
                            + S1,
                            2,
                        )
                        + 0.5
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                3.8402064e7
                                + 1.38523392e8 * (1.0 + n)
                                + 2.26358048e8 * np.power(1.0 + n, 2)
                                + 2.20651312e8 * np.power(1.0 + n, 3)
                                + 1.42622963e8 * np.power(1.0 + n, 4)
                                + 6.434848e7 * np.power(1.0 + n, 5)
                                + 2.07774e7 * np.power(1.0 + n, 6)
                                + 4.838848e6 * np.power(1.0 + n, 7)
                                + 807086.0 * np.power(1.0 + n, 8)
                                + 94080.0 * np.power(1.0 + n, 9)
                                + 7280.0 * np.power(1.0 + n, 10)
                                + 336.0 * np.power(1.0 + n, 11)
                                + 7.0 * np.power(1.0 + n, 12)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                                * np.power(7.0 + n, 2)
                                * np.power(8.0 + n, 2)
                            )
                            + S2
                        )
                    )
                )
                / np.power(9.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                13068.0
                                + 26264.0 * (1.0 + n)
                                + 20307.0 * np.power(1.0 + n, 2)
                                + 7840.0 * np.power(1.0 + n, 3)
                                + 1610.0 * np.power(1.0 + n, 4)
                                + 168.0 * np.power(1.0 + n, 5)
                                + 7.0 * np.power(1.0 + n, 6)
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                                * (8.0 + n)
                            )
                            + S1,
                            3,
                        )
                        + 0.5
                        * (
                            1 / (1.0 + n)
                            + (
                                13068.0
                                + 26264.0 * (1.0 + n)
                                + 20307.0 * np.power(1.0 + n, 2)
                                + 7840.0 * np.power(1.0 + n, 3)
                                + 1610.0 * np.power(1.0 + n, 4)
                                + 168.0 * np.power(1.0 + n, 5)
                                + 7.0 * np.power(1.0 + n, 6)
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                                * (8.0 + n)
                            )
                            + S1
                        )
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                3.8402064e7
                                + 1.38523392e8 * (1.0 + n)
                                + 2.26358048e8 * np.power(1.0 + n, 2)
                                + 2.20651312e8 * np.power(1.0 + n, 3)
                                + 1.42622963e8 * np.power(1.0 + n, 4)
                                + 6.434848e7 * np.power(1.0 + n, 5)
                                + 2.07774e7 * np.power(1.0 + n, 6)
                                + 4.838848e6 * np.power(1.0 + n, 7)
                                + 807086.0 * np.power(1.0 + n, 8)
                                + 94080.0 * np.power(1.0 + n, 9)
                                + 7280.0 * np.power(1.0 + n, 10)
                                + 336.0 * np.power(1.0 + n, 11)
                                + 7.0 * np.power(1.0 + n, 12)
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                                * np.power(7.0 + n, 2)
                                * np.power(8.0 + n, 2)
                            )
                            + S2
                        )
                        + 0.3333333333333333
                        * (
                            np.power(1.0 + n, -3)
                            + (
                                1.52759224512e11
                                + 7.72859090304e11 * (1.0 + n)
                                + 1.840340570544e12 * np.power(1.0 + n, 2)
                                + 2.738393029568e12 * np.power(1.0 + n, 3)
                                + 2.850741832092e12 * np.power(1.0 + n, 4)
                                + 2.203027167432e12 * np.power(1.0 + n, 5)
                                + 1.308849323187e12 * np.power(1.0 + n, 6)
                                + 6.10929168192e11 * np.power(1.0 + n, 7)
                                + 2.2702816521e11 * np.power(1.0 + n, 8)
                                + 6.7650709672e10 * np.power(1.0 + n, 9)
                                + 1.6200316881e10 * np.power(1.0 + n, 10)
                                + 3.110018688e9 * np.power(1.0 + n, 11)
                                + 4.75055e8 * np.power(1.0 + n, 12)
                                + 5.6957208e7 * np.power(1.0 + n, 13)
                                + 5.242629e6 * np.power(1.0 + n, 14)
                                + 357504.0 * np.power(1.0 + n, 15)
                                + 17010.0 * np.power(1.0 + n, 16)
                                + 504.0 * np.power(1.0 + n, 17)
                                + 7.0 * np.power(1.0 + n, 18)
                            )
                            / (
                                np.power(2.0 + n, 3)
                                * np.power(3.0 + n, 3)
                                * np.power(4.0 + n, 3)
                                * np.power(5.0 + n, 3)
                                * np.power(6.0 + n, 3)
                                * np.power(7.0 + n, 3)
                                * np.power(8.0 + n, 3)
                            )
                            + S3
                        )
                    )
                )
                / np.power(9.0 + n, 2)
            )
        )
        + 0.003243204652309423
        * (
            (
                0.16666666666666666
                * np.power(
                    1 / (1.0 + n)
                    + (
                        3.0
                        * (
                            342192.0
                            + 781800.0 * (1.0 + n)
                            + 723680.0 * np.power(1.0 + n, 2)
                            + 359100.0 * np.power(1.0 + n, 3)
                            + 105455.0 * np.power(1.0 + n, 4)
                            + 18900.0 * np.power(1.0 + n, 5)
                            + 2030.0 * np.power(1.0 + n, 6)
                            + 120.0 * np.power(1.0 + n, 7)
                            + 3.0 * np.power(1.0 + n, 8)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                        * (10.0 + n)
                    )
                    + S1,
                    3,
                )
                + 0.5
                * (
                    1 / (1.0 + n)
                    + (
                        3.0
                        * (
                            342192.0
                            + 781800.0 * (1.0 + n)
                            + 723680.0 * np.power(1.0 + n, 2)
                            + 359100.0 * np.power(1.0 + n, 3)
                            + 105455.0 * np.power(1.0 + n, 4)
                            + 18900.0 * np.power(1.0 + n, 5)
                            + 2030.0 * np.power(1.0 + n, 6)
                            + 120.0 * np.power(1.0 + n, 7)
                            + 3.0 * np.power(1.0 + n, 8)
                        )
                    )
                    / (
                        (2.0 + n)
                        * (3.0 + n)
                        * (4.0 + n)
                        * (5.0 + n)
                        * (6.0 + n)
                        * (7.0 + n)
                        * (8.0 + n)
                        * (9.0 + n)
                        * (10.0 + n)
                    )
                    + S1
                )
                * (
                    np.power(1.0 + n, -2)
                    + (
                        3.0
                        * (
                            6.7586510592e10
                            + 2.7735912e11 * (1.0 + n)
                            + 5.25886236e11 * np.power(1.0 + n, 2)
                            + 6.098325648e11 * np.power(1.0 + n, 3)
                            + 4.8346372324e11 * np.power(1.0 + n, 4)
                            + 2.77716663e11 * np.power(1.0 + n, 5)
                            + 1.195744907e11 * np.power(1.0 + n, 6)
                            + 3.937668588e10 * np.power(1.0 + n, 7)
                            + 1.0027662147e10 * np.power(1.0 + n, 8)
                            + 1.982481e9 * np.power(1.0 + n, 9)
                            + 3.0344942e8 * np.power(1.0 + n, 10)
                            + 3.560508e7 * np.power(1.0 + n, 11)
                            + 3.141418e6 * np.power(1.0 + n, 12)
                            + 201600.0 * np.power(1.0 + n, 13)
                            + 8880.0 * np.power(1.0 + n, 14)
                            + 240.0 * np.power(1.0 + n, 15)
                            + 3.0 * np.power(1.0 + n, 16)
                        )
                    )
                    / (
                        np.power(2.0 + n, 2)
                        * np.power(3.0 + n, 2)
                        * np.power(4.0 + n, 2)
                        * np.power(5.0 + n, 2)
                        * np.power(6.0 + n, 2)
                        * np.power(7.0 + n, 2)
                        * np.power(8.0 + n, 2)
                        * np.power(9.0 + n, 2)
                        * np.power(10.0 + n, 2)
                    )
                    + S2
                )
                + 0.3333333333333333
                * (
                    np.power(1.0 + n, -3)
                    + (
                        3.0
                        * (
                            1.905865096469299e16
                            + 1.100489126093568e17 * (1.0 + n)
                            + 3.026775163197197e17 * np.power(1.0 + n, 2)
                            + 5.274174874222368e17 * np.power(1.0 + n, 3)
                            + 6.532963289874519e17 * np.power(1.0 + n, 4)
                            + 6.118731135138024e17 * np.power(1.0 + n, 5)
                            + 4.5005054609223366e17 * np.power(1.0 + n, 6)
                            + 2.6656016992225488e17 * np.power(1.0 + n, 7)
                            + 1.2935179046741138e17 * np.power(1.0 + n, 8)
                            + 5.2054701631938e16 * np.power(1.0 + n, 9)
                            + 1.751929057804686e16 * np.power(1.0 + n, 10)
                            + 4.95861919609626e15 * np.power(1.0 + n, 11)
                            + 1.184087108357771e15 * np.power(1.0 + n, 12)
                            + 2.388131885349e14 * np.power(1.0 + n, 13)
                            + 4.064171822907e13 * np.power(1.0 + n, 14)
                            + 5.818192578e12 * np.power(1.0 + n, 15)
                            + 6.96833685225e11 * np.power(1.0 + n, 16)
                            + 6.92402094e10 * np.power(1.0 + n, 17)
                            + 5.63902616e9 * np.power(1.0 + n, 18)
                            + 3.699297e8 * np.power(1.0 + n, 19)
                            + 1.9060797e7 * np.power(1.0 + n, 20)
                            + 742500.0 * np.power(1.0 + n, 21)
                            + 20550.0 * np.power(1.0 + n, 22)
                            + 360.0 * np.power(1.0 + n, 23)
                            + 3.0 * np.power(1.0 + n, 24)
                        )
                    )
                    / (
                        np.power(2.0 + n, 3)
                        * np.power(3.0 + n, 3)
                        * np.power(4.0 + n, 3)
                        * np.power(5.0 + n, 3)
                        * np.power(6.0 + n, 3)
                        * np.power(7.0 + n, 3)
                        * np.power(8.0 + n, 3)
                        * np.power(9.0 + n, 3)
                        * np.power(10.0 + n, 3)
                    )
                    + S3
                )
            )
            / (10.0 + n)
            + n
            * (
                -1.0 / np.power(10.0 + n, 5)
                + 1.0823232337111381 / (10.0 + n)
                - (
                    1.0
                    * (
                        1 / (1.0 + n)
                        + (
                            4.0
                            * (9.0 + 2.0 * (1.0 + n))
                            * (
                                3044.0
                                + 5886.0 * (1.0 + n)
                                + 4299.0 * np.power(1.0 + n, 2)
                                + 1539.0 * np.power(1.0 + n, 3)
                                + 288.0 * np.power(1.0 + n, 4)
                                + 27.0 * np.power(1.0 + n, 5)
                                + np.power(1.0 + n, 6)
                            )
                        )
                        / (
                            (2.0 + n)
                            * (3.0 + n)
                            * (4.0 + n)
                            * (5.0 + n)
                            * (6.0 + n)
                            * (7.0 + n)
                            * (8.0 + n)
                            * (9.0 + n)
                        )
                        + S1
                    )
                )
                / np.power(10.0 + n, 4)
                - (
                    1.0
                    * (
                        0.5
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                4.0
                                * (9.0 + 2.0 * (1.0 + n))
                                * (
                                    3044.0
                                    + 5886.0 * (1.0 + n)
                                    + 4299.0 * np.power(1.0 + n, 2)
                                    + 1539.0 * np.power(1.0 + n, 3)
                                    + 288.0 * np.power(1.0 + n, 4)
                                    + 27.0 * np.power(1.0 + n, 5)
                                    + np.power(1.0 + n, 6)
                                )
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                                * (8.0 + n)
                                * (9.0 + n)
                            )
                            + S1,
                            2,
                        )
                        + 0.5
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                4.0
                                * (
                                    6.20783424e8
                                    + 2.402913888e9 * (1.0 + n)
                                    + 4.261208648e9 * np.power(1.0 + n, 2)
                                    + 4.5733464e9 * np.power(1.0 + n, 3)
                                    + 3.31344237e9 * np.power(1.0 + n, 4)
                                    + 1.713293694e9 * np.power(1.0 + n, 5)
                                    + 6.51986769e8 * np.power(1.0 + n, 6)
                                    + 1.85551632e8 * np.power(1.0 + n, 7)
                                    + 3.9703709e7 * np.power(1.0 + n, 8)
                                    + 6.360228e6 * np.power(1.0 + n, 9)
                                    + 751317.0 * np.power(1.0 + n, 10)
                                    + 63504.0 * np.power(1.0 + n, 11)
                                    + 3633.0 * np.power(1.0 + n, 12)
                                    + 126.0 * np.power(1.0 + n, 13)
                                    + 2.0 * np.power(1.0 + n, 14)
                                )
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                                * np.power(7.0 + n, 2)
                                * np.power(8.0 + n, 2)
                                * np.power(9.0 + n, 2)
                            )
                            + S2
                        )
                    )
                )
                / np.power(10.0 + n, 3)
                - (
                    1.0
                    * (
                        0.16666666666666666
                        * np.power(
                            1 / (1.0 + n)
                            + (
                                4.0
                                * (9.0 + 2.0 * (1.0 + n))
                                * (
                                    3044.0
                                    + 5886.0 * (1.0 + n)
                                    + 4299.0 * np.power(1.0 + n, 2)
                                    + 1539.0 * np.power(1.0 + n, 3)
                                    + 288.0 * np.power(1.0 + n, 4)
                                    + 27.0 * np.power(1.0 + n, 5)
                                    + np.power(1.0 + n, 6)
                                )
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                                * (8.0 + n)
                                * (9.0 + n)
                            )
                            + S1,
                            3,
                        )
                        + 0.5
                        * (
                            1 / (1.0 + n)
                            + (
                                4.0
                                * (9.0 + 2.0 * (1.0 + n))
                                * (
                                    3044.0
                                    + 5886.0 * (1.0 + n)
                                    + 4299.0 * np.power(1.0 + n, 2)
                                    + 1539.0 * np.power(1.0 + n, 3)
                                    + 288.0 * np.power(1.0 + n, 4)
                                    + 27.0 * np.power(1.0 + n, 5)
                                    + np.power(1.0 + n, 6)
                                )
                            )
                            / (
                                (2.0 + n)
                                * (3.0 + n)
                                * (4.0 + n)
                                * (5.0 + n)
                                * (6.0 + n)
                                * (7.0 + n)
                                * (8.0 + n)
                                * (9.0 + n)
                            )
                            + S1
                        )
                        * (
                            np.power(1.0 + n, -2)
                            + (
                                4.0
                                * (
                                    6.20783424e8
                                    + 2.402913888e9 * (1.0 + n)
                                    + 4.261208648e9 * np.power(1.0 + n, 2)
                                    + 4.5733464e9 * np.power(1.0 + n, 3)
                                    + 3.31344237e9 * np.power(1.0 + n, 4)
                                    + 1.713293694e9 * np.power(1.0 + n, 5)
                                    + 6.51986769e8 * np.power(1.0 + n, 6)
                                    + 1.85551632e8 * np.power(1.0 + n, 7)
                                    + 3.9703709e7 * np.power(1.0 + n, 8)
                                    + 6.360228e6 * np.power(1.0 + n, 9)
                                    + 751317.0 * np.power(1.0 + n, 10)
                                    + 63504.0 * np.power(1.0 + n, 11)
                                    + 3633.0 * np.power(1.0 + n, 12)
                                    + 126.0 * np.power(1.0 + n, 13)
                                    + 2.0 * np.power(1.0 + n, 14)
                                )
                            )
                            / (
                                np.power(2.0 + n, 2)
                                * np.power(3.0 + n, 2)
                                * np.power(4.0 + n, 2)
                                * np.power(5.0 + n, 2)
                                * np.power(6.0 + n, 2)
                                * np.power(7.0 + n, 2)
                                * np.power(8.0 + n, 2)
                                * np.power(9.0 + n, 2)
                            )
                            + S2
                        )
                        + 0.3333333333333333
                        * (
                            np.power(1.0 + n, -3)
                            + (
                                4.0
                                * (9.0 + 2.0 * (1.0 + n))
                                * (
                                    2.176131861504e12
                                    + 1.135056707712e13 * (1.0 + n)
                                    + 2.7974661270464e13 * np.power(1.0 + n, 2)
                                    + 4.3284545841312e13 * np.power(1.0 + n, 3)
                                    + 4.7115984701808e13 * np.power(1.0 + n, 4)
                                    + 3.8323387681704e13 * np.power(1.0 + n, 5)
                                    + 2.4153337475604e13 * np.power(1.0 + n, 6)
                                    + 1.2072584201292e13 * np.power(1.0 + n, 7)
                                    + 4.858675624797e12 * np.power(1.0 + n, 8)
                                    + 1.589624084295e12 * np.power(1.0 + n, 9)
                                    + 4.25052833112e11 * np.power(1.0 + n, 10)
                                    + 9.304706925e10 * np.power(1.0 + n, 11)
                                    + 1.6646348871e10 * np.power(1.0 + n, 12)
                                    + 2.420753526e9 * np.power(1.0 + n, 13)
                                    + 2.8338678e8 * np.power(1.0 + n, 14)
                                    + 2.6298432e7 * np.power(1.0 + n, 15)
                                    + 1.889595e6 * np.power(1.0 + n, 16)
                                    + 101331.0 * np.power(1.0 + n, 17)
                                    + 3816.0 * np.power(1.0 + n, 18)
                                    + 90.0 * np.power(1.0 + n, 19)
                                    + np.power(1.0 + n, 20)
                                )
                            )
                            / (
                                np.power(2.0 + n, 3)
                                * np.power(3.0 + n, 3)
                                * np.power(4.0 + n, 3)
                                * np.power(5.0 + n, 3)
                                * np.power(6.0 + n, 3)
                                * np.power(7.0 + n, 3)
                                * np.power(8.0 + n, 3)
                                * np.power(9.0 + n, 3)
                            )
                            + S3
                        )
                    )
                )
                / np.power(10.0 + n, 2)
            )
        )
    )
