# pylint: skip-file
"""This module contains implemtation of F17.

When using it, please cite :cite:`Blumlein:2009ta`.
Mellin transform is defined with the convention x^(N).
"""
import numba as nb
import numpy as np


@nb.njit(cache=True)
def F17(n, S1, S2, S3):
    """Implements eq 9.35 of :cite:`Blumlein:2009ta`"""
    return (
        0.006250114775233491 * n
        - (0.003746947390066303 * n) / (2.0 + n)
        - (0.0023126098502258036 * n) / (3.0 + n)
        + (0.0099367254968704 * n) / (4.0 + n)
        + (0.011620487178071414 * n) / (5.0 + n)
        - (0.06649377693249485 * n) / (6.0 + n)
        + (0.19948261641123977 * n) / (7.0 + n)
        - (0.4211429420070887 * n) / (8.0 + n)
        + (0.6134519590989854 * n) / (9.0 + n)
        - (0.6080710864181954 * n) / (10.0 + n)
        + (0.39145233830114945 * n) / (11.0 + n)
        - (0.1477783591293883 * n) / (12.0 + n)
        + (0.02482853473316387 * n) / (13.0 + n)
        + 0.007477407032205702 * (-1.0 + 1 / (1.0 + n))
        - 0.000051440329218106995
        * n
        * (
            121.50223994844418
            + 83580.0 / (1.0 + n)
            - 3390.0 / (2.0 + n)
            + 320.0 / (3.0 + n)
            + (67770.0 * (1.0 + (1.0 + n) * S1)) / np.power(1.0 + n, 2)
            - (5805.0 * (1.0 + (2.0 + n) * (1 / (1.0 + n) + S1))) / np.power(2.0 + n, 2)
            + (720.0 * (1.0 + (3.0 + n) * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)))
            / np.power(3.0 + n, 2)
            - (
                83725.36366334453
                * (
                    1.0
                    + n
                    * (1 / (1.0 + n) + (1.0 - 2.0 * (1.0 + n)) / (n * (1.0 + n)) + S1)
                )
            )
            / np.power(n, 2)
            - (
                9180.0
                * (
                    1.0
                    + (2.0 + n) * (1 / (1.0 + n) + S1)
                    + np.power(2.0 + n, 2)
                    * (
                        np.power(1.0 + n, -2)
                        + S1 / (1.0 + n)
                        + 0.5 * (np.power(S1, 2) + S2)
                    )
                )
            )
            / np.power(2.0 + n, 3)
            + (
                52920.0
                * (
                    1.0
                    + (1.0 + n) * S1
                    + np.power(1.0 + n, 2)
                    * (
                        np.power(1.0 + n, -2)
                        + S1 / (1.0 + n)
                        - (1.0 * (1 / (1.0 + n) + S1)) / (1.0 + n)
                        + 0.5 * (np.power(S1, 2) + S2)
                    )
                )
            )
            / np.power(1.0 + n, 3)
            + (
                1440.0
                * (
                    1.0
                    + (3.0 + n) * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)
                    + np.power(3.0 + n, 2)
                    * (
                        np.power(1.0 + n, -2)
                        + np.power(2.0 + n, -2)
                        + S1 / (1.0 + n)
                        + (1 / (1.0 + n) + S1) / (2.0 + n)
                        + 0.5 * (np.power(S1, 2) + S2)
                    )
                )
            )
            / np.power(3.0 + n, 3)
            - (
                45180.0
                * (
                    1.0
                    + n
                    * (1 / (1.0 + n) + (1.0 - 2.0 * (1.0 + n)) / (n * (1.0 + n)) + S1)
                    + np.power(n, 2)
                    * (
                        np.power(1.0 + n, -2)
                        + 1 / (n * (1.0 + n))
                        + S1 / (1.0 + n)
                        + ((1.0 - 2.0 * (1.0 + n)) * (1 / (1.0 + n) + S1))
                        / (n * (1.0 + n))
                        + 0.5 * (np.power(S1, 2) + S2)
                    )
                )
            )
            / np.power(n, 3)
            + (
                11340.0
                * (
                    -1.0
                    - 1.0 * (2.0 + n) * (1 / (1.0 + n) + S1)
                    - 1.0
                    * np.power(2.0 + n, 2)
                    * (
                        np.power(1.0 + n, -2)
                        + S1 / (1.0 + n)
                        + 0.5 * (np.power(S1, 2) + S2)
                    )
                    - 1.0
                    * np.power(2.0 + n, 3)
                    * (
                        np.power(1.0 + n, -3)
                        + S1 / np.power(1.0 + n, 2)
                        + (0.5 * np.power(S1, 2)) / (1.0 + n)
                        + (0.5 * S2) / (1.0 + n)
                        + 0.16666666666666666
                        * (np.power(S1, 3) + 3.0 * S1 * S2 + 2.0 * S3)
                    )
                )
            )
            / np.power(2.0 + n, 4)
            + (
                35640.0
                * (
                    1.0
                    + (1.0 + n) * S1
                    + np.power(1.0 + n, 2)
                    * (
                        np.power(1.0 + n, -2)
                        + S1 / (1.0 + n)
                        - (1.0 * (1 / (1.0 + n) + S1)) / (1.0 + n)
                        + 0.5 * (np.power(S1, 2) + S2)
                    )
                    + np.power(1.0 + n, 3)
                    * (
                        np.power(1.0 + n, -3)
                        + S1 / np.power(1.0 + n, 2)
                        + (0.5 * np.power(S1, 2)) / (1.0 + n)
                        - (0.5 * np.power(1 / (1.0 + n) + S1, 2)) / (1.0 + n)
                        + (0.5 * S2) / (1.0 + n)
                        - (0.5 * (np.power(1.0 + n, -2) + S2)) / (1.0 + n)
                        + 0.16666666666666666
                        * (np.power(S1, 3) + 3.0 * S1 * S2 + 2.0 * S3)
                    )
                )
            )
            / np.power(1.0 + n, 4)
            + (
                2160.0
                * (
                    1.0
                    + (3.0 + n) * (1 / (1.0 + n) + 1 / (2.0 + n) + S1)
                    + np.power(3.0 + n, 2)
                    * (
                        np.power(1.0 + n, -2)
                        + np.power(2.0 + n, -2)
                        + S1 / (1.0 + n)
                        + (1 / (1.0 + n) + S1) / (2.0 + n)
                        + 0.5 * (np.power(S1, 2) + S2)
                    )
                    + np.power(3.0 + n, 3)
                    * (
                        np.power(1.0 + n, -3)
                        + np.power(2.0 + n, -3)
                        + S1 / np.power(1.0 + n, 2)
                        + (0.5 * np.power(S1, 2)) / (1.0 + n)
                        + (1 / (1.0 + n) + S1) / np.power(2.0 + n, 2)
                        + (0.5 * np.power(1 / (1.0 + n) + S1, 2)) / (2.0 + n)
                        + (0.5 * S2) / (1.0 + n)
                        + (0.5 * (np.power(1.0 + n, -2) + S2)) / (2.0 + n)
                        + 0.16666666666666666
                        * (np.power(S1, 3) + 3.0 * S1 * S2 + 2.0 * S3)
                    )
                )
            )
            / np.power(3.0 + n, 4)
            + (
                26460.0
                * (
                    -1.0
                    - 1.0
                    * n
                    * (1 / (1.0 + n) + (1.0 - 2.0 * (1.0 + n)) / (n * (1.0 + n)) + S1)
                    - 1.0
                    * np.power(n, 2)
                    * (
                        np.power(1.0 + n, -2)
                        + 1 / (n * (1.0 + n))
                        + S1 / (1.0 + n)
                        + ((1.0 - 2.0 * (1.0 + n)) * (1 / (1.0 + n) + S1))
                        / (n * (1.0 + n))
                        + 0.5 * (np.power(S1, 2) + S2)
                    )
                    - 1.0
                    * np.power(n, 3)
                    * (
                        np.power(1.0 + n, -3)
                        + S1 / np.power(1.0 + n, 2)
                        + (0.5 * np.power(S1, 2)) / (1.0 + n)
                        + (1 / (1.0 + n) + S1) / (n * (1.0 + n))
                        + (
                            0.5
                            * (1.0 - 2.0 * (1.0 + n))
                            * np.power(1 / (1.0 + n) + S1, 2)
                        )
                        / (n * (1.0 + n))
                        + (0.5 * S2) / (1.0 + n)
                        + (0.5 * (1.0 - 2.0 * (1.0 + n)) * (np.power(1.0 + n, -2) + S2))
                        / (n * (1.0 + n))
                        + 0.16666666666666666
                        * (np.power(S1, 3) + 3.0 * S1 * S2 + 2.0 * S3)
                    )
                )
            )
            / np.power(n, 4)
        )
    )
