# tfm
Simple file manager implemented in Qt for Python (Qt6). This project aims to create a simple, desktop agnostic linux file-manager.
The project is in an alpha stage right now and thus it is not advised to use it at the moment.
If you still want to try it, see below.

## Features
* basic directory traversal
* window layout with toolbar, statusbar, main table view, fs tree, bookmarks and mounts
* open files using xdg-open
* cut, copy, paste (with progress information), rename
* named bookmarks to directories
* show/hide dotfiles
* throw files and directories in the trash
* drag and drop (always moves)
* cli to open with a path or file url supplied
* show, mount and unmount devices and iso files using udisks2
* auto extract zip and tar files

## How to install
There are python packages for the alpha version to download on pypi. Install at your own risk using:
```
pip install tfm
```
Then run using:
```
python3 -m tfm
```
Also install the external requirements `udisks2` and `util-linux`.

## Screenshots
Coming soon.

## Roadmap

### high priority
#### functionality
* give choices on handling existing files on paste
* implement network mounts, especially SMB shares (probably using smbnetfs)

### normal priority
#### functionality
* differentiate default dropAction by destination
* fuzzy search in folder
* restore from trash (should be implemented via a custom model/view)
* delete from trash (should be implemented via a custom model/view)
* open terminal in current directory
#### ui
* open with dialog
* make links visually distinguishable
* file property dialog
* bookmark order configurable in the UI
* drag and drop folders as bookmarks in the bookmark view
* bookmark current dir
* bookmark directory name as tool tip
#### infrastructure
* address all in code #TODOs

### low priority
#### functionality
* mount MTP devices
#### ui
* optional preview pane
* context sensitive views and columns
* user configurable views and columns
#### accessability
* localization

## Non-Features
These features are never going to be part of tfm:

* dependencies on specific desktop environments
* window management like tabs, split views or similar
* plugins or script support
* a lot of configuration options
