# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aiosignald']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'aiosignald',
    'version': '0.2',
    'description': 'Python bindings for signald',
    'long_description': 'Signald python bindings\n=======================\n\nMost of the content here is generated by the ``generate.py`` script\nthat uses `<https://signald.org/protocol.json>`_.\n\nInstall\n-------\n\n``pip install aiosignald``\n\nHave signald running. See `their docs <https://signald.org/articles/install/>`_ about it.\n\nUsage\n-----\n\nExample: registration\n*********************\n\n.. code:: py\n\n   import asyncio\n\n   from aiosignald import SignaldAPI\n\n   async def main():\n       loop = asyncio.get_running_loop()\n       _, signald = await loop.create_unix_connection(\n           SignaldAPI, path=SIGNALD_SOCKET_PATH)\n       await signald.register(username="+XXXXXX")\n       # Some async code to get the SMS code\n       await signald.verify(username="+XXXXXX", code=code)\n       await signald.on_con_lost\n\n   # See https://signald.org/articles/protocol/ for more info about this\n   SIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"\n\n   asyncio.run(main())\n\nDocs are available on `readthedocs <https://aiosignald.readthedocs.org>`_.\n',
    'author': 'Nicolas Cedilnik',
    'author_email': 'nicoco@nicoco.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/nicocool84/aiosignald',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
