/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsPollingSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStoreImpl;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsWatchSnapshotSource;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.spark_project.guava.cache.Cache;
import org.spark_project.guava.cache.CacheBuilder;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M3Q!\u0001\u0002\u0001\u00119\u0011\u0001dS;cKJtW\r^3t\u00072,8\u000f^3s\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0002lqMT!!\u0002\u0004\u0002\u000f\rdWo\u001d;fe*\u0011q\u0001C\u0001\ng\u000eDW\rZ;mKJT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=)\u0012\u0004\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-]i\u0011AB\u0005\u00031\u0019\u0011a#\u0012=uKJt\u0017\r\\\"mkN$XM]'b]\u0006<WM\u001d\t\u00035ui\u0011a\u0007\u0006\u00039!\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=m\u0011q\u0001T8hO&tw\rC\u0003!\u0001\u0011\u0005!%\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0019\u0003C\u0001\u0013\u0001\u001b\u0005\u0011\u0001\"\u0002\u0014\u0001\t\u0003:\u0013!C2b]\u000e\u0013X-\u0019;f)\tA3\u0006\u0005\u0002\u0011S%\u0011!&\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015aS\u00051\u0001.\u0003%i\u0017m\u001d;feV\u0013F\n\u0005\u0002/c9\u0011\u0001cL\u0005\u0003aE\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001'\u0005\u0005\u0006k\u0001!\tEN\u0001\u0014GJ,\u0017\r^3UCN\\7k\u00195fIVdWM\u001d\u000b\u0004oi\u0002\u0005C\u0001\f9\u0013\tIdAA\u0007UCN\\7k\u00195fIVdWM\u001d\u0005\u0006wQ\u0002\r\u0001P\u0001\u0003g\u000e\u0004\"!\u0010 \u000e\u0003!I!a\u0010\u0005\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000b1\"\u0004\u0019A\u0017\t\u000b\t\u0003A\u0011I\"\u0002-\r\u0014X-\u0019;f'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012$B\u0001R$I\u0013B\u0011a#R\u0005\u0003\r\u001a\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\t\u000bm\n\u0005\u0019\u0001\u001f\t\u000b1\n\u0005\u0019A\u0017\t\u000b\u001d\t\u0005\u0019A\u001c\t\u000b-\u0003A\u0011\t'\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002N!F\u0003\"\u0001\u0005(\n\u0005=\u000b\"\u0001B+oSRDQa\u0002&A\u0002]BQA\u0015&A\u0002\u0011\u000bqAY1dW\u0016tG\r")
public class KubernetesClusterManager
implements ExternalClusterManager,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public boolean canCreate(String masterURL) {
        return masterURL.startsWith("k8s");
    }

    public TaskScheduler createTaskScheduler(SparkContext sc, String masterURL) {
        return new TaskSchedulerImpl(sc);
    }

    public SchedulerBackend createSchedulerBackend(SparkContext sc, String masterURL, TaskScheduler scheduler) {
        Tuple4 tuple4;
        Tuple4 tuple42;
        boolean wasSparkSubmittedInClusterMode = BoxesRunTime.unboxToBoolean((Object)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_SUBMIT_CHECK()));
        if (wasSparkSubmittedInClusterMode) {
            Predef$.MODULE$.require(((Option)sc.conf().get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME())).isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "If the application is deployed using spark-submit in cluster mode, the driver pod name must be provided.";
                }
            });
            tuple42 = new Tuple4((Object)Config$.MODULE$.KUBERNETES_AUTH_DRIVER_MOUNTED_CONF_PREFIX(), (Object)Constants$.MODULE$.KUBERNETES_MASTER_INTERNAL_URL(), (Object)new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/token")), (Object)new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt")));
        } else {
            tuple42 = tuple4 = new Tuple4((Object)Config$.MODULE$.KUBERNETES_AUTH_CLIENT_MODE_PREFIX(), (Object)KubernetesUtils$.MODULE$.parseMasterUrl(masterURL), (Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple4 != null) {
            Tuple4 tuple43;
            String authConfPrefix = (String)tuple4._1();
            String apiServerUri = (String)tuple4._2();
            Option defaultServiceAccountToken = (Option)tuple4._3();
            Option defaultServiceAccountCaCrt = (Option)tuple4._4();
            Tuple4 tuple44 = tuple43 = new Tuple4((Object)authConfPrefix, (Object)apiServerUri, (Object)defaultServiceAccountToken, (Object)defaultServiceAccountCaCrt);
            String authConfPrefix2 = (String)tuple44._1();
            String apiServerUri2 = (String)tuple44._2();
            Option defaultServiceAccountToken2 = (Option)tuple44._3();
            Option defaultServiceAccountCaCrt2 = (Option)tuple44._4();
            KubernetesClient kubernetesClient = SparkKubernetesClientFactory$.MODULE$.createKubernetesClient(apiServerUri2, (Option<String>)new Some(sc.conf().get(Config$.MODULE$.KUBERNETES_NAMESPACE())), authConfPrefix2, sc.conf(), (Option<File>)defaultServiceAccountToken2, (Option<File>)defaultServiceAccountCaCrt2);
            ThreadPoolExecutor requestExecutorsService = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("kubernetes-executor-requests");
            ScheduledExecutorService subscribersExecutor = ThreadUtils$.MODULE$.newDaemonThreadPoolScheduledExecutor("kubernetes-executor-snapshots-subscribers", 2);
            ExecutorPodsSnapshotsStoreImpl snapshotsStore = new ExecutorPodsSnapshotsStoreImpl(subscribersExecutor);
            Cache removedExecutorsCache = CacheBuilder.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).build();
            ExecutorPodsLifecycleManager executorPodsLifecycleEventHandler = new ExecutorPodsLifecycleManager(sc.conf(), new KubernetesExecutorBuilder(KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$1(), KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$2(), KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$3(), KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$4(), KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$5()), kubernetesClient, snapshotsStore, (Cache<Long, Long>)removedExecutorsCache);
            ExecutorPodsAllocator executorPodsAllocator = new ExecutorPodsAllocator(sc.conf(), new KubernetesExecutorBuilder(KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$1(), KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$2(), KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$3(), KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$4(), KubernetesExecutorBuilder$.MODULE$.$lessinit$greater$default$5()), kubernetesClient, snapshotsStore, (Clock)new SystemClock());
            ExecutorPodsWatchSnapshotSource podsWatchEventSource = new ExecutorPodsWatchSnapshotSource(snapshotsStore, kubernetesClient);
            ScheduledExecutorService eventsPollingExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("kubernetes-executor-pod-polling-sync");
            ExecutorPodsPollingSnapshotSource podsPollingEventSource = new ExecutorPodsPollingSnapshotSource(sc.conf(), kubernetesClient, snapshotsStore, eventsPollingExecutor);
            return new KubernetesClusterSchedulerBackend((TaskSchedulerImpl)scheduler, sc.env().rpcEnv(), kubernetesClient, requestExecutorsService, snapshotsStore, executorPodsAllocator, executorPodsLifecycleEventHandler, podsWatchEventSource, podsPollingEventSource);
        }
        throw new MatchError((Object)tuple4);
    }

    public void initialize(TaskScheduler scheduler, SchedulerBackend backend) {
        ((TaskSchedulerImpl)scheduler).initialize(backend);
    }

    public KubernetesClusterManager() {
        Logging.class.$init$((Logging)this);
    }
}

