/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public class SqlIntervalLiteral
extends SqlLiteral {
    protected SqlIntervalLiteral(int sign, String intervalStr, SqlIntervalQualifier intervalQualifier, SqlTypeName sqlTypeName, SqlParserPos pos) {
        this(new IntervalValue(intervalQualifier, sign, intervalStr), sqlTypeName, pos);
    }

    private SqlIntervalLiteral(IntervalValue intervalValue, SqlTypeName sqlTypeName, SqlParserPos pos) {
        super(intervalValue, sqlTypeName, pos);
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlIntervalLiteral((IntervalValue)this.value, this.getTypeName(), pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        IntervalValue interval = (IntervalValue)this.value;
        writer.keyword("INTERVAL");
        if (interval.getSign() == -1) {
            writer.print("-");
        }
        writer.literal("'" + this.value.toString() + "'");
        writer.keyword(interval.intervalQualifier.toString());
    }

    @Override
    public int signum() {
        return ((IntervalValue)this.value).signum();
    }

    public static class IntervalValue {
        private final SqlIntervalQualifier intervalQualifier;
        private final String intervalStr;
        private final int sign;

        IntervalValue(SqlIntervalQualifier intervalQualifier, int sign, String intervalStr) {
            assert (sign == -1 || sign == 1);
            assert (intervalQualifier != null);
            assert (intervalStr != null);
            this.intervalQualifier = intervalQualifier;
            this.sign = sign;
            this.intervalStr = intervalStr;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IntervalValue)) {
                return false;
            }
            IntervalValue that = (IntervalValue)obj;
            return this.intervalStr.equals(that.intervalStr) && this.sign == that.sign && this.intervalQualifier.equalsDeep(that.intervalQualifier, false);
        }

        public int hashCode() {
            int h = Util.hash(this.sign, this.intervalStr);
            int i = Util.hash(h, this.intervalQualifier);
            return i;
        }

        public SqlIntervalQualifier getIntervalQualifier() {
            return this.intervalQualifier;
        }

        public String getIntervalLiteral() {
            return this.intervalStr;
        }

        public int getSign() {
            return this.sign;
        }

        public int signum() {
            for (int i = 0; i < this.intervalStr.length(); ++i) {
                char ch = this.intervalStr.charAt(i);
                if (ch < '1' || ch > '9') continue;
                return this.getSign();
            }
            return 0;
        }

        public String toString() {
            return this.intervalStr;
        }
    }
}

