/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.EqualityComparer;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.linq4j.function.Predicate2;
import org.apache.calcite.util.Bug;

public class Enumerables {
    private static final Function1<?, ?> SLICE = new Function1<Object[], Object>(){

        public Object apply(Object[] a0) {
            return a0[0];
        }
    };
    private static final Function1<Object[], Row> ARRAY_TO_ROW = new Function1<Object[], Row>(){

        public Row apply(Object[] a0) {
            return Row.asCopy(a0);
        }
    };

    private Enumerables() {
    }

    public static <E> Enumerable<E> slice0(Enumerable<E[]> enumerable) {
        return enumerable.select(SLICE);
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> semiJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector) {
        Bug.upgrade("move into linq4j");
        return Enumerables.semiJoin(outer, inner, outerKeySelector, innerKeySelector, null);
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> semiJoin(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final EqualityComparer<TKey> comparer) {
        return new AbstractEnumerable<TSource>(){

            public Enumerator<TSource> enumerator() {
                final Enumerable innerLookup = comparer == null ? inner.select(innerKeySelector).distinct() : inner.select(innerKeySelector).distinct(comparer);
                return Enumerables.where(outer.enumerator(), new Predicate1<TSource>(){

                    public boolean apply(TSource v0) {
                        Object key = outerKeySelector.apply(v0);
                        return innerLookup.contains(key);
                    }
                });
            }
        };
    }

    public static <TSource, TInner, TResult> Enumerable<TResult> thetaJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Predicate2<TSource, TInner> predicate, Function2<TSource, TInner, TResult> resultSelector, boolean generateNullsOnLeft, boolean generateNullsOnRight) {
        Set rightUnmatched;
        ArrayList result = Lists.newArrayList();
        Enumerator lefts = outer.enumerator();
        List rightList = inner.toList();
        if (generateNullsOnLeft) {
            rightUnmatched = Sets.newIdentityHashSet();
            rightUnmatched.addAll(rightList);
        } else {
            rightUnmatched = null;
        }
        while (lefts.moveNext()) {
            int leftMatchCount = 0;
            Object left = lefts.current();
            Enumerator rights = Linq4j.iterableEnumerator((Iterable)rightList);
            while (rights.moveNext()) {
                Object right = rights.current();
                if (!predicate.apply(left, right)) continue;
                ++leftMatchCount;
                if (rightUnmatched != null) {
                    rightUnmatched.remove(right);
                }
                result.add(resultSelector.apply(left, right));
            }
            if (!generateNullsOnRight || leftMatchCount != 0) continue;
            result.add(resultSelector.apply(left, null));
        }
        if (rightUnmatched != null) {
            Enumerator rights = Linq4j.iterableEnumerator((Iterable)rightUnmatched);
            while (rights.moveNext()) {
                Object right = rights.current();
                result.add(resultSelector.apply(null, right));
            }
        }
        return Linq4j.asEnumerable((List)result);
    }

    public static <TSource> Enumerable<TSource> where(final Enumerable<TSource> source, final Predicate1<TSource> predicate) {
        assert (predicate != null);
        return new AbstractEnumerable<TSource>(){

            public Enumerator<TSource> enumerator() {
                Enumerator enumerator = source.enumerator();
                return Enumerables.where(enumerator, predicate);
            }
        };
    }

    private static <TSource> Enumerator<TSource> where(final Enumerator<TSource> enumerator, final Predicate1<TSource> predicate) {
        return new Enumerator<TSource>(){

            public TSource current() {
                return enumerator.current();
            }

            public boolean moveNext() {
                while (enumerator.moveNext()) {
                    if (!predicate.apply(enumerator.current())) continue;
                    return true;
                }
                return false;
            }

            public void reset() {
                enumerator.reset();
            }

            public void close() {
                enumerator.close();
            }
        };
    }

    public static Enumerable<Row> toRow(Enumerable<Object[]> enumerator) {
        return enumerator.select(ARRAY_TO_ROW);
    }

    public static <TSource, TInner, TKey extends Comparable<TKey>, TResult> Enumerable<TResult> mergeJoin(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final Function2<TSource, TInner, TResult> resultSelector, boolean generateNullsOnLeft, boolean generateNullsOnRight) {
        assert (!generateNullsOnLeft) : "not implemented";
        assert (!generateNullsOnRight) : "not implemented";
        return new AbstractEnumerable<TResult>(){

            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    final Enumerator<TSource> leftEnumerator;
                    final Enumerator<TInner> rightEnumerator;
                    final List<TSource> lefts;
                    final List<TInner> rights;
                    boolean done;
                    Enumerator<List<Object>> cartesians;
                    {
                        this.leftEnumerator = outer.enumerator();
                        this.rightEnumerator = inner.enumerator();
                        this.lefts = Lists.newArrayList();
                        this.rights = Lists.newArrayList();
                        this.start();
                    }

                    private void start() {
                        if (!(this.leftEnumerator.moveNext() && this.rightEnumerator.moveNext() && this.advance())) {
                            this.done = true;
                            this.cartesians = Linq4j.emptyEnumerator();
                        }
                    }

                    private boolean advance() {
                        int c;
                        int c2;
                        Object left = this.leftEnumerator.current();
                        Comparable leftKey = (Comparable)outerKeySelector.apply(left);
                        Object right = this.rightEnumerator.current();
                        Comparable rightKey = (Comparable)innerKeySelector.apply(right);
                        while ((c2 = leftKey.compareTo(rightKey)) != 0) {
                            if (c2 < 0) {
                                if (!this.leftEnumerator.moveNext()) {
                                    this.done = true;
                                    return false;
                                }
                                left = this.leftEnumerator.current();
                                leftKey = (Comparable)outerKeySelector.apply(left);
                                continue;
                            }
                            if (!this.rightEnumerator.moveNext()) {
                                this.done = true;
                                return false;
                            }
                            right = this.rightEnumerator.current();
                            rightKey = (Comparable)innerKeySelector.apply(right);
                        }
                        this.lefts.clear();
                        this.lefts.add(left);
                        while (true) {
                            if (!this.leftEnumerator.moveNext()) {
                                this.done = true;
                                break;
                            }
                            left = this.leftEnumerator.current();
                            Comparable leftKey2 = (Comparable)outerKeySelector.apply(left);
                            c = leftKey.compareTo(leftKey2);
                            if (c != 0) {
                                assert (c < 0) : "not sorted";
                                break;
                            }
                            this.lefts.add(left);
                        }
                        this.rights.clear();
                        this.rights.add(right);
                        while (true) {
                            if (!this.rightEnumerator.moveNext()) {
                                this.done = true;
                                break;
                            }
                            right = this.rightEnumerator.current();
                            Comparable rightKey2 = (Comparable)innerKeySelector.apply(right);
                            c = rightKey.compareTo(rightKey2);
                            if (c != 0) {
                                assert (c < 0) : "not sorted";
                                break;
                            }
                            this.rights.add(right);
                        }
                        this.cartesians = Linq4j.product((List)ImmutableList.of((Object)Linq4j.enumerator(this.lefts), (Object)Linq4j.enumerator(this.rights)));
                        return true;
                    }

                    public TResult current() {
                        List list = (List)this.cartesians.current();
                        Object left = list.get(0);
                        Object right = list.get(1);
                        return resultSelector.apply(left, right);
                    }

                    public boolean moveNext() {
                        do {
                            if (this.cartesians.moveNext()) {
                                return true;
                            }
                            if (!this.done) continue;
                            return false;
                        } while (this.advance());
                        return false;
                    }

                    public void reset() {
                        this.done = false;
                        this.leftEnumerator.reset();
                        this.rightEnumerator.reset();
                        this.start();
                    }

                    public void close() {
                    }
                };
            }
        };
    }
}

