# noqa: W605

import sys
from datetime import datetime
from typing import List, Optional

if sys.version_info >= (3, 8):
    from typing import TypedDict
else:
    from typing_extensions import TypedDict

from localstack.aws.api import RequestContext, ServiceRequest, handler

AddressMaxResults = int
AllocationId = str
AutoRecoveryFlag = bool
BareMetalFlag = bool
BaselineBandwidthInMbps = int
BaselineIops = int
BaselineThroughputInMBps = float
Boolean = bool
BoxedDouble = float
BundleId = str
BurstablePerformanceFlag = bool
CancelCapacityReservationFleetErrorCode = str
CancelCapacityReservationFleetErrorMessage = str
CapacityReservationFleetId = str
CapacityReservationId = str
CarrierGatewayId = str
CarrierGatewayMaxResults = int
ClientVpnAssociationId = str
ClientVpnEndpointId = str
CoipPoolId = str
CoipPoolMaxResults = int
ConnectionNotificationId = str
ConversionTaskId = str
CoreCount = int
CoreNetworkArn = str
CurrentGenerationFlag = bool
CustomerGatewayId = str
DITMaxResults = int
DITOMaxResults = int
DedicatedHostFlag = bool
DedicatedHostId = str
DefaultNetworkCardIndex = int
DefaultingDhcpOptionsId = str
DescribeByoipCidrsMaxResults = int
DescribeCapacityReservationFleetsMaxResults = int
DescribeCapacityReservationsMaxResults = int
DescribeClassicLinkInstancesMaxResults = int
DescribeClientVpnAuthorizationRulesMaxResults = int
DescribeClientVpnConnectionsMaxResults = int
DescribeClientVpnEndpointMaxResults = int
DescribeClientVpnRoutesMaxResults = int
DescribeClientVpnTargetNetworksMaxResults = int
DescribeDhcpOptionsMaxResults = int
DescribeEgressOnlyInternetGatewaysMaxResults = int
DescribeElasticGpusMaxResults = int
DescribeExportImageTasksMaxResults = int
DescribeFastLaunchImagesRequestMaxResults = int
DescribeFastSnapshotRestoresMaxResults = int
DescribeFpgaImagesMaxResults = int
DescribeHostReservationsMaxResults = int
DescribeIamInstanceProfileAssociationsMaxResults = int
DescribeInstanceCreditSpecificationsMaxResults = int
DescribeInternetGatewaysMaxResults = int
DescribeLaunchTemplatesMaxResults = int
DescribeMovingAddressesMaxResults = int
DescribeNatGatewaysMaxResults = int
DescribeNetworkAclsMaxResults = int
DescribeNetworkInterfacePermissionsMaxResults = int
DescribeNetworkInterfacesMaxResults = int
DescribePrincipalIdFormatMaxResults = int
DescribeReplaceRootVolumeTasksMaxResults = int
DescribeRouteTablesMaxResults = int
DescribeScheduledInstanceAvailabilityMaxResults = int
DescribeSecurityGroupRulesMaxResults = int
DescribeSecurityGroupsMaxResults = int
DescribeSnapshotTierStatusMaxResults = int
DescribeSpotFleetInstancesMaxResults = int
DescribeSpotFleetRequestHistoryMaxResults = int
DescribeStaleSecurityGroupsMaxResults = int
DescribeStaleSecurityGroupsNextToken = str
DescribeStoreImageTasksRequestMaxResults = int
DescribeSubnetsMaxResults = int
DescribeTrunkInterfaceAssociationsMaxResults = int
DescribeVpcClassicLinkDnsSupportMaxResults = int
DescribeVpcClassicLinkDnsSupportNextToken = str
DescribeVpcPeeringConnectionsMaxResults = int
DescribeVpcsMaxResults = int
DhcpOptionsId = str
DiskCount = int
Double = float
DoubleWithConstraints = float
EfaSupportedFlag = bool
EgressOnlyInternetGatewayId = str
ElasticGpuId = str
ElasticInferenceAcceleratorCount = int
ElasticIpAssociationId = str
EncryptionInTransitSupported = bool
ExcludedInstanceType = str
ExportImageTaskId = str
ExportTaskId = str
ExportVmTaskId = str
FleetId = str
Float = float
FlowLogResourceId = str
FpgaDeviceCount = int
FpgaDeviceManufacturerName = str
FpgaDeviceMemorySize = int
FpgaDeviceName = str
FpgaImageId = str
FreeTierEligibleFlag = bool
GVCDMaxResults = int
GetCapacityReservationUsageRequestMaxResults = int
GetGroupsForCapacityReservationRequestMaxResults = int
GetIpamPoolAllocationsMaxResults = int
GetManagedPrefixListAssociationsMaxResults = int
GetSubnetCidrReservationsMaxResults = int
GpuDeviceCount = int
GpuDeviceManufacturerName = str
GpuDeviceMemorySize = int
GpuDeviceName = str
HibernationFlag = bool
HostReservationId = str
Hour = int
IamInstanceProfileAssociationId = str
ImageId = str
ImportImageTaskId = str
ImportSnapshotTaskId = str
ImportTaskId = str
InferenceDeviceCount = int
InferenceDeviceManufacturerName = str
InferenceDeviceName = str
InstanceEventId = str
InstanceEventWindowCronExpression = str
InstanceEventWindowId = str
InstanceId = str
InstanceStorageFlag = bool
Integer = int
IntegerWithConstraints = int
InternetGatewayId = str
IpAddress = str
IpamAddressHistoryMaxResults = int
IpamId = str
IpamMaxResults = int
IpamNetmaskLength = int
IpamPoolAllocationId = str
IpamPoolId = str
IpamScopeId = str
Ipv4PoolEc2Id = str
Ipv6Address = str
Ipv6Flag = bool
Ipv6PoolEc2Id = str
Ipv6PoolMaxResults = int
KernelId = str
KeyPairId = str
KeyPairName = str
KmsKeyId = str
LaunchTemplateElasticInferenceAcceleratorCount = int
LaunchTemplateId = str
LaunchTemplateName = str
ListSnapshotsInRecycleBinMaxResults = int
LocalGatewayId = str
LocalGatewayMaxResults = int
LocalGatewayRouteTableVirtualInterfaceGroupAssociationId = str
LocalGatewayRouteTableVpcAssociationId = str
LocalGatewayRoutetableId = str
LocalGatewayVirtualInterfaceGroupId = str
LocalGatewayVirtualInterfaceId = str
Location = str
MaxIpv4AddrPerInterface = int
MaxIpv6AddrPerInterface = int
MaxNetworkInterfaces = int
MaxResults = int
MaximumBandwidthInMbps = int
MaximumEfaInterfaces = int
MaximumIops = int
MaximumNetworkCards = int
MaximumThroughputInMBps = float
NatGatewayId = str
NetmaskLength = int
NetworkAclAssociationId = str
NetworkAclId = str
NetworkCardIndex = int
NetworkInsightsAccessScopeAnalysisId = str
NetworkInsightsAccessScopeId = str
NetworkInsightsAnalysisId = str
NetworkInsightsMaxResults = int
NetworkInsightsPathId = str
NetworkInsightsResourceId = str
NetworkInterfaceAttachmentId = str
NetworkInterfaceId = str
NetworkInterfacePermissionId = str
NetworkPerformance = str
NextToken = str
OfferingId = str
OutpostArn = str
PlacementGroupArn = str
PlacementGroupId = str
PlacementGroupName = str
PoolMaxResults = int
Port = int
PrefixListMaxResults = int
PrefixListResourceId = str
ProcessorSustainedClockSpeed = float
PublicIpAddress = str
RamdiskId = str
ReplaceRootVolumeTaskId = str
ReservationId = str
ReservedInstancesListingId = str
ReservedInstancesModificationId = str
ReservedInstancesOfferingId = str
ResourceArn = str
RestoreSnapshotTierRequestTemporaryRestoreDays = int
ResultRange = int
RouteGatewayId = str
RouteTableAssociationId = str
RouteTableId = str
ScheduledInstanceId = str
SecurityGroupId = str
SecurityGroupName = str
SecurityGroupRuleId = str
SensitiveUserData = str
SnapshotId = str
SpotFleetRequestId = str
SpotInstanceRequestId = str
SpotPlacementScoresMaxResults = int
SpotPlacementScoresTargetCapacity = int
String = str
SubnetCidrAssociationId = str
SubnetCidrReservationId = str
SubnetId = str
TaggableResourceId = str
ThreadsPerCore = int
TrafficMirrorFilterId = str
TrafficMirrorFilterRuleId = str
TrafficMirrorSessionId = str
TrafficMirrorTargetId = str
TrafficMirroringMaxResults = int
TransitAssociationGatewayId = str
TransitGatewayAttachmentId = str
TransitGatewayConnectPeerId = str
TransitGatewayId = str
TransitGatewayMaxResults = int
TransitGatewayMulticastDomainId = str
TransitGatewayRouteTableId = str
TrunkInterfaceAssociationId = str
VCpuCount = int
VersionDescription = str
VolumeId = str
VpcCidrAssociationId = str
VpcEndpointId = str
VpcEndpointServiceId = str
VpcFlowLogId = str
VpcId = str
VpcPeeringConnectionId = str
VpnConnectionDeviceSampleConfiguration = str
VpnConnectionDeviceTypeId = str
VpnConnectionId = str
VpnGatewayId = str
totalFpgaMemory = int
totalGpuMemory = int


class AcceleratorManufacturer(str):
    nvidia = "nvidia"
    amd = "amd"
    amazon_web_services = "amazon-web-services"
    xilinx = "xilinx"


class AcceleratorName(str):
    a100 = "a100"
    v100 = "v100"
    k80 = "k80"
    t4 = "t4"
    m60 = "m60"
    radeon_pro_v520 = "radeon-pro-v520"
    vu9p = "vu9p"


class AcceleratorType(str):
    gpu = "gpu"
    fpga = "fpga"
    inference = "inference"


class AccountAttributeName(str):
    supported_platforms = "supported-platforms"
    default_vpc = "default-vpc"


class ActivityStatus(str):
    error = "error"
    pending_fulfillment = "pending_fulfillment"
    pending_termination = "pending_termination"
    fulfilled = "fulfilled"


class AddressAttributeName(str):
    domain_name = "domain-name"


class AddressFamily(str):
    ipv4 = "ipv4"
    ipv6 = "ipv6"


class Affinity(str):
    default = "default"
    host = "host"


class AllocationState(str):
    available = "available"
    under_assessment = "under-assessment"
    permanent_failure = "permanent-failure"
    released = "released"
    released_permanent_failure = "released-permanent-failure"
    pending = "pending"


class AllocationStrategy(str):
    lowestPrice = "lowestPrice"
    diversified = "diversified"
    capacityOptimized = "capacityOptimized"
    capacityOptimizedPrioritized = "capacityOptimizedPrioritized"


class AllowsMultipleInstanceTypes(str):
    on = "on"
    off = "off"


class AnalysisStatus(str):
    running = "running"
    succeeded = "succeeded"
    failed = "failed"


class ApplianceModeSupportValue(str):
    enable = "enable"
    disable = "disable"


class ArchitectureType(str):
    i386 = "i386"
    x86_64 = "x86_64"
    arm64 = "arm64"
    x86_64_mac = "x86_64_mac"


class ArchitectureValues(str):
    i386 = "i386"
    x86_64 = "x86_64"
    arm64 = "arm64"
    x86_64_mac = "x86_64_mac"


class AssociatedNetworkType(str):
    vpc = "vpc"


class AssociationStatusCode(str):
    associating = "associating"
    associated = "associated"
    association_failed = "association-failed"
    disassociating = "disassociating"
    disassociated = "disassociated"


class AttachmentStatus(str):
    attaching = "attaching"
    attached = "attached"
    detaching = "detaching"
    detached = "detached"


class AutoAcceptSharedAssociationsValue(str):
    enable = "enable"
    disable = "disable"


class AutoAcceptSharedAttachmentsValue(str):
    enable = "enable"
    disable = "disable"


class AutoPlacement(str):
    on = "on"
    off = "off"


class AvailabilityZoneOptInStatus(str):
    opt_in_not_required = "opt-in-not-required"
    opted_in = "opted-in"
    not_opted_in = "not-opted-in"


class AvailabilityZoneState(str):
    available = "available"
    information = "information"
    impaired = "impaired"
    unavailable = "unavailable"


class BareMetal(str):
    included = "included"
    required = "required"
    excluded = "excluded"


class BatchState(str):
    submitted = "submitted"
    active = "active"
    cancelled = "cancelled"
    failed = "failed"
    cancelled_running = "cancelled_running"
    cancelled_terminating = "cancelled_terminating"
    modifying = "modifying"


class BgpStatus(str):
    up = "up"
    down = "down"


class BootModeType(str):
    legacy_bios = "legacy-bios"
    uefi = "uefi"


class BootModeValues(str):
    legacy_bios = "legacy-bios"
    uefi = "uefi"


class BundleTaskState(str):
    pending = "pending"
    waiting_for_shutdown = "waiting-for-shutdown"
    bundling = "bundling"
    storing = "storing"
    cancelling = "cancelling"
    complete = "complete"
    failed = "failed"


class BurstablePerformance(str):
    included = "included"
    required = "required"
    excluded = "excluded"


class ByoipCidrState(str):
    advertised = "advertised"
    deprovisioned = "deprovisioned"
    failed_deprovision = "failed-deprovision"
    failed_provision = "failed-provision"
    pending_deprovision = "pending-deprovision"
    pending_provision = "pending-provision"
    provisioned = "provisioned"
    provisioned_not_publicly_advertisable = "provisioned-not-publicly-advertisable"


class CancelBatchErrorCode(str):
    fleetRequestIdDoesNotExist = "fleetRequestIdDoesNotExist"
    fleetRequestIdMalformed = "fleetRequestIdMalformed"
    fleetRequestNotInCancellableState = "fleetRequestNotInCancellableState"
    unexpectedError = "unexpectedError"


class CancelSpotInstanceRequestState(str):
    active = "active"
    open = "open"
    closed = "closed"
    cancelled = "cancelled"
    completed = "completed"


class CapacityReservationFleetState(str):
    submitted = "submitted"
    modifying = "modifying"
    active = "active"
    partially_fulfilled = "partially_fulfilled"
    expiring = "expiring"
    expired = "expired"
    cancelling = "cancelling"
    cancelled = "cancelled"
    failed = "failed"


class CapacityReservationInstancePlatform(str):
    Linux_UNIX = "Linux/UNIX"
    Red_Hat_Enterprise_Linux = "Red Hat Enterprise Linux"
    SUSE_Linux = "SUSE Linux"
    Windows = "Windows"
    Windows_with_SQL_Server = "Windows with SQL Server"
    Windows_with_SQL_Server_Enterprise = "Windows with SQL Server Enterprise"
    Windows_with_SQL_Server_Standard = "Windows with SQL Server Standard"
    Windows_with_SQL_Server_Web = "Windows with SQL Server Web"
    Linux_with_SQL_Server_Standard = "Linux with SQL Server Standard"
    Linux_with_SQL_Server_Web = "Linux with SQL Server Web"
    Linux_with_SQL_Server_Enterprise = "Linux with SQL Server Enterprise"
    RHEL_with_SQL_Server_Standard = "RHEL with SQL Server Standard"
    RHEL_with_SQL_Server_Enterprise = "RHEL with SQL Server Enterprise"
    RHEL_with_SQL_Server_Web = "RHEL with SQL Server Web"
    RHEL_with_HA = "RHEL with HA"
    RHEL_with_HA_and_SQL_Server_Standard = "RHEL with HA and SQL Server Standard"
    RHEL_with_HA_and_SQL_Server_Enterprise = "RHEL with HA and SQL Server Enterprise"


class CapacityReservationPreference(str):
    open = "open"
    none = "none"


class CapacityReservationState(str):
    active = "active"
    expired = "expired"
    cancelled = "cancelled"
    pending = "pending"
    failed = "failed"


class CapacityReservationTenancy(str):
    default = "default"
    dedicated = "dedicated"


class CarrierGatewayState(str):
    pending = "pending"
    available = "available"
    deleting = "deleting"
    deleted = "deleted"


class ClientCertificateRevocationListStatusCode(str):
    pending = "pending"
    active = "active"


class ClientVpnAuthenticationType(str):
    certificate_authentication = "certificate-authentication"
    directory_service_authentication = "directory-service-authentication"
    federated_authentication = "federated-authentication"


class ClientVpnAuthorizationRuleStatusCode(str):
    authorizing = "authorizing"
    active = "active"
    failed = "failed"
    revoking = "revoking"


class ClientVpnConnectionStatusCode(str):
    active = "active"
    failed_to_terminate = "failed-to-terminate"
    terminating = "terminating"
    terminated = "terminated"


class ClientVpnEndpointAttributeStatusCode(str):
    applying = "applying"
    applied = "applied"


class ClientVpnEndpointStatusCode(str):
    pending_associate = "pending-associate"
    available = "available"
    deleting = "deleting"
    deleted = "deleted"


class ClientVpnRouteStatusCode(str):
    creating = "creating"
    active = "active"
    failed = "failed"
    deleting = "deleting"


class ConnectionNotificationState(str):
    Enabled = "Enabled"
    Disabled = "Disabled"


class ConnectionNotificationType(str):
    Topic = "Topic"


class ConnectivityType(str):
    private = "private"
    public = "public"


class ContainerFormat(str):
    ova = "ova"


class ConversionTaskState(str):
    active = "active"
    cancelling = "cancelling"
    cancelled = "cancelled"
    completed = "completed"


class CopyTagsFromSource(str):
    volume = "volume"


class CpuManufacturer(str):
    intel = "intel"
    amd = "amd"
    amazon_web_services = "amazon-web-services"


class CurrencyCodeValues(str):
    USD = "USD"


class DatafeedSubscriptionState(str):
    Active = "Active"
    Inactive = "Inactive"


class DefaultRouteTableAssociationValue(str):
    enable = "enable"
    disable = "disable"


class DefaultRouteTablePropagationValue(str):
    enable = "enable"
    disable = "disable"


class DefaultTargetCapacityType(str):
    spot = "spot"
    on_demand = "on-demand"


class DeleteFleetErrorCode(str):
    fleetIdDoesNotExist = "fleetIdDoesNotExist"
    fleetIdMalformed = "fleetIdMalformed"
    fleetNotInDeletableState = "fleetNotInDeletableState"
    unexpectedError = "unexpectedError"


class DeleteQueuedReservedInstancesErrorCode(str):
    reserved_instances_id_invalid = "reserved-instances-id-invalid"
    reserved_instances_not_in_queued_state = "reserved-instances-not-in-queued-state"
    unexpected_error = "unexpected-error"


class DestinationFileFormat(str):
    plain_text = "plain-text"
    parquet = "parquet"


class DeviceType(str):
    ebs = "ebs"
    instance_store = "instance-store"


class DiskImageFormat(str):
    VMDK = "VMDK"
    RAW = "RAW"
    VHD = "VHD"


class DiskType(str):
    hdd = "hdd"
    ssd = "ssd"


class DnsNameState(str):
    pendingVerification = "pendingVerification"
    verified = "verified"
    failed = "failed"


class DnsSupportValue(str):
    enable = "enable"
    disable = "disable"


class DomainType(str):
    vpc = "vpc"
    standard = "standard"


class EbsEncryptionSupport(str):
    unsupported = "unsupported"
    supported = "supported"


class EbsNvmeSupport(str):
    unsupported = "unsupported"
    supported = "supported"
    required = "required"


class EbsOptimizedSupport(str):
    unsupported = "unsupported"
    supported = "supported"
    default = "default"


class ElasticGpuState(str):
    ATTACHED = "ATTACHED"


class ElasticGpuStatus(str):
    OK = "OK"
    IMPAIRED = "IMPAIRED"


class EnaSupport(str):
    unsupported = "unsupported"
    supported = "supported"
    required = "required"


class EndDateType(str):
    unlimited = "unlimited"
    limited = "limited"


class EphemeralNvmeSupport(str):
    unsupported = "unsupported"
    supported = "supported"
    required = "required"


class EventCode(str):
    instance_reboot = "instance-reboot"
    system_reboot = "system-reboot"
    system_maintenance = "system-maintenance"
    instance_retirement = "instance-retirement"
    instance_stop = "instance-stop"


class EventType(str):
    instanceChange = "instanceChange"
    fleetRequestChange = "fleetRequestChange"
    error = "error"
    information = "information"


class ExcessCapacityTerminationPolicy(str):
    noTermination = "noTermination"
    default = "default"


class ExportEnvironment(str):
    citrix = "citrix"
    vmware = "vmware"
    microsoft = "microsoft"


class ExportTaskState(str):
    active = "active"
    cancelling = "cancelling"
    cancelled = "cancelled"
    completed = "completed"


class FastLaunchResourceType(str):
    snapshot = "snapshot"


class FastLaunchStateCode(str):
    enabling = "enabling"
    enabling_failed = "enabling-failed"
    enabled = "enabled"
    enabled_failed = "enabled-failed"
    disabling = "disabling"
    disabling_failed = "disabling-failed"


class FastSnapshotRestoreStateCode(str):
    enabling = "enabling"
    optimizing = "optimizing"
    enabled = "enabled"
    disabling = "disabling"
    disabled = "disabled"


class FindingsFound(str):
    true = "true"
    false = "false"
    unknown = "unknown"


class FleetActivityStatus(str):
    error = "error"
    pending_fulfillment = "pending_fulfillment"
    pending_termination = "pending_termination"
    fulfilled = "fulfilled"


class FleetCapacityReservationTenancy(str):
    default = "default"


class FleetCapacityReservationUsageStrategy(str):
    use_capacity_reservations_first = "use-capacity-reservations-first"


class FleetEventType(str):
    instance_change = "instance-change"
    fleet_change = "fleet-change"
    service_error = "service-error"


class FleetExcessCapacityTerminationPolicy(str):
    no_termination = "no-termination"
    termination = "termination"


class FleetInstanceMatchCriteria(str):
    open = "open"


class FleetOnDemandAllocationStrategy(str):
    lowest_price = "lowest-price"
    prioritized = "prioritized"


class FleetReplacementStrategy(str):
    launch = "launch"
    launch_before_terminate = "launch-before-terminate"


class FleetStateCode(str):
    submitted = "submitted"
    active = "active"
    deleted = "deleted"
    failed = "failed"
    deleted_running = "deleted_running"
    deleted_terminating = "deleted_terminating"
    modifying = "modifying"


class FleetType(str):
    request = "request"
    maintain = "maintain"
    instant = "instant"


class FlowLogsResourceType(str):
    VPC = "VPC"
    Subnet = "Subnet"
    NetworkInterface = "NetworkInterface"


class FpgaImageAttributeName(str):
    description = "description"
    name = "name"
    loadPermission = "loadPermission"
    productCodes = "productCodes"


class FpgaImageStateCode(str):
    pending = "pending"
    failed = "failed"
    available = "available"
    unavailable = "unavailable"


class GatewayAssociationState(str):
    associated = "associated"
    not_associated = "not-associated"
    associating = "associating"
    disassociating = "disassociating"


class GatewayType(str):
    ipsec_1 = "ipsec.1"


class HostRecovery(str):
    on = "on"
    off = "off"


class HostTenancy(str):
    dedicated = "dedicated"
    host = "host"


class HostnameType(str):
    ip_name = "ip-name"
    resource_name = "resource-name"


class HttpTokensState(str):
    optional = "optional"
    required = "required"


class HypervisorType(str):
    ovm = "ovm"
    xen = "xen"


class IamInstanceProfileAssociationState(str):
    associating = "associating"
    associated = "associated"
    disassociating = "disassociating"
    disassociated = "disassociated"


class Igmpv2SupportValue(str):
    enable = "enable"
    disable = "disable"


class ImageAttributeName(str):
    description = "description"
    kernel = "kernel"
    ramdisk = "ramdisk"
    launchPermission = "launchPermission"
    productCodes = "productCodes"
    blockDeviceMapping = "blockDeviceMapping"
    sriovNetSupport = "sriovNetSupport"
    bootMode = "bootMode"


class ImageState(str):
    pending = "pending"
    available = "available"
    invalid = "invalid"
    deregistered = "deregistered"
    transient = "transient"
    failed = "failed"
    error = "error"


class ImageTypeValues(str):
    machine = "machine"
    kernel = "kernel"
    ramdisk = "ramdisk"


class InstanceAttributeName(str):
    instanceType = "instanceType"
    kernel = "kernel"
    ramdisk = "ramdisk"
    userData = "userData"
    disableApiTermination = "disableApiTermination"
    instanceInitiatedShutdownBehavior = "instanceInitiatedShutdownBehavior"
    rootDeviceName = "rootDeviceName"
    blockDeviceMapping = "blockDeviceMapping"
    productCodes = "productCodes"
    sourceDestCheck = "sourceDestCheck"
    groupSet = "groupSet"
    ebsOptimized = "ebsOptimized"
    sriovNetSupport = "sriovNetSupport"
    enaSupport = "enaSupport"
    enclaveOptions = "enclaveOptions"


class InstanceEventWindowState(str):
    creating = "creating"
    deleting = "deleting"
    active = "active"
    deleted = "deleted"


class InstanceGeneration(str):
    current = "current"
    previous = "previous"


class InstanceHealthStatus(str):
    healthy = "healthy"
    unhealthy = "unhealthy"


class InstanceInterruptionBehavior(str):
    hibernate = "hibernate"
    stop = "stop"
    terminate = "terminate"


class InstanceLifecycle(str):
    spot = "spot"
    on_demand = "on-demand"


class InstanceLifecycleType(str):
    spot = "spot"
    scheduled = "scheduled"


class InstanceMatchCriteria(str):
    open = "open"
    targeted = "targeted"


class InstanceMetadataEndpointState(str):
    disabled = "disabled"
    enabled = "enabled"


class InstanceMetadataOptionsState(str):
    pending = "pending"
    applied = "applied"


class InstanceMetadataProtocolState(str):
    disabled = "disabled"
    enabled = "enabled"


class InstanceMetadataTagsState(str):
    disabled = "disabled"
    enabled = "enabled"


class InstanceStateName(str):
    pending = "pending"
    running = "running"
    shutting_down = "shutting-down"
    terminated = "terminated"
    stopping = "stopping"
    stopped = "stopped"


class InstanceStorageEncryptionSupport(str):
    unsupported = "unsupported"
    required = "required"


class InstanceType(str):
    a1_medium = "a1.medium"
    a1_large = "a1.large"
    a1_xlarge = "a1.xlarge"
    a1_2xlarge = "a1.2xlarge"
    a1_4xlarge = "a1.4xlarge"
    a1_metal = "a1.metal"
    c1_medium = "c1.medium"
    c1_xlarge = "c1.xlarge"
    c3_large = "c3.large"
    c3_xlarge = "c3.xlarge"
    c3_2xlarge = "c3.2xlarge"
    c3_4xlarge = "c3.4xlarge"
    c3_8xlarge = "c3.8xlarge"
    c4_large = "c4.large"
    c4_xlarge = "c4.xlarge"
    c4_2xlarge = "c4.2xlarge"
    c4_4xlarge = "c4.4xlarge"
    c4_8xlarge = "c4.8xlarge"
    c5_large = "c5.large"
    c5_xlarge = "c5.xlarge"
    c5_2xlarge = "c5.2xlarge"
    c5_4xlarge = "c5.4xlarge"
    c5_9xlarge = "c5.9xlarge"
    c5_12xlarge = "c5.12xlarge"
    c5_18xlarge = "c5.18xlarge"
    c5_24xlarge = "c5.24xlarge"
    c5_metal = "c5.metal"
    c5a_large = "c5a.large"
    c5a_xlarge = "c5a.xlarge"
    c5a_2xlarge = "c5a.2xlarge"
    c5a_4xlarge = "c5a.4xlarge"
    c5a_8xlarge = "c5a.8xlarge"
    c5a_12xlarge = "c5a.12xlarge"
    c5a_16xlarge = "c5a.16xlarge"
    c5a_24xlarge = "c5a.24xlarge"
    c5ad_large = "c5ad.large"
    c5ad_xlarge = "c5ad.xlarge"
    c5ad_2xlarge = "c5ad.2xlarge"
    c5ad_4xlarge = "c5ad.4xlarge"
    c5ad_8xlarge = "c5ad.8xlarge"
    c5ad_12xlarge = "c5ad.12xlarge"
    c5ad_16xlarge = "c5ad.16xlarge"
    c5ad_24xlarge = "c5ad.24xlarge"
    c5d_large = "c5d.large"
    c5d_xlarge = "c5d.xlarge"
    c5d_2xlarge = "c5d.2xlarge"
    c5d_4xlarge = "c5d.4xlarge"
    c5d_9xlarge = "c5d.9xlarge"
    c5d_12xlarge = "c5d.12xlarge"
    c5d_18xlarge = "c5d.18xlarge"
    c5d_24xlarge = "c5d.24xlarge"
    c5d_metal = "c5d.metal"
    c5n_large = "c5n.large"
    c5n_xlarge = "c5n.xlarge"
    c5n_2xlarge = "c5n.2xlarge"
    c5n_4xlarge = "c5n.4xlarge"
    c5n_9xlarge = "c5n.9xlarge"
    c5n_18xlarge = "c5n.18xlarge"
    c5n_metal = "c5n.metal"
    c6g_medium = "c6g.medium"
    c6g_large = "c6g.large"
    c6g_xlarge = "c6g.xlarge"
    c6g_2xlarge = "c6g.2xlarge"
    c6g_4xlarge = "c6g.4xlarge"
    c6g_8xlarge = "c6g.8xlarge"
    c6g_12xlarge = "c6g.12xlarge"
    c6g_16xlarge = "c6g.16xlarge"
    c6g_metal = "c6g.metal"
    c6gd_medium = "c6gd.medium"
    c6gd_large = "c6gd.large"
    c6gd_xlarge = "c6gd.xlarge"
    c6gd_2xlarge = "c6gd.2xlarge"
    c6gd_4xlarge = "c6gd.4xlarge"
    c6gd_8xlarge = "c6gd.8xlarge"
    c6gd_12xlarge = "c6gd.12xlarge"
    c6gd_16xlarge = "c6gd.16xlarge"
    c6gd_metal = "c6gd.metal"
    c6gn_medium = "c6gn.medium"
    c6gn_large = "c6gn.large"
    c6gn_xlarge = "c6gn.xlarge"
    c6gn_2xlarge = "c6gn.2xlarge"
    c6gn_4xlarge = "c6gn.4xlarge"
    c6gn_8xlarge = "c6gn.8xlarge"
    c6gn_12xlarge = "c6gn.12xlarge"
    c6gn_16xlarge = "c6gn.16xlarge"
    c6i_large = "c6i.large"
    c6i_xlarge = "c6i.xlarge"
    c6i_2xlarge = "c6i.2xlarge"
    c6i_4xlarge = "c6i.4xlarge"
    c6i_8xlarge = "c6i.8xlarge"
    c6i_12xlarge = "c6i.12xlarge"
    c6i_16xlarge = "c6i.16xlarge"
    c6i_24xlarge = "c6i.24xlarge"
    c6i_32xlarge = "c6i.32xlarge"
    c6i_metal = "c6i.metal"
    cc1_4xlarge = "cc1.4xlarge"
    cc2_8xlarge = "cc2.8xlarge"
    cg1_4xlarge = "cg1.4xlarge"
    cr1_8xlarge = "cr1.8xlarge"
    d2_xlarge = "d2.xlarge"
    d2_2xlarge = "d2.2xlarge"
    d2_4xlarge = "d2.4xlarge"
    d2_8xlarge = "d2.8xlarge"
    d3_xlarge = "d3.xlarge"
    d3_2xlarge = "d3.2xlarge"
    d3_4xlarge = "d3.4xlarge"
    d3_8xlarge = "d3.8xlarge"
    d3en_xlarge = "d3en.xlarge"
    d3en_2xlarge = "d3en.2xlarge"
    d3en_4xlarge = "d3en.4xlarge"
    d3en_6xlarge = "d3en.6xlarge"
    d3en_8xlarge = "d3en.8xlarge"
    d3en_12xlarge = "d3en.12xlarge"
    dl1_24xlarge = "dl1.24xlarge"
    f1_2xlarge = "f1.2xlarge"
    f1_4xlarge = "f1.4xlarge"
    f1_16xlarge = "f1.16xlarge"
    g2_2xlarge = "g2.2xlarge"
    g2_8xlarge = "g2.8xlarge"
    g3_4xlarge = "g3.4xlarge"
    g3_8xlarge = "g3.8xlarge"
    g3_16xlarge = "g3.16xlarge"
    g3s_xlarge = "g3s.xlarge"
    g4ad_xlarge = "g4ad.xlarge"
    g4ad_2xlarge = "g4ad.2xlarge"
    g4ad_4xlarge = "g4ad.4xlarge"
    g4ad_8xlarge = "g4ad.8xlarge"
    g4ad_16xlarge = "g4ad.16xlarge"
    g4dn_xlarge = "g4dn.xlarge"
    g4dn_2xlarge = "g4dn.2xlarge"
    g4dn_4xlarge = "g4dn.4xlarge"
    g4dn_8xlarge = "g4dn.8xlarge"
    g4dn_12xlarge = "g4dn.12xlarge"
    g4dn_16xlarge = "g4dn.16xlarge"
    g4dn_metal = "g4dn.metal"
    g5_xlarge = "g5.xlarge"
    g5_2xlarge = "g5.2xlarge"
    g5_4xlarge = "g5.4xlarge"
    g5_8xlarge = "g5.8xlarge"
    g5_12xlarge = "g5.12xlarge"
    g5_16xlarge = "g5.16xlarge"
    g5_24xlarge = "g5.24xlarge"
    g5_48xlarge = "g5.48xlarge"
    g5g_xlarge = "g5g.xlarge"
    g5g_2xlarge = "g5g.2xlarge"
    g5g_4xlarge = "g5g.4xlarge"
    g5g_8xlarge = "g5g.8xlarge"
    g5g_16xlarge = "g5g.16xlarge"
    g5g_metal = "g5g.metal"
    hi1_4xlarge = "hi1.4xlarge"
    hpc6a_48xlarge = "hpc6a.48xlarge"
    hs1_8xlarge = "hs1.8xlarge"
    h1_2xlarge = "h1.2xlarge"
    h1_4xlarge = "h1.4xlarge"
    h1_8xlarge = "h1.8xlarge"
    h1_16xlarge = "h1.16xlarge"
    i2_xlarge = "i2.xlarge"
    i2_2xlarge = "i2.2xlarge"
    i2_4xlarge = "i2.4xlarge"
    i2_8xlarge = "i2.8xlarge"
    i3_large = "i3.large"
    i3_xlarge = "i3.xlarge"
    i3_2xlarge = "i3.2xlarge"
    i3_4xlarge = "i3.4xlarge"
    i3_8xlarge = "i3.8xlarge"
    i3_16xlarge = "i3.16xlarge"
    i3_metal = "i3.metal"
    i3en_large = "i3en.large"
    i3en_xlarge = "i3en.xlarge"
    i3en_2xlarge = "i3en.2xlarge"
    i3en_3xlarge = "i3en.3xlarge"
    i3en_6xlarge = "i3en.6xlarge"
    i3en_12xlarge = "i3en.12xlarge"
    i3en_24xlarge = "i3en.24xlarge"
    i3en_metal = "i3en.metal"
    im4gn_large = "im4gn.large"
    im4gn_xlarge = "im4gn.xlarge"
    im4gn_2xlarge = "im4gn.2xlarge"
    im4gn_4xlarge = "im4gn.4xlarge"
    im4gn_8xlarge = "im4gn.8xlarge"
    im4gn_16xlarge = "im4gn.16xlarge"
    inf1_xlarge = "inf1.xlarge"
    inf1_2xlarge = "inf1.2xlarge"
    inf1_6xlarge = "inf1.6xlarge"
    inf1_24xlarge = "inf1.24xlarge"
    is4gen_medium = "is4gen.medium"
    is4gen_large = "is4gen.large"
    is4gen_xlarge = "is4gen.xlarge"
    is4gen_2xlarge = "is4gen.2xlarge"
    is4gen_4xlarge = "is4gen.4xlarge"
    is4gen_8xlarge = "is4gen.8xlarge"
    m1_small = "m1.small"
    m1_medium = "m1.medium"
    m1_large = "m1.large"
    m1_xlarge = "m1.xlarge"
    m2_xlarge = "m2.xlarge"
    m2_2xlarge = "m2.2xlarge"
    m2_4xlarge = "m2.4xlarge"
    m3_medium = "m3.medium"
    m3_large = "m3.large"
    m3_xlarge = "m3.xlarge"
    m3_2xlarge = "m3.2xlarge"
    m4_large = "m4.large"
    m4_xlarge = "m4.xlarge"
    m4_2xlarge = "m4.2xlarge"
    m4_4xlarge = "m4.4xlarge"
    m4_10xlarge = "m4.10xlarge"
    m4_16xlarge = "m4.16xlarge"
    m5_large = "m5.large"
    m5_xlarge = "m5.xlarge"
    m5_2xlarge = "m5.2xlarge"
    m5_4xlarge = "m5.4xlarge"
    m5_8xlarge = "m5.8xlarge"
    m5_12xlarge = "m5.12xlarge"
    m5_16xlarge = "m5.16xlarge"
    m5_24xlarge = "m5.24xlarge"
    m5_metal = "m5.metal"
    m5a_large = "m5a.large"
    m5a_xlarge = "m5a.xlarge"
    m5a_2xlarge = "m5a.2xlarge"
    m5a_4xlarge = "m5a.4xlarge"
    m5a_8xlarge = "m5a.8xlarge"
    m5a_12xlarge = "m5a.12xlarge"
    m5a_16xlarge = "m5a.16xlarge"
    m5a_24xlarge = "m5a.24xlarge"
    m5ad_large = "m5ad.large"
    m5ad_xlarge = "m5ad.xlarge"
    m5ad_2xlarge = "m5ad.2xlarge"
    m5ad_4xlarge = "m5ad.4xlarge"
    m5ad_8xlarge = "m5ad.8xlarge"
    m5ad_12xlarge = "m5ad.12xlarge"
    m5ad_16xlarge = "m5ad.16xlarge"
    m5ad_24xlarge = "m5ad.24xlarge"
    m5d_large = "m5d.large"
    m5d_xlarge = "m5d.xlarge"
    m5d_2xlarge = "m5d.2xlarge"
    m5d_4xlarge = "m5d.4xlarge"
    m5d_8xlarge = "m5d.8xlarge"
    m5d_12xlarge = "m5d.12xlarge"
    m5d_16xlarge = "m5d.16xlarge"
    m5d_24xlarge = "m5d.24xlarge"
    m5d_metal = "m5d.metal"
    m5dn_large = "m5dn.large"
    m5dn_xlarge = "m5dn.xlarge"
    m5dn_2xlarge = "m5dn.2xlarge"
    m5dn_4xlarge = "m5dn.4xlarge"
    m5dn_8xlarge = "m5dn.8xlarge"
    m5dn_12xlarge = "m5dn.12xlarge"
    m5dn_16xlarge = "m5dn.16xlarge"
    m5dn_24xlarge = "m5dn.24xlarge"
    m5dn_metal = "m5dn.metal"
    m5n_large = "m5n.large"
    m5n_xlarge = "m5n.xlarge"
    m5n_2xlarge = "m5n.2xlarge"
    m5n_4xlarge = "m5n.4xlarge"
    m5n_8xlarge = "m5n.8xlarge"
    m5n_12xlarge = "m5n.12xlarge"
    m5n_16xlarge = "m5n.16xlarge"
    m5n_24xlarge = "m5n.24xlarge"
    m5n_metal = "m5n.metal"
    m5zn_large = "m5zn.large"
    m5zn_xlarge = "m5zn.xlarge"
    m5zn_2xlarge = "m5zn.2xlarge"
    m5zn_3xlarge = "m5zn.3xlarge"
    m5zn_6xlarge = "m5zn.6xlarge"
    m5zn_12xlarge = "m5zn.12xlarge"
    m5zn_metal = "m5zn.metal"
    m6a_large = "m6a.large"
    m6a_xlarge = "m6a.xlarge"
    m6a_2xlarge = "m6a.2xlarge"
    m6a_4xlarge = "m6a.4xlarge"
    m6a_8xlarge = "m6a.8xlarge"
    m6a_12xlarge = "m6a.12xlarge"
    m6a_16xlarge = "m6a.16xlarge"
    m6a_24xlarge = "m6a.24xlarge"
    m6a_32xlarge = "m6a.32xlarge"
    m6a_48xlarge = "m6a.48xlarge"
    m6g_metal = "m6g.metal"
    m6g_medium = "m6g.medium"
    m6g_large = "m6g.large"
    m6g_xlarge = "m6g.xlarge"
    m6g_2xlarge = "m6g.2xlarge"
    m6g_4xlarge = "m6g.4xlarge"
    m6g_8xlarge = "m6g.8xlarge"
    m6g_12xlarge = "m6g.12xlarge"
    m6g_16xlarge = "m6g.16xlarge"
    m6gd_metal = "m6gd.metal"
    m6gd_medium = "m6gd.medium"
    m6gd_large = "m6gd.large"
    m6gd_xlarge = "m6gd.xlarge"
    m6gd_2xlarge = "m6gd.2xlarge"
    m6gd_4xlarge = "m6gd.4xlarge"
    m6gd_8xlarge = "m6gd.8xlarge"
    m6gd_12xlarge = "m6gd.12xlarge"
    m6gd_16xlarge = "m6gd.16xlarge"
    m6i_large = "m6i.large"
    m6i_xlarge = "m6i.xlarge"
    m6i_2xlarge = "m6i.2xlarge"
    m6i_4xlarge = "m6i.4xlarge"
    m6i_8xlarge = "m6i.8xlarge"
    m6i_12xlarge = "m6i.12xlarge"
    m6i_16xlarge = "m6i.16xlarge"
    m6i_24xlarge = "m6i.24xlarge"
    m6i_32xlarge = "m6i.32xlarge"
    m6i_metal = "m6i.metal"
    mac1_metal = "mac1.metal"
    p2_xlarge = "p2.xlarge"
    p2_8xlarge = "p2.8xlarge"
    p2_16xlarge = "p2.16xlarge"
    p3_2xlarge = "p3.2xlarge"
    p3_8xlarge = "p3.8xlarge"
    p3_16xlarge = "p3.16xlarge"
    p3dn_24xlarge = "p3dn.24xlarge"
    p4d_24xlarge = "p4d.24xlarge"
    r3_large = "r3.large"
    r3_xlarge = "r3.xlarge"
    r3_2xlarge = "r3.2xlarge"
    r3_4xlarge = "r3.4xlarge"
    r3_8xlarge = "r3.8xlarge"
    r4_large = "r4.large"
    r4_xlarge = "r4.xlarge"
    r4_2xlarge = "r4.2xlarge"
    r4_4xlarge = "r4.4xlarge"
    r4_8xlarge = "r4.8xlarge"
    r4_16xlarge = "r4.16xlarge"
    r5_large = "r5.large"
    r5_xlarge = "r5.xlarge"
    r5_2xlarge = "r5.2xlarge"
    r5_4xlarge = "r5.4xlarge"
    r5_8xlarge = "r5.8xlarge"
    r5_12xlarge = "r5.12xlarge"
    r5_16xlarge = "r5.16xlarge"
    r5_24xlarge = "r5.24xlarge"
    r5_metal = "r5.metal"
    r5a_large = "r5a.large"
    r5a_xlarge = "r5a.xlarge"
    r5a_2xlarge = "r5a.2xlarge"
    r5a_4xlarge = "r5a.4xlarge"
    r5a_8xlarge = "r5a.8xlarge"
    r5a_12xlarge = "r5a.12xlarge"
    r5a_16xlarge = "r5a.16xlarge"
    r5a_24xlarge = "r5a.24xlarge"
    r5ad_large = "r5ad.large"
    r5ad_xlarge = "r5ad.xlarge"
    r5ad_2xlarge = "r5ad.2xlarge"
    r5ad_4xlarge = "r5ad.4xlarge"
    r5ad_8xlarge = "r5ad.8xlarge"
    r5ad_12xlarge = "r5ad.12xlarge"
    r5ad_16xlarge = "r5ad.16xlarge"
    r5ad_24xlarge = "r5ad.24xlarge"
    r5b_large = "r5b.large"
    r5b_xlarge = "r5b.xlarge"
    r5b_2xlarge = "r5b.2xlarge"
    r5b_4xlarge = "r5b.4xlarge"
    r5b_8xlarge = "r5b.8xlarge"
    r5b_12xlarge = "r5b.12xlarge"
    r5b_16xlarge = "r5b.16xlarge"
    r5b_24xlarge = "r5b.24xlarge"
    r5b_metal = "r5b.metal"
    r5d_large = "r5d.large"
    r5d_xlarge = "r5d.xlarge"
    r5d_2xlarge = "r5d.2xlarge"
    r5d_4xlarge = "r5d.4xlarge"
    r5d_8xlarge = "r5d.8xlarge"
    r5d_12xlarge = "r5d.12xlarge"
    r5d_16xlarge = "r5d.16xlarge"
    r5d_24xlarge = "r5d.24xlarge"
    r5d_metal = "r5d.metal"
    r5dn_large = "r5dn.large"
    r5dn_xlarge = "r5dn.xlarge"
    r5dn_2xlarge = "r5dn.2xlarge"
    r5dn_4xlarge = "r5dn.4xlarge"
    r5dn_8xlarge = "r5dn.8xlarge"
    r5dn_12xlarge = "r5dn.12xlarge"
    r5dn_16xlarge = "r5dn.16xlarge"
    r5dn_24xlarge = "r5dn.24xlarge"
    r5dn_metal = "r5dn.metal"
    r5n_large = "r5n.large"
    r5n_xlarge = "r5n.xlarge"
    r5n_2xlarge = "r5n.2xlarge"
    r5n_4xlarge = "r5n.4xlarge"
    r5n_8xlarge = "r5n.8xlarge"
    r5n_12xlarge = "r5n.12xlarge"
    r5n_16xlarge = "r5n.16xlarge"
    r5n_24xlarge = "r5n.24xlarge"
    r5n_metal = "r5n.metal"
    r6g_medium = "r6g.medium"
    r6g_large = "r6g.large"
    r6g_xlarge = "r6g.xlarge"
    r6g_2xlarge = "r6g.2xlarge"
    r6g_4xlarge = "r6g.4xlarge"
    r6g_8xlarge = "r6g.8xlarge"
    r6g_12xlarge = "r6g.12xlarge"
    r6g_16xlarge = "r6g.16xlarge"
    r6g_metal = "r6g.metal"
    r6gd_medium = "r6gd.medium"
    r6gd_large = "r6gd.large"
    r6gd_xlarge = "r6gd.xlarge"
    r6gd_2xlarge = "r6gd.2xlarge"
    r6gd_4xlarge = "r6gd.4xlarge"
    r6gd_8xlarge = "r6gd.8xlarge"
    r6gd_12xlarge = "r6gd.12xlarge"
    r6gd_16xlarge = "r6gd.16xlarge"
    r6gd_metal = "r6gd.metal"
    r6i_large = "r6i.large"
    r6i_xlarge = "r6i.xlarge"
    r6i_2xlarge = "r6i.2xlarge"
    r6i_4xlarge = "r6i.4xlarge"
    r6i_8xlarge = "r6i.8xlarge"
    r6i_12xlarge = "r6i.12xlarge"
    r6i_16xlarge = "r6i.16xlarge"
    r6i_24xlarge = "r6i.24xlarge"
    r6i_32xlarge = "r6i.32xlarge"
    r6i_metal = "r6i.metal"
    t1_micro = "t1.micro"
    t2_nano = "t2.nano"
    t2_micro = "t2.micro"
    t2_small = "t2.small"
    t2_medium = "t2.medium"
    t2_large = "t2.large"
    t2_xlarge = "t2.xlarge"
    t2_2xlarge = "t2.2xlarge"
    t3_nano = "t3.nano"
    t3_micro = "t3.micro"
    t3_small = "t3.small"
    t3_medium = "t3.medium"
    t3_large = "t3.large"
    t3_xlarge = "t3.xlarge"
    t3_2xlarge = "t3.2xlarge"
    t3a_nano = "t3a.nano"
    t3a_micro = "t3a.micro"
    t3a_small = "t3a.small"
    t3a_medium = "t3a.medium"
    t3a_large = "t3a.large"
    t3a_xlarge = "t3a.xlarge"
    t3a_2xlarge = "t3a.2xlarge"
    t4g_nano = "t4g.nano"
    t4g_micro = "t4g.micro"
    t4g_small = "t4g.small"
    t4g_medium = "t4g.medium"
    t4g_large = "t4g.large"
    t4g_xlarge = "t4g.xlarge"
    t4g_2xlarge = "t4g.2xlarge"
    u_6tb1_56xlarge = "u-6tb1.56xlarge"
    u_6tb1_112xlarge = "u-6tb1.112xlarge"
    u_9tb1_112xlarge = "u-9tb1.112xlarge"
    u_12tb1_112xlarge = "u-12tb1.112xlarge"
    u_6tb1_metal = "u-6tb1.metal"
    u_9tb1_metal = "u-9tb1.metal"
    u_12tb1_metal = "u-12tb1.metal"
    u_18tb1_metal = "u-18tb1.metal"
    u_24tb1_metal = "u-24tb1.metal"
    vt1_3xlarge = "vt1.3xlarge"
    vt1_6xlarge = "vt1.6xlarge"
    vt1_24xlarge = "vt1.24xlarge"
    x1_16xlarge = "x1.16xlarge"
    x1_32xlarge = "x1.32xlarge"
    x1e_xlarge = "x1e.xlarge"
    x1e_2xlarge = "x1e.2xlarge"
    x1e_4xlarge = "x1e.4xlarge"
    x1e_8xlarge = "x1e.8xlarge"
    x1e_16xlarge = "x1e.16xlarge"
    x1e_32xlarge = "x1e.32xlarge"
    x2iezn_2xlarge = "x2iezn.2xlarge"
    x2iezn_4xlarge = "x2iezn.4xlarge"
    x2iezn_6xlarge = "x2iezn.6xlarge"
    x2iezn_8xlarge = "x2iezn.8xlarge"
    x2iezn_12xlarge = "x2iezn.12xlarge"
    x2iezn_metal = "x2iezn.metal"
    x2gd_medium = "x2gd.medium"
    x2gd_large = "x2gd.large"
    x2gd_xlarge = "x2gd.xlarge"
    x2gd_2xlarge = "x2gd.2xlarge"
    x2gd_4xlarge = "x2gd.4xlarge"
    x2gd_8xlarge = "x2gd.8xlarge"
    x2gd_12xlarge = "x2gd.12xlarge"
    x2gd_16xlarge = "x2gd.16xlarge"
    x2gd_metal = "x2gd.metal"
    z1d_large = "z1d.large"
    z1d_xlarge = "z1d.xlarge"
    z1d_2xlarge = "z1d.2xlarge"
    z1d_3xlarge = "z1d.3xlarge"
    z1d_6xlarge = "z1d.6xlarge"
    z1d_12xlarge = "z1d.12xlarge"
    z1d_metal = "z1d.metal"


class InstanceTypeHypervisor(str):
    nitro = "nitro"
    xen = "xen"


class InterfacePermissionType(str):
    INSTANCE_ATTACH = "INSTANCE-ATTACH"
    EIP_ASSOCIATE = "EIP-ASSOCIATE"


class InterfaceProtocolType(str):
    VLAN = "VLAN"
    GRE = "GRE"


class IpamAddressHistoryResourceType(str):
    eip = "eip"
    vpc = "vpc"
    subnet = "subnet"
    network_interface = "network-interface"
    instance = "instance"


class IpamComplianceStatus(str):
    compliant = "compliant"
    noncompliant = "noncompliant"
    unmanaged = "unmanaged"
    ignored = "ignored"


class IpamManagementState(str):
    managed = "managed"
    unmanaged = "unmanaged"
    ignored = "ignored"


class IpamOverlapStatus(str):
    overlapping = "overlapping"
    nonoverlapping = "nonoverlapping"
    ignored = "ignored"


class IpamPoolAllocationResourceType(str):
    ipam_pool = "ipam-pool"
    vpc = "vpc"
    ec2_public_ipv4_pool = "ec2-public-ipv4-pool"
    custom = "custom"


class IpamPoolAwsService(str):
    ec2 = "ec2"


class IpamPoolCidrFailureCode(str):
    cidr_not_available = "cidr-not-available"


class IpamPoolCidrState(str):
    pending_provision = "pending-provision"
    provisioned = "provisioned"
    failed_provision = "failed-provision"
    pending_deprovision = "pending-deprovision"
    deprovisioned = "deprovisioned"
    failed_deprovision = "failed-deprovision"
    pending_import = "pending-import"
    failed_import = "failed-import"


class IpamPoolState(str):
    create_in_progress = "create-in-progress"
    create_complete = "create-complete"
    create_failed = "create-failed"
    modify_in_progress = "modify-in-progress"
    modify_complete = "modify-complete"
    modify_failed = "modify-failed"
    delete_in_progress = "delete-in-progress"
    delete_complete = "delete-complete"
    delete_failed = "delete-failed"


class IpamResourceType(str):
    vpc = "vpc"
    subnet = "subnet"
    eip = "eip"
    public_ipv4_pool = "public-ipv4-pool"
    ipv6_pool = "ipv6-pool"


class IpamScopeState(str):
    create_in_progress = "create-in-progress"
    create_complete = "create-complete"
    create_failed = "create-failed"
    modify_in_progress = "modify-in-progress"
    modify_complete = "modify-complete"
    modify_failed = "modify-failed"
    delete_in_progress = "delete-in-progress"
    delete_complete = "delete-complete"
    delete_failed = "delete-failed"


class IpamScopeType(str):
    public = "public"
    private = "private"


class IpamState(str):
    create_in_progress = "create-in-progress"
    create_complete = "create-complete"
    create_failed = "create-failed"
    modify_in_progress = "modify-in-progress"
    modify_complete = "modify-complete"
    modify_failed = "modify-failed"
    delete_in_progress = "delete-in-progress"
    delete_complete = "delete-complete"
    delete_failed = "delete-failed"


class Ipv6SupportValue(str):
    enable = "enable"
    disable = "disable"


class KeyType(str):
    rsa = "rsa"
    ed25519 = "ed25519"


class LaunchTemplateErrorCode(str):
    launchTemplateIdDoesNotExist = "launchTemplateIdDoesNotExist"
    launchTemplateIdMalformed = "launchTemplateIdMalformed"
    launchTemplateNameDoesNotExist = "launchTemplateNameDoesNotExist"
    launchTemplateNameMalformed = "launchTemplateNameMalformed"
    launchTemplateVersionDoesNotExist = "launchTemplateVersionDoesNotExist"
    unexpectedError = "unexpectedError"


class LaunchTemplateHttpTokensState(str):
    optional = "optional"
    required = "required"


class LaunchTemplateInstanceMetadataEndpointState(str):
    disabled = "disabled"
    enabled = "enabled"


class LaunchTemplateInstanceMetadataOptionsState(str):
    pending = "pending"
    applied = "applied"


class LaunchTemplateInstanceMetadataProtocolIpv6(str):
    disabled = "disabled"
    enabled = "enabled"


class LaunchTemplateInstanceMetadataTagsState(str):
    disabled = "disabled"
    enabled = "enabled"


class ListingState(str):
    available = "available"
    sold = "sold"
    cancelled = "cancelled"
    pending = "pending"


class ListingStatus(str):
    active = "active"
    pending = "pending"
    cancelled = "cancelled"
    closed = "closed"


class LocalGatewayRouteState(str):
    pending = "pending"
    active = "active"
    blackhole = "blackhole"
    deleting = "deleting"
    deleted = "deleted"


class LocalGatewayRouteType(str):
    static = "static"
    propagated = "propagated"


class LocalStorage(str):
    included = "included"
    required = "required"
    excluded = "excluded"


class LocalStorageType(str):
    hdd = "hdd"
    ssd = "ssd"


class LocationType(str):
    region = "region"
    availability_zone = "availability-zone"
    availability_zone_id = "availability-zone-id"


class LogDestinationType(str):
    cloud_watch_logs = "cloud-watch-logs"
    s3 = "s3"


class MarketType(str):
    spot = "spot"


class MembershipType(str):
    static = "static"
    igmp = "igmp"


class ModifyAvailabilityZoneOptInStatus(str):
    opted_in = "opted-in"
    not_opted_in = "not-opted-in"


class MonitoringState(str):
    disabled = "disabled"
    disabling = "disabling"
    enabled = "enabled"
    pending = "pending"


class MoveStatus(str):
    movingToVpc = "movingToVpc"
    restoringToClassic = "restoringToClassic"


class MulticastSupportValue(str):
    enable = "enable"
    disable = "disable"


class NatGatewayState(str):
    pending = "pending"
    failed = "failed"
    available = "available"
    deleting = "deleting"
    deleted = "deleted"


class NetworkInterfaceAttribute(str):
    description = "description"
    groupSet = "groupSet"
    sourceDestCheck = "sourceDestCheck"
    attachment = "attachment"


class NetworkInterfaceCreationType(str):
    efa = "efa"
    branch = "branch"
    trunk = "trunk"


class NetworkInterfacePermissionStateCode(str):
    pending = "pending"
    granted = "granted"
    revoking = "revoking"
    revoked = "revoked"


class NetworkInterfaceStatus(str):
    available = "available"
    associated = "associated"
    attaching = "attaching"
    in_use = "in-use"
    detaching = "detaching"


class NetworkInterfaceType(str):
    interface = "interface"
    natGateway = "natGateway"
    efa = "efa"
    trunk = "trunk"


class OfferingClassType(str):
    standard = "standard"
    convertible = "convertible"


class OfferingTypeValues(str):
    Heavy_Utilization = "Heavy Utilization"
    Medium_Utilization = "Medium Utilization"
    Light_Utilization = "Light Utilization"
    No_Upfront = "No Upfront"
    Partial_Upfront = "Partial Upfront"
    All_Upfront = "All Upfront"


class OnDemandAllocationStrategy(str):
    lowestPrice = "lowestPrice"
    prioritized = "prioritized"


class OperationType(str):
    add = "add"
    remove = "remove"


class PartitionLoadFrequency(str):
    none = "none"
    daily = "daily"
    weekly = "weekly"
    monthly = "monthly"


class PayerResponsibility(str):
    ServiceOwner = "ServiceOwner"


class PaymentOption(str):
    AllUpfront = "AllUpfront"
    PartialUpfront = "PartialUpfront"
    NoUpfront = "NoUpfront"


class PermissionGroup(str):
    all = "all"


class PlacementGroupState(str):
    pending = "pending"
    available = "available"
    deleting = "deleting"
    deleted = "deleted"


class PlacementGroupStrategy(str):
    cluster = "cluster"
    partition = "partition"
    spread = "spread"


class PlacementStrategy(str):
    cluster = "cluster"
    spread = "spread"
    partition = "partition"


class PlatformValues(str):
    Windows = "Windows"


class PrefixListState(str):
    create_in_progress = "create-in-progress"
    create_complete = "create-complete"
    create_failed = "create-failed"
    modify_in_progress = "modify-in-progress"
    modify_complete = "modify-complete"
    modify_failed = "modify-failed"
    restore_in_progress = "restore-in-progress"
    restore_complete = "restore-complete"
    restore_failed = "restore-failed"
    delete_in_progress = "delete-in-progress"
    delete_complete = "delete-complete"
    delete_failed = "delete-failed"


class PrincipalType(str):
    All = "All"
    Service = "Service"
    OrganizationUnit = "OrganizationUnit"
    Account = "Account"
    User = "User"
    Role = "Role"


class ProductCodeValues(str):
    devpay = "devpay"
    marketplace = "marketplace"


class Protocol(str):
    tcp = "tcp"
    udp = "udp"


class ProtocolValue(str):
    gre = "gre"


class RIProductDescription(str):
    Linux_UNIX = "Linux/UNIX"
    Linux_UNIX_Amazon_VPC_ = "Linux/UNIX (Amazon VPC)"
    Windows = "Windows"
    Windows_Amazon_VPC_ = "Windows (Amazon VPC)"


class RecurringChargeFrequency(str):
    Hourly = "Hourly"


class ReplaceRootVolumeTaskState(str):
    pending = "pending"
    in_progress = "in-progress"
    failing = "failing"
    succeeded = "succeeded"
    failed = "failed"
    failed_detached = "failed-detached"


class ReplacementStrategy(str):
    launch = "launch"
    launch_before_terminate = "launch-before-terminate"


class ReportInstanceReasonCodes(str):
    instance_stuck_in_state = "instance-stuck-in-state"
    unresponsive = "unresponsive"
    not_accepting_credentials = "not-accepting-credentials"
    password_not_available = "password-not-available"
    performance_network = "performance-network"
    performance_instance_store = "performance-instance-store"
    performance_ebs_volume = "performance-ebs-volume"
    performance_other = "performance-other"
    other = "other"


class ReportStatusType(str):
    ok = "ok"
    impaired = "impaired"


class ReservationState(str):
    payment_pending = "payment-pending"
    payment_failed = "payment-failed"
    active = "active"
    retired = "retired"


class ReservedInstanceState(str):
    payment_pending = "payment-pending"
    active = "active"
    payment_failed = "payment-failed"
    retired = "retired"
    queued = "queued"
    queued_deleted = "queued-deleted"


class ResetFpgaImageAttributeName(str):
    loadPermission = "loadPermission"


class ResetImageAttributeName(str):
    launchPermission = "launchPermission"


class ResourceType(str):
    capacity_reservation = "capacity-reservation"
    client_vpn_endpoint = "client-vpn-endpoint"
    customer_gateway = "customer-gateway"
    carrier_gateway = "carrier-gateway"
    dedicated_host = "dedicated-host"
    dhcp_options = "dhcp-options"
    egress_only_internet_gateway = "egress-only-internet-gateway"
    elastic_ip = "elastic-ip"
    elastic_gpu = "elastic-gpu"
    export_image_task = "export-image-task"
    export_instance_task = "export-instance-task"
    fleet = "fleet"
    fpga_image = "fpga-image"
    host_reservation = "host-reservation"
    image = "image"
    import_image_task = "import-image-task"
    import_snapshot_task = "import-snapshot-task"
    instance = "instance"
    instance_event_window = "instance-event-window"
    internet_gateway = "internet-gateway"
    ipam = "ipam"
    ipam_pool = "ipam-pool"
    ipam_scope = "ipam-scope"
    ipv4pool_ec2 = "ipv4pool-ec2"
    ipv6pool_ec2 = "ipv6pool-ec2"
    key_pair = "key-pair"
    launch_template = "launch-template"
    local_gateway = "local-gateway"
    local_gateway_route_table = "local-gateway-route-table"
    local_gateway_virtual_interface = "local-gateway-virtual-interface"
    local_gateway_virtual_interface_group = "local-gateway-virtual-interface-group"
    local_gateway_route_table_vpc_association = "local-gateway-route-table-vpc-association"
    local_gateway_route_table_virtual_interface_group_association = (
        "local-gateway-route-table-virtual-interface-group-association"
    )
    natgateway = "natgateway"
    network_acl = "network-acl"
    network_interface = "network-interface"
    network_insights_analysis = "network-insights-analysis"
    network_insights_path = "network-insights-path"
    network_insights_access_scope = "network-insights-access-scope"
    network_insights_access_scope_analysis = "network-insights-access-scope-analysis"
    placement_group = "placement-group"
    prefix_list = "prefix-list"
    replace_root_volume_task = "replace-root-volume-task"
    reserved_instances = "reserved-instances"
    route_table = "route-table"
    security_group = "security-group"
    security_group_rule = "security-group-rule"
    snapshot = "snapshot"
    spot_fleet_request = "spot-fleet-request"
    spot_instances_request = "spot-instances-request"
    subnet = "subnet"
    traffic_mirror_filter = "traffic-mirror-filter"
    traffic_mirror_session = "traffic-mirror-session"
    traffic_mirror_target = "traffic-mirror-target"
    transit_gateway = "transit-gateway"
    transit_gateway_attachment = "transit-gateway-attachment"
    transit_gateway_connect_peer = "transit-gateway-connect-peer"
    transit_gateway_multicast_domain = "transit-gateway-multicast-domain"
    transit_gateway_route_table = "transit-gateway-route-table"
    volume = "volume"
    vpc = "vpc"
    vpc_endpoint = "vpc-endpoint"
    vpc_endpoint_service = "vpc-endpoint-service"
    vpc_peering_connection = "vpc-peering-connection"
    vpn_connection = "vpn-connection"
    vpn_gateway = "vpn-gateway"
    vpc_flow_log = "vpc-flow-log"


class RootDeviceType(str):
    ebs = "ebs"
    instance_store = "instance-store"


class RouteOrigin(str):
    CreateRouteTable = "CreateRouteTable"
    CreateRoute = "CreateRoute"
    EnableVgwRoutePropagation = "EnableVgwRoutePropagation"


class RouteState(str):
    active = "active"
    blackhole = "blackhole"


class RouteTableAssociationStateCode(str):
    associating = "associating"
    associated = "associated"
    disassociating = "disassociating"
    disassociated = "disassociated"
    failed = "failed"


class RuleAction(str):
    allow = "allow"
    deny = "deny"


class SelfServicePortal(str):
    enabled = "enabled"
    disabled = "disabled"


class ServiceState(str):
    Pending = "Pending"
    Available = "Available"
    Deleting = "Deleting"
    Deleted = "Deleted"
    Failed = "Failed"


class ServiceType(str):
    Interface = "Interface"
    Gateway = "Gateway"
    GatewayLoadBalancer = "GatewayLoadBalancer"


class ShutdownBehavior(str):
    stop = "stop"
    terminate = "terminate"


class SnapshotAttributeName(str):
    productCodes = "productCodes"
    createVolumePermission = "createVolumePermission"


class SnapshotState(str):
    pending = "pending"
    completed = "completed"
    error = "error"
    recoverable = "recoverable"
    recovering = "recovering"


class SpotAllocationStrategy(str):
    lowest_price = "lowest-price"
    diversified = "diversified"
    capacity_optimized = "capacity-optimized"
    capacity_optimized_prioritized = "capacity-optimized-prioritized"


class SpotInstanceInterruptionBehavior(str):
    hibernate = "hibernate"
    stop = "stop"
    terminate = "terminate"


class SpotInstanceState(str):
    open = "open"
    active = "active"
    closed = "closed"
    cancelled = "cancelled"
    failed = "failed"


class SpotInstanceType(str):
    one_time = "one-time"
    persistent = "persistent"


class State(str):
    PendingAcceptance = "PendingAcceptance"
    Pending = "Pending"
    Available = "Available"
    Deleting = "Deleting"
    Deleted = "Deleted"
    Rejected = "Rejected"
    Failed = "Failed"
    Expired = "Expired"


class StaticSourcesSupportValue(str):
    enable = "enable"
    disable = "disable"


class Status(str):
    MoveInProgress = "MoveInProgress"
    InVpc = "InVpc"
    InClassic = "InClassic"


class StatusName(str):
    reachability = "reachability"


class StatusType(str):
    passed = "passed"
    failed = "failed"
    insufficient_data = "insufficient-data"
    initializing = "initializing"


class StorageTier(str):
    archive = "archive"
    standard = "standard"


class SubnetCidrBlockStateCode(str):
    associating = "associating"
    associated = "associated"
    disassociating = "disassociating"
    disassociated = "disassociated"
    failing = "failing"
    failed = "failed"


class SubnetCidrReservationType(str):
    prefix = "prefix"
    explicit = "explicit"


class SubnetState(str):
    pending = "pending"
    available = "available"


class SummaryStatus(str):
    ok = "ok"
    impaired = "impaired"
    insufficient_data = "insufficient-data"
    not_applicable = "not-applicable"
    initializing = "initializing"


class TargetCapacityUnitType(str):
    vcpu = "vcpu"
    memory_mib = "memory-mib"
    units = "units"


class TargetStorageTier(str):
    archive = "archive"


class TelemetryStatus(str):
    UP = "UP"
    DOWN = "DOWN"


class Tenancy(str):
    default = "default"
    dedicated = "dedicated"
    host = "host"


class TieringOperationStatus(str):
    archival_in_progress = "archival-in-progress"
    archival_completed = "archival-completed"
    archival_failed = "archival-failed"
    temporary_restore_in_progress = "temporary-restore-in-progress"
    temporary_restore_completed = "temporary-restore-completed"
    temporary_restore_failed = "temporary-restore-failed"
    permanent_restore_in_progress = "permanent-restore-in-progress"
    permanent_restore_completed = "permanent-restore-completed"
    permanent_restore_failed = "permanent-restore-failed"


class TrafficDirection(str):
    ingress = "ingress"
    egress = "egress"


class TrafficMirrorFilterRuleField(str):
    destination_port_range = "destination-port-range"
    source_port_range = "source-port-range"
    protocol = "protocol"
    description = "description"


class TrafficMirrorNetworkService(str):
    amazon_dns = "amazon-dns"


class TrafficMirrorRuleAction(str):
    accept = "accept"
    reject = "reject"


class TrafficMirrorSessionField(str):
    packet_length = "packet-length"
    description = "description"
    virtual_network_id = "virtual-network-id"


class TrafficMirrorTargetType(str):
    network_interface = "network-interface"
    network_load_balancer = "network-load-balancer"


class TrafficType(str):
    ACCEPT = "ACCEPT"
    REJECT = "REJECT"
    ALL = "ALL"


class TransitGatewayAssociationState(str):
    associating = "associating"
    associated = "associated"
    disassociating = "disassociating"
    disassociated = "disassociated"


class TransitGatewayAttachmentResourceType(str):
    vpc = "vpc"
    vpn = "vpn"
    direct_connect_gateway = "direct-connect-gateway"
    connect = "connect"
    peering = "peering"
    tgw_peering = "tgw-peering"


class TransitGatewayAttachmentState(str):
    initiating = "initiating"
    initiatingRequest = "initiatingRequest"
    pendingAcceptance = "pendingAcceptance"
    rollingBack = "rollingBack"
    pending = "pending"
    available = "available"
    modifying = "modifying"
    deleting = "deleting"
    deleted = "deleted"
    failed = "failed"
    rejected = "rejected"
    rejecting = "rejecting"
    failing = "failing"


class TransitGatewayConnectPeerState(str):
    pending = "pending"
    available = "available"
    deleting = "deleting"
    deleted = "deleted"


class TransitGatewayMulitcastDomainAssociationState(str):
    pendingAcceptance = "pendingAcceptance"
    associating = "associating"
    associated = "associated"
    disassociating = "disassociating"
    disassociated = "disassociated"
    rejected = "rejected"
    failed = "failed"


class TransitGatewayMulticastDomainState(str):
    pending = "pending"
    available = "available"
    deleting = "deleting"
    deleted = "deleted"


class TransitGatewayPrefixListReferenceState(str):
    pending = "pending"
    available = "available"
    modifying = "modifying"
    deleting = "deleting"


class TransitGatewayPropagationState(str):
    enabling = "enabling"
    enabled = "enabled"
    disabling = "disabling"
    disabled = "disabled"


class TransitGatewayRouteState(str):
    pending = "pending"
    active = "active"
    blackhole = "blackhole"
    deleting = "deleting"
    deleted = "deleted"


class TransitGatewayRouteTableState(str):
    pending = "pending"
    available = "available"
    deleting = "deleting"
    deleted = "deleted"


class TransitGatewayRouteType(str):
    static = "static"
    propagated = "propagated"


class TransitGatewayState(str):
    pending = "pending"
    available = "available"
    modifying = "modifying"
    deleting = "deleting"
    deleted = "deleted"


class TransportProtocol(str):
    tcp = "tcp"
    udp = "udp"


class TunnelInsideIpVersion(str):
    ipv4 = "ipv4"
    ipv6 = "ipv6"


class UnlimitedSupportedInstanceFamily(str):
    t2 = "t2"
    t3 = "t3"
    t3a = "t3a"
    t4g = "t4g"


class UnsuccessfulInstanceCreditSpecificationErrorCode(str):
    InvalidInstanceID_Malformed = "InvalidInstanceID.Malformed"
    InvalidInstanceID_NotFound = "InvalidInstanceID.NotFound"
    IncorrectInstanceState = "IncorrectInstanceState"
    InstanceCreditSpecification_NotSupported = "InstanceCreditSpecification.NotSupported"


class UsageClassType(str):
    spot = "spot"
    on_demand = "on-demand"


class VirtualizationType(str):
    hvm = "hvm"
    paravirtual = "paravirtual"


class VolumeAttachmentState(str):
    attaching = "attaching"
    attached = "attached"
    detaching = "detaching"
    detached = "detached"
    busy = "busy"


class VolumeAttributeName(str):
    autoEnableIO = "autoEnableIO"
    productCodes = "productCodes"


class VolumeModificationState(str):
    modifying = "modifying"
    optimizing = "optimizing"
    completed = "completed"
    failed = "failed"


class VolumeState(str):
    creating = "creating"
    available = "available"
    in_use = "in-use"
    deleting = "deleting"
    deleted = "deleted"
    error = "error"


class VolumeStatusInfoStatus(str):
    ok = "ok"
    impaired = "impaired"
    insufficient_data = "insufficient-data"


class VolumeStatusName(str):
    io_enabled = "io-enabled"
    io_performance = "io-performance"


class VolumeType(str):
    standard = "standard"
    io1 = "io1"
    io2 = "io2"
    gp2 = "gp2"
    sc1 = "sc1"
    st1 = "st1"
    gp3 = "gp3"


class VpcAttributeName(str):
    enableDnsSupport = "enableDnsSupport"
    enableDnsHostnames = "enableDnsHostnames"


class VpcCidrBlockStateCode(str):
    associating = "associating"
    associated = "associated"
    disassociating = "disassociating"
    disassociated = "disassociated"
    failing = "failing"
    failed = "failed"


class VpcEndpointType(str):
    Interface = "Interface"
    Gateway = "Gateway"
    GatewayLoadBalancer = "GatewayLoadBalancer"


class VpcPeeringConnectionStateReasonCode(str):
    initiating_request = "initiating-request"
    pending_acceptance = "pending-acceptance"
    active = "active"
    deleted = "deleted"
    rejected = "rejected"
    failed = "failed"
    expired = "expired"
    provisioning = "provisioning"
    deleting = "deleting"


class VpcState(str):
    pending = "pending"
    available = "available"


class VpcTenancy(str):
    default = "default"


class VpnEcmpSupportValue(str):
    enable = "enable"
    disable = "disable"


class VpnProtocol(str):
    openvpn = "openvpn"


class VpnState(str):
    pending = "pending"
    available = "available"
    deleting = "deleting"
    deleted = "deleted"


class VpnStaticRouteSource(str):
    Static = "Static"


class WeekDay(str):
    sunday = "sunday"
    monday = "monday"
    tuesday = "tuesday"
    wednesday = "wednesday"
    thursday = "thursday"
    friday = "friday"
    saturday = "saturday"


class scope(str):
    Availability_Zone = "Availability Zone"
    Region = "Region"


class AcceleratorCount(TypedDict, total=False):
    """The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon
    Web Services Inferentia chips) on an instance.
    """

    Min: Optional[Integer]
    Max: Optional[Integer]


class AcceleratorCountRequest(TypedDict, total=False):
    """The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon
    Web Services Inferentia chips) on an instance. To exclude
    accelerator-enabled instance types, set ``Max`` to ``0``.
    """

    Min: Optional[Integer]
    Max: Optional[Integer]


AcceleratorManufacturerSet = List[AcceleratorManufacturer]
AcceleratorNameSet = List[AcceleratorName]


class AcceleratorTotalMemoryMiB(TypedDict, total=False):
    """The minimum and maximum amount of total accelerator memory, in MiB."""

    Min: Optional[Integer]
    Max: Optional[Integer]


class AcceleratorTotalMemoryMiBRequest(TypedDict, total=False):
    """The minimum and maximum amount of total accelerator memory, in MiB."""

    Min: Optional[Integer]
    Max: Optional[Integer]


AcceleratorTypeSet = List[AcceleratorType]


class TargetConfigurationRequest(TypedDict, total=False):
    """Details about the target configuration."""

    InstanceCount: Optional[Integer]
    OfferingId: ReservedInstancesOfferingId


TargetConfigurationRequestSet = List[TargetConfigurationRequest]
ReservedInstanceIdSet = List[ReservationId]


class AcceptReservedInstancesExchangeQuoteRequest(ServiceRequest):
    """Contains the parameters for accepting the quote."""

    DryRun: Optional[Boolean]
    ReservedInstanceIds: ReservedInstanceIdSet
    TargetConfigurations: Optional[TargetConfigurationRequestSet]


class AcceptReservedInstancesExchangeQuoteResult(TypedDict, total=False):
    """The result of the exchange and whether it was ``successful``."""

    ExchangeId: Optional[String]


ValueStringList = List[String]


class AcceptTransitGatewayMulticastDomainAssociationsRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    SubnetIds: Optional[ValueStringList]
    DryRun: Optional[Boolean]


class SubnetAssociation(TypedDict, total=False):
    """Describes the subnet association with the transit gateway multicast
    domain.
    """

    SubnetId: Optional[String]
    State: Optional[TransitGatewayMulitcastDomainAssociationState]


SubnetAssociationList = List[SubnetAssociation]


class TransitGatewayMulticastDomainAssociations(TypedDict, total=False):
    """Describes the multicast domain associations."""

    TransitGatewayMulticastDomainId: Optional[String]
    TransitGatewayAttachmentId: Optional[String]
    ResourceId: Optional[String]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]
    ResourceOwnerId: Optional[String]
    Subnets: Optional[SubnetAssociationList]


class AcceptTransitGatewayMulticastDomainAssociationsResult(TypedDict, total=False):
    Associations: Optional[TransitGatewayMulticastDomainAssociations]


class AcceptTransitGatewayPeeringAttachmentRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class Tag(TypedDict, total=False):
    """Describes a tag."""

    Key: Optional[String]
    Value: Optional[String]


TagList = List[Tag]
DateTime = datetime


class PeeringAttachmentStatus(TypedDict, total=False):
    """The status of the transit gateway peering attachment."""

    Code: Optional[String]
    Message: Optional[String]


class PeeringTgwInfo(TypedDict, total=False):
    """Information about the transit gateway in the peering attachment."""

    TransitGatewayId: Optional[String]
    OwnerId: Optional[String]
    Region: Optional[String]


class TransitGatewayPeeringAttachment(TypedDict, total=False):
    """Describes the transit gateway peering attachment."""

    TransitGatewayAttachmentId: Optional[String]
    RequesterTgwInfo: Optional[PeeringTgwInfo]
    AccepterTgwInfo: Optional[PeeringTgwInfo]
    Status: Optional[PeeringAttachmentStatus]
    State: Optional[TransitGatewayAttachmentState]
    CreationTime: Optional[DateTime]
    Tags: Optional[TagList]


class AcceptTransitGatewayPeeringAttachmentResult(TypedDict, total=False):
    TransitGatewayPeeringAttachment: Optional[TransitGatewayPeeringAttachment]


class AcceptTransitGatewayVpcAttachmentRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class TransitGatewayVpcAttachmentOptions(TypedDict, total=False):
    """Describes the VPC attachment options."""

    DnsSupport: Optional[DnsSupportValue]
    Ipv6Support: Optional[Ipv6SupportValue]
    ApplianceModeSupport: Optional[ApplianceModeSupportValue]


class TransitGatewayVpcAttachment(TypedDict, total=False):
    """Describes a VPC attachment."""

    TransitGatewayAttachmentId: Optional[String]
    TransitGatewayId: Optional[String]
    VpcId: Optional[String]
    VpcOwnerId: Optional[String]
    State: Optional[TransitGatewayAttachmentState]
    SubnetIds: Optional[ValueStringList]
    CreationTime: Optional[DateTime]
    Options: Optional[TransitGatewayVpcAttachmentOptions]
    Tags: Optional[TagList]


class AcceptTransitGatewayVpcAttachmentResult(TypedDict, total=False):
    TransitGatewayVpcAttachment: Optional[TransitGatewayVpcAttachment]


VpcEndpointIdList = List[VpcEndpointId]


class AcceptVpcEndpointConnectionsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceId: VpcEndpointServiceId
    VpcEndpointIds: VpcEndpointIdList


class UnsuccessfulItemError(TypedDict, total=False):
    """Information about the error that occurred. For more information about
    errors, see `Error
    codes <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html>`__.
    """

    Code: Optional[String]
    Message: Optional[String]


class UnsuccessfulItem(TypedDict, total=False):
    """Information about items that were not successfully processed in a batch
    call.
    """

    Error: Optional[UnsuccessfulItemError]
    ResourceId: Optional[String]


UnsuccessfulItemSet = List[UnsuccessfulItem]


class AcceptVpcEndpointConnectionsResult(TypedDict, total=False):
    Unsuccessful: Optional[UnsuccessfulItemSet]


class AcceptVpcPeeringConnectionRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VpcPeeringConnectionId: Optional[VpcPeeringConnectionId]


class VpcPeeringConnectionStateReason(TypedDict, total=False):
    """Describes the status of a VPC peering connection."""

    Code: Optional[VpcPeeringConnectionStateReasonCode]
    Message: Optional[String]


class VpcPeeringConnectionOptionsDescription(TypedDict, total=False):
    """Describes the VPC peering connection options."""

    AllowDnsResolutionFromRemoteVpc: Optional[Boolean]
    AllowEgressFromLocalClassicLinkToRemoteVpc: Optional[Boolean]
    AllowEgressFromLocalVpcToRemoteClassicLink: Optional[Boolean]


class CidrBlock(TypedDict, total=False):
    """Describes an IPv4 CIDR block."""

    CidrBlock: Optional[String]


CidrBlockSet = List[CidrBlock]


class Ipv6CidrBlock(TypedDict, total=False):
    """Describes an IPv6 CIDR block."""

    Ipv6CidrBlock: Optional[String]


Ipv6CidrBlockSet = List[Ipv6CidrBlock]


class VpcPeeringConnectionVpcInfo(TypedDict, total=False):
    """Describes a VPC in a VPC peering connection."""

    CidrBlock: Optional[String]
    Ipv6CidrBlockSet: Optional[Ipv6CidrBlockSet]
    CidrBlockSet: Optional[CidrBlockSet]
    OwnerId: Optional[String]
    PeeringOptions: Optional[VpcPeeringConnectionOptionsDescription]
    VpcId: Optional[String]
    Region: Optional[String]


class VpcPeeringConnection(TypedDict, total=False):
    """Describes a VPC peering connection."""

    AccepterVpcInfo: Optional[VpcPeeringConnectionVpcInfo]
    ExpirationTime: Optional[DateTime]
    RequesterVpcInfo: Optional[VpcPeeringConnectionVpcInfo]
    Status: Optional[VpcPeeringConnectionStateReason]
    Tags: Optional[TagList]
    VpcPeeringConnectionId: Optional[String]


class AcceptVpcPeeringConnectionResult(TypedDict, total=False):
    VpcPeeringConnection: Optional[VpcPeeringConnection]


class AnalysisComponent(TypedDict, total=False):
    """Describes a path component."""

    Id: Optional[String]
    Arn: Optional[String]
    Name: Optional[String]


class PortRange(TypedDict, total=False):
    """Describes a range of ports."""

    From: Optional[Integer]
    To: Optional[Integer]


class AnalysisSecurityGroupRule(TypedDict, total=False):
    """Describes a security group rule."""

    Cidr: Optional[String]
    Direction: Optional[String]
    SecurityGroupId: Optional[String]
    PortRange: Optional[PortRange]
    PrefixListId: Optional[String]
    Protocol: Optional[String]


class AnalysisRouteTableRoute(TypedDict, total=False):
    """Describes a route table route."""

    DestinationCidr: Optional[String]
    DestinationPrefixListId: Optional[String]
    EgressOnlyInternetGatewayId: Optional[String]
    GatewayId: Optional[String]
    InstanceId: Optional[String]
    NatGatewayId: Optional[String]
    NetworkInterfaceId: Optional[String]
    Origin: Optional[String]
    TransitGatewayId: Optional[String]
    VpcPeeringConnectionId: Optional[String]


PortRangeList = List[PortRange]
IpAddressList = List[IpAddress]


class AnalysisPacketHeader(TypedDict, total=False):
    """Describes a header. Reflects any changes made by a component as traffic
    passes through. The fields of an inbound header are null except for the
    first component of a path.
    """

    DestinationAddresses: Optional[IpAddressList]
    DestinationPortRanges: Optional[PortRangeList]
    Protocol: Optional[String]
    SourceAddresses: Optional[IpAddressList]
    SourcePortRanges: Optional[PortRangeList]


class AnalysisAclRule(TypedDict, total=False):
    """Describes a network access control (ACL) rule."""

    Cidr: Optional[String]
    Egress: Optional[Boolean]
    PortRange: Optional[PortRange]
    Protocol: Optional[String]
    RuleAction: Optional[String]
    RuleNumber: Optional[Integer]


class PathComponent(TypedDict, total=False):
    """Describes a path component."""

    SequenceNumber: Optional[Integer]
    AclRule: Optional[AnalysisAclRule]
    AttachedTo: Optional[AnalysisComponent]
    Component: Optional[AnalysisComponent]
    DestinationVpc: Optional[AnalysisComponent]
    OutboundHeader: Optional[AnalysisPacketHeader]
    InboundHeader: Optional[AnalysisPacketHeader]
    RouteTableRoute: Optional[AnalysisRouteTableRoute]
    SecurityGroupRule: Optional[AnalysisSecurityGroupRule]
    SourceVpc: Optional[AnalysisComponent]
    Subnet: Optional[AnalysisComponent]
    Vpc: Optional[AnalysisComponent]


PathComponentList = List[PathComponent]


class AccessScopeAnalysisFinding(TypedDict, total=False):
    """Describes a finding for a Network Access Scope."""

    NetworkInsightsAccessScopeAnalysisId: Optional[NetworkInsightsAccessScopeAnalysisId]
    NetworkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    FindingId: Optional[String]
    FindingComponents: Optional[PathComponentList]


AccessScopeAnalysisFindingList = List[AccessScopeAnalysisFinding]


class ResourceStatement(TypedDict, total=False):
    """Describes a resource statement."""

    Resources: Optional[ValueStringList]
    ResourceTypes: Optional[ValueStringList]


class ThroughResourcesStatement(TypedDict, total=False):
    """Describes a through resource statement."""

    ResourceStatement: Optional[ResourceStatement]


ThroughResourcesStatementList = List[ThroughResourcesStatement]
ProtocolList = List[Protocol]


class PacketHeaderStatement(TypedDict, total=False):
    """Describes a packet header statement."""

    SourceAddresses: Optional[ValueStringList]
    DestinationAddresses: Optional[ValueStringList]
    SourcePorts: Optional[ValueStringList]
    DestinationPorts: Optional[ValueStringList]
    SourcePrefixLists: Optional[ValueStringList]
    DestinationPrefixLists: Optional[ValueStringList]
    Protocols: Optional[ProtocolList]


class PathStatement(TypedDict, total=False):
    """Describes a path statement."""

    PacketHeaderStatement: Optional[PacketHeaderStatement]
    ResourceStatement: Optional[ResourceStatement]


class AccessScopePath(TypedDict, total=False):
    """Describes a path."""

    Source: Optional[PathStatement]
    Destination: Optional[PathStatement]
    ThroughResources: Optional[ThroughResourcesStatementList]


AccessScopePathList = List[AccessScopePath]


class ResourceStatementRequest(TypedDict, total=False):
    """Describes a resource statement."""

    Resources: Optional[ValueStringList]
    ResourceTypes: Optional[ValueStringList]


class ThroughResourcesStatementRequest(TypedDict, total=False):
    """Describes a through resource statement."""

    ResourceStatement: Optional[ResourceStatementRequest]


ThroughResourcesStatementRequestList = List[ThroughResourcesStatementRequest]


class PacketHeaderStatementRequest(TypedDict, total=False):
    """Describes a packet header statement."""

    SourceAddresses: Optional[ValueStringList]
    DestinationAddresses: Optional[ValueStringList]
    SourcePorts: Optional[ValueStringList]
    DestinationPorts: Optional[ValueStringList]
    SourcePrefixLists: Optional[ValueStringList]
    DestinationPrefixLists: Optional[ValueStringList]
    Protocols: Optional[ProtocolList]


class PathStatementRequest(TypedDict, total=False):
    """Describes a path statement."""

    PacketHeaderStatement: Optional[PacketHeaderStatementRequest]
    ResourceStatement: Optional[ResourceStatementRequest]


class AccessScopePathRequest(TypedDict, total=False):
    """Describes a path."""

    Source: Optional[PathStatementRequest]
    Destination: Optional[PathStatementRequest]
    ThroughResources: Optional[ThroughResourcesStatementRequestList]


AccessScopePathListRequest = List[AccessScopePathRequest]


class AccountAttributeValue(TypedDict, total=False):
    """Describes a value of an account attribute."""

    AttributeValue: Optional[String]


AccountAttributeValueList = List[AccountAttributeValue]


class AccountAttribute(TypedDict, total=False):
    """Describes an account attribute."""

    AttributeName: Optional[String]
    AttributeValues: Optional[AccountAttributeValueList]


AccountAttributeList = List[AccountAttribute]
AccountAttributeNameStringList = List[AccountAttributeName]


class ActiveInstance(TypedDict, total=False):
    """Describes a running instance in a Spot Fleet."""

    InstanceId: Optional[String]
    InstanceType: Optional[String]
    SpotInstanceRequestId: Optional[String]
    InstanceHealth: Optional[InstanceHealthStatus]


ActiveInstanceSet = List[ActiveInstance]


class AddIpamOperatingRegion(TypedDict, total=False):
    """Add an operating Region to an IPAM. Operating Regions are Amazon Web
    Services Regions where the IPAM is allowed to manage IP address CIDRs.
    IPAM only discovers and monitors resources in the Amazon Web Services
    Regions you select as operating Regions.

    For more information about operating Regions, see `Create an
    IPAM </vpc/latest/ipam/create-ipam.html>`__ in the *Amazon VPC IPAM User
    Guide*.
    """

    RegionName: Optional[String]


AddIpamOperatingRegionSet = List[AddIpamOperatingRegion]


class AddPrefixListEntry(TypedDict, total=False):
    """An entry for a prefix list."""

    Cidr: String
    Description: Optional[String]


AddPrefixListEntries = List[AddPrefixListEntry]


class Address(TypedDict, total=False):
    """Describes an Elastic IP address, or a carrier IP address."""

    InstanceId: Optional[String]
    PublicIp: Optional[String]
    AllocationId: Optional[String]
    AssociationId: Optional[String]
    Domain: Optional[DomainType]
    NetworkInterfaceId: Optional[String]
    NetworkInterfaceOwnerId: Optional[String]
    PrivateIpAddress: Optional[String]
    Tags: Optional[TagList]
    PublicIpv4Pool: Optional[String]
    NetworkBorderGroup: Optional[String]
    CustomerOwnedIp: Optional[String]
    CustomerOwnedIpv4Pool: Optional[String]
    CarrierIp: Optional[String]


class PtrUpdateStatus(TypedDict, total=False):
    """The status of an updated pointer (PTR) record for an Elastic IP address."""

    Value: Optional[String]
    Status: Optional[String]
    Reason: Optional[String]


class AddressAttribute(TypedDict, total=False):
    """The attributes associated with an Elastic IP address."""

    PublicIp: Optional[PublicIpAddress]
    AllocationId: Optional[AllocationId]
    PtrRecord: Optional[String]
    PtrRecordUpdate: Optional[PtrUpdateStatus]


AddressList = List[Address]
AddressSet = List[AddressAttribute]


class AdvertiseByoipCidrRequest(ServiceRequest):
    Cidr: String
    DryRun: Optional[Boolean]


class ByoipCidr(TypedDict, total=False):
    """Information about an address range that is provisioned for use with your
    Amazon Web Services resources through bring your own IP addresses
    (BYOIP).
    """

    Cidr: Optional[String]
    Description: Optional[String]
    StatusMessage: Optional[String]
    State: Optional[ByoipCidrState]


class AdvertiseByoipCidrResult(TypedDict, total=False):
    ByoipCidr: Optional[ByoipCidr]


class TagSpecification(TypedDict, total=False):
    """The tags to apply to a resource when the resource is being created."""

    ResourceType: Optional[ResourceType]
    Tags: Optional[TagList]


TagSpecificationList = List[TagSpecification]


class AllocateAddressRequest(ServiceRequest):
    Domain: Optional[DomainType]
    Address: Optional[PublicIpAddress]
    PublicIpv4Pool: Optional[Ipv4PoolEc2Id]
    NetworkBorderGroup: Optional[String]
    CustomerOwnedIpv4Pool: Optional[String]
    DryRun: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]


class AllocateAddressResult(TypedDict, total=False):
    PublicIp: Optional[String]
    AllocationId: Optional[String]
    PublicIpv4Pool: Optional[String]
    NetworkBorderGroup: Optional[String]
    Domain: Optional[DomainType]
    CustomerOwnedIp: Optional[String]
    CustomerOwnedIpv4Pool: Optional[String]
    CarrierIp: Optional[String]


class AllocateHostsRequest(ServiceRequest):
    AutoPlacement: Optional[AutoPlacement]
    AvailabilityZone: String
    ClientToken: Optional[String]
    InstanceType: Optional[String]
    InstanceFamily: Optional[String]
    Quantity: Integer
    TagSpecifications: Optional[TagSpecificationList]
    HostRecovery: Optional[HostRecovery]


ResponseHostIdList = List[String]


class AllocateHostsResult(TypedDict, total=False):
    """Contains the output of AllocateHosts."""

    HostIds: Optional[ResponseHostIdList]


IpamPoolAllocationDisallowedCidrs = List[String]


class AllocateIpamPoolCidrRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamPoolId: IpamPoolId
    Cidr: Optional[String]
    NetmaskLength: Optional[Integer]
    ClientToken: Optional[String]
    Description: Optional[String]
    PreviewNextCidr: Optional[Boolean]
    DisallowedCidrs: Optional[IpamPoolAllocationDisallowedCidrs]


class IpamPoolAllocation(TypedDict, total=False):
    """In IPAM, an allocation is a CIDR assignment from an IPAM pool to another
    resource or IPAM pool.
    """

    Cidr: Optional[String]
    IpamPoolAllocationId: Optional[IpamPoolAllocationId]
    Description: Optional[String]
    ResourceId: Optional[String]
    ResourceType: Optional[IpamPoolAllocationResourceType]
    ResourceRegion: Optional[String]
    ResourceOwner: Optional[String]


class AllocateIpamPoolCidrResult(TypedDict, total=False):
    IpamPoolAllocation: Optional[IpamPoolAllocation]


AllocationIdList = List[AllocationId]
AllocationIds = List[AllocationId]


class AllowedPrincipal(TypedDict, total=False):
    """Describes a principal."""

    PrincipalType: Optional[PrincipalType]
    Principal: Optional[String]


AllowedPrincipalSet = List[AllowedPrincipal]


class AlternatePathHint(TypedDict, total=False):
    """Describes an potential intermediate component of a feasible path."""

    ComponentId: Optional[String]
    ComponentArn: Optional[String]


AlternatePathHintList = List[AlternatePathHint]
AnalysisComponentList = List[AnalysisComponent]


class AnalysisLoadBalancerListener(TypedDict, total=False):
    """Describes a load balancer listener."""

    LoadBalancerPort: Optional[Port]
    InstancePort: Optional[Port]


class AnalysisLoadBalancerTarget(TypedDict, total=False):
    """Describes a load balancer target."""

    Address: Optional[IpAddress]
    AvailabilityZone: Optional[String]
    Instance: Optional[AnalysisComponent]
    Port: Optional[Port]


ClientVpnSecurityGroupIdSet = List[SecurityGroupId]


class ApplySecurityGroupsToClientVpnTargetNetworkRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    VpcId: VpcId
    SecurityGroupIds: ClientVpnSecurityGroupIdSet
    DryRun: Optional[Boolean]


class ApplySecurityGroupsToClientVpnTargetNetworkResult(TypedDict, total=False):
    SecurityGroupIds: Optional[ClientVpnSecurityGroupIdSet]


ArchitectureTypeList = List[ArchitectureType]
ArchitectureTypeSet = List[ArchitectureType]
ArnList = List[ResourceArn]
IpPrefixList = List[String]
Ipv6AddressList = List[String]


class AssignIpv6AddressesRequest(ServiceRequest):
    Ipv6AddressCount: Optional[Integer]
    Ipv6Addresses: Optional[Ipv6AddressList]
    Ipv6PrefixCount: Optional[Integer]
    Ipv6Prefixes: Optional[IpPrefixList]
    NetworkInterfaceId: NetworkInterfaceId


class AssignIpv6AddressesResult(TypedDict, total=False):
    AssignedIpv6Addresses: Optional[Ipv6AddressList]
    AssignedIpv6Prefixes: Optional[IpPrefixList]
    NetworkInterfaceId: Optional[String]


PrivateIpAddressStringList = List[String]


class AssignPrivateIpAddressesRequest(ServiceRequest):
    """Contains the parameters for AssignPrivateIpAddresses."""

    AllowReassignment: Optional[Boolean]
    NetworkInterfaceId: NetworkInterfaceId
    PrivateIpAddresses: Optional[PrivateIpAddressStringList]
    SecondaryPrivateIpAddressCount: Optional[Integer]
    Ipv4Prefixes: Optional[IpPrefixList]
    Ipv4PrefixCount: Optional[Integer]


class Ipv4PrefixSpecification(TypedDict, total=False):
    """Describes an IPv4 prefix."""

    Ipv4Prefix: Optional[String]


Ipv4PrefixesList = List[Ipv4PrefixSpecification]


class AssignedPrivateIpAddress(TypedDict, total=False):
    """Describes the private IP addresses assigned to a network interface."""

    PrivateIpAddress: Optional[String]


AssignedPrivateIpAddressList = List[AssignedPrivateIpAddress]


class AssignPrivateIpAddressesResult(TypedDict, total=False):
    NetworkInterfaceId: Optional[String]
    AssignedPrivateIpAddresses: Optional[AssignedPrivateIpAddressList]
    AssignedIpv4Prefixes: Optional[Ipv4PrefixesList]


class AssociateAddressRequest(ServiceRequest):
    AllocationId: Optional[AllocationId]
    InstanceId: Optional[InstanceId]
    PublicIp: Optional[String]
    AllowReassociation: Optional[Boolean]
    DryRun: Optional[Boolean]
    NetworkInterfaceId: Optional[NetworkInterfaceId]
    PrivateIpAddress: Optional[String]


class AssociateAddressResult(TypedDict, total=False):
    AssociationId: Optional[String]


class AssociateClientVpnTargetNetworkRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    SubnetId: SubnetId
    ClientToken: Optional[String]
    DryRun: Optional[Boolean]


class AssociationStatus(TypedDict, total=False):
    """Describes the state of a target network association."""

    Code: Optional[AssociationStatusCode]
    Message: Optional[String]


class AssociateClientVpnTargetNetworkResult(TypedDict, total=False):
    AssociationId: Optional[String]
    Status: Optional[AssociationStatus]


class AssociateDhcpOptionsRequest(ServiceRequest):
    DhcpOptionsId: DefaultingDhcpOptionsId
    VpcId: VpcId
    DryRun: Optional[Boolean]


class AssociateEnclaveCertificateIamRoleRequest(ServiceRequest):
    CertificateArn: Optional[ResourceArn]
    RoleArn: Optional[ResourceArn]
    DryRun: Optional[Boolean]


class AssociateEnclaveCertificateIamRoleResult(TypedDict, total=False):
    CertificateS3BucketName: Optional[String]
    CertificateS3ObjectKey: Optional[String]
    EncryptionKmsKeyId: Optional[String]


class IamInstanceProfileSpecification(TypedDict, total=False):
    """Describes an IAM instance profile."""

    Arn: Optional[String]
    Name: Optional[String]


class AssociateIamInstanceProfileRequest(ServiceRequest):
    IamInstanceProfile: IamInstanceProfileSpecification
    InstanceId: InstanceId


class IamInstanceProfile(TypedDict, total=False):
    """Describes an IAM instance profile."""

    Arn: Optional[String]
    Id: Optional[String]


class IamInstanceProfileAssociation(TypedDict, total=False):
    """Describes an association between an IAM instance profile and an
    instance.
    """

    AssociationId: Optional[String]
    InstanceId: Optional[String]
    IamInstanceProfile: Optional[IamInstanceProfile]
    State: Optional[IamInstanceProfileAssociationState]
    Timestamp: Optional[DateTime]


class AssociateIamInstanceProfileResult(TypedDict, total=False):
    IamInstanceProfileAssociation: Optional[IamInstanceProfileAssociation]


DedicatedHostIdList = List[DedicatedHostId]
InstanceIdList = List[InstanceId]


class InstanceEventWindowAssociationRequest(TypedDict, total=False):
    """One or more targets associated with the specified event window. Only one
    *type* of target (instance ID, instance tag, or Dedicated Host ID) can
    be associated with an event window.
    """

    InstanceIds: Optional[InstanceIdList]
    InstanceTags: Optional[TagList]
    DedicatedHostIds: Optional[DedicatedHostIdList]


class AssociateInstanceEventWindowRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceEventWindowId: InstanceEventWindowId
    AssociationTarget: InstanceEventWindowAssociationRequest


class InstanceEventWindowAssociationTarget(TypedDict, total=False):
    """One or more targets associated with the event window."""

    InstanceIds: Optional[InstanceIdList]
    Tags: Optional[TagList]
    DedicatedHostIds: Optional[DedicatedHostIdList]


class InstanceEventWindowTimeRange(TypedDict, total=False):
    """The start day and time and the end day and time of the time range, in
    UTC.
    """

    StartWeekDay: Optional[WeekDay]
    StartHour: Optional[Hour]
    EndWeekDay: Optional[WeekDay]
    EndHour: Optional[Hour]


InstanceEventWindowTimeRangeList = List[InstanceEventWindowTimeRange]


class InstanceEventWindow(TypedDict, total=False):
    """The event window."""

    InstanceEventWindowId: Optional[InstanceEventWindowId]
    TimeRanges: Optional[InstanceEventWindowTimeRangeList]
    Name: Optional[String]
    CronExpression: Optional[InstanceEventWindowCronExpression]
    AssociationTarget: Optional[InstanceEventWindowAssociationTarget]
    State: Optional[InstanceEventWindowState]
    Tags: Optional[TagList]


class AssociateInstanceEventWindowResult(TypedDict, total=False):
    InstanceEventWindow: Optional[InstanceEventWindow]


class AssociateRouteTableRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    RouteTableId: RouteTableId
    SubnetId: Optional[SubnetId]
    GatewayId: Optional[RouteGatewayId]


class RouteTableAssociationState(TypedDict, total=False):
    """Describes the state of an association between a route table and a subnet
    or gateway.
    """

    State: Optional[RouteTableAssociationStateCode]
    StatusMessage: Optional[String]


class AssociateRouteTableResult(TypedDict, total=False):
    AssociationId: Optional[String]
    AssociationState: Optional[RouteTableAssociationState]


class AssociateSubnetCidrBlockRequest(ServiceRequest):
    Ipv6CidrBlock: String
    SubnetId: SubnetId


class SubnetCidrBlockState(TypedDict, total=False):
    """Describes the state of a CIDR block."""

    State: Optional[SubnetCidrBlockStateCode]
    StatusMessage: Optional[String]


class SubnetIpv6CidrBlockAssociation(TypedDict, total=False):
    """Describes an association between a subnet and an IPv6 CIDR block."""

    AssociationId: Optional[SubnetCidrAssociationId]
    Ipv6CidrBlock: Optional[String]
    Ipv6CidrBlockState: Optional[SubnetCidrBlockState]


class AssociateSubnetCidrBlockResult(TypedDict, total=False):
    Ipv6CidrBlockAssociation: Optional[SubnetIpv6CidrBlockAssociation]
    SubnetId: Optional[String]


TransitGatewaySubnetIdList = List[SubnetId]


class AssociateTransitGatewayMulticastDomainRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    SubnetIds: Optional[TransitGatewaySubnetIdList]
    DryRun: Optional[Boolean]


class AssociateTransitGatewayMulticastDomainResult(TypedDict, total=False):
    Associations: Optional[TransitGatewayMulticastDomainAssociations]


class AssociateTransitGatewayRouteTableRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class TransitGatewayAssociation(TypedDict, total=False):
    """Describes an association between a resource attachment and a transit
    gateway route table.
    """

    TransitGatewayRouteTableId: Optional[TransitGatewayRouteTableId]
    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    ResourceId: Optional[String]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]
    State: Optional[TransitGatewayAssociationState]


class AssociateTransitGatewayRouteTableResult(TypedDict, total=False):
    Association: Optional[TransitGatewayAssociation]


class AssociateTrunkInterfaceRequest(ServiceRequest):
    BranchInterfaceId: NetworkInterfaceId
    TrunkInterfaceId: NetworkInterfaceId
    VlanId: Optional[Integer]
    GreKey: Optional[Integer]
    ClientToken: Optional[String]
    DryRun: Optional[Boolean]


class TrunkInterfaceAssociation(TypedDict, total=False):
    """Currently available in **limited preview only**. If you are interested
    in using this feature, contact your account manager.

    Information about an association between a branch network interface with
    a trunk network interface.
    """

    AssociationId: Optional[TrunkInterfaceAssociationId]
    BranchInterfaceId: Optional[String]
    TrunkInterfaceId: Optional[String]
    InterfaceProtocol: Optional[InterfaceProtocolType]
    VlanId: Optional[Integer]
    GreKey: Optional[Integer]
    Tags: Optional[TagList]


class AssociateTrunkInterfaceResult(TypedDict, total=False):
    InterfaceAssociation: Optional[TrunkInterfaceAssociation]
    ClientToken: Optional[String]


class AssociateVpcCidrBlockRequest(ServiceRequest):
    AmazonProvidedIpv6CidrBlock: Optional[Boolean]
    CidrBlock: Optional[String]
    VpcId: VpcId
    Ipv6CidrBlockNetworkBorderGroup: Optional[String]
    Ipv6Pool: Optional[Ipv6PoolEc2Id]
    Ipv6CidrBlock: Optional[String]
    Ipv4IpamPoolId: Optional[IpamPoolId]
    Ipv4NetmaskLength: Optional[NetmaskLength]
    Ipv6IpamPoolId: Optional[IpamPoolId]
    Ipv6NetmaskLength: Optional[NetmaskLength]


class VpcCidrBlockState(TypedDict, total=False):
    """Describes the state of a CIDR block."""

    State: Optional[VpcCidrBlockStateCode]
    StatusMessage: Optional[String]


class VpcCidrBlockAssociation(TypedDict, total=False):
    """Describes an IPv4 CIDR block associated with a VPC."""

    AssociationId: Optional[String]
    CidrBlock: Optional[String]
    CidrBlockState: Optional[VpcCidrBlockState]


class VpcIpv6CidrBlockAssociation(TypedDict, total=False):
    """Describes an IPv6 CIDR block associated with a VPC."""

    AssociationId: Optional[String]
    Ipv6CidrBlock: Optional[String]
    Ipv6CidrBlockState: Optional[VpcCidrBlockState]
    NetworkBorderGroup: Optional[String]
    Ipv6Pool: Optional[String]


class AssociateVpcCidrBlockResult(TypedDict, total=False):
    Ipv6CidrBlockAssociation: Optional[VpcIpv6CidrBlockAssociation]
    CidrBlockAssociation: Optional[VpcCidrBlockAssociation]
    VpcId: Optional[String]


class AssociatedRole(TypedDict, total=False):
    """Information about the associated IAM roles."""

    AssociatedRoleArn: Optional[ResourceArn]
    CertificateS3BucketName: Optional[String]
    CertificateS3ObjectKey: Optional[String]
    EncryptionKmsKeyId: Optional[String]


AssociatedRolesList = List[AssociatedRole]


class AssociatedTargetNetwork(TypedDict, total=False):
    """Describes a target network that is associated with a Client VPN
    endpoint. A target network is a subnet in a VPC.
    """

    NetworkId: Optional[String]
    NetworkType: Optional[AssociatedNetworkType]


AssociatedTargetNetworkSet = List[AssociatedTargetNetwork]
AssociationIdList = List[IamInstanceProfileAssociationId]
MillisecondDateTime = datetime


class AthenaIntegration(TypedDict, total=False):
    """Describes integration options for Amazon Athena."""

    IntegrationResultS3DestinationArn: String
    PartitionLoadFrequency: PartitionLoadFrequency
    PartitionStartDate: Optional[MillisecondDateTime]
    PartitionEndDate: Optional[MillisecondDateTime]


AthenaIntegrationsSet = List[AthenaIntegration]
GroupIdStringList = List[SecurityGroupId]


class AttachClassicLinkVpcRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Groups: GroupIdStringList
    InstanceId: InstanceId
    VpcId: VpcId


class AttachClassicLinkVpcResult(TypedDict, total=False):
    Return: Optional[Boolean]


class AttachInternetGatewayRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InternetGatewayId: InternetGatewayId
    VpcId: VpcId


class AttachNetworkInterfaceRequest(ServiceRequest):
    """Contains the parameters for AttachNetworkInterface."""

    DeviceIndex: Integer
    DryRun: Optional[Boolean]
    InstanceId: InstanceId
    NetworkInterfaceId: NetworkInterfaceId
    NetworkCardIndex: Optional[Integer]


class AttachNetworkInterfaceResult(TypedDict, total=False):
    """Contains the output of AttachNetworkInterface."""

    AttachmentId: Optional[String]
    NetworkCardIndex: Optional[Integer]


class AttachVolumeRequest(ServiceRequest):
    Device: String
    InstanceId: InstanceId
    VolumeId: VolumeId
    DryRun: Optional[Boolean]


class AttachVpnGatewayRequest(ServiceRequest):
    """Contains the parameters for AttachVpnGateway."""

    VpcId: VpcId
    VpnGatewayId: VpnGatewayId
    DryRun: Optional[Boolean]


class VpcAttachment(TypedDict, total=False):
    """Describes an attachment between a virtual private gateway and a VPC."""

    State: Optional[AttachmentStatus]
    VpcId: Optional[String]


class AttachVpnGatewayResult(TypedDict, total=False):
    """Contains the output of AttachVpnGateway."""

    VpcAttachment: Optional[VpcAttachment]


class AttributeBooleanValue(TypedDict, total=False):
    """Describes a value for a resource attribute that is a Boolean value."""

    Value: Optional[Boolean]


class AttributeValue(TypedDict, total=False):
    """Describes a value for a resource attribute that is a String."""

    Value: Optional[String]


class ClientVpnAuthorizationRuleStatus(TypedDict, total=False):
    """Describes the state of an authorization rule."""

    Code: Optional[ClientVpnAuthorizationRuleStatusCode]
    Message: Optional[String]


class AuthorizationRule(TypedDict, total=False):
    """Information about an authorization rule."""

    ClientVpnEndpointId: Optional[String]
    Description: Optional[String]
    GroupId: Optional[String]
    AccessAll: Optional[Boolean]
    DestinationCidr: Optional[String]
    Status: Optional[ClientVpnAuthorizationRuleStatus]


AuthorizationRuleSet = List[AuthorizationRule]


class AuthorizeClientVpnIngressRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    TargetNetworkCidr: String
    AccessGroupId: Optional[String]
    AuthorizeAllGroups: Optional[Boolean]
    Description: Optional[String]
    ClientToken: Optional[String]
    DryRun: Optional[Boolean]


class AuthorizeClientVpnIngressResult(TypedDict, total=False):
    Status: Optional[ClientVpnAuthorizationRuleStatus]


class UserIdGroupPair(TypedDict, total=False):
    """Describes a security group and Amazon Web Services account ID pair."""

    Description: Optional[String]
    GroupId: Optional[String]
    GroupName: Optional[String]
    PeeringStatus: Optional[String]
    UserId: Optional[String]
    VpcId: Optional[String]
    VpcPeeringConnectionId: Optional[String]


UserIdGroupPairList = List[UserIdGroupPair]


class PrefixListId(TypedDict, total=False):
    """Describes a prefix list ID."""

    Description: Optional[String]
    PrefixListId: Optional[String]


PrefixListIdList = List[PrefixListId]


class Ipv6Range(TypedDict, total=False):
    """[EC2-VPC only] Describes an IPv6 range."""

    CidrIpv6: Optional[String]
    Description: Optional[String]


Ipv6RangeList = List[Ipv6Range]


class IpRange(TypedDict, total=False):
    """Describes an IPv4 range."""

    CidrIp: Optional[String]
    Description: Optional[String]


IpRangeList = List[IpRange]


class IpPermission(TypedDict, total=False):
    """Describes a set of permissions for a security group rule."""

    FromPort: Optional[Integer]
    IpProtocol: Optional[String]
    IpRanges: Optional[IpRangeList]
    Ipv6Ranges: Optional[Ipv6RangeList]
    PrefixListIds: Optional[PrefixListIdList]
    ToPort: Optional[Integer]
    UserIdGroupPairs: Optional[UserIdGroupPairList]


IpPermissionList = List[IpPermission]


class AuthorizeSecurityGroupEgressRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    GroupId: SecurityGroupId
    IpPermissions: Optional[IpPermissionList]
    TagSpecifications: Optional[TagSpecificationList]
    CidrIp: Optional[String]
    FromPort: Optional[Integer]
    IpProtocol: Optional[String]
    ToPort: Optional[Integer]
    SourceSecurityGroupName: Optional[String]
    SourceSecurityGroupOwnerId: Optional[String]


class ReferencedSecurityGroup(TypedDict, total=False):
    """Describes the security group that is referenced in the security group
    rule.
    """

    GroupId: Optional[String]
    PeeringStatus: Optional[String]
    UserId: Optional[String]
    VpcId: Optional[String]
    VpcPeeringConnectionId: Optional[String]


class SecurityGroupRule(TypedDict, total=False):
    """Describes a security group rule."""

    SecurityGroupRuleId: Optional[SecurityGroupRuleId]
    GroupId: Optional[SecurityGroupId]
    GroupOwnerId: Optional[String]
    IsEgress: Optional[Boolean]
    IpProtocol: Optional[String]
    FromPort: Optional[Integer]
    ToPort: Optional[Integer]
    CidrIpv4: Optional[String]
    CidrIpv6: Optional[String]
    PrefixListId: Optional[PrefixListResourceId]
    ReferencedGroupInfo: Optional[ReferencedSecurityGroup]
    Description: Optional[String]
    Tags: Optional[TagList]


SecurityGroupRuleList = List[SecurityGroupRule]


class AuthorizeSecurityGroupEgressResult(TypedDict, total=False):
    Return: Optional[Boolean]
    SecurityGroupRules: Optional[SecurityGroupRuleList]


class AuthorizeSecurityGroupIngressRequest(ServiceRequest):
    CidrIp: Optional[String]
    FromPort: Optional[Integer]
    GroupId: Optional[SecurityGroupId]
    GroupName: Optional[SecurityGroupName]
    IpPermissions: Optional[IpPermissionList]
    IpProtocol: Optional[String]
    SourceSecurityGroupName: Optional[String]
    SourceSecurityGroupOwnerId: Optional[String]
    ToPort: Optional[Integer]
    DryRun: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]


class AuthorizeSecurityGroupIngressResult(TypedDict, total=False):
    Return: Optional[Boolean]
    SecurityGroupRules: Optional[SecurityGroupRuleList]


class AvailabilityZoneMessage(TypedDict, total=False):
    """Describes a message about an Availability Zone, Local Zone, or
    Wavelength Zone.
    """

    Message: Optional[String]


AvailabilityZoneMessageList = List[AvailabilityZoneMessage]


class AvailabilityZone(TypedDict, total=False):
    """Describes Availability Zones, Local Zones, and Wavelength Zones."""

    State: Optional[AvailabilityZoneState]
    OptInStatus: Optional[AvailabilityZoneOptInStatus]
    Messages: Optional[AvailabilityZoneMessageList]
    RegionName: Optional[String]
    ZoneName: Optional[String]
    ZoneId: Optional[String]
    GroupName: Optional[String]
    NetworkBorderGroup: Optional[String]
    ZoneType: Optional[String]
    ParentZoneName: Optional[String]
    ParentZoneId: Optional[String]


AvailabilityZoneList = List[AvailabilityZone]
AvailabilityZoneStringList = List[String]


class InstanceCapacity(TypedDict, total=False):
    """Information about the number of instances that can be launched onto the
    Dedicated Host.
    """

    AvailableCapacity: Optional[Integer]
    InstanceType: Optional[String]
    TotalCapacity: Optional[Integer]


AvailableInstanceCapacityList = List[InstanceCapacity]


class AvailableCapacity(TypedDict, total=False):
    """The capacity information for instances that can be launched onto the
    Dedicated Host.
    """

    AvailableInstanceCapacity: Optional[AvailableInstanceCapacityList]
    AvailableVCpus: Optional[Integer]


class BaselineEbsBandwidthMbps(TypedDict, total=False):
    """The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For
    more information, see `Amazon EBS–optimized
    instances <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html>`__
    in the *Amazon EC2 User Guide*.
    """

    Min: Optional[Integer]
    Max: Optional[Integer]


class BaselineEbsBandwidthMbpsRequest(TypedDict, total=False):
    """The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For
    more information, see `Amazon EBS–optimized
    instances <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html>`__
    in the *Amazon EC2 User Guide*.
    """

    Min: Optional[Integer]
    Max: Optional[Integer]


BillingProductList = List[String]
Blob = bytes


class BlobAttributeValue(TypedDict, total=False):
    Value: Optional[Blob]


class EbsBlockDevice(TypedDict, total=False):
    """Describes a block device for an EBS volume."""

    DeleteOnTermination: Optional[Boolean]
    Iops: Optional[Integer]
    SnapshotId: Optional[SnapshotId]
    VolumeSize: Optional[Integer]
    VolumeType: Optional[VolumeType]
    KmsKeyId: Optional[String]
    Throughput: Optional[Integer]
    OutpostArn: Optional[String]
    Encrypted: Optional[Boolean]


class BlockDeviceMapping(TypedDict, total=False):
    """Describes a block device mapping, which defines the EBS volumes and
    instance store volumes to attach to an instance at launch.
    """

    DeviceName: Optional[String]
    VirtualName: Optional[String]
    Ebs: Optional[EbsBlockDevice]
    NoDevice: Optional[String]


BlockDeviceMappingList = List[BlockDeviceMapping]
BlockDeviceMappingRequestList = List[BlockDeviceMapping]
BootModeTypeList = List[BootModeType]
BundleIdStringList = List[BundleId]


class S3Storage(TypedDict, total=False):
    """Describes the storage parameters for Amazon S3 and Amazon S3 buckets for
    an instance store-backed AMI.
    """

    AWSAccessKeyId: Optional[String]
    Bucket: Optional[String]
    Prefix: Optional[String]
    UploadPolicy: Optional[Blob]
    UploadPolicySignature: Optional[String]


class Storage(TypedDict, total=False):
    """Describes the storage location for an instance store-backed AMI."""

    S3: Optional[S3Storage]


class BundleInstanceRequest(ServiceRequest):
    """Contains the parameters for BundleInstance."""

    InstanceId: InstanceId
    Storage: Storage
    DryRun: Optional[Boolean]


class BundleTaskError(TypedDict, total=False):
    """Describes an error for BundleInstance."""

    Code: Optional[String]
    Message: Optional[String]


class BundleTask(TypedDict, total=False):
    """Describes a bundle task."""

    BundleId: Optional[String]
    BundleTaskError: Optional[BundleTaskError]
    InstanceId: Optional[String]
    Progress: Optional[String]
    StartTime: Optional[DateTime]
    State: Optional[BundleTaskState]
    Storage: Optional[Storage]
    UpdateTime: Optional[DateTime]


class BundleInstanceResult(TypedDict, total=False):
    """Contains the output of BundleInstance."""

    BundleTask: Optional[BundleTask]


BundleTaskList = List[BundleTask]
ByoipCidrSet = List[ByoipCidr]


class CancelBundleTaskRequest(ServiceRequest):
    """Contains the parameters for CancelBundleTask."""

    BundleId: BundleId
    DryRun: Optional[Boolean]


class CancelBundleTaskResult(TypedDict, total=False):
    """Contains the output of CancelBundleTask."""

    BundleTask: Optional[BundleTask]


class CancelCapacityReservationFleetError(TypedDict, total=False):
    """Describes a Capacity Reservation Fleet cancellation error."""

    Code: Optional[CancelCapacityReservationFleetErrorCode]
    Message: Optional[CancelCapacityReservationFleetErrorMessage]


CapacityReservationFleetIdSet = List[CapacityReservationFleetId]


class CancelCapacityReservationFleetsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    CapacityReservationFleetIds: CapacityReservationFleetIdSet


class FailedCapacityReservationFleetCancellationResult(TypedDict, total=False):
    """Describes a Capacity Reservation Fleet that could not be cancelled."""

    CapacityReservationFleetId: Optional[CapacityReservationFleetId]
    CancelCapacityReservationFleetError: Optional[CancelCapacityReservationFleetError]


FailedCapacityReservationFleetCancellationResultSet = List[
    FailedCapacityReservationFleetCancellationResult
]


class CapacityReservationFleetCancellationState(TypedDict, total=False):
    """Describes a Capacity Reservation Fleet that was successfully cancelled."""

    CurrentFleetState: Optional[CapacityReservationFleetState]
    PreviousFleetState: Optional[CapacityReservationFleetState]
    CapacityReservationFleetId: Optional[CapacityReservationFleetId]


CapacityReservationFleetCancellationStateSet = List[CapacityReservationFleetCancellationState]


class CancelCapacityReservationFleetsResult(TypedDict, total=False):
    SuccessfulFleetCancellations: Optional[CapacityReservationFleetCancellationStateSet]
    FailedFleetCancellations: Optional[FailedCapacityReservationFleetCancellationResultSet]


class CancelCapacityReservationRequest(ServiceRequest):
    CapacityReservationId: CapacityReservationId
    DryRun: Optional[Boolean]


class CancelCapacityReservationResult(TypedDict, total=False):
    Return: Optional[Boolean]


class CancelConversionRequest(ServiceRequest):
    ConversionTaskId: ConversionTaskId
    DryRun: Optional[Boolean]
    ReasonMessage: Optional[String]


class CancelExportTaskRequest(ServiceRequest):
    ExportTaskId: ExportVmTaskId


class CancelImportTaskRequest(ServiceRequest):
    CancelReason: Optional[String]
    DryRun: Optional[Boolean]
    ImportTaskId: Optional[ImportTaskId]


class CancelImportTaskResult(TypedDict, total=False):
    ImportTaskId: Optional[String]
    PreviousState: Optional[String]
    State: Optional[String]


class CancelReservedInstancesListingRequest(ServiceRequest):
    """Contains the parameters for CancelReservedInstancesListing."""

    ReservedInstancesListingId: ReservedInstancesListingId


Long = int


class PriceSchedule(TypedDict, total=False):
    """Describes the price for a Reserved Instance."""

    Active: Optional[Boolean]
    CurrencyCode: Optional[CurrencyCodeValues]
    Price: Optional[Double]
    Term: Optional[Long]


PriceScheduleList = List[PriceSchedule]


class InstanceCount(TypedDict, total=False):
    """Describes a Reserved Instance listing state."""

    InstanceCount: Optional[Integer]
    State: Optional[ListingState]


InstanceCountList = List[InstanceCount]


class ReservedInstancesListing(TypedDict, total=False):
    """Describes a Reserved Instance listing."""

    ClientToken: Optional[String]
    CreateDate: Optional[DateTime]
    InstanceCounts: Optional[InstanceCountList]
    PriceSchedules: Optional[PriceScheduleList]
    ReservedInstancesId: Optional[String]
    ReservedInstancesListingId: Optional[String]
    Status: Optional[ListingStatus]
    StatusMessage: Optional[String]
    Tags: Optional[TagList]
    UpdateDate: Optional[DateTime]


ReservedInstancesListingList = List[ReservedInstancesListing]


class CancelReservedInstancesListingResult(TypedDict, total=False):
    """Contains the output of CancelReservedInstancesListing."""

    ReservedInstancesListings: Optional[ReservedInstancesListingList]


class CancelSpotFleetRequestsError(TypedDict, total=False):
    """Describes a Spot Fleet error."""

    Code: Optional[CancelBatchErrorCode]
    Message: Optional[String]


class CancelSpotFleetRequestsErrorItem(TypedDict, total=False):
    """Describes a Spot Fleet request that was not successfully canceled."""

    Error: Optional[CancelSpotFleetRequestsError]
    SpotFleetRequestId: Optional[String]


CancelSpotFleetRequestsErrorSet = List[CancelSpotFleetRequestsErrorItem]
SpotFleetRequestIdList = List[SpotFleetRequestId]


class CancelSpotFleetRequestsRequest(ServiceRequest):
    """Contains the parameters for CancelSpotFleetRequests."""

    DryRun: Optional[Boolean]
    SpotFleetRequestIds: SpotFleetRequestIdList
    TerminateInstances: Boolean


class CancelSpotFleetRequestsSuccessItem(TypedDict, total=False):
    """Describes a Spot Fleet request that was successfully canceled."""

    CurrentSpotFleetRequestState: Optional[BatchState]
    PreviousSpotFleetRequestState: Optional[BatchState]
    SpotFleetRequestId: Optional[String]


CancelSpotFleetRequestsSuccessSet = List[CancelSpotFleetRequestsSuccessItem]


class CancelSpotFleetRequestsResponse(TypedDict, total=False):
    """Contains the output of CancelSpotFleetRequests."""

    SuccessfulFleetRequests: Optional[CancelSpotFleetRequestsSuccessSet]
    UnsuccessfulFleetRequests: Optional[CancelSpotFleetRequestsErrorSet]


SpotInstanceRequestIdList = List[SpotInstanceRequestId]


class CancelSpotInstanceRequestsRequest(ServiceRequest):
    """Contains the parameters for CancelSpotInstanceRequests."""

    DryRun: Optional[Boolean]
    SpotInstanceRequestIds: SpotInstanceRequestIdList


class CancelledSpotInstanceRequest(TypedDict, total=False):
    """Describes a request to cancel a Spot Instance."""

    SpotInstanceRequestId: Optional[String]
    State: Optional[CancelSpotInstanceRequestState]


CancelledSpotInstanceRequestList = List[CancelledSpotInstanceRequest]


class CancelSpotInstanceRequestsResult(TypedDict, total=False):
    """Contains the output of CancelSpotInstanceRequests."""

    CancelledSpotInstanceRequests: Optional[CancelledSpotInstanceRequestList]


class CapacityReservation(TypedDict, total=False):
    """Describes a Capacity Reservation."""

    CapacityReservationId: Optional[String]
    OwnerId: Optional[String]
    CapacityReservationArn: Optional[String]
    AvailabilityZoneId: Optional[String]
    InstanceType: Optional[String]
    InstancePlatform: Optional[CapacityReservationInstancePlatform]
    AvailabilityZone: Optional[String]
    Tenancy: Optional[CapacityReservationTenancy]
    TotalInstanceCount: Optional[Integer]
    AvailableInstanceCount: Optional[Integer]
    EbsOptimized: Optional[Boolean]
    EphemeralStorage: Optional[Boolean]
    State: Optional[CapacityReservationState]
    StartDate: Optional[MillisecondDateTime]
    EndDate: Optional[DateTime]
    EndDateType: Optional[EndDateType]
    InstanceMatchCriteria: Optional[InstanceMatchCriteria]
    CreateDate: Optional[DateTime]
    Tags: Optional[TagList]
    OutpostArn: Optional[OutpostArn]
    CapacityReservationFleetId: Optional[String]
    PlacementGroupArn: Optional[PlacementGroupArn]


class FleetCapacityReservation(TypedDict, total=False):
    """Information about a Capacity Reservation in a Capacity Reservation
    Fleet.
    """

    CapacityReservationId: Optional[CapacityReservationId]
    AvailabilityZoneId: Optional[String]
    InstanceType: Optional[InstanceType]
    InstancePlatform: Optional[CapacityReservationInstancePlatform]
    AvailabilityZone: Optional[String]
    TotalInstanceCount: Optional[Integer]
    FulfilledCapacity: Optional[Double]
    EbsOptimized: Optional[Boolean]
    CreateDate: Optional[MillisecondDateTime]
    Weight: Optional[DoubleWithConstraints]
    Priority: Optional[IntegerWithConstraints]


FleetCapacityReservationSet = List[FleetCapacityReservation]


class CapacityReservationFleet(TypedDict, total=False):
    """Information about a Capacity Reservation Fleet."""

    CapacityReservationFleetId: Optional[CapacityReservationFleetId]
    CapacityReservationFleetArn: Optional[String]
    State: Optional[CapacityReservationFleetState]
    TotalTargetCapacity: Optional[Integer]
    TotalFulfilledCapacity: Optional[Double]
    Tenancy: Optional[FleetCapacityReservationTenancy]
    EndDate: Optional[MillisecondDateTime]
    CreateTime: Optional[MillisecondDateTime]
    InstanceMatchCriteria: Optional[FleetInstanceMatchCriteria]
    AllocationStrategy: Optional[String]
    InstanceTypeSpecifications: Optional[FleetCapacityReservationSet]
    Tags: Optional[TagList]


CapacityReservationFleetSet = List[CapacityReservationFleet]


class CapacityReservationGroup(TypedDict, total=False):
    """Describes a resource group to which a Capacity Reservation has been
    added.
    """

    GroupArn: Optional[String]
    OwnerId: Optional[String]


CapacityReservationGroupSet = List[CapacityReservationGroup]
CapacityReservationIdSet = List[CapacityReservationId]


class CapacityReservationOptions(TypedDict, total=False):
    """Describes the strategy for using unused Capacity Reservations for
    fulfilling On-Demand capacity.

    This strategy can only be used if the EC2 Fleet is of type ``instant``.

    For more information about Capacity Reservations, see `On-Demand
    Capacity
    Reservations <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html>`__
    in the *Amazon EC2 User Guide*. For examples of using Capacity
    Reservations in an EC2 Fleet, see `EC2 Fleet example
    configurations <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html>`__
    in the *Amazon EC2 User Guide*.
    """

    UsageStrategy: Optional[FleetCapacityReservationUsageStrategy]


class CapacityReservationOptionsRequest(TypedDict, total=False):
    """Describes the strategy for using unused Capacity Reservations for
    fulfilling On-Demand capacity.

    This strategy can only be used if the EC2 Fleet is of type ``instant``.

    For more information about Capacity Reservations, see `On-Demand
    Capacity
    Reservations <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html>`__
    in the *Amazon EC2 User Guide*. For examples of using Capacity
    Reservations in an EC2 Fleet, see `EC2 Fleet example
    configurations <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html>`__
    in the *Amazon EC2 User Guide*.
    """

    UsageStrategy: Optional[FleetCapacityReservationUsageStrategy]


CapacityReservationSet = List[CapacityReservation]


class CapacityReservationTarget(TypedDict, total=False):
    """Describes a target Capacity Reservation or Capacity Reservation group."""

    CapacityReservationId: Optional[CapacityReservationId]
    CapacityReservationResourceGroupArn: Optional[String]


class CapacityReservationSpecification(TypedDict, total=False):
    """Describes an instance's Capacity Reservation targeting option. You can
    specify only one parameter at a time. If you specify
    ``CapacityReservationPreference`` and ``CapacityReservationTarget``, the
    request fails.

    Use the ``CapacityReservationPreference`` parameter to configure the
    instance to run as an On-Demand Instance or to run in any ``open``
    Capacity Reservation that has matching attributes (instance type,
    platform, Availability Zone). Use the ``CapacityReservationTarget``
    parameter to explicitly target a specific Capacity Reservation or a
    Capacity Reservation group.
    """

    CapacityReservationPreference: Optional[CapacityReservationPreference]
    CapacityReservationTarget: Optional[CapacityReservationTarget]


class CapacityReservationTargetResponse(TypedDict, total=False):
    """Describes a target Capacity Reservation or Capacity Reservation group."""

    CapacityReservationId: Optional[String]
    CapacityReservationResourceGroupArn: Optional[String]


class CapacityReservationSpecificationResponse(TypedDict, total=False):
    """Describes the instance's Capacity Reservation targeting preferences. The
    action returns the ``capacityReservationPreference`` response element if
    the instance is configured to run in On-Demand capacity, or if it is
    configured in run in any ``open`` Capacity Reservation that has matching
    attributes (instance type, platform, Availability Zone). The action
    returns the ``capacityReservationTarget`` response element if the
    instance explicily targets a specific Capacity Reservation or Capacity
    Reservation group.
    """

    CapacityReservationPreference: Optional[CapacityReservationPreference]
    CapacityReservationTarget: Optional[CapacityReservationTargetResponse]


class CarrierGateway(TypedDict, total=False):
    """Describes a carrier gateway."""

    CarrierGatewayId: Optional[CarrierGatewayId]
    VpcId: Optional[VpcId]
    State: Optional[CarrierGatewayState]
    OwnerId: Optional[String]
    Tags: Optional[TagList]


CarrierGatewayIdSet = List[CarrierGatewayId]
CarrierGatewaySet = List[CarrierGateway]


class CertificateAuthentication(TypedDict, total=False):
    """Information about the client certificate used for authentication."""

    ClientRootCertificateChain: Optional[String]


class CertificateAuthenticationRequest(TypedDict, total=False):
    """Information about the client certificate to be used for authentication."""

    ClientRootCertificateChainArn: Optional[String]


class CidrAuthorizationContext(TypedDict, total=False):
    """Provides authorization for Amazon to bring a specific IP address range
    to a specific Amazon Web Services account using bring your own IP
    addresses (BYOIP). For more information, see `Configuring your BYOIP
    address
    range <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip>`__
    in the *Amazon Elastic Compute Cloud User Guide*.
    """

    Message: String
    Signature: String


class ClassicLinkDnsSupport(TypedDict, total=False):
    """Describes the ClassicLink DNS support status of a VPC."""

    ClassicLinkDnsSupported: Optional[Boolean]
    VpcId: Optional[String]


ClassicLinkDnsSupportList = List[ClassicLinkDnsSupport]


class GroupIdentifier(TypedDict, total=False):
    """Describes a security group."""

    GroupName: Optional[String]
    GroupId: Optional[String]


GroupIdentifierList = List[GroupIdentifier]


class ClassicLinkInstance(TypedDict, total=False):
    """Describes a linked EC2-Classic instance."""

    Groups: Optional[GroupIdentifierList]
    InstanceId: Optional[String]
    Tags: Optional[TagList]
    VpcId: Optional[String]


ClassicLinkInstanceList = List[ClassicLinkInstance]


class ClassicLoadBalancer(TypedDict, total=False):
    """Describes a Classic Load Balancer."""

    Name: Optional[String]


ClassicLoadBalancers = List[ClassicLoadBalancer]


class ClassicLoadBalancersConfig(TypedDict, total=False):
    """Describes the Classic Load Balancers to attach to a Spot Fleet. Spot
    Fleet registers the running Spot Instances with these Classic Load
    Balancers.
    """

    ClassicLoadBalancers: Optional[ClassicLoadBalancers]


class ClientCertificateRevocationListStatus(TypedDict, total=False):
    """Describes the state of a client certificate revocation list."""

    Code: Optional[ClientCertificateRevocationListStatusCode]
    Message: Optional[String]


class ClientConnectOptions(TypedDict, total=False):
    """The options for managing connection authorization for new client
    connections.
    """

    Enabled: Optional[Boolean]
    LambdaFunctionArn: Optional[String]


class ClientVpnEndpointAttributeStatus(TypedDict, total=False):
    """Describes the status of the Client VPN endpoint attribute."""

    Code: Optional[ClientVpnEndpointAttributeStatusCode]
    Message: Optional[String]


class ClientConnectResponseOptions(TypedDict, total=False):
    """The options for managing connection authorization for new client
    connections.
    """

    Enabled: Optional[Boolean]
    LambdaFunctionArn: Optional[String]
    Status: Optional[ClientVpnEndpointAttributeStatus]


class ClientData(TypedDict, total=False):
    """Describes the client-specific data."""

    Comment: Optional[String]
    UploadEnd: Optional[DateTime]
    UploadSize: Optional[Double]
    UploadStart: Optional[DateTime]


class ClientLoginBannerOptions(TypedDict, total=False):
    Enabled: Optional[Boolean]
    BannerText: Optional[String]


class ClientLoginBannerResponseOptions(TypedDict, total=False):
    Enabled: Optional[Boolean]
    BannerText: Optional[String]


class FederatedAuthentication(TypedDict, total=False):
    """Describes the IAM SAML identity providers used for federated
    authentication.
    """

    SamlProviderArn: Optional[String]
    SelfServiceSamlProviderArn: Optional[String]


class DirectoryServiceAuthentication(TypedDict, total=False):
    """Describes an Active Directory."""

    DirectoryId: Optional[String]


class ClientVpnAuthentication(TypedDict, total=False):
    """Describes the authentication methods used by a Client VPN endpoint. For
    more information, see
    `Authentication <https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html>`__
    in the *Client VPN Administrator Guide*.
    """

    Type: Optional[ClientVpnAuthenticationType]
    ActiveDirectory: Optional[DirectoryServiceAuthentication]
    MutualAuthentication: Optional[CertificateAuthentication]
    FederatedAuthentication: Optional[FederatedAuthentication]


ClientVpnAuthenticationList = List[ClientVpnAuthentication]


class FederatedAuthenticationRequest(TypedDict, total=False):
    """The IAM SAML identity provider used for federated authentication."""

    SAMLProviderArn: Optional[String]
    SelfServiceSAMLProviderArn: Optional[String]


class DirectoryServiceAuthenticationRequest(TypedDict, total=False):
    """Describes the Active Directory to be used for client authentication."""

    DirectoryId: Optional[String]


class ClientVpnAuthenticationRequest(TypedDict, total=False):
    """Describes the authentication method to be used by a Client VPN endpoint.
    For more information, see
    `Authentication <https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication>`__
    in the *Client VPN Administrator Guide*.
    """

    Type: Optional[ClientVpnAuthenticationType]
    ActiveDirectory: Optional[DirectoryServiceAuthenticationRequest]
    MutualAuthentication: Optional[CertificateAuthenticationRequest]
    FederatedAuthentication: Optional[FederatedAuthenticationRequest]


ClientVpnAuthenticationRequestList = List[ClientVpnAuthenticationRequest]


class ClientVpnConnectionStatus(TypedDict, total=False):
    """Describes the status of a client connection."""

    Code: Optional[ClientVpnConnectionStatusCode]
    Message: Optional[String]


class ClientVpnConnection(TypedDict, total=False):
    """Describes a client connection."""

    ClientVpnEndpointId: Optional[String]
    Timestamp: Optional[String]
    ConnectionId: Optional[String]
    Username: Optional[String]
    ConnectionEstablishedTime: Optional[String]
    IngressBytes: Optional[String]
    EgressBytes: Optional[String]
    IngressPackets: Optional[String]
    EgressPackets: Optional[String]
    ClientIp: Optional[String]
    CommonName: Optional[String]
    Status: Optional[ClientVpnConnectionStatus]
    ConnectionEndTime: Optional[String]
    PostureComplianceStatuses: Optional[ValueStringList]


ClientVpnConnectionSet = List[ClientVpnConnection]


class ConnectionLogResponseOptions(TypedDict, total=False):
    """Information about the client connection logging options for a Client VPN
    endpoint.
    """

    Enabled: Optional[Boolean]
    CloudwatchLogGroup: Optional[String]
    CloudwatchLogStream: Optional[String]


class ClientVpnEndpointStatus(TypedDict, total=False):
    """Describes the state of a Client VPN endpoint."""

    Code: Optional[ClientVpnEndpointStatusCode]
    Message: Optional[String]


class ClientVpnEndpoint(TypedDict, total=False):
    """Describes a Client VPN endpoint."""

    ClientVpnEndpointId: Optional[String]
    Description: Optional[String]
    Status: Optional[ClientVpnEndpointStatus]
    CreationTime: Optional[String]
    DeletionTime: Optional[String]
    DnsName: Optional[String]
    ClientCidrBlock: Optional[String]
    DnsServers: Optional[ValueStringList]
    SplitTunnel: Optional[Boolean]
    VpnProtocol: Optional[VpnProtocol]
    TransportProtocol: Optional[TransportProtocol]
    VpnPort: Optional[Integer]
    AssociatedTargetNetworks: Optional[AssociatedTargetNetworkSet]
    ServerCertificateArn: Optional[String]
    AuthenticationOptions: Optional[ClientVpnAuthenticationList]
    ConnectionLogOptions: Optional[ConnectionLogResponseOptions]
    Tags: Optional[TagList]
    SecurityGroupIds: Optional[ClientVpnSecurityGroupIdSet]
    VpcId: Optional[VpcId]
    SelfServicePortalUrl: Optional[String]
    ClientConnectOptions: Optional[ClientConnectResponseOptions]
    SessionTimeoutHours: Optional[Integer]
    ClientLoginBannerOptions: Optional[ClientLoginBannerResponseOptions]


ClientVpnEndpointIdList = List[ClientVpnEndpointId]


class ClientVpnRouteStatus(TypedDict, total=False):
    """Describes the state of a Client VPN endpoint route."""

    Code: Optional[ClientVpnRouteStatusCode]
    Message: Optional[String]


class ClientVpnRoute(TypedDict, total=False):
    """Information about a Client VPN endpoint route."""

    ClientVpnEndpointId: Optional[String]
    DestinationCidr: Optional[String]
    TargetSubnet: Optional[String]
    Type: Optional[String]
    Origin: Optional[String]
    Status: Optional[ClientVpnRouteStatus]
    Description: Optional[String]


ClientVpnRouteSet = List[ClientVpnRoute]


class CoipAddressUsage(TypedDict, total=False):
    """Describes address usage for a customer-owned address pool."""

    AllocationId: Optional[String]
    AwsAccountId: Optional[String]
    AwsService: Optional[String]
    CoIp: Optional[String]


CoipAddressUsageSet = List[CoipAddressUsage]


class CoipPool(TypedDict, total=False):
    """Describes a customer-owned address pool."""

    PoolId: Optional[CoipPoolId]
    PoolCidrs: Optional[ValueStringList]
    LocalGatewayRouteTableId: Optional[LocalGatewayRoutetableId]
    Tags: Optional[TagList]
    PoolArn: Optional[ResourceArn]


CoipPoolIdSet = List[CoipPoolId]
CoipPoolSet = List[CoipPool]


class ConfirmProductInstanceRequest(ServiceRequest):
    InstanceId: InstanceId
    ProductCode: String
    DryRun: Optional[Boolean]


class ConfirmProductInstanceResult(TypedDict, total=False):
    OwnerId: Optional[String]
    Return: Optional[Boolean]


class ConnectionLogOptions(TypedDict, total=False):
    """Describes the client connection logging options for the Client VPN
    endpoint.
    """

    Enabled: Optional[Boolean]
    CloudwatchLogGroup: Optional[String]
    CloudwatchLogStream: Optional[String]


class ConnectionNotification(TypedDict, total=False):
    """Describes a connection notification for a VPC endpoint or VPC endpoint
    service.
    """

    ConnectionNotificationId: Optional[String]
    ServiceId: Optional[String]
    VpcEndpointId: Optional[String]
    ConnectionNotificationType: Optional[ConnectionNotificationType]
    ConnectionNotificationArn: Optional[String]
    ConnectionEvents: Optional[ValueStringList]
    ConnectionNotificationState: Optional[ConnectionNotificationState]


ConnectionNotificationIdsList = List[ConnectionNotificationId]
ConnectionNotificationSet = List[ConnectionNotification]
ConversionIdStringList = List[ConversionTaskId]


class DiskImageVolumeDescription(TypedDict, total=False):
    """Describes a disk image volume."""

    Id: Optional[String]
    Size: Optional[Long]


class DiskImageDescription(TypedDict, total=False):
    """Describes a disk image."""

    Checksum: Optional[String]
    Format: Optional[DiskImageFormat]
    ImportManifestUrl: Optional[String]
    Size: Optional[Long]


class ImportVolumeTaskDetails(TypedDict, total=False):
    """Describes an import volume task."""

    AvailabilityZone: Optional[String]
    BytesConverted: Optional[Long]
    Description: Optional[String]
    Image: Optional[DiskImageDescription]
    Volume: Optional[DiskImageVolumeDescription]


class ImportInstanceVolumeDetailItem(TypedDict, total=False):
    """Describes an import volume task."""

    AvailabilityZone: Optional[String]
    BytesConverted: Optional[Long]
    Description: Optional[String]
    Image: Optional[DiskImageDescription]
    Status: Optional[String]
    StatusMessage: Optional[String]
    Volume: Optional[DiskImageVolumeDescription]


ImportInstanceVolumeDetailSet = List[ImportInstanceVolumeDetailItem]


class ImportInstanceTaskDetails(TypedDict, total=False):
    """Describes an import instance task."""

    Description: Optional[String]
    InstanceId: Optional[String]
    Platform: Optional[PlatformValues]
    Volumes: Optional[ImportInstanceVolumeDetailSet]


class ConversionTask(TypedDict, total=False):
    """Describes a conversion task."""

    ConversionTaskId: Optional[String]
    ExpirationTime: Optional[String]
    ImportInstance: Optional[ImportInstanceTaskDetails]
    ImportVolume: Optional[ImportVolumeTaskDetails]
    State: Optional[ConversionTaskState]
    StatusMessage: Optional[String]
    Tags: Optional[TagList]


class CopyFpgaImageRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    SourceFpgaImageId: String
    Description: Optional[String]
    Name: Optional[String]
    SourceRegion: String
    ClientToken: Optional[String]


class CopyFpgaImageResult(TypedDict, total=False):
    FpgaImageId: Optional[String]


class CopyImageRequest(ServiceRequest):
    """Contains the parameters for CopyImage."""

    ClientToken: Optional[String]
    Description: Optional[String]
    Encrypted: Optional[Boolean]
    KmsKeyId: Optional[KmsKeyId]
    Name: String
    SourceImageId: String
    SourceRegion: String
    DestinationOutpostArn: Optional[String]
    DryRun: Optional[Boolean]


class CopyImageResult(TypedDict, total=False):
    """Contains the output of CopyImage."""

    ImageId: Optional[String]


class CopySnapshotRequest(ServiceRequest):
    Description: Optional[String]
    DestinationOutpostArn: Optional[String]
    DestinationRegion: Optional[String]
    Encrypted: Optional[Boolean]
    KmsKeyId: Optional[KmsKeyId]
    PresignedUrl: Optional[String]
    SourceRegion: String
    SourceSnapshotId: String
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class CopySnapshotResult(TypedDict, total=False):
    SnapshotId: Optional[String]
    Tags: Optional[TagList]


CoreCountList = List[CoreCount]
CpuManufacturerSet = List[CpuManufacturer]


class CpuOptions(TypedDict, total=False):
    """The CPU options for the instance."""

    CoreCount: Optional[Integer]
    ThreadsPerCore: Optional[Integer]


class CpuOptionsRequest(TypedDict, total=False):
    """The CPU options for the instance. Both the core count and threads per
    core must be specified in the request.
    """

    CoreCount: Optional[Integer]
    ThreadsPerCore: Optional[Integer]


class ReservationFleetInstanceSpecification(TypedDict, total=False):
    """Information about an instance type to use in a Capacity Reservation
    Fleet.
    """

    InstanceType: Optional[InstanceType]
    InstancePlatform: Optional[CapacityReservationInstancePlatform]
    Weight: Optional[DoubleWithConstraints]
    AvailabilityZone: Optional[String]
    AvailabilityZoneId: Optional[String]
    EbsOptimized: Optional[Boolean]
    Priority: Optional[IntegerWithConstraints]


ReservationFleetInstanceSpecificationList = List[ReservationFleetInstanceSpecification]


class CreateCapacityReservationFleetRequest(ServiceRequest):
    AllocationStrategy: Optional[String]
    ClientToken: Optional[String]
    InstanceTypeSpecifications: ReservationFleetInstanceSpecificationList
    Tenancy: Optional[FleetCapacityReservationTenancy]
    TotalTargetCapacity: Integer
    EndDate: Optional[MillisecondDateTime]
    InstanceMatchCriteria: Optional[FleetInstanceMatchCriteria]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class CreateCapacityReservationFleetResult(TypedDict, total=False):
    CapacityReservationFleetId: Optional[CapacityReservationFleetId]
    State: Optional[CapacityReservationFleetState]
    TotalTargetCapacity: Optional[Integer]
    TotalFulfilledCapacity: Optional[Double]
    InstanceMatchCriteria: Optional[FleetInstanceMatchCriteria]
    AllocationStrategy: Optional[String]
    CreateTime: Optional[MillisecondDateTime]
    EndDate: Optional[MillisecondDateTime]
    Tenancy: Optional[FleetCapacityReservationTenancy]
    FleetCapacityReservations: Optional[FleetCapacityReservationSet]
    Tags: Optional[TagList]


class CreateCapacityReservationRequest(ServiceRequest):
    ClientToken: Optional[String]
    InstanceType: String
    InstancePlatform: CapacityReservationInstancePlatform
    AvailabilityZone: Optional[String]
    AvailabilityZoneId: Optional[String]
    Tenancy: Optional[CapacityReservationTenancy]
    InstanceCount: Integer
    EbsOptimized: Optional[Boolean]
    EphemeralStorage: Optional[Boolean]
    EndDate: Optional[DateTime]
    EndDateType: Optional[EndDateType]
    InstanceMatchCriteria: Optional[InstanceMatchCriteria]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]
    OutpostArn: Optional[OutpostArn]
    PlacementGroupArn: Optional[PlacementGroupArn]


class CreateCapacityReservationResult(TypedDict, total=False):
    CapacityReservation: Optional[CapacityReservation]


class CreateCarrierGatewayRequest(ServiceRequest):
    VpcId: VpcId
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]


class CreateCarrierGatewayResult(TypedDict, total=False):
    CarrierGateway: Optional[CarrierGateway]


class CreateClientVpnEndpointRequest(ServiceRequest):
    ClientCidrBlock: String
    ServerCertificateArn: String
    AuthenticationOptions: ClientVpnAuthenticationRequestList
    ConnectionLogOptions: ConnectionLogOptions
    DnsServers: Optional[ValueStringList]
    TransportProtocol: Optional[TransportProtocol]
    VpnPort: Optional[Integer]
    Description: Optional[String]
    SplitTunnel: Optional[Boolean]
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]
    SecurityGroupIds: Optional[ClientVpnSecurityGroupIdSet]
    VpcId: Optional[VpcId]
    SelfServicePortal: Optional[SelfServicePortal]
    ClientConnectOptions: Optional[ClientConnectOptions]
    SessionTimeoutHours: Optional[Integer]
    ClientLoginBannerOptions: Optional[ClientLoginBannerOptions]


class CreateClientVpnEndpointResult(TypedDict, total=False):
    ClientVpnEndpointId: Optional[String]
    Status: Optional[ClientVpnEndpointStatus]
    DnsName: Optional[String]


class CreateClientVpnRouteRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    DestinationCidrBlock: String
    TargetVpcSubnetId: SubnetId
    Description: Optional[String]
    ClientToken: Optional[String]
    DryRun: Optional[Boolean]


class CreateClientVpnRouteResult(TypedDict, total=False):
    Status: Optional[ClientVpnRouteStatus]


class CreateCustomerGatewayRequest(ServiceRequest):
    """Contains the parameters for CreateCustomerGateway."""

    BgpAsn: Integer
    PublicIp: Optional[String]
    CertificateArn: Optional[String]
    Type: GatewayType
    TagSpecifications: Optional[TagSpecificationList]
    DeviceName: Optional[String]
    DryRun: Optional[Boolean]


class CustomerGateway(TypedDict, total=False):
    """Describes a customer gateway."""

    BgpAsn: Optional[String]
    CustomerGatewayId: Optional[String]
    IpAddress: Optional[String]
    CertificateArn: Optional[String]
    State: Optional[String]
    Type: Optional[String]
    DeviceName: Optional[String]
    Tags: Optional[TagList]


class CreateCustomerGatewayResult(TypedDict, total=False):
    """Contains the output of CreateCustomerGateway."""

    CustomerGateway: Optional[CustomerGateway]


class CreateDefaultSubnetRequest(ServiceRequest):
    AvailabilityZone: String
    DryRun: Optional[Boolean]
    Ipv6Native: Optional[Boolean]


class PrivateDnsNameOptionsOnLaunch(TypedDict, total=False):
    """Describes the options for instance hostnames."""

    HostnameType: Optional[HostnameType]
    EnableResourceNameDnsARecord: Optional[Boolean]
    EnableResourceNameDnsAAAARecord: Optional[Boolean]


SubnetIpv6CidrBlockAssociationSet = List[SubnetIpv6CidrBlockAssociation]


class Subnet(TypedDict, total=False):
    """Describes a subnet."""

    AvailabilityZone: Optional[String]
    AvailabilityZoneId: Optional[String]
    AvailableIpAddressCount: Optional[Integer]
    CidrBlock: Optional[String]
    DefaultForAz: Optional[Boolean]
    EnableLniAtDeviceIndex: Optional[Integer]
    MapPublicIpOnLaunch: Optional[Boolean]
    MapCustomerOwnedIpOnLaunch: Optional[Boolean]
    CustomerOwnedIpv4Pool: Optional[CoipPoolId]
    State: Optional[SubnetState]
    SubnetId: Optional[String]
    VpcId: Optional[String]
    OwnerId: Optional[String]
    AssignIpv6AddressOnCreation: Optional[Boolean]
    Ipv6CidrBlockAssociationSet: Optional[SubnetIpv6CidrBlockAssociationSet]
    Tags: Optional[TagList]
    SubnetArn: Optional[String]
    OutpostArn: Optional[String]
    EnableDns64: Optional[Boolean]
    Ipv6Native: Optional[Boolean]
    PrivateDnsNameOptionsOnLaunch: Optional[PrivateDnsNameOptionsOnLaunch]


class CreateDefaultSubnetResult(TypedDict, total=False):
    Subnet: Optional[Subnet]


class CreateDefaultVpcRequest(ServiceRequest):
    DryRun: Optional[Boolean]


VpcCidrBlockAssociationSet = List[VpcCidrBlockAssociation]
VpcIpv6CidrBlockAssociationSet = List[VpcIpv6CidrBlockAssociation]


class Vpc(TypedDict, total=False):
    """Describes a VPC."""

    CidrBlock: Optional[String]
    DhcpOptionsId: Optional[String]
    State: Optional[VpcState]
    VpcId: Optional[String]
    OwnerId: Optional[String]
    InstanceTenancy: Optional[Tenancy]
    Ipv6CidrBlockAssociationSet: Optional[VpcIpv6CidrBlockAssociationSet]
    CidrBlockAssociationSet: Optional[VpcCidrBlockAssociationSet]
    IsDefault: Optional[Boolean]
    Tags: Optional[TagList]


class CreateDefaultVpcResult(TypedDict, total=False):
    Vpc: Optional[Vpc]


class NewDhcpConfiguration(TypedDict, total=False):
    Key: Optional[String]
    Values: Optional[ValueStringList]


NewDhcpConfigurationList = List[NewDhcpConfiguration]


class CreateDhcpOptionsRequest(ServiceRequest):
    DhcpConfigurations: NewDhcpConfigurationList
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


DhcpConfigurationValueList = List[AttributeValue]


class DhcpConfiguration(TypedDict, total=False):
    """Describes a DHCP configuration option."""

    Key: Optional[String]
    Values: Optional[DhcpConfigurationValueList]


DhcpConfigurationList = List[DhcpConfiguration]


class DhcpOptions(TypedDict, total=False):
    """Describes a set of DHCP options."""

    DhcpConfigurations: Optional[DhcpConfigurationList]
    DhcpOptionsId: Optional[String]
    OwnerId: Optional[String]
    Tags: Optional[TagList]


class CreateDhcpOptionsResult(TypedDict, total=False):
    DhcpOptions: Optional[DhcpOptions]


class CreateEgressOnlyInternetGatewayRequest(ServiceRequest):
    ClientToken: Optional[String]
    DryRun: Optional[Boolean]
    VpcId: VpcId
    TagSpecifications: Optional[TagSpecificationList]


class InternetGatewayAttachment(TypedDict, total=False):
    """Describes the attachment of a VPC to an internet gateway or an
    egress-only internet gateway.
    """

    State: Optional[AttachmentStatus]
    VpcId: Optional[String]


InternetGatewayAttachmentList = List[InternetGatewayAttachment]


class EgressOnlyInternetGateway(TypedDict, total=False):
    """Describes an egress-only internet gateway."""

    Attachments: Optional[InternetGatewayAttachmentList]
    EgressOnlyInternetGatewayId: Optional[EgressOnlyInternetGatewayId]
    Tags: Optional[TagList]


class CreateEgressOnlyInternetGatewayResult(TypedDict, total=False):
    ClientToken: Optional[String]
    EgressOnlyInternetGateway: Optional[EgressOnlyInternetGateway]


class TotalLocalStorageGB(TypedDict, total=False):
    """The minimum and maximum amount of total local storage, in GB."""

    Min: Optional[Double]
    Max: Optional[Double]


LocalStorageTypeSet = List[LocalStorageType]


class NetworkInterfaceCount(TypedDict, total=False):
    """The minimum and maximum number of network interfaces."""

    Min: Optional[Integer]
    Max: Optional[Integer]


InstanceGenerationSet = List[InstanceGeneration]
ExcludedInstanceTypeSet = List[ExcludedInstanceType]


class MemoryGiBPerVCpu(TypedDict, total=False):
    """The minimum and maximum amount of memory per vCPU, in GiB."""

    Min: Optional[Double]
    Max: Optional[Double]


class MemoryMiB(TypedDict, total=False):
    """The minimum and maximum amount of memory, in MiB."""

    Min: Optional[Integer]
    Max: Optional[Integer]


class VCpuCountRange(TypedDict, total=False):
    """The minimum and maximum number of vCPUs."""

    Min: Optional[Integer]
    Max: Optional[Integer]


class InstanceRequirements(TypedDict, total=False):
    """The attributes for the instance types. When you specify instance
    attributes, Amazon EC2 will identify instance types with these
    attributes.

    When you specify multiple parameters, you get instance types that
    satisfy all of the specified parameters. If you specify multiple values
    for a parameter, you get instance types that satisfy any of the
    specified values.

    You must specify ``VCpuCount`` and ``MemoryMiB``. All other parameters
    are optional. Any unspecified optional parameter is set to its default.

    For more information, see `Attribute-based instance type selection for
    EC2
    Fleet <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html>`__,
    `Attribute-based instance type selection for Spot
    Fleet <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html>`__,
    and `Spot placement
    score <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html>`__
    in the *Amazon EC2 User Guide*.
    """

    VCpuCount: Optional[VCpuCountRange]
    MemoryMiB: Optional[MemoryMiB]
    CpuManufacturers: Optional[CpuManufacturerSet]
    MemoryGiBPerVCpu: Optional[MemoryGiBPerVCpu]
    ExcludedInstanceTypes: Optional[ExcludedInstanceTypeSet]
    InstanceGenerations: Optional[InstanceGenerationSet]
    SpotMaxPricePercentageOverLowestPrice: Optional[Integer]
    OnDemandMaxPricePercentageOverLowestPrice: Optional[Integer]
    BareMetal: Optional[BareMetal]
    BurstablePerformance: Optional[BurstablePerformance]
    RequireHibernateSupport: Optional[Boolean]
    NetworkInterfaceCount: Optional[NetworkInterfaceCount]
    LocalStorage: Optional[LocalStorage]
    LocalStorageTypes: Optional[LocalStorageTypeSet]
    TotalLocalStorageGB: Optional[TotalLocalStorageGB]
    BaselineEbsBandwidthMbps: Optional[BaselineEbsBandwidthMbps]
    AcceleratorTypes: Optional[AcceleratorTypeSet]
    AcceleratorCount: Optional[AcceleratorCount]
    AcceleratorManufacturers: Optional[AcceleratorManufacturerSet]
    AcceleratorNames: Optional[AcceleratorNameSet]
    AcceleratorTotalMemoryMiB: Optional[AcceleratorTotalMemoryMiB]


class PlacementResponse(TypedDict, total=False):
    """Describes the placement of an instance."""

    GroupName: Optional[PlacementGroupName]


class FleetLaunchTemplateOverrides(TypedDict, total=False):
    """Describes overrides for a launch template."""

    InstanceType: Optional[InstanceType]
    MaxPrice: Optional[String]
    SubnetId: Optional[String]
    AvailabilityZone: Optional[String]
    WeightedCapacity: Optional[Double]
    Priority: Optional[Double]
    Placement: Optional[PlacementResponse]
    InstanceRequirements: Optional[InstanceRequirements]


class FleetLaunchTemplateSpecification(TypedDict, total=False):
    """Describes the Amazon EC2 launch template and the launch template version
    that can be used by a Spot Fleet request to configure Amazon EC2
    instances. For information about launch templates, see `Launching an
    instance from a launch
    template <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html>`__
    in the *Amazon EC2 User Guide for Linux Instances*.
    """

    LaunchTemplateId: Optional[String]
    LaunchTemplateName: Optional[LaunchTemplateName]
    Version: Optional[String]


class LaunchTemplateAndOverridesResponse(TypedDict, total=False):
    """Describes a launch template and overrides."""

    LaunchTemplateSpecification: Optional[FleetLaunchTemplateSpecification]
    Overrides: Optional[FleetLaunchTemplateOverrides]


class CreateFleetError(TypedDict, total=False):
    """Describes the instances that could not be launched by the fleet."""

    LaunchTemplateAndOverrides: Optional[LaunchTemplateAndOverridesResponse]
    Lifecycle: Optional[InstanceLifecycle]
    ErrorCode: Optional[String]
    ErrorMessage: Optional[String]


CreateFleetErrorsSet = List[CreateFleetError]
InstanceIdsSet = List[InstanceId]


class CreateFleetInstance(TypedDict, total=False):
    """Describes the instances that were launched by the fleet."""

    LaunchTemplateAndOverrides: Optional[LaunchTemplateAndOverridesResponse]
    Lifecycle: Optional[InstanceLifecycle]
    InstanceIds: Optional[InstanceIdsSet]
    InstanceType: Optional[InstanceType]
    Platform: Optional[PlatformValues]


CreateFleetInstancesSet = List[CreateFleetInstance]


class TargetCapacitySpecificationRequest(TypedDict, total=False):
    """The number of units to request. You can choose to set the target
    capacity as the number of instances. Or you can set the target capacity
    to a performance characteristic that is important to your application
    workload, such as vCPUs, memory, or I/O. If the request type is
    ``maintain``, you can specify a target capacity of 0 and add capacity
    later.

    You can use the On-Demand Instance ``MaxTotalPrice`` parameter, the Spot
    Instance ``MaxTotalPrice`` parameter, or both parameters to ensure that
    your fleet cost does not exceed your budget. If you set a maximum price
    per hour for the On-Demand Instances and Spot Instances in your request,
    EC2 Fleet will launch instances until it reaches the maximum amount that
    you're willing to pay. When the maximum amount you're willing to pay is
    reached, the fleet stops launching instances even if it hasn’t met the
    target capacity. The ``MaxTotalPrice`` parameters are located in
    `OnDemandOptionsRequest <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_OnDemandOptionsRequest>`__
    and
    `SpotOptionsRequest <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotOptionsRequest>`__.
    """

    TotalTargetCapacity: Integer
    OnDemandTargetCapacity: Optional[Integer]
    SpotTargetCapacity: Optional[Integer]
    DefaultTargetCapacityType: Optional[DefaultTargetCapacityType]
    TargetCapacityUnitType: Optional[TargetCapacityUnitType]


class TotalLocalStorageGBRequest(TypedDict, total=False):
    """The minimum and maximum amount of total local storage, in GB."""

    Min: Optional[Double]
    Max: Optional[Double]


class NetworkInterfaceCountRequest(TypedDict, total=False):
    """The minimum and maximum number of network interfaces."""

    Min: Optional[Integer]
    Max: Optional[Integer]


class MemoryGiBPerVCpuRequest(TypedDict, total=False):
    """The minimum and maximum amount of memory per vCPU, in GiB."""

    Min: Optional[Double]
    Max: Optional[Double]


class MemoryMiBRequest(TypedDict, total=False):
    """The minimum and maximum amount of memory, in MiB."""

    Min: Integer
    Max: Optional[Integer]


class VCpuCountRangeRequest(TypedDict, total=False):
    """The minimum and maximum number of vCPUs."""

    Min: Integer
    Max: Optional[Integer]


class InstanceRequirementsRequest(TypedDict, total=False):
    """The attributes for the instance types. When you specify instance
    attributes, Amazon EC2 will identify instance types with these
    attributes.

    When you specify multiple parameters, you get instance types that
    satisfy all of the specified parameters. If you specify multiple values
    for a parameter, you get instance types that satisfy any of the
    specified values.

    You must specify ``VCpuCount`` and ``MemoryMiB``. All other parameters
    are optional. Any unspecified optional parameter is set to its default.

    For more information, see `Attribute-based instance type selection for
    EC2
    Fleet <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html>`__,
    `Attribute-based instance type selection for Spot
    Fleet <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html>`__,
    and `Spot placement
    score <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html>`__
    in the *Amazon EC2 User Guide*.
    """

    VCpuCount: VCpuCountRangeRequest
    MemoryMiB: MemoryMiBRequest
    CpuManufacturers: Optional[CpuManufacturerSet]
    MemoryGiBPerVCpu: Optional[MemoryGiBPerVCpuRequest]
    ExcludedInstanceTypes: Optional[ExcludedInstanceTypeSet]
    InstanceGenerations: Optional[InstanceGenerationSet]
    SpotMaxPricePercentageOverLowestPrice: Optional[Integer]
    OnDemandMaxPricePercentageOverLowestPrice: Optional[Integer]
    BareMetal: Optional[BareMetal]
    BurstablePerformance: Optional[BurstablePerformance]
    RequireHibernateSupport: Optional[Boolean]
    NetworkInterfaceCount: Optional[NetworkInterfaceCountRequest]
    LocalStorage: Optional[LocalStorage]
    LocalStorageTypes: Optional[LocalStorageTypeSet]
    TotalLocalStorageGB: Optional[TotalLocalStorageGBRequest]
    BaselineEbsBandwidthMbps: Optional[BaselineEbsBandwidthMbpsRequest]
    AcceleratorTypes: Optional[AcceleratorTypeSet]
    AcceleratorCount: Optional[AcceleratorCountRequest]
    AcceleratorManufacturers: Optional[AcceleratorManufacturerSet]
    AcceleratorNames: Optional[AcceleratorNameSet]
    AcceleratorTotalMemoryMiB: Optional[AcceleratorTotalMemoryMiBRequest]


class Placement(TypedDict, total=False):
    """Describes the placement of an instance."""

    AvailabilityZone: Optional[String]
    Affinity: Optional[String]
    GroupName: Optional[PlacementGroupName]
    PartitionNumber: Optional[Integer]
    HostId: Optional[String]
    Tenancy: Optional[Tenancy]
    SpreadDomain: Optional[String]
    HostResourceGroupArn: Optional[String]


class FleetLaunchTemplateOverridesRequest(TypedDict, total=False):
    """Describes overrides for a launch template."""

    InstanceType: Optional[InstanceType]
    MaxPrice: Optional[String]
    SubnetId: Optional[SubnetId]
    AvailabilityZone: Optional[String]
    WeightedCapacity: Optional[Double]
    Priority: Optional[Double]
    Placement: Optional[Placement]
    InstanceRequirements: Optional[InstanceRequirementsRequest]


FleetLaunchTemplateOverridesListRequest = List[FleetLaunchTemplateOverridesRequest]


class FleetLaunchTemplateSpecificationRequest(TypedDict, total=False):
    """Describes the Amazon EC2 launch template and the launch template version
    that can be used by an EC2 Fleet to configure Amazon EC2 instances. For
    information about launch templates, see `Launching an instance from a
    launch
    template <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html>`__
    in the *Amazon EC2 User Guide*.
    """

    LaunchTemplateId: Optional[LaunchTemplateId]
    LaunchTemplateName: Optional[LaunchTemplateName]
    Version: Optional[String]


class FleetLaunchTemplateConfigRequest(TypedDict, total=False):
    """Describes a launch template and overrides."""

    LaunchTemplateSpecification: Optional[FleetLaunchTemplateSpecificationRequest]
    Overrides: Optional[FleetLaunchTemplateOverridesListRequest]


FleetLaunchTemplateConfigListRequest = List[FleetLaunchTemplateConfigRequest]


class OnDemandOptionsRequest(TypedDict, total=False):
    """Describes the configuration of On-Demand Instances in an EC2 Fleet."""

    AllocationStrategy: Optional[FleetOnDemandAllocationStrategy]
    CapacityReservationOptions: Optional[CapacityReservationOptionsRequest]
    SingleInstanceType: Optional[Boolean]
    SingleAvailabilityZone: Optional[Boolean]
    MinTargetCapacity: Optional[Integer]
    MaxTotalPrice: Optional[String]


class FleetSpotCapacityRebalanceRequest(TypedDict, total=False):
    """The Spot Instance replacement strategy to use when Amazon EC2 emits a
    rebalance notification signal that your Spot Instance is at an elevated
    risk of being interrupted. For more information, see `Capacity
    rebalancing <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-capacity-rebalance.html>`__
    in the *Amazon EC2 User Guide*.
    """

    ReplacementStrategy: Optional[FleetReplacementStrategy]
    TerminationDelay: Optional[Integer]


class FleetSpotMaintenanceStrategiesRequest(TypedDict, total=False):
    """The strategies for managing your Spot Instances that are at an elevated
    risk of being interrupted.
    """

    CapacityRebalance: Optional[FleetSpotCapacityRebalanceRequest]


class SpotOptionsRequest(TypedDict, total=False):
    """Describes the configuration of Spot Instances in an EC2 Fleet request."""

    AllocationStrategy: Optional[SpotAllocationStrategy]
    MaintenanceStrategies: Optional[FleetSpotMaintenanceStrategiesRequest]
    InstanceInterruptionBehavior: Optional[SpotInstanceInterruptionBehavior]
    InstancePoolsToUseCount: Optional[Integer]
    SingleInstanceType: Optional[Boolean]
    SingleAvailabilityZone: Optional[Boolean]
    MinTargetCapacity: Optional[Integer]
    MaxTotalPrice: Optional[String]


class CreateFleetRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]
    SpotOptions: Optional[SpotOptionsRequest]
    OnDemandOptions: Optional[OnDemandOptionsRequest]
    ExcessCapacityTerminationPolicy: Optional[FleetExcessCapacityTerminationPolicy]
    LaunchTemplateConfigs: FleetLaunchTemplateConfigListRequest
    TargetCapacitySpecification: TargetCapacitySpecificationRequest
    TerminateInstancesWithExpiration: Optional[Boolean]
    Type: Optional[FleetType]
    ValidFrom: Optional[DateTime]
    ValidUntil: Optional[DateTime]
    ReplaceUnhealthyInstances: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]
    Context: Optional[String]


class CreateFleetResult(TypedDict, total=False):
    FleetId: Optional[FleetId]
    Errors: Optional[CreateFleetErrorsSet]
    Instances: Optional[CreateFleetInstancesSet]


class DestinationOptionsRequest(TypedDict, total=False):
    """Describes the destination options for a flow log."""

    FileFormat: Optional[DestinationFileFormat]
    HiveCompatiblePartitions: Optional[Boolean]
    PerHourPartition: Optional[Boolean]


FlowLogResourceIds = List[FlowLogResourceId]


class CreateFlowLogsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]
    DeliverLogsPermissionArn: Optional[String]
    LogGroupName: Optional[String]
    ResourceIds: FlowLogResourceIds
    ResourceType: FlowLogsResourceType
    TrafficType: TrafficType
    LogDestinationType: Optional[LogDestinationType]
    LogDestination: Optional[String]
    LogFormat: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]
    MaxAggregationInterval: Optional[Integer]
    DestinationOptions: Optional[DestinationOptionsRequest]


class CreateFlowLogsResult(TypedDict, total=False):
    ClientToken: Optional[String]
    FlowLogIds: Optional[ValueStringList]
    Unsuccessful: Optional[UnsuccessfulItemSet]


class StorageLocation(TypedDict, total=False):
    """Describes a storage location in Amazon S3."""

    Bucket: Optional[String]
    Key: Optional[String]


class CreateFpgaImageRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InputStorageLocation: StorageLocation
    LogsStorageLocation: Optional[StorageLocation]
    Description: Optional[String]
    Name: Optional[String]
    ClientToken: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]


class CreateFpgaImageResult(TypedDict, total=False):
    FpgaImageId: Optional[String]
    FpgaImageGlobalId: Optional[String]


class CreateImageRequest(ServiceRequest):
    BlockDeviceMappings: Optional[BlockDeviceMappingRequestList]
    Description: Optional[String]
    DryRun: Optional[Boolean]
    InstanceId: InstanceId
    Name: String
    NoReboot: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]


class CreateImageResult(TypedDict, total=False):
    ImageId: Optional[String]


class InstanceEventWindowTimeRangeRequest(TypedDict, total=False):
    """The start day and time and the end day and time of the time range, in
    UTC.
    """

    StartWeekDay: Optional[WeekDay]
    StartHour: Optional[Hour]
    EndWeekDay: Optional[WeekDay]
    EndHour: Optional[Hour]


InstanceEventWindowTimeRangeRequestSet = List[InstanceEventWindowTimeRangeRequest]


class CreateInstanceEventWindowRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Name: Optional[String]
    TimeRanges: Optional[InstanceEventWindowTimeRangeRequestSet]
    CronExpression: Optional[InstanceEventWindowCronExpression]
    TagSpecifications: Optional[TagSpecificationList]


class CreateInstanceEventWindowResult(TypedDict, total=False):
    InstanceEventWindow: Optional[InstanceEventWindow]


class ExportToS3TaskSpecification(TypedDict, total=False):
    """Describes an export instance task."""

    ContainerFormat: Optional[ContainerFormat]
    DiskImageFormat: Optional[DiskImageFormat]
    S3Bucket: Optional[String]
    S3Prefix: Optional[String]


class CreateInstanceExportTaskRequest(ServiceRequest):
    Description: Optional[String]
    ExportToS3Task: ExportToS3TaskSpecification
    InstanceId: InstanceId
    TargetEnvironment: ExportEnvironment
    TagSpecifications: Optional[TagSpecificationList]


class InstanceExportDetails(TypedDict, total=False):
    """Describes an instance to export."""

    InstanceId: Optional[String]
    TargetEnvironment: Optional[ExportEnvironment]


class ExportToS3Task(TypedDict, total=False):
    """Describes the format and location for the export task."""

    ContainerFormat: Optional[ContainerFormat]
    DiskImageFormat: Optional[DiskImageFormat]
    S3Bucket: Optional[String]
    S3Key: Optional[String]


class ExportTask(TypedDict, total=False):
    """Describes an export instance task."""

    Description: Optional[String]
    ExportTaskId: Optional[String]
    ExportToS3Task: Optional[ExportToS3Task]
    InstanceExportDetails: Optional[InstanceExportDetails]
    State: Optional[ExportTaskState]
    StatusMessage: Optional[String]
    Tags: Optional[TagList]


class CreateInstanceExportTaskResult(TypedDict, total=False):
    ExportTask: Optional[ExportTask]


class CreateInternetGatewayRequest(ServiceRequest):
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class InternetGateway(TypedDict, total=False):
    """Describes an internet gateway."""

    Attachments: Optional[InternetGatewayAttachmentList]
    InternetGatewayId: Optional[String]
    OwnerId: Optional[String]
    Tags: Optional[TagList]


class CreateInternetGatewayResult(TypedDict, total=False):
    InternetGateway: Optional[InternetGateway]


class RequestIpamResourceTag(TypedDict, total=False):
    """A tag on an IPAM resource."""

    Key: Optional[String]
    Value: Optional[String]


RequestIpamResourceTagList = List[RequestIpamResourceTag]


class CreateIpamPoolRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamScopeId: IpamScopeId
    Locale: Optional[String]
    SourceIpamPoolId: Optional[IpamPoolId]
    Description: Optional[String]
    AddressFamily: Optional[AddressFamily]
    AutoImport: Optional[Boolean]
    PubliclyAdvertisable: Optional[Boolean]
    AllocationMinNetmaskLength: Optional[IpamNetmaskLength]
    AllocationMaxNetmaskLength: Optional[IpamNetmaskLength]
    AllocationDefaultNetmaskLength: Optional[IpamNetmaskLength]
    AllocationResourceTags: Optional[RequestIpamResourceTagList]
    TagSpecifications: Optional[TagSpecificationList]
    ClientToken: Optional[String]
    AwsService: Optional[IpamPoolAwsService]


class IpamResourceTag(TypedDict, total=False):
    """The key/value combination of a tag assigned to the resource. Use the tag
    key in the filter name and the tag value as the filter value. For
    example, to find all resources that have a tag with the key ``Owner``
    and the value ``TeamA``, specify ``tag:Owner`` for the filter name and
    ``TeamA`` for the filter value.
    """

    Key: Optional[String]
    Value: Optional[String]


IpamResourceTagList = List[IpamResourceTag]


class IpamPool(TypedDict, total=False):
    """In IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools
    enable you to organize your IP addresses according to your routing and
    security needs. For example, if you have separate routing and security
    needs for development and production applications, you can create a pool
    for each.
    """

    OwnerId: Optional[String]
    IpamPoolId: Optional[IpamPoolId]
    SourceIpamPoolId: Optional[IpamPoolId]
    IpamPoolArn: Optional[ResourceArn]
    IpamScopeArn: Optional[ResourceArn]
    IpamScopeType: Optional[IpamScopeType]
    IpamArn: Optional[ResourceArn]
    IpamRegion: Optional[String]
    Locale: Optional[String]
    PoolDepth: Optional[Integer]
    State: Optional[IpamPoolState]
    StateMessage: Optional[String]
    Description: Optional[String]
    AutoImport: Optional[Boolean]
    PubliclyAdvertisable: Optional[Boolean]
    AddressFamily: Optional[AddressFamily]
    AllocationMinNetmaskLength: Optional[IpamNetmaskLength]
    AllocationMaxNetmaskLength: Optional[IpamNetmaskLength]
    AllocationDefaultNetmaskLength: Optional[IpamNetmaskLength]
    AllocationResourceTags: Optional[IpamResourceTagList]
    Tags: Optional[TagList]
    AwsService: Optional[IpamPoolAwsService]


class CreateIpamPoolResult(TypedDict, total=False):
    IpamPool: Optional[IpamPool]


class CreateIpamRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Description: Optional[String]
    OperatingRegions: Optional[AddIpamOperatingRegionSet]
    TagSpecifications: Optional[TagSpecificationList]
    ClientToken: Optional[String]


class IpamOperatingRegion(TypedDict, total=False):
    """The operating Regions for an IPAM. Operating Regions are Amazon Web
    Services Regions where the IPAM is allowed to manage IP address CIDRs.
    IPAM only discovers and monitors resources in the Amazon Web Services
    Regions you select as operating Regions.

    For more information about operating Regions, see `Create an
    IPAM </vpc/latest/ipam/create-ipam.html>`__ in the *Amazon VPC IPAM User
    Guide*.
    """

    RegionName: Optional[String]


IpamOperatingRegionSet = List[IpamOperatingRegion]


class Ipam(TypedDict, total=False):
    """IPAM is a VPC feature that you can use to automate your IP address
    management workflows including assigning, tracking, troubleshooting, and
    auditing IP addresses across Amazon Web Services Regions and accounts
    throughout your Amazon Web Services Organization. For more information,
    see `What is IPAM? </vpc/latest/ipam/what-is-it-ipam.html>`__ in the
    *Amazon VPC IPAM User Guide*.
    """

    OwnerId: Optional[String]
    IpamId: Optional[IpamId]
    IpamArn: Optional[ResourceArn]
    IpamRegion: Optional[String]
    PublicDefaultScopeId: Optional[IpamScopeId]
    PrivateDefaultScopeId: Optional[IpamScopeId]
    ScopeCount: Optional[Integer]
    Description: Optional[String]
    OperatingRegions: Optional[IpamOperatingRegionSet]
    State: Optional[IpamState]
    Tags: Optional[TagList]


class CreateIpamResult(TypedDict, total=False):
    Ipam: Optional[Ipam]


class CreateIpamScopeRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamId: IpamId
    Description: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]
    ClientToken: Optional[String]


class IpamScope(TypedDict, total=False):
    """In IPAM, a scope is the highest-level container within IPAM. An IPAM
    contains two default scopes. Each scope represents the IP space for a
    single network. The private scope is intended for all private IP address
    space. The public scope is intended for all public IP address space.
    Scopes enable you to reuse IP addresses across multiple unconnected
    networks without causing IP address overlap or conflict.

    For more information, see `How IPAM
    works </vpc/latest/ipam/how-it-works-ipam.html>`__ in the *Amazon VPC
    IPAM User Guide*
    """

    OwnerId: Optional[String]
    IpamScopeId: Optional[IpamScopeId]
    IpamScopeArn: Optional[ResourceArn]
    IpamArn: Optional[ResourceArn]
    IpamRegion: Optional[String]
    IpamScopeType: Optional[IpamScopeType]
    IsDefault: Optional[Boolean]
    Description: Optional[String]
    PoolCount: Optional[Integer]
    State: Optional[IpamScopeState]
    Tags: Optional[TagList]


class CreateIpamScopeResult(TypedDict, total=False):
    IpamScope: Optional[IpamScope]


class CreateKeyPairRequest(ServiceRequest):
    KeyName: String
    DryRun: Optional[Boolean]
    KeyType: Optional[KeyType]
    TagSpecifications: Optional[TagSpecificationList]


class LaunchTemplatePrivateDnsNameOptionsRequest(TypedDict, total=False):
    """Describes the options for instance hostnames."""

    HostnameType: Optional[HostnameType]
    EnableResourceNameDnsARecord: Optional[Boolean]
    EnableResourceNameDnsAAAARecord: Optional[Boolean]


class LaunchTemplateEnclaveOptionsRequest(TypedDict, total=False):
    """Indicates whether the instance is enabled for Amazon Web Services Nitro
    Enclaves. For more information, see `What is Amazon Web Services Nitro
    Enclaves? <https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html>`__
    in the *Amazon Web Services Nitro Enclaves User Guide*.
    """

    Enabled: Optional[Boolean]


class LaunchTemplateInstanceMetadataOptionsRequest(TypedDict, total=False):
    """The metadata options for the instance. For more information, see
    `Instance Metadata and User
    Data <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html>`__
    in the *Amazon Elastic Compute Cloud User Guide*.
    """

    HttpTokens: Optional[LaunchTemplateHttpTokensState]
    HttpPutResponseHopLimit: Optional[Integer]
    HttpEndpoint: Optional[LaunchTemplateInstanceMetadataEndpointState]
    HttpProtocolIpv6: Optional[LaunchTemplateInstanceMetadataProtocolIpv6]
    InstanceMetadataTags: Optional[LaunchTemplateInstanceMetadataTagsState]


class LaunchTemplateHibernationOptionsRequest(TypedDict, total=False):
    """Indicates whether the instance is configured for hibernation. This
    parameter is valid only if the instance meets the `hibernation
    prerequisites <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites>`__.
    """

    Configured: Optional[Boolean]


class LaunchTemplateLicenseConfigurationRequest(TypedDict, total=False):
    """Describes a license configuration."""

    LicenseConfigurationArn: Optional[String]


LaunchTemplateLicenseSpecificationListRequest = List[LaunchTemplateLicenseConfigurationRequest]


class LaunchTemplateCapacityReservationSpecificationRequest(TypedDict, total=False):
    """Describes an instance's Capacity Reservation targeting option. You can
    specify only one option at a time. Use the
    ``CapacityReservationPreference`` parameter to configure the instance to
    run in On-Demand capacity or to run in any ``open`` Capacity Reservation
    that has matching attributes (instance type, platform, Availability
    Zone). Use the ``CapacityReservationTarget`` parameter to explicitly
    target a specific Capacity Reservation or a Capacity Reservation group.
    """

    CapacityReservationPreference: Optional[CapacityReservationPreference]
    CapacityReservationTarget: Optional[CapacityReservationTarget]


class LaunchTemplateCpuOptionsRequest(TypedDict, total=False):
    """The CPU options for the instance. Both the core count and threads per
    core must be specified in the request.
    """

    CoreCount: Optional[Integer]
    ThreadsPerCore: Optional[Integer]


class CreditSpecificationRequest(TypedDict, total=False):
    """The credit option for CPU usage of a T2, T3, or T3a instance."""

    CpuCredits: String


class LaunchTemplateSpotMarketOptionsRequest(TypedDict, total=False):
    """The options for Spot Instances."""

    MaxPrice: Optional[String]
    SpotInstanceType: Optional[SpotInstanceType]
    BlockDurationMinutes: Optional[Integer]
    ValidUntil: Optional[DateTime]
    InstanceInterruptionBehavior: Optional[InstanceInterruptionBehavior]


class LaunchTemplateInstanceMarketOptionsRequest(TypedDict, total=False):
    """The market (purchasing) option for the instances."""

    MarketType: Optional[MarketType]
    SpotOptions: Optional[LaunchTemplateSpotMarketOptionsRequest]


SecurityGroupStringList = List[SecurityGroupName]
SecurityGroupIdStringList = List[SecurityGroupId]


class LaunchTemplateElasticInferenceAccelerator(TypedDict, total=False):
    """Describes an elastic inference accelerator."""

    Type: String
    Count: Optional[LaunchTemplateElasticInferenceAcceleratorCount]


LaunchTemplateElasticInferenceAcceleratorList = List[LaunchTemplateElasticInferenceAccelerator]


class ElasticGpuSpecification(TypedDict, total=False):
    """A specification for an Elastic Graphics accelerator."""

    Type: String


ElasticGpuSpecificationList = List[ElasticGpuSpecification]


class LaunchTemplateTagSpecificationRequest(TypedDict, total=False):
    """The tags specification for the launch template."""

    ResourceType: Optional[ResourceType]
    Tags: Optional[TagList]


LaunchTemplateTagSpecificationRequestList = List[LaunchTemplateTagSpecificationRequest]


class LaunchTemplatePlacementRequest(TypedDict, total=False):
    """Describes the placement of an instance."""

    AvailabilityZone: Optional[String]
    Affinity: Optional[String]
    GroupName: Optional[PlacementGroupName]
    HostId: Optional[DedicatedHostId]
    Tenancy: Optional[Tenancy]
    SpreadDomain: Optional[String]
    HostResourceGroupArn: Optional[String]
    PartitionNumber: Optional[Integer]


class LaunchTemplatesMonitoringRequest(TypedDict, total=False):
    """Describes the monitoring for the instance."""

    Enabled: Optional[Boolean]


class Ipv6PrefixSpecificationRequest(TypedDict, total=False):
    """Describes the IPv4 prefix option for a network interface."""

    Ipv6Prefix: Optional[String]


Ipv6PrefixList = List[Ipv6PrefixSpecificationRequest]


class Ipv4PrefixSpecificationRequest(TypedDict, total=False):
    """Describes the IPv4 prefix option for a network interface."""

    Ipv4Prefix: Optional[String]


Ipv4PrefixList = List[Ipv4PrefixSpecificationRequest]


class PrivateIpAddressSpecification(TypedDict, total=False):
    """Describes a secondary private IPv4 address for a network interface."""

    Primary: Optional[Boolean]
    PrivateIpAddress: Optional[String]


PrivateIpAddressSpecificationList = List[PrivateIpAddressSpecification]


class InstanceIpv6AddressRequest(TypedDict, total=False):
    """Describes an IPv6 address."""

    Ipv6Address: Optional[String]


InstanceIpv6AddressListRequest = List[InstanceIpv6AddressRequest]


class LaunchTemplateInstanceNetworkInterfaceSpecificationRequest(TypedDict, total=False):
    """The parameters for a network interface."""

    AssociateCarrierIpAddress: Optional[Boolean]
    AssociatePublicIpAddress: Optional[Boolean]
    DeleteOnTermination: Optional[Boolean]
    Description: Optional[String]
    DeviceIndex: Optional[Integer]
    Groups: Optional[SecurityGroupIdStringList]
    InterfaceType: Optional[String]
    Ipv6AddressCount: Optional[Integer]
    Ipv6Addresses: Optional[InstanceIpv6AddressListRequest]
    NetworkInterfaceId: Optional[NetworkInterfaceId]
    PrivateIpAddress: Optional[String]
    PrivateIpAddresses: Optional[PrivateIpAddressSpecificationList]
    SecondaryPrivateIpAddressCount: Optional[Integer]
    SubnetId: Optional[SubnetId]
    NetworkCardIndex: Optional[Integer]
    Ipv4Prefixes: Optional[Ipv4PrefixList]
    Ipv4PrefixCount: Optional[Integer]
    Ipv6Prefixes: Optional[Ipv6PrefixList]
    Ipv6PrefixCount: Optional[Integer]


LaunchTemplateInstanceNetworkInterfaceSpecificationRequestList = List[
    LaunchTemplateInstanceNetworkInterfaceSpecificationRequest
]


class LaunchTemplateEbsBlockDeviceRequest(TypedDict, total=False):
    """The parameters for a block device for an EBS volume."""

    Encrypted: Optional[Boolean]
    DeleteOnTermination: Optional[Boolean]
    Iops: Optional[Integer]
    KmsKeyId: Optional[KmsKeyId]
    SnapshotId: Optional[SnapshotId]
    VolumeSize: Optional[Integer]
    VolumeType: Optional[VolumeType]
    Throughput: Optional[Integer]


class LaunchTemplateBlockDeviceMappingRequest(TypedDict, total=False):
    """Describes a block device mapping."""

    DeviceName: Optional[String]
    VirtualName: Optional[String]
    Ebs: Optional[LaunchTemplateEbsBlockDeviceRequest]
    NoDevice: Optional[String]


LaunchTemplateBlockDeviceMappingRequestList = List[LaunchTemplateBlockDeviceMappingRequest]


class LaunchTemplateIamInstanceProfileSpecificationRequest(TypedDict, total=False):
    """An IAM instance profile."""

    Arn: Optional[String]
    Name: Optional[String]


class RequestLaunchTemplateData(TypedDict, total=False):
    """The information to include in the launch template."""

    KernelId: Optional[KernelId]
    EbsOptimized: Optional[Boolean]
    IamInstanceProfile: Optional[LaunchTemplateIamInstanceProfileSpecificationRequest]
    BlockDeviceMappings: Optional[LaunchTemplateBlockDeviceMappingRequestList]
    NetworkInterfaces: Optional[LaunchTemplateInstanceNetworkInterfaceSpecificationRequestList]
    ImageId: Optional[ImageId]
    InstanceType: Optional[InstanceType]
    KeyName: Optional[KeyPairName]
    Monitoring: Optional[LaunchTemplatesMonitoringRequest]
    Placement: Optional[LaunchTemplatePlacementRequest]
    RamDiskId: Optional[RamdiskId]
    DisableApiTermination: Optional[Boolean]
    InstanceInitiatedShutdownBehavior: Optional[ShutdownBehavior]
    UserData: Optional[String]
    TagSpecifications: Optional[LaunchTemplateTagSpecificationRequestList]
    ElasticGpuSpecifications: Optional[ElasticGpuSpecificationList]
    ElasticInferenceAccelerators: Optional[LaunchTemplateElasticInferenceAcceleratorList]
    SecurityGroupIds: Optional[SecurityGroupIdStringList]
    SecurityGroups: Optional[SecurityGroupStringList]
    InstanceMarketOptions: Optional[LaunchTemplateInstanceMarketOptionsRequest]
    CreditSpecification: Optional[CreditSpecificationRequest]
    CpuOptions: Optional[LaunchTemplateCpuOptionsRequest]
    CapacityReservationSpecification: Optional[
        LaunchTemplateCapacityReservationSpecificationRequest
    ]
    LicenseSpecifications: Optional[LaunchTemplateLicenseSpecificationListRequest]
    HibernationOptions: Optional[LaunchTemplateHibernationOptionsRequest]
    MetadataOptions: Optional[LaunchTemplateInstanceMetadataOptionsRequest]
    EnclaveOptions: Optional[LaunchTemplateEnclaveOptionsRequest]
    InstanceRequirements: Optional[InstanceRequirementsRequest]
    PrivateDnsNameOptions: Optional[LaunchTemplatePrivateDnsNameOptionsRequest]


class CreateLaunchTemplateRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]
    LaunchTemplateName: LaunchTemplateName
    VersionDescription: Optional[VersionDescription]
    LaunchTemplateData: RequestLaunchTemplateData
    TagSpecifications: Optional[TagSpecificationList]


class ValidationError(TypedDict, total=False):
    """The error code and error message that is returned for a parameter or
    parameter combination that is not valid when a new launch template or
    new version of a launch template is created.
    """

    Code: Optional[String]
    Message: Optional[String]


ErrorSet = List[ValidationError]


class ValidationWarning(TypedDict, total=False):
    """The error codes and error messages that are returned for the parameters
    or parameter combinations that are not valid when a new launch template
    or new version of a launch template is created.
    """

    Errors: Optional[ErrorSet]


class LaunchTemplate(TypedDict, total=False):
    """Describes a launch template."""

    LaunchTemplateId: Optional[String]
    LaunchTemplateName: Optional[LaunchTemplateName]
    CreateTime: Optional[DateTime]
    CreatedBy: Optional[String]
    DefaultVersionNumber: Optional[Long]
    LatestVersionNumber: Optional[Long]
    Tags: Optional[TagList]


class CreateLaunchTemplateResult(TypedDict, total=False):
    LaunchTemplate: Optional[LaunchTemplate]
    Warning: Optional[ValidationWarning]


class CreateLaunchTemplateVersionRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]
    LaunchTemplateId: Optional[LaunchTemplateId]
    LaunchTemplateName: Optional[LaunchTemplateName]
    SourceVersion: Optional[String]
    VersionDescription: Optional[VersionDescription]
    LaunchTemplateData: RequestLaunchTemplateData


class LaunchTemplatePrivateDnsNameOptions(TypedDict, total=False):
    """Describes the options for instance hostnames."""

    HostnameType: Optional[HostnameType]
    EnableResourceNameDnsARecord: Optional[Boolean]
    EnableResourceNameDnsAAAARecord: Optional[Boolean]


class LaunchTemplateEnclaveOptions(TypedDict, total=False):
    """Indicates whether the instance is enabled for Amazon Web Services Nitro
    Enclaves.
    """

    Enabled: Optional[Boolean]


class LaunchTemplateInstanceMetadataOptions(TypedDict, total=False):
    """The metadata options for the instance. For more information, see
    `Instance Metadata and User
    Data <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html>`__
    in the *Amazon Elastic Compute Cloud User Guide*.
    """

    State: Optional[LaunchTemplateInstanceMetadataOptionsState]
    HttpTokens: Optional[LaunchTemplateHttpTokensState]
    HttpPutResponseHopLimit: Optional[Integer]
    HttpEndpoint: Optional[LaunchTemplateInstanceMetadataEndpointState]
    HttpProtocolIpv6: Optional[LaunchTemplateInstanceMetadataProtocolIpv6]
    InstanceMetadataTags: Optional[LaunchTemplateInstanceMetadataTagsState]


class LaunchTemplateHibernationOptions(TypedDict, total=False):
    """Indicates whether an instance is configured for hibernation."""

    Configured: Optional[Boolean]


class LaunchTemplateLicenseConfiguration(TypedDict, total=False):
    """Describes a license configuration."""

    LicenseConfigurationArn: Optional[String]


LaunchTemplateLicenseList = List[LaunchTemplateLicenseConfiguration]


class LaunchTemplateCapacityReservationSpecificationResponse(TypedDict, total=False):
    """Information about the Capacity Reservation targeting option."""

    CapacityReservationPreference: Optional[CapacityReservationPreference]
    CapacityReservationTarget: Optional[CapacityReservationTargetResponse]


class LaunchTemplateCpuOptions(TypedDict, total=False):
    """The CPU options for the instance."""

    CoreCount: Optional[Integer]
    ThreadsPerCore: Optional[Integer]


class CreditSpecification(TypedDict, total=False):
    """Describes the credit option for CPU usage of a T2, T3, or T3a instance."""

    CpuCredits: Optional[String]


class LaunchTemplateSpotMarketOptions(TypedDict, total=False):
    """The options for Spot Instances."""

    MaxPrice: Optional[String]
    SpotInstanceType: Optional[SpotInstanceType]
    BlockDurationMinutes: Optional[Integer]
    ValidUntil: Optional[DateTime]
    InstanceInterruptionBehavior: Optional[InstanceInterruptionBehavior]


class LaunchTemplateInstanceMarketOptions(TypedDict, total=False):
    """The market (purchasing) option for the instances."""

    MarketType: Optional[MarketType]
    SpotOptions: Optional[LaunchTemplateSpotMarketOptions]


class LaunchTemplateElasticInferenceAcceleratorResponse(TypedDict, total=False):
    """Describes an elastic inference accelerator."""

    Type: Optional[String]
    Count: Optional[Integer]


LaunchTemplateElasticInferenceAcceleratorResponseList = List[
    LaunchTemplateElasticInferenceAcceleratorResponse
]


class ElasticGpuSpecificationResponse(TypedDict, total=False):
    """Describes an elastic GPU."""

    Type: Optional[String]


ElasticGpuSpecificationResponseList = List[ElasticGpuSpecificationResponse]


class LaunchTemplateTagSpecification(TypedDict, total=False):
    """The tag specification for the launch template."""

    ResourceType: Optional[ResourceType]
    Tags: Optional[TagList]


LaunchTemplateTagSpecificationList = List[LaunchTemplateTagSpecification]


class LaunchTemplatePlacement(TypedDict, total=False):
    """Describes the placement of an instance."""

    AvailabilityZone: Optional[String]
    Affinity: Optional[String]
    GroupName: Optional[String]
    HostId: Optional[String]
    Tenancy: Optional[Tenancy]
    SpreadDomain: Optional[String]
    HostResourceGroupArn: Optional[String]
    PartitionNumber: Optional[Integer]


class LaunchTemplatesMonitoring(TypedDict, total=False):
    """Describes the monitoring for the instance."""

    Enabled: Optional[Boolean]


class Ipv6PrefixSpecificationResponse(TypedDict, total=False):
    """Information about the IPv6 delegated prefixes assigned to a network
    interface.
    """

    Ipv6Prefix: Optional[String]


Ipv6PrefixListResponse = List[Ipv6PrefixSpecificationResponse]


class Ipv4PrefixSpecificationResponse(TypedDict, total=False):
    """Information about the IPv4 delegated prefixes assigned to a network
    interface.
    """

    Ipv4Prefix: Optional[String]


Ipv4PrefixListResponse = List[Ipv4PrefixSpecificationResponse]


class InstanceIpv6Address(TypedDict, total=False):
    """Describes an IPv6 address."""

    Ipv6Address: Optional[String]


InstanceIpv6AddressList = List[InstanceIpv6Address]


class LaunchTemplateInstanceNetworkInterfaceSpecification(TypedDict, total=False):
    """Describes a network interface."""

    AssociateCarrierIpAddress: Optional[Boolean]
    AssociatePublicIpAddress: Optional[Boolean]
    DeleteOnTermination: Optional[Boolean]
    Description: Optional[String]
    DeviceIndex: Optional[Integer]
    Groups: Optional[GroupIdStringList]
    InterfaceType: Optional[String]
    Ipv6AddressCount: Optional[Integer]
    Ipv6Addresses: Optional[InstanceIpv6AddressList]
    NetworkInterfaceId: Optional[NetworkInterfaceId]
    PrivateIpAddress: Optional[String]
    PrivateIpAddresses: Optional[PrivateIpAddressSpecificationList]
    SecondaryPrivateIpAddressCount: Optional[Integer]
    SubnetId: Optional[SubnetId]
    NetworkCardIndex: Optional[Integer]
    Ipv4Prefixes: Optional[Ipv4PrefixListResponse]
    Ipv4PrefixCount: Optional[Integer]
    Ipv6Prefixes: Optional[Ipv6PrefixListResponse]
    Ipv6PrefixCount: Optional[Integer]


LaunchTemplateInstanceNetworkInterfaceSpecificationList = List[
    LaunchTemplateInstanceNetworkInterfaceSpecification
]


class LaunchTemplateEbsBlockDevice(TypedDict, total=False):
    """Describes a block device for an EBS volume."""

    Encrypted: Optional[Boolean]
    DeleteOnTermination: Optional[Boolean]
    Iops: Optional[Integer]
    KmsKeyId: Optional[KmsKeyId]
    SnapshotId: Optional[SnapshotId]
    VolumeSize: Optional[Integer]
    VolumeType: Optional[VolumeType]
    Throughput: Optional[Integer]


class LaunchTemplateBlockDeviceMapping(TypedDict, total=False):
    """Describes a block device mapping."""

    DeviceName: Optional[String]
    VirtualName: Optional[String]
    Ebs: Optional[LaunchTemplateEbsBlockDevice]
    NoDevice: Optional[String]


LaunchTemplateBlockDeviceMappingList = List[LaunchTemplateBlockDeviceMapping]


class LaunchTemplateIamInstanceProfileSpecification(TypedDict, total=False):
    """Describes an IAM instance profile."""

    Arn: Optional[String]
    Name: Optional[String]


class ResponseLaunchTemplateData(TypedDict, total=False):
    """The information for a launch template."""

    KernelId: Optional[String]
    EbsOptimized: Optional[Boolean]
    IamInstanceProfile: Optional[LaunchTemplateIamInstanceProfileSpecification]
    BlockDeviceMappings: Optional[LaunchTemplateBlockDeviceMappingList]
    NetworkInterfaces: Optional[LaunchTemplateInstanceNetworkInterfaceSpecificationList]
    ImageId: Optional[String]
    InstanceType: Optional[InstanceType]
    KeyName: Optional[String]
    Monitoring: Optional[LaunchTemplatesMonitoring]
    Placement: Optional[LaunchTemplatePlacement]
    RamDiskId: Optional[String]
    DisableApiTermination: Optional[Boolean]
    InstanceInitiatedShutdownBehavior: Optional[ShutdownBehavior]
    UserData: Optional[String]
    TagSpecifications: Optional[LaunchTemplateTagSpecificationList]
    ElasticGpuSpecifications: Optional[ElasticGpuSpecificationResponseList]
    ElasticInferenceAccelerators: Optional[LaunchTemplateElasticInferenceAcceleratorResponseList]
    SecurityGroupIds: Optional[ValueStringList]
    SecurityGroups: Optional[ValueStringList]
    InstanceMarketOptions: Optional[LaunchTemplateInstanceMarketOptions]
    CreditSpecification: Optional[CreditSpecification]
    CpuOptions: Optional[LaunchTemplateCpuOptions]
    CapacityReservationSpecification: Optional[
        LaunchTemplateCapacityReservationSpecificationResponse
    ]
    LicenseSpecifications: Optional[LaunchTemplateLicenseList]
    HibernationOptions: Optional[LaunchTemplateHibernationOptions]
    MetadataOptions: Optional[LaunchTemplateInstanceMetadataOptions]
    EnclaveOptions: Optional[LaunchTemplateEnclaveOptions]
    InstanceRequirements: Optional[InstanceRequirements]
    PrivateDnsNameOptions: Optional[LaunchTemplatePrivateDnsNameOptions]


class LaunchTemplateVersion(TypedDict, total=False):
    """Describes a launch template version."""

    LaunchTemplateId: Optional[String]
    LaunchTemplateName: Optional[LaunchTemplateName]
    VersionNumber: Optional[Long]
    VersionDescription: Optional[VersionDescription]
    CreateTime: Optional[DateTime]
    CreatedBy: Optional[String]
    DefaultVersion: Optional[Boolean]
    LaunchTemplateData: Optional[ResponseLaunchTemplateData]


class CreateLaunchTemplateVersionResult(TypedDict, total=False):
    LaunchTemplateVersion: Optional[LaunchTemplateVersion]
    Warning: Optional[ValidationWarning]


class CreateLocalGatewayRouteRequest(ServiceRequest):
    DestinationCidrBlock: String
    LocalGatewayRouteTableId: LocalGatewayRoutetableId
    LocalGatewayVirtualInterfaceGroupId: LocalGatewayVirtualInterfaceGroupId
    DryRun: Optional[Boolean]


class LocalGatewayRoute(TypedDict, total=False):
    """Describes a route for a local gateway route table."""

    DestinationCidrBlock: Optional[String]
    LocalGatewayVirtualInterfaceGroupId: Optional[LocalGatewayVirtualInterfaceGroupId]
    Type: Optional[LocalGatewayRouteType]
    State: Optional[LocalGatewayRouteState]
    LocalGatewayRouteTableId: Optional[LocalGatewayRoutetableId]
    LocalGatewayRouteTableArn: Optional[ResourceArn]
    OwnerId: Optional[String]


class CreateLocalGatewayRouteResult(TypedDict, total=False):
    Route: Optional[LocalGatewayRoute]


class CreateLocalGatewayRouteTableVpcAssociationRequest(ServiceRequest):
    LocalGatewayRouteTableId: LocalGatewayRoutetableId
    VpcId: VpcId
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class LocalGatewayRouteTableVpcAssociation(TypedDict, total=False):
    """Describes an association between a local gateway route table and a VPC."""

    LocalGatewayRouteTableVpcAssociationId: Optional[LocalGatewayRouteTableVpcAssociationId]
    LocalGatewayRouteTableId: Optional[String]
    LocalGatewayRouteTableArn: Optional[ResourceArn]
    LocalGatewayId: Optional[String]
    VpcId: Optional[String]
    OwnerId: Optional[String]
    State: Optional[String]
    Tags: Optional[TagList]


class CreateLocalGatewayRouteTableVpcAssociationResult(TypedDict, total=False):
    LocalGatewayRouteTableVpcAssociation: Optional[LocalGatewayRouteTableVpcAssociation]


class CreateManagedPrefixListRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PrefixListName: String
    Entries: Optional[AddPrefixListEntries]
    MaxEntries: Integer
    TagSpecifications: Optional[TagSpecificationList]
    AddressFamily: String
    ClientToken: Optional[String]


class ManagedPrefixList(TypedDict, total=False):
    """Describes a managed prefix list."""

    PrefixListId: Optional[PrefixListResourceId]
    AddressFamily: Optional[String]
    State: Optional[PrefixListState]
    StateMessage: Optional[String]
    PrefixListArn: Optional[ResourceArn]
    PrefixListName: Optional[String]
    MaxEntries: Optional[Integer]
    Version: Optional[Long]
    Tags: Optional[TagList]
    OwnerId: Optional[String]


class CreateManagedPrefixListResult(TypedDict, total=False):
    PrefixList: Optional[ManagedPrefixList]


class CreateNatGatewayRequest(ServiceRequest):
    AllocationId: Optional[AllocationId]
    ClientToken: Optional[String]
    DryRun: Optional[Boolean]
    SubnetId: SubnetId
    TagSpecifications: Optional[TagSpecificationList]
    ConnectivityType: Optional[ConnectivityType]


class ProvisionedBandwidth(TypedDict, total=False):
    """Reserved. If you need to sustain traffic greater than the `documented
    limits <https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html>`__,
    contact us through the `Support
    Center <https://console.aws.amazon.com/support/home?>`__.
    """

    ProvisionTime: Optional[DateTime]
    Provisioned: Optional[String]
    RequestTime: Optional[DateTime]
    Requested: Optional[String]
    Status: Optional[String]


class NatGatewayAddress(TypedDict, total=False):
    """Describes the IP addresses and network interface associated with a NAT
    gateway.
    """

    AllocationId: Optional[String]
    NetworkInterfaceId: Optional[String]
    PrivateIp: Optional[String]
    PublicIp: Optional[String]


NatGatewayAddressList = List[NatGatewayAddress]


class NatGateway(TypedDict, total=False):
    """Describes a NAT gateway."""

    CreateTime: Optional[DateTime]
    DeleteTime: Optional[DateTime]
    FailureCode: Optional[String]
    FailureMessage: Optional[String]
    NatGatewayAddresses: Optional[NatGatewayAddressList]
    NatGatewayId: Optional[String]
    ProvisionedBandwidth: Optional[ProvisionedBandwidth]
    State: Optional[NatGatewayState]
    SubnetId: Optional[String]
    VpcId: Optional[String]
    Tags: Optional[TagList]
    ConnectivityType: Optional[ConnectivityType]


class CreateNatGatewayResult(TypedDict, total=False):
    ClientToken: Optional[String]
    NatGateway: Optional[NatGateway]


class IcmpTypeCode(TypedDict, total=False):
    """Describes the ICMP type and code."""

    Code: Optional[Integer]
    Type: Optional[Integer]


class CreateNetworkAclEntryRequest(ServiceRequest):
    CidrBlock: Optional[String]
    DryRun: Optional[Boolean]
    Egress: Boolean
    IcmpTypeCode: Optional[IcmpTypeCode]
    Ipv6CidrBlock: Optional[String]
    NetworkAclId: NetworkAclId
    PortRange: Optional[PortRange]
    Protocol: String
    RuleAction: RuleAction
    RuleNumber: Integer


class CreateNetworkAclRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VpcId: VpcId
    TagSpecifications: Optional[TagSpecificationList]


class NetworkAclEntry(TypedDict, total=False):
    """Describes an entry in a network ACL."""

    CidrBlock: Optional[String]
    Egress: Optional[Boolean]
    IcmpTypeCode: Optional[IcmpTypeCode]
    Ipv6CidrBlock: Optional[String]
    PortRange: Optional[PortRange]
    Protocol: Optional[String]
    RuleAction: Optional[RuleAction]
    RuleNumber: Optional[Integer]


NetworkAclEntryList = List[NetworkAclEntry]


class NetworkAclAssociation(TypedDict, total=False):
    """Describes an association between a network ACL and a subnet."""

    NetworkAclAssociationId: Optional[String]
    NetworkAclId: Optional[String]
    SubnetId: Optional[String]


NetworkAclAssociationList = List[NetworkAclAssociation]


class NetworkAcl(TypedDict, total=False):
    """Describes a network ACL."""

    Associations: Optional[NetworkAclAssociationList]
    Entries: Optional[NetworkAclEntryList]
    IsDefault: Optional[Boolean]
    NetworkAclId: Optional[String]
    Tags: Optional[TagList]
    VpcId: Optional[String]
    OwnerId: Optional[String]


class CreateNetworkAclResult(TypedDict, total=False):
    NetworkAcl: Optional[NetworkAcl]


class CreateNetworkInsightsAccessScopeRequest(ServiceRequest):
    MatchPaths: Optional[AccessScopePathListRequest]
    ExcludePaths: Optional[AccessScopePathListRequest]
    ClientToken: String
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class NetworkInsightsAccessScopeContent(TypedDict, total=False):
    """Describes the Network Access Scope content."""

    NetworkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    MatchPaths: Optional[AccessScopePathList]
    ExcludePaths: Optional[AccessScopePathList]


class NetworkInsightsAccessScope(TypedDict, total=False):
    """Describes a Network Access Scope."""

    NetworkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    NetworkInsightsAccessScopeArn: Optional[ResourceArn]
    CreatedDate: Optional[MillisecondDateTime]
    UpdatedDate: Optional[MillisecondDateTime]
    Tags: Optional[TagList]


class CreateNetworkInsightsAccessScopeResult(TypedDict, total=False):
    NetworkInsightsAccessScope: Optional[NetworkInsightsAccessScope]
    NetworkInsightsAccessScopeContent: Optional[NetworkInsightsAccessScopeContent]


class CreateNetworkInsightsPathRequest(ServiceRequest):
    SourceIp: Optional[IpAddress]
    DestinationIp: Optional[IpAddress]
    Source: NetworkInsightsResourceId
    Destination: NetworkInsightsResourceId
    Protocol: Protocol
    DestinationPort: Optional[Port]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]
    ClientToken: String


class NetworkInsightsPath(TypedDict, total=False):
    """Describes a path."""

    NetworkInsightsPathId: Optional[NetworkInsightsPathId]
    NetworkInsightsPathArn: Optional[ResourceArn]
    CreatedDate: Optional[MillisecondDateTime]
    Source: Optional[String]
    Destination: Optional[String]
    SourceIp: Optional[IpAddress]
    DestinationIp: Optional[IpAddress]
    Protocol: Optional[Protocol]
    DestinationPort: Optional[Integer]
    Tags: Optional[TagList]


class CreateNetworkInsightsPathResult(TypedDict, total=False):
    NetworkInsightsPath: Optional[NetworkInsightsPath]


class CreateNetworkInterfacePermissionRequest(ServiceRequest):
    """Contains the parameters for CreateNetworkInterfacePermission."""

    NetworkInterfaceId: NetworkInterfaceId
    AwsAccountId: Optional[String]
    AwsService: Optional[String]
    Permission: InterfacePermissionType
    DryRun: Optional[Boolean]


class NetworkInterfacePermissionState(TypedDict, total=False):
    """Describes the state of a network interface permission."""

    State: Optional[NetworkInterfacePermissionStateCode]
    StatusMessage: Optional[String]


class NetworkInterfacePermission(TypedDict, total=False):
    """Describes a permission for a network interface."""

    NetworkInterfacePermissionId: Optional[String]
    NetworkInterfaceId: Optional[String]
    AwsAccountId: Optional[String]
    AwsService: Optional[String]
    Permission: Optional[InterfacePermissionType]
    PermissionState: Optional[NetworkInterfacePermissionState]


class CreateNetworkInterfacePermissionResult(TypedDict, total=False):
    """Contains the output of CreateNetworkInterfacePermission."""

    InterfacePermission: Optional[NetworkInterfacePermission]


class CreateNetworkInterfaceRequest(ServiceRequest):
    """Contains the parameters for CreateNetworkInterface."""

    Description: Optional[String]
    DryRun: Optional[Boolean]
    Groups: Optional[SecurityGroupIdStringList]
    Ipv6AddressCount: Optional[Integer]
    Ipv6Addresses: Optional[InstanceIpv6AddressList]
    PrivateIpAddress: Optional[String]
    PrivateIpAddresses: Optional[PrivateIpAddressSpecificationList]
    SecondaryPrivateIpAddressCount: Optional[Integer]
    Ipv4Prefixes: Optional[Ipv4PrefixList]
    Ipv4PrefixCount: Optional[Integer]
    Ipv6Prefixes: Optional[Ipv6PrefixList]
    Ipv6PrefixCount: Optional[Integer]
    InterfaceType: Optional[NetworkInterfaceCreationType]
    SubnetId: SubnetId
    TagSpecifications: Optional[TagSpecificationList]
    ClientToken: Optional[String]


class Ipv6PrefixSpecification(TypedDict, total=False):
    """Describes the IPv6 prefix."""

    Ipv6Prefix: Optional[String]


Ipv6PrefixesList = List[Ipv6PrefixSpecification]


class NetworkInterfaceAssociation(TypedDict, total=False):
    """Describes association information for an Elastic IP address (IPv4 only),
    or a Carrier IP address (for a network interface which resides in a
    subnet in a Wavelength Zone).
    """

    AllocationId: Optional[String]
    AssociationId: Optional[String]
    IpOwnerId: Optional[String]
    PublicDnsName: Optional[String]
    PublicIp: Optional[String]
    CustomerOwnedIp: Optional[String]
    CarrierIp: Optional[String]


class NetworkInterfacePrivateIpAddress(TypedDict, total=False):
    """Describes the private IPv4 address of a network interface."""

    Association: Optional[NetworkInterfaceAssociation]
    Primary: Optional[Boolean]
    PrivateDnsName: Optional[String]
    PrivateIpAddress: Optional[String]


NetworkInterfacePrivateIpAddressList = List[NetworkInterfacePrivateIpAddress]


class NetworkInterfaceIpv6Address(TypedDict, total=False):
    """Describes an IPv6 address associated with a network interface."""

    Ipv6Address: Optional[String]


NetworkInterfaceIpv6AddressesList = List[NetworkInterfaceIpv6Address]


class NetworkInterfaceAttachment(TypedDict, total=False):
    """Describes a network interface attachment."""

    AttachTime: Optional[DateTime]
    AttachmentId: Optional[String]
    DeleteOnTermination: Optional[Boolean]
    DeviceIndex: Optional[Integer]
    NetworkCardIndex: Optional[Integer]
    InstanceId: Optional[String]
    InstanceOwnerId: Optional[String]
    Status: Optional[AttachmentStatus]


class NetworkInterface(TypedDict, total=False):
    """Describes a network interface."""

    Association: Optional[NetworkInterfaceAssociation]
    Attachment: Optional[NetworkInterfaceAttachment]
    AvailabilityZone: Optional[String]
    Description: Optional[String]
    Groups: Optional[GroupIdentifierList]
    InterfaceType: Optional[NetworkInterfaceType]
    Ipv6Addresses: Optional[NetworkInterfaceIpv6AddressesList]
    MacAddress: Optional[String]
    NetworkInterfaceId: Optional[String]
    OutpostArn: Optional[String]
    OwnerId: Optional[String]
    PrivateDnsName: Optional[String]
    PrivateIpAddress: Optional[String]
    PrivateIpAddresses: Optional[NetworkInterfacePrivateIpAddressList]
    Ipv4Prefixes: Optional[Ipv4PrefixesList]
    Ipv6Prefixes: Optional[Ipv6PrefixesList]
    RequesterId: Optional[String]
    RequesterManaged: Optional[Boolean]
    SourceDestCheck: Optional[Boolean]
    Status: Optional[NetworkInterfaceStatus]
    SubnetId: Optional[String]
    TagSet: Optional[TagList]
    VpcId: Optional[String]
    DenyAllIgwTraffic: Optional[Boolean]
    Ipv6Native: Optional[Boolean]
    Ipv6Address: Optional[String]


class CreateNetworkInterfaceResult(TypedDict, total=False):
    """Contains the output of CreateNetworkInterface."""

    NetworkInterface: Optional[NetworkInterface]
    ClientToken: Optional[String]


class CreatePlacementGroupRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    GroupName: Optional[String]
    Strategy: Optional[PlacementStrategy]
    PartitionCount: Optional[Integer]
    TagSpecifications: Optional[TagSpecificationList]


class PlacementGroup(TypedDict, total=False):
    """Describes a placement group."""

    GroupName: Optional[String]
    State: Optional[PlacementGroupState]
    Strategy: Optional[PlacementStrategy]
    PartitionCount: Optional[Integer]
    GroupId: Optional[String]
    Tags: Optional[TagList]
    GroupArn: Optional[String]


class CreatePlacementGroupResult(TypedDict, total=False):
    PlacementGroup: Optional[PlacementGroup]


class CreatePublicIpv4PoolRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]


class CreatePublicIpv4PoolResult(TypedDict, total=False):
    PoolId: Optional[Ipv4PoolEc2Id]


class CreateReplaceRootVolumeTaskRequest(ServiceRequest):
    InstanceId: InstanceId
    SnapshotId: Optional[SnapshotId]
    ClientToken: Optional[String]
    DryRun: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]


class ReplaceRootVolumeTask(TypedDict, total=False):
    """Information about a root volume replacement task."""

    ReplaceRootVolumeTaskId: Optional[ReplaceRootVolumeTaskId]
    InstanceId: Optional[String]
    TaskState: Optional[ReplaceRootVolumeTaskState]
    StartTime: Optional[String]
    CompleteTime: Optional[String]
    Tags: Optional[TagList]


class CreateReplaceRootVolumeTaskResult(TypedDict, total=False):
    ReplaceRootVolumeTask: Optional[ReplaceRootVolumeTask]


class PriceScheduleSpecification(TypedDict, total=False):
    """Describes the price for a Reserved Instance."""

    CurrencyCode: Optional[CurrencyCodeValues]
    Price: Optional[Double]
    Term: Optional[Long]


PriceScheduleSpecificationList = List[PriceScheduleSpecification]


class CreateReservedInstancesListingRequest(ServiceRequest):
    """Contains the parameters for CreateReservedInstancesListing."""

    ClientToken: String
    InstanceCount: Integer
    PriceSchedules: PriceScheduleSpecificationList
    ReservedInstancesId: ReservationId


class CreateReservedInstancesListingResult(TypedDict, total=False):
    """Contains the output of CreateReservedInstancesListing."""

    ReservedInstancesListings: Optional[ReservedInstancesListingList]


class CreateRestoreImageTaskRequest(ServiceRequest):
    Bucket: String
    ObjectKey: String
    Name: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class CreateRestoreImageTaskResult(TypedDict, total=False):
    ImageId: Optional[String]


class CreateRouteRequest(ServiceRequest):
    DestinationCidrBlock: Optional[String]
    DestinationIpv6CidrBlock: Optional[String]
    DestinationPrefixListId: Optional[PrefixListResourceId]
    DryRun: Optional[Boolean]
    VpcEndpointId: Optional[VpcEndpointId]
    EgressOnlyInternetGatewayId: Optional[EgressOnlyInternetGatewayId]
    GatewayId: Optional[RouteGatewayId]
    InstanceId: Optional[InstanceId]
    NatGatewayId: Optional[NatGatewayId]
    TransitGatewayId: Optional[TransitGatewayId]
    LocalGatewayId: Optional[LocalGatewayId]
    CarrierGatewayId: Optional[CarrierGatewayId]
    NetworkInterfaceId: Optional[NetworkInterfaceId]
    RouteTableId: RouteTableId
    VpcPeeringConnectionId: Optional[VpcPeeringConnectionId]
    CoreNetworkArn: Optional[CoreNetworkArn]


class CreateRouteResult(TypedDict, total=False):
    Return: Optional[Boolean]


class CreateRouteTableRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VpcId: VpcId
    TagSpecifications: Optional[TagSpecificationList]


class Route(TypedDict, total=False):
    """Describes a route in a route table."""

    DestinationCidrBlock: Optional[String]
    DestinationIpv6CidrBlock: Optional[String]
    DestinationPrefixListId: Optional[String]
    EgressOnlyInternetGatewayId: Optional[String]
    GatewayId: Optional[String]
    InstanceId: Optional[String]
    InstanceOwnerId: Optional[String]
    NatGatewayId: Optional[String]
    TransitGatewayId: Optional[String]
    LocalGatewayId: Optional[String]
    CarrierGatewayId: Optional[CarrierGatewayId]
    NetworkInterfaceId: Optional[String]
    Origin: Optional[RouteOrigin]
    State: Optional[RouteState]
    VpcPeeringConnectionId: Optional[String]
    CoreNetworkArn: Optional[CoreNetworkArn]


RouteList = List[Route]


class PropagatingVgw(TypedDict, total=False):
    """Describes a virtual private gateway propagating route."""

    GatewayId: Optional[String]


PropagatingVgwList = List[PropagatingVgw]


class RouteTableAssociation(TypedDict, total=False):
    """Describes an association between a route table and a subnet or gateway."""

    Main: Optional[Boolean]
    RouteTableAssociationId: Optional[String]
    RouteTableId: Optional[String]
    SubnetId: Optional[String]
    GatewayId: Optional[String]
    AssociationState: Optional[RouteTableAssociationState]


RouteTableAssociationList = List[RouteTableAssociation]


class RouteTable(TypedDict, total=False):
    """Describes a route table."""

    Associations: Optional[RouteTableAssociationList]
    PropagatingVgws: Optional[PropagatingVgwList]
    RouteTableId: Optional[String]
    Routes: Optional[RouteList]
    Tags: Optional[TagList]
    VpcId: Optional[String]
    OwnerId: Optional[String]


class CreateRouteTableResult(TypedDict, total=False):
    RouteTable: Optional[RouteTable]


class CreateSecurityGroupRequest(ServiceRequest):
    Description: String
    GroupName: String
    VpcId: Optional[VpcId]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class CreateSecurityGroupResult(TypedDict, total=False):
    GroupId: Optional[String]
    Tags: Optional[TagList]


class CreateSnapshotRequest(ServiceRequest):
    Description: Optional[String]
    OutpostArn: Optional[String]
    VolumeId: VolumeId
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class InstanceSpecification(TypedDict, total=False):
    """The instance details to specify which volumes should be snapshotted."""

    InstanceId: Optional[InstanceId]
    ExcludeBootVolume: Optional[Boolean]


class CreateSnapshotsRequest(ServiceRequest):
    Description: Optional[String]
    InstanceSpecification: InstanceSpecification
    OutpostArn: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]
    CopyTagsFromSource: Optional[CopyTagsFromSource]


class SnapshotInfo(TypedDict, total=False):
    """Information about a snapshot."""

    Description: Optional[String]
    Tags: Optional[TagList]
    Encrypted: Optional[Boolean]
    VolumeId: Optional[String]
    State: Optional[SnapshotState]
    VolumeSize: Optional[Integer]
    StartTime: Optional[MillisecondDateTime]
    Progress: Optional[String]
    OwnerId: Optional[String]
    SnapshotId: Optional[String]
    OutpostArn: Optional[String]


SnapshotSet = List[SnapshotInfo]


class CreateSnapshotsResult(TypedDict, total=False):
    Snapshots: Optional[SnapshotSet]


class CreateSpotDatafeedSubscriptionRequest(ServiceRequest):
    """Contains the parameters for CreateSpotDatafeedSubscription."""

    Bucket: String
    DryRun: Optional[Boolean]
    Prefix: Optional[String]


class SpotInstanceStateFault(TypedDict, total=False):
    """Describes a Spot Instance state change."""

    Code: Optional[String]
    Message: Optional[String]


class SpotDatafeedSubscription(TypedDict, total=False):
    """Describes the data feed for a Spot Instance."""

    Bucket: Optional[String]
    Fault: Optional[SpotInstanceStateFault]
    OwnerId: Optional[String]
    Prefix: Optional[String]
    State: Optional[DatafeedSubscriptionState]


class CreateSpotDatafeedSubscriptionResult(TypedDict, total=False):
    """Contains the output of CreateSpotDatafeedSubscription."""

    SpotDatafeedSubscription: Optional[SpotDatafeedSubscription]


class S3ObjectTag(TypedDict, total=False):
    """The tags to apply to the AMI object that will be stored in the Amazon S3
    bucket. For more information, see `Categorizing your storage using
    tags <https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-tagging.html>`__
    in the *Amazon Simple Storage Service User Guide*.
    """

    Key: Optional[String]
    Value: Optional[String]


S3ObjectTagList = List[S3ObjectTag]


class CreateStoreImageTaskRequest(ServiceRequest):
    ImageId: ImageId
    Bucket: String
    S3ObjectTags: Optional[S3ObjectTagList]
    DryRun: Optional[Boolean]


class CreateStoreImageTaskResult(TypedDict, total=False):
    ObjectKey: Optional[String]


class CreateSubnetCidrReservationRequest(ServiceRequest):
    TagSpecifications: Optional[TagSpecificationList]
    SubnetId: SubnetId
    Cidr: String
    ReservationType: SubnetCidrReservationType
    Description: Optional[String]
    DryRun: Optional[Boolean]


class SubnetCidrReservation(TypedDict, total=False):
    """Describes a subnet CIDR reservation."""

    SubnetCidrReservationId: Optional[SubnetCidrReservationId]
    SubnetId: Optional[SubnetId]
    Cidr: Optional[String]
    ReservationType: Optional[SubnetCidrReservationType]
    OwnerId: Optional[String]
    Description: Optional[String]
    Tags: Optional[TagList]


class CreateSubnetCidrReservationResult(TypedDict, total=False):
    SubnetCidrReservation: Optional[SubnetCidrReservation]


class CreateSubnetRequest(ServiceRequest):
    TagSpecifications: Optional[TagSpecificationList]
    AvailabilityZone: Optional[String]
    AvailabilityZoneId: Optional[String]
    CidrBlock: Optional[String]
    Ipv6CidrBlock: Optional[String]
    OutpostArn: Optional[String]
    VpcId: VpcId
    DryRun: Optional[Boolean]
    Ipv6Native: Optional[Boolean]


class CreateSubnetResult(TypedDict, total=False):
    Subnet: Optional[Subnet]


ResourceIdList = List[TaggableResourceId]


class CreateTagsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Resources: ResourceIdList
    Tags: TagList


class CreateTrafficMirrorFilterRequest(ServiceRequest):
    Description: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]


TrafficMirrorNetworkServiceList = List[TrafficMirrorNetworkService]


class TrafficMirrorPortRange(TypedDict, total=False):
    """Describes the Traffic Mirror port range."""

    FromPort: Optional[Integer]
    ToPort: Optional[Integer]


class TrafficMirrorFilterRule(TypedDict, total=False):
    """Describes the Traffic Mirror rule."""

    TrafficMirrorFilterRuleId: Optional[String]
    TrafficMirrorFilterId: Optional[String]
    TrafficDirection: Optional[TrafficDirection]
    RuleNumber: Optional[Integer]
    RuleAction: Optional[TrafficMirrorRuleAction]
    Protocol: Optional[Integer]
    DestinationPortRange: Optional[TrafficMirrorPortRange]
    SourcePortRange: Optional[TrafficMirrorPortRange]
    DestinationCidrBlock: Optional[String]
    SourceCidrBlock: Optional[String]
    Description: Optional[String]


TrafficMirrorFilterRuleList = List[TrafficMirrorFilterRule]


class TrafficMirrorFilter(TypedDict, total=False):
    """Describes the Traffic Mirror filter."""

    TrafficMirrorFilterId: Optional[String]
    IngressFilterRules: Optional[TrafficMirrorFilterRuleList]
    EgressFilterRules: Optional[TrafficMirrorFilterRuleList]
    NetworkServices: Optional[TrafficMirrorNetworkServiceList]
    Description: Optional[String]
    Tags: Optional[TagList]


class CreateTrafficMirrorFilterResult(TypedDict, total=False):
    TrafficMirrorFilter: Optional[TrafficMirrorFilter]
    ClientToken: Optional[String]


class TrafficMirrorPortRangeRequest(TypedDict, total=False):
    """Information about the Traffic Mirror filter rule port range."""

    FromPort: Optional[Integer]
    ToPort: Optional[Integer]


class CreateTrafficMirrorFilterRuleRequest(ServiceRequest):
    TrafficMirrorFilterId: TrafficMirrorFilterId
    TrafficDirection: TrafficDirection
    RuleNumber: Integer
    RuleAction: TrafficMirrorRuleAction
    DestinationPortRange: Optional[TrafficMirrorPortRangeRequest]
    SourcePortRange: Optional[TrafficMirrorPortRangeRequest]
    Protocol: Optional[Integer]
    DestinationCidrBlock: String
    SourceCidrBlock: String
    Description: Optional[String]
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]


class CreateTrafficMirrorFilterRuleResult(TypedDict, total=False):
    TrafficMirrorFilterRule: Optional[TrafficMirrorFilterRule]
    ClientToken: Optional[String]


class CreateTrafficMirrorSessionRequest(ServiceRequest):
    NetworkInterfaceId: NetworkInterfaceId
    TrafficMirrorTargetId: TrafficMirrorTargetId
    TrafficMirrorFilterId: TrafficMirrorFilterId
    PacketLength: Optional[Integer]
    SessionNumber: Integer
    VirtualNetworkId: Optional[Integer]
    Description: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]


class TrafficMirrorSession(TypedDict, total=False):
    """Describes a Traffic Mirror session."""

    TrafficMirrorSessionId: Optional[String]
    TrafficMirrorTargetId: Optional[String]
    TrafficMirrorFilterId: Optional[String]
    NetworkInterfaceId: Optional[String]
    OwnerId: Optional[String]
    PacketLength: Optional[Integer]
    SessionNumber: Optional[Integer]
    VirtualNetworkId: Optional[Integer]
    Description: Optional[String]
    Tags: Optional[TagList]


class CreateTrafficMirrorSessionResult(TypedDict, total=False):
    TrafficMirrorSession: Optional[TrafficMirrorSession]
    ClientToken: Optional[String]


class CreateTrafficMirrorTargetRequest(ServiceRequest):
    NetworkInterfaceId: Optional[NetworkInterfaceId]
    NetworkLoadBalancerArn: Optional[String]
    Description: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]


class TrafficMirrorTarget(TypedDict, total=False):
    """Describes a Traffic Mirror target."""

    TrafficMirrorTargetId: Optional[String]
    NetworkInterfaceId: Optional[String]
    NetworkLoadBalancerArn: Optional[String]
    Type: Optional[TrafficMirrorTargetType]
    Description: Optional[String]
    OwnerId: Optional[String]
    Tags: Optional[TagList]


class CreateTrafficMirrorTargetResult(TypedDict, total=False):
    TrafficMirrorTarget: Optional[TrafficMirrorTarget]
    ClientToken: Optional[String]


InsideCidrBlocksStringList = List[String]


class TransitGatewayConnectRequestBgpOptions(TypedDict, total=False):
    """The BGP options for the Connect attachment."""

    PeerAsn: Optional[Long]


class CreateTransitGatewayConnectPeerRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    TransitGatewayAddress: Optional[String]
    PeerAddress: String
    BgpOptions: Optional[TransitGatewayConnectRequestBgpOptions]
    InsideCidrBlocks: InsideCidrBlocksStringList
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class TransitGatewayAttachmentBgpConfiguration(TypedDict, total=False):
    """The BGP configuration information."""

    TransitGatewayAsn: Optional[Long]
    PeerAsn: Optional[Long]
    TransitGatewayAddress: Optional[String]
    PeerAddress: Optional[String]
    BgpStatus: Optional[BgpStatus]


TransitGatewayAttachmentBgpConfigurationList = List[TransitGatewayAttachmentBgpConfiguration]


class TransitGatewayConnectPeerConfiguration(TypedDict, total=False):
    """Describes the Connect peer details."""

    TransitGatewayAddress: Optional[String]
    PeerAddress: Optional[String]
    InsideCidrBlocks: Optional[InsideCidrBlocksStringList]
    Protocol: Optional[ProtocolValue]
    BgpConfigurations: Optional[TransitGatewayAttachmentBgpConfigurationList]


class TransitGatewayConnectPeer(TypedDict, total=False):
    """Describes a transit gateway Connect peer."""

    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    TransitGatewayConnectPeerId: Optional[TransitGatewayConnectPeerId]
    State: Optional[TransitGatewayConnectPeerState]
    CreationTime: Optional[DateTime]
    ConnectPeerConfiguration: Optional[TransitGatewayConnectPeerConfiguration]
    Tags: Optional[TagList]


class CreateTransitGatewayConnectPeerResult(TypedDict, total=False):
    TransitGatewayConnectPeer: Optional[TransitGatewayConnectPeer]


class CreateTransitGatewayConnectRequestOptions(TypedDict, total=False):
    """The options for a Connect attachment."""

    Protocol: ProtocolValue


class CreateTransitGatewayConnectRequest(ServiceRequest):
    TransportTransitGatewayAttachmentId: TransitGatewayAttachmentId
    Options: CreateTransitGatewayConnectRequestOptions
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class TransitGatewayConnectOptions(TypedDict, total=False):
    """Describes the Connect attachment options."""

    Protocol: Optional[ProtocolValue]


class TransitGatewayConnect(TypedDict, total=False):
    """Describes a transit gateway Connect attachment."""

    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    TransportTransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    TransitGatewayId: Optional[TransitGatewayId]
    State: Optional[TransitGatewayAttachmentState]
    CreationTime: Optional[DateTime]
    Options: Optional[TransitGatewayConnectOptions]
    Tags: Optional[TagList]


class CreateTransitGatewayConnectResult(TypedDict, total=False):
    TransitGatewayConnect: Optional[TransitGatewayConnect]


class CreateTransitGatewayMulticastDomainRequestOptions(TypedDict, total=False):
    """The options for the transit gateway multicast domain."""

    Igmpv2Support: Optional[Igmpv2SupportValue]
    StaticSourcesSupport: Optional[StaticSourcesSupportValue]
    AutoAcceptSharedAssociations: Optional[AutoAcceptSharedAssociationsValue]


class CreateTransitGatewayMulticastDomainRequest(ServiceRequest):
    TransitGatewayId: TransitGatewayId
    Options: Optional[CreateTransitGatewayMulticastDomainRequestOptions]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class TransitGatewayMulticastDomainOptions(TypedDict, total=False):
    """Describes the options for a transit gateway multicast domain."""

    Igmpv2Support: Optional[Igmpv2SupportValue]
    StaticSourcesSupport: Optional[StaticSourcesSupportValue]
    AutoAcceptSharedAssociations: Optional[AutoAcceptSharedAssociationsValue]


class TransitGatewayMulticastDomain(TypedDict, total=False):
    """Describes the transit gateway multicast domain."""

    TransitGatewayMulticastDomainId: Optional[String]
    TransitGatewayId: Optional[String]
    TransitGatewayMulticastDomainArn: Optional[String]
    OwnerId: Optional[String]
    Options: Optional[TransitGatewayMulticastDomainOptions]
    State: Optional[TransitGatewayMulticastDomainState]
    CreationTime: Optional[DateTime]
    Tags: Optional[TagList]


class CreateTransitGatewayMulticastDomainResult(TypedDict, total=False):
    TransitGatewayMulticastDomain: Optional[TransitGatewayMulticastDomain]


class CreateTransitGatewayPeeringAttachmentRequest(ServiceRequest):
    TransitGatewayId: TransitGatewayId
    PeerTransitGatewayId: TransitAssociationGatewayId
    PeerAccountId: String
    PeerRegion: String
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class CreateTransitGatewayPeeringAttachmentResult(TypedDict, total=False):
    TransitGatewayPeeringAttachment: Optional[TransitGatewayPeeringAttachment]


class CreateTransitGatewayPrefixListReferenceRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    PrefixListId: PrefixListResourceId
    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    Blackhole: Optional[Boolean]
    DryRun: Optional[Boolean]


class TransitGatewayPrefixListAttachment(TypedDict, total=False):
    """Describes a transit gateway prefix list attachment."""

    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]
    ResourceId: Optional[String]


class TransitGatewayPrefixListReference(TypedDict, total=False):
    """Describes a prefix list reference."""

    TransitGatewayRouteTableId: Optional[TransitGatewayRouteTableId]
    PrefixListId: Optional[PrefixListResourceId]
    PrefixListOwnerId: Optional[String]
    State: Optional[TransitGatewayPrefixListReferenceState]
    Blackhole: Optional[Boolean]
    TransitGatewayAttachment: Optional[TransitGatewayPrefixListAttachment]


class CreateTransitGatewayPrefixListReferenceResult(TypedDict, total=False):
    TransitGatewayPrefixListReference: Optional[TransitGatewayPrefixListReference]


TransitGatewayCidrBlockStringList = List[String]


class TransitGatewayRequestOptions(TypedDict, total=False):
    """Describes the options for a transit gateway."""

    AmazonSideAsn: Optional[Long]
    AutoAcceptSharedAttachments: Optional[AutoAcceptSharedAttachmentsValue]
    DefaultRouteTableAssociation: Optional[DefaultRouteTableAssociationValue]
    DefaultRouteTablePropagation: Optional[DefaultRouteTablePropagationValue]
    VpnEcmpSupport: Optional[VpnEcmpSupportValue]
    DnsSupport: Optional[DnsSupportValue]
    MulticastSupport: Optional[MulticastSupportValue]
    TransitGatewayCidrBlocks: Optional[TransitGatewayCidrBlockStringList]


class CreateTransitGatewayRequest(ServiceRequest):
    Description: Optional[String]
    Options: Optional[TransitGatewayRequestOptions]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class TransitGatewayOptions(TypedDict, total=False):
    """Describes the options for a transit gateway."""

    AmazonSideAsn: Optional[Long]
    TransitGatewayCidrBlocks: Optional[ValueStringList]
    AutoAcceptSharedAttachments: Optional[AutoAcceptSharedAttachmentsValue]
    DefaultRouteTableAssociation: Optional[DefaultRouteTableAssociationValue]
    AssociationDefaultRouteTableId: Optional[String]
    DefaultRouteTablePropagation: Optional[DefaultRouteTablePropagationValue]
    PropagationDefaultRouteTableId: Optional[String]
    VpnEcmpSupport: Optional[VpnEcmpSupportValue]
    DnsSupport: Optional[DnsSupportValue]
    MulticastSupport: Optional[MulticastSupportValue]


class TransitGateway(TypedDict, total=False):
    """Describes a transit gateway."""

    TransitGatewayId: Optional[String]
    TransitGatewayArn: Optional[String]
    State: Optional[TransitGatewayState]
    OwnerId: Optional[String]
    Description: Optional[String]
    CreationTime: Optional[DateTime]
    Options: Optional[TransitGatewayOptions]
    Tags: Optional[TagList]


class CreateTransitGatewayResult(TypedDict, total=False):
    TransitGateway: Optional[TransitGateway]


class CreateTransitGatewayRouteRequest(ServiceRequest):
    DestinationCidrBlock: String
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    Blackhole: Optional[Boolean]
    DryRun: Optional[Boolean]


class TransitGatewayRouteAttachment(TypedDict, total=False):
    """Describes a route attachment."""

    ResourceId: Optional[String]
    TransitGatewayAttachmentId: Optional[String]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]


TransitGatewayRouteAttachmentList = List[TransitGatewayRouteAttachment]


class TransitGatewayRoute(TypedDict, total=False):
    """Describes a route for a transit gateway route table."""

    DestinationCidrBlock: Optional[String]
    PrefixListId: Optional[PrefixListResourceId]
    TransitGatewayAttachments: Optional[TransitGatewayRouteAttachmentList]
    Type: Optional[TransitGatewayRouteType]
    State: Optional[TransitGatewayRouteState]


class CreateTransitGatewayRouteResult(TypedDict, total=False):
    Route: Optional[TransitGatewayRoute]


class CreateTransitGatewayRouteTableRequest(ServiceRequest):
    TransitGatewayId: TransitGatewayId
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class TransitGatewayRouteTable(TypedDict, total=False):
    """Describes a transit gateway route table."""

    TransitGatewayRouteTableId: Optional[String]
    TransitGatewayId: Optional[String]
    State: Optional[TransitGatewayRouteTableState]
    DefaultAssociationRouteTable: Optional[Boolean]
    DefaultPropagationRouteTable: Optional[Boolean]
    CreationTime: Optional[DateTime]
    Tags: Optional[TagList]


class CreateTransitGatewayRouteTableResult(TypedDict, total=False):
    TransitGatewayRouteTable: Optional[TransitGatewayRouteTable]


class CreateTransitGatewayVpcAttachmentRequestOptions(TypedDict, total=False):
    """Describes the options for a VPC attachment."""

    DnsSupport: Optional[DnsSupportValue]
    Ipv6Support: Optional[Ipv6SupportValue]
    ApplianceModeSupport: Optional[ApplianceModeSupportValue]


class CreateTransitGatewayVpcAttachmentRequest(ServiceRequest):
    TransitGatewayId: TransitGatewayId
    VpcId: VpcId
    SubnetIds: TransitGatewaySubnetIdList
    Options: Optional[CreateTransitGatewayVpcAttachmentRequestOptions]
    TagSpecifications: Optional[TagSpecificationList]
    DryRun: Optional[Boolean]


class CreateTransitGatewayVpcAttachmentResult(TypedDict, total=False):
    TransitGatewayVpcAttachment: Optional[TransitGatewayVpcAttachment]


class CreateVolumePermission(TypedDict, total=False):
    """Describes the user or group to be added or removed from the list of
    create volume permissions for a volume.
    """

    Group: Optional[PermissionGroup]
    UserId: Optional[String]


CreateVolumePermissionList = List[CreateVolumePermission]


class CreateVolumePermissionModifications(TypedDict, total=False):
    """Describes modifications to the list of create volume permissions for a
    volume.
    """

    Add: Optional[CreateVolumePermissionList]
    Remove: Optional[CreateVolumePermissionList]


class CreateVolumeRequest(ServiceRequest):
    AvailabilityZone: String
    Encrypted: Optional[Boolean]
    Iops: Optional[Integer]
    KmsKeyId: Optional[KmsKeyId]
    OutpostArn: Optional[String]
    Size: Optional[Integer]
    SnapshotId: Optional[SnapshotId]
    VolumeType: Optional[VolumeType]
    DryRun: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]
    MultiAttachEnabled: Optional[Boolean]
    Throughput: Optional[Integer]
    ClientToken: Optional[String]


class CreateVpcEndpointConnectionNotificationRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceId: Optional[VpcEndpointServiceId]
    VpcEndpointId: Optional[VpcEndpointId]
    ConnectionNotificationArn: String
    ConnectionEvents: ValueStringList
    ClientToken: Optional[String]


class CreateVpcEndpointConnectionNotificationResult(TypedDict, total=False):
    ConnectionNotification: Optional[ConnectionNotification]
    ClientToken: Optional[String]


VpcEndpointSecurityGroupIdList = List[SecurityGroupId]
VpcEndpointSubnetIdList = List[SubnetId]
VpcEndpointRouteTableIdList = List[RouteTableId]


class CreateVpcEndpointRequest(ServiceRequest):
    """Contains the parameters for CreateVpcEndpoint."""

    DryRun: Optional[Boolean]
    VpcEndpointType: Optional[VpcEndpointType]
    VpcId: VpcId
    ServiceName: String
    PolicyDocument: Optional[String]
    RouteTableIds: Optional[VpcEndpointRouteTableIdList]
    SubnetIds: Optional[VpcEndpointSubnetIdList]
    SecurityGroupIds: Optional[VpcEndpointSecurityGroupIdList]
    ClientToken: Optional[String]
    PrivateDnsEnabled: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]


class LastError(TypedDict, total=False):
    """The last error that occurred for a VPC endpoint."""

    Message: Optional[String]
    Code: Optional[String]


class DnsEntry(TypedDict, total=False):
    """Describes a DNS entry."""

    DnsName: Optional[String]
    HostedZoneId: Optional[String]


DnsEntrySet = List[DnsEntry]


class SecurityGroupIdentifier(TypedDict, total=False):
    """Describes a security group."""

    GroupId: Optional[String]
    GroupName: Optional[String]


GroupIdentifierSet = List[SecurityGroupIdentifier]


class VpcEndpoint(TypedDict, total=False):
    """Describes a VPC endpoint."""

    VpcEndpointId: Optional[String]
    VpcEndpointType: Optional[VpcEndpointType]
    VpcId: Optional[String]
    ServiceName: Optional[String]
    State: Optional[State]
    PolicyDocument: Optional[String]
    RouteTableIds: Optional[ValueStringList]
    SubnetIds: Optional[ValueStringList]
    Groups: Optional[GroupIdentifierSet]
    PrivateDnsEnabled: Optional[Boolean]
    RequesterManaged: Optional[Boolean]
    NetworkInterfaceIds: Optional[ValueStringList]
    DnsEntries: Optional[DnsEntrySet]
    CreationTimestamp: Optional[MillisecondDateTime]
    Tags: Optional[TagList]
    OwnerId: Optional[String]
    LastError: Optional[LastError]


class CreateVpcEndpointResult(TypedDict, total=False):
    """Contains the output of CreateVpcEndpoint."""

    VpcEndpoint: Optional[VpcEndpoint]
    ClientToken: Optional[String]


class CreateVpcEndpointServiceConfigurationRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    AcceptanceRequired: Optional[Boolean]
    PrivateDnsName: Optional[String]
    NetworkLoadBalancerArns: Optional[ValueStringList]
    GatewayLoadBalancerArns: Optional[ValueStringList]
    ClientToken: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]


class PrivateDnsNameConfiguration(TypedDict, total=False):
    """Information about the private DNS name for the service endpoint. For
    more information about these parameters, see `VPC Endpoint Service
    Private DNS Name
    Verification <https://docs.aws.amazon.com/vpc/latest/userguide/ndpoint-services-dns-validation.html>`__
    in the *Amazon Virtual Private Cloud User Guide*.
    """

    State: Optional[DnsNameState]
    Type: Optional[String]
    Value: Optional[String]
    Name: Optional[String]


class ServiceTypeDetail(TypedDict, total=False):
    """Describes the type of service for a VPC endpoint."""

    ServiceType: Optional[ServiceType]


ServiceTypeDetailSet = List[ServiceTypeDetail]


class ServiceConfiguration(TypedDict, total=False):
    """Describes a service configuration for a VPC endpoint service."""

    ServiceType: Optional[ServiceTypeDetailSet]
    ServiceId: Optional[String]
    ServiceName: Optional[String]
    ServiceState: Optional[ServiceState]
    AvailabilityZones: Optional[ValueStringList]
    AcceptanceRequired: Optional[Boolean]
    ManagesVpcEndpoints: Optional[Boolean]
    NetworkLoadBalancerArns: Optional[ValueStringList]
    GatewayLoadBalancerArns: Optional[ValueStringList]
    BaseEndpointDnsNames: Optional[ValueStringList]
    PrivateDnsName: Optional[String]
    PrivateDnsNameConfiguration: Optional[PrivateDnsNameConfiguration]
    PayerResponsibility: Optional[PayerResponsibility]
    Tags: Optional[TagList]


class CreateVpcEndpointServiceConfigurationResult(TypedDict, total=False):
    ServiceConfiguration: Optional[ServiceConfiguration]
    ClientToken: Optional[String]


class CreateVpcPeeringConnectionRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PeerOwnerId: Optional[String]
    PeerVpcId: Optional[String]
    VpcId: Optional[VpcId]
    PeerRegion: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]


class CreateVpcPeeringConnectionResult(TypedDict, total=False):
    VpcPeeringConnection: Optional[VpcPeeringConnection]


class CreateVpcRequest(ServiceRequest):
    CidrBlock: Optional[String]
    AmazonProvidedIpv6CidrBlock: Optional[Boolean]
    Ipv6Pool: Optional[Ipv6PoolEc2Id]
    Ipv6CidrBlock: Optional[String]
    Ipv4IpamPoolId: Optional[IpamPoolId]
    Ipv4NetmaskLength: Optional[NetmaskLength]
    Ipv6IpamPoolId: Optional[IpamPoolId]
    Ipv6NetmaskLength: Optional[NetmaskLength]
    DryRun: Optional[Boolean]
    InstanceTenancy: Optional[Tenancy]
    Ipv6CidrBlockNetworkBorderGroup: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]


class CreateVpcResult(TypedDict, total=False):
    Vpc: Optional[Vpc]


class IKEVersionsRequestListValue(TypedDict, total=False):
    """The IKE version that is permitted for the VPN tunnel."""

    Value: Optional[String]


IKEVersionsRequestList = List[IKEVersionsRequestListValue]


class Phase2DHGroupNumbersRequestListValue(TypedDict, total=False):
    """Specifies a Diffie-Hellman group number for the VPN tunnel for phase 2
    IKE negotiations.
    """

    Value: Optional[Integer]


Phase2DHGroupNumbersRequestList = List[Phase2DHGroupNumbersRequestListValue]


class Phase1DHGroupNumbersRequestListValue(TypedDict, total=False):
    """Specifies a Diffie-Hellman group number for the VPN tunnel for phase 1
    IKE negotiations.
    """

    Value: Optional[Integer]


Phase1DHGroupNumbersRequestList = List[Phase1DHGroupNumbersRequestListValue]


class Phase2IntegrityAlgorithmsRequestListValue(TypedDict, total=False):
    """Specifies the integrity algorithm for the VPN tunnel for phase 2 IKE
    negotiations.
    """

    Value: Optional[String]


Phase2IntegrityAlgorithmsRequestList = List[Phase2IntegrityAlgorithmsRequestListValue]


class Phase1IntegrityAlgorithmsRequestListValue(TypedDict, total=False):
    """Specifies the integrity algorithm for the VPN tunnel for phase 1 IKE
    negotiations.
    """

    Value: Optional[String]


Phase1IntegrityAlgorithmsRequestList = List[Phase1IntegrityAlgorithmsRequestListValue]


class Phase2EncryptionAlgorithmsRequestListValue(TypedDict, total=False):
    """Specifies the encryption algorithm for the VPN tunnel for phase 2 IKE
    negotiations.
    """

    Value: Optional[String]


Phase2EncryptionAlgorithmsRequestList = List[Phase2EncryptionAlgorithmsRequestListValue]


class Phase1EncryptionAlgorithmsRequestListValue(TypedDict, total=False):
    """Specifies the encryption algorithm for the VPN tunnel for phase 1 IKE
    negotiations.
    """

    Value: Optional[String]


Phase1EncryptionAlgorithmsRequestList = List[Phase1EncryptionAlgorithmsRequestListValue]


class VpnTunnelOptionsSpecification(TypedDict, total=False):
    """The tunnel options for a single VPN tunnel."""

    TunnelInsideCidr: Optional[String]
    TunnelInsideIpv6Cidr: Optional[String]
    PreSharedKey: Optional[String]
    Phase1LifetimeSeconds: Optional[Integer]
    Phase2LifetimeSeconds: Optional[Integer]
    RekeyMarginTimeSeconds: Optional[Integer]
    RekeyFuzzPercentage: Optional[Integer]
    ReplayWindowSize: Optional[Integer]
    DPDTimeoutSeconds: Optional[Integer]
    DPDTimeoutAction: Optional[String]
    Phase1EncryptionAlgorithms: Optional[Phase1EncryptionAlgorithmsRequestList]
    Phase2EncryptionAlgorithms: Optional[Phase2EncryptionAlgorithmsRequestList]
    Phase1IntegrityAlgorithms: Optional[Phase1IntegrityAlgorithmsRequestList]
    Phase2IntegrityAlgorithms: Optional[Phase2IntegrityAlgorithmsRequestList]
    Phase1DHGroupNumbers: Optional[Phase1DHGroupNumbersRequestList]
    Phase2DHGroupNumbers: Optional[Phase2DHGroupNumbersRequestList]
    IKEVersions: Optional[IKEVersionsRequestList]
    StartupAction: Optional[String]


VpnTunnelOptionsSpecificationsList = List[VpnTunnelOptionsSpecification]


class VpnConnectionOptionsSpecification(TypedDict, total=False):
    """Describes VPN connection options."""

    EnableAcceleration: Optional[Boolean]
    StaticRoutesOnly: Optional[Boolean]
    TunnelInsideIpVersion: Optional[TunnelInsideIpVersion]
    TunnelOptions: Optional[VpnTunnelOptionsSpecificationsList]
    LocalIpv4NetworkCidr: Optional[String]
    RemoteIpv4NetworkCidr: Optional[String]
    LocalIpv6NetworkCidr: Optional[String]
    RemoteIpv6NetworkCidr: Optional[String]


class CreateVpnConnectionRequest(ServiceRequest):
    """Contains the parameters for CreateVpnConnection."""

    CustomerGatewayId: CustomerGatewayId
    Type: String
    VpnGatewayId: Optional[VpnGatewayId]
    TransitGatewayId: Optional[TransitGatewayId]
    DryRun: Optional[Boolean]
    Options: Optional[VpnConnectionOptionsSpecification]
    TagSpecifications: Optional[TagSpecificationList]


class VgwTelemetry(TypedDict, total=False):
    """Describes telemetry for a VPN tunnel."""

    AcceptedRouteCount: Optional[Integer]
    LastStatusChange: Optional[DateTime]
    OutsideIpAddress: Optional[String]
    Status: Optional[TelemetryStatus]
    StatusMessage: Optional[String]
    CertificateArn: Optional[String]


VgwTelemetryList = List[VgwTelemetry]


class VpnStaticRoute(TypedDict, total=False):
    """Describes a static route for a VPN connection."""

    DestinationCidrBlock: Optional[String]
    Source: Optional[VpnStaticRouteSource]
    State: Optional[VpnState]


VpnStaticRouteList = List[VpnStaticRoute]


class IKEVersionsListValue(TypedDict, total=False):
    """The internet key exchange (IKE) version permitted for the VPN tunnel."""

    Value: Optional[String]


IKEVersionsList = List[IKEVersionsListValue]


class Phase2DHGroupNumbersListValue(TypedDict, total=False):
    """The Diffie-Hellmann group number for phase 2 IKE negotiations."""

    Value: Optional[Integer]


Phase2DHGroupNumbersList = List[Phase2DHGroupNumbersListValue]


class Phase1DHGroupNumbersListValue(TypedDict, total=False):
    """The Diffie-Hellmann group number for phase 1 IKE negotiations."""

    Value: Optional[Integer]


Phase1DHGroupNumbersList = List[Phase1DHGroupNumbersListValue]


class Phase2IntegrityAlgorithmsListValue(TypedDict, total=False):
    """The integrity algorithm for phase 2 IKE negotiations."""

    Value: Optional[String]


Phase2IntegrityAlgorithmsList = List[Phase2IntegrityAlgorithmsListValue]


class Phase1IntegrityAlgorithmsListValue(TypedDict, total=False):
    """The integrity algorithm for phase 1 IKE negotiations."""

    Value: Optional[String]


Phase1IntegrityAlgorithmsList = List[Phase1IntegrityAlgorithmsListValue]


class Phase2EncryptionAlgorithmsListValue(TypedDict, total=False):
    """The encryption algorithm for phase 2 IKE negotiations."""

    Value: Optional[String]


Phase2EncryptionAlgorithmsList = List[Phase2EncryptionAlgorithmsListValue]


class Phase1EncryptionAlgorithmsListValue(TypedDict, total=False):
    """The encryption algorithm for phase 1 IKE negotiations."""

    Value: Optional[String]


Phase1EncryptionAlgorithmsList = List[Phase1EncryptionAlgorithmsListValue]


class TunnelOption(TypedDict, total=False):
    """The VPN tunnel options."""

    OutsideIpAddress: Optional[String]
    TunnelInsideCidr: Optional[String]
    TunnelInsideIpv6Cidr: Optional[String]
    PreSharedKey: Optional[String]
    Phase1LifetimeSeconds: Optional[Integer]
    Phase2LifetimeSeconds: Optional[Integer]
    RekeyMarginTimeSeconds: Optional[Integer]
    RekeyFuzzPercentage: Optional[Integer]
    ReplayWindowSize: Optional[Integer]
    DpdTimeoutSeconds: Optional[Integer]
    DpdTimeoutAction: Optional[String]
    Phase1EncryptionAlgorithms: Optional[Phase1EncryptionAlgorithmsList]
    Phase2EncryptionAlgorithms: Optional[Phase2EncryptionAlgorithmsList]
    Phase1IntegrityAlgorithms: Optional[Phase1IntegrityAlgorithmsList]
    Phase2IntegrityAlgorithms: Optional[Phase2IntegrityAlgorithmsList]
    Phase1DHGroupNumbers: Optional[Phase1DHGroupNumbersList]
    Phase2DHGroupNumbers: Optional[Phase2DHGroupNumbersList]
    IkeVersions: Optional[IKEVersionsList]
    StartupAction: Optional[String]


TunnelOptionsList = List[TunnelOption]


class VpnConnectionOptions(TypedDict, total=False):
    """Describes VPN connection options."""

    EnableAcceleration: Optional[Boolean]
    StaticRoutesOnly: Optional[Boolean]
    LocalIpv4NetworkCidr: Optional[String]
    RemoteIpv4NetworkCidr: Optional[String]
    LocalIpv6NetworkCidr: Optional[String]
    RemoteIpv6NetworkCidr: Optional[String]
    TunnelInsideIpVersion: Optional[TunnelInsideIpVersion]
    TunnelOptions: Optional[TunnelOptionsList]


class VpnConnection(TypedDict, total=False):
    """Describes a VPN connection."""

    CustomerGatewayConfiguration: Optional[String]
    CustomerGatewayId: Optional[String]
    Category: Optional[String]
    State: Optional[VpnState]
    Type: Optional[GatewayType]
    VpnConnectionId: Optional[String]
    VpnGatewayId: Optional[String]
    TransitGatewayId: Optional[String]
    CoreNetworkArn: Optional[String]
    CoreNetworkAttachmentArn: Optional[String]
    GatewayAssociationState: Optional[GatewayAssociationState]
    Options: Optional[VpnConnectionOptions]
    Routes: Optional[VpnStaticRouteList]
    Tags: Optional[TagList]
    VgwTelemetry: Optional[VgwTelemetryList]


class CreateVpnConnectionResult(TypedDict, total=False):
    """Contains the output of CreateVpnConnection."""

    VpnConnection: Optional[VpnConnection]


class CreateVpnConnectionRouteRequest(ServiceRequest):
    """Contains the parameters for CreateVpnConnectionRoute."""

    DestinationCidrBlock: String
    VpnConnectionId: VpnConnectionId


class CreateVpnGatewayRequest(ServiceRequest):
    """Contains the parameters for CreateVpnGateway."""

    AvailabilityZone: Optional[String]
    Type: GatewayType
    TagSpecifications: Optional[TagSpecificationList]
    AmazonSideAsn: Optional[Long]
    DryRun: Optional[Boolean]


VpcAttachmentList = List[VpcAttachment]


class VpnGateway(TypedDict, total=False):
    """Describes a virtual private gateway."""

    AvailabilityZone: Optional[String]
    State: Optional[VpnState]
    Type: Optional[GatewayType]
    VpcAttachments: Optional[VpcAttachmentList]
    VpnGatewayId: Optional[String]
    AmazonSideAsn: Optional[Long]
    Tags: Optional[TagList]


class CreateVpnGatewayResult(TypedDict, total=False):
    """Contains the output of CreateVpnGateway."""

    VpnGateway: Optional[VpnGateway]


CustomerGatewayIdStringList = List[CustomerGatewayId]
CustomerGatewayList = List[CustomerGateway]


class DeleteCarrierGatewayRequest(ServiceRequest):
    CarrierGatewayId: CarrierGatewayId
    DryRun: Optional[Boolean]


class DeleteCarrierGatewayResult(TypedDict, total=False):
    CarrierGateway: Optional[CarrierGateway]


class DeleteClientVpnEndpointRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    DryRun: Optional[Boolean]


class DeleteClientVpnEndpointResult(TypedDict, total=False):
    Status: Optional[ClientVpnEndpointStatus]


class DeleteClientVpnRouteRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    TargetVpcSubnetId: Optional[SubnetId]
    DestinationCidrBlock: String
    DryRun: Optional[Boolean]


class DeleteClientVpnRouteResult(TypedDict, total=False):
    Status: Optional[ClientVpnRouteStatus]


class DeleteCustomerGatewayRequest(ServiceRequest):
    """Contains the parameters for DeleteCustomerGateway."""

    CustomerGatewayId: CustomerGatewayId
    DryRun: Optional[Boolean]


class DeleteDhcpOptionsRequest(ServiceRequest):
    DhcpOptionsId: DhcpOptionsId
    DryRun: Optional[Boolean]


class DeleteEgressOnlyInternetGatewayRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    EgressOnlyInternetGatewayId: EgressOnlyInternetGatewayId


class DeleteEgressOnlyInternetGatewayResult(TypedDict, total=False):
    ReturnCode: Optional[Boolean]


class DeleteFleetError(TypedDict, total=False):
    """Describes an EC2 Fleet error."""

    Code: Optional[DeleteFleetErrorCode]
    Message: Optional[String]


class DeleteFleetErrorItem(TypedDict, total=False):
    """Describes an EC2 Fleet that was not successfully deleted."""

    Error: Optional[DeleteFleetError]
    FleetId: Optional[FleetId]


DeleteFleetErrorSet = List[DeleteFleetErrorItem]


class DeleteFleetSuccessItem(TypedDict, total=False):
    """Describes an EC2 Fleet that was successfully deleted."""

    CurrentFleetState: Optional[FleetStateCode]
    PreviousFleetState: Optional[FleetStateCode]
    FleetId: Optional[FleetId]


DeleteFleetSuccessSet = List[DeleteFleetSuccessItem]
FleetIdSet = List[FleetId]


class DeleteFleetsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    FleetIds: FleetIdSet
    TerminateInstances: Boolean


class DeleteFleetsResult(TypedDict, total=False):
    SuccessfulFleetDeletions: Optional[DeleteFleetSuccessSet]
    UnsuccessfulFleetDeletions: Optional[DeleteFleetErrorSet]


FlowLogIdList = List[VpcFlowLogId]


class DeleteFlowLogsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    FlowLogIds: FlowLogIdList


class DeleteFlowLogsResult(TypedDict, total=False):
    Unsuccessful: Optional[UnsuccessfulItemSet]


class DeleteFpgaImageRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    FpgaImageId: FpgaImageId


class DeleteFpgaImageResult(TypedDict, total=False):
    Return: Optional[Boolean]


class DeleteInstanceEventWindowRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ForceDelete: Optional[Boolean]
    InstanceEventWindowId: InstanceEventWindowId


class InstanceEventWindowStateChange(TypedDict, total=False):
    """The state of the event window."""

    InstanceEventWindowId: Optional[InstanceEventWindowId]
    State: Optional[InstanceEventWindowState]


class DeleteInstanceEventWindowResult(TypedDict, total=False):
    InstanceEventWindowState: Optional[InstanceEventWindowStateChange]


class DeleteInternetGatewayRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InternetGatewayId: InternetGatewayId


class DeleteIpamPoolRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamPoolId: IpamPoolId


class DeleteIpamPoolResult(TypedDict, total=False):
    IpamPool: Optional[IpamPool]


class DeleteIpamRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamId: IpamId


class DeleteIpamResult(TypedDict, total=False):
    Ipam: Optional[Ipam]


class DeleteIpamScopeRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamScopeId: IpamScopeId


class DeleteIpamScopeResult(TypedDict, total=False):
    IpamScope: Optional[IpamScope]


class DeleteKeyPairRequest(ServiceRequest):
    KeyName: Optional[KeyPairName]
    KeyPairId: Optional[KeyPairId]
    DryRun: Optional[Boolean]


class DeleteLaunchTemplateRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    LaunchTemplateId: Optional[LaunchTemplateId]
    LaunchTemplateName: Optional[LaunchTemplateName]


class DeleteLaunchTemplateResult(TypedDict, total=False):
    LaunchTemplate: Optional[LaunchTemplate]


VersionStringList = List[String]


class DeleteLaunchTemplateVersionsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    LaunchTemplateId: Optional[LaunchTemplateId]
    LaunchTemplateName: Optional[LaunchTemplateName]
    Versions: VersionStringList


class ResponseError(TypedDict, total=False):
    """Describes the error that's returned when you cannot delete a launch
    template version.
    """

    Code: Optional[LaunchTemplateErrorCode]
    Message: Optional[String]


class DeleteLaunchTemplateVersionsResponseErrorItem(TypedDict, total=False):
    """Describes a launch template version that could not be deleted."""

    LaunchTemplateId: Optional[String]
    LaunchTemplateName: Optional[String]
    VersionNumber: Optional[Long]
    ResponseError: Optional[ResponseError]


DeleteLaunchTemplateVersionsResponseErrorSet = List[DeleteLaunchTemplateVersionsResponseErrorItem]


class DeleteLaunchTemplateVersionsResponseSuccessItem(TypedDict, total=False):
    """Describes a launch template version that was successfully deleted."""

    LaunchTemplateId: Optional[String]
    LaunchTemplateName: Optional[String]
    VersionNumber: Optional[Long]


DeleteLaunchTemplateVersionsResponseSuccessSet = List[
    DeleteLaunchTemplateVersionsResponseSuccessItem
]


class DeleteLaunchTemplateVersionsResult(TypedDict, total=False):
    SuccessfullyDeletedLaunchTemplateVersions: Optional[
        DeleteLaunchTemplateVersionsResponseSuccessSet
    ]
    UnsuccessfullyDeletedLaunchTemplateVersions: Optional[
        DeleteLaunchTemplateVersionsResponseErrorSet
    ]


class DeleteLocalGatewayRouteRequest(ServiceRequest):
    DestinationCidrBlock: String
    LocalGatewayRouteTableId: LocalGatewayRoutetableId
    DryRun: Optional[Boolean]


class DeleteLocalGatewayRouteResult(TypedDict, total=False):
    Route: Optional[LocalGatewayRoute]


class DeleteLocalGatewayRouteTableVpcAssociationRequest(ServiceRequest):
    LocalGatewayRouteTableVpcAssociationId: LocalGatewayRouteTableVpcAssociationId
    DryRun: Optional[Boolean]


class DeleteLocalGatewayRouteTableVpcAssociationResult(TypedDict, total=False):
    LocalGatewayRouteTableVpcAssociation: Optional[LocalGatewayRouteTableVpcAssociation]


class DeleteManagedPrefixListRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PrefixListId: PrefixListResourceId


class DeleteManagedPrefixListResult(TypedDict, total=False):
    PrefixList: Optional[ManagedPrefixList]


class DeleteNatGatewayRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    NatGatewayId: NatGatewayId


class DeleteNatGatewayResult(TypedDict, total=False):
    NatGatewayId: Optional[String]


class DeleteNetworkAclEntryRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Egress: Boolean
    NetworkAclId: NetworkAclId
    RuleNumber: Integer


class DeleteNetworkAclRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    NetworkAclId: NetworkAclId


class DeleteNetworkInsightsAccessScopeAnalysisRequest(ServiceRequest):
    NetworkInsightsAccessScopeAnalysisId: NetworkInsightsAccessScopeAnalysisId
    DryRun: Optional[Boolean]


class DeleteNetworkInsightsAccessScopeAnalysisResult(TypedDict, total=False):
    NetworkInsightsAccessScopeAnalysisId: Optional[NetworkInsightsAccessScopeAnalysisId]


class DeleteNetworkInsightsAccessScopeRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    NetworkInsightsAccessScopeId: NetworkInsightsAccessScopeId


class DeleteNetworkInsightsAccessScopeResult(TypedDict, total=False):
    NetworkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]


class DeleteNetworkInsightsAnalysisRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    NetworkInsightsAnalysisId: NetworkInsightsAnalysisId


class DeleteNetworkInsightsAnalysisResult(TypedDict, total=False):
    NetworkInsightsAnalysisId: Optional[NetworkInsightsAnalysisId]


class DeleteNetworkInsightsPathRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    NetworkInsightsPathId: NetworkInsightsPathId


class DeleteNetworkInsightsPathResult(TypedDict, total=False):
    NetworkInsightsPathId: Optional[NetworkInsightsPathId]


class DeleteNetworkInterfacePermissionRequest(ServiceRequest):
    """Contains the parameters for DeleteNetworkInterfacePermission."""

    NetworkInterfacePermissionId: NetworkInterfacePermissionId
    Force: Optional[Boolean]
    DryRun: Optional[Boolean]


class DeleteNetworkInterfacePermissionResult(TypedDict, total=False):
    """Contains the output for DeleteNetworkInterfacePermission."""

    Return: Optional[Boolean]


class DeleteNetworkInterfaceRequest(ServiceRequest):
    """Contains the parameters for DeleteNetworkInterface."""

    DryRun: Optional[Boolean]
    NetworkInterfaceId: NetworkInterfaceId


class DeletePlacementGroupRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    GroupName: PlacementGroupName


class DeletePublicIpv4PoolRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PoolId: Ipv4PoolEc2Id


class DeletePublicIpv4PoolResult(TypedDict, total=False):
    ReturnValue: Optional[Boolean]


class DeleteQueuedReservedInstancesError(TypedDict, total=False):
    """Describes the error for a Reserved Instance whose queued purchase could
    not be deleted.
    """

    Code: Optional[DeleteQueuedReservedInstancesErrorCode]
    Message: Optional[String]


DeleteQueuedReservedInstancesIdList = List[ReservationId]


class DeleteQueuedReservedInstancesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ReservedInstancesIds: DeleteQueuedReservedInstancesIdList


class FailedQueuedPurchaseDeletion(TypedDict, total=False):
    """Describes a Reserved Instance whose queued purchase was not deleted."""

    Error: Optional[DeleteQueuedReservedInstancesError]
    ReservedInstancesId: Optional[String]


FailedQueuedPurchaseDeletionSet = List[FailedQueuedPurchaseDeletion]


class SuccessfulQueuedPurchaseDeletion(TypedDict, total=False):
    """Describes a Reserved Instance whose queued purchase was successfully
    deleted.
    """

    ReservedInstancesId: Optional[String]


SuccessfulQueuedPurchaseDeletionSet = List[SuccessfulQueuedPurchaseDeletion]


class DeleteQueuedReservedInstancesResult(TypedDict, total=False):
    SuccessfulQueuedPurchaseDeletions: Optional[SuccessfulQueuedPurchaseDeletionSet]
    FailedQueuedPurchaseDeletions: Optional[FailedQueuedPurchaseDeletionSet]


class DeleteRouteRequest(ServiceRequest):
    DestinationCidrBlock: Optional[String]
    DestinationIpv6CidrBlock: Optional[String]
    DestinationPrefixListId: Optional[PrefixListResourceId]
    DryRun: Optional[Boolean]
    RouteTableId: RouteTableId


class DeleteRouteTableRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    RouteTableId: RouteTableId


class DeleteSecurityGroupRequest(ServiceRequest):
    GroupId: Optional[SecurityGroupId]
    GroupName: Optional[SecurityGroupName]
    DryRun: Optional[Boolean]


class DeleteSnapshotRequest(ServiceRequest):
    SnapshotId: SnapshotId
    DryRun: Optional[Boolean]


class DeleteSpotDatafeedSubscriptionRequest(ServiceRequest):
    """Contains the parameters for DeleteSpotDatafeedSubscription."""

    DryRun: Optional[Boolean]


class DeleteSubnetCidrReservationRequest(ServiceRequest):
    SubnetCidrReservationId: SubnetCidrReservationId
    DryRun: Optional[Boolean]


class DeleteSubnetCidrReservationResult(TypedDict, total=False):
    DeletedSubnetCidrReservation: Optional[SubnetCidrReservation]


class DeleteSubnetRequest(ServiceRequest):
    SubnetId: SubnetId
    DryRun: Optional[Boolean]


class DeleteTagsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Resources: ResourceIdList
    Tags: Optional[TagList]


class DeleteTrafficMirrorFilterRequest(ServiceRequest):
    TrafficMirrorFilterId: TrafficMirrorFilterId
    DryRun: Optional[Boolean]


class DeleteTrafficMirrorFilterResult(TypedDict, total=False):
    TrafficMirrorFilterId: Optional[String]


class DeleteTrafficMirrorFilterRuleRequest(ServiceRequest):
    TrafficMirrorFilterRuleId: TrafficMirrorFilterRuleId
    DryRun: Optional[Boolean]


class DeleteTrafficMirrorFilterRuleResult(TypedDict, total=False):
    TrafficMirrorFilterRuleId: Optional[String]


class DeleteTrafficMirrorSessionRequest(ServiceRequest):
    TrafficMirrorSessionId: TrafficMirrorSessionId
    DryRun: Optional[Boolean]


class DeleteTrafficMirrorSessionResult(TypedDict, total=False):
    TrafficMirrorSessionId: Optional[String]


class DeleteTrafficMirrorTargetRequest(ServiceRequest):
    TrafficMirrorTargetId: TrafficMirrorTargetId
    DryRun: Optional[Boolean]


class DeleteTrafficMirrorTargetResult(TypedDict, total=False):
    TrafficMirrorTargetId: Optional[String]


class DeleteTransitGatewayConnectPeerRequest(ServiceRequest):
    TransitGatewayConnectPeerId: TransitGatewayConnectPeerId
    DryRun: Optional[Boolean]


class DeleteTransitGatewayConnectPeerResult(TypedDict, total=False):
    TransitGatewayConnectPeer: Optional[TransitGatewayConnectPeer]


class DeleteTransitGatewayConnectRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class DeleteTransitGatewayConnectResult(TypedDict, total=False):
    TransitGatewayConnect: Optional[TransitGatewayConnect]


class DeleteTransitGatewayMulticastDomainRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: TransitGatewayMulticastDomainId
    DryRun: Optional[Boolean]


class DeleteTransitGatewayMulticastDomainResult(TypedDict, total=False):
    TransitGatewayMulticastDomain: Optional[TransitGatewayMulticastDomain]


class DeleteTransitGatewayPeeringAttachmentRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class DeleteTransitGatewayPeeringAttachmentResult(TypedDict, total=False):
    TransitGatewayPeeringAttachment: Optional[TransitGatewayPeeringAttachment]


class DeleteTransitGatewayPrefixListReferenceRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    PrefixListId: PrefixListResourceId
    DryRun: Optional[Boolean]


class DeleteTransitGatewayPrefixListReferenceResult(TypedDict, total=False):
    TransitGatewayPrefixListReference: Optional[TransitGatewayPrefixListReference]


class DeleteTransitGatewayRequest(ServiceRequest):
    TransitGatewayId: TransitGatewayId
    DryRun: Optional[Boolean]


class DeleteTransitGatewayResult(TypedDict, total=False):
    TransitGateway: Optional[TransitGateway]


class DeleteTransitGatewayRouteRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    DestinationCidrBlock: String
    DryRun: Optional[Boolean]


class DeleteTransitGatewayRouteResult(TypedDict, total=False):
    Route: Optional[TransitGatewayRoute]


class DeleteTransitGatewayRouteTableRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    DryRun: Optional[Boolean]


class DeleteTransitGatewayRouteTableResult(TypedDict, total=False):
    TransitGatewayRouteTable: Optional[TransitGatewayRouteTable]


class DeleteTransitGatewayVpcAttachmentRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class DeleteTransitGatewayVpcAttachmentResult(TypedDict, total=False):
    TransitGatewayVpcAttachment: Optional[TransitGatewayVpcAttachment]


class DeleteVolumeRequest(ServiceRequest):
    VolumeId: VolumeId
    DryRun: Optional[Boolean]


class DeleteVpcEndpointConnectionNotificationsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ConnectionNotificationIds: ConnectionNotificationIdsList


class DeleteVpcEndpointConnectionNotificationsResult(TypedDict, total=False):
    Unsuccessful: Optional[UnsuccessfulItemSet]


VpcEndpointServiceIdList = List[VpcEndpointServiceId]


class DeleteVpcEndpointServiceConfigurationsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceIds: VpcEndpointServiceIdList


class DeleteVpcEndpointServiceConfigurationsResult(TypedDict, total=False):
    Unsuccessful: Optional[UnsuccessfulItemSet]


class DeleteVpcEndpointsRequest(ServiceRequest):
    """Contains the parameters for DeleteVpcEndpoints."""

    DryRun: Optional[Boolean]
    VpcEndpointIds: VpcEndpointIdList


class DeleteVpcEndpointsResult(TypedDict, total=False):
    """Contains the output of DeleteVpcEndpoints."""

    Unsuccessful: Optional[UnsuccessfulItemSet]


class DeleteVpcPeeringConnectionRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VpcPeeringConnectionId: VpcPeeringConnectionId


class DeleteVpcPeeringConnectionResult(TypedDict, total=False):
    Return: Optional[Boolean]


class DeleteVpcRequest(ServiceRequest):
    VpcId: VpcId
    DryRun: Optional[Boolean]


class DeleteVpnConnectionRequest(ServiceRequest):
    """Contains the parameters for DeleteVpnConnection."""

    VpnConnectionId: VpnConnectionId
    DryRun: Optional[Boolean]


class DeleteVpnConnectionRouteRequest(ServiceRequest):
    """Contains the parameters for DeleteVpnConnectionRoute."""

    DestinationCidrBlock: String
    VpnConnectionId: VpnConnectionId


class DeleteVpnGatewayRequest(ServiceRequest):
    """Contains the parameters for DeleteVpnGateway."""

    VpnGatewayId: VpnGatewayId
    DryRun: Optional[Boolean]


class DeprovisionByoipCidrRequest(ServiceRequest):
    Cidr: String
    DryRun: Optional[Boolean]


class DeprovisionByoipCidrResult(TypedDict, total=False):
    ByoipCidr: Optional[ByoipCidr]


class DeprovisionIpamPoolCidrRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamPoolId: IpamPoolId
    Cidr: Optional[String]


class IpamPoolCidrFailureReason(TypedDict, total=False):
    """Details related to why an IPAM pool CIDR failed to be provisioned."""

    Code: Optional[IpamPoolCidrFailureCode]
    Message: Optional[String]


class IpamPoolCidr(TypedDict, total=False):
    """A CIDR provisioned to an IPAM pool."""

    Cidr: Optional[String]
    State: Optional[IpamPoolCidrState]
    FailureReason: Optional[IpamPoolCidrFailureReason]


class DeprovisionIpamPoolCidrResult(TypedDict, total=False):
    IpamPoolCidr: Optional[IpamPoolCidr]


class DeprovisionPublicIpv4PoolCidrRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PoolId: Ipv4PoolEc2Id
    Cidr: String


DeprovisionedAddressSet = List[String]


class DeprovisionPublicIpv4PoolCidrResult(TypedDict, total=False):
    PoolId: Optional[Ipv4PoolEc2Id]
    DeprovisionedAddresses: Optional[DeprovisionedAddressSet]


class DeregisterImageRequest(ServiceRequest):
    """Contains the parameters for DeregisterImage."""

    ImageId: ImageId
    DryRun: Optional[Boolean]


InstanceTagKeySet = List[String]


class DeregisterInstanceTagAttributeRequest(TypedDict, total=False):
    """Information about the tag keys to deregister for the current Region. You
    can either specify individual tag keys or deregister all tag keys in the
    current Region. You must specify either ``IncludeAllTagsOfInstance`` or
    ``InstanceTagKeys`` in the request
    """

    IncludeAllTagsOfInstance: Optional[Boolean]
    InstanceTagKeys: Optional[InstanceTagKeySet]


class DeregisterInstanceEventNotificationAttributesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceTagAttribute: Optional[DeregisterInstanceTagAttributeRequest]


class InstanceTagNotificationAttribute(TypedDict, total=False):
    """Describes the registered tag keys for the current Region."""

    InstanceTagKeys: Optional[InstanceTagKeySet]
    IncludeAllTagsOfInstance: Optional[Boolean]


class DeregisterInstanceEventNotificationAttributesResult(TypedDict, total=False):
    InstanceTagAttribute: Optional[InstanceTagNotificationAttribute]


TransitGatewayNetworkInterfaceIdList = List[NetworkInterfaceId]


class DeregisterTransitGatewayMulticastGroupMembersRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    GroupIpAddress: Optional[String]
    NetworkInterfaceIds: Optional[TransitGatewayNetworkInterfaceIdList]
    DryRun: Optional[Boolean]


class TransitGatewayMulticastDeregisteredGroupMembers(TypedDict, total=False):
    """Describes the deregistered transit gateway multicast group members."""

    TransitGatewayMulticastDomainId: Optional[String]
    DeregisteredNetworkInterfaceIds: Optional[ValueStringList]
    GroupIpAddress: Optional[String]


class DeregisterTransitGatewayMulticastGroupMembersResult(TypedDict, total=False):
    DeregisteredMulticastGroupMembers: Optional[TransitGatewayMulticastDeregisteredGroupMembers]


class DeregisterTransitGatewayMulticastGroupSourcesRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    GroupIpAddress: Optional[String]
    NetworkInterfaceIds: Optional[TransitGatewayNetworkInterfaceIdList]
    DryRun: Optional[Boolean]


class TransitGatewayMulticastDeregisteredGroupSources(TypedDict, total=False):
    """Describes the deregistered transit gateway multicast group sources."""

    TransitGatewayMulticastDomainId: Optional[String]
    DeregisteredNetworkInterfaceIds: Optional[ValueStringList]
    GroupIpAddress: Optional[String]


class DeregisterTransitGatewayMulticastGroupSourcesResult(TypedDict, total=False):
    DeregisteredMulticastGroupSources: Optional[TransitGatewayMulticastDeregisteredGroupSources]


class DescribeAccountAttributesRequest(ServiceRequest):
    AttributeNames: Optional[AccountAttributeNameStringList]
    DryRun: Optional[Boolean]


class DescribeAccountAttributesResult(TypedDict, total=False):
    AccountAttributes: Optional[AccountAttributeList]


class DescribeAddressesAttributeRequest(ServiceRequest):
    AllocationIds: Optional[AllocationIds]
    Attribute: Optional[AddressAttributeName]
    NextToken: Optional[NextToken]
    MaxResults: Optional[AddressMaxResults]
    DryRun: Optional[Boolean]


class DescribeAddressesAttributeResult(TypedDict, total=False):
    Addresses: Optional[AddressSet]
    NextToken: Optional[NextToken]


PublicIpStringList = List[String]


class Filter(TypedDict, total=False):
    """A filter name and value pair that is used to return a more specific list
    of results from a describe operation. Filters can be used to match a set
    of resources by specific criteria, such as tags, attributes, or IDs.

    If you specify multiple filters, the filters are joined with an ``AND``,
    and the request returns only results that match all of the specified
    filters.
    """

    Name: Optional[String]
    Values: Optional[ValueStringList]


FilterList = List[Filter]


class DescribeAddressesRequest(ServiceRequest):
    Filters: Optional[FilterList]
    PublicIps: Optional[PublicIpStringList]
    AllocationIds: Optional[AllocationIdList]
    DryRun: Optional[Boolean]


class DescribeAddressesResult(TypedDict, total=False):
    Addresses: Optional[AddressList]


class DescribeAggregateIdFormatRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class IdFormat(TypedDict, total=False):
    """Describes the ID format for a resource."""

    Deadline: Optional[DateTime]
    Resource: Optional[String]
    UseLongIds: Optional[Boolean]


IdFormatList = List[IdFormat]


class DescribeAggregateIdFormatResult(TypedDict, total=False):
    UseLongIdsAggregated: Optional[Boolean]
    Statuses: Optional[IdFormatList]


ZoneIdStringList = List[String]
ZoneNameStringList = List[String]


class DescribeAvailabilityZonesRequest(ServiceRequest):
    Filters: Optional[FilterList]
    ZoneNames: Optional[ZoneNameStringList]
    ZoneIds: Optional[ZoneIdStringList]
    AllAvailabilityZones: Optional[Boolean]
    DryRun: Optional[Boolean]


class DescribeAvailabilityZonesResult(TypedDict, total=False):
    AvailabilityZones: Optional[AvailabilityZoneList]


class DescribeBundleTasksRequest(ServiceRequest):
    BundleIds: Optional[BundleIdStringList]
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]


class DescribeBundleTasksResult(TypedDict, total=False):
    BundleTasks: Optional[BundleTaskList]


class DescribeByoipCidrsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    MaxResults: DescribeByoipCidrsMaxResults
    NextToken: Optional[NextToken]


class DescribeByoipCidrsResult(TypedDict, total=False):
    ByoipCidrs: Optional[ByoipCidrSet]
    NextToken: Optional[String]


class DescribeCapacityReservationFleetsRequest(ServiceRequest):
    CapacityReservationFleetIds: Optional[CapacityReservationFleetIdSet]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeCapacityReservationFleetsMaxResults]
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]


class DescribeCapacityReservationFleetsResult(TypedDict, total=False):
    CapacityReservationFleets: Optional[CapacityReservationFleetSet]
    NextToken: Optional[String]


class DescribeCapacityReservationsRequest(ServiceRequest):
    CapacityReservationIds: Optional[CapacityReservationIdSet]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeCapacityReservationsMaxResults]
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]


class DescribeCapacityReservationsResult(TypedDict, total=False):
    NextToken: Optional[String]
    CapacityReservations: Optional[CapacityReservationSet]


class DescribeCarrierGatewaysRequest(ServiceRequest):
    CarrierGatewayIds: Optional[CarrierGatewayIdSet]
    Filters: Optional[FilterList]
    MaxResults: Optional[CarrierGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class DescribeCarrierGatewaysResult(TypedDict, total=False):
    CarrierGateways: Optional[CarrierGatewaySet]
    NextToken: Optional[String]


InstanceIdStringList = List[InstanceId]


class DescribeClassicLinkInstancesRequest(ServiceRequest):
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    InstanceIds: Optional[InstanceIdStringList]
    MaxResults: Optional[DescribeClassicLinkInstancesMaxResults]
    NextToken: Optional[String]


class DescribeClassicLinkInstancesResult(TypedDict, total=False):
    Instances: Optional[ClassicLinkInstanceList]
    NextToken: Optional[String]


class DescribeClientVpnAuthorizationRulesRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    DryRun: Optional[Boolean]
    NextToken: Optional[NextToken]
    Filters: Optional[FilterList]
    MaxResults: Optional[DescribeClientVpnAuthorizationRulesMaxResults]


class DescribeClientVpnAuthorizationRulesResult(TypedDict, total=False):
    AuthorizationRules: Optional[AuthorizationRuleSet]
    NextToken: Optional[NextToken]


class DescribeClientVpnConnectionsRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    Filters: Optional[FilterList]
    NextToken: Optional[NextToken]
    MaxResults: Optional[DescribeClientVpnConnectionsMaxResults]
    DryRun: Optional[Boolean]


class DescribeClientVpnConnectionsResult(TypedDict, total=False):
    Connections: Optional[ClientVpnConnectionSet]
    NextToken: Optional[NextToken]


class DescribeClientVpnEndpointsRequest(ServiceRequest):
    ClientVpnEndpointIds: Optional[ClientVpnEndpointIdList]
    MaxResults: Optional[DescribeClientVpnEndpointMaxResults]
    NextToken: Optional[NextToken]
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]


EndpointSet = List[ClientVpnEndpoint]


class DescribeClientVpnEndpointsResult(TypedDict, total=False):
    ClientVpnEndpoints: Optional[EndpointSet]
    NextToken: Optional[NextToken]


class DescribeClientVpnRoutesRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    Filters: Optional[FilterList]
    MaxResults: Optional[DescribeClientVpnRoutesMaxResults]
    NextToken: Optional[NextToken]
    DryRun: Optional[Boolean]


class DescribeClientVpnRoutesResult(TypedDict, total=False):
    Routes: Optional[ClientVpnRouteSet]
    NextToken: Optional[NextToken]


class DescribeClientVpnTargetNetworksRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    AssociationIds: Optional[ValueStringList]
    MaxResults: Optional[DescribeClientVpnTargetNetworksMaxResults]
    NextToken: Optional[NextToken]
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]


class TargetNetwork(TypedDict, total=False):
    """Describes a target network associated with a Client VPN endpoint."""

    AssociationId: Optional[String]
    VpcId: Optional[String]
    TargetNetworkId: Optional[String]
    ClientVpnEndpointId: Optional[String]
    Status: Optional[AssociationStatus]
    SecurityGroups: Optional[ValueStringList]


TargetNetworkSet = List[TargetNetwork]


class DescribeClientVpnTargetNetworksResult(TypedDict, total=False):
    ClientVpnTargetNetworks: Optional[TargetNetworkSet]
    NextToken: Optional[NextToken]


class DescribeCoipPoolsRequest(ServiceRequest):
    PoolIds: Optional[CoipPoolIdSet]
    Filters: Optional[FilterList]
    MaxResults: Optional[CoipPoolMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class DescribeCoipPoolsResult(TypedDict, total=False):
    CoipPools: Optional[CoipPoolSet]
    NextToken: Optional[String]


DescribeConversionTaskList = List[ConversionTask]


class DescribeConversionTasksRequest(ServiceRequest):
    ConversionTaskIds: Optional[ConversionIdStringList]
    DryRun: Optional[Boolean]


class DescribeConversionTasksResult(TypedDict, total=False):
    ConversionTasks: Optional[DescribeConversionTaskList]


class DescribeCustomerGatewaysRequest(ServiceRequest):
    """Contains the parameters for DescribeCustomerGateways."""

    CustomerGatewayIds: Optional[CustomerGatewayIdStringList]
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]


class DescribeCustomerGatewaysResult(TypedDict, total=False):
    """Contains the output of DescribeCustomerGateways."""

    CustomerGateways: Optional[CustomerGatewayList]


DhcpOptionsIdStringList = List[DhcpOptionsId]


class DescribeDhcpOptionsRequest(ServiceRequest):
    DhcpOptionsIds: Optional[DhcpOptionsIdStringList]
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeDhcpOptionsMaxResults]


DhcpOptionsList = List[DhcpOptions]


class DescribeDhcpOptionsResult(TypedDict, total=False):
    DhcpOptions: Optional[DhcpOptionsList]
    NextToken: Optional[String]


EgressOnlyInternetGatewayIdList = List[EgressOnlyInternetGatewayId]


class DescribeEgressOnlyInternetGatewaysRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    EgressOnlyInternetGatewayIds: Optional[EgressOnlyInternetGatewayIdList]
    MaxResults: Optional[DescribeEgressOnlyInternetGatewaysMaxResults]
    NextToken: Optional[String]
    Filters: Optional[FilterList]


EgressOnlyInternetGatewayList = List[EgressOnlyInternetGateway]


class DescribeEgressOnlyInternetGatewaysResult(TypedDict, total=False):
    EgressOnlyInternetGateways: Optional[EgressOnlyInternetGatewayList]
    NextToken: Optional[String]


ElasticGpuIdSet = List[ElasticGpuId]


class DescribeElasticGpusRequest(ServiceRequest):
    ElasticGpuIds: Optional[ElasticGpuIdSet]
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[DescribeElasticGpusMaxResults]
    NextToken: Optional[String]


class ElasticGpuHealth(TypedDict, total=False):
    """Describes the status of an Elastic Graphics accelerator."""

    Status: Optional[ElasticGpuStatus]


class ElasticGpus(TypedDict, total=False):
    """Describes an Elastic Graphics accelerator."""

    ElasticGpuId: Optional[String]
    AvailabilityZone: Optional[String]
    ElasticGpuType: Optional[String]
    ElasticGpuHealth: Optional[ElasticGpuHealth]
    ElasticGpuState: Optional[ElasticGpuState]
    InstanceId: Optional[String]
    Tags: Optional[TagList]


ElasticGpuSet = List[ElasticGpus]


class DescribeElasticGpusResult(TypedDict, total=False):
    ElasticGpuSet: Optional[ElasticGpuSet]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


ExportImageTaskIdList = List[ExportImageTaskId]


class DescribeExportImageTasksRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    ExportImageTaskIds: Optional[ExportImageTaskIdList]
    MaxResults: Optional[DescribeExportImageTasksMaxResults]
    NextToken: Optional[NextToken]


class ExportTaskS3Location(TypedDict, total=False):
    """Describes the destination for an export image task."""

    S3Bucket: Optional[String]
    S3Prefix: Optional[String]


class ExportImageTask(TypedDict, total=False):
    """Describes an export image task."""

    Description: Optional[String]
    ExportImageTaskId: Optional[String]
    ImageId: Optional[String]
    Progress: Optional[String]
    S3ExportLocation: Optional[ExportTaskS3Location]
    Status: Optional[String]
    StatusMessage: Optional[String]
    Tags: Optional[TagList]


ExportImageTaskList = List[ExportImageTask]


class DescribeExportImageTasksResult(TypedDict, total=False):
    ExportImageTasks: Optional[ExportImageTaskList]
    NextToken: Optional[NextToken]


ExportTaskIdStringList = List[ExportTaskId]


class DescribeExportTasksRequest(ServiceRequest):
    ExportTaskIds: Optional[ExportTaskIdStringList]
    Filters: Optional[FilterList]


ExportTaskList = List[ExportTask]


class DescribeExportTasksResult(TypedDict, total=False):
    ExportTasks: Optional[ExportTaskList]


FastLaunchImageIdList = List[ImageId]


class DescribeFastLaunchImagesRequest(ServiceRequest):
    ImageIds: Optional[FastLaunchImageIdList]
    Filters: Optional[FilterList]
    MaxResults: Optional[DescribeFastLaunchImagesRequestMaxResults]
    NextToken: Optional[NextToken]
    DryRun: Optional[Boolean]


class FastLaunchLaunchTemplateSpecificationResponse(TypedDict, total=False):
    """Identifies the launch template to use for faster launching of the
    Windows AMI.
    """

    LaunchTemplateId: Optional[LaunchTemplateId]
    LaunchTemplateName: Optional[String]
    Version: Optional[String]


class FastLaunchSnapshotConfigurationResponse(TypedDict, total=False):
    """Configuration settings for creating and managing pre-provisioned
    snapshots for a fast-launch enabled Windows AMI.
    """

    TargetResourceCount: Optional[Integer]


class DescribeFastLaunchImagesSuccessItem(TypedDict, total=False):
    """Describe details about a fast-launch enabled Windows image that meets
    the requested criteria. Criteria are defined by the
    ``DescribeFastLaunchImages`` action filters.
    """

    ImageId: Optional[ImageId]
    ResourceType: Optional[FastLaunchResourceType]
    SnapshotConfiguration: Optional[FastLaunchSnapshotConfigurationResponse]
    LaunchTemplate: Optional[FastLaunchLaunchTemplateSpecificationResponse]
    MaxParallelLaunches: Optional[Integer]
    OwnerId: Optional[String]
    State: Optional[FastLaunchStateCode]
    StateTransitionReason: Optional[String]
    StateTransitionTime: Optional[MillisecondDateTime]


DescribeFastLaunchImagesSuccessSet = List[DescribeFastLaunchImagesSuccessItem]


class DescribeFastLaunchImagesResult(TypedDict, total=False):
    FastLaunchImages: Optional[DescribeFastLaunchImagesSuccessSet]
    NextToken: Optional[NextToken]


class DescribeFastSnapshotRestoreSuccessItem(TypedDict, total=False):
    """Describes fast snapshot restores for a snapshot."""

    SnapshotId: Optional[String]
    AvailabilityZone: Optional[String]
    State: Optional[FastSnapshotRestoreStateCode]
    StateTransitionReason: Optional[String]
    OwnerId: Optional[String]
    OwnerAlias: Optional[String]
    EnablingTime: Optional[MillisecondDateTime]
    OptimizingTime: Optional[MillisecondDateTime]
    EnabledTime: Optional[MillisecondDateTime]
    DisablingTime: Optional[MillisecondDateTime]
    DisabledTime: Optional[MillisecondDateTime]


DescribeFastSnapshotRestoreSuccessSet = List[DescribeFastSnapshotRestoreSuccessItem]


class DescribeFastSnapshotRestoresRequest(ServiceRequest):
    Filters: Optional[FilterList]
    MaxResults: Optional[DescribeFastSnapshotRestoresMaxResults]
    NextToken: Optional[NextToken]
    DryRun: Optional[Boolean]


class DescribeFastSnapshotRestoresResult(TypedDict, total=False):
    FastSnapshotRestores: Optional[DescribeFastSnapshotRestoreSuccessSet]
    NextToken: Optional[NextToken]


class DescribeFleetError(TypedDict, total=False):
    """Describes the instances that could not be launched by the fleet."""

    LaunchTemplateAndOverrides: Optional[LaunchTemplateAndOverridesResponse]
    Lifecycle: Optional[InstanceLifecycle]
    ErrorCode: Optional[String]
    ErrorMessage: Optional[String]


class DescribeFleetHistoryRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    EventType: Optional[FleetEventType]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    FleetId: FleetId
    StartTime: DateTime


class EventInformation(TypedDict, total=False):
    """Describes an EC2 Fleet or Spot Fleet event."""

    EventDescription: Optional[String]
    EventSubType: Optional[String]
    InstanceId: Optional[String]


class HistoryRecordEntry(TypedDict, total=False):
    """Describes an event in the history of an EC2 Fleet."""

    EventInformation: Optional[EventInformation]
    EventType: Optional[FleetEventType]
    Timestamp: Optional[DateTime]


HistoryRecordSet = List[HistoryRecordEntry]


class DescribeFleetHistoryResult(TypedDict, total=False):
    HistoryRecords: Optional[HistoryRecordSet]
    LastEvaluatedTime: Optional[DateTime]
    NextToken: Optional[String]
    FleetId: Optional[FleetId]
    StartTime: Optional[DateTime]


class DescribeFleetInstancesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    FleetId: FleetId
    Filters: Optional[FilterList]


class DescribeFleetInstancesResult(TypedDict, total=False):
    ActiveInstances: Optional[ActiveInstanceSet]
    NextToken: Optional[String]
    FleetId: Optional[FleetId]


DescribeFleetsErrorSet = List[DescribeFleetError]


class DescribeFleetsInstances(TypedDict, total=False):
    """Describes the instances that were launched by the fleet."""

    LaunchTemplateAndOverrides: Optional[LaunchTemplateAndOverridesResponse]
    Lifecycle: Optional[InstanceLifecycle]
    InstanceIds: Optional[InstanceIdsSet]
    InstanceType: Optional[InstanceType]
    Platform: Optional[PlatformValues]


DescribeFleetsInstancesSet = List[DescribeFleetsInstances]


class DescribeFleetsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    FleetIds: Optional[FleetIdSet]
    Filters: Optional[FilterList]


class OnDemandOptions(TypedDict, total=False):
    """Describes the configuration of On-Demand Instances in an EC2 Fleet."""

    AllocationStrategy: Optional[FleetOnDemandAllocationStrategy]
    CapacityReservationOptions: Optional[CapacityReservationOptions]
    SingleInstanceType: Optional[Boolean]
    SingleAvailabilityZone: Optional[Boolean]
    MinTargetCapacity: Optional[Integer]
    MaxTotalPrice: Optional[String]


class FleetSpotCapacityRebalance(TypedDict, total=False):
    """The strategy to use when Amazon EC2 emits a signal that your Spot
    Instance is at an elevated risk of being interrupted.
    """

    ReplacementStrategy: Optional[FleetReplacementStrategy]
    TerminationDelay: Optional[Integer]


class FleetSpotMaintenanceStrategies(TypedDict, total=False):
    """The strategies for managing your Spot Instances that are at an elevated
    risk of being interrupted.
    """

    CapacityRebalance: Optional[FleetSpotCapacityRebalance]


class SpotOptions(TypedDict, total=False):
    """Describes the configuration of Spot Instances in an EC2 Fleet."""

    AllocationStrategy: Optional[SpotAllocationStrategy]
    MaintenanceStrategies: Optional[FleetSpotMaintenanceStrategies]
    InstanceInterruptionBehavior: Optional[SpotInstanceInterruptionBehavior]
    InstancePoolsToUseCount: Optional[Integer]
    SingleInstanceType: Optional[Boolean]
    SingleAvailabilityZone: Optional[Boolean]
    MinTargetCapacity: Optional[Integer]
    MaxTotalPrice: Optional[String]


class TargetCapacitySpecification(TypedDict, total=False):
    """The number of units to request. You can choose to set the target
    capacity in terms of instances or a performance characteristic that is
    important to your application workload, such as vCPUs, memory, or I/O.
    If the request type is ``maintain``, you can specify a target capacity
    of 0 and add capacity later.

    You can use the On-Demand Instance ``MaxTotalPrice`` parameter, the Spot
    Instance ``MaxTotalPrice``, or both to ensure that your fleet cost does
    not exceed your budget. If you set a maximum price per hour for the
    On-Demand Instances and Spot Instances in your request, EC2 Fleet will
    launch instances until it reaches the maximum amount that you're willing
    to pay. When the maximum amount you're willing to pay is reached, the
    fleet stops launching instances even if it hasn’t met the target
    capacity. The ``MaxTotalPrice`` parameters are located in
    `OnDemandOptions <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_OnDemandOptions.html>`__
    and
    `SpotOptions <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SpotOptions>`__.
    """

    TotalTargetCapacity: Optional[Integer]
    OnDemandTargetCapacity: Optional[Integer]
    SpotTargetCapacity: Optional[Integer]
    DefaultTargetCapacityType: Optional[DefaultTargetCapacityType]
    TargetCapacityUnitType: Optional[TargetCapacityUnitType]


FleetLaunchTemplateOverridesList = List[FleetLaunchTemplateOverrides]


class FleetLaunchTemplateConfig(TypedDict, total=False):
    """Describes a launch template and overrides."""

    LaunchTemplateSpecification: Optional[FleetLaunchTemplateSpecification]
    Overrides: Optional[FleetLaunchTemplateOverridesList]


FleetLaunchTemplateConfigList = List[FleetLaunchTemplateConfig]


class FleetData(TypedDict, total=False):
    """Describes an EC2 Fleet."""

    ActivityStatus: Optional[FleetActivityStatus]
    CreateTime: Optional[DateTime]
    FleetId: Optional[FleetId]
    FleetState: Optional[FleetStateCode]
    ClientToken: Optional[String]
    ExcessCapacityTerminationPolicy: Optional[FleetExcessCapacityTerminationPolicy]
    FulfilledCapacity: Optional[Double]
    FulfilledOnDemandCapacity: Optional[Double]
    LaunchTemplateConfigs: Optional[FleetLaunchTemplateConfigList]
    TargetCapacitySpecification: Optional[TargetCapacitySpecification]
    TerminateInstancesWithExpiration: Optional[Boolean]
    Type: Optional[FleetType]
    ValidFrom: Optional[DateTime]
    ValidUntil: Optional[DateTime]
    ReplaceUnhealthyInstances: Optional[Boolean]
    SpotOptions: Optional[SpotOptions]
    OnDemandOptions: Optional[OnDemandOptions]
    Tags: Optional[TagList]
    Errors: Optional[DescribeFleetsErrorSet]
    Instances: Optional[DescribeFleetsInstancesSet]
    Context: Optional[String]


FleetSet = List[FleetData]


class DescribeFleetsResult(TypedDict, total=False):
    NextToken: Optional[String]
    Fleets: Optional[FleetSet]


class DescribeFlowLogsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filter: Optional[FilterList]
    FlowLogIds: Optional[FlowLogIdList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class DestinationOptionsResponse(TypedDict, total=False):
    """Describes the destination options for a flow log."""

    FileFormat: Optional[DestinationFileFormat]
    HiveCompatiblePartitions: Optional[Boolean]
    PerHourPartition: Optional[Boolean]


class FlowLog(TypedDict, total=False):
    """Describes a flow log."""

    CreationTime: Optional[MillisecondDateTime]
    DeliverLogsErrorMessage: Optional[String]
    DeliverLogsPermissionArn: Optional[String]
    DeliverLogsStatus: Optional[String]
    FlowLogId: Optional[String]
    FlowLogStatus: Optional[String]
    LogGroupName: Optional[String]
    ResourceId: Optional[String]
    TrafficType: Optional[TrafficType]
    LogDestinationType: Optional[LogDestinationType]
    LogDestination: Optional[String]
    LogFormat: Optional[String]
    Tags: Optional[TagList]
    MaxAggregationInterval: Optional[Integer]
    DestinationOptions: Optional[DestinationOptionsResponse]


FlowLogSet = List[FlowLog]


class DescribeFlowLogsResult(TypedDict, total=False):
    FlowLogs: Optional[FlowLogSet]
    NextToken: Optional[String]


class DescribeFpgaImageAttributeRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    FpgaImageId: FpgaImageId
    Attribute: FpgaImageAttributeName


class ProductCode(TypedDict, total=False):
    """Describes a product code."""

    ProductCodeId: Optional[String]
    ProductCodeType: Optional[ProductCodeValues]


ProductCodeList = List[ProductCode]


class LoadPermission(TypedDict, total=False):
    """Describes a load permission."""

    UserId: Optional[String]
    Group: Optional[PermissionGroup]


LoadPermissionList = List[LoadPermission]


class FpgaImageAttribute(TypedDict, total=False):
    """Describes an Amazon FPGA image (AFI) attribute."""

    FpgaImageId: Optional[String]
    Name: Optional[String]
    Description: Optional[String]
    LoadPermissions: Optional[LoadPermissionList]
    ProductCodes: Optional[ProductCodeList]


class DescribeFpgaImageAttributeResult(TypedDict, total=False):
    FpgaImageAttribute: Optional[FpgaImageAttribute]


OwnerStringList = List[String]
FpgaImageIdList = List[FpgaImageId]


class DescribeFpgaImagesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    FpgaImageIds: Optional[FpgaImageIdList]
    Owners: Optional[OwnerStringList]
    Filters: Optional[FilterList]
    NextToken: Optional[NextToken]
    MaxResults: Optional[DescribeFpgaImagesMaxResults]


class FpgaImageState(TypedDict, total=False):
    """Describes the state of the bitstream generation process for an Amazon
    FPGA image (AFI).
    """

    Code: Optional[FpgaImageStateCode]
    Message: Optional[String]


class PciId(TypedDict, total=False):
    """Describes the data that identifies an Amazon FPGA image (AFI) on the PCI
    bus.
    """

    DeviceId: Optional[String]
    VendorId: Optional[String]
    SubsystemId: Optional[String]
    SubsystemVendorId: Optional[String]


class FpgaImage(TypedDict, total=False):
    """Describes an Amazon FPGA image (AFI)."""

    FpgaImageId: Optional[String]
    FpgaImageGlobalId: Optional[String]
    Name: Optional[String]
    Description: Optional[String]
    ShellVersion: Optional[String]
    PciId: Optional[PciId]
    State: Optional[FpgaImageState]
    CreateTime: Optional[DateTime]
    UpdateTime: Optional[DateTime]
    OwnerId: Optional[String]
    OwnerAlias: Optional[String]
    ProductCodes: Optional[ProductCodeList]
    Tags: Optional[TagList]
    Public: Optional[Boolean]
    DataRetentionSupport: Optional[Boolean]


FpgaImageList = List[FpgaImage]


class DescribeFpgaImagesResult(TypedDict, total=False):
    FpgaImages: Optional[FpgaImageList]
    NextToken: Optional[NextToken]


class DescribeHostReservationOfferingsRequest(ServiceRequest):
    Filter: Optional[FilterList]
    MaxDuration: Optional[Integer]
    MaxResults: Optional[DescribeHostReservationsMaxResults]
    MinDuration: Optional[Integer]
    NextToken: Optional[String]
    OfferingId: Optional[OfferingId]


class HostOffering(TypedDict, total=False):
    """Details about the Dedicated Host Reservation offering."""

    CurrencyCode: Optional[CurrencyCodeValues]
    Duration: Optional[Integer]
    HourlyPrice: Optional[String]
    InstanceFamily: Optional[String]
    OfferingId: Optional[OfferingId]
    PaymentOption: Optional[PaymentOption]
    UpfrontPrice: Optional[String]


HostOfferingSet = List[HostOffering]


class DescribeHostReservationOfferingsResult(TypedDict, total=False):
    NextToken: Optional[String]
    OfferingSet: Optional[HostOfferingSet]


HostReservationIdSet = List[HostReservationId]


class DescribeHostReservationsRequest(ServiceRequest):
    Filter: Optional[FilterList]
    HostReservationIdSet: Optional[HostReservationIdSet]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


ResponseHostIdSet = List[String]


class HostReservation(TypedDict, total=False):
    """Details about the Dedicated Host Reservation and associated Dedicated
    Hosts.
    """

    Count: Optional[Integer]
    CurrencyCode: Optional[CurrencyCodeValues]
    Duration: Optional[Integer]
    End: Optional[DateTime]
    HostIdSet: Optional[ResponseHostIdSet]
    HostReservationId: Optional[HostReservationId]
    HourlyPrice: Optional[String]
    InstanceFamily: Optional[String]
    OfferingId: Optional[OfferingId]
    PaymentOption: Optional[PaymentOption]
    Start: Optional[DateTime]
    State: Optional[ReservationState]
    UpfrontPrice: Optional[String]
    Tags: Optional[TagList]


HostReservationSet = List[HostReservation]


class DescribeHostReservationsResult(TypedDict, total=False):
    HostReservationSet: Optional[HostReservationSet]
    NextToken: Optional[String]


RequestHostIdList = List[DedicatedHostId]


class DescribeHostsRequest(ServiceRequest):
    Filter: Optional[FilterList]
    HostIds: Optional[RequestHostIdList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class HostInstance(TypedDict, total=False):
    """Describes an instance running on a Dedicated Host."""

    InstanceId: Optional[String]
    InstanceType: Optional[String]
    OwnerId: Optional[String]


HostInstanceList = List[HostInstance]


class HostProperties(TypedDict, total=False):
    """Describes the properties of a Dedicated Host."""

    Cores: Optional[Integer]
    InstanceType: Optional[String]
    InstanceFamily: Optional[String]
    Sockets: Optional[Integer]
    TotalVCpus: Optional[Integer]


class Host(TypedDict, total=False):
    """Describes the properties of the Dedicated Host."""

    AutoPlacement: Optional[AutoPlacement]
    AvailabilityZone: Optional[String]
    AvailableCapacity: Optional[AvailableCapacity]
    ClientToken: Optional[String]
    HostId: Optional[String]
    HostProperties: Optional[HostProperties]
    HostReservationId: Optional[String]
    Instances: Optional[HostInstanceList]
    State: Optional[AllocationState]
    AllocationTime: Optional[DateTime]
    ReleaseTime: Optional[DateTime]
    Tags: Optional[TagList]
    HostRecovery: Optional[HostRecovery]
    AllowsMultipleInstanceTypes: Optional[AllowsMultipleInstanceTypes]
    OwnerId: Optional[String]
    AvailabilityZoneId: Optional[String]
    MemberOfServiceLinkedResourceGroup: Optional[Boolean]


HostList = List[Host]


class DescribeHostsResult(TypedDict, total=False):
    Hosts: Optional[HostList]
    NextToken: Optional[String]


class DescribeIamInstanceProfileAssociationsRequest(ServiceRequest):
    AssociationIds: Optional[AssociationIdList]
    Filters: Optional[FilterList]
    MaxResults: Optional[DescribeIamInstanceProfileAssociationsMaxResults]
    NextToken: Optional[NextToken]


IamInstanceProfileAssociationSet = List[IamInstanceProfileAssociation]


class DescribeIamInstanceProfileAssociationsResult(TypedDict, total=False):
    IamInstanceProfileAssociations: Optional[IamInstanceProfileAssociationSet]
    NextToken: Optional[NextToken]


class DescribeIdFormatRequest(ServiceRequest):
    Resource: Optional[String]


class DescribeIdFormatResult(TypedDict, total=False):
    Statuses: Optional[IdFormatList]


class DescribeIdentityIdFormatRequest(ServiceRequest):
    PrincipalArn: String
    Resource: Optional[String]


class DescribeIdentityIdFormatResult(TypedDict, total=False):
    Statuses: Optional[IdFormatList]


class DescribeImageAttributeRequest(ServiceRequest):
    """Contains the parameters for DescribeImageAttribute."""

    Attribute: ImageAttributeName
    ImageId: ImageId
    DryRun: Optional[Boolean]


ImageIdStringList = List[ImageId]
ExecutableByStringList = List[String]


class DescribeImagesRequest(ServiceRequest):
    ExecutableUsers: Optional[ExecutableByStringList]
    Filters: Optional[FilterList]
    ImageIds: Optional[ImageIdStringList]
    Owners: Optional[OwnerStringList]
    IncludeDeprecated: Optional[Boolean]
    DryRun: Optional[Boolean]


class StateReason(TypedDict, total=False):
    """Describes a state change."""

    Code: Optional[String]
    Message: Optional[String]


class Image(TypedDict, total=False):
    """Describes an image."""

    Architecture: Optional[ArchitectureValues]
    CreationDate: Optional[String]
    ImageId: Optional[String]
    ImageLocation: Optional[String]
    ImageType: Optional[ImageTypeValues]
    Public: Optional[Boolean]
    KernelId: Optional[String]
    OwnerId: Optional[String]
    Platform: Optional[PlatformValues]
    PlatformDetails: Optional[String]
    UsageOperation: Optional[String]
    ProductCodes: Optional[ProductCodeList]
    RamdiskId: Optional[String]
    State: Optional[ImageState]
    BlockDeviceMappings: Optional[BlockDeviceMappingList]
    Description: Optional[String]
    EnaSupport: Optional[Boolean]
    Hypervisor: Optional[HypervisorType]
    ImageOwnerAlias: Optional[String]
    Name: Optional[String]
    RootDeviceName: Optional[String]
    RootDeviceType: Optional[DeviceType]
    SriovNetSupport: Optional[String]
    StateReason: Optional[StateReason]
    Tags: Optional[TagList]
    VirtualizationType: Optional[VirtualizationType]
    BootMode: Optional[BootModeValues]
    DeprecationTime: Optional[String]


ImageList = List[Image]


class DescribeImagesResult(TypedDict, total=False):
    Images: Optional[ImageList]


ImportTaskIdList = List[ImportImageTaskId]


class DescribeImportImageTasksRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    ImportTaskIds: Optional[ImportTaskIdList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class ImportImageLicenseConfigurationResponse(TypedDict, total=False):
    """The response information for license configurations."""

    LicenseConfigurationArn: Optional[String]


ImportImageLicenseSpecificationListResponse = List[ImportImageLicenseConfigurationResponse]


class UserBucketDetails(TypedDict, total=False):
    """Describes the Amazon S3 bucket for the disk image."""

    S3Bucket: Optional[String]
    S3Key: Optional[String]


class SnapshotDetail(TypedDict, total=False):
    """Describes the snapshot created from the imported disk."""

    Description: Optional[String]
    DeviceName: Optional[String]
    DiskImageSize: Optional[Double]
    Format: Optional[String]
    Progress: Optional[String]
    SnapshotId: Optional[String]
    Status: Optional[String]
    StatusMessage: Optional[String]
    Url: Optional[String]
    UserBucket: Optional[UserBucketDetails]


SnapshotDetailList = List[SnapshotDetail]


class ImportImageTask(TypedDict, total=False):
    """Describes an import image task."""

    Architecture: Optional[String]
    Description: Optional[String]
    Encrypted: Optional[Boolean]
    Hypervisor: Optional[String]
    ImageId: Optional[String]
    ImportTaskId: Optional[String]
    KmsKeyId: Optional[String]
    LicenseType: Optional[String]
    Platform: Optional[String]
    Progress: Optional[String]
    SnapshotDetails: Optional[SnapshotDetailList]
    Status: Optional[String]
    StatusMessage: Optional[String]
    Tags: Optional[TagList]
    LicenseSpecifications: Optional[ImportImageLicenseSpecificationListResponse]
    UsageOperation: Optional[String]
    BootMode: Optional[BootModeValues]


ImportImageTaskList = List[ImportImageTask]


class DescribeImportImageTasksResult(TypedDict, total=False):
    ImportImageTasks: Optional[ImportImageTaskList]
    NextToken: Optional[String]


ImportSnapshotTaskIdList = List[ImportSnapshotTaskId]


class DescribeImportSnapshotTasksRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    ImportTaskIds: Optional[ImportSnapshotTaskIdList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class SnapshotTaskDetail(TypedDict, total=False):
    """Details about the import snapshot task."""

    Description: Optional[String]
    DiskImageSize: Optional[Double]
    Encrypted: Optional[Boolean]
    Format: Optional[String]
    KmsKeyId: Optional[String]
    Progress: Optional[String]
    SnapshotId: Optional[String]
    Status: Optional[String]
    StatusMessage: Optional[String]
    Url: Optional[String]
    UserBucket: Optional[UserBucketDetails]


class ImportSnapshotTask(TypedDict, total=False):
    """Describes an import snapshot task."""

    Description: Optional[String]
    ImportTaskId: Optional[String]
    SnapshotTaskDetail: Optional[SnapshotTaskDetail]
    Tags: Optional[TagList]


ImportSnapshotTaskList = List[ImportSnapshotTask]


class DescribeImportSnapshotTasksResult(TypedDict, total=False):
    ImportSnapshotTasks: Optional[ImportSnapshotTaskList]
    NextToken: Optional[String]


class DescribeInstanceAttributeRequest(ServiceRequest):
    Attribute: InstanceAttributeName
    DryRun: Optional[Boolean]
    InstanceId: InstanceId


class DescribeInstanceCreditSpecificationsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    InstanceIds: Optional[InstanceIdStringList]
    MaxResults: Optional[DescribeInstanceCreditSpecificationsMaxResults]
    NextToken: Optional[String]


class InstanceCreditSpecification(TypedDict, total=False):
    """Describes the credit option for CPU usage of a burstable performance
    instance.
    """

    InstanceId: Optional[String]
    CpuCredits: Optional[String]


InstanceCreditSpecificationList = List[InstanceCreditSpecification]


class DescribeInstanceCreditSpecificationsResult(TypedDict, total=False):
    InstanceCreditSpecifications: Optional[InstanceCreditSpecificationList]
    NextToken: Optional[String]


class DescribeInstanceEventNotificationAttributesRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class DescribeInstanceEventNotificationAttributesResult(TypedDict, total=False):
    InstanceTagAttribute: Optional[InstanceTagNotificationAttribute]


InstanceEventWindowIdSet = List[InstanceEventWindowId]


class DescribeInstanceEventWindowsRequest(ServiceRequest):
    """Describe instance event windows by InstanceEventWindow."""

    DryRun: Optional[Boolean]
    InstanceEventWindowIds: Optional[InstanceEventWindowIdSet]
    Filters: Optional[FilterList]
    MaxResults: Optional[ResultRange]
    NextToken: Optional[String]


InstanceEventWindowSet = List[InstanceEventWindow]


class DescribeInstanceEventWindowsResult(TypedDict, total=False):
    InstanceEventWindows: Optional[InstanceEventWindowSet]
    NextToken: Optional[String]


class DescribeInstanceStatusRequest(ServiceRequest):
    Filters: Optional[FilterList]
    InstanceIds: Optional[InstanceIdStringList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]
    IncludeAllInstances: Optional[Boolean]


class InstanceStatusDetails(TypedDict, total=False):
    """Describes the instance status."""

    ImpairedSince: Optional[DateTime]
    Name: Optional[StatusName]
    Status: Optional[StatusType]


InstanceStatusDetailsList = List[InstanceStatusDetails]


class InstanceStatusSummary(TypedDict, total=False):
    """Describes the status of an instance."""

    Details: Optional[InstanceStatusDetailsList]
    Status: Optional[SummaryStatus]


class InstanceState(TypedDict, total=False):
    """Describes the current state of an instance."""

    Code: Optional[Integer]
    Name: Optional[InstanceStateName]


class InstanceStatusEvent(TypedDict, total=False):
    """Describes a scheduled event for an instance."""

    InstanceEventId: Optional[InstanceEventId]
    Code: Optional[EventCode]
    Description: Optional[String]
    NotAfter: Optional[DateTime]
    NotBefore: Optional[DateTime]
    NotBeforeDeadline: Optional[DateTime]


InstanceStatusEventList = List[InstanceStatusEvent]


class InstanceStatus(TypedDict, total=False):
    """Describes the status of an instance."""

    AvailabilityZone: Optional[String]
    OutpostArn: Optional[String]
    Events: Optional[InstanceStatusEventList]
    InstanceId: Optional[String]
    InstanceState: Optional[InstanceState]
    InstanceStatus: Optional[InstanceStatusSummary]
    SystemStatus: Optional[InstanceStatusSummary]


InstanceStatusList = List[InstanceStatus]


class DescribeInstanceStatusResult(TypedDict, total=False):
    InstanceStatuses: Optional[InstanceStatusList]
    NextToken: Optional[String]


class DescribeInstanceTypeOfferingsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    LocationType: Optional[LocationType]
    Filters: Optional[FilterList]
    MaxResults: Optional[DITOMaxResults]
    NextToken: Optional[NextToken]


class InstanceTypeOffering(TypedDict, total=False):
    """The instance types offered."""

    InstanceType: Optional[InstanceType]
    LocationType: Optional[LocationType]
    Location: Optional[Location]


InstanceTypeOfferingsList = List[InstanceTypeOffering]


class DescribeInstanceTypeOfferingsResult(TypedDict, total=False):
    InstanceTypeOfferings: Optional[InstanceTypeOfferingsList]
    NextToken: Optional[NextToken]


RequestInstanceTypeList = List[InstanceType]


class DescribeInstanceTypesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceTypes: Optional[RequestInstanceTypeList]
    Filters: Optional[FilterList]
    MaxResults: Optional[DITMaxResults]
    NextToken: Optional[NextToken]


class InferenceDeviceInfo(TypedDict, total=False):
    """Describes the Inference accelerators for the instance type."""

    Count: Optional[InferenceDeviceCount]
    Name: Optional[InferenceDeviceName]
    Manufacturer: Optional[InferenceDeviceManufacturerName]


InferenceDeviceInfoList = List[InferenceDeviceInfo]


class InferenceAcceleratorInfo(TypedDict, total=False):
    """Describes the Inference accelerators for the instance type."""

    Accelerators: Optional[InferenceDeviceInfoList]


PlacementGroupStrategyList = List[PlacementGroupStrategy]


class PlacementGroupInfo(TypedDict, total=False):
    """Describes the placement group support of the instance type."""

    SupportedStrategies: Optional[PlacementGroupStrategyList]


class FpgaDeviceMemoryInfo(TypedDict, total=False):
    """Describes the memory for the FPGA accelerator for the instance type."""

    SizeInMiB: Optional[FpgaDeviceMemorySize]


class FpgaDeviceInfo(TypedDict, total=False):
    """Describes the FPGA accelerator for the instance type."""

    Name: Optional[FpgaDeviceName]
    Manufacturer: Optional[FpgaDeviceManufacturerName]
    Count: Optional[FpgaDeviceCount]
    MemoryInfo: Optional[FpgaDeviceMemoryInfo]


FpgaDeviceInfoList = List[FpgaDeviceInfo]


class FpgaInfo(TypedDict, total=False):
    """Describes the FPGAs for the instance type."""

    Fpgas: Optional[FpgaDeviceInfoList]
    TotalFpgaMemoryInMiB: Optional[totalFpgaMemory]


class GpuDeviceMemoryInfo(TypedDict, total=False):
    """Describes the memory available to the GPU accelerator."""

    SizeInMiB: Optional[GpuDeviceMemorySize]


class GpuDeviceInfo(TypedDict, total=False):
    """Describes the GPU accelerators for the instance type."""

    Name: Optional[GpuDeviceName]
    Manufacturer: Optional[GpuDeviceManufacturerName]
    Count: Optional[GpuDeviceCount]
    MemoryInfo: Optional[GpuDeviceMemoryInfo]


GpuDeviceInfoList = List[GpuDeviceInfo]


class GpuInfo(TypedDict, total=False):
    """Describes the GPU accelerators for the instance type."""

    Gpus: Optional[GpuDeviceInfoList]
    TotalGpuMemoryInMiB: Optional[totalGpuMemory]


class EfaInfo(TypedDict, total=False):
    """Describes the Elastic Fabric Adapters for the instance type."""

    MaximumEfaInterfaces: Optional[MaximumEfaInterfaces]


class NetworkCardInfo(TypedDict, total=False):
    """Describes the network card support of the instance type."""

    NetworkCardIndex: Optional[NetworkCardIndex]
    NetworkPerformance: Optional[NetworkPerformance]
    MaximumNetworkInterfaces: Optional[MaxNetworkInterfaces]


NetworkCardInfoList = List[NetworkCardInfo]


class NetworkInfo(TypedDict, total=False):
    """Describes the networking features of the instance type."""

    NetworkPerformance: Optional[NetworkPerformance]
    MaximumNetworkInterfaces: Optional[MaxNetworkInterfaces]
    MaximumNetworkCards: Optional[MaximumNetworkCards]
    DefaultNetworkCardIndex: Optional[DefaultNetworkCardIndex]
    NetworkCards: Optional[NetworkCardInfoList]
    Ipv4AddressesPerInterface: Optional[MaxIpv4AddrPerInterface]
    Ipv6AddressesPerInterface: Optional[MaxIpv6AddrPerInterface]
    Ipv6Supported: Optional[Ipv6Flag]
    EnaSupport: Optional[EnaSupport]
    EfaSupported: Optional[EfaSupportedFlag]
    EfaInfo: Optional[EfaInfo]
    EncryptionInTransitSupported: Optional[EncryptionInTransitSupported]


class EbsOptimizedInfo(TypedDict, total=False):
    """Describes the optimized EBS performance for supported instance types."""

    BaselineBandwidthInMbps: Optional[BaselineBandwidthInMbps]
    BaselineThroughputInMBps: Optional[BaselineThroughputInMBps]
    BaselineIops: Optional[BaselineIops]
    MaximumBandwidthInMbps: Optional[MaximumBandwidthInMbps]
    MaximumThroughputInMBps: Optional[MaximumThroughputInMBps]
    MaximumIops: Optional[MaximumIops]


class EbsInfo(TypedDict, total=False):
    """Describes the Amazon EBS features supported by the instance type."""

    EbsOptimizedSupport: Optional[EbsOptimizedSupport]
    EncryptionSupport: Optional[EbsEncryptionSupport]
    EbsOptimizedInfo: Optional[EbsOptimizedInfo]
    NvmeSupport: Optional[EbsNvmeSupport]


DiskSize = int


class DiskInfo(TypedDict, total=False):
    """Describes a disk."""

    SizeInGB: Optional[DiskSize]
    Count: Optional[DiskCount]
    Type: Optional[DiskType]


DiskInfoList = List[DiskInfo]


class InstanceStorageInfo(TypedDict, total=False):
    """Describes the instance store features that are supported by the instance
    type.
    """

    TotalSizeInGB: Optional[DiskSize]
    Disks: Optional[DiskInfoList]
    NvmeSupport: Optional[EphemeralNvmeSupport]
    EncryptionSupport: Optional[InstanceStorageEncryptionSupport]


MemorySize = int


class MemoryInfo(TypedDict, total=False):
    """Describes the memory for the instance type."""

    SizeInMiB: Optional[MemorySize]


ThreadsPerCoreList = List[ThreadsPerCore]


class VCpuInfo(TypedDict, total=False):
    """Describes the vCPU configurations for the instance type."""

    DefaultVCpus: Optional[VCpuCount]
    DefaultCores: Optional[CoreCount]
    DefaultThreadsPerCore: Optional[ThreadsPerCore]
    ValidCores: Optional[CoreCountList]
    ValidThreadsPerCore: Optional[ThreadsPerCoreList]


class ProcessorInfo(TypedDict, total=False):
    """Describes the processor used by the instance type."""

    SupportedArchitectures: Optional[ArchitectureTypeList]
    SustainedClockSpeedInGhz: Optional[ProcessorSustainedClockSpeed]


VirtualizationTypeList = List[VirtualizationType]
RootDeviceTypeList = List[RootDeviceType]
UsageClassTypeList = List[UsageClassType]


class InstanceTypeInfo(TypedDict, total=False):
    """Describes the instance type."""

    InstanceType: Optional[InstanceType]
    CurrentGeneration: Optional[CurrentGenerationFlag]
    FreeTierEligible: Optional[FreeTierEligibleFlag]
    SupportedUsageClasses: Optional[UsageClassTypeList]
    SupportedRootDeviceTypes: Optional[RootDeviceTypeList]
    SupportedVirtualizationTypes: Optional[VirtualizationTypeList]
    BareMetal: Optional[BareMetalFlag]
    Hypervisor: Optional[InstanceTypeHypervisor]
    ProcessorInfo: Optional[ProcessorInfo]
    VCpuInfo: Optional[VCpuInfo]
    MemoryInfo: Optional[MemoryInfo]
    InstanceStorageSupported: Optional[InstanceStorageFlag]
    InstanceStorageInfo: Optional[InstanceStorageInfo]
    EbsInfo: Optional[EbsInfo]
    NetworkInfo: Optional[NetworkInfo]
    GpuInfo: Optional[GpuInfo]
    FpgaInfo: Optional[FpgaInfo]
    PlacementGroupInfo: Optional[PlacementGroupInfo]
    InferenceAcceleratorInfo: Optional[InferenceAcceleratorInfo]
    HibernationSupported: Optional[HibernationFlag]
    BurstablePerformanceSupported: Optional[BurstablePerformanceFlag]
    DedicatedHostsSupported: Optional[DedicatedHostFlag]
    AutoRecoverySupported: Optional[AutoRecoveryFlag]
    SupportedBootModes: Optional[BootModeTypeList]


InstanceTypeInfoList = List[InstanceTypeInfo]


class DescribeInstanceTypesResult(TypedDict, total=False):
    InstanceTypes: Optional[InstanceTypeInfoList]
    NextToken: Optional[NextToken]


class DescribeInstancesRequest(ServiceRequest):
    Filters: Optional[FilterList]
    InstanceIds: Optional[InstanceIdStringList]
    DryRun: Optional[Boolean]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class PrivateDnsNameOptionsResponse(TypedDict, total=False):
    """Describes the options for instance hostnames."""

    HostnameType: Optional[HostnameType]
    EnableResourceNameDnsARecord: Optional[Boolean]
    EnableResourceNameDnsAAAARecord: Optional[Boolean]


class EnclaveOptions(TypedDict, total=False):
    """Indicates whether the instance is enabled for Amazon Web Services Nitro
    Enclaves.
    """

    Enabled: Optional[Boolean]


class InstanceMetadataOptionsResponse(TypedDict, total=False):
    """The metadata options for the instance."""

    State: Optional[InstanceMetadataOptionsState]
    HttpTokens: Optional[HttpTokensState]
    HttpPutResponseHopLimit: Optional[Integer]
    HttpEndpoint: Optional[InstanceMetadataEndpointState]
    HttpProtocolIpv6: Optional[InstanceMetadataProtocolState]
    InstanceMetadataTags: Optional[InstanceMetadataTagsState]


class LicenseConfiguration(TypedDict, total=False):
    """Describes a license configuration."""

    LicenseConfigurationArn: Optional[String]


LicenseList = List[LicenseConfiguration]


class HibernationOptions(TypedDict, total=False):
    """Indicates whether your instance is configured for hibernation. This
    parameter is valid only if the instance meets the `hibernation
    prerequisites <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites>`__.
    For more information, see `Hibernate your
    instance <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html>`__
    in the *Amazon EC2 User Guide*.
    """

    Configured: Optional[Boolean]


class InstanceIpv6Prefix(TypedDict, total=False):
    """Information about an IPv6 prefix."""

    Ipv6Prefix: Optional[String]


InstanceIpv6PrefixList = List[InstanceIpv6Prefix]


class InstanceIpv4Prefix(TypedDict, total=False):
    """Information about an IPv4 prefix."""

    Ipv4Prefix: Optional[String]


InstanceIpv4PrefixList = List[InstanceIpv4Prefix]


class InstanceNetworkInterfaceAssociation(TypedDict, total=False):
    """Describes association information for an Elastic IP address (IPv4)."""

    CarrierIp: Optional[String]
    CustomerOwnedIp: Optional[String]
    IpOwnerId: Optional[String]
    PublicDnsName: Optional[String]
    PublicIp: Optional[String]


class InstancePrivateIpAddress(TypedDict, total=False):
    """Describes a private IPv4 address."""

    Association: Optional[InstanceNetworkInterfaceAssociation]
    Primary: Optional[Boolean]
    PrivateDnsName: Optional[String]
    PrivateIpAddress: Optional[String]


InstancePrivateIpAddressList = List[InstancePrivateIpAddress]


class InstanceNetworkInterfaceAttachment(TypedDict, total=False):
    """Describes a network interface attachment."""

    AttachTime: Optional[DateTime]
    AttachmentId: Optional[String]
    DeleteOnTermination: Optional[Boolean]
    DeviceIndex: Optional[Integer]
    Status: Optional[AttachmentStatus]
    NetworkCardIndex: Optional[Integer]


class InstanceNetworkInterface(TypedDict, total=False):
    """Describes a network interface."""

    Association: Optional[InstanceNetworkInterfaceAssociation]
    Attachment: Optional[InstanceNetworkInterfaceAttachment]
    Description: Optional[String]
    Groups: Optional[GroupIdentifierList]
    Ipv6Addresses: Optional[InstanceIpv6AddressList]
    MacAddress: Optional[String]
    NetworkInterfaceId: Optional[String]
    OwnerId: Optional[String]
    PrivateDnsName: Optional[String]
    PrivateIpAddress: Optional[String]
    PrivateIpAddresses: Optional[InstancePrivateIpAddressList]
    SourceDestCheck: Optional[Boolean]
    Status: Optional[NetworkInterfaceStatus]
    SubnetId: Optional[String]
    VpcId: Optional[String]
    InterfaceType: Optional[String]
    Ipv4Prefixes: Optional[InstanceIpv4PrefixList]
    Ipv6Prefixes: Optional[InstanceIpv6PrefixList]


InstanceNetworkInterfaceList = List[InstanceNetworkInterface]


class ElasticInferenceAcceleratorAssociation(TypedDict, total=False):
    """Describes the association between an instance and an elastic inference
    accelerator.
    """

    ElasticInferenceAcceleratorArn: Optional[String]
    ElasticInferenceAcceleratorAssociationId: Optional[String]
    ElasticInferenceAcceleratorAssociationState: Optional[String]
    ElasticInferenceAcceleratorAssociationTime: Optional[DateTime]


ElasticInferenceAcceleratorAssociationList = List[ElasticInferenceAcceleratorAssociation]


class ElasticGpuAssociation(TypedDict, total=False):
    """Describes the association between an instance and an Elastic Graphics
    accelerator.
    """

    ElasticGpuId: Optional[ElasticGpuId]
    ElasticGpuAssociationId: Optional[String]
    ElasticGpuAssociationState: Optional[String]
    ElasticGpuAssociationTime: Optional[String]


ElasticGpuAssociationList = List[ElasticGpuAssociation]


class EbsInstanceBlockDevice(TypedDict, total=False):
    """Describes a parameter used to set up an EBS volume in a block device
    mapping.
    """

    AttachTime: Optional[DateTime]
    DeleteOnTermination: Optional[Boolean]
    Status: Optional[AttachmentStatus]
    VolumeId: Optional[String]


class InstanceBlockDeviceMapping(TypedDict, total=False):
    """Describes a block device mapping."""

    DeviceName: Optional[String]
    Ebs: Optional[EbsInstanceBlockDevice]


InstanceBlockDeviceMappingList = List[InstanceBlockDeviceMapping]


class Monitoring(TypedDict, total=False):
    """Describes the monitoring of an instance."""

    State: Optional[MonitoringState]


class Instance(TypedDict, total=False):
    """Describes an instance."""

    AmiLaunchIndex: Optional[Integer]
    ImageId: Optional[String]
    InstanceId: Optional[String]
    InstanceType: Optional[InstanceType]
    KernelId: Optional[String]
    KeyName: Optional[String]
    LaunchTime: Optional[DateTime]
    Monitoring: Optional[Monitoring]
    Placement: Optional[Placement]
    Platform: Optional[PlatformValues]
    PrivateDnsName: Optional[String]
    PrivateIpAddress: Optional[String]
    ProductCodes: Optional[ProductCodeList]
    PublicDnsName: Optional[String]
    PublicIpAddress: Optional[String]
    RamdiskId: Optional[String]
    State: Optional[InstanceState]
    StateTransitionReason: Optional[String]
    SubnetId: Optional[String]
    VpcId: Optional[String]
    Architecture: Optional[ArchitectureValues]
    BlockDeviceMappings: Optional[InstanceBlockDeviceMappingList]
    ClientToken: Optional[String]
    EbsOptimized: Optional[Boolean]
    EnaSupport: Optional[Boolean]
    Hypervisor: Optional[HypervisorType]
    IamInstanceProfile: Optional[IamInstanceProfile]
    InstanceLifecycle: Optional[InstanceLifecycleType]
    ElasticGpuAssociations: Optional[ElasticGpuAssociationList]
    ElasticInferenceAcceleratorAssociations: Optional[ElasticInferenceAcceleratorAssociationList]
    NetworkInterfaces: Optional[InstanceNetworkInterfaceList]
    OutpostArn: Optional[String]
    RootDeviceName: Optional[String]
    RootDeviceType: Optional[DeviceType]
    SecurityGroups: Optional[GroupIdentifierList]
    SourceDestCheck: Optional[Boolean]
    SpotInstanceRequestId: Optional[String]
    SriovNetSupport: Optional[String]
    StateReason: Optional[StateReason]
    Tags: Optional[TagList]
    VirtualizationType: Optional[VirtualizationType]
    CpuOptions: Optional[CpuOptions]
    CapacityReservationId: Optional[String]
    CapacityReservationSpecification: Optional[CapacityReservationSpecificationResponse]
    HibernationOptions: Optional[HibernationOptions]
    Licenses: Optional[LicenseList]
    MetadataOptions: Optional[InstanceMetadataOptionsResponse]
    EnclaveOptions: Optional[EnclaveOptions]
    BootMode: Optional[BootModeValues]
    PlatformDetails: Optional[String]
    UsageOperation: Optional[String]
    UsageOperationUpdateTime: Optional[MillisecondDateTime]
    PrivateDnsNameOptions: Optional[PrivateDnsNameOptionsResponse]
    Ipv6Address: Optional[String]


InstanceList = List[Instance]


class Reservation(TypedDict, total=False):
    """Describes a launch request for one or more instances, and includes
    owner, requester, and security group information that applies to all
    instances in the launch request.
    """

    Groups: Optional[GroupIdentifierList]
    Instances: Optional[InstanceList]
    OwnerId: Optional[String]
    RequesterId: Optional[String]
    ReservationId: Optional[String]


ReservationList = List[Reservation]


class DescribeInstancesResult(TypedDict, total=False):
    Reservations: Optional[ReservationList]
    NextToken: Optional[String]


InternetGatewayIdList = List[InternetGatewayId]


class DescribeInternetGatewaysRequest(ServiceRequest):
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    InternetGatewayIds: Optional[InternetGatewayIdList]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeInternetGatewaysMaxResults]


InternetGatewayList = List[InternetGateway]


class DescribeInternetGatewaysResult(TypedDict, total=False):
    InternetGateways: Optional[InternetGatewayList]
    NextToken: Optional[String]


class DescribeIpamPoolsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[IpamMaxResults]
    NextToken: Optional[NextToken]
    IpamPoolIds: Optional[ValueStringList]


IpamPoolSet = List[IpamPool]


class DescribeIpamPoolsResult(TypedDict, total=False):
    NextToken: Optional[NextToken]
    IpamPools: Optional[IpamPoolSet]


class DescribeIpamScopesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[IpamMaxResults]
    NextToken: Optional[NextToken]
    IpamScopeIds: Optional[ValueStringList]


IpamScopeSet = List[IpamScope]


class DescribeIpamScopesResult(TypedDict, total=False):
    NextToken: Optional[NextToken]
    IpamScopes: Optional[IpamScopeSet]


class DescribeIpamsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[IpamMaxResults]
    NextToken: Optional[NextToken]
    IpamIds: Optional[ValueStringList]


IpamSet = List[Ipam]


class DescribeIpamsResult(TypedDict, total=False):
    NextToken: Optional[NextToken]
    Ipams: Optional[IpamSet]


Ipv6PoolIdList = List[Ipv6PoolEc2Id]


class DescribeIpv6PoolsRequest(ServiceRequest):
    PoolIds: Optional[Ipv6PoolIdList]
    NextToken: Optional[NextToken]
    MaxResults: Optional[Ipv6PoolMaxResults]
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]


class PoolCidrBlock(TypedDict, total=False):
    """Describes a CIDR block for an address pool."""

    Cidr: Optional[String]


PoolCidrBlocksSet = List[PoolCidrBlock]


class Ipv6Pool(TypedDict, total=False):
    """Describes an IPv6 address pool."""

    PoolId: Optional[String]
    Description: Optional[String]
    PoolCidrBlocks: Optional[PoolCidrBlocksSet]
    Tags: Optional[TagList]


Ipv6PoolSet = List[Ipv6Pool]


class DescribeIpv6PoolsResult(TypedDict, total=False):
    Ipv6Pools: Optional[Ipv6PoolSet]
    NextToken: Optional[NextToken]


KeyPairIdStringList = List[KeyPairId]
KeyNameStringList = List[KeyPairName]


class DescribeKeyPairsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    KeyNames: Optional[KeyNameStringList]
    KeyPairIds: Optional[KeyPairIdStringList]
    DryRun: Optional[Boolean]


class KeyPairInfo(TypedDict, total=False):
    """Describes a key pair."""

    KeyPairId: Optional[String]
    KeyFingerprint: Optional[String]
    KeyName: Optional[String]
    KeyType: Optional[KeyType]
    Tags: Optional[TagList]


KeyPairList = List[KeyPairInfo]


class DescribeKeyPairsResult(TypedDict, total=False):
    KeyPairs: Optional[KeyPairList]


class DescribeLaunchTemplateVersionsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    LaunchTemplateId: Optional[LaunchTemplateId]
    LaunchTemplateName: Optional[LaunchTemplateName]
    Versions: Optional[VersionStringList]
    MinVersion: Optional[String]
    MaxVersion: Optional[String]
    NextToken: Optional[String]
    MaxResults: Optional[Integer]
    Filters: Optional[FilterList]


LaunchTemplateVersionSet = List[LaunchTemplateVersion]


class DescribeLaunchTemplateVersionsResult(TypedDict, total=False):
    LaunchTemplateVersions: Optional[LaunchTemplateVersionSet]
    NextToken: Optional[String]


LaunchTemplateNameStringList = List[LaunchTemplateName]
LaunchTemplateIdStringList = List[LaunchTemplateId]


class DescribeLaunchTemplatesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    LaunchTemplateIds: Optional[LaunchTemplateIdStringList]
    LaunchTemplateNames: Optional[LaunchTemplateNameStringList]
    Filters: Optional[FilterList]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeLaunchTemplatesMaxResults]


LaunchTemplateSet = List[LaunchTemplate]


class DescribeLaunchTemplatesResult(TypedDict, total=False):
    LaunchTemplates: Optional[LaunchTemplateSet]
    NextToken: Optional[String]


LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdSet = List[
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
]


class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(ServiceRequest):
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds: Optional[
        LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdSet
    ]
    Filters: Optional[FilterList]
    MaxResults: Optional[LocalGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class LocalGatewayRouteTableVirtualInterfaceGroupAssociation(TypedDict, total=False):
    """Describes an association between a local gateway route table and a
    virtual interface group.
    """

    LocalGatewayRouteTableVirtualInterfaceGroupAssociationId: Optional[
        LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
    ]
    LocalGatewayVirtualInterfaceGroupId: Optional[LocalGatewayVirtualInterfaceGroupId]
    LocalGatewayId: Optional[String]
    LocalGatewayRouteTableId: Optional[LocalGatewayId]
    LocalGatewayRouteTableArn: Optional[ResourceArn]
    OwnerId: Optional[String]
    State: Optional[String]
    Tags: Optional[TagList]


LocalGatewayRouteTableVirtualInterfaceGroupAssociationSet = List[
    LocalGatewayRouteTableVirtualInterfaceGroupAssociation
]


class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult(TypedDict, total=False):
    LocalGatewayRouteTableVirtualInterfaceGroupAssociations: Optional[
        LocalGatewayRouteTableVirtualInterfaceGroupAssociationSet
    ]
    NextToken: Optional[String]


LocalGatewayRouteTableVpcAssociationIdSet = List[LocalGatewayRouteTableVpcAssociationId]


class DescribeLocalGatewayRouteTableVpcAssociationsRequest(ServiceRequest):
    LocalGatewayRouteTableVpcAssociationIds: Optional[LocalGatewayRouteTableVpcAssociationIdSet]
    Filters: Optional[FilterList]
    MaxResults: Optional[LocalGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


LocalGatewayRouteTableVpcAssociationSet = List[LocalGatewayRouteTableVpcAssociation]


class DescribeLocalGatewayRouteTableVpcAssociationsResult(TypedDict, total=False):
    LocalGatewayRouteTableVpcAssociations: Optional[LocalGatewayRouteTableVpcAssociationSet]
    NextToken: Optional[String]


LocalGatewayRouteTableIdSet = List[LocalGatewayRoutetableId]


class DescribeLocalGatewayRouteTablesRequest(ServiceRequest):
    LocalGatewayRouteTableIds: Optional[LocalGatewayRouteTableIdSet]
    Filters: Optional[FilterList]
    MaxResults: Optional[LocalGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class LocalGatewayRouteTable(TypedDict, total=False):
    """Describes a local gateway route table."""

    LocalGatewayRouteTableId: Optional[String]
    LocalGatewayRouteTableArn: Optional[ResourceArn]
    LocalGatewayId: Optional[LocalGatewayId]
    OutpostArn: Optional[String]
    OwnerId: Optional[String]
    State: Optional[String]
    Tags: Optional[TagList]


LocalGatewayRouteTableSet = List[LocalGatewayRouteTable]


class DescribeLocalGatewayRouteTablesResult(TypedDict, total=False):
    LocalGatewayRouteTables: Optional[LocalGatewayRouteTableSet]
    NextToken: Optional[String]


LocalGatewayVirtualInterfaceGroupIdSet = List[LocalGatewayVirtualInterfaceGroupId]


class DescribeLocalGatewayVirtualInterfaceGroupsRequest(ServiceRequest):
    LocalGatewayVirtualInterfaceGroupIds: Optional[LocalGatewayVirtualInterfaceGroupIdSet]
    Filters: Optional[FilterList]
    MaxResults: Optional[LocalGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


LocalGatewayVirtualInterfaceIdSet = List[LocalGatewayVirtualInterfaceId]


class LocalGatewayVirtualInterfaceGroup(TypedDict, total=False):
    """Describes a local gateway virtual interface group."""

    LocalGatewayVirtualInterfaceGroupId: Optional[LocalGatewayVirtualInterfaceGroupId]
    LocalGatewayVirtualInterfaceIds: Optional[LocalGatewayVirtualInterfaceIdSet]
    LocalGatewayId: Optional[String]
    OwnerId: Optional[String]
    Tags: Optional[TagList]


LocalGatewayVirtualInterfaceGroupSet = List[LocalGatewayVirtualInterfaceGroup]


class DescribeLocalGatewayVirtualInterfaceGroupsResult(TypedDict, total=False):
    LocalGatewayVirtualInterfaceGroups: Optional[LocalGatewayVirtualInterfaceGroupSet]
    NextToken: Optional[String]


class DescribeLocalGatewayVirtualInterfacesRequest(ServiceRequest):
    LocalGatewayVirtualInterfaceIds: Optional[LocalGatewayVirtualInterfaceIdSet]
    Filters: Optional[FilterList]
    MaxResults: Optional[LocalGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class LocalGatewayVirtualInterface(TypedDict, total=False):
    """Describes a local gateway virtual interface."""

    LocalGatewayVirtualInterfaceId: Optional[LocalGatewayVirtualInterfaceId]
    LocalGatewayId: Optional[String]
    Vlan: Optional[Integer]
    LocalAddress: Optional[String]
    PeerAddress: Optional[String]
    LocalBgpAsn: Optional[Integer]
    PeerBgpAsn: Optional[Integer]
    OwnerId: Optional[String]
    Tags: Optional[TagList]


LocalGatewayVirtualInterfaceSet = List[LocalGatewayVirtualInterface]


class DescribeLocalGatewayVirtualInterfacesResult(TypedDict, total=False):
    LocalGatewayVirtualInterfaces: Optional[LocalGatewayVirtualInterfaceSet]
    NextToken: Optional[String]


LocalGatewayIdSet = List[LocalGatewayId]


class DescribeLocalGatewaysRequest(ServiceRequest):
    LocalGatewayIds: Optional[LocalGatewayIdSet]
    Filters: Optional[FilterList]
    MaxResults: Optional[LocalGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class LocalGateway(TypedDict, total=False):
    """Describes a local gateway."""

    LocalGatewayId: Optional[LocalGatewayId]
    OutpostArn: Optional[String]
    OwnerId: Optional[String]
    State: Optional[String]
    Tags: Optional[TagList]


LocalGatewaySet = List[LocalGateway]


class DescribeLocalGatewaysResult(TypedDict, total=False):
    LocalGateways: Optional[LocalGatewaySet]
    NextToken: Optional[String]


class DescribeManagedPrefixListsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[PrefixListMaxResults]
    NextToken: Optional[NextToken]
    PrefixListIds: Optional[ValueStringList]


ManagedPrefixListSet = List[ManagedPrefixList]


class DescribeManagedPrefixListsResult(TypedDict, total=False):
    NextToken: Optional[NextToken]
    PrefixLists: Optional[ManagedPrefixListSet]


class DescribeMovingAddressesRequest(ServiceRequest):
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    MaxResults: Optional[DescribeMovingAddressesMaxResults]
    NextToken: Optional[String]
    PublicIps: Optional[ValueStringList]


class MovingAddressStatus(TypedDict, total=False):
    """Describes the status of a moving Elastic IP address."""

    MoveStatus: Optional[MoveStatus]
    PublicIp: Optional[String]


MovingAddressStatusSet = List[MovingAddressStatus]


class DescribeMovingAddressesResult(TypedDict, total=False):
    MovingAddressStatuses: Optional[MovingAddressStatusSet]
    NextToken: Optional[String]


NatGatewayIdStringList = List[NatGatewayId]


class DescribeNatGatewaysRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filter: Optional[FilterList]
    MaxResults: Optional[DescribeNatGatewaysMaxResults]
    NatGatewayIds: Optional[NatGatewayIdStringList]
    NextToken: Optional[String]


NatGatewayList = List[NatGateway]


class DescribeNatGatewaysResult(TypedDict, total=False):
    NatGateways: Optional[NatGatewayList]
    NextToken: Optional[String]


NetworkAclIdStringList = List[NetworkAclId]


class DescribeNetworkAclsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    NetworkAclIds: Optional[NetworkAclIdStringList]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeNetworkAclsMaxResults]


NetworkAclList = List[NetworkAcl]


class DescribeNetworkAclsResult(TypedDict, total=False):
    NetworkAcls: Optional[NetworkAclList]
    NextToken: Optional[String]


NetworkInsightsAccessScopeAnalysisIdList = List[NetworkInsightsAccessScopeAnalysisId]


class DescribeNetworkInsightsAccessScopeAnalysesRequest(ServiceRequest):
    NetworkInsightsAccessScopeAnalysisIds: Optional[NetworkInsightsAccessScopeAnalysisIdList]
    NetworkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    AnalysisStartTimeBegin: Optional[MillisecondDateTime]
    AnalysisStartTimeEnd: Optional[MillisecondDateTime]
    Filters: Optional[FilterList]
    MaxResults: Optional[NetworkInsightsMaxResults]
    DryRun: Optional[Boolean]
    NextToken: Optional[NextToken]


class NetworkInsightsAccessScopeAnalysis(TypedDict, total=False):
    """Describes a Network Access Scope analysis."""

    NetworkInsightsAccessScopeAnalysisId: Optional[NetworkInsightsAccessScopeAnalysisId]
    NetworkInsightsAccessScopeAnalysisArn: Optional[ResourceArn]
    NetworkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    Status: Optional[AnalysisStatus]
    StatusMessage: Optional[String]
    WarningMessage: Optional[String]
    StartDate: Optional[MillisecondDateTime]
    EndDate: Optional[MillisecondDateTime]
    FindingsFound: Optional[FindingsFound]
    AnalyzedEniCount: Optional[Integer]
    Tags: Optional[TagList]


NetworkInsightsAccessScopeAnalysisList = List[NetworkInsightsAccessScopeAnalysis]


class DescribeNetworkInsightsAccessScopeAnalysesResult(TypedDict, total=False):
    NetworkInsightsAccessScopeAnalyses: Optional[NetworkInsightsAccessScopeAnalysisList]
    NextToken: Optional[String]


NetworkInsightsAccessScopeIdList = List[NetworkInsightsAccessScopeId]


class DescribeNetworkInsightsAccessScopesRequest(ServiceRequest):
    NetworkInsightsAccessScopeIds: Optional[NetworkInsightsAccessScopeIdList]
    Filters: Optional[FilterList]
    MaxResults: Optional[NetworkInsightsMaxResults]
    DryRun: Optional[Boolean]
    NextToken: Optional[NextToken]


NetworkInsightsAccessScopeList = List[NetworkInsightsAccessScope]


class DescribeNetworkInsightsAccessScopesResult(TypedDict, total=False):
    NetworkInsightsAccessScopes: Optional[NetworkInsightsAccessScopeList]
    NextToken: Optional[String]


NetworkInsightsAnalysisIdList = List[NetworkInsightsAnalysisId]


class DescribeNetworkInsightsAnalysesRequest(ServiceRequest):
    NetworkInsightsAnalysisIds: Optional[NetworkInsightsAnalysisIdList]
    NetworkInsightsPathId: Optional[NetworkInsightsPathId]
    AnalysisStartTime: Optional[MillisecondDateTime]
    AnalysisEndTime: Optional[MillisecondDateTime]
    Filters: Optional[FilterList]
    MaxResults: Optional[NetworkInsightsMaxResults]
    DryRun: Optional[Boolean]
    NextToken: Optional[NextToken]


StringList = List[String]


class Explanation(TypedDict, total=False):
    """Describes an explanation code for an unreachable path. For more
    information, see `Reachability Analyzer explanation
    codes <https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html>`__.
    """

    Acl: Optional[AnalysisComponent]
    AclRule: Optional[AnalysisAclRule]
    Address: Optional[IpAddress]
    Addresses: Optional[IpAddressList]
    AttachedTo: Optional[AnalysisComponent]
    AvailabilityZones: Optional[ValueStringList]
    Cidrs: Optional[ValueStringList]
    Component: Optional[AnalysisComponent]
    CustomerGateway: Optional[AnalysisComponent]
    Destination: Optional[AnalysisComponent]
    DestinationVpc: Optional[AnalysisComponent]
    Direction: Optional[String]
    ExplanationCode: Optional[String]
    IngressRouteTable: Optional[AnalysisComponent]
    InternetGateway: Optional[AnalysisComponent]
    LoadBalancerArn: Optional[ResourceArn]
    ClassicLoadBalancerListener: Optional[AnalysisLoadBalancerListener]
    LoadBalancerListenerPort: Optional[Port]
    LoadBalancerTarget: Optional[AnalysisLoadBalancerTarget]
    LoadBalancerTargetGroup: Optional[AnalysisComponent]
    LoadBalancerTargetGroups: Optional[AnalysisComponentList]
    LoadBalancerTargetPort: Optional[Port]
    ElasticLoadBalancerListener: Optional[AnalysisComponent]
    MissingComponent: Optional[String]
    NatGateway: Optional[AnalysisComponent]
    NetworkInterface: Optional[AnalysisComponent]
    PacketField: Optional[String]
    VpcPeeringConnection: Optional[AnalysisComponent]
    Port: Optional[Port]
    PortRanges: Optional[PortRangeList]
    PrefixList: Optional[AnalysisComponent]
    Protocols: Optional[StringList]
    RouteTableRoute: Optional[AnalysisRouteTableRoute]
    RouteTable: Optional[AnalysisComponent]
    SecurityGroup: Optional[AnalysisComponent]
    SecurityGroupRule: Optional[AnalysisSecurityGroupRule]
    SecurityGroups: Optional[AnalysisComponentList]
    SourceVpc: Optional[AnalysisComponent]
    State: Optional[String]
    Subnet: Optional[AnalysisComponent]
    SubnetRouteTable: Optional[AnalysisComponent]
    Vpc: Optional[AnalysisComponent]
    VpcEndpoint: Optional[AnalysisComponent]
    VpnConnection: Optional[AnalysisComponent]
    VpnGateway: Optional[AnalysisComponent]


ExplanationList = List[Explanation]


class NetworkInsightsAnalysis(TypedDict, total=False):
    """Describes a network insights analysis."""

    NetworkInsightsAnalysisId: Optional[NetworkInsightsAnalysisId]
    NetworkInsightsAnalysisArn: Optional[ResourceArn]
    NetworkInsightsPathId: Optional[NetworkInsightsPathId]
    FilterInArns: Optional[ArnList]
    StartDate: Optional[MillisecondDateTime]
    Status: Optional[AnalysisStatus]
    StatusMessage: Optional[String]
    WarningMessage: Optional[String]
    NetworkPathFound: Optional[Boolean]
    ForwardPathComponents: Optional[PathComponentList]
    ReturnPathComponents: Optional[PathComponentList]
    Explanations: Optional[ExplanationList]
    AlternatePathHints: Optional[AlternatePathHintList]
    Tags: Optional[TagList]


NetworkInsightsAnalysisList = List[NetworkInsightsAnalysis]


class DescribeNetworkInsightsAnalysesResult(TypedDict, total=False):
    NetworkInsightsAnalyses: Optional[NetworkInsightsAnalysisList]
    NextToken: Optional[String]


NetworkInsightsPathIdList = List[NetworkInsightsPathId]


class DescribeNetworkInsightsPathsRequest(ServiceRequest):
    NetworkInsightsPathIds: Optional[NetworkInsightsPathIdList]
    Filters: Optional[FilterList]
    MaxResults: Optional[NetworkInsightsMaxResults]
    DryRun: Optional[Boolean]
    NextToken: Optional[NextToken]


NetworkInsightsPathList = List[NetworkInsightsPath]


class DescribeNetworkInsightsPathsResult(TypedDict, total=False):
    NetworkInsightsPaths: Optional[NetworkInsightsPathList]
    NextToken: Optional[String]


class DescribeNetworkInterfaceAttributeRequest(ServiceRequest):
    """Contains the parameters for DescribeNetworkInterfaceAttribute."""

    Attribute: Optional[NetworkInterfaceAttribute]
    DryRun: Optional[Boolean]
    NetworkInterfaceId: NetworkInterfaceId


class DescribeNetworkInterfaceAttributeResult(TypedDict, total=False):
    """Contains the output of DescribeNetworkInterfaceAttribute."""

    Attachment: Optional[NetworkInterfaceAttachment]
    Description: Optional[AttributeValue]
    Groups: Optional[GroupIdentifierList]
    NetworkInterfaceId: Optional[String]
    SourceDestCheck: Optional[AttributeBooleanValue]


NetworkInterfacePermissionIdList = List[NetworkInterfacePermissionId]


class DescribeNetworkInterfacePermissionsRequest(ServiceRequest):
    """Contains the parameters for DescribeNetworkInterfacePermissions."""

    NetworkInterfacePermissionIds: Optional[NetworkInterfacePermissionIdList]
    Filters: Optional[FilterList]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeNetworkInterfacePermissionsMaxResults]


NetworkInterfacePermissionList = List[NetworkInterfacePermission]


class DescribeNetworkInterfacePermissionsResult(TypedDict, total=False):
    """Contains the output for DescribeNetworkInterfacePermissions."""

    NetworkInterfacePermissions: Optional[NetworkInterfacePermissionList]
    NextToken: Optional[String]


NetworkInterfaceIdList = List[NetworkInterfaceId]


class DescribeNetworkInterfacesRequest(ServiceRequest):
    """Contains the parameters for DescribeNetworkInterfaces."""

    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    NetworkInterfaceIds: Optional[NetworkInterfaceIdList]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeNetworkInterfacesMaxResults]


NetworkInterfaceList = List[NetworkInterface]


class DescribeNetworkInterfacesResult(TypedDict, total=False):
    """Contains the output of DescribeNetworkInterfaces."""

    NetworkInterfaces: Optional[NetworkInterfaceList]
    NextToken: Optional[String]


PlacementGroupIdStringList = List[PlacementGroupId]
PlacementGroupStringList = List[PlacementGroupName]


class DescribePlacementGroupsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    GroupNames: Optional[PlacementGroupStringList]
    GroupIds: Optional[PlacementGroupIdStringList]


PlacementGroupList = List[PlacementGroup]


class DescribePlacementGroupsResult(TypedDict, total=False):
    PlacementGroups: Optional[PlacementGroupList]


PrefixListResourceIdStringList = List[PrefixListResourceId]


class DescribePrefixListsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    PrefixListIds: Optional[PrefixListResourceIdStringList]


class PrefixList(TypedDict, total=False):
    """Describes prefixes for Amazon Web Services services."""

    Cidrs: Optional[ValueStringList]
    PrefixListId: Optional[String]
    PrefixListName: Optional[String]


PrefixListSet = List[PrefixList]


class DescribePrefixListsResult(TypedDict, total=False):
    NextToken: Optional[String]
    PrefixLists: Optional[PrefixListSet]


ResourceList = List[String]


class DescribePrincipalIdFormatRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Resources: Optional[ResourceList]
    MaxResults: Optional[DescribePrincipalIdFormatMaxResults]
    NextToken: Optional[String]


class PrincipalIdFormat(TypedDict, total=False):
    """PrincipalIdFormat description"""

    Arn: Optional[String]
    Statuses: Optional[IdFormatList]


PrincipalIdFormatList = List[PrincipalIdFormat]


class DescribePrincipalIdFormatResult(TypedDict, total=False):
    Principals: Optional[PrincipalIdFormatList]
    NextToken: Optional[String]


PublicIpv4PoolIdStringList = List[Ipv4PoolEc2Id]


class DescribePublicIpv4PoolsRequest(ServiceRequest):
    PoolIds: Optional[PublicIpv4PoolIdStringList]
    NextToken: Optional[NextToken]
    MaxResults: Optional[PoolMaxResults]
    Filters: Optional[FilterList]


class PublicIpv4PoolRange(TypedDict, total=False):
    """Describes an address range of an IPv4 address pool."""

    FirstAddress: Optional[String]
    LastAddress: Optional[String]
    AddressCount: Optional[Integer]
    AvailableAddressCount: Optional[Integer]


PublicIpv4PoolRangeSet = List[PublicIpv4PoolRange]


class PublicIpv4Pool(TypedDict, total=False):
    """Describes an IPv4 address pool."""

    PoolId: Optional[String]
    Description: Optional[String]
    PoolAddressRanges: Optional[PublicIpv4PoolRangeSet]
    TotalAddressCount: Optional[Integer]
    TotalAvailableAddressCount: Optional[Integer]
    NetworkBorderGroup: Optional[String]
    Tags: Optional[TagList]


PublicIpv4PoolSet = List[PublicIpv4Pool]


class DescribePublicIpv4PoolsResult(TypedDict, total=False):
    PublicIpv4Pools: Optional[PublicIpv4PoolSet]
    NextToken: Optional[String]


RegionNameStringList = List[String]


class DescribeRegionsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    RegionNames: Optional[RegionNameStringList]
    DryRun: Optional[Boolean]
    AllRegions: Optional[Boolean]


class Region(TypedDict, total=False):
    """Describes a Region."""

    Endpoint: Optional[String]
    RegionName: Optional[String]
    OptInStatus: Optional[String]


RegionList = List[Region]


class DescribeRegionsResult(TypedDict, total=False):
    Regions: Optional[RegionList]


ReplaceRootVolumeTaskIds = List[ReplaceRootVolumeTaskId]


class DescribeReplaceRootVolumeTasksRequest(ServiceRequest):
    ReplaceRootVolumeTaskIds: Optional[ReplaceRootVolumeTaskIds]
    Filters: Optional[FilterList]
    MaxResults: Optional[DescribeReplaceRootVolumeTasksMaxResults]
    NextToken: Optional[NextToken]
    DryRun: Optional[Boolean]


ReplaceRootVolumeTasks = List[ReplaceRootVolumeTask]


class DescribeReplaceRootVolumeTasksResult(TypedDict, total=False):
    ReplaceRootVolumeTasks: Optional[ReplaceRootVolumeTasks]
    NextToken: Optional[String]


class DescribeReservedInstancesListingsRequest(ServiceRequest):
    """Contains the parameters for DescribeReservedInstancesListings."""

    Filters: Optional[FilterList]
    ReservedInstancesId: Optional[ReservationId]
    ReservedInstancesListingId: Optional[ReservedInstancesListingId]


class DescribeReservedInstancesListingsResult(TypedDict, total=False):
    """Contains the output of DescribeReservedInstancesListings."""

    ReservedInstancesListings: Optional[ReservedInstancesListingList]


ReservedInstancesModificationIdStringList = List[ReservedInstancesModificationId]


class DescribeReservedInstancesModificationsRequest(ServiceRequest):
    """Contains the parameters for DescribeReservedInstancesModifications."""

    Filters: Optional[FilterList]
    ReservedInstancesModificationIds: Optional[ReservedInstancesModificationIdStringList]
    NextToken: Optional[String]


class ReservedInstancesId(TypedDict, total=False):
    """Describes the ID of a Reserved Instance."""

    ReservedInstancesId: Optional[String]


ReservedIntancesIds = List[ReservedInstancesId]


class ReservedInstancesConfiguration(TypedDict, total=False):
    """Describes the configuration settings for the modified Reserved
    Instances.
    """

    AvailabilityZone: Optional[String]
    InstanceCount: Optional[Integer]
    InstanceType: Optional[InstanceType]
    Platform: Optional[String]
    Scope: Optional[scope]


class ReservedInstancesModificationResult(TypedDict, total=False):
    """Describes the modification request/s."""

    ReservedInstancesId: Optional[String]
    TargetConfiguration: Optional[ReservedInstancesConfiguration]


ReservedInstancesModificationResultList = List[ReservedInstancesModificationResult]


class ReservedInstancesModification(TypedDict, total=False):
    """Describes a Reserved Instance modification."""

    ClientToken: Optional[String]
    CreateDate: Optional[DateTime]
    EffectiveDate: Optional[DateTime]
    ModificationResults: Optional[ReservedInstancesModificationResultList]
    ReservedInstancesIds: Optional[ReservedIntancesIds]
    ReservedInstancesModificationId: Optional[String]
    Status: Optional[String]
    StatusMessage: Optional[String]
    UpdateDate: Optional[DateTime]


ReservedInstancesModificationList = List[ReservedInstancesModification]


class DescribeReservedInstancesModificationsResult(TypedDict, total=False):
    """Contains the output of DescribeReservedInstancesModifications."""

    NextToken: Optional[String]
    ReservedInstancesModifications: Optional[ReservedInstancesModificationList]


ReservedInstancesOfferingIdStringList = List[ReservedInstancesOfferingId]


class DescribeReservedInstancesOfferingsRequest(ServiceRequest):
    """Contains the parameters for DescribeReservedInstancesOfferings."""

    AvailabilityZone: Optional[String]
    Filters: Optional[FilterList]
    IncludeMarketplace: Optional[Boolean]
    InstanceType: Optional[InstanceType]
    MaxDuration: Optional[Long]
    MaxInstanceCount: Optional[Integer]
    MinDuration: Optional[Long]
    OfferingClass: Optional[OfferingClassType]
    ProductDescription: Optional[RIProductDescription]
    ReservedInstancesOfferingIds: Optional[ReservedInstancesOfferingIdStringList]
    DryRun: Optional[Boolean]
    InstanceTenancy: Optional[Tenancy]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    OfferingType: Optional[OfferingTypeValues]


class RecurringCharge(TypedDict, total=False):
    """Describes a recurring charge."""

    Amount: Optional[Double]
    Frequency: Optional[RecurringChargeFrequency]


RecurringChargesList = List[RecurringCharge]


class PricingDetail(TypedDict, total=False):
    """Describes a Reserved Instance offering."""

    Count: Optional[Integer]
    Price: Optional[Double]


PricingDetailsList = List[PricingDetail]


class ReservedInstancesOffering(TypedDict, total=False):
    """Describes a Reserved Instance offering."""

    AvailabilityZone: Optional[String]
    Duration: Optional[Long]
    FixedPrice: Optional[Float]
    InstanceType: Optional[InstanceType]
    ProductDescription: Optional[RIProductDescription]
    ReservedInstancesOfferingId: Optional[String]
    UsagePrice: Optional[Float]
    CurrencyCode: Optional[CurrencyCodeValues]
    InstanceTenancy: Optional[Tenancy]
    Marketplace: Optional[Boolean]
    OfferingClass: Optional[OfferingClassType]
    OfferingType: Optional[OfferingTypeValues]
    PricingDetails: Optional[PricingDetailsList]
    RecurringCharges: Optional[RecurringChargesList]
    Scope: Optional[scope]


ReservedInstancesOfferingList = List[ReservedInstancesOffering]


class DescribeReservedInstancesOfferingsResult(TypedDict, total=False):
    """Contains the output of DescribeReservedInstancesOfferings."""

    ReservedInstancesOfferings: Optional[ReservedInstancesOfferingList]
    NextToken: Optional[String]


ReservedInstancesIdStringList = List[ReservationId]


class DescribeReservedInstancesRequest(ServiceRequest):
    """Contains the parameters for DescribeReservedInstances."""

    Filters: Optional[FilterList]
    OfferingClass: Optional[OfferingClassType]
    ReservedInstancesIds: Optional[ReservedInstancesIdStringList]
    DryRun: Optional[Boolean]
    OfferingType: Optional[OfferingTypeValues]


class ReservedInstances(TypedDict, total=False):
    """Describes a Reserved Instance."""

    AvailabilityZone: Optional[String]
    Duration: Optional[Long]
    End: Optional[DateTime]
    FixedPrice: Optional[Float]
    InstanceCount: Optional[Integer]
    InstanceType: Optional[InstanceType]
    ProductDescription: Optional[RIProductDescription]
    ReservedInstancesId: Optional[String]
    Start: Optional[DateTime]
    State: Optional[ReservedInstanceState]
    UsagePrice: Optional[Float]
    CurrencyCode: Optional[CurrencyCodeValues]
    InstanceTenancy: Optional[Tenancy]
    OfferingClass: Optional[OfferingClassType]
    OfferingType: Optional[OfferingTypeValues]
    RecurringCharges: Optional[RecurringChargesList]
    Scope: Optional[scope]
    Tags: Optional[TagList]


ReservedInstancesList = List[ReservedInstances]


class DescribeReservedInstancesResult(TypedDict, total=False):
    """Contains the output for DescribeReservedInstances."""

    ReservedInstances: Optional[ReservedInstancesList]


RouteTableIdStringList = List[RouteTableId]


class DescribeRouteTablesRequest(ServiceRequest):
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    RouteTableIds: Optional[RouteTableIdStringList]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeRouteTablesMaxResults]


RouteTableList = List[RouteTable]


class DescribeRouteTablesResult(TypedDict, total=False):
    """Contains the output of DescribeRouteTables."""

    RouteTables: Optional[RouteTableList]
    NextToken: Optional[String]


OccurrenceDayRequestSet = List[Integer]


class ScheduledInstanceRecurrenceRequest(TypedDict, total=False):
    """Describes the recurring schedule for a Scheduled Instance."""

    Frequency: Optional[String]
    Interval: Optional[Integer]
    OccurrenceDays: Optional[OccurrenceDayRequestSet]
    OccurrenceRelativeToEnd: Optional[Boolean]
    OccurrenceUnit: Optional[String]


class SlotDateTimeRangeRequest(TypedDict, total=False):
    """Describes the time period for a Scheduled Instance to start its first
    schedule. The time period must span less than one day.
    """

    EarliestTime: DateTime
    LatestTime: DateTime


class DescribeScheduledInstanceAvailabilityRequest(ServiceRequest):
    """Contains the parameters for DescribeScheduledInstanceAvailability."""

    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    FirstSlotStartTimeRange: SlotDateTimeRangeRequest
    MaxResults: Optional[DescribeScheduledInstanceAvailabilityMaxResults]
    MaxSlotDurationInHours: Optional[Integer]
    MinSlotDurationInHours: Optional[Integer]
    NextToken: Optional[String]
    Recurrence: ScheduledInstanceRecurrenceRequest


OccurrenceDaySet = List[Integer]


class ScheduledInstanceRecurrence(TypedDict, total=False):
    """Describes the recurring schedule for a Scheduled Instance."""

    Frequency: Optional[String]
    Interval: Optional[Integer]
    OccurrenceDaySet: Optional[OccurrenceDaySet]
    OccurrenceRelativeToEnd: Optional[Boolean]
    OccurrenceUnit: Optional[String]


class ScheduledInstanceAvailability(TypedDict, total=False):
    """Describes a schedule that is available for your Scheduled Instances."""

    AvailabilityZone: Optional[String]
    AvailableInstanceCount: Optional[Integer]
    FirstSlotStartTime: Optional[DateTime]
    HourlyPrice: Optional[String]
    InstanceType: Optional[String]
    MaxTermDurationInDays: Optional[Integer]
    MinTermDurationInDays: Optional[Integer]
    NetworkPlatform: Optional[String]
    Platform: Optional[String]
    PurchaseToken: Optional[String]
    Recurrence: Optional[ScheduledInstanceRecurrence]
    SlotDurationInHours: Optional[Integer]
    TotalScheduledInstanceHours: Optional[Integer]


ScheduledInstanceAvailabilitySet = List[ScheduledInstanceAvailability]


class DescribeScheduledInstanceAvailabilityResult(TypedDict, total=False):
    """Contains the output of DescribeScheduledInstanceAvailability."""

    NextToken: Optional[String]
    ScheduledInstanceAvailabilitySet: Optional[ScheduledInstanceAvailabilitySet]


class SlotStartTimeRangeRequest(TypedDict, total=False):
    """Describes the time period for a Scheduled Instance to start its first
    schedule.
    """

    EarliestTime: Optional[DateTime]
    LatestTime: Optional[DateTime]


ScheduledInstanceIdRequestSet = List[ScheduledInstanceId]


class DescribeScheduledInstancesRequest(ServiceRequest):
    """Contains the parameters for DescribeScheduledInstances."""

    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    ScheduledInstanceIds: Optional[ScheduledInstanceIdRequestSet]
    SlotStartTimeRange: Optional[SlotStartTimeRangeRequest]


class ScheduledInstance(TypedDict, total=False):
    """Describes a Scheduled Instance."""

    AvailabilityZone: Optional[String]
    CreateDate: Optional[DateTime]
    HourlyPrice: Optional[String]
    InstanceCount: Optional[Integer]
    InstanceType: Optional[String]
    NetworkPlatform: Optional[String]
    NextSlotStartTime: Optional[DateTime]
    Platform: Optional[String]
    PreviousSlotEndTime: Optional[DateTime]
    Recurrence: Optional[ScheduledInstanceRecurrence]
    ScheduledInstanceId: Optional[String]
    SlotDurationInHours: Optional[Integer]
    TermEndDate: Optional[DateTime]
    TermStartDate: Optional[DateTime]
    TotalScheduledInstanceHours: Optional[Integer]


ScheduledInstanceSet = List[ScheduledInstance]


class DescribeScheduledInstancesResult(TypedDict, total=False):
    """Contains the output of DescribeScheduledInstances."""

    NextToken: Optional[String]
    ScheduledInstanceSet: Optional[ScheduledInstanceSet]


GroupIds = List[SecurityGroupId]


class DescribeSecurityGroupReferencesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    GroupId: GroupIds


class SecurityGroupReference(TypedDict, total=False):
    """Describes a VPC with a security group that references your security
    group.
    """

    GroupId: Optional[String]
    ReferencingVpcId: Optional[String]
    VpcPeeringConnectionId: Optional[String]


SecurityGroupReferences = List[SecurityGroupReference]


class DescribeSecurityGroupReferencesResult(TypedDict, total=False):
    SecurityGroupReferenceSet: Optional[SecurityGroupReferences]


SecurityGroupRuleIdList = List[String]


class DescribeSecurityGroupRulesRequest(ServiceRequest):
    Filters: Optional[FilterList]
    SecurityGroupRuleIds: Optional[SecurityGroupRuleIdList]
    DryRun: Optional[Boolean]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeSecurityGroupRulesMaxResults]


class DescribeSecurityGroupRulesResult(TypedDict, total=False):
    SecurityGroupRules: Optional[SecurityGroupRuleList]
    NextToken: Optional[String]


GroupNameStringList = List[SecurityGroupName]


class DescribeSecurityGroupsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    GroupIds: Optional[GroupIdStringList]
    GroupNames: Optional[GroupNameStringList]
    DryRun: Optional[Boolean]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeSecurityGroupsMaxResults]


class SecurityGroup(TypedDict, total=False):
    """Describes a security group."""

    Description: Optional[String]
    GroupName: Optional[String]
    IpPermissions: Optional[IpPermissionList]
    OwnerId: Optional[String]
    GroupId: Optional[String]
    IpPermissionsEgress: Optional[IpPermissionList]
    Tags: Optional[TagList]
    VpcId: Optional[String]


SecurityGroupList = List[SecurityGroup]


class DescribeSecurityGroupsResult(TypedDict, total=False):
    SecurityGroups: Optional[SecurityGroupList]
    NextToken: Optional[String]


class DescribeSnapshotAttributeRequest(ServiceRequest):
    Attribute: SnapshotAttributeName
    SnapshotId: SnapshotId
    DryRun: Optional[Boolean]


class DescribeSnapshotAttributeResult(TypedDict, total=False):
    CreateVolumePermissions: Optional[CreateVolumePermissionList]
    ProductCodes: Optional[ProductCodeList]
    SnapshotId: Optional[String]


class DescribeSnapshotTierStatusRequest(ServiceRequest):
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeSnapshotTierStatusMaxResults]


class SnapshotTierStatus(TypedDict, total=False):
    """Provides information about a snapshot's storage tier."""

    SnapshotId: Optional[SnapshotId]
    VolumeId: Optional[VolumeId]
    Status: Optional[SnapshotState]
    OwnerId: Optional[String]
    Tags: Optional[TagList]
    StorageTier: Optional[StorageTier]
    LastTieringStartTime: Optional[MillisecondDateTime]
    LastTieringProgress: Optional[Integer]
    LastTieringOperationStatus: Optional[TieringOperationStatus]
    LastTieringOperationStatusDetail: Optional[String]
    ArchivalCompleteTime: Optional[MillisecondDateTime]
    RestoreExpiryTime: Optional[MillisecondDateTime]


snapshotTierStatusSet = List[SnapshotTierStatus]


class DescribeSnapshotTierStatusResult(TypedDict, total=False):
    SnapshotTierStatuses: Optional[snapshotTierStatusSet]
    NextToken: Optional[String]


SnapshotIdStringList = List[SnapshotId]
RestorableByStringList = List[String]


class DescribeSnapshotsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    OwnerIds: Optional[OwnerStringList]
    RestorableByUserIds: Optional[RestorableByStringList]
    SnapshotIds: Optional[SnapshotIdStringList]
    DryRun: Optional[Boolean]


class Snapshot(TypedDict, total=False):
    """Describes a snapshot."""

    DataEncryptionKeyId: Optional[String]
    Description: Optional[String]
    Encrypted: Optional[Boolean]
    KmsKeyId: Optional[String]
    OwnerId: Optional[String]
    Progress: Optional[String]
    SnapshotId: Optional[String]
    StartTime: Optional[DateTime]
    State: Optional[SnapshotState]
    StateMessage: Optional[String]
    VolumeId: Optional[String]
    VolumeSize: Optional[Integer]
    OwnerAlias: Optional[String]
    OutpostArn: Optional[String]
    Tags: Optional[TagList]
    StorageTier: Optional[StorageTier]
    RestoreExpiryTime: Optional[MillisecondDateTime]


SnapshotList = List[Snapshot]


class DescribeSnapshotsResult(TypedDict, total=False):
    Snapshots: Optional[SnapshotList]
    NextToken: Optional[String]


class DescribeSpotDatafeedSubscriptionRequest(ServiceRequest):
    """Contains the parameters for DescribeSpotDatafeedSubscription."""

    DryRun: Optional[Boolean]


class DescribeSpotDatafeedSubscriptionResult(TypedDict, total=False):
    """Contains the output of DescribeSpotDatafeedSubscription."""

    SpotDatafeedSubscription: Optional[SpotDatafeedSubscription]


class DescribeSpotFleetInstancesRequest(ServiceRequest):
    """Contains the parameters for DescribeSpotFleetInstances."""

    DryRun: Optional[Boolean]
    MaxResults: Optional[DescribeSpotFleetInstancesMaxResults]
    NextToken: Optional[String]
    SpotFleetRequestId: SpotFleetRequestId


class DescribeSpotFleetInstancesResponse(TypedDict, total=False):
    """Contains the output of DescribeSpotFleetInstances."""

    ActiveInstances: Optional[ActiveInstanceSet]
    NextToken: Optional[String]
    SpotFleetRequestId: Optional[String]


class DescribeSpotFleetRequestHistoryRequest(ServiceRequest):
    """Contains the parameters for DescribeSpotFleetRequestHistory."""

    DryRun: Optional[Boolean]
    EventType: Optional[EventType]
    MaxResults: Optional[DescribeSpotFleetRequestHistoryMaxResults]
    NextToken: Optional[String]
    SpotFleetRequestId: SpotFleetRequestId
    StartTime: DateTime


class HistoryRecord(TypedDict, total=False):
    """Describes an event in the history of the Spot Fleet request."""

    EventInformation: Optional[EventInformation]
    EventType: Optional[EventType]
    Timestamp: Optional[DateTime]


HistoryRecords = List[HistoryRecord]


class DescribeSpotFleetRequestHistoryResponse(TypedDict, total=False):
    """Contains the output of DescribeSpotFleetRequestHistory."""

    HistoryRecords: Optional[HistoryRecords]
    LastEvaluatedTime: Optional[DateTime]
    NextToken: Optional[String]
    SpotFleetRequestId: Optional[String]
    StartTime: Optional[DateTime]


class DescribeSpotFleetRequestsRequest(ServiceRequest):
    """Contains the parameters for DescribeSpotFleetRequests."""

    DryRun: Optional[Boolean]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    SpotFleetRequestIds: Optional[SpotFleetRequestIdList]


class TargetGroup(TypedDict, total=False):
    """Describes a load balancer target group."""

    Arn: Optional[String]


TargetGroups = List[TargetGroup]


class TargetGroupsConfig(TypedDict, total=False):
    """Describes the target groups to attach to a Spot Fleet. Spot Fleet
    registers the running Spot Instances with these target groups.
    """

    TargetGroups: Optional[TargetGroups]


class LoadBalancersConfig(TypedDict, total=False):
    """Describes the Classic Load Balancers and target groups to attach to a
    Spot Fleet request.
    """

    ClassicLoadBalancersConfig: Optional[ClassicLoadBalancersConfig]
    TargetGroupsConfig: Optional[TargetGroupsConfig]


class LaunchTemplateOverrides(TypedDict, total=False):
    """Describes overrides for a launch template."""

    InstanceType: Optional[InstanceType]
    SpotPrice: Optional[String]
    SubnetId: Optional[SubnetId]
    AvailabilityZone: Optional[String]
    WeightedCapacity: Optional[Double]
    Priority: Optional[Double]
    InstanceRequirements: Optional[InstanceRequirements]


LaunchTemplateOverridesList = List[LaunchTemplateOverrides]


class LaunchTemplateConfig(TypedDict, total=False):
    """Describes a launch template and overrides."""

    LaunchTemplateSpecification: Optional[FleetLaunchTemplateSpecification]
    Overrides: Optional[LaunchTemplateOverridesList]


LaunchTemplateConfigList = List[LaunchTemplateConfig]


class SpotFleetTagSpecification(TypedDict, total=False):
    """The tags for a Spot Fleet resource."""

    ResourceType: Optional[ResourceType]
    Tags: Optional[TagList]


SpotFleetTagSpecificationList = List[SpotFleetTagSpecification]


class SpotPlacement(TypedDict, total=False):
    """Describes Spot Instance placement."""

    AvailabilityZone: Optional[String]
    GroupName: Optional[PlacementGroupName]
    Tenancy: Optional[Tenancy]


class InstanceNetworkInterfaceSpecification(TypedDict, total=False):
    """Describes a network interface."""

    AssociatePublicIpAddress: Optional[Boolean]
    DeleteOnTermination: Optional[Boolean]
    Description: Optional[String]
    DeviceIndex: Optional[Integer]
    Groups: Optional[SecurityGroupIdStringList]
    Ipv6AddressCount: Optional[Integer]
    Ipv6Addresses: Optional[InstanceIpv6AddressList]
    NetworkInterfaceId: Optional[NetworkInterfaceId]
    PrivateIpAddress: Optional[String]
    PrivateIpAddresses: Optional[PrivateIpAddressSpecificationList]
    SecondaryPrivateIpAddressCount: Optional[Integer]
    SubnetId: Optional[String]
    AssociateCarrierIpAddress: Optional[Boolean]
    InterfaceType: Optional[String]
    NetworkCardIndex: Optional[Integer]
    Ipv4Prefixes: Optional[Ipv4PrefixList]
    Ipv4PrefixCount: Optional[Integer]
    Ipv6Prefixes: Optional[Ipv6PrefixList]
    Ipv6PrefixCount: Optional[Integer]


InstanceNetworkInterfaceSpecificationList = List[InstanceNetworkInterfaceSpecification]


class SpotFleetMonitoring(TypedDict, total=False):
    """Describes whether monitoring is enabled."""

    Enabled: Optional[Boolean]


class SpotFleetLaunchSpecification(TypedDict, total=False):
    """Describes the launch specification for one or more Spot Instances. If
    you include On-Demand capacity in your fleet request or want to specify
    an EFA network device, you can't use ``SpotFleetLaunchSpecification``;
    you must use
    `LaunchTemplateConfig <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html>`__.
    """

    SecurityGroups: Optional[GroupIdentifierList]
    AddressingType: Optional[String]
    BlockDeviceMappings: Optional[BlockDeviceMappingList]
    EbsOptimized: Optional[Boolean]
    IamInstanceProfile: Optional[IamInstanceProfileSpecification]
    ImageId: Optional[ImageId]
    InstanceType: Optional[InstanceType]
    KernelId: Optional[String]
    KeyName: Optional[KeyPairName]
    Monitoring: Optional[SpotFleetMonitoring]
    NetworkInterfaces: Optional[InstanceNetworkInterfaceSpecificationList]
    Placement: Optional[SpotPlacement]
    RamdiskId: Optional[String]
    SpotPrice: Optional[String]
    SubnetId: Optional[SubnetId]
    UserData: Optional[String]
    WeightedCapacity: Optional[Double]
    TagSpecifications: Optional[SpotFleetTagSpecificationList]
    InstanceRequirements: Optional[InstanceRequirements]


LaunchSpecsList = List[SpotFleetLaunchSpecification]


class SpotCapacityRebalance(TypedDict, total=False):
    """The Spot Instance replacement strategy to use when Amazon EC2 emits a
    signal that your Spot Instance is at an elevated risk of being
    interrupted. For more information, see `Capacity
    rebalancing <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-capacity-rebalance.html>`__
    in the *Amazon EC2 User Guide for Linux Instances*.
    """

    ReplacementStrategy: Optional[ReplacementStrategy]
    TerminationDelay: Optional[Integer]


class SpotMaintenanceStrategies(TypedDict, total=False):
    """The strategies for managing your Spot Instances that are at an elevated
    risk of being interrupted.
    """

    CapacityRebalance: Optional[SpotCapacityRebalance]


class SpotFleetRequestConfigData(TypedDict, total=False):
    """Describes the configuration of a Spot Fleet request."""

    AllocationStrategy: Optional[AllocationStrategy]
    OnDemandAllocationStrategy: Optional[OnDemandAllocationStrategy]
    SpotMaintenanceStrategies: Optional[SpotMaintenanceStrategies]
    ClientToken: Optional[String]
    ExcessCapacityTerminationPolicy: Optional[ExcessCapacityTerminationPolicy]
    FulfilledCapacity: Optional[Double]
    OnDemandFulfilledCapacity: Optional[Double]
    IamFleetRole: String
    LaunchSpecifications: Optional[LaunchSpecsList]
    LaunchTemplateConfigs: Optional[LaunchTemplateConfigList]
    SpotPrice: Optional[String]
    TargetCapacity: Integer
    OnDemandTargetCapacity: Optional[Integer]
    OnDemandMaxTotalPrice: Optional[String]
    SpotMaxTotalPrice: Optional[String]
    TerminateInstancesWithExpiration: Optional[Boolean]
    Type: Optional[FleetType]
    ValidFrom: Optional[DateTime]
    ValidUntil: Optional[DateTime]
    ReplaceUnhealthyInstances: Optional[Boolean]
    InstanceInterruptionBehavior: Optional[InstanceInterruptionBehavior]
    LoadBalancersConfig: Optional[LoadBalancersConfig]
    InstancePoolsToUseCount: Optional[Integer]
    Context: Optional[String]
    TargetCapacityUnitType: Optional[TargetCapacityUnitType]
    TagSpecifications: Optional[TagSpecificationList]


class SpotFleetRequestConfig(TypedDict, total=False):
    """Describes a Spot Fleet request."""

    ActivityStatus: Optional[ActivityStatus]
    CreateTime: Optional[MillisecondDateTime]
    SpotFleetRequestConfig: Optional[SpotFleetRequestConfigData]
    SpotFleetRequestId: Optional[String]
    SpotFleetRequestState: Optional[BatchState]
    Tags: Optional[TagList]


SpotFleetRequestConfigSet = List[SpotFleetRequestConfig]


class DescribeSpotFleetRequestsResponse(TypedDict, total=False):
    """Contains the output of DescribeSpotFleetRequests."""

    NextToken: Optional[String]
    SpotFleetRequestConfigs: Optional[SpotFleetRequestConfigSet]


class DescribeSpotInstanceRequestsRequest(ServiceRequest):
    """Contains the parameters for DescribeSpotInstanceRequests."""

    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    SpotInstanceRequestIds: Optional[SpotInstanceRequestIdList]
    NextToken: Optional[String]
    MaxResults: Optional[Integer]


class SpotInstanceStatus(TypedDict, total=False):
    """Describes the status of a Spot Instance request."""

    Code: Optional[String]
    Message: Optional[String]
    UpdateTime: Optional[DateTime]


class RunInstancesMonitoringEnabled(TypedDict, total=False):
    """Describes the monitoring of an instance."""

    Enabled: Boolean


class LaunchSpecification(TypedDict, total=False):
    """Describes the launch specification for an instance."""

    UserData: Optional[String]
    SecurityGroups: Optional[GroupIdentifierList]
    AddressingType: Optional[String]
    BlockDeviceMappings: Optional[BlockDeviceMappingList]
    EbsOptimized: Optional[Boolean]
    IamInstanceProfile: Optional[IamInstanceProfileSpecification]
    ImageId: Optional[String]
    InstanceType: Optional[InstanceType]
    KernelId: Optional[String]
    KeyName: Optional[String]
    NetworkInterfaces: Optional[InstanceNetworkInterfaceSpecificationList]
    Placement: Optional[SpotPlacement]
    RamdiskId: Optional[String]
    SubnetId: Optional[String]
    Monitoring: Optional[RunInstancesMonitoringEnabled]


class SpotInstanceRequest(TypedDict, total=False):
    """Describes a Spot Instance request."""

    ActualBlockHourlyPrice: Optional[String]
    AvailabilityZoneGroup: Optional[String]
    BlockDurationMinutes: Optional[Integer]
    CreateTime: Optional[DateTime]
    Fault: Optional[SpotInstanceStateFault]
    InstanceId: Optional[InstanceId]
    LaunchGroup: Optional[String]
    LaunchSpecification: Optional[LaunchSpecification]
    LaunchedAvailabilityZone: Optional[String]
    ProductDescription: Optional[RIProductDescription]
    SpotInstanceRequestId: Optional[String]
    SpotPrice: Optional[String]
    State: Optional[SpotInstanceState]
    Status: Optional[SpotInstanceStatus]
    Tags: Optional[TagList]
    Type: Optional[SpotInstanceType]
    ValidFrom: Optional[DateTime]
    ValidUntil: Optional[DateTime]
    InstanceInterruptionBehavior: Optional[InstanceInterruptionBehavior]


SpotInstanceRequestList = List[SpotInstanceRequest]


class DescribeSpotInstanceRequestsResult(TypedDict, total=False):
    """Contains the output of DescribeSpotInstanceRequests."""

    SpotInstanceRequests: Optional[SpotInstanceRequestList]
    NextToken: Optional[String]


ProductDescriptionList = List[String]
InstanceTypeList = List[InstanceType]


class DescribeSpotPriceHistoryRequest(ServiceRequest):
    """Contains the parameters for DescribeSpotPriceHistory."""

    Filters: Optional[FilterList]
    AvailabilityZone: Optional[String]
    DryRun: Optional[Boolean]
    EndTime: Optional[DateTime]
    InstanceTypes: Optional[InstanceTypeList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    ProductDescriptions: Optional[ProductDescriptionList]
    StartTime: Optional[DateTime]


class SpotPrice(TypedDict, total=False):
    """Describes the maximum price per hour that you are willing to pay for a
    Spot Instance.
    """

    AvailabilityZone: Optional[String]
    InstanceType: Optional[InstanceType]
    ProductDescription: Optional[RIProductDescription]
    SpotPrice: Optional[String]
    Timestamp: Optional[DateTime]


SpotPriceHistoryList = List[SpotPrice]


class DescribeSpotPriceHistoryResult(TypedDict, total=False):
    """Contains the output of DescribeSpotPriceHistory."""

    NextToken: Optional[String]
    SpotPriceHistory: Optional[SpotPriceHistoryList]


class DescribeStaleSecurityGroupsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    MaxResults: Optional[DescribeStaleSecurityGroupsMaxResults]
    NextToken: Optional[DescribeStaleSecurityGroupsNextToken]
    VpcId: VpcId


UserIdGroupPairSet = List[UserIdGroupPair]
PrefixListIdSet = List[String]
IpRanges = List[String]


class StaleIpPermission(TypedDict, total=False):
    """Describes a stale rule in a security group."""

    FromPort: Optional[Integer]
    IpProtocol: Optional[String]
    IpRanges: Optional[IpRanges]
    PrefixListIds: Optional[PrefixListIdSet]
    ToPort: Optional[Integer]
    UserIdGroupPairs: Optional[UserIdGroupPairSet]


StaleIpPermissionSet = List[StaleIpPermission]


class StaleSecurityGroup(TypedDict, total=False):
    """Describes a stale security group (a security group that contains stale
    rules).
    """

    Description: Optional[String]
    GroupId: Optional[String]
    GroupName: Optional[String]
    StaleIpPermissions: Optional[StaleIpPermissionSet]
    StaleIpPermissionsEgress: Optional[StaleIpPermissionSet]
    VpcId: Optional[String]


StaleSecurityGroupSet = List[StaleSecurityGroup]


class DescribeStaleSecurityGroupsResult(TypedDict, total=False):
    NextToken: Optional[String]
    StaleSecurityGroupSet: Optional[StaleSecurityGroupSet]


ImageIdList = List[ImageId]


class DescribeStoreImageTasksRequest(ServiceRequest):
    ImageIds: Optional[ImageIdList]
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeStoreImageTasksRequestMaxResults]


class StoreImageTaskResult(TypedDict, total=False):
    """The information about the AMI store task, including the progress of the
    task.
    """

    AmiId: Optional[String]
    TaskStartTime: Optional[MillisecondDateTime]
    Bucket: Optional[String]
    S3objectKey: Optional[String]
    ProgressPercentage: Optional[Integer]
    StoreTaskState: Optional[String]
    StoreTaskFailureReason: Optional[String]


StoreImageTaskResultSet = List[StoreImageTaskResult]


class DescribeStoreImageTasksResult(TypedDict, total=False):
    StoreImageTaskResults: Optional[StoreImageTaskResultSet]
    NextToken: Optional[String]


SubnetIdStringList = List[SubnetId]


class DescribeSubnetsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    SubnetIds: Optional[SubnetIdStringList]
    DryRun: Optional[Boolean]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeSubnetsMaxResults]


SubnetList = List[Subnet]


class DescribeSubnetsResult(TypedDict, total=False):
    Subnets: Optional[SubnetList]
    NextToken: Optional[String]


class DescribeTagsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class TagDescription(TypedDict, total=False):
    """Describes a tag."""

    Key: Optional[String]
    ResourceId: Optional[String]
    ResourceType: Optional[ResourceType]
    Value: Optional[String]


TagDescriptionList = List[TagDescription]


class DescribeTagsResult(TypedDict, total=False):
    NextToken: Optional[String]
    Tags: Optional[TagDescriptionList]


TrafficMirrorFilterIdList = List[TrafficMirrorFilterId]


class DescribeTrafficMirrorFiltersRequest(ServiceRequest):
    TrafficMirrorFilterIds: Optional[TrafficMirrorFilterIdList]
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[TrafficMirroringMaxResults]
    NextToken: Optional[NextToken]


TrafficMirrorFilterSet = List[TrafficMirrorFilter]


class DescribeTrafficMirrorFiltersResult(TypedDict, total=False):
    TrafficMirrorFilters: Optional[TrafficMirrorFilterSet]
    NextToken: Optional[String]


TrafficMirrorSessionIdList = List[TrafficMirrorSessionId]


class DescribeTrafficMirrorSessionsRequest(ServiceRequest):
    TrafficMirrorSessionIds: Optional[TrafficMirrorSessionIdList]
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[TrafficMirroringMaxResults]
    NextToken: Optional[NextToken]


TrafficMirrorSessionSet = List[TrafficMirrorSession]


class DescribeTrafficMirrorSessionsResult(TypedDict, total=False):
    TrafficMirrorSessions: Optional[TrafficMirrorSessionSet]
    NextToken: Optional[String]


TrafficMirrorTargetIdList = List[TrafficMirrorTargetId]


class DescribeTrafficMirrorTargetsRequest(ServiceRequest):
    TrafficMirrorTargetIds: Optional[TrafficMirrorTargetIdList]
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[TrafficMirroringMaxResults]
    NextToken: Optional[NextToken]


TrafficMirrorTargetSet = List[TrafficMirrorTarget]


class DescribeTrafficMirrorTargetsResult(TypedDict, total=False):
    TrafficMirrorTargets: Optional[TrafficMirrorTargetSet]
    NextToken: Optional[String]


TransitGatewayAttachmentIdStringList = List[TransitGatewayAttachmentId]


class DescribeTransitGatewayAttachmentsRequest(ServiceRequest):
    TransitGatewayAttachmentIds: Optional[TransitGatewayAttachmentIdStringList]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class TransitGatewayAttachmentAssociation(TypedDict, total=False):
    """Describes an association."""

    TransitGatewayRouteTableId: Optional[String]
    State: Optional[TransitGatewayAssociationState]


class TransitGatewayAttachment(TypedDict, total=False):
    """Describes an attachment between a resource and a transit gateway."""

    TransitGatewayAttachmentId: Optional[String]
    TransitGatewayId: Optional[String]
    TransitGatewayOwnerId: Optional[String]
    ResourceOwnerId: Optional[String]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]
    ResourceId: Optional[String]
    State: Optional[TransitGatewayAttachmentState]
    Association: Optional[TransitGatewayAttachmentAssociation]
    CreationTime: Optional[DateTime]
    Tags: Optional[TagList]


TransitGatewayAttachmentList = List[TransitGatewayAttachment]


class DescribeTransitGatewayAttachmentsResult(TypedDict, total=False):
    TransitGatewayAttachments: Optional[TransitGatewayAttachmentList]
    NextToken: Optional[String]


TransitGatewayConnectPeerIdStringList = List[TransitGatewayConnectPeerId]


class DescribeTransitGatewayConnectPeersRequest(ServiceRequest):
    TransitGatewayConnectPeerIds: Optional[TransitGatewayConnectPeerIdStringList]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


TransitGatewayConnectPeerList = List[TransitGatewayConnectPeer]


class DescribeTransitGatewayConnectPeersResult(TypedDict, total=False):
    TransitGatewayConnectPeers: Optional[TransitGatewayConnectPeerList]
    NextToken: Optional[String]


class DescribeTransitGatewayConnectsRequest(ServiceRequest):
    TransitGatewayAttachmentIds: Optional[TransitGatewayAttachmentIdStringList]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


TransitGatewayConnectList = List[TransitGatewayConnect]


class DescribeTransitGatewayConnectsResult(TypedDict, total=False):
    TransitGatewayConnects: Optional[TransitGatewayConnectList]
    NextToken: Optional[String]


TransitGatewayMulticastDomainIdStringList = List[TransitGatewayMulticastDomainId]


class DescribeTransitGatewayMulticastDomainsRequest(ServiceRequest):
    TransitGatewayMulticastDomainIds: Optional[TransitGatewayMulticastDomainIdStringList]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


TransitGatewayMulticastDomainList = List[TransitGatewayMulticastDomain]


class DescribeTransitGatewayMulticastDomainsResult(TypedDict, total=False):
    TransitGatewayMulticastDomains: Optional[TransitGatewayMulticastDomainList]
    NextToken: Optional[String]


class DescribeTransitGatewayPeeringAttachmentsRequest(ServiceRequest):
    TransitGatewayAttachmentIds: Optional[TransitGatewayAttachmentIdStringList]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


TransitGatewayPeeringAttachmentList = List[TransitGatewayPeeringAttachment]


class DescribeTransitGatewayPeeringAttachmentsResult(TypedDict, total=False):
    TransitGatewayPeeringAttachments: Optional[TransitGatewayPeeringAttachmentList]
    NextToken: Optional[String]


TransitGatewayRouteTableIdStringList = List[TransitGatewayRouteTableId]


class DescribeTransitGatewayRouteTablesRequest(ServiceRequest):
    TransitGatewayRouteTableIds: Optional[TransitGatewayRouteTableIdStringList]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


TransitGatewayRouteTableList = List[TransitGatewayRouteTable]


class DescribeTransitGatewayRouteTablesResult(TypedDict, total=False):
    TransitGatewayRouteTables: Optional[TransitGatewayRouteTableList]
    NextToken: Optional[String]


class DescribeTransitGatewayVpcAttachmentsRequest(ServiceRequest):
    TransitGatewayAttachmentIds: Optional[TransitGatewayAttachmentIdStringList]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


TransitGatewayVpcAttachmentList = List[TransitGatewayVpcAttachment]


class DescribeTransitGatewayVpcAttachmentsResult(TypedDict, total=False):
    TransitGatewayVpcAttachments: Optional[TransitGatewayVpcAttachmentList]
    NextToken: Optional[String]


TransitGatewayIdStringList = List[TransitGatewayId]


class DescribeTransitGatewaysRequest(ServiceRequest):
    TransitGatewayIds: Optional[TransitGatewayIdStringList]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


TransitGatewayList = List[TransitGateway]


class DescribeTransitGatewaysResult(TypedDict, total=False):
    TransitGateways: Optional[TransitGatewayList]
    NextToken: Optional[String]


TrunkInterfaceAssociationIdList = List[TrunkInterfaceAssociationId]


class DescribeTrunkInterfaceAssociationsRequest(ServiceRequest):
    AssociationIds: Optional[TrunkInterfaceAssociationIdList]
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeTrunkInterfaceAssociationsMaxResults]


TrunkInterfaceAssociationList = List[TrunkInterfaceAssociation]


class DescribeTrunkInterfaceAssociationsResult(TypedDict, total=False):
    InterfaceAssociations: Optional[TrunkInterfaceAssociationList]
    NextToken: Optional[String]


class DescribeVolumeAttributeRequest(ServiceRequest):
    Attribute: VolumeAttributeName
    VolumeId: VolumeId
    DryRun: Optional[Boolean]


class DescribeVolumeAttributeResult(TypedDict, total=False):
    AutoEnableIO: Optional[AttributeBooleanValue]
    ProductCodes: Optional[ProductCodeList]
    VolumeId: Optional[String]


VolumeIdStringList = List[VolumeId]


class DescribeVolumeStatusRequest(ServiceRequest):
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]
    VolumeIds: Optional[VolumeIdStringList]
    DryRun: Optional[Boolean]


class VolumeStatusAttachmentStatus(TypedDict, total=False):
    """Information about the instances to which the volume is attached."""

    IoPerformance: Optional[String]
    InstanceId: Optional[String]


VolumeStatusAttachmentStatusList = List[VolumeStatusAttachmentStatus]


class VolumeStatusDetails(TypedDict, total=False):
    """Describes a volume status."""

    Name: Optional[VolumeStatusName]
    Status: Optional[String]


VolumeStatusDetailsList = List[VolumeStatusDetails]


class VolumeStatusInfo(TypedDict, total=False):
    """Describes the status of a volume."""

    Details: Optional[VolumeStatusDetailsList]
    Status: Optional[VolumeStatusInfoStatus]


class VolumeStatusEvent(TypedDict, total=False):
    """Describes a volume status event."""

    Description: Optional[String]
    EventId: Optional[String]
    EventType: Optional[String]
    NotAfter: Optional[MillisecondDateTime]
    NotBefore: Optional[MillisecondDateTime]
    InstanceId: Optional[String]


VolumeStatusEventsList = List[VolumeStatusEvent]


class VolumeStatusAction(TypedDict, total=False):
    """Describes a volume status operation code."""

    Code: Optional[String]
    Description: Optional[String]
    EventId: Optional[String]
    EventType: Optional[String]


VolumeStatusActionsList = List[VolumeStatusAction]


class VolumeStatusItem(TypedDict, total=False):
    """Describes the volume status."""

    Actions: Optional[VolumeStatusActionsList]
    AvailabilityZone: Optional[String]
    OutpostArn: Optional[String]
    Events: Optional[VolumeStatusEventsList]
    VolumeId: Optional[String]
    VolumeStatus: Optional[VolumeStatusInfo]
    AttachmentStatuses: Optional[VolumeStatusAttachmentStatusList]


VolumeStatusList = List[VolumeStatusItem]


class DescribeVolumeStatusResult(TypedDict, total=False):
    NextToken: Optional[String]
    VolumeStatuses: Optional[VolumeStatusList]


class DescribeVolumesModificationsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VolumeIds: Optional[VolumeIdStringList]
    Filters: Optional[FilterList]
    NextToken: Optional[String]
    MaxResults: Optional[Integer]


class VolumeModification(TypedDict, total=False):
    """Describes the modification status of an EBS volume.

    If the volume has never been modified, some element values will be null.
    """

    VolumeId: Optional[String]
    ModificationState: Optional[VolumeModificationState]
    StatusMessage: Optional[String]
    TargetSize: Optional[Integer]
    TargetIops: Optional[Integer]
    TargetVolumeType: Optional[VolumeType]
    TargetThroughput: Optional[Integer]
    TargetMultiAttachEnabled: Optional[Boolean]
    OriginalSize: Optional[Integer]
    OriginalIops: Optional[Integer]
    OriginalVolumeType: Optional[VolumeType]
    OriginalThroughput: Optional[Integer]
    OriginalMultiAttachEnabled: Optional[Boolean]
    Progress: Optional[Long]
    StartTime: Optional[DateTime]
    EndTime: Optional[DateTime]


VolumeModificationList = List[VolumeModification]


class DescribeVolumesModificationsResult(TypedDict, total=False):
    VolumesModifications: Optional[VolumeModificationList]
    NextToken: Optional[String]


class DescribeVolumesRequest(ServiceRequest):
    Filters: Optional[FilterList]
    VolumeIds: Optional[VolumeIdStringList]
    DryRun: Optional[Boolean]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class VolumeAttachment(TypedDict, total=False):
    """Describes volume attachment details."""

    AttachTime: Optional[DateTime]
    Device: Optional[String]
    InstanceId: Optional[String]
    State: Optional[VolumeAttachmentState]
    VolumeId: Optional[String]
    DeleteOnTermination: Optional[Boolean]


VolumeAttachmentList = List[VolumeAttachment]


class Volume(TypedDict, total=False):
    """Describes a volume."""

    Attachments: Optional[VolumeAttachmentList]
    AvailabilityZone: Optional[String]
    CreateTime: Optional[DateTime]
    Encrypted: Optional[Boolean]
    KmsKeyId: Optional[String]
    OutpostArn: Optional[String]
    Size: Optional[Integer]
    SnapshotId: Optional[String]
    State: Optional[VolumeState]
    VolumeId: Optional[String]
    Iops: Optional[Integer]
    Tags: Optional[TagList]
    VolumeType: Optional[VolumeType]
    FastRestored: Optional[Boolean]
    MultiAttachEnabled: Optional[Boolean]
    Throughput: Optional[Integer]


VolumeList = List[Volume]


class DescribeVolumesResult(TypedDict, total=False):
    Volumes: Optional[VolumeList]
    NextToken: Optional[String]


class DescribeVpcAttributeRequest(ServiceRequest):
    Attribute: VpcAttributeName
    VpcId: VpcId
    DryRun: Optional[Boolean]


class DescribeVpcAttributeResult(TypedDict, total=False):
    VpcId: Optional[String]
    EnableDnsHostnames: Optional[AttributeBooleanValue]
    EnableDnsSupport: Optional[AttributeBooleanValue]


VpcClassicLinkIdList = List[VpcId]


class DescribeVpcClassicLinkDnsSupportRequest(ServiceRequest):
    MaxResults: Optional[DescribeVpcClassicLinkDnsSupportMaxResults]
    NextToken: Optional[DescribeVpcClassicLinkDnsSupportNextToken]
    VpcIds: Optional[VpcClassicLinkIdList]


class DescribeVpcClassicLinkDnsSupportResult(TypedDict, total=False):
    NextToken: Optional[DescribeVpcClassicLinkDnsSupportNextToken]
    Vpcs: Optional[ClassicLinkDnsSupportList]


class DescribeVpcClassicLinkRequest(ServiceRequest):
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    VpcIds: Optional[VpcClassicLinkIdList]


class VpcClassicLink(TypedDict, total=False):
    """Describes whether a VPC is enabled for ClassicLink."""

    ClassicLinkEnabled: Optional[Boolean]
    Tags: Optional[TagList]
    VpcId: Optional[String]


VpcClassicLinkList = List[VpcClassicLink]


class DescribeVpcClassicLinkResult(TypedDict, total=False):
    Vpcs: Optional[VpcClassicLinkList]


class DescribeVpcEndpointConnectionNotificationsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ConnectionNotificationId: Optional[ConnectionNotificationId]
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class DescribeVpcEndpointConnectionNotificationsResult(TypedDict, total=False):
    ConnectionNotificationSet: Optional[ConnectionNotificationSet]
    NextToken: Optional[String]


class DescribeVpcEndpointConnectionsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class VpcEndpointConnection(TypedDict, total=False):
    """Describes a VPC endpoint connection to a service."""

    ServiceId: Optional[String]
    VpcEndpointId: Optional[String]
    VpcEndpointOwner: Optional[String]
    VpcEndpointState: Optional[State]
    CreationTimestamp: Optional[MillisecondDateTime]
    DnsEntries: Optional[DnsEntrySet]
    NetworkLoadBalancerArns: Optional[ValueStringList]
    GatewayLoadBalancerArns: Optional[ValueStringList]


VpcEndpointConnectionSet = List[VpcEndpointConnection]


class DescribeVpcEndpointConnectionsResult(TypedDict, total=False):
    VpcEndpointConnections: Optional[VpcEndpointConnectionSet]
    NextToken: Optional[String]


class DescribeVpcEndpointServiceConfigurationsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceIds: Optional[VpcEndpointServiceIdList]
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


ServiceConfigurationSet = List[ServiceConfiguration]


class DescribeVpcEndpointServiceConfigurationsResult(TypedDict, total=False):
    ServiceConfigurations: Optional[ServiceConfigurationSet]
    NextToken: Optional[String]


class DescribeVpcEndpointServicePermissionsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceId: VpcEndpointServiceId
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class DescribeVpcEndpointServicePermissionsResult(TypedDict, total=False):
    AllowedPrincipals: Optional[AllowedPrincipalSet]
    NextToken: Optional[String]


class DescribeVpcEndpointServicesRequest(ServiceRequest):
    """Contains the parameters for DescribeVpcEndpointServices."""

    DryRun: Optional[Boolean]
    ServiceNames: Optional[ValueStringList]
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class PrivateDnsDetails(TypedDict, total=False):
    """Information about the Private DNS name for interface endpoints."""

    PrivateDnsName: Optional[String]


PrivateDnsDetailsSet = List[PrivateDnsDetails]


class ServiceDetail(TypedDict, total=False):
    """Describes a VPC endpoint service."""

    ServiceName: Optional[String]
    ServiceId: Optional[String]
    ServiceType: Optional[ServiceTypeDetailSet]
    AvailabilityZones: Optional[ValueStringList]
    Owner: Optional[String]
    BaseEndpointDnsNames: Optional[ValueStringList]
    PrivateDnsName: Optional[String]
    PrivateDnsNames: Optional[PrivateDnsDetailsSet]
    VpcEndpointPolicySupported: Optional[Boolean]
    AcceptanceRequired: Optional[Boolean]
    ManagesVpcEndpoints: Optional[Boolean]
    PayerResponsibility: Optional[PayerResponsibility]
    Tags: Optional[TagList]
    PrivateDnsNameVerificationState: Optional[DnsNameState]


ServiceDetailSet = List[ServiceDetail]


class DescribeVpcEndpointServicesResult(TypedDict, total=False):
    """Contains the output of DescribeVpcEndpointServices."""

    ServiceNames: Optional[ValueStringList]
    ServiceDetails: Optional[ServiceDetailSet]
    NextToken: Optional[String]


class DescribeVpcEndpointsRequest(ServiceRequest):
    """Contains the parameters for DescribeVpcEndpoints."""

    DryRun: Optional[Boolean]
    VpcEndpointIds: Optional[VpcEndpointIdList]
    Filters: Optional[FilterList]
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


VpcEndpointSet = List[VpcEndpoint]


class DescribeVpcEndpointsResult(TypedDict, total=False):
    """Contains the output of DescribeVpcEndpoints."""

    VpcEndpoints: Optional[VpcEndpointSet]
    NextToken: Optional[String]


VpcPeeringConnectionIdList = List[VpcPeeringConnectionId]


class DescribeVpcPeeringConnectionsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    DryRun: Optional[Boolean]
    VpcPeeringConnectionIds: Optional[VpcPeeringConnectionIdList]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeVpcPeeringConnectionsMaxResults]


VpcPeeringConnectionList = List[VpcPeeringConnection]


class DescribeVpcPeeringConnectionsResult(TypedDict, total=False):
    VpcPeeringConnections: Optional[VpcPeeringConnectionList]
    NextToken: Optional[String]


VpcIdStringList = List[VpcId]


class DescribeVpcsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    VpcIds: Optional[VpcIdStringList]
    DryRun: Optional[Boolean]
    NextToken: Optional[String]
    MaxResults: Optional[DescribeVpcsMaxResults]


VpcList = List[Vpc]


class DescribeVpcsResult(TypedDict, total=False):
    Vpcs: Optional[VpcList]
    NextToken: Optional[String]


VpnConnectionIdStringList = List[VpnConnectionId]


class DescribeVpnConnectionsRequest(ServiceRequest):
    """Contains the parameters for DescribeVpnConnections."""

    Filters: Optional[FilterList]
    VpnConnectionIds: Optional[VpnConnectionIdStringList]
    DryRun: Optional[Boolean]


VpnConnectionList = List[VpnConnection]


class DescribeVpnConnectionsResult(TypedDict, total=False):
    """Contains the output of DescribeVpnConnections."""

    VpnConnections: Optional[VpnConnectionList]


VpnGatewayIdStringList = List[VpnGatewayId]


class DescribeVpnGatewaysRequest(ServiceRequest):
    """Contains the parameters for DescribeVpnGateways."""

    Filters: Optional[FilterList]
    VpnGatewayIds: Optional[VpnGatewayIdStringList]
    DryRun: Optional[Boolean]


VpnGatewayList = List[VpnGateway]


class DescribeVpnGatewaysResult(TypedDict, total=False):
    """Contains the output of DescribeVpnGateways."""

    VpnGateways: Optional[VpnGatewayList]


class DetachClassicLinkVpcRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceId: InstanceId
    VpcId: VpcId


class DetachClassicLinkVpcResult(TypedDict, total=False):
    Return: Optional[Boolean]


class DetachInternetGatewayRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InternetGatewayId: InternetGatewayId
    VpcId: VpcId


class DetachNetworkInterfaceRequest(ServiceRequest):
    """Contains the parameters for DetachNetworkInterface."""

    AttachmentId: NetworkInterfaceAttachmentId
    DryRun: Optional[Boolean]
    Force: Optional[Boolean]


class DetachVolumeRequest(ServiceRequest):
    Device: Optional[String]
    Force: Optional[Boolean]
    InstanceId: Optional[InstanceId]
    VolumeId: VolumeId
    DryRun: Optional[Boolean]


class DetachVpnGatewayRequest(ServiceRequest):
    """Contains the parameters for DetachVpnGateway."""

    VpcId: VpcId
    VpnGatewayId: VpnGatewayId
    DryRun: Optional[Boolean]


class DisableEbsEncryptionByDefaultRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class DisableEbsEncryptionByDefaultResult(TypedDict, total=False):
    EbsEncryptionByDefault: Optional[Boolean]


class DisableFastLaunchRequest(ServiceRequest):
    ImageId: ImageId
    Force: Optional[Boolean]
    DryRun: Optional[Boolean]


class DisableFastLaunchResult(TypedDict, total=False):
    ImageId: Optional[ImageId]
    ResourceType: Optional[FastLaunchResourceType]
    SnapshotConfiguration: Optional[FastLaunchSnapshotConfigurationResponse]
    LaunchTemplate: Optional[FastLaunchLaunchTemplateSpecificationResponse]
    MaxParallelLaunches: Optional[Integer]
    OwnerId: Optional[String]
    State: Optional[FastLaunchStateCode]
    StateTransitionReason: Optional[String]
    StateTransitionTime: Optional[MillisecondDateTime]


class DisableFastSnapshotRestoreStateError(TypedDict, total=False):
    """Describes an error that occurred when disabling fast snapshot restores."""

    Code: Optional[String]
    Message: Optional[String]


class DisableFastSnapshotRestoreStateErrorItem(TypedDict, total=False):
    """Contains information about an error that occurred when disabling fast
    snapshot restores.
    """

    AvailabilityZone: Optional[String]
    Error: Optional[DisableFastSnapshotRestoreStateError]


DisableFastSnapshotRestoreStateErrorSet = List[DisableFastSnapshotRestoreStateErrorItem]


class DisableFastSnapshotRestoreErrorItem(TypedDict, total=False):
    """Contains information about the errors that occurred when disabling fast
    snapshot restores.
    """

    SnapshotId: Optional[String]
    FastSnapshotRestoreStateErrors: Optional[DisableFastSnapshotRestoreStateErrorSet]


DisableFastSnapshotRestoreErrorSet = List[DisableFastSnapshotRestoreErrorItem]


class DisableFastSnapshotRestoreSuccessItem(TypedDict, total=False):
    """Describes fast snapshot restores that were successfully disabled."""

    SnapshotId: Optional[String]
    AvailabilityZone: Optional[String]
    State: Optional[FastSnapshotRestoreStateCode]
    StateTransitionReason: Optional[String]
    OwnerId: Optional[String]
    OwnerAlias: Optional[String]
    EnablingTime: Optional[MillisecondDateTime]
    OptimizingTime: Optional[MillisecondDateTime]
    EnabledTime: Optional[MillisecondDateTime]
    DisablingTime: Optional[MillisecondDateTime]
    DisabledTime: Optional[MillisecondDateTime]


DisableFastSnapshotRestoreSuccessSet = List[DisableFastSnapshotRestoreSuccessItem]


class DisableFastSnapshotRestoresRequest(ServiceRequest):
    AvailabilityZones: AvailabilityZoneStringList
    SourceSnapshotIds: SnapshotIdStringList
    DryRun: Optional[Boolean]


class DisableFastSnapshotRestoresResult(TypedDict, total=False):
    Successful: Optional[DisableFastSnapshotRestoreSuccessSet]
    Unsuccessful: Optional[DisableFastSnapshotRestoreErrorSet]


class DisableImageDeprecationRequest(ServiceRequest):
    ImageId: ImageId
    DryRun: Optional[Boolean]


class DisableImageDeprecationResult(TypedDict, total=False):
    Return: Optional[Boolean]


class DisableIpamOrganizationAdminAccountRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    DelegatedAdminAccountId: String


class DisableIpamOrganizationAdminAccountResult(TypedDict, total=False):
    Success: Optional[Boolean]


class DisableSerialConsoleAccessRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class DisableSerialConsoleAccessResult(TypedDict, total=False):
    SerialConsoleAccessEnabled: Optional[Boolean]


class DisableTransitGatewayRouteTablePropagationRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class TransitGatewayPropagation(TypedDict, total=False):
    """Describes route propagation."""

    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    ResourceId: Optional[String]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]
    TransitGatewayRouteTableId: Optional[String]
    State: Optional[TransitGatewayPropagationState]


class DisableTransitGatewayRouteTablePropagationResult(TypedDict, total=False):
    Propagation: Optional[TransitGatewayPropagation]


class DisableVgwRoutePropagationRequest(ServiceRequest):
    """Contains the parameters for DisableVgwRoutePropagation."""

    GatewayId: VpnGatewayId
    RouteTableId: RouteTableId
    DryRun: Optional[Boolean]


class DisableVpcClassicLinkDnsSupportRequest(ServiceRequest):
    VpcId: Optional[VpcId]


class DisableVpcClassicLinkDnsSupportResult(TypedDict, total=False):
    Return: Optional[Boolean]


class DisableVpcClassicLinkRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VpcId: VpcId


class DisableVpcClassicLinkResult(TypedDict, total=False):
    Return: Optional[Boolean]


class DisassociateAddressRequest(ServiceRequest):
    AssociationId: Optional[ElasticIpAssociationId]
    PublicIp: Optional[String]
    DryRun: Optional[Boolean]


class DisassociateClientVpnTargetNetworkRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    AssociationId: ClientVpnAssociationId
    DryRun: Optional[Boolean]


class DisassociateClientVpnTargetNetworkResult(TypedDict, total=False):
    AssociationId: Optional[String]
    Status: Optional[AssociationStatus]


class DisassociateEnclaveCertificateIamRoleRequest(ServiceRequest):
    CertificateArn: Optional[ResourceArn]
    RoleArn: Optional[ResourceArn]
    DryRun: Optional[Boolean]


class DisassociateEnclaveCertificateIamRoleResult(TypedDict, total=False):
    Return: Optional[Boolean]


class DisassociateIamInstanceProfileRequest(ServiceRequest):
    AssociationId: IamInstanceProfileAssociationId


class DisassociateIamInstanceProfileResult(TypedDict, total=False):
    IamInstanceProfileAssociation: Optional[IamInstanceProfileAssociation]


class InstanceEventWindowDisassociationRequest(TypedDict, total=False):
    """The targets to disassociate from the specified event window."""

    InstanceIds: Optional[InstanceIdList]
    InstanceTags: Optional[TagList]
    DedicatedHostIds: Optional[DedicatedHostIdList]


class DisassociateInstanceEventWindowRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceEventWindowId: InstanceEventWindowId
    AssociationTarget: InstanceEventWindowDisassociationRequest


class DisassociateInstanceEventWindowResult(TypedDict, total=False):
    InstanceEventWindow: Optional[InstanceEventWindow]


class DisassociateRouteTableRequest(ServiceRequest):
    AssociationId: RouteTableAssociationId
    DryRun: Optional[Boolean]


class DisassociateSubnetCidrBlockRequest(ServiceRequest):
    AssociationId: SubnetCidrAssociationId


class DisassociateSubnetCidrBlockResult(TypedDict, total=False):
    Ipv6CidrBlockAssociation: Optional[SubnetIpv6CidrBlockAssociation]
    SubnetId: Optional[String]


class DisassociateTransitGatewayMulticastDomainRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    SubnetIds: Optional[TransitGatewaySubnetIdList]
    DryRun: Optional[Boolean]


class DisassociateTransitGatewayMulticastDomainResult(TypedDict, total=False):
    Associations: Optional[TransitGatewayMulticastDomainAssociations]


class DisassociateTransitGatewayRouteTableRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class DisassociateTransitGatewayRouteTableResult(TypedDict, total=False):
    Association: Optional[TransitGatewayAssociation]


class DisassociateTrunkInterfaceRequest(ServiceRequest):
    AssociationId: TrunkInterfaceAssociationId
    ClientToken: Optional[String]
    DryRun: Optional[Boolean]


class DisassociateTrunkInterfaceResult(TypedDict, total=False):
    Return: Optional[Boolean]
    ClientToken: Optional[String]


class DisassociateVpcCidrBlockRequest(ServiceRequest):
    AssociationId: VpcCidrAssociationId


class DisassociateVpcCidrBlockResult(TypedDict, total=False):
    Ipv6CidrBlockAssociation: Optional[VpcIpv6CidrBlockAssociation]
    CidrBlockAssociation: Optional[VpcCidrBlockAssociation]
    VpcId: Optional[String]


class VolumeDetail(TypedDict, total=False):
    """Describes an EBS volume."""

    Size: Long


class DiskImageDetail(TypedDict, total=False):
    """Describes a disk image."""

    Bytes: Long
    Format: DiskImageFormat
    ImportManifestUrl: String


class DiskImage(TypedDict, total=False):
    """Describes a disk image."""

    Description: Optional[String]
    Image: Optional[DiskImageDetail]
    Volume: Optional[VolumeDetail]


DiskImageList = List[DiskImage]


class DnsServersOptionsModifyStructure(TypedDict, total=False):
    """Information about the DNS server to be used."""

    CustomDnsServers: Optional[ValueStringList]
    Enabled: Optional[Boolean]


class EbsInstanceBlockDeviceSpecification(TypedDict, total=False):
    """Describes information used to set up an EBS volume specified in a block
    device mapping.
    """

    DeleteOnTermination: Optional[Boolean]
    VolumeId: Optional[VolumeId]


ElasticGpuSpecifications = List[ElasticGpuSpecification]


class ElasticInferenceAccelerator(TypedDict, total=False):
    """Describes an elastic inference accelerator."""

    Type: String
    Count: Optional[ElasticInferenceAcceleratorCount]


ElasticInferenceAccelerators = List[ElasticInferenceAccelerator]


class EnableEbsEncryptionByDefaultRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class EnableEbsEncryptionByDefaultResult(TypedDict, total=False):
    EbsEncryptionByDefault: Optional[Boolean]


class FastLaunchLaunchTemplateSpecificationRequest(TypedDict, total=False):
    """Request to create a launch template for a fast-launch enabled Windows
    AMI.

    Note - You can specify either the ``LaunchTemplateName`` or the
    ``LaunchTemplateId``, but not both.
    """

    LaunchTemplateId: Optional[LaunchTemplateId]
    LaunchTemplateName: Optional[String]
    Version: String


class FastLaunchSnapshotConfigurationRequest(TypedDict, total=False):
    """Configuration settings for creating and managing pre-provisioned
    snapshots for a fast-launch enabled Windows AMI.
    """

    TargetResourceCount: Optional[Integer]


class EnableFastLaunchRequest(ServiceRequest):
    ImageId: ImageId
    ResourceType: Optional[String]
    SnapshotConfiguration: Optional[FastLaunchSnapshotConfigurationRequest]
    LaunchTemplate: Optional[FastLaunchLaunchTemplateSpecificationRequest]
    MaxParallelLaunches: Optional[Integer]
    DryRun: Optional[Boolean]


class EnableFastLaunchResult(TypedDict, total=False):
    ImageId: Optional[ImageId]
    ResourceType: Optional[FastLaunchResourceType]
    SnapshotConfiguration: Optional[FastLaunchSnapshotConfigurationResponse]
    LaunchTemplate: Optional[FastLaunchLaunchTemplateSpecificationResponse]
    MaxParallelLaunches: Optional[Integer]
    OwnerId: Optional[String]
    State: Optional[FastLaunchStateCode]
    StateTransitionReason: Optional[String]
    StateTransitionTime: Optional[MillisecondDateTime]


class EnableFastSnapshotRestoreStateError(TypedDict, total=False):
    """Describes an error that occurred when enabling fast snapshot restores."""

    Code: Optional[String]
    Message: Optional[String]


class EnableFastSnapshotRestoreStateErrorItem(TypedDict, total=False):
    """Contains information about an error that occurred when enabling fast
    snapshot restores.
    """

    AvailabilityZone: Optional[String]
    Error: Optional[EnableFastSnapshotRestoreStateError]


EnableFastSnapshotRestoreStateErrorSet = List[EnableFastSnapshotRestoreStateErrorItem]


class EnableFastSnapshotRestoreErrorItem(TypedDict, total=False):
    """Contains information about the errors that occurred when enabling fast
    snapshot restores.
    """

    SnapshotId: Optional[String]
    FastSnapshotRestoreStateErrors: Optional[EnableFastSnapshotRestoreStateErrorSet]


EnableFastSnapshotRestoreErrorSet = List[EnableFastSnapshotRestoreErrorItem]


class EnableFastSnapshotRestoreSuccessItem(TypedDict, total=False):
    """Describes fast snapshot restores that were successfully enabled."""

    SnapshotId: Optional[String]
    AvailabilityZone: Optional[String]
    State: Optional[FastSnapshotRestoreStateCode]
    StateTransitionReason: Optional[String]
    OwnerId: Optional[String]
    OwnerAlias: Optional[String]
    EnablingTime: Optional[MillisecondDateTime]
    OptimizingTime: Optional[MillisecondDateTime]
    EnabledTime: Optional[MillisecondDateTime]
    DisablingTime: Optional[MillisecondDateTime]
    DisabledTime: Optional[MillisecondDateTime]


EnableFastSnapshotRestoreSuccessSet = List[EnableFastSnapshotRestoreSuccessItem]


class EnableFastSnapshotRestoresRequest(ServiceRequest):
    AvailabilityZones: AvailabilityZoneStringList
    SourceSnapshotIds: SnapshotIdStringList
    DryRun: Optional[Boolean]


class EnableFastSnapshotRestoresResult(TypedDict, total=False):
    Successful: Optional[EnableFastSnapshotRestoreSuccessSet]
    Unsuccessful: Optional[EnableFastSnapshotRestoreErrorSet]


class EnableImageDeprecationRequest(ServiceRequest):
    ImageId: ImageId
    DeprecateAt: MillisecondDateTime
    DryRun: Optional[Boolean]


class EnableImageDeprecationResult(TypedDict, total=False):
    Return: Optional[Boolean]


class EnableIpamOrganizationAdminAccountRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    DelegatedAdminAccountId: String


class EnableIpamOrganizationAdminAccountResult(TypedDict, total=False):
    Success: Optional[Boolean]


class EnableSerialConsoleAccessRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class EnableSerialConsoleAccessResult(TypedDict, total=False):
    SerialConsoleAccessEnabled: Optional[Boolean]


class EnableTransitGatewayRouteTablePropagationRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class EnableTransitGatewayRouteTablePropagationResult(TypedDict, total=False):
    Propagation: Optional[TransitGatewayPropagation]


class EnableVgwRoutePropagationRequest(ServiceRequest):
    """Contains the parameters for EnableVgwRoutePropagation."""

    GatewayId: VpnGatewayId
    RouteTableId: RouteTableId
    DryRun: Optional[Boolean]


class EnableVolumeIORequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VolumeId: VolumeId


class EnableVpcClassicLinkDnsSupportRequest(ServiceRequest):
    VpcId: Optional[VpcId]


class EnableVpcClassicLinkDnsSupportResult(TypedDict, total=False):
    Return: Optional[Boolean]


class EnableVpcClassicLinkRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VpcId: VpcId


class EnableVpcClassicLinkResult(TypedDict, total=False):
    Return: Optional[Boolean]


class EnclaveOptionsRequest(TypedDict, total=False):
    """Indicates whether the instance is enabled for Amazon Web Services Nitro
    Enclaves. For more information, see `What is Amazon Web Services Nitro
    Enclaves? <https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html>`__
    in the *Amazon Web Services Nitro Enclaves User Guide*.
    """

    Enabled: Optional[Boolean]


class ExportClientVpnClientCertificateRevocationListRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    DryRun: Optional[Boolean]


class ExportClientVpnClientCertificateRevocationListResult(TypedDict, total=False):
    CertificateRevocationList: Optional[String]
    Status: Optional[ClientCertificateRevocationListStatus]


class ExportClientVpnClientConfigurationRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    DryRun: Optional[Boolean]


class ExportClientVpnClientConfigurationResult(TypedDict, total=False):
    ClientConfiguration: Optional[String]


class ExportTaskS3LocationRequest(TypedDict, total=False):
    """Describes the destination for an export image task."""

    S3Bucket: String
    S3Prefix: Optional[String]


class ExportImageRequest(ServiceRequest):
    ClientToken: Optional[String]
    Description: Optional[String]
    DiskImageFormat: DiskImageFormat
    DryRun: Optional[Boolean]
    ImageId: ImageId
    S3ExportLocation: ExportTaskS3LocationRequest
    RoleName: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]


class ExportImageResult(TypedDict, total=False):
    Description: Optional[String]
    DiskImageFormat: Optional[DiskImageFormat]
    ExportImageTaskId: Optional[String]
    ImageId: Optional[String]
    RoleName: Optional[String]
    Progress: Optional[String]
    S3ExportLocation: Optional[ExportTaskS3Location]
    Status: Optional[String]
    StatusMessage: Optional[String]
    Tags: Optional[TagList]


class ExportTransitGatewayRoutesRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    Filters: Optional[FilterList]
    S3Bucket: String
    DryRun: Optional[Boolean]


class ExportTransitGatewayRoutesResult(TypedDict, total=False):
    S3Location: Optional[String]


class GetAssociatedEnclaveCertificateIamRolesRequest(ServiceRequest):
    CertificateArn: Optional[ResourceArn]
    DryRun: Optional[Boolean]


class GetAssociatedEnclaveCertificateIamRolesResult(TypedDict, total=False):
    AssociatedRoles: Optional[AssociatedRolesList]


class GetAssociatedIpv6PoolCidrsRequest(ServiceRequest):
    PoolId: Ipv6PoolEc2Id
    NextToken: Optional[NextToken]
    MaxResults: Optional[Ipv6PoolMaxResults]
    DryRun: Optional[Boolean]


class Ipv6CidrAssociation(TypedDict, total=False):
    """Describes an IPv6 CIDR block association."""

    Ipv6Cidr: Optional[String]
    AssociatedResource: Optional[String]


Ipv6CidrAssociationSet = List[Ipv6CidrAssociation]


class GetAssociatedIpv6PoolCidrsResult(TypedDict, total=False):
    Ipv6CidrAssociations: Optional[Ipv6CidrAssociationSet]
    NextToken: Optional[String]


class GetCapacityReservationUsageRequest(ServiceRequest):
    CapacityReservationId: CapacityReservationId
    NextToken: Optional[String]
    MaxResults: Optional[GetCapacityReservationUsageRequestMaxResults]
    DryRun: Optional[Boolean]


class InstanceUsage(TypedDict, total=False):
    """Information about the Capacity Reservation usage."""

    AccountId: Optional[String]
    UsedInstanceCount: Optional[Integer]


InstanceUsageSet = List[InstanceUsage]


class GetCapacityReservationUsageResult(TypedDict, total=False):
    NextToken: Optional[String]
    CapacityReservationId: Optional[String]
    InstanceType: Optional[String]
    TotalInstanceCount: Optional[Integer]
    AvailableInstanceCount: Optional[Integer]
    State: Optional[CapacityReservationState]
    InstanceUsages: Optional[InstanceUsageSet]


class GetCoipPoolUsageRequest(ServiceRequest):
    PoolId: CoipPoolId
    Filters: Optional[FilterList]
    MaxResults: Optional[CoipPoolMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class GetCoipPoolUsageResult(TypedDict, total=False):
    CoipPoolId: Optional[String]
    CoipAddressUsages: Optional[CoipAddressUsageSet]
    LocalGatewayRouteTableId: Optional[String]


class GetConsoleOutputRequest(ServiceRequest):
    InstanceId: InstanceId
    DryRun: Optional[Boolean]
    Latest: Optional[Boolean]


class GetConsoleOutputResult(TypedDict, total=False):
    InstanceId: Optional[String]
    Output: Optional[String]
    Timestamp: Optional[DateTime]


class GetConsoleScreenshotRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceId: InstanceId
    WakeUp: Optional[Boolean]


class GetConsoleScreenshotResult(TypedDict, total=False):
    ImageData: Optional[String]
    InstanceId: Optional[String]


class GetDefaultCreditSpecificationRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceFamily: UnlimitedSupportedInstanceFamily


class InstanceFamilyCreditSpecification(TypedDict, total=False):
    """Describes the default credit option for CPU usage of a burstable
    performance instance family.
    """

    InstanceFamily: Optional[UnlimitedSupportedInstanceFamily]
    CpuCredits: Optional[String]


class GetDefaultCreditSpecificationResult(TypedDict, total=False):
    InstanceFamilyCreditSpecification: Optional[InstanceFamilyCreditSpecification]


class GetEbsDefaultKmsKeyIdRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class GetEbsDefaultKmsKeyIdResult(TypedDict, total=False):
    KmsKeyId: Optional[String]


class GetEbsEncryptionByDefaultRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class GetEbsEncryptionByDefaultResult(TypedDict, total=False):
    EbsEncryptionByDefault: Optional[Boolean]


class IntegrateServices(TypedDict, total=False):
    """Describes service integrations with VPC Flow logs."""

    AthenaIntegrations: Optional[AthenaIntegrationsSet]


class GetFlowLogsIntegrationTemplateRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    FlowLogId: VpcFlowLogId
    ConfigDeliveryS3DestinationArn: String
    IntegrateServices: IntegrateServices


class GetFlowLogsIntegrationTemplateResult(TypedDict, total=False):
    Result: Optional[String]


class GetGroupsForCapacityReservationRequest(ServiceRequest):
    CapacityReservationId: CapacityReservationId
    NextToken: Optional[String]
    MaxResults: Optional[GetGroupsForCapacityReservationRequestMaxResults]
    DryRun: Optional[Boolean]


class GetGroupsForCapacityReservationResult(TypedDict, total=False):
    NextToken: Optional[String]
    CapacityReservationGroups: Optional[CapacityReservationGroupSet]


RequestHostIdSet = List[DedicatedHostId]


class GetHostReservationPurchasePreviewRequest(ServiceRequest):
    HostIdSet: RequestHostIdSet
    OfferingId: OfferingId


class Purchase(TypedDict, total=False):
    """Describes the result of the purchase."""

    CurrencyCode: Optional[CurrencyCodeValues]
    Duration: Optional[Integer]
    HostIdSet: Optional[ResponseHostIdSet]
    HostReservationId: Optional[HostReservationId]
    HourlyPrice: Optional[String]
    InstanceFamily: Optional[String]
    PaymentOption: Optional[PaymentOption]
    UpfrontPrice: Optional[String]


PurchaseSet = List[Purchase]


class GetHostReservationPurchasePreviewResult(TypedDict, total=False):
    CurrencyCode: Optional[CurrencyCodeValues]
    Purchase: Optional[PurchaseSet]
    TotalHourlyPrice: Optional[String]
    TotalUpfrontPrice: Optional[String]


VirtualizationTypeSet = List[VirtualizationType]


class GetInstanceTypesFromInstanceRequirementsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ArchitectureTypes: ArchitectureTypeSet
    VirtualizationTypes: VirtualizationTypeSet
    InstanceRequirements: InstanceRequirementsRequest
    MaxResults: Optional[Integer]
    NextToken: Optional[String]


class InstanceTypeInfoFromInstanceRequirements(TypedDict, total=False):
    """The list of instance types with the specified instance attributes."""

    InstanceType: Optional[String]


InstanceTypeInfoFromInstanceRequirementsSet = List[InstanceTypeInfoFromInstanceRequirements]


class GetInstanceTypesFromInstanceRequirementsResult(TypedDict, total=False):
    InstanceTypes: Optional[InstanceTypeInfoFromInstanceRequirementsSet]
    NextToken: Optional[String]


class GetIpamAddressHistoryRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Cidr: String
    IpamScopeId: IpamScopeId
    VpcId: Optional[String]
    StartTime: Optional[MillisecondDateTime]
    EndTime: Optional[MillisecondDateTime]
    MaxResults: Optional[IpamAddressHistoryMaxResults]
    NextToken: Optional[NextToken]


class IpamAddressHistoryRecord(TypedDict, total=False):
    """The historical record of a CIDR within an IPAM scope. For more
    information, see `View the history of IP
    addresses </vpc/latest/ipam/view-history-cidr-ipam.html>`__ in the
    *Amazon VPC IPAM User Guide*.
    """

    ResourceOwnerId: Optional[String]
    ResourceRegion: Optional[String]
    ResourceType: Optional[IpamAddressHistoryResourceType]
    ResourceId: Optional[String]
    ResourceCidr: Optional[String]
    ResourceName: Optional[String]
    ResourceComplianceStatus: Optional[IpamComplianceStatus]
    ResourceOverlapStatus: Optional[IpamOverlapStatus]
    VpcId: Optional[String]
    SampledStartTime: Optional[MillisecondDateTime]
    SampledEndTime: Optional[MillisecondDateTime]


IpamAddressHistoryRecordSet = List[IpamAddressHistoryRecord]


class GetIpamAddressHistoryResult(TypedDict, total=False):
    HistoryRecords: Optional[IpamAddressHistoryRecordSet]
    NextToken: Optional[NextToken]


class GetIpamPoolAllocationsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamPoolId: IpamPoolId
    IpamPoolAllocationId: Optional[IpamPoolAllocationId]
    Filters: Optional[FilterList]
    MaxResults: Optional[GetIpamPoolAllocationsMaxResults]
    NextToken: Optional[NextToken]


IpamPoolAllocationSet = List[IpamPoolAllocation]


class GetIpamPoolAllocationsResult(TypedDict, total=False):
    IpamPoolAllocations: Optional[IpamPoolAllocationSet]
    NextToken: Optional[NextToken]


class GetIpamPoolCidrsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamPoolId: IpamPoolId
    Filters: Optional[FilterList]
    MaxResults: Optional[IpamMaxResults]
    NextToken: Optional[NextToken]


IpamPoolCidrSet = List[IpamPoolCidr]


class GetIpamPoolCidrsResult(TypedDict, total=False):
    IpamPoolCidrs: Optional[IpamPoolCidrSet]
    NextToken: Optional[NextToken]


class GetIpamResourceCidrsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Filters: Optional[FilterList]
    MaxResults: Optional[IpamMaxResults]
    NextToken: Optional[NextToken]
    IpamScopeId: IpamScopeId
    IpamPoolId: Optional[IpamPoolId]
    ResourceId: Optional[String]
    ResourceType: Optional[IpamResourceType]
    ResourceTag: Optional[RequestIpamResourceTag]
    ResourceOwner: Optional[String]


class IpamResourceCidr(TypedDict, total=False):
    """The CIDR for an IPAM resource."""

    IpamId: Optional[IpamId]
    IpamScopeId: Optional[IpamScopeId]
    IpamPoolId: Optional[IpamPoolId]
    ResourceRegion: Optional[String]
    ResourceOwnerId: Optional[String]
    ResourceId: Optional[String]
    ResourceName: Optional[String]
    ResourceCidr: Optional[String]
    ResourceType: Optional[IpamResourceType]
    ResourceTags: Optional[IpamResourceTagList]
    IpUsage: Optional[BoxedDouble]
    ComplianceStatus: Optional[IpamComplianceStatus]
    ManagementState: Optional[IpamManagementState]
    OverlapStatus: Optional[IpamOverlapStatus]
    VpcId: Optional[String]


IpamResourceCidrSet = List[IpamResourceCidr]


class GetIpamResourceCidrsResult(TypedDict, total=False):
    NextToken: Optional[NextToken]
    IpamResourceCidrs: Optional[IpamResourceCidrSet]


class GetLaunchTemplateDataRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceId: InstanceId


class GetLaunchTemplateDataResult(TypedDict, total=False):
    LaunchTemplateData: Optional[ResponseLaunchTemplateData]


class GetManagedPrefixListAssociationsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PrefixListId: PrefixListResourceId
    MaxResults: Optional[GetManagedPrefixListAssociationsMaxResults]
    NextToken: Optional[NextToken]


class PrefixListAssociation(TypedDict, total=False):
    """Describes the resource with which a prefix list is associated."""

    ResourceId: Optional[String]
    ResourceOwner: Optional[String]


PrefixListAssociationSet = List[PrefixListAssociation]


class GetManagedPrefixListAssociationsResult(TypedDict, total=False):
    PrefixListAssociations: Optional[PrefixListAssociationSet]
    NextToken: Optional[String]


class GetManagedPrefixListEntriesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PrefixListId: PrefixListResourceId
    TargetVersion: Optional[Long]
    MaxResults: Optional[PrefixListMaxResults]
    NextToken: Optional[NextToken]


class PrefixListEntry(TypedDict, total=False):
    """Describes a prefix list entry."""

    Cidr: Optional[String]
    Description: Optional[String]


PrefixListEntrySet = List[PrefixListEntry]


class GetManagedPrefixListEntriesResult(TypedDict, total=False):
    Entries: Optional[PrefixListEntrySet]
    NextToken: Optional[NextToken]


class GetNetworkInsightsAccessScopeAnalysisFindingsRequest(ServiceRequest):
    NetworkInsightsAccessScopeAnalysisId: NetworkInsightsAccessScopeAnalysisId
    MaxResults: Optional[NetworkInsightsMaxResults]
    NextToken: Optional[NextToken]
    DryRun: Optional[Boolean]


class GetNetworkInsightsAccessScopeAnalysisFindingsResult(TypedDict, total=False):
    NetworkInsightsAccessScopeAnalysisId: Optional[NetworkInsightsAccessScopeAnalysisId]
    AnalysisStatus: Optional[AnalysisStatus]
    AnalysisFindings: Optional[AccessScopeAnalysisFindingList]
    NextToken: Optional[String]


class GetNetworkInsightsAccessScopeContentRequest(ServiceRequest):
    NetworkInsightsAccessScopeId: NetworkInsightsAccessScopeId
    DryRun: Optional[Boolean]


class GetNetworkInsightsAccessScopeContentResult(TypedDict, total=False):
    NetworkInsightsAccessScopeContent: Optional[NetworkInsightsAccessScopeContent]


class GetPasswordDataRequest(ServiceRequest):
    InstanceId: InstanceId
    DryRun: Optional[Boolean]


class GetPasswordDataResult(TypedDict, total=False):
    InstanceId: Optional[String]
    PasswordData: Optional[String]
    Timestamp: Optional[DateTime]


class GetReservedInstancesExchangeQuoteRequest(ServiceRequest):
    """Contains the parameters for GetReservedInstanceExchangeQuote."""

    DryRun: Optional[Boolean]
    ReservedInstanceIds: ReservedInstanceIdSet
    TargetConfigurations: Optional[TargetConfigurationRequestSet]


class TargetConfiguration(TypedDict, total=False):
    """Information about the Convertible Reserved Instance offering."""

    InstanceCount: Optional[Integer]
    OfferingId: Optional[String]


class ReservationValue(TypedDict, total=False):
    """The cost associated with the Reserved Instance."""

    HourlyPrice: Optional[String]
    RemainingTotalValue: Optional[String]
    RemainingUpfrontValue: Optional[String]


class TargetReservationValue(TypedDict, total=False):
    """The total value of the new Convertible Reserved Instances."""

    ReservationValue: Optional[ReservationValue]
    TargetConfiguration: Optional[TargetConfiguration]


TargetReservationValueSet = List[TargetReservationValue]


class ReservedInstanceReservationValue(TypedDict, total=False):
    """The total value of the Convertible Reserved Instance."""

    ReservationValue: Optional[ReservationValue]
    ReservedInstanceId: Optional[String]


ReservedInstanceReservationValueSet = List[ReservedInstanceReservationValue]


class GetReservedInstancesExchangeQuoteResult(TypedDict, total=False):
    """Contains the output of GetReservedInstancesExchangeQuote."""

    CurrencyCode: Optional[String]
    IsValidExchange: Optional[Boolean]
    OutputReservedInstancesWillExpireAt: Optional[DateTime]
    PaymentDue: Optional[String]
    ReservedInstanceValueRollup: Optional[ReservationValue]
    ReservedInstanceValueSet: Optional[ReservedInstanceReservationValueSet]
    TargetConfigurationValueRollup: Optional[ReservationValue]
    TargetConfigurationValueSet: Optional[TargetReservationValueSet]
    ValidationFailureReason: Optional[String]


class GetSerialConsoleAccessStatusRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class GetSerialConsoleAccessStatusResult(TypedDict, total=False):
    SerialConsoleAccessEnabled: Optional[Boolean]


class InstanceRequirementsWithMetadataRequest(TypedDict, total=False):
    """The architecture type, virtualization type, and other attributes for the
    instance types. When you specify instance attributes, Amazon EC2 will
    identify instance types with those attributes.

    If you specify ``InstanceRequirementsWithMetadataRequest``, you can't
    specify ``InstanceTypes``.
    """

    ArchitectureTypes: Optional[ArchitectureTypeSet]
    VirtualizationTypes: Optional[VirtualizationTypeSet]
    InstanceRequirements: Optional[InstanceRequirementsRequest]


RegionNames = List[String]
InstanceTypes = List[String]


class GetSpotPlacementScoresRequest(ServiceRequest):
    InstanceTypes: Optional[InstanceTypes]
    TargetCapacity: SpotPlacementScoresTargetCapacity
    TargetCapacityUnitType: Optional[TargetCapacityUnitType]
    SingleAvailabilityZone: Optional[Boolean]
    RegionNames: Optional[RegionNames]
    InstanceRequirementsWithMetadata: Optional[InstanceRequirementsWithMetadataRequest]
    DryRun: Optional[Boolean]
    MaxResults: Optional[SpotPlacementScoresMaxResults]
    NextToken: Optional[String]


class SpotPlacementScore(TypedDict, total=False):
    """The Spot placement score for this Region or Availability Zone. The score
    is calculated based on the assumption that the ``capacity-optimized``
    allocation strategy is used and that all of the Availability Zones in
    the Region can be used.
    """

    Region: Optional[String]
    AvailabilityZoneId: Optional[String]
    Score: Optional[Integer]


SpotPlacementScores = List[SpotPlacementScore]


class GetSpotPlacementScoresResult(TypedDict, total=False):
    SpotPlacementScores: Optional[SpotPlacementScores]
    NextToken: Optional[String]


class GetSubnetCidrReservationsRequest(ServiceRequest):
    Filters: Optional[FilterList]
    SubnetId: SubnetId
    DryRun: Optional[Boolean]
    NextToken: Optional[String]
    MaxResults: Optional[GetSubnetCidrReservationsMaxResults]


SubnetCidrReservationList = List[SubnetCidrReservation]


class GetSubnetCidrReservationsResult(TypedDict, total=False):
    SubnetIpv4CidrReservations: Optional[SubnetCidrReservationList]
    SubnetIpv6CidrReservations: Optional[SubnetCidrReservationList]
    NextToken: Optional[String]


class GetTransitGatewayAttachmentPropagationsRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class TransitGatewayAttachmentPropagation(TypedDict, total=False):
    """Describes a propagation route table."""

    TransitGatewayRouteTableId: Optional[String]
    State: Optional[TransitGatewayPropagationState]


TransitGatewayAttachmentPropagationList = List[TransitGatewayAttachmentPropagation]


class GetTransitGatewayAttachmentPropagationsResult(TypedDict, total=False):
    TransitGatewayAttachmentPropagations: Optional[TransitGatewayAttachmentPropagationList]
    NextToken: Optional[String]


class GetTransitGatewayMulticastDomainAssociationsRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class TransitGatewayMulticastDomainAssociation(TypedDict, total=False):
    """Describes the resources associated with the transit gateway multicast
    domain.
    """

    TransitGatewayAttachmentId: Optional[String]
    ResourceId: Optional[String]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]
    ResourceOwnerId: Optional[String]
    Subnet: Optional[SubnetAssociation]


TransitGatewayMulticastDomainAssociationList = List[TransitGatewayMulticastDomainAssociation]


class GetTransitGatewayMulticastDomainAssociationsResult(TypedDict, total=False):
    MulticastDomainAssociations: Optional[TransitGatewayMulticastDomainAssociationList]
    NextToken: Optional[String]


class GetTransitGatewayPrefixListReferencesRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


TransitGatewayPrefixListReferenceSet = List[TransitGatewayPrefixListReference]


class GetTransitGatewayPrefixListReferencesResult(TypedDict, total=False):
    TransitGatewayPrefixListReferences: Optional[TransitGatewayPrefixListReferenceSet]
    NextToken: Optional[String]


class GetTransitGatewayRouteTableAssociationsRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class TransitGatewayRouteTableAssociation(TypedDict, total=False):
    """Describes an association between a route table and a resource
    attachment.
    """

    TransitGatewayAttachmentId: Optional[String]
    ResourceId: Optional[String]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]
    State: Optional[TransitGatewayAssociationState]


TransitGatewayRouteTableAssociationList = List[TransitGatewayRouteTableAssociation]


class GetTransitGatewayRouteTableAssociationsResult(TypedDict, total=False):
    Associations: Optional[TransitGatewayRouteTableAssociationList]
    NextToken: Optional[String]


class GetTransitGatewayRouteTablePropagationsRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class TransitGatewayRouteTablePropagation(TypedDict, total=False):
    """Describes a route table propagation."""

    TransitGatewayAttachmentId: Optional[String]
    ResourceId: Optional[String]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]
    State: Optional[TransitGatewayPropagationState]


TransitGatewayRouteTablePropagationList = List[TransitGatewayRouteTablePropagation]


class GetTransitGatewayRouteTablePropagationsResult(TypedDict, total=False):
    TransitGatewayRouteTablePropagations: Optional[TransitGatewayRouteTablePropagationList]
    NextToken: Optional[String]


class GetVpnConnectionDeviceSampleConfigurationRequest(ServiceRequest):
    VpnConnectionId: VpnConnectionId
    VpnConnectionDeviceTypeId: VpnConnectionDeviceTypeId
    InternetKeyExchangeVersion: Optional[String]
    DryRun: Optional[Boolean]


class GetVpnConnectionDeviceSampleConfigurationResult(TypedDict, total=False):
    VpnConnectionDeviceSampleConfiguration: Optional[VpnConnectionDeviceSampleConfiguration]


class GetVpnConnectionDeviceTypesRequest(ServiceRequest):
    MaxResults: Optional[GVCDMaxResults]
    NextToken: Optional[NextToken]
    DryRun: Optional[Boolean]


class VpnConnectionDeviceType(TypedDict, total=False):
    """List of customer gateway devices that have a sample configuration file
    available for use. You can also see the list of device types with sample
    configuration files available under `Your customer gateway
    device <https://docs.aws.amazon.com/vpn/latest/s2svpn/your-cgw.html>`__
    in the *Amazon Web Services Site-to-Site VPN User Guide*.
    """

    VpnConnectionDeviceTypeId: Optional[String]
    Vendor: Optional[String]
    Platform: Optional[String]
    Software: Optional[String]


VpnConnectionDeviceTypeList = List[VpnConnectionDeviceType]


class GetVpnConnectionDeviceTypesResult(TypedDict, total=False):
    VpnConnectionDeviceTypes: Optional[VpnConnectionDeviceTypeList]
    NextToken: Optional[NextToken]


class HibernationOptionsRequest(TypedDict, total=False):
    """Indicates whether your instance is configured for hibernation. This
    parameter is valid only if the instance meets the `hibernation
    prerequisites <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites>`__.
    For more information, see `Hibernate your
    instance <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html>`__
    in the *Amazon EC2 User Guide*.
    """

    Configured: Optional[Boolean]


class LaunchPermission(TypedDict, total=False):
    """Describes a launch permission."""

    Group: Optional[PermissionGroup]
    UserId: Optional[String]
    OrganizationArn: Optional[String]
    OrganizationalUnitArn: Optional[String]


LaunchPermissionList = List[LaunchPermission]


class ImageAttribute(TypedDict, total=False):
    """Describes an image attribute."""

    BlockDeviceMappings: Optional[BlockDeviceMappingList]
    ImageId: Optional[String]
    LaunchPermissions: Optional[LaunchPermissionList]
    ProductCodes: Optional[ProductCodeList]
    Description: Optional[AttributeValue]
    KernelId: Optional[AttributeValue]
    RamdiskId: Optional[AttributeValue]
    SriovNetSupport: Optional[AttributeValue]
    BootMode: Optional[AttributeValue]


class UserBucket(TypedDict, total=False):
    """Describes the Amazon S3 bucket for the disk image."""

    S3Bucket: Optional[String]
    S3Key: Optional[String]


class ImageDiskContainer(TypedDict, total=False):
    """Describes the disk container object for an import image task."""

    Description: Optional[String]
    DeviceName: Optional[String]
    Format: Optional[String]
    SnapshotId: Optional[SnapshotId]
    Url: Optional[String]
    UserBucket: Optional[UserBucket]


ImageDiskContainerList = List[ImageDiskContainer]


class ImportClientVpnClientCertificateRevocationListRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    CertificateRevocationList: String
    DryRun: Optional[Boolean]


class ImportClientVpnClientCertificateRevocationListResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ImportImageLicenseConfigurationRequest(TypedDict, total=False):
    """The request information of license configurations."""

    LicenseConfigurationArn: Optional[String]


ImportImageLicenseSpecificationListRequest = List[ImportImageLicenseConfigurationRequest]


class ImportImageRequest(ServiceRequest):
    Architecture: Optional[String]
    ClientData: Optional[ClientData]
    ClientToken: Optional[String]
    Description: Optional[String]
    DiskContainers: Optional[ImageDiskContainerList]
    DryRun: Optional[Boolean]
    Encrypted: Optional[Boolean]
    Hypervisor: Optional[String]
    KmsKeyId: Optional[KmsKeyId]
    LicenseType: Optional[String]
    Platform: Optional[String]
    RoleName: Optional[String]
    LicenseSpecifications: Optional[ImportImageLicenseSpecificationListRequest]
    TagSpecifications: Optional[TagSpecificationList]
    UsageOperation: Optional[String]
    BootMode: Optional[BootModeValues]


class ImportImageResult(TypedDict, total=False):
    Architecture: Optional[String]
    Description: Optional[String]
    Encrypted: Optional[Boolean]
    Hypervisor: Optional[String]
    ImageId: Optional[String]
    ImportTaskId: Optional[ImportImageTaskId]
    KmsKeyId: Optional[KmsKeyId]
    LicenseType: Optional[String]
    Platform: Optional[String]
    Progress: Optional[String]
    SnapshotDetails: Optional[SnapshotDetailList]
    Status: Optional[String]
    StatusMessage: Optional[String]
    LicenseSpecifications: Optional[ImportImageLicenseSpecificationListResponse]
    Tags: Optional[TagList]
    UsageOperation: Optional[String]


class UserData(TypedDict, total=False):
    """Describes the user data for an instance."""

    Data: Optional[String]


class ImportInstanceLaunchSpecification(TypedDict, total=False):
    """Describes the launch specification for VM import."""

    AdditionalInfo: Optional[String]
    Architecture: Optional[ArchitectureValues]
    GroupIds: Optional[SecurityGroupIdStringList]
    GroupNames: Optional[SecurityGroupStringList]
    InstanceInitiatedShutdownBehavior: Optional[ShutdownBehavior]
    InstanceType: Optional[InstanceType]
    Monitoring: Optional[Boolean]
    Placement: Optional[Placement]
    PrivateIpAddress: Optional[String]
    SubnetId: Optional[SubnetId]
    UserData: Optional[UserData]


class ImportInstanceRequest(ServiceRequest):
    Description: Optional[String]
    DiskImages: Optional[DiskImageList]
    DryRun: Optional[Boolean]
    LaunchSpecification: Optional[ImportInstanceLaunchSpecification]
    Platform: PlatformValues


class ImportInstanceResult(TypedDict, total=False):
    ConversionTask: Optional[ConversionTask]


class ImportKeyPairRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    KeyName: String
    PublicKeyMaterial: Blob
    TagSpecifications: Optional[TagSpecificationList]


class ImportKeyPairResult(TypedDict, total=False):
    KeyFingerprint: Optional[String]
    KeyName: Optional[String]
    KeyPairId: Optional[String]
    Tags: Optional[TagList]


class SnapshotDiskContainer(TypedDict, total=False):
    """The disk container object for the import snapshot request."""

    Description: Optional[String]
    Format: Optional[String]
    Url: Optional[String]
    UserBucket: Optional[UserBucket]


class ImportSnapshotRequest(ServiceRequest):
    ClientData: Optional[ClientData]
    ClientToken: Optional[String]
    Description: Optional[String]
    DiskContainer: Optional[SnapshotDiskContainer]
    DryRun: Optional[Boolean]
    Encrypted: Optional[Boolean]
    KmsKeyId: Optional[KmsKeyId]
    RoleName: Optional[String]
    TagSpecifications: Optional[TagSpecificationList]


class ImportSnapshotResult(TypedDict, total=False):
    Description: Optional[String]
    ImportTaskId: Optional[String]
    SnapshotTaskDetail: Optional[SnapshotTaskDetail]
    Tags: Optional[TagList]


class ImportVolumeRequest(ServiceRequest):
    AvailabilityZone: String
    Description: Optional[String]
    DryRun: Optional[Boolean]
    Image: DiskImageDetail
    Volume: VolumeDetail


class ImportVolumeResult(TypedDict, total=False):
    ConversionTask: Optional[ConversionTask]


class InstanceAttribute(TypedDict, total=False):
    """Describes an instance attribute."""

    Groups: Optional[GroupIdentifierList]
    BlockDeviceMappings: Optional[InstanceBlockDeviceMappingList]
    DisableApiTermination: Optional[AttributeBooleanValue]
    EnaSupport: Optional[AttributeBooleanValue]
    EnclaveOptions: Optional[EnclaveOptions]
    EbsOptimized: Optional[AttributeBooleanValue]
    InstanceId: Optional[String]
    InstanceInitiatedShutdownBehavior: Optional[AttributeValue]
    InstanceType: Optional[AttributeValue]
    KernelId: Optional[AttributeValue]
    ProductCodes: Optional[ProductCodeList]
    RamdiskId: Optional[AttributeValue]
    RootDeviceName: Optional[AttributeValue]
    SourceDestCheck: Optional[AttributeBooleanValue]
    SriovNetSupport: Optional[AttributeValue]
    UserData: Optional[AttributeValue]


class InstanceBlockDeviceMappingSpecification(TypedDict, total=False):
    """Describes a block device mapping entry."""

    DeviceName: Optional[String]
    Ebs: Optional[EbsInstanceBlockDeviceSpecification]
    NoDevice: Optional[String]
    VirtualName: Optional[String]


InstanceBlockDeviceMappingSpecificationList = List[InstanceBlockDeviceMappingSpecification]


class InstanceCreditSpecificationRequest(TypedDict, total=False):
    """Describes the credit option for CPU usage of a burstable performance
    instance.
    """

    InstanceId: Optional[InstanceId]
    CpuCredits: Optional[String]


InstanceCreditSpecificationListRequest = List[InstanceCreditSpecificationRequest]
InstanceIdSet = List[InstanceId]


class SpotMarketOptions(TypedDict, total=False):
    """The options for Spot Instances."""

    MaxPrice: Optional[String]
    SpotInstanceType: Optional[SpotInstanceType]
    BlockDurationMinutes: Optional[Integer]
    ValidUntil: Optional[DateTime]
    InstanceInterruptionBehavior: Optional[InstanceInterruptionBehavior]


class InstanceMarketOptionsRequest(TypedDict, total=False):
    """Describes the market (purchasing) option for the instances."""

    MarketType: Optional[MarketType]
    SpotOptions: Optional[SpotMarketOptions]


class InstanceMetadataOptionsRequest(TypedDict, total=False):
    """The metadata options for the instance."""

    HttpTokens: Optional[HttpTokensState]
    HttpPutResponseHopLimit: Optional[Integer]
    HttpEndpoint: Optional[InstanceMetadataEndpointState]
    HttpProtocolIpv6: Optional[InstanceMetadataProtocolState]
    InstanceMetadataTags: Optional[InstanceMetadataTagsState]


class InstanceMonitoring(TypedDict, total=False):
    """Describes the monitoring of an instance."""

    InstanceId: Optional[String]
    Monitoring: Optional[Monitoring]


InstanceMonitoringList = List[InstanceMonitoring]


class InstanceStateChange(TypedDict, total=False):
    """Describes an instance state change."""

    CurrentState: Optional[InstanceState]
    InstanceId: Optional[String]
    PreviousState: Optional[InstanceState]


InstanceStateChangeList = List[InstanceStateChange]


class IpamCidrAuthorizationContext(TypedDict, total=False):
    """A signed document that proves that you are authorized to bring the
    specified IP address range to Amazon using BYOIP.
    """

    Message: Optional[String]
    Signature: Optional[String]


class KeyPair(TypedDict, total=False):
    """Describes a key pair."""

    KeyFingerprint: Optional[String]
    KeyMaterial: Optional[SensitiveUserData]
    KeyName: Optional[String]
    KeyPairId: Optional[String]
    Tags: Optional[TagList]


class LaunchPermissionModifications(TypedDict, total=False):
    """Describes a launch permission modification."""

    Add: Optional[LaunchPermissionList]
    Remove: Optional[LaunchPermissionList]


class LaunchTemplateSpecification(TypedDict, total=False):
    """The launch template to use. You must specify either the launch template
    ID or launch template name in the request, but not both.
    """

    LaunchTemplateId: Optional[LaunchTemplateId]
    LaunchTemplateName: Optional[String]
    Version: Optional[String]


class LicenseConfigurationRequest(TypedDict, total=False):
    """Describes a license configuration."""

    LicenseConfigurationArn: Optional[String]


LicenseSpecificationListRequest = List[LicenseConfigurationRequest]


class ListSnapshotsInRecycleBinRequest(ServiceRequest):
    MaxResults: Optional[ListSnapshotsInRecycleBinMaxResults]
    NextToken: Optional[String]
    SnapshotIds: Optional[SnapshotIdStringList]
    DryRun: Optional[Boolean]


class SnapshotRecycleBinInfo(TypedDict, total=False):
    """Information about a snapshot that is currently in the Recycle Bin."""

    SnapshotId: Optional[String]
    RecycleBinEnterTime: Optional[MillisecondDateTime]
    RecycleBinExitTime: Optional[MillisecondDateTime]
    Description: Optional[String]
    VolumeId: Optional[String]


SnapshotRecycleBinInfoList = List[SnapshotRecycleBinInfo]


class ListSnapshotsInRecycleBinResult(TypedDict, total=False):
    Snapshots: Optional[SnapshotRecycleBinInfoList]
    NextToken: Optional[String]


class LoadPermissionRequest(TypedDict, total=False):
    """Describes a load permission."""

    Group: Optional[PermissionGroup]
    UserId: Optional[String]


LoadPermissionListRequest = List[LoadPermissionRequest]


class LoadPermissionModifications(TypedDict, total=False):
    """Describes modifications to the load permissions of an Amazon FPGA image
    (AFI).
    """

    Add: Optional[LoadPermissionListRequest]
    Remove: Optional[LoadPermissionListRequest]


LocalGatewayRouteList = List[LocalGatewayRoute]


class ModifyAddressAttributeRequest(ServiceRequest):
    AllocationId: AllocationId
    DomainName: Optional[String]
    DryRun: Optional[Boolean]


class ModifyAddressAttributeResult(TypedDict, total=False):
    Address: Optional[AddressAttribute]


class ModifyAvailabilityZoneGroupRequest(ServiceRequest):
    GroupName: String
    OptInStatus: ModifyAvailabilityZoneOptInStatus
    DryRun: Optional[Boolean]


class ModifyAvailabilityZoneGroupResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ModifyCapacityReservationFleetRequest(ServiceRequest):
    CapacityReservationFleetId: CapacityReservationFleetId
    TotalTargetCapacity: Optional[Integer]
    EndDate: Optional[MillisecondDateTime]
    DryRun: Optional[Boolean]
    RemoveEndDate: Optional[Boolean]


class ModifyCapacityReservationFleetResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ModifyCapacityReservationRequest(ServiceRequest):
    CapacityReservationId: CapacityReservationId
    InstanceCount: Optional[Integer]
    EndDate: Optional[DateTime]
    EndDateType: Optional[EndDateType]
    Accept: Optional[Boolean]
    DryRun: Optional[Boolean]
    AdditionalInfo: Optional[String]


class ModifyCapacityReservationResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ModifyClientVpnEndpointRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    ServerCertificateArn: Optional[String]
    ConnectionLogOptions: Optional[ConnectionLogOptions]
    DnsServers: Optional[DnsServersOptionsModifyStructure]
    VpnPort: Optional[Integer]
    Description: Optional[String]
    SplitTunnel: Optional[Boolean]
    DryRun: Optional[Boolean]
    SecurityGroupIds: Optional[ClientVpnSecurityGroupIdSet]
    VpcId: Optional[VpcId]
    SelfServicePortal: Optional[SelfServicePortal]
    ClientConnectOptions: Optional[ClientConnectOptions]
    SessionTimeoutHours: Optional[Integer]
    ClientLoginBannerOptions: Optional[ClientLoginBannerOptions]


class ModifyClientVpnEndpointResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ModifyDefaultCreditSpecificationRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceFamily: UnlimitedSupportedInstanceFamily
    CpuCredits: String


class ModifyDefaultCreditSpecificationResult(TypedDict, total=False):
    InstanceFamilyCreditSpecification: Optional[InstanceFamilyCreditSpecification]


class ModifyEbsDefaultKmsKeyIdRequest(ServiceRequest):
    KmsKeyId: KmsKeyId
    DryRun: Optional[Boolean]


class ModifyEbsDefaultKmsKeyIdResult(TypedDict, total=False):
    KmsKeyId: Optional[String]


class ModifyFleetRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ExcessCapacityTerminationPolicy: Optional[FleetExcessCapacityTerminationPolicy]
    LaunchTemplateConfigs: Optional[FleetLaunchTemplateConfigListRequest]
    FleetId: FleetId
    TargetCapacitySpecification: Optional[TargetCapacitySpecificationRequest]
    Context: Optional[String]


class ModifyFleetResult(TypedDict, total=False):
    Return: Optional[Boolean]


ProductCodeStringList = List[String]
UserGroupStringList = List[String]
UserIdStringList = List[String]


class ModifyFpgaImageAttributeRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    FpgaImageId: FpgaImageId
    Attribute: Optional[FpgaImageAttributeName]
    OperationType: Optional[OperationType]
    UserIds: Optional[UserIdStringList]
    UserGroups: Optional[UserGroupStringList]
    ProductCodes: Optional[ProductCodeStringList]
    LoadPermission: Optional[LoadPermissionModifications]
    Description: Optional[String]
    Name: Optional[String]


class ModifyFpgaImageAttributeResult(TypedDict, total=False):
    FpgaImageAttribute: Optional[FpgaImageAttribute]


class ModifyHostsRequest(ServiceRequest):
    AutoPlacement: Optional[AutoPlacement]
    HostIds: RequestHostIdList
    HostRecovery: Optional[HostRecovery]
    InstanceType: Optional[String]
    InstanceFamily: Optional[String]


UnsuccessfulItemList = List[UnsuccessfulItem]


class ModifyHostsResult(TypedDict, total=False):
    Successful: Optional[ResponseHostIdList]
    Unsuccessful: Optional[UnsuccessfulItemList]


class ModifyIdFormatRequest(ServiceRequest):
    Resource: String
    UseLongIds: Boolean


class ModifyIdentityIdFormatRequest(ServiceRequest):
    PrincipalArn: String
    Resource: String
    UseLongIds: Boolean


OrganizationalUnitArnStringList = List[String]
OrganizationArnStringList = List[String]


class ModifyImageAttributeRequest(ServiceRequest):
    """Contains the parameters for ModifyImageAttribute."""

    Attribute: Optional[String]
    Description: Optional[AttributeValue]
    ImageId: ImageId
    LaunchPermission: Optional[LaunchPermissionModifications]
    OperationType: Optional[OperationType]
    ProductCodes: Optional[ProductCodeStringList]
    UserGroups: Optional[UserGroupStringList]
    UserIds: Optional[UserIdStringList]
    Value: Optional[String]
    DryRun: Optional[Boolean]
    OrganizationArns: Optional[OrganizationArnStringList]
    OrganizationalUnitArns: Optional[OrganizationalUnitArnStringList]


class ModifyInstanceAttributeRequest(ServiceRequest):
    SourceDestCheck: Optional[AttributeBooleanValue]
    Attribute: Optional[InstanceAttributeName]
    BlockDeviceMappings: Optional[InstanceBlockDeviceMappingSpecificationList]
    DisableApiTermination: Optional[AttributeBooleanValue]
    DryRun: Optional[Boolean]
    EbsOptimized: Optional[AttributeBooleanValue]
    EnaSupport: Optional[AttributeBooleanValue]
    Groups: Optional[GroupIdStringList]
    InstanceId: InstanceId
    InstanceInitiatedShutdownBehavior: Optional[AttributeValue]
    InstanceType: Optional[AttributeValue]
    Kernel: Optional[AttributeValue]
    Ramdisk: Optional[AttributeValue]
    SriovNetSupport: Optional[AttributeValue]
    UserData: Optional[BlobAttributeValue]
    Value: Optional[String]


class ModifyInstanceCapacityReservationAttributesRequest(ServiceRequest):
    InstanceId: InstanceId
    CapacityReservationSpecification: CapacityReservationSpecification
    DryRun: Optional[Boolean]


class ModifyInstanceCapacityReservationAttributesResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ModifyInstanceCreditSpecificationRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]
    InstanceCreditSpecifications: InstanceCreditSpecificationListRequest


class UnsuccessfulInstanceCreditSpecificationItemError(TypedDict, total=False):
    """Information about the error for the burstable performance instance whose
    credit option for CPU usage was not modified.
    """

    Code: Optional[UnsuccessfulInstanceCreditSpecificationErrorCode]
    Message: Optional[String]


class UnsuccessfulInstanceCreditSpecificationItem(TypedDict, total=False):
    """Describes the burstable performance instance whose credit option for CPU
    usage was not modified.
    """

    InstanceId: Optional[String]
    Error: Optional[UnsuccessfulInstanceCreditSpecificationItemError]


UnsuccessfulInstanceCreditSpecificationSet = List[UnsuccessfulInstanceCreditSpecificationItem]


class SuccessfulInstanceCreditSpecificationItem(TypedDict, total=False):
    """Describes the burstable performance instance whose credit option for CPU
    usage was successfully modified.
    """

    InstanceId: Optional[String]


SuccessfulInstanceCreditSpecificationSet = List[SuccessfulInstanceCreditSpecificationItem]


class ModifyInstanceCreditSpecificationResult(TypedDict, total=False):
    SuccessfulInstanceCreditSpecifications: Optional[SuccessfulInstanceCreditSpecificationSet]
    UnsuccessfulInstanceCreditSpecifications: Optional[UnsuccessfulInstanceCreditSpecificationSet]


class ModifyInstanceEventStartTimeRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceId: InstanceId
    InstanceEventId: String
    NotBefore: DateTime


class ModifyInstanceEventStartTimeResult(TypedDict, total=False):
    Event: Optional[InstanceStatusEvent]


class ModifyInstanceEventWindowRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Name: Optional[String]
    InstanceEventWindowId: InstanceEventWindowId
    TimeRanges: Optional[InstanceEventWindowTimeRangeRequestSet]
    CronExpression: Optional[InstanceEventWindowCronExpression]


class ModifyInstanceEventWindowResult(TypedDict, total=False):
    InstanceEventWindow: Optional[InstanceEventWindow]


class ModifyInstanceMetadataOptionsRequest(ServiceRequest):
    InstanceId: InstanceId
    HttpTokens: Optional[HttpTokensState]
    HttpPutResponseHopLimit: Optional[Integer]
    HttpEndpoint: Optional[InstanceMetadataEndpointState]
    DryRun: Optional[Boolean]
    HttpProtocolIpv6: Optional[InstanceMetadataProtocolState]
    InstanceMetadataTags: Optional[InstanceMetadataTagsState]


class ModifyInstanceMetadataOptionsResult(TypedDict, total=False):
    InstanceId: Optional[String]
    InstanceMetadataOptions: Optional[InstanceMetadataOptionsResponse]


class ModifyInstancePlacementRequest(ServiceRequest):
    Affinity: Optional[Affinity]
    GroupName: Optional[PlacementGroupName]
    HostId: Optional[DedicatedHostId]
    InstanceId: InstanceId
    Tenancy: Optional[HostTenancy]
    PartitionNumber: Optional[Integer]
    HostResourceGroupArn: Optional[String]


class ModifyInstancePlacementResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ModifyIpamPoolRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamPoolId: IpamPoolId
    Description: Optional[String]
    AutoImport: Optional[Boolean]
    AllocationMinNetmaskLength: Optional[IpamNetmaskLength]
    AllocationMaxNetmaskLength: Optional[IpamNetmaskLength]
    AllocationDefaultNetmaskLength: Optional[IpamNetmaskLength]
    ClearAllocationDefaultNetmaskLength: Optional[Boolean]
    AddAllocationResourceTags: Optional[RequestIpamResourceTagList]
    RemoveAllocationResourceTags: Optional[RequestIpamResourceTagList]


class ModifyIpamPoolResult(TypedDict, total=False):
    IpamPool: Optional[IpamPool]


class RemoveIpamOperatingRegion(TypedDict, total=False):
    """Remove an operating Region from an IPAM. Operating Regions are Amazon
    Web Services Regions where the IPAM is allowed to manage IP address
    CIDRs. IPAM only discovers and monitors resources in the Amazon Web
    Services Regions you select as operating Regions.

    For more information about operating Regions, see `Create an
    IPAM </vpc/latest/ipam/create-ipam.html>`__ in the *Amazon VPC IPAM User
    Guide*
    """

    RegionName: Optional[String]


RemoveIpamOperatingRegionSet = List[RemoveIpamOperatingRegion]


class ModifyIpamRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamId: IpamId
    Description: Optional[String]
    AddOperatingRegions: Optional[AddIpamOperatingRegionSet]
    RemoveOperatingRegions: Optional[RemoveIpamOperatingRegionSet]


class ModifyIpamResourceCidrRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ResourceId: String
    ResourceCidr: String
    ResourceRegion: String
    CurrentIpamScopeId: IpamScopeId
    DestinationIpamScopeId: Optional[IpamScopeId]
    Monitored: Boolean


class ModifyIpamResourceCidrResult(TypedDict, total=False):
    IpamResourceCidr: Optional[IpamResourceCidr]


class ModifyIpamResult(TypedDict, total=False):
    Ipam: Optional[Ipam]


class ModifyIpamScopeRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamScopeId: IpamScopeId
    Description: Optional[String]


class ModifyIpamScopeResult(TypedDict, total=False):
    IpamScope: Optional[IpamScope]


class ModifyLaunchTemplateRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ClientToken: Optional[String]
    LaunchTemplateId: Optional[LaunchTemplateId]
    LaunchTemplateName: Optional[LaunchTemplateName]
    DefaultVersion: Optional[String]


class ModifyLaunchTemplateResult(TypedDict, total=False):
    LaunchTemplate: Optional[LaunchTemplate]


class RemovePrefixListEntry(TypedDict, total=False):
    """An entry for a prefix list."""

    Cidr: String


RemovePrefixListEntries = List[RemovePrefixListEntry]


class ModifyManagedPrefixListRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PrefixListId: PrefixListResourceId
    CurrentVersion: Optional[Long]
    PrefixListName: Optional[String]
    AddEntries: Optional[AddPrefixListEntries]
    RemoveEntries: Optional[RemovePrefixListEntries]
    MaxEntries: Optional[Integer]


class ModifyManagedPrefixListResult(TypedDict, total=False):
    PrefixList: Optional[ManagedPrefixList]


class NetworkInterfaceAttachmentChanges(TypedDict, total=False):
    """Describes an attachment change."""

    AttachmentId: Optional[NetworkInterfaceAttachmentId]
    DeleteOnTermination: Optional[Boolean]


class ModifyNetworkInterfaceAttributeRequest(ServiceRequest):
    """Contains the parameters for ModifyNetworkInterfaceAttribute."""

    Attachment: Optional[NetworkInterfaceAttachmentChanges]
    Description: Optional[AttributeValue]
    DryRun: Optional[Boolean]
    Groups: Optional[SecurityGroupIdStringList]
    NetworkInterfaceId: NetworkInterfaceId
    SourceDestCheck: Optional[AttributeBooleanValue]


class ModifyPrivateDnsNameOptionsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceId: Optional[InstanceId]
    PrivateDnsHostnameType: Optional[HostnameType]
    EnableResourceNameDnsARecord: Optional[Boolean]
    EnableResourceNameDnsAAAARecord: Optional[Boolean]


class ModifyPrivateDnsNameOptionsResult(TypedDict, total=False):
    Return: Optional[Boolean]


ReservedInstancesConfigurationList = List[ReservedInstancesConfiguration]


class ModifyReservedInstancesRequest(ServiceRequest):
    """Contains the parameters for ModifyReservedInstances."""

    ReservedInstancesIds: ReservedInstancesIdStringList
    ClientToken: Optional[String]
    TargetConfigurations: ReservedInstancesConfigurationList


class ModifyReservedInstancesResult(TypedDict, total=False):
    """Contains the output of ModifyReservedInstances."""

    ReservedInstancesModificationId: Optional[String]


class SecurityGroupRuleRequest(TypedDict, total=False):
    """Describes a security group rule.

    You must specify exactly one of the following parameters, based on the
    rule type:

    -  CidrIpv4

    -  CidrIpv6

    -  PrefixListId

    -  ReferencedGroupId

    When you modify a rule, you cannot change the rule type. For example, if
    the rule uses an IPv4 address range, you must use ``CidrIpv4`` to
    specify a new IPv4 address range.
    """

    IpProtocol: Optional[String]
    FromPort: Optional[Integer]
    ToPort: Optional[Integer]
    CidrIpv4: Optional[String]
    CidrIpv6: Optional[String]
    PrefixListId: Optional[PrefixListResourceId]
    ReferencedGroupId: Optional[SecurityGroupId]
    Description: Optional[String]


class SecurityGroupRuleUpdate(TypedDict, total=False):
    """Describes an update to a security group rule."""

    SecurityGroupRuleId: Optional[SecurityGroupRuleId]
    SecurityGroupRule: Optional[SecurityGroupRuleRequest]


SecurityGroupRuleUpdateList = List[SecurityGroupRuleUpdate]


class ModifySecurityGroupRulesRequest(ServiceRequest):
    GroupId: SecurityGroupId
    SecurityGroupRules: SecurityGroupRuleUpdateList
    DryRun: Optional[Boolean]


class ModifySecurityGroupRulesResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ModifySnapshotAttributeRequest(ServiceRequest):
    Attribute: Optional[SnapshotAttributeName]
    CreateVolumePermission: Optional[CreateVolumePermissionModifications]
    GroupNames: Optional[GroupNameStringList]
    OperationType: Optional[OperationType]
    SnapshotId: SnapshotId
    UserIds: Optional[UserIdStringList]
    DryRun: Optional[Boolean]


class ModifySnapshotTierRequest(ServiceRequest):
    SnapshotId: SnapshotId
    StorageTier: Optional[TargetStorageTier]
    DryRun: Optional[Boolean]


class ModifySnapshotTierResult(TypedDict, total=False):
    SnapshotId: Optional[String]
    TieringStartTime: Optional[MillisecondDateTime]


class ModifySpotFleetRequestRequest(ServiceRequest):
    """Contains the parameters for ModifySpotFleetRequest."""

    ExcessCapacityTerminationPolicy: Optional[ExcessCapacityTerminationPolicy]
    LaunchTemplateConfigs: Optional[LaunchTemplateConfigList]
    SpotFleetRequestId: SpotFleetRequestId
    TargetCapacity: Optional[Integer]
    OnDemandTargetCapacity: Optional[Integer]
    Context: Optional[String]


class ModifySpotFleetRequestResponse(TypedDict, total=False):
    """Contains the output of ModifySpotFleetRequest."""

    Return: Optional[Boolean]


class ModifySubnetAttributeRequest(ServiceRequest):
    AssignIpv6AddressOnCreation: Optional[AttributeBooleanValue]
    MapPublicIpOnLaunch: Optional[AttributeBooleanValue]
    SubnetId: SubnetId
    MapCustomerOwnedIpOnLaunch: Optional[AttributeBooleanValue]
    CustomerOwnedIpv4Pool: Optional[CoipPoolId]
    EnableDns64: Optional[AttributeBooleanValue]
    PrivateDnsHostnameTypeOnLaunch: Optional[HostnameType]
    EnableResourceNameDnsARecordOnLaunch: Optional[AttributeBooleanValue]
    EnableResourceNameDnsAAAARecordOnLaunch: Optional[AttributeBooleanValue]
    EnableLniAtDeviceIndex: Optional[Integer]
    DisableLniAtDeviceIndex: Optional[AttributeBooleanValue]


class ModifyTrafficMirrorFilterNetworkServicesRequest(ServiceRequest):
    TrafficMirrorFilterId: TrafficMirrorFilterId
    AddNetworkServices: Optional[TrafficMirrorNetworkServiceList]
    RemoveNetworkServices: Optional[TrafficMirrorNetworkServiceList]
    DryRun: Optional[Boolean]


class ModifyTrafficMirrorFilterNetworkServicesResult(TypedDict, total=False):
    TrafficMirrorFilter: Optional[TrafficMirrorFilter]


TrafficMirrorFilterRuleFieldList = List[TrafficMirrorFilterRuleField]


class ModifyTrafficMirrorFilterRuleRequest(ServiceRequest):
    TrafficMirrorFilterRuleId: TrafficMirrorFilterRuleId
    TrafficDirection: Optional[TrafficDirection]
    RuleNumber: Optional[Integer]
    RuleAction: Optional[TrafficMirrorRuleAction]
    DestinationPortRange: Optional[TrafficMirrorPortRangeRequest]
    SourcePortRange: Optional[TrafficMirrorPortRangeRequest]
    Protocol: Optional[Integer]
    DestinationCidrBlock: Optional[String]
    SourceCidrBlock: Optional[String]
    Description: Optional[String]
    RemoveFields: Optional[TrafficMirrorFilterRuleFieldList]
    DryRun: Optional[Boolean]


class ModifyTrafficMirrorFilterRuleResult(TypedDict, total=False):
    TrafficMirrorFilterRule: Optional[TrafficMirrorFilterRule]


TrafficMirrorSessionFieldList = List[TrafficMirrorSessionField]


class ModifyTrafficMirrorSessionRequest(ServiceRequest):
    TrafficMirrorSessionId: TrafficMirrorSessionId
    TrafficMirrorTargetId: Optional[TrafficMirrorTargetId]
    TrafficMirrorFilterId: Optional[TrafficMirrorFilterId]
    PacketLength: Optional[Integer]
    SessionNumber: Optional[Integer]
    VirtualNetworkId: Optional[Integer]
    Description: Optional[String]
    RemoveFields: Optional[TrafficMirrorSessionFieldList]
    DryRun: Optional[Boolean]


class ModifyTrafficMirrorSessionResult(TypedDict, total=False):
    TrafficMirrorSession: Optional[TrafficMirrorSession]


class ModifyTransitGatewayOptions(TypedDict, total=False):
    """The transit gateway options."""

    AddTransitGatewayCidrBlocks: Optional[TransitGatewayCidrBlockStringList]
    RemoveTransitGatewayCidrBlocks: Optional[TransitGatewayCidrBlockStringList]
    VpnEcmpSupport: Optional[VpnEcmpSupportValue]
    DnsSupport: Optional[DnsSupportValue]
    AutoAcceptSharedAttachments: Optional[AutoAcceptSharedAttachmentsValue]
    DefaultRouteTableAssociation: Optional[DefaultRouteTableAssociationValue]
    AssociationDefaultRouteTableId: Optional[TransitGatewayRouteTableId]
    DefaultRouteTablePropagation: Optional[DefaultRouteTablePropagationValue]
    PropagationDefaultRouteTableId: Optional[TransitGatewayRouteTableId]


class ModifyTransitGatewayPrefixListReferenceRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    PrefixListId: PrefixListResourceId
    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    Blackhole: Optional[Boolean]
    DryRun: Optional[Boolean]


class ModifyTransitGatewayPrefixListReferenceResult(TypedDict, total=False):
    TransitGatewayPrefixListReference: Optional[TransitGatewayPrefixListReference]


class ModifyTransitGatewayRequest(ServiceRequest):
    TransitGatewayId: TransitGatewayId
    Description: Optional[String]
    Options: Optional[ModifyTransitGatewayOptions]
    DryRun: Optional[Boolean]


class ModifyTransitGatewayResult(TypedDict, total=False):
    TransitGateway: Optional[TransitGateway]


class ModifyTransitGatewayVpcAttachmentRequestOptions(TypedDict, total=False):
    """Describes the options for a VPC attachment."""

    DnsSupport: Optional[DnsSupportValue]
    Ipv6Support: Optional[Ipv6SupportValue]
    ApplianceModeSupport: Optional[ApplianceModeSupportValue]


class ModifyTransitGatewayVpcAttachmentRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    AddSubnetIds: Optional[TransitGatewaySubnetIdList]
    RemoveSubnetIds: Optional[TransitGatewaySubnetIdList]
    Options: Optional[ModifyTransitGatewayVpcAttachmentRequestOptions]
    DryRun: Optional[Boolean]


class ModifyTransitGatewayVpcAttachmentResult(TypedDict, total=False):
    TransitGatewayVpcAttachment: Optional[TransitGatewayVpcAttachment]


class ModifyVolumeAttributeRequest(ServiceRequest):
    AutoEnableIO: Optional[AttributeBooleanValue]
    VolumeId: VolumeId
    DryRun: Optional[Boolean]


class ModifyVolumeRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VolumeId: VolumeId
    Size: Optional[Integer]
    VolumeType: Optional[VolumeType]
    Iops: Optional[Integer]
    Throughput: Optional[Integer]
    MultiAttachEnabled: Optional[Boolean]


class ModifyVolumeResult(TypedDict, total=False):
    VolumeModification: Optional[VolumeModification]


class ModifyVpcAttributeRequest(ServiceRequest):
    EnableDnsHostnames: Optional[AttributeBooleanValue]
    EnableDnsSupport: Optional[AttributeBooleanValue]
    VpcId: VpcId


class ModifyVpcEndpointConnectionNotificationRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ConnectionNotificationId: ConnectionNotificationId
    ConnectionNotificationArn: Optional[String]
    ConnectionEvents: Optional[ValueStringList]


class ModifyVpcEndpointConnectionNotificationResult(TypedDict, total=False):
    ReturnValue: Optional[Boolean]


class ModifyVpcEndpointRequest(ServiceRequest):
    """Contains the parameters for ModifyVpcEndpoint."""

    DryRun: Optional[Boolean]
    VpcEndpointId: VpcEndpointId
    ResetPolicy: Optional[Boolean]
    PolicyDocument: Optional[String]
    AddRouteTableIds: Optional[VpcEndpointRouteTableIdList]
    RemoveRouteTableIds: Optional[VpcEndpointRouteTableIdList]
    AddSubnetIds: Optional[VpcEndpointSubnetIdList]
    RemoveSubnetIds: Optional[VpcEndpointSubnetIdList]
    AddSecurityGroupIds: Optional[VpcEndpointSecurityGroupIdList]
    RemoveSecurityGroupIds: Optional[VpcEndpointSecurityGroupIdList]
    PrivateDnsEnabled: Optional[Boolean]


class ModifyVpcEndpointResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ModifyVpcEndpointServiceConfigurationRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceId: VpcEndpointServiceId
    PrivateDnsName: Optional[String]
    RemovePrivateDnsName: Optional[Boolean]
    AcceptanceRequired: Optional[Boolean]
    AddNetworkLoadBalancerArns: Optional[ValueStringList]
    RemoveNetworkLoadBalancerArns: Optional[ValueStringList]
    AddGatewayLoadBalancerArns: Optional[ValueStringList]
    RemoveGatewayLoadBalancerArns: Optional[ValueStringList]


class ModifyVpcEndpointServiceConfigurationResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ModifyVpcEndpointServicePayerResponsibilityRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceId: VpcEndpointServiceId
    PayerResponsibility: PayerResponsibility


class ModifyVpcEndpointServicePayerResponsibilityResult(TypedDict, total=False):
    ReturnValue: Optional[Boolean]


class ModifyVpcEndpointServicePermissionsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceId: VpcEndpointServiceId
    AddAllowedPrincipals: Optional[ValueStringList]
    RemoveAllowedPrincipals: Optional[ValueStringList]


class ModifyVpcEndpointServicePermissionsResult(TypedDict, total=False):
    ReturnValue: Optional[Boolean]


class PeeringConnectionOptionsRequest(TypedDict, total=False):
    """The VPC peering connection options."""

    AllowDnsResolutionFromRemoteVpc: Optional[Boolean]
    AllowEgressFromLocalClassicLinkToRemoteVpc: Optional[Boolean]
    AllowEgressFromLocalVpcToRemoteClassicLink: Optional[Boolean]


class ModifyVpcPeeringConnectionOptionsRequest(ServiceRequest):
    AccepterPeeringConnectionOptions: Optional[PeeringConnectionOptionsRequest]
    DryRun: Optional[Boolean]
    RequesterPeeringConnectionOptions: Optional[PeeringConnectionOptionsRequest]
    VpcPeeringConnectionId: VpcPeeringConnectionId


class PeeringConnectionOptions(TypedDict, total=False):
    """Describes the VPC peering connection options."""

    AllowDnsResolutionFromRemoteVpc: Optional[Boolean]
    AllowEgressFromLocalClassicLinkToRemoteVpc: Optional[Boolean]
    AllowEgressFromLocalVpcToRemoteClassicLink: Optional[Boolean]


class ModifyVpcPeeringConnectionOptionsResult(TypedDict, total=False):
    AccepterPeeringConnectionOptions: Optional[PeeringConnectionOptions]
    RequesterPeeringConnectionOptions: Optional[PeeringConnectionOptions]


class ModifyVpcTenancyRequest(ServiceRequest):
    VpcId: VpcId
    InstanceTenancy: VpcTenancy
    DryRun: Optional[Boolean]


class ModifyVpcTenancyResult(TypedDict, total=False):
    ReturnValue: Optional[Boolean]


class ModifyVpnConnectionOptionsRequest(ServiceRequest):
    VpnConnectionId: VpnConnectionId
    LocalIpv4NetworkCidr: Optional[String]
    RemoteIpv4NetworkCidr: Optional[String]
    LocalIpv6NetworkCidr: Optional[String]
    RemoteIpv6NetworkCidr: Optional[String]
    DryRun: Optional[Boolean]


class ModifyVpnConnectionOptionsResult(TypedDict, total=False):
    VpnConnection: Optional[VpnConnection]


class ModifyVpnConnectionRequest(ServiceRequest):
    VpnConnectionId: VpnConnectionId
    TransitGatewayId: Optional[TransitGatewayId]
    CustomerGatewayId: Optional[CustomerGatewayId]
    VpnGatewayId: Optional[VpnGatewayId]
    DryRun: Optional[Boolean]


class ModifyVpnConnectionResult(TypedDict, total=False):
    VpnConnection: Optional[VpnConnection]


class ModifyVpnTunnelCertificateRequest(ServiceRequest):
    VpnConnectionId: VpnConnectionId
    VpnTunnelOutsideIpAddress: String
    DryRun: Optional[Boolean]


class ModifyVpnTunnelCertificateResult(TypedDict, total=False):
    VpnConnection: Optional[VpnConnection]


class ModifyVpnTunnelOptionsSpecification(TypedDict, total=False):
    """The Amazon Web Services Site-to-Site VPN tunnel options to modify."""

    TunnelInsideCidr: Optional[String]
    TunnelInsideIpv6Cidr: Optional[String]
    PreSharedKey: Optional[String]
    Phase1LifetimeSeconds: Optional[Integer]
    Phase2LifetimeSeconds: Optional[Integer]
    RekeyMarginTimeSeconds: Optional[Integer]
    RekeyFuzzPercentage: Optional[Integer]
    ReplayWindowSize: Optional[Integer]
    DPDTimeoutSeconds: Optional[Integer]
    DPDTimeoutAction: Optional[String]
    Phase1EncryptionAlgorithms: Optional[Phase1EncryptionAlgorithmsRequestList]
    Phase2EncryptionAlgorithms: Optional[Phase2EncryptionAlgorithmsRequestList]
    Phase1IntegrityAlgorithms: Optional[Phase1IntegrityAlgorithmsRequestList]
    Phase2IntegrityAlgorithms: Optional[Phase2IntegrityAlgorithmsRequestList]
    Phase1DHGroupNumbers: Optional[Phase1DHGroupNumbersRequestList]
    Phase2DHGroupNumbers: Optional[Phase2DHGroupNumbersRequestList]
    IKEVersions: Optional[IKEVersionsRequestList]
    StartupAction: Optional[String]


class ModifyVpnTunnelOptionsRequest(ServiceRequest):
    VpnConnectionId: VpnConnectionId
    VpnTunnelOutsideIpAddress: String
    TunnelOptions: ModifyVpnTunnelOptionsSpecification
    DryRun: Optional[Boolean]


class ModifyVpnTunnelOptionsResult(TypedDict, total=False):
    VpnConnection: Optional[VpnConnection]


class MonitorInstancesRequest(ServiceRequest):
    InstanceIds: InstanceIdStringList
    DryRun: Optional[Boolean]


class MonitorInstancesResult(TypedDict, total=False):
    InstanceMonitorings: Optional[InstanceMonitoringList]


class MoveAddressToVpcRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PublicIp: String


class MoveAddressToVpcResult(TypedDict, total=False):
    AllocationId: Optional[String]
    Status: Optional[Status]


class MoveByoipCidrToIpamRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    Cidr: String
    IpamPoolId: IpamPoolId
    IpamPoolOwner: String


class MoveByoipCidrToIpamResult(TypedDict, total=False):
    ByoipCidr: Optional[ByoipCidr]


class PrivateDnsNameOptionsRequest(TypedDict, total=False):
    """Describes the options for instance hostnames."""

    HostnameType: Optional[HostnameType]
    EnableResourceNameDnsARecord: Optional[Boolean]
    EnableResourceNameDnsAAAARecord: Optional[Boolean]


class ScheduledInstancesPrivateIpAddressConfig(TypedDict, total=False):
    """Describes a private IPv4 address for a Scheduled Instance."""

    Primary: Optional[Boolean]
    PrivateIpAddress: Optional[String]


PrivateIpAddressConfigSet = List[ScheduledInstancesPrivateIpAddressConfig]


class ProvisionByoipCidrRequest(ServiceRequest):
    Cidr: String
    CidrAuthorizationContext: Optional[CidrAuthorizationContext]
    PubliclyAdvertisable: Optional[Boolean]
    Description: Optional[String]
    DryRun: Optional[Boolean]
    PoolTagSpecifications: Optional[TagSpecificationList]
    MultiRegion: Optional[Boolean]


class ProvisionByoipCidrResult(TypedDict, total=False):
    ByoipCidr: Optional[ByoipCidr]


class ProvisionIpamPoolCidrRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamPoolId: IpamPoolId
    Cidr: Optional[String]
    CidrAuthorizationContext: Optional[IpamCidrAuthorizationContext]


class ProvisionIpamPoolCidrResult(TypedDict, total=False):
    IpamPoolCidr: Optional[IpamPoolCidr]


class ProvisionPublicIpv4PoolCidrRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamPoolId: IpamPoolId
    PoolId: Ipv4PoolEc2Id
    NetmaskLength: Integer


class ProvisionPublicIpv4PoolCidrResult(TypedDict, total=False):
    PoolId: Optional[Ipv4PoolEc2Id]
    PoolAddressRange: Optional[PublicIpv4PoolRange]


class PurchaseHostReservationRequest(ServiceRequest):
    ClientToken: Optional[String]
    CurrencyCode: Optional[CurrencyCodeValues]
    HostIdSet: RequestHostIdSet
    LimitPrice: Optional[String]
    OfferingId: OfferingId
    TagSpecifications: Optional[TagSpecificationList]


class PurchaseHostReservationResult(TypedDict, total=False):
    ClientToken: Optional[String]
    CurrencyCode: Optional[CurrencyCodeValues]
    Purchase: Optional[PurchaseSet]
    TotalHourlyPrice: Optional[String]
    TotalUpfrontPrice: Optional[String]


class PurchaseRequest(TypedDict, total=False):
    """Describes a request to purchase Scheduled Instances."""

    InstanceCount: Integer
    PurchaseToken: String


PurchaseRequestSet = List[PurchaseRequest]


class ReservedInstanceLimitPrice(TypedDict, total=False):
    """Describes the limit price of a Reserved Instance offering."""

    Amount: Optional[Double]
    CurrencyCode: Optional[CurrencyCodeValues]


class PurchaseReservedInstancesOfferingRequest(ServiceRequest):
    """Contains the parameters for PurchaseReservedInstancesOffering."""

    InstanceCount: Integer
    ReservedInstancesOfferingId: ReservedInstancesOfferingId
    DryRun: Optional[Boolean]
    LimitPrice: Optional[ReservedInstanceLimitPrice]
    PurchaseTime: Optional[DateTime]


class PurchaseReservedInstancesOfferingResult(TypedDict, total=False):
    """Contains the output of PurchaseReservedInstancesOffering."""

    ReservedInstancesId: Optional[String]


class PurchaseScheduledInstancesRequest(ServiceRequest):
    """Contains the parameters for PurchaseScheduledInstances."""

    ClientToken: Optional[String]
    DryRun: Optional[Boolean]
    PurchaseRequests: PurchaseRequestSet


PurchasedScheduledInstanceSet = List[ScheduledInstance]


class PurchaseScheduledInstancesResult(TypedDict, total=False):
    """Contains the output of PurchaseScheduledInstances."""

    ScheduledInstanceSet: Optional[PurchasedScheduledInstanceSet]


ReasonCodesList = List[ReportInstanceReasonCodes]


class RebootInstancesRequest(ServiceRequest):
    InstanceIds: InstanceIdStringList
    DryRun: Optional[Boolean]


class RegisterImageRequest(ServiceRequest):
    """Contains the parameters for RegisterImage."""

    ImageLocation: Optional[String]
    Architecture: Optional[ArchitectureValues]
    BlockDeviceMappings: Optional[BlockDeviceMappingRequestList]
    Description: Optional[String]
    DryRun: Optional[Boolean]
    EnaSupport: Optional[Boolean]
    KernelId: Optional[KernelId]
    Name: String
    BillingProducts: Optional[BillingProductList]
    RamdiskId: Optional[RamdiskId]
    RootDeviceName: Optional[String]
    SriovNetSupport: Optional[String]
    VirtualizationType: Optional[String]
    BootMode: Optional[BootModeValues]


class RegisterImageResult(TypedDict, total=False):
    """Contains the output of RegisterImage."""

    ImageId: Optional[String]


class RegisterInstanceTagAttributeRequest(TypedDict, total=False):
    """Information about the tag keys to register for the current Region. You
    can either specify individual tag keys or register all tag keys in the
    current Region. You must specify either ``IncludeAllTagsOfInstance`` or
    ``InstanceTagKeys`` in the request
    """

    IncludeAllTagsOfInstance: Optional[Boolean]
    InstanceTagKeys: Optional[InstanceTagKeySet]


class RegisterInstanceEventNotificationAttributesRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    InstanceTagAttribute: Optional[RegisterInstanceTagAttributeRequest]


class RegisterInstanceEventNotificationAttributesResult(TypedDict, total=False):
    InstanceTagAttribute: Optional[InstanceTagNotificationAttribute]


class RegisterTransitGatewayMulticastGroupMembersRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    GroupIpAddress: Optional[String]
    NetworkInterfaceIds: Optional[TransitGatewayNetworkInterfaceIdList]
    DryRun: Optional[Boolean]


class TransitGatewayMulticastRegisteredGroupMembers(TypedDict, total=False):
    """Describes the registered transit gateway multicast group members."""

    TransitGatewayMulticastDomainId: Optional[String]
    RegisteredNetworkInterfaceIds: Optional[ValueStringList]
    GroupIpAddress: Optional[String]


class RegisterTransitGatewayMulticastGroupMembersResult(TypedDict, total=False):
    RegisteredMulticastGroupMembers: Optional[TransitGatewayMulticastRegisteredGroupMembers]


class RegisterTransitGatewayMulticastGroupSourcesRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    GroupIpAddress: Optional[String]
    NetworkInterfaceIds: Optional[TransitGatewayNetworkInterfaceIdList]
    DryRun: Optional[Boolean]


class TransitGatewayMulticastRegisteredGroupSources(TypedDict, total=False):
    """Describes the members registered with the transit gateway multicast
    group.
    """

    TransitGatewayMulticastDomainId: Optional[String]
    RegisteredNetworkInterfaceIds: Optional[ValueStringList]
    GroupIpAddress: Optional[String]


class RegisterTransitGatewayMulticastGroupSourcesResult(TypedDict, total=False):
    RegisteredMulticastGroupSources: Optional[TransitGatewayMulticastRegisteredGroupSources]


class RejectTransitGatewayMulticastDomainAssociationsRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    SubnetIds: Optional[ValueStringList]
    DryRun: Optional[Boolean]


class RejectTransitGatewayMulticastDomainAssociationsResult(TypedDict, total=False):
    Associations: Optional[TransitGatewayMulticastDomainAssociations]


class RejectTransitGatewayPeeringAttachmentRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class RejectTransitGatewayPeeringAttachmentResult(TypedDict, total=False):
    TransitGatewayPeeringAttachment: Optional[TransitGatewayPeeringAttachment]


class RejectTransitGatewayVpcAttachmentRequest(ServiceRequest):
    TransitGatewayAttachmentId: TransitGatewayAttachmentId
    DryRun: Optional[Boolean]


class RejectTransitGatewayVpcAttachmentResult(TypedDict, total=False):
    TransitGatewayVpcAttachment: Optional[TransitGatewayVpcAttachment]


class RejectVpcEndpointConnectionsRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceId: VpcEndpointServiceId
    VpcEndpointIds: VpcEndpointIdList


class RejectVpcEndpointConnectionsResult(TypedDict, total=False):
    Unsuccessful: Optional[UnsuccessfulItemSet]


class RejectVpcPeeringConnectionRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    VpcPeeringConnectionId: VpcPeeringConnectionId


class RejectVpcPeeringConnectionResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ReleaseAddressRequest(ServiceRequest):
    AllocationId: Optional[AllocationId]
    PublicIp: Optional[String]
    NetworkBorderGroup: Optional[String]
    DryRun: Optional[Boolean]


class ReleaseHostsRequest(ServiceRequest):
    HostIds: RequestHostIdList


class ReleaseHostsResult(TypedDict, total=False):
    Successful: Optional[ResponseHostIdList]
    Unsuccessful: Optional[UnsuccessfulItemList]


class ReleaseIpamPoolAllocationRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    IpamPoolId: IpamPoolId
    Cidr: String
    IpamPoolAllocationId: Optional[IpamPoolAllocationId]


class ReleaseIpamPoolAllocationResult(TypedDict, total=False):
    Success: Optional[Boolean]


class ReplaceIamInstanceProfileAssociationRequest(ServiceRequest):
    IamInstanceProfile: IamInstanceProfileSpecification
    AssociationId: IamInstanceProfileAssociationId


class ReplaceIamInstanceProfileAssociationResult(TypedDict, total=False):
    IamInstanceProfileAssociation: Optional[IamInstanceProfileAssociation]


class ReplaceNetworkAclAssociationRequest(ServiceRequest):
    AssociationId: NetworkAclAssociationId
    DryRun: Optional[Boolean]
    NetworkAclId: NetworkAclId


class ReplaceNetworkAclAssociationResult(TypedDict, total=False):
    NewAssociationId: Optional[String]


class ReplaceNetworkAclEntryRequest(ServiceRequest):
    CidrBlock: Optional[String]
    DryRun: Optional[Boolean]
    Egress: Boolean
    IcmpTypeCode: Optional[IcmpTypeCode]
    Ipv6CidrBlock: Optional[String]
    NetworkAclId: NetworkAclId
    PortRange: Optional[PortRange]
    Protocol: String
    RuleAction: RuleAction
    RuleNumber: Integer


class ReplaceRouteRequest(ServiceRequest):
    DestinationCidrBlock: Optional[String]
    DestinationIpv6CidrBlock: Optional[String]
    DestinationPrefixListId: Optional[PrefixListResourceId]
    DryRun: Optional[Boolean]
    VpcEndpointId: Optional[VpcEndpointId]
    EgressOnlyInternetGatewayId: Optional[EgressOnlyInternetGatewayId]
    GatewayId: Optional[RouteGatewayId]
    InstanceId: Optional[InstanceId]
    LocalTarget: Optional[Boolean]
    NatGatewayId: Optional[NatGatewayId]
    TransitGatewayId: Optional[TransitGatewayId]
    LocalGatewayId: Optional[LocalGatewayId]
    CarrierGatewayId: Optional[CarrierGatewayId]
    NetworkInterfaceId: Optional[NetworkInterfaceId]
    RouteTableId: RouteTableId
    VpcPeeringConnectionId: Optional[VpcPeeringConnectionId]
    CoreNetworkArn: Optional[CoreNetworkArn]


class ReplaceRouteTableAssociationRequest(ServiceRequest):
    AssociationId: RouteTableAssociationId
    DryRun: Optional[Boolean]
    RouteTableId: RouteTableId


class ReplaceRouteTableAssociationResult(TypedDict, total=False):
    NewAssociationId: Optional[String]
    AssociationState: Optional[RouteTableAssociationState]


class ReplaceTransitGatewayRouteRequest(ServiceRequest):
    DestinationCidrBlock: String
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    TransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    Blackhole: Optional[Boolean]
    DryRun: Optional[Boolean]


class ReplaceTransitGatewayRouteResult(TypedDict, total=False):
    Route: Optional[TransitGatewayRoute]


class ReportInstanceStatusRequest(ServiceRequest):
    Description: Optional[String]
    DryRun: Optional[Boolean]
    EndTime: Optional[DateTime]
    Instances: InstanceIdStringList
    ReasonCodes: ReasonCodesList
    StartTime: Optional[DateTime]
    Status: ReportStatusType


class RequestSpotFleetRequest(ServiceRequest):
    """Contains the parameters for RequestSpotFleet."""

    DryRun: Optional[Boolean]
    SpotFleetRequestConfig: SpotFleetRequestConfigData


class RequestSpotFleetResponse(TypedDict, total=False):
    """Contains the output of RequestSpotFleet."""

    SpotFleetRequestId: Optional[String]


RequestSpotLaunchSpecificationSecurityGroupList = List[String]
RequestSpotLaunchSpecificationSecurityGroupIdList = List[SecurityGroupId]


class RequestSpotLaunchSpecification(TypedDict, total=False):
    """Describes the launch specification for an instance."""

    SecurityGroupIds: Optional[RequestSpotLaunchSpecificationSecurityGroupIdList]
    SecurityGroups: Optional[RequestSpotLaunchSpecificationSecurityGroupList]
    AddressingType: Optional[String]
    BlockDeviceMappings: Optional[BlockDeviceMappingList]
    EbsOptimized: Optional[Boolean]
    IamInstanceProfile: Optional[IamInstanceProfileSpecification]
    ImageId: Optional[ImageId]
    InstanceType: Optional[InstanceType]
    KernelId: Optional[KernelId]
    KeyName: Optional[KeyPairName]
    Monitoring: Optional[RunInstancesMonitoringEnabled]
    NetworkInterfaces: Optional[InstanceNetworkInterfaceSpecificationList]
    Placement: Optional[SpotPlacement]
    RamdiskId: Optional[RamdiskId]
    SubnetId: Optional[SubnetId]
    UserData: Optional[String]


class RequestSpotInstancesRequest(ServiceRequest):
    """Contains the parameters for RequestSpotInstances."""

    AvailabilityZoneGroup: Optional[String]
    BlockDurationMinutes: Optional[Integer]
    ClientToken: Optional[String]
    DryRun: Optional[Boolean]
    InstanceCount: Optional[Integer]
    LaunchGroup: Optional[String]
    LaunchSpecification: Optional[RequestSpotLaunchSpecification]
    SpotPrice: Optional[String]
    Type: Optional[SpotInstanceType]
    ValidFrom: Optional[DateTime]
    ValidUntil: Optional[DateTime]
    TagSpecifications: Optional[TagSpecificationList]
    InstanceInterruptionBehavior: Optional[InstanceInterruptionBehavior]


class RequestSpotInstancesResult(TypedDict, total=False):
    """Contains the output of RequestSpotInstances."""

    SpotInstanceRequests: Optional[SpotInstanceRequestList]


class ResetAddressAttributeRequest(ServiceRequest):
    AllocationId: AllocationId
    Attribute: AddressAttributeName
    DryRun: Optional[Boolean]


class ResetAddressAttributeResult(TypedDict, total=False):
    Address: Optional[AddressAttribute]


class ResetEbsDefaultKmsKeyIdRequest(ServiceRequest):
    DryRun: Optional[Boolean]


class ResetEbsDefaultKmsKeyIdResult(TypedDict, total=False):
    KmsKeyId: Optional[String]


class ResetFpgaImageAttributeRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    FpgaImageId: FpgaImageId
    Attribute: Optional[ResetFpgaImageAttributeName]


class ResetFpgaImageAttributeResult(TypedDict, total=False):
    Return: Optional[Boolean]


class ResetImageAttributeRequest(ServiceRequest):
    """Contains the parameters for ResetImageAttribute."""

    Attribute: ResetImageAttributeName
    ImageId: ImageId
    DryRun: Optional[Boolean]


class ResetInstanceAttributeRequest(ServiceRequest):
    Attribute: InstanceAttributeName
    DryRun: Optional[Boolean]
    InstanceId: InstanceId


class ResetNetworkInterfaceAttributeRequest(ServiceRequest):
    """Contains the parameters for ResetNetworkInterfaceAttribute."""

    DryRun: Optional[Boolean]
    NetworkInterfaceId: NetworkInterfaceId
    SourceDestCheck: Optional[String]


class ResetSnapshotAttributeRequest(ServiceRequest):
    Attribute: SnapshotAttributeName
    SnapshotId: SnapshotId
    DryRun: Optional[Boolean]


class RestoreAddressToClassicRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PublicIp: String


class RestoreAddressToClassicResult(TypedDict, total=False):
    PublicIp: Optional[String]
    Status: Optional[Status]


class RestoreManagedPrefixListVersionRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    PrefixListId: PrefixListResourceId
    PreviousVersion: Long
    CurrentVersion: Long


class RestoreManagedPrefixListVersionResult(TypedDict, total=False):
    PrefixList: Optional[ManagedPrefixList]


class RestoreSnapshotFromRecycleBinRequest(ServiceRequest):
    SnapshotId: SnapshotId
    DryRun: Optional[Boolean]


class RestoreSnapshotFromRecycleBinResult(TypedDict, total=False):
    SnapshotId: Optional[String]
    OutpostArn: Optional[String]
    Description: Optional[String]
    Encrypted: Optional[Boolean]
    OwnerId: Optional[String]
    Progress: Optional[String]
    StartTime: Optional[MillisecondDateTime]
    State: Optional[SnapshotState]
    VolumeId: Optional[String]
    VolumeSize: Optional[Integer]


class RestoreSnapshotTierRequest(ServiceRequest):
    SnapshotId: SnapshotId
    TemporaryRestoreDays: Optional[RestoreSnapshotTierRequestTemporaryRestoreDays]
    PermanentRestore: Optional[Boolean]
    DryRun: Optional[Boolean]


class RestoreSnapshotTierResult(TypedDict, total=False):
    SnapshotId: Optional[String]
    RestoreStartTime: Optional[MillisecondDateTime]
    RestoreDuration: Optional[Integer]
    IsPermanentRestore: Optional[Boolean]


class RevokeClientVpnIngressRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    TargetNetworkCidr: String
    AccessGroupId: Optional[String]
    RevokeAllGroups: Optional[Boolean]
    DryRun: Optional[Boolean]


class RevokeClientVpnIngressResult(TypedDict, total=False):
    Status: Optional[ClientVpnAuthorizationRuleStatus]


class RevokeSecurityGroupEgressRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    GroupId: SecurityGroupId
    IpPermissions: Optional[IpPermissionList]
    SecurityGroupRuleIds: Optional[SecurityGroupRuleIdList]
    CidrIp: Optional[String]
    FromPort: Optional[Integer]
    IpProtocol: Optional[String]
    ToPort: Optional[Integer]
    SourceSecurityGroupName: Optional[String]
    SourceSecurityGroupOwnerId: Optional[String]


class RevokeSecurityGroupEgressResult(TypedDict, total=False):
    Return: Optional[Boolean]
    UnknownIpPermissions: Optional[IpPermissionList]


class RevokeSecurityGroupIngressRequest(ServiceRequest):
    CidrIp: Optional[String]
    FromPort: Optional[Integer]
    GroupId: Optional[SecurityGroupId]
    GroupName: Optional[SecurityGroupName]
    IpPermissions: Optional[IpPermissionList]
    IpProtocol: Optional[String]
    SourceSecurityGroupName: Optional[String]
    SourceSecurityGroupOwnerId: Optional[String]
    ToPort: Optional[Integer]
    DryRun: Optional[Boolean]
    SecurityGroupRuleIds: Optional[SecurityGroupRuleIdList]


class RevokeSecurityGroupIngressResult(TypedDict, total=False):
    Return: Optional[Boolean]
    UnknownIpPermissions: Optional[IpPermissionList]


class RunInstancesRequest(ServiceRequest):
    BlockDeviceMappings: Optional[BlockDeviceMappingRequestList]
    ImageId: Optional[ImageId]
    InstanceType: Optional[InstanceType]
    Ipv6AddressCount: Optional[Integer]
    Ipv6Addresses: Optional[InstanceIpv6AddressList]
    KernelId: Optional[KernelId]
    KeyName: Optional[KeyPairName]
    MaxCount: Integer
    MinCount: Integer
    Monitoring: Optional[RunInstancesMonitoringEnabled]
    Placement: Optional[Placement]
    RamdiskId: Optional[RamdiskId]
    SecurityGroupIds: Optional[SecurityGroupIdStringList]
    SecurityGroups: Optional[SecurityGroupStringList]
    SubnetId: Optional[SubnetId]
    UserData: Optional[String]
    AdditionalInfo: Optional[String]
    ClientToken: Optional[String]
    DisableApiTermination: Optional[Boolean]
    DryRun: Optional[Boolean]
    EbsOptimized: Optional[Boolean]
    IamInstanceProfile: Optional[IamInstanceProfileSpecification]
    InstanceInitiatedShutdownBehavior: Optional[ShutdownBehavior]
    NetworkInterfaces: Optional[InstanceNetworkInterfaceSpecificationList]
    PrivateIpAddress: Optional[String]
    ElasticGpuSpecification: Optional[ElasticGpuSpecifications]
    ElasticInferenceAccelerators: Optional[ElasticInferenceAccelerators]
    TagSpecifications: Optional[TagSpecificationList]
    LaunchTemplate: Optional[LaunchTemplateSpecification]
    InstanceMarketOptions: Optional[InstanceMarketOptionsRequest]
    CreditSpecification: Optional[CreditSpecificationRequest]
    CpuOptions: Optional[CpuOptionsRequest]
    CapacityReservationSpecification: Optional[CapacityReservationSpecification]
    HibernationOptions: Optional[HibernationOptionsRequest]
    LicenseSpecifications: Optional[LicenseSpecificationListRequest]
    MetadataOptions: Optional[InstanceMetadataOptionsRequest]
    EnclaveOptions: Optional[EnclaveOptionsRequest]
    PrivateDnsNameOptions: Optional[PrivateDnsNameOptionsRequest]


ScheduledInstancesSecurityGroupIdSet = List[SecurityGroupId]


class ScheduledInstancesPlacement(TypedDict, total=False):
    """Describes the placement for a Scheduled Instance."""

    AvailabilityZone: Optional[String]
    GroupName: Optional[PlacementGroupName]


class ScheduledInstancesIpv6Address(TypedDict, total=False):
    """Describes an IPv6 address."""

    Ipv6Address: Optional[Ipv6Address]


ScheduledInstancesIpv6AddressList = List[ScheduledInstancesIpv6Address]


class ScheduledInstancesNetworkInterface(TypedDict, total=False):
    """Describes a network interface for a Scheduled Instance."""

    AssociatePublicIpAddress: Optional[Boolean]
    DeleteOnTermination: Optional[Boolean]
    Description: Optional[String]
    DeviceIndex: Optional[Integer]
    Groups: Optional[ScheduledInstancesSecurityGroupIdSet]
    Ipv6AddressCount: Optional[Integer]
    Ipv6Addresses: Optional[ScheduledInstancesIpv6AddressList]
    NetworkInterfaceId: Optional[NetworkInterfaceId]
    PrivateIpAddress: Optional[String]
    PrivateIpAddressConfigs: Optional[PrivateIpAddressConfigSet]
    SecondaryPrivateIpAddressCount: Optional[Integer]
    SubnetId: Optional[SubnetId]


ScheduledInstancesNetworkInterfaceSet = List[ScheduledInstancesNetworkInterface]


class ScheduledInstancesMonitoring(TypedDict, total=False):
    """Describes whether monitoring is enabled for a Scheduled Instance."""

    Enabled: Optional[Boolean]


class ScheduledInstancesIamInstanceProfile(TypedDict, total=False):
    """Describes an IAM instance profile for a Scheduled Instance."""

    Arn: Optional[String]
    Name: Optional[String]


class ScheduledInstancesEbs(TypedDict, total=False):
    """Describes an EBS volume for a Scheduled Instance."""

    DeleteOnTermination: Optional[Boolean]
    Encrypted: Optional[Boolean]
    Iops: Optional[Integer]
    SnapshotId: Optional[SnapshotId]
    VolumeSize: Optional[Integer]
    VolumeType: Optional[String]


class ScheduledInstancesBlockDeviceMapping(TypedDict, total=False):
    """Describes a block device mapping for a Scheduled Instance."""

    DeviceName: Optional[String]
    Ebs: Optional[ScheduledInstancesEbs]
    NoDevice: Optional[String]
    VirtualName: Optional[String]


ScheduledInstancesBlockDeviceMappingSet = List[ScheduledInstancesBlockDeviceMapping]


class ScheduledInstancesLaunchSpecification(TypedDict, total=False):
    """Describes the launch specification for a Scheduled Instance.

    If you are launching the Scheduled Instance in EC2-VPC, you must specify
    the ID of the subnet. You can specify the subnet using either
    ``SubnetId`` or ``NetworkInterface``.
    """

    BlockDeviceMappings: Optional[ScheduledInstancesBlockDeviceMappingSet]
    EbsOptimized: Optional[Boolean]
    IamInstanceProfile: Optional[ScheduledInstancesIamInstanceProfile]
    ImageId: ImageId
    InstanceType: Optional[String]
    KernelId: Optional[KernelId]
    KeyName: Optional[KeyPairName]
    Monitoring: Optional[ScheduledInstancesMonitoring]
    NetworkInterfaces: Optional[ScheduledInstancesNetworkInterfaceSet]
    Placement: Optional[ScheduledInstancesPlacement]
    RamdiskId: Optional[RamdiskId]
    SecurityGroupIds: Optional[ScheduledInstancesSecurityGroupIdSet]
    SubnetId: Optional[SubnetId]
    UserData: Optional[String]


class RunScheduledInstancesRequest(ServiceRequest):
    """Contains the parameters for RunScheduledInstances."""

    ClientToken: Optional[String]
    DryRun: Optional[Boolean]
    InstanceCount: Optional[Integer]
    LaunchSpecification: ScheduledInstancesLaunchSpecification
    ScheduledInstanceId: ScheduledInstanceId


class RunScheduledInstancesResult(TypedDict, total=False):
    """Contains the output of RunScheduledInstances."""

    InstanceIdSet: Optional[InstanceIdSet]


class SearchLocalGatewayRoutesRequest(ServiceRequest):
    LocalGatewayRouteTableId: LocalGatewayRoutetableId
    Filters: Optional[FilterList]
    MaxResults: Optional[MaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class SearchLocalGatewayRoutesResult(TypedDict, total=False):
    Routes: Optional[LocalGatewayRouteList]
    NextToken: Optional[String]


class SearchTransitGatewayMulticastGroupsRequest(ServiceRequest):
    TransitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId]
    Filters: Optional[FilterList]
    MaxResults: Optional[TransitGatewayMaxResults]
    NextToken: Optional[String]
    DryRun: Optional[Boolean]


class TransitGatewayMulticastGroup(TypedDict, total=False):
    """Describes the transit gateway multicast group resources."""

    GroupIpAddress: Optional[String]
    TransitGatewayAttachmentId: Optional[String]
    SubnetId: Optional[String]
    ResourceId: Optional[String]
    ResourceType: Optional[TransitGatewayAttachmentResourceType]
    ResourceOwnerId: Optional[String]
    NetworkInterfaceId: Optional[String]
    GroupMember: Optional[Boolean]
    GroupSource: Optional[Boolean]
    MemberType: Optional[MembershipType]
    SourceType: Optional[MembershipType]


TransitGatewayMulticastGroupList = List[TransitGatewayMulticastGroup]


class SearchTransitGatewayMulticastGroupsResult(TypedDict, total=False):
    MulticastGroups: Optional[TransitGatewayMulticastGroupList]
    NextToken: Optional[String]


class SearchTransitGatewayRoutesRequest(ServiceRequest):
    TransitGatewayRouteTableId: TransitGatewayRouteTableId
    Filters: FilterList
    MaxResults: Optional[TransitGatewayMaxResults]
    DryRun: Optional[Boolean]


TransitGatewayRouteList = List[TransitGatewayRoute]


class SearchTransitGatewayRoutesResult(TypedDict, total=False):
    Routes: Optional[TransitGatewayRouteList]
    AdditionalRoutesAvailable: Optional[Boolean]


class SecurityGroupRuleDescription(TypedDict, total=False):
    """Describes the description of a security group rule.

    You can use this when you want to update the security group rule
    description for either an inbound or outbound rule.
    """

    SecurityGroupRuleId: Optional[String]
    Description: Optional[String]


SecurityGroupRuleDescriptionList = List[SecurityGroupRuleDescription]


class SendDiagnosticInterruptRequest(ServiceRequest):
    InstanceId: InstanceId
    DryRun: Optional[Boolean]


class StartInstancesRequest(ServiceRequest):
    InstanceIds: InstanceIdStringList
    AdditionalInfo: Optional[String]
    DryRun: Optional[Boolean]


class StartInstancesResult(TypedDict, total=False):
    StartingInstances: Optional[InstanceStateChangeList]


class StartNetworkInsightsAccessScopeAnalysisRequest(ServiceRequest):
    NetworkInsightsAccessScopeId: NetworkInsightsAccessScopeId
    DryRun: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]
    ClientToken: String


class StartNetworkInsightsAccessScopeAnalysisResult(TypedDict, total=False):
    NetworkInsightsAccessScopeAnalysis: Optional[NetworkInsightsAccessScopeAnalysis]


class StartNetworkInsightsAnalysisRequest(ServiceRequest):
    NetworkInsightsPathId: NetworkInsightsPathId
    FilterInArns: Optional[ArnList]
    DryRun: Optional[Boolean]
    TagSpecifications: Optional[TagSpecificationList]
    ClientToken: String


class StartNetworkInsightsAnalysisResult(TypedDict, total=False):
    NetworkInsightsAnalysis: Optional[NetworkInsightsAnalysis]


class StartVpcEndpointServicePrivateDnsVerificationRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    ServiceId: VpcEndpointServiceId


class StartVpcEndpointServicePrivateDnsVerificationResult(TypedDict, total=False):
    ReturnValue: Optional[Boolean]


class StopInstancesRequest(ServiceRequest):
    InstanceIds: InstanceIdStringList
    Hibernate: Optional[Boolean]
    DryRun: Optional[Boolean]
    Force: Optional[Boolean]


class StopInstancesResult(TypedDict, total=False):
    StoppingInstances: Optional[InstanceStateChangeList]


class TerminateClientVpnConnectionsRequest(ServiceRequest):
    ClientVpnEndpointId: ClientVpnEndpointId
    ConnectionId: Optional[VpnConnectionId]
    Username: Optional[String]
    DryRun: Optional[Boolean]


class TerminateConnectionStatus(TypedDict, total=False):
    """Information about a terminated Client VPN endpoint client connection."""

    ConnectionId: Optional[String]
    PreviousStatus: Optional[ClientVpnConnectionStatus]
    CurrentStatus: Optional[ClientVpnConnectionStatus]


TerminateConnectionStatusSet = List[TerminateConnectionStatus]


class TerminateClientVpnConnectionsResult(TypedDict, total=False):
    ClientVpnEndpointId: Optional[String]
    Username: Optional[String]
    ConnectionStatuses: Optional[TerminateConnectionStatusSet]


class TerminateInstancesRequest(ServiceRequest):
    InstanceIds: InstanceIdStringList
    DryRun: Optional[Boolean]


class TerminateInstancesResult(TypedDict, total=False):
    TerminatingInstances: Optional[InstanceStateChangeList]


class UnassignIpv6AddressesRequest(ServiceRequest):
    Ipv6Addresses: Optional[Ipv6AddressList]
    Ipv6Prefixes: Optional[IpPrefixList]
    NetworkInterfaceId: NetworkInterfaceId


class UnassignIpv6AddressesResult(TypedDict, total=False):
    NetworkInterfaceId: Optional[String]
    UnassignedIpv6Addresses: Optional[Ipv6AddressList]
    UnassignedIpv6Prefixes: Optional[IpPrefixList]


class UnassignPrivateIpAddressesRequest(ServiceRequest):
    """Contains the parameters for UnassignPrivateIpAddresses."""

    NetworkInterfaceId: NetworkInterfaceId
    PrivateIpAddresses: Optional[PrivateIpAddressStringList]
    Ipv4Prefixes: Optional[IpPrefixList]


class UnmonitorInstancesRequest(ServiceRequest):
    InstanceIds: InstanceIdStringList
    DryRun: Optional[Boolean]


class UnmonitorInstancesResult(TypedDict, total=False):
    InstanceMonitorings: Optional[InstanceMonitoringList]


class UpdateSecurityGroupRuleDescriptionsEgressRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    GroupId: Optional[SecurityGroupId]
    GroupName: Optional[SecurityGroupName]
    IpPermissions: Optional[IpPermissionList]
    SecurityGroupRuleDescriptions: Optional[SecurityGroupRuleDescriptionList]


class UpdateSecurityGroupRuleDescriptionsEgressResult(TypedDict, total=False):
    Return: Optional[Boolean]


class UpdateSecurityGroupRuleDescriptionsIngressRequest(ServiceRequest):
    DryRun: Optional[Boolean]
    GroupId: Optional[SecurityGroupId]
    GroupName: Optional[SecurityGroupName]
    IpPermissions: Optional[IpPermissionList]
    SecurityGroupRuleDescriptions: Optional[SecurityGroupRuleDescriptionList]


class UpdateSecurityGroupRuleDescriptionsIngressResult(TypedDict, total=False):
    Return: Optional[Boolean]


class WithdrawByoipCidrRequest(ServiceRequest):
    Cidr: String
    DryRun: Optional[Boolean]


class WithdrawByoipCidrResult(TypedDict, total=False):
    ByoipCidr: Optional[ByoipCidr]


class Ec2Api:

    service = "ec2"
    version = "2016-11-15"

    @handler("AcceptReservedInstancesExchangeQuote")
    def accept_reserved_instances_exchange_quote(
        self,
        context: RequestContext,
        reserved_instance_ids: ReservedInstanceIdSet,
        dry_run: Boolean = None,
        target_configurations: TargetConfigurationRequestSet = None,
    ) -> AcceptReservedInstancesExchangeQuoteResult:
        """Accepts the Convertible Reserved Instance exchange quote described in
        the GetReservedInstancesExchangeQuote call.

        :param reserved_instance_ids: The IDs of the Convertible Reserved Instances to exchange for another
        Convertible Reserved Instance of the same or higher value.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param target_configurations: The configuration of the target Convertible Reserved Instance to
        exchange for your current Convertible Reserved Instances.
        :returns: AcceptReservedInstancesExchangeQuoteResult
        """
        raise NotImplementedError

    @handler("AcceptTransitGatewayMulticastDomainAssociations")
    def accept_transit_gateway_multicast_domain_associations(
        self,
        context: RequestContext,
        transit_gateway_multicast_domain_id: TransitGatewayMulticastDomainId = None,
        transit_gateway_attachment_id: TransitGatewayAttachmentId = None,
        subnet_ids: ValueStringList = None,
        dry_run: Boolean = None,
    ) -> AcceptTransitGatewayMulticastDomainAssociationsResult:
        """Accepts a request to associate subnets with a transit gateway multicast
        domain.

        :param transit_gateway_multicast_domain_id: The ID of the transit gateway multicast domain.
        :param transit_gateway_attachment_id: The ID of the transit gateway attachment.
        :param subnet_ids: The IDs of the subnets to associate with the transit gateway multicast
        domain.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AcceptTransitGatewayMulticastDomainAssociationsResult
        """
        raise NotImplementedError

    @handler("AcceptTransitGatewayPeeringAttachment")
    def accept_transit_gateway_peering_attachment(
        self,
        context: RequestContext,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        dry_run: Boolean = None,
    ) -> AcceptTransitGatewayPeeringAttachmentResult:
        """Accepts a transit gateway peering attachment request. The peering
        attachment must be in the ``pendingAcceptance`` state.

        :param transit_gateway_attachment_id: The ID of the transit gateway attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AcceptTransitGatewayPeeringAttachmentResult
        """
        raise NotImplementedError

    @handler("AcceptTransitGatewayVpcAttachment")
    def accept_transit_gateway_vpc_attachment(
        self,
        context: RequestContext,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        dry_run: Boolean = None,
    ) -> AcceptTransitGatewayVpcAttachmentResult:
        """Accepts a request to attach a VPC to a transit gateway.

        The VPC attachment must be in the ``pendingAcceptance`` state. Use
        DescribeTransitGatewayVpcAttachments to view your pending VPC attachment
        requests. Use RejectTransitGatewayVpcAttachment to reject a VPC
        attachment request.

        :param transit_gateway_attachment_id: The ID of the attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AcceptTransitGatewayVpcAttachmentResult
        """
        raise NotImplementedError

    @handler("AcceptVpcEndpointConnections")
    def accept_vpc_endpoint_connections(
        self,
        context: RequestContext,
        service_id: VpcEndpointServiceId,
        vpc_endpoint_ids: VpcEndpointIdList,
        dry_run: Boolean = None,
    ) -> AcceptVpcEndpointConnectionsResult:
        """Accepts one or more interface VPC endpoint connection requests to your
        VPC endpoint service.

        :param service_id: The ID of the VPC endpoint service.
        :param vpc_endpoint_ids: The IDs of one or more interface VPC endpoints.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AcceptVpcEndpointConnectionsResult
        """
        raise NotImplementedError

    @handler("AcceptVpcPeeringConnection")
    def accept_vpc_peering_connection(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        vpc_peering_connection_id: VpcPeeringConnectionId = None,
    ) -> AcceptVpcPeeringConnectionResult:
        """Accept a VPC peering connection request. To accept a request, the VPC
        peering connection must be in the ``pending-acceptance`` state, and you
        must be the owner of the peer VPC. Use DescribeVpcPeeringConnections to
        view your outstanding VPC peering connection requests.

        For an inter-Region VPC peering connection request, you must accept the
        VPC peering connection in the Region of the accepter VPC.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param vpc_peering_connection_id: The ID of the VPC peering connection.
        :returns: AcceptVpcPeeringConnectionResult
        """
        raise NotImplementedError

    @handler("AdvertiseByoipCidr")
    def advertise_byoip_cidr(
        self, context: RequestContext, cidr: String, dry_run: Boolean = None
    ) -> AdvertiseByoipCidrResult:
        """Advertises an IPv4 or IPv6 address range that is provisioned for use
        with your Amazon Web Services resources through bring your own IP
        addresses (BYOIP).

        You can perform this operation at most once every 10 seconds, even if
        you specify different address ranges each time.

        We recommend that you stop advertising the BYOIP CIDR from other
        locations when you advertise it from Amazon Web Services. To minimize
        down time, you can configure your Amazon Web Services resources to use
        an address from a BYOIP CIDR before it is advertised, and then
        simultaneously stop advertising it from the current location and start
        advertising it through Amazon Web Services.

        It can take a few minutes before traffic to the specified addresses
        starts routing to Amazon Web Services because of BGP propagation delays.

        To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.

        :param cidr: The address range, in CIDR notation.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AdvertiseByoipCidrResult
        """
        raise NotImplementedError

    @handler("AllocateAddress")
    def allocate_address(
        self,
        context: RequestContext,
        domain: DomainType = None,
        address: PublicIpAddress = None,
        public_ipv4_pool: Ipv4PoolEc2Id = None,
        network_border_group: String = None,
        customer_owned_ipv4_pool: String = None,
        dry_run: Boolean = None,
        tag_specifications: TagSpecificationList = None,
    ) -> AllocateAddressResult:
        """Allocates an Elastic IP address to your Amazon Web Services account.
        After you allocate the Elastic IP address you can associate it with an
        instance or network interface. After you release an Elastic IP address,
        it is released to the IP address pool and can be allocated to a
        different Amazon Web Services account.

        You can allocate an Elastic IP address from an address pool owned by
        Amazon Web Services or from an address pool created from a public IPv4
        address range that you have brought to Amazon Web Services for use with
        your Amazon Web Services resources using bring your own IP addresses
        (BYOIP). For more information, see `Bring Your Own IP Addresses
        (BYOIP) <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        [EC2-VPC] If you release an Elastic IP address, you might be able to
        recover it. You cannot recover an Elastic IP address that you released
        after it is allocated to another Amazon Web Services account. You cannot
        recover an Elastic IP address for EC2-Classic. To attempt to recover an
        Elastic IP address that you released, specify it in this operation.

        An Elastic IP address is for use either in the EC2-Classic platform or
        in a VPC. By default, you can allocate 5 Elastic IP addresses for
        EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per
        Region.

        For more information, see `Elastic IP
        Addresses <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        You can allocate a carrier IP address which is a public IP address from
        a telecommunication carrier, to a network interface which resides in a
        subnet in a Wavelength Zone (for example an EC2 instance).

        :param domain: Indicates whether the Elastic IP address is for use with instances in a
        VPC or instances in EC2-Classic.
        :param address: [EC2-VPC] The Elastic IP address to recover or an IPv4 address from an
        address pool.
        :param public_ipv4_pool: The ID of an address pool that you own.
        :param network_border_group: A unique set of Availability Zones, Local Zones, or Wavelength Zones
        from which Amazon Web Services advertises IP addresses.
        :param customer_owned_ipv4_pool: The ID of a customer-owned address pool.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param tag_specifications: The tags to assign to the Elastic IP address.
        :returns: AllocateAddressResult
        """
        raise NotImplementedError

    @handler("AllocateHosts")
    def allocate_hosts(
        self,
        context: RequestContext,
        availability_zone: String,
        quantity: Integer,
        auto_placement: AutoPlacement = None,
        client_token: String = None,
        instance_type: String = None,
        instance_family: String = None,
        tag_specifications: TagSpecificationList = None,
        host_recovery: HostRecovery = None,
    ) -> AllocateHostsResult:
        """Allocates a Dedicated Host to your account. At a minimum, specify the
        supported instance type or instance family, the Availability Zone in
        which to allocate the host, and the number of hosts to allocate.

        :param availability_zone: The Availability Zone in which to allocate the Dedicated Host.
        :param quantity: The number of Dedicated Hosts to allocate to your account with these
        parameters.
        :param auto_placement: Indicates whether the host accepts any untargeted instance launches that
        match its instance type configuration, or if it only accepts Host
        tenancy instance launches that specify its unique host ID.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param instance_type: Specifies the instance type to be supported by the Dedicated Hosts.
        :param instance_family: Specifies the instance family to be supported by the Dedicated Hosts.
        :param tag_specifications: The tags to apply to the Dedicated Host during creation.
        :param host_recovery: Indicates whether to enable or disable host recovery for the Dedicated
        Host.
        :returns: AllocateHostsResult
        """
        raise NotImplementedError

    @handler("AllocateIpamPoolCidr")
    def allocate_ipam_pool_cidr(
        self,
        context: RequestContext,
        ipam_pool_id: IpamPoolId,
        dry_run: Boolean = None,
        cidr: String = None,
        netmask_length: Integer = None,
        client_token: String = None,
        description: String = None,
        preview_next_cidr: Boolean = None,
        disallowed_cidrs: IpamPoolAllocationDisallowedCidrs = None,
    ) -> AllocateIpamPoolCidrResult:
        """Allocate a CIDR from an IPAM pool. In IPAM, an allocation is a CIDR
        assignment from an IPAM pool to another resource or IPAM pool. For more
        information, see `Allocate
        CIDRs </vpc/latest/ipam/allocate-cidrs-ipam.html>`__ in the *Amazon VPC
        IPAM User Guide*.

        :param ipam_pool_id: The ID of the IPAM pool from which you would like to allocate a CIDR.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :param cidr: The CIDR you would like to allocate from the IPAM pool.
        :param netmask_length: The netmask length of the CIDR you would like to allocate from the IPAM
        pool.
        :param client_token: A unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param description: A description for the allocation.
        :param preview_next_cidr: A preview of the next available CIDR in a pool.
        :param disallowed_cidrs: Exclude a particular CIDR range from being returned by the pool.
        :returns: AllocateIpamPoolCidrResult
        """
        raise NotImplementedError

    @handler("ApplySecurityGroupsToClientVpnTargetNetwork")
    def apply_security_groups_to_client_vpn_target_network(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        vpc_id: VpcId,
        security_group_ids: ClientVpnSecurityGroupIdSet,
        dry_run: Boolean = None,
    ) -> ApplySecurityGroupsToClientVpnTargetNetworkResult:
        """Applies a security group to the association between the target network
        and the Client VPN endpoint. This action replaces the existing security
        groups with the specified security groups.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint.
        :param vpc_id: The ID of the VPC in which the associated target network is located.
        :param security_group_ids: The IDs of the security groups to apply to the associated target
        network.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: ApplySecurityGroupsToClientVpnTargetNetworkResult
        """
        raise NotImplementedError

    @handler("AssignIpv6Addresses")
    def assign_ipv6_addresses(
        self,
        context: RequestContext,
        network_interface_id: NetworkInterfaceId,
        ipv6_address_count: Integer = None,
        ipv6_addresses: Ipv6AddressList = None,
        ipv6_prefix_count: Integer = None,
        ipv6_prefixes: IpPrefixList = None,
    ) -> AssignIpv6AddressesResult:
        """Assigns one or more IPv6 addresses to the specified network interface.
        You can specify one or more specific IPv6 addresses, or you can specify
        the number of IPv6 addresses to be automatically assigned from within
        the subnet's IPv6 CIDR block range. You can assign as many IPv6
        addresses to a network interface as you can assign private IPv4
        addresses, and the limit varies per instance type. For information, see
        `IP Addresses Per Network Interface Per Instance
        Type <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        You must specify either the IPv6 addresses or the IPv6 address count in
        the request.

        You can optionally use Prefix Delegation on the network interface. You
        must specify either the IPV6 Prefix Delegation prefixes, or the IPv6
        Prefix Delegation count. For information, see `Assigning prefixes to
        Amazon EC2 network
        interfaces <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param network_interface_id: The ID of the network interface.
        :param ipv6_address_count: The number of additional IPv6 addresses to assign to the network
        interface.
        :param ipv6_addresses: One or more specific IPv6 addresses to be assigned to the network
        interface.
        :param ipv6_prefix_count: The number of IPv6 prefixes that Amazon Web Services automatically
        assigns to the network interface.
        :param ipv6_prefixes: One or more IPv6 prefixes assigned to the network interface.
        :returns: AssignIpv6AddressesResult
        """
        raise NotImplementedError

    @handler("AssignPrivateIpAddresses")
    def assign_private_ip_addresses(
        self,
        context: RequestContext,
        network_interface_id: NetworkInterfaceId,
        allow_reassignment: Boolean = None,
        private_ip_addresses: PrivateIpAddressStringList = None,
        secondary_private_ip_address_count: Integer = None,
        ipv4_prefixes: IpPrefixList = None,
        ipv4_prefix_count: Integer = None,
    ) -> AssignPrivateIpAddressesResult:
        """Assigns one or more secondary private IP addresses to the specified
        network interface.

        You can specify one or more specific secondary IP addresses, or you can
        specify the number of secondary IP addresses to be automatically
        assigned within the subnet's CIDR block range. The number of secondary
        IP addresses that you can assign to an instance varies by instance type.
        For information about instance types, see `Instance
        Types <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*. For more information
        about Elastic IP addresses, see `Elastic IP
        Addresses <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        When you move a secondary private IP address to another network
        interface, any Elastic IP address that is associated with the IP address
        is also moved.

        Remapping an IP address is an asynchronous operation. When you move an
        IP address from one network interface to another, check
        ``network/interfaces/macs/mac/local-ipv4s`` in the instance metadata to
        confirm that the remapping is complete.

        You must specify either the IP addresses or the IP address count in the
        request.

        You can optionally use Prefix Delegation on the network interface. You
        must specify either the IPv4 Prefix Delegation prefixes, or the IPv4
        Prefix Delegation count. For information, see `Assigning prefixes to
        Amazon EC2 network
        interfaces <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param network_interface_id: The ID of the network interface.
        :param allow_reassignment: Indicates whether to allow an IP address that is already assigned to
        another network interface or instance to be reassigned to the specified
        network interface.
        :param private_ip_addresses: One or more IP addresses to be assigned as a secondary private IP
        address to the network interface.
        :param secondary_private_ip_address_count: The number of secondary IP addresses to assign to the network interface.
        :param ipv4_prefixes: One or more IPv4 prefixes assigned to the network interface.
        :param ipv4_prefix_count: The number of IPv4 prefixes that Amazon Web Services automatically
        assigns to the network interface.
        :returns: AssignPrivateIpAddressesResult
        """
        raise NotImplementedError

    @handler("AssociateAddress")
    def associate_address(
        self,
        context: RequestContext,
        allocation_id: AllocationId = None,
        instance_id: InstanceId = None,
        public_ip: String = None,
        allow_reassociation: Boolean = None,
        dry_run: Boolean = None,
        network_interface_id: NetworkInterfaceId = None,
        private_ip_address: String = None,
    ) -> AssociateAddressResult:
        """Associates an Elastic IP address, or carrier IP address (for instances
        that are in subnets in Wavelength Zones) with an instance or a network
        interface. Before you can use an Elastic IP address, you must allocate
        it to your account.

        An Elastic IP address is for use in either the EC2-Classic platform or
        in a VPC. For more information, see `Elastic IP
        Addresses <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        [EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP address
        is already associated with a different instance, it is disassociated
        from that instance and associated with the specified instance. If you
        associate an Elastic IP address with an instance that has an existing
        Elastic IP address, the existing address is disassociated from the
        instance, but remains allocated to your account.

        [VPC in an EC2-Classic account] If you don't specify a private IP
        address, the Elastic IP address is associated with the primary IP
        address. If the Elastic IP address is already associated with a
        different instance or a network interface, you get an error unless you
        allow reassociation. You cannot associate an Elastic IP address with an
        instance or network interface that has an existing Elastic IP address.

        [Subnets in Wavelength Zones] You can associate an IP address from the
        telecommunication carrier to the instance or network interface.

        You cannot associate an Elastic IP address with an interface in a
        different network border group.

        This is an idempotent operation. If you perform the operation more than
        once, Amazon EC2 doesn't return an error, and you may be charged for
        each time the Elastic IP address is remapped to the same instance. For
        more information, see the *Elastic IP Addresses* section of `Amazon EC2
        Pricing <http://aws.amazon.com/ec2/pricing/>`__.

        :param allocation_id: [EC2-VPC] The allocation ID.
        :param instance_id: The ID of the instance.
        :param public_ip: [EC2-Classic] The Elastic IP address to associate with the instance.
        :param allow_reassociation: [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an
        Elastic IP address that is already associated with an instance or
        network interface to be reassociated with the specified instance or
        network interface.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param network_interface_id: [EC2-VPC] The ID of the network interface.
        :param private_ip_address: [EC2-VPC] The primary or secondary private IP address to associate with
        the Elastic IP address.
        :returns: AssociateAddressResult
        """
        raise NotImplementedError

    @handler("AssociateClientVpnTargetNetwork")
    def associate_client_vpn_target_network(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        subnet_id: SubnetId,
        client_token: String = None,
        dry_run: Boolean = None,
    ) -> AssociateClientVpnTargetNetworkResult:
        """Associates a target network with a Client VPN endpoint. A target network
        is a subnet in a VPC. You can associate multiple subnets from the same
        VPC with a Client VPN endpoint. You can associate only one subnet in
        each Availability Zone. We recommend that you associate at least two
        subnets to provide Availability Zone redundancy.

        If you specified a VPC when you created the Client VPN endpoint or if
        you have previous subnet associations, the specified subnet must be in
        the same VPC. To specify a subnet that's in a different VPC, you must
        first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and
        change the VPC that's associated with it.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint.
        :param subnet_id: The ID of the subnet to associate with the Client VPN endpoint.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AssociateClientVpnTargetNetworkResult
        """
        raise NotImplementedError

    @handler("AssociateDhcpOptions")
    def associate_dhcp_options(
        self,
        context: RequestContext,
        dhcp_options_id: DefaultingDhcpOptionsId,
        vpc_id: VpcId,
        dry_run: Boolean = None,
    ) -> None:
        """Associates a set of DHCP options (that you've previously created) with
        the specified VPC, or associates no DHCP options with the VPC.

        After you associate the options with the VPC, any existing instances and
        all new instances that you launch in that VPC use the options. You don't
        need to restart or relaunch the instances. They automatically pick up
        the changes within a few hours, depending on how frequently the instance
        renews its DHCP lease. You can explicitly renew the lease using the
        operating system on the instance.

        For more information, see `DHCP options
        sets <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param dhcp_options_id: The ID of the DHCP options set, or ``default`` to associate no DHCP
        options with the VPC.
        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("AssociateEnclaveCertificateIamRole")
    def associate_enclave_certificate_iam_role(
        self,
        context: RequestContext,
        certificate_arn: ResourceArn = None,
        role_arn: ResourceArn = None,
        dry_run: Boolean = None,
    ) -> AssociateEnclaveCertificateIamRoleResult:
        """Associates an Identity and Access Management (IAM) role with an
        Certificate Manager (ACM) certificate. This enables the certificate to
        be used by the ACM for Nitro Enclaves application inside an enclave. For
        more information, see `Certificate Manager for Nitro
        Enclaves <https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html>`__
        in the *Amazon Web Services Nitro Enclaves User Guide*.

        When the IAM role is associated with the ACM certificate, the
        certificate, certificate chain, and encrypted private key are placed in
        an Amazon S3 bucket that only the associated IAM role can access. The
        private key of the certificate is encrypted with an Amazon Web Services
        managed key that has an attached attestation-based key policy.

        To enable the IAM role to access the Amazon S3 object, you must grant it
        permission to call ``s3:GetObject`` on the Amazon S3 bucket returned by
        the command. To enable the IAM role to access the KMS key, you must
        grant it permission to call ``kms:Decrypt`` on the KMS key returned by
        the command. For more information, see `Grant the role permission to
        access the certificate and encryption
        key <https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy>`__
        in the *Amazon Web Services Nitro Enclaves User Guide*.

        :param certificate_arn: The ARN of the ACM certificate with which to associate the IAM role.
        :param role_arn: The ARN of the IAM role to associate with the ACM certificate.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AssociateEnclaveCertificateIamRoleResult
        """
        raise NotImplementedError

    @handler("AssociateIamInstanceProfile")
    def associate_iam_instance_profile(
        self,
        context: RequestContext,
        iam_instance_profile: IamInstanceProfileSpecification,
        instance_id: InstanceId,
    ) -> AssociateIamInstanceProfileResult:
        """Associates an IAM instance profile with a running or stopped instance.
        You cannot associate more than one IAM instance profile with an
        instance.

        :param iam_instance_profile: The IAM instance profile.
        :param instance_id: The ID of the instance.
        :returns: AssociateIamInstanceProfileResult
        """
        raise NotImplementedError

    @handler("AssociateInstanceEventWindow")
    def associate_instance_event_window(
        self,
        context: RequestContext,
        instance_event_window_id: InstanceEventWindowId,
        association_target: InstanceEventWindowAssociationRequest,
        dry_run: Boolean = None,
    ) -> AssociateInstanceEventWindowResult:
        """Associates one or more targets with an event window. Only one type of
        target (instance IDs, Dedicated Host IDs, or tags) can be specified with
        an event window.

        For more information, see `Define event windows for scheduled
        events <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html>`__
        in the *Amazon EC2 User Guide*.

        :param instance_event_window_id: The ID of the event window.
        :param association_target: One or more targets associated with the specified event window.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AssociateInstanceEventWindowResult
        """
        raise NotImplementedError

    @handler("AssociateRouteTable")
    def associate_route_table(
        self,
        context: RequestContext,
        route_table_id: RouteTableId,
        dry_run: Boolean = None,
        subnet_id: SubnetId = None,
        gateway_id: RouteGatewayId = None,
    ) -> AssociateRouteTableResult:
        """Associates a subnet in your VPC or an internet gateway or virtual
        private gateway attached to your VPC with a route table in your VPC.
        This association causes traffic from the subnet or gateway to be routed
        according to the routes in the route table. The action returns an
        association ID, which you need in order to disassociate the route table
        later. A route table can be associated with multiple subnets.

        For more information, see `Route
        tables <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param route_table_id: The ID of the route table.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param subnet_id: The ID of the subnet.
        :param gateway_id: The ID of the internet gateway or virtual private gateway.
        :returns: AssociateRouteTableResult
        """
        raise NotImplementedError

    @handler("AssociateSubnetCidrBlock")
    def associate_subnet_cidr_block(
        self, context: RequestContext, ipv6_cidr_block: String, subnet_id: SubnetId
    ) -> AssociateSubnetCidrBlockResult:
        """Associates a CIDR block with your subnet. You can only associate a
        single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a
        prefix length of /64.

        :param ipv6_cidr_block: The IPv6 CIDR block for your subnet.
        :param subnet_id: The ID of your subnet.
        :returns: AssociateSubnetCidrBlockResult
        """
        raise NotImplementedError

    @handler("AssociateTransitGatewayMulticastDomain")
    def associate_transit_gateway_multicast_domain(
        self,
        context: RequestContext,
        transit_gateway_multicast_domain_id: TransitGatewayMulticastDomainId = None,
        transit_gateway_attachment_id: TransitGatewayAttachmentId = None,
        subnet_ids: TransitGatewaySubnetIdList = None,
        dry_run: Boolean = None,
    ) -> AssociateTransitGatewayMulticastDomainResult:
        """Associates the specified subnets and transit gateway attachments with
        the specified transit gateway multicast domain.

        The transit gateway attachment must be in the available state before you
        can add a resource. Use
        `DescribeTransitGatewayAttachments <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html>`__
        to see the state of the attachment.

        :param transit_gateway_multicast_domain_id: The ID of the transit gateway multicast domain.
        :param transit_gateway_attachment_id: The ID of the transit gateway attachment to associate with the transit
        gateway multicast domain.
        :param subnet_ids: The IDs of the subnets to associate with the transit gateway multicast
        domain.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AssociateTransitGatewayMulticastDomainResult
        """
        raise NotImplementedError

    @handler("AssociateTransitGatewayRouteTable")
    def associate_transit_gateway_route_table(
        self,
        context: RequestContext,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        dry_run: Boolean = None,
    ) -> AssociateTransitGatewayRouteTableResult:
        """Associates the specified attachment with the specified transit gateway
        route table. You can associate only one route table with an attachment.

        :param transit_gateway_route_table_id: The ID of the transit gateway route table.
        :param transit_gateway_attachment_id: The ID of the attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AssociateTransitGatewayRouteTableResult
        """
        raise NotImplementedError

    @handler("AssociateTrunkInterface")
    def associate_trunk_interface(
        self,
        context: RequestContext,
        branch_interface_id: NetworkInterfaceId,
        trunk_interface_id: NetworkInterfaceId,
        vlan_id: Integer = None,
        gre_key: Integer = None,
        client_token: String = None,
        dry_run: Boolean = None,
    ) -> AssociateTrunkInterfaceResult:
        """This API action is currently in **limited preview only**. If you are
        interested in using this feature, contact your account manager.

        Associates a branch network interface with a trunk network interface.

        Before you create the association, run the
        `create-network-interface <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html>`__
        command and set ``--interface-type`` to ``trunk``. You must also create
        a network interface for each branch network interface that you want to
        associate with the trunk network interface.

        :param branch_interface_id: The ID of the branch network interface.
        :param trunk_interface_id: The ID of the trunk network interface.
        :param vlan_id: The ID of the VLAN.
        :param gre_key: The application key.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AssociateTrunkInterfaceResult
        """
        raise NotImplementedError

    @handler("AssociateVpcCidrBlock")
    def associate_vpc_cidr_block(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        amazon_provided_ipv6_cidr_block: Boolean = None,
        cidr_block: String = None,
        ipv6_cidr_block_network_border_group: String = None,
        ipv6_pool: Ipv6PoolEc2Id = None,
        ipv6_cidr_block: String = None,
        ipv4_ipam_pool_id: IpamPoolId = None,
        ipv4_netmask_length: NetmaskLength = None,
        ipv6_ipam_pool_id: IpamPoolId = None,
        ipv6_netmask_length: NetmaskLength = None,
    ) -> AssociateVpcCidrBlockResult:
        """Associates a CIDR block with your VPC. You can associate a secondary
        IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR
        block from an IPv6 address pool that you provisioned through bring your
        own IP addresses
        (`BYOIP <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html>`__).
        The IPv6 CIDR block size is fixed at /56.

        You must specify one of the following in the request: an IPv4 CIDR
        block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block.

        For more information about associating CIDR blocks with your VPC and
        applicable restrictions, see `VPC and subnet
        sizing <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param vpc_id: The ID of the VPC.
        :param amazon_provided_ipv6_cidr_block: Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
        the VPC.
        :param cidr_block: An IPv4 CIDR block to associate with the VPC.
        :param ipv6_cidr_block_network_border_group: The name of the location from which we advertise the IPV6 CIDR block.
        :param ipv6_pool: The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
        block.
        :param ipv6_cidr_block: An IPv6 CIDR block from the IPv6 address pool.
        :param ipv4_ipam_pool_id: Associate a CIDR allocated from an IPv4 IPAM pool to a VPC.
        :param ipv4_netmask_length: The netmask length of the IPv4 CIDR you would like to associate from an
        Amazon VPC IP Address Manager (IPAM) pool.
        :param ipv6_ipam_pool_id: Associates a CIDR allocated from an IPv6 IPAM pool to a VPC.
        :param ipv6_netmask_length: The netmask length of the IPv6 CIDR you would like to associate from an
        Amazon VPC IP Address Manager (IPAM) pool.
        :returns: AssociateVpcCidrBlockResult
        """
        raise NotImplementedError

    @handler("AttachClassicLinkVpc")
    def attach_classic_link_vpc(
        self,
        context: RequestContext,
        groups: GroupIdStringList,
        instance_id: InstanceId,
        vpc_id: VpcId,
        dry_run: Boolean = None,
    ) -> AttachClassicLinkVpcResult:
        """Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
        or more of the VPC's security groups. You cannot link an EC2-Classic
        instance to more than one VPC at a time. You can only link an instance
        that's in the ``running`` state. An instance is automatically unlinked
        from a VPC when it's stopped - you can link it to the VPC again when you
        restart it.

        After you've linked an instance, you cannot change the VPC security
        groups that are associated with it. To change the security groups, you
        must first unlink the instance, and then link it again.

        Linking your instance to a VPC is sometimes referred to as *attaching*
        your instance.

        :param groups: The ID of one or more of the VPC's security groups.
        :param instance_id: The ID of an EC2-Classic instance to link to the ClassicLink-enabled
        VPC.
        :param vpc_id: The ID of a ClassicLink-enabled VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AttachClassicLinkVpcResult
        """
        raise NotImplementedError

    @handler("AttachInternetGateway")
    def attach_internet_gateway(
        self,
        context: RequestContext,
        internet_gateway_id: InternetGatewayId,
        vpc_id: VpcId,
        dry_run: Boolean = None,
    ) -> None:
        """Attaches an internet gateway or a virtual private gateway to a VPC,
        enabling connectivity between the internet and the VPC. For more
        information about your VPC and internet gateway, see the `Amazon Virtual
        Private Cloud User
        Guide <https://docs.aws.amazon.com/vpc/latest/userguide/>`__.

        :param internet_gateway_id: The ID of the internet gateway.
        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("AttachNetworkInterface")
    def attach_network_interface(
        self,
        context: RequestContext,
        device_index: Integer,
        instance_id: InstanceId,
        network_interface_id: NetworkInterfaceId,
        dry_run: Boolean = None,
        network_card_index: Integer = None,
    ) -> AttachNetworkInterfaceResult:
        """Attaches a network interface to an instance.

        :param device_index: The index of the device for the network interface attachment.
        :param instance_id: The ID of the instance.
        :param network_interface_id: The ID of the network interface.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param network_card_index: The index of the network card.
        :returns: AttachNetworkInterfaceResult
        """
        raise NotImplementedError

    @handler("AttachVolume")
    def attach_volume(
        self,
        context: RequestContext,
        device: String,
        instance_id: InstanceId,
        volume_id: VolumeId,
        dry_run: Boolean = None,
    ) -> VolumeAttachment:
        """Attaches an EBS volume to a running or stopped instance and exposes it
        to the instance with the specified device name.

        Encrypted EBS volumes must be attached to instances that support Amazon
        EBS encryption. For more information, see `Amazon EBS
        encryption <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        After you attach an EBS volume, you must make it available. For more
        information, see `Make an EBS volume available for
        use <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html>`__.

        If a volume has an Amazon Web Services Marketplace product code:

        -  The volume can be attached only to a stopped instance.

        -  Amazon Web Services Marketplace product codes are copied from the
           volume to the instance.

        -  You must be subscribed to the product.

        -  The instance type and operating system of the instance must support
           the product. For example, you can't detach a volume from a Windows
           instance and attach it to a Linux instance.

        For more information, see `Attach an Amazon EBS volume to an
        instance <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param device: The device name (for example, ``/dev/sdh`` or ``xvdh``).
        :param instance_id: The ID of the instance.
        :param volume_id: The ID of the EBS volume.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: VolumeAttachment
        """
        raise NotImplementedError

    @handler("AttachVpnGateway")
    def attach_vpn_gateway(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        vpn_gateway_id: VpnGatewayId,
        dry_run: Boolean = None,
    ) -> AttachVpnGatewayResult:
        """Attaches a virtual private gateway to a VPC. You can attach one virtual
        private gateway to one VPC at a time.

        For more information, see `Amazon Web Services Site-to-Site
        VPN <https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html>`__ in
        the *Amazon Web Services Site-to-Site VPN User Guide*.

        :param vpc_id: The ID of the VPC.
        :param vpn_gateway_id: The ID of the virtual private gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AttachVpnGatewayResult
        """
        raise NotImplementedError

    @handler("AuthorizeClientVpnIngress")
    def authorize_client_vpn_ingress(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        target_network_cidr: String,
        access_group_id: String = None,
        authorize_all_groups: Boolean = None,
        description: String = None,
        client_token: String = None,
        dry_run: Boolean = None,
    ) -> AuthorizeClientVpnIngressResult:
        """Adds an ingress authorization rule to a Client VPN endpoint. Ingress
        authorization rules act as firewall rules that grant access to networks.
        You must configure ingress authorization rules to enable clients to
        access resources in Amazon Web Services or on-premises networks.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint.
        :param target_network_cidr: The IPv4 address range, in CIDR notation, of the network for which
        access is being authorized.
        :param access_group_id: The ID of the group to grant access to, for example, the Active
        Directory group or identity provider (IdP) group.
        :param authorize_all_groups: Indicates whether to grant access to all clients.
        :param description: A brief description of the authorization rule.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: AuthorizeClientVpnIngressResult
        """
        raise NotImplementedError

    @handler("AuthorizeSecurityGroupEgress")
    def authorize_security_group_egress(
        self,
        context: RequestContext,
        group_id: SecurityGroupId,
        dry_run: Boolean = None,
        ip_permissions: IpPermissionList = None,
        tag_specifications: TagSpecificationList = None,
        cidr_ip: String = None,
        from_port: Integer = None,
        ip_protocol: String = None,
        to_port: Integer = None,
        source_security_group_name: String = None,
        source_security_group_owner_id: String = None,
    ) -> AuthorizeSecurityGroupEgressResult:
        """[VPC only] Adds the specified outbound (egress) rules to a security
        group for use with a VPC.

        An outbound rule permits instances to send traffic to the specified IPv4
        or IPv6 CIDR address ranges, or to the instances that are associated
        with the specified source security groups.

        You specify a protocol for each rule (for example, TCP). For the TCP and
        UDP protocols, you must also specify the destination port or port range.
        For the ICMP protocol, you must also specify the ICMP type and code. You
        can use -1 for the type or code to mean all types or all codes.

        Rule changes are propagated to affected instances as quickly as
        possible. However, a small delay might occur.

        For information about VPC security group quotas, see `Amazon VPC
        quotas <https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html>`__.

        :param group_id: The ID of the security group.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param ip_permissions: The sets of IP permissions.
        :param tag_specifications: The tags applied to the security group rule.
        :param cidr_ip: Not supported.
        :param from_port: Not supported.
        :param ip_protocol: Not supported.
        :param to_port: Not supported.
        :param source_security_group_name: Not supported.
        :param source_security_group_owner_id: Not supported.
        :returns: AuthorizeSecurityGroupEgressResult
        """
        raise NotImplementedError

    @handler("AuthorizeSecurityGroupIngress")
    def authorize_security_group_ingress(
        self,
        context: RequestContext,
        cidr_ip: String = None,
        from_port: Integer = None,
        group_id: SecurityGroupId = None,
        group_name: SecurityGroupName = None,
        ip_permissions: IpPermissionList = None,
        ip_protocol: String = None,
        source_security_group_name: String = None,
        source_security_group_owner_id: String = None,
        to_port: Integer = None,
        dry_run: Boolean = None,
        tag_specifications: TagSpecificationList = None,
    ) -> AuthorizeSecurityGroupIngressResult:
        """Adds the specified inbound (ingress) rules to a security group.

        An inbound rule permits instances to receive traffic from the specified
        IPv4 or IPv6 CIDR address range, or from the instances that are
        associated with the specified destination security groups.

        You specify a protocol for each rule (for example, TCP). For TCP and
        UDP, you must also specify the destination port or port range. For
        ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You
        can use -1 to mean all types or all codes.

        Rule changes are propagated to instances within the security group as
        quickly as possible. However, a small delay might occur.

        For more information about VPC security group quotas, see `Amazon VPC
        quotas <https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html>`__.

        :param cidr_ip: The IPv4 address range, in CIDR format.
        :param from_port: The start of port range for the TCP and UDP protocols, or an ICMP type
        number.
        :param group_id: The ID of the security group.
        :param group_name: [EC2-Classic, default VPC] The name of the security group.
        :param ip_permissions: The sets of IP permissions.
        :param ip_protocol: The IP protocol name (``tcp``, ``udp``, ``icmp``) or number (see
        `Protocol
        Numbers <http://www.
        :param source_security_group_name: [EC2-Classic, default VPC] The name of the source security group.
        :param source_security_group_owner_id: [nondefault VPC] The Amazon Web Services account ID for the source
        security group, if the source security group is in a different account.
        :param to_port: The end of port range for the TCP and UDP protocols, or an ICMP code
        number.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param tag_specifications: [VPC Only] The tags applied to the security group rule.
        :returns: AuthorizeSecurityGroupIngressResult
        """
        raise NotImplementedError

    @handler("BundleInstance")
    def bundle_instance(
        self,
        context: RequestContext,
        instance_id: InstanceId,
        storage: Storage,
        dry_run: Boolean = None,
    ) -> BundleInstanceResult:
        """Bundles an Amazon instance store-backed Windows instance.

        During bundling, only the root device volume (C:) is bundled. Data on
        other instance store volumes is not preserved.

        This action is not applicable for Linux/Unix instances or Windows
        instances that are backed by Amazon EBS.

        :param instance_id: The ID of the instance to bundle.
        :param storage: The bucket in which to store the AMI.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: BundleInstanceResult
        """
        raise NotImplementedError

    @handler("CancelBundleTask")
    def cancel_bundle_task(
        self, context: RequestContext, bundle_id: BundleId, dry_run: Boolean = None
    ) -> CancelBundleTaskResult:
        """Cancels a bundling operation for an instance store-backed Windows
        instance.

        :param bundle_id: The ID of the bundle task.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CancelBundleTaskResult
        """
        raise NotImplementedError

    @handler("CancelCapacityReservation")
    def cancel_capacity_reservation(
        self,
        context: RequestContext,
        capacity_reservation_id: CapacityReservationId,
        dry_run: Boolean = None,
    ) -> CancelCapacityReservationResult:
        """Cancels the specified Capacity Reservation, releases the reserved
        capacity, and changes the Capacity Reservation's state to ``cancelled``.

        Instances running in the reserved capacity continue running until you
        stop them. Stopped instances that target the Capacity Reservation can no
        longer launch. Modify these instances to either target a different
        Capacity Reservation, launch On-Demand Instance capacity, or run in any
        open Capacity Reservation that has matching attributes and sufficient
        capacity.

        :param capacity_reservation_id: The ID of the Capacity Reservation to be cancelled.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CancelCapacityReservationResult
        """
        raise NotImplementedError

    @handler("CancelCapacityReservationFleets")
    def cancel_capacity_reservation_fleets(
        self,
        context: RequestContext,
        capacity_reservation_fleet_ids: CapacityReservationFleetIdSet,
        dry_run: Boolean = None,
    ) -> CancelCapacityReservationFleetsResult:
        """Cancels one or more Capacity Reservation Fleets. When you cancel a
        Capacity Reservation Fleet, the following happens:

        -  The Capacity Reservation Fleet's status changes to ``cancelled``.

        -  The individual Capacity Reservations in the Fleet are cancelled.
           Instances running in the Capacity Reservations at the time of
           cancelling the Fleet continue to run in shared capacity.

        -  The Fleet stops creating new Capacity Reservations.

        :param capacity_reservation_fleet_ids: The IDs of the Capacity Reservation Fleets to cancel.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CancelCapacityReservationFleetsResult
        """
        raise NotImplementedError

    @handler("CancelConversionTask")
    def cancel_conversion_task(
        self,
        context: RequestContext,
        conversion_task_id: ConversionTaskId,
        dry_run: Boolean = None,
        reason_message: String = None,
    ) -> None:
        """Cancels an active conversion task. The task can be the import of an
        instance or volume. The action removes all artifacts of the conversion,
        including a partially uploaded volume or instance. If the conversion is
        complete or is in the process of transferring the final disk image, the
        command fails and returns an exception.

        For more information, see `Importing a Virtual Machine Using the Amazon
        EC2
        CLI <https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html>`__.

        :param conversion_task_id: The ID of the conversion task.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param reason_message: The reason for canceling the conversion task.
        """
        raise NotImplementedError

    @handler("CancelExportTask")
    def cancel_export_task(self, context: RequestContext, export_task_id: ExportVmTaskId) -> None:
        """Cancels an active export task. The request removes all artifacts of the
        export, including any partially-created Amazon S3 objects. If the export
        task is complete or is in the process of transferring the final disk
        image, the command fails and returns an error.

        :param export_task_id: The ID of the export task.
        """
        raise NotImplementedError

    @handler("CancelImportTask")
    def cancel_import_task(
        self,
        context: RequestContext,
        cancel_reason: String = None,
        dry_run: Boolean = None,
        import_task_id: ImportTaskId = None,
    ) -> CancelImportTaskResult:
        """Cancels an in-process import virtual machine or import snapshot task.

        :param cancel_reason: The reason for canceling the task.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param import_task_id: The ID of the import image or import snapshot task to be canceled.
        :returns: CancelImportTaskResult
        """
        raise NotImplementedError

    @handler("CancelReservedInstancesListing")
    def cancel_reserved_instances_listing(
        self, context: RequestContext, reserved_instances_listing_id: ReservedInstancesListingId
    ) -> CancelReservedInstancesListingResult:
        """Cancels the specified Reserved Instance listing in the Reserved Instance
        Marketplace.

        For more information, see `Reserved Instance
        Marketplace <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html>`__
        in the *Amazon EC2 User Guide*.

        :param reserved_instances_listing_id: The ID of the Reserved Instance listing.
        :returns: CancelReservedInstancesListingResult
        """
        raise NotImplementedError

    @handler("CancelSpotFleetRequests")
    def cancel_spot_fleet_requests(
        self,
        context: RequestContext,
        spot_fleet_request_ids: SpotFleetRequestIdList,
        terminate_instances: Boolean,
        dry_run: Boolean = None,
    ) -> CancelSpotFleetRequestsResponse:
        """Cancels the specified Spot Fleet requests.

        After you cancel a Spot Fleet request, the Spot Fleet launches no new
        Spot Instances. You must specify whether the Spot Fleet should also
        terminate its Spot Instances. If you terminate the instances, the Spot
        Fleet request enters the ``cancelled_terminating`` state. Otherwise, the
        Spot Fleet request enters the ``cancelled_running`` state and the
        instances continue to run until they are interrupted or you terminate
        them manually.

        :param spot_fleet_request_ids: The IDs of the Spot Fleet requests.
        :param terminate_instances: Indicates whether to terminate instances for a Spot Fleet request if it
        is canceled successfully.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CancelSpotFleetRequestsResponse
        """
        raise NotImplementedError

    @handler("CancelSpotInstanceRequests")
    def cancel_spot_instance_requests(
        self,
        context: RequestContext,
        spot_instance_request_ids: SpotInstanceRequestIdList,
        dry_run: Boolean = None,
    ) -> CancelSpotInstanceRequestsResult:
        """Cancels one or more Spot Instance requests.

        Canceling a Spot Instance request does not terminate running Spot
        Instances associated with the request.

        :param spot_instance_request_ids: One or more Spot Instance request IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CancelSpotInstanceRequestsResult
        """
        raise NotImplementedError

    @handler("ConfirmProductInstance")
    def confirm_product_instance(
        self,
        context: RequestContext,
        instance_id: InstanceId,
        product_code: String,
        dry_run: Boolean = None,
    ) -> ConfirmProductInstanceResult:
        """Determines whether a product code is associated with an instance. This
        action can only be used by the owner of the product code. It is useful
        when a product code owner must verify whether another user's instance is
        eligible for support.

        :param instance_id: The ID of the instance.
        :param product_code: The product code.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: ConfirmProductInstanceResult
        """
        raise NotImplementedError

    @handler("CopyFpgaImage")
    def copy_fpga_image(
        self,
        context: RequestContext,
        source_fpga_image_id: String,
        source_region: String,
        dry_run: Boolean = None,
        description: String = None,
        name: String = None,
        client_token: String = None,
    ) -> CopyFpgaImageResult:
        """Copies the specified Amazon FPGA Image (AFI) to the current Region.

        :param source_fpga_image_id: The ID of the source AFI.
        :param source_region: The Region that contains the source AFI.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param description: The description for the new AFI.
        :param name: The name for the new AFI.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CopyFpgaImageResult
        """
        raise NotImplementedError

    @handler("CopyImage")
    def copy_image(
        self,
        context: RequestContext,
        name: String,
        source_image_id: String,
        source_region: String,
        client_token: String = None,
        description: String = None,
        encrypted: Boolean = None,
        kms_key_id: KmsKeyId = None,
        destination_outpost_arn: String = None,
        dry_run: Boolean = None,
    ) -> CopyImageResult:
        """Initiates the copy of an AMI. You can copy an AMI from one Region to
        another, or from a Region to an Outpost. You can't copy an AMI from an
        Outpost to a Region, from one Outpost to another, or within the same
        Outpost. To copy an AMI to another partition, see
        `CreateStoreImageTask <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html>`__.

        To copy an AMI from one Region to another, specify the source Region
        using the **SourceRegion** parameter, and specify the destination Region
        using its endpoint. Copies of encrypted backing snapshots for the AMI
        are encrypted. Copies of unencrypted backing snapshots remain
        unencrypted, unless you set ``Encrypted`` during the copy operation. You
        cannot create an unencrypted copy of an encrypted backing snapshot.

        To copy an AMI from a Region to an Outpost, specify the source Region
        using the **SourceRegion** parameter, and specify the ARN of the
        destination Outpost using **DestinationOutpostArn**. Backing snapshots
        copied to an Outpost are encrypted by default using the default
        encryption key for the Region, or a different key that you specify in
        the request using **KmsKeyId**. Outposts do not support unencrypted
        snapshots. For more information, `Amazon EBS local snapshots on
        Outposts <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        For more information about the prerequisites and limits when copying an
        AMI, see `Copying an
        AMI <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param name: The name of the new AMI in the destination Region.
        :param source_image_id: The ID of the AMI to copy.
        :param source_region: The name of the Region that contains the AMI to copy.
        :param client_token: Unique, case-sensitive identifier you provide to ensure idempotency of
        the request.
        :param description: A description for the new AMI in the destination Region.
        :param encrypted: Specifies whether the destination snapshots of the copied image should
        be encrypted.
        :param kms_key_id: The identifier of the symmetric Key Management Service (KMS) KMS key to
        use when creating encrypted volumes.
        :param destination_outpost_arn: The Amazon Resource Name (ARN) of the Outpost to which to copy the AMI.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CopyImageResult
        """
        raise NotImplementedError

    @handler("CopySnapshot")
    def copy_snapshot(
        self,
        context: RequestContext,
        source_region: String,
        source_snapshot_id: String,
        description: String = None,
        destination_outpost_arn: String = None,
        destination_region: String = None,
        encrypted: Boolean = None,
        kms_key_id: KmsKeyId = None,
        presigned_url: String = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CopySnapshotResult:
        """Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
        S3. You can copy a snapshot within the same Region, from one Region to
        another, or from a Region to an Outpost. You can't copy a snapshot from
        an Outpost to a Region, from one Outpost to another, or within the same
        Outpost.

        You can use the snapshot to create EBS volumes or Amazon Machine Images
        (AMIs).

        When copying snapshots to a Region, copies of encrypted EBS snapshots
        remain encrypted. Copies of unencrypted snapshots remain unencrypted,
        unless you enable encryption for the snapshot copy operation. By
        default, encrypted snapshot copies use the default Key Management
        Service (KMS) KMS key; however, you can specify a different KMS key. To
        copy an encrypted snapshot that has been shared from another account,
        you must have permissions for the KMS key used to encrypt the snapshot.

        Snapshots copied to an Outpost are encrypted by default using the
        default encryption key for the Region, or a different key that you
        specify in the request using **KmsKeyId**. Outposts do not support
        unencrypted snapshots. For more information, `Amazon EBS local snapshots
        on
        Outposts <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#ami>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        Snapshots created by copying another snapshot have an arbitrary volume
        ID that should not be used for any purpose.

        For more information, see `Copy an Amazon EBS
        snapshot <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param source_region: The ID of the Region that contains the snapshot to be copied.
        :param source_snapshot_id: The ID of the EBS snapshot to copy.
        :param description: A description for the EBS snapshot.
        :param destination_outpost_arn: The Amazon Resource Name (ARN) of the Outpost to which to copy the
        snapshot.
        :param destination_region: The destination Region to use in the ``PresignedUrl`` parameter of a
        snapshot copy operation.
        :param encrypted: To encrypt a copy of an unencrypted snapshot if encryption by default is
        not enabled, enable encryption using this parameter.
        :param kms_key_id: The identifier of the Key Management Service (KMS) KMS key to use for
        Amazon EBS encryption.
        :param presigned_url: When you copy an encrypted source snapshot using the Amazon EC2 Query
        API, you must supply a pre-signed URL.
        :param tag_specifications: The tags to apply to the new snapshot.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CopySnapshotResult
        """
        raise NotImplementedError

    @handler("CreateCapacityReservation")
    def create_capacity_reservation(
        self,
        context: RequestContext,
        instance_type: String,
        instance_platform: CapacityReservationInstancePlatform,
        instance_count: Integer,
        client_token: String = None,
        availability_zone: String = None,
        availability_zone_id: String = None,
        tenancy: CapacityReservationTenancy = None,
        ebs_optimized: Boolean = None,
        ephemeral_storage: Boolean = None,
        end_date: DateTime = None,
        end_date_type: EndDateType = None,
        instance_match_criteria: InstanceMatchCriteria = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
        outpost_arn: OutpostArn = None,
        placement_group_arn: PlacementGroupArn = None,
    ) -> CreateCapacityReservationResult:
        """Creates a new Capacity Reservation with the specified attributes.

        Capacity Reservations enable you to reserve capacity for your Amazon EC2
        instances in a specific Availability Zone for any duration. This gives
        you the flexibility to selectively add capacity reservations and still
        get the Regional RI discounts for that usage. By creating Capacity
        Reservations, you ensure that you always have access to Amazon EC2
        capacity when you need it, for as long as you need it. For more
        information, see `Capacity
        Reservations <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html>`__
        in the *Amazon EC2 User Guide*.

        Your request to create a Capacity Reservation could fail if Amazon EC2
        does not have sufficient capacity to fulfill the request. If your
        request fails due to Amazon EC2 capacity constraints, either try again
        at a later time, try in a different Availability Zone, or request a
        smaller capacity reservation. If your application is flexible across
        instance types and sizes, try to create a Capacity Reservation with
        different instance attributes.

        Your request could also fail if the requested quantity exceeds your
        On-Demand Instance limit for the selected instance type. If your request
        fails due to limit constraints, increase your On-Demand Instance limit
        for the required instance type and try again. For more information about
        increasing your instance limits, see `Amazon EC2 Service
        Quotas <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html>`__
        in the *Amazon EC2 User Guide*.

        :param instance_type: The instance type for which to reserve capacity.
        :param instance_platform: The type of operating system for which to reserve capacity.
        :param instance_count: The number of instances for which to reserve capacity.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param availability_zone: The Availability Zone in which to create the Capacity Reservation.
        :param availability_zone_id: The ID of the Availability Zone in which to create the Capacity
        Reservation.
        :param tenancy: Indicates the tenancy of the Capacity Reservation.
        :param ebs_optimized: Indicates whether the Capacity Reservation supports EBS-optimized
        instances.
        :param ephemeral_storage: Indicates whether the Capacity Reservation supports instances with
        temporary, block-level storage.
        :param end_date: The date and time at which the Capacity Reservation expires.
        :param end_date_type: Indicates the way in which the Capacity Reservation ends.
        :param instance_match_criteria: Indicates the type of instance launches that the Capacity Reservation
        accepts.
        :param tag_specifications: The tags to apply to the Capacity Reservation during launch.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param outpost_arn: The Amazon Resource Name (ARN) of the Outpost on which to create the
        Capacity Reservation.
        :param placement_group_arn: The Amazon Resource Name (ARN) of the cluster placement group in which
        to create the Capacity Reservation.
        :returns: CreateCapacityReservationResult
        """
        raise NotImplementedError

    @handler("CreateCapacityReservationFleet")
    def create_capacity_reservation_fleet(
        self,
        context: RequestContext,
        instance_type_specifications: ReservationFleetInstanceSpecificationList,
        total_target_capacity: Integer,
        allocation_strategy: String = None,
        client_token: String = None,
        tenancy: FleetCapacityReservationTenancy = None,
        end_date: MillisecondDateTime = None,
        instance_match_criteria: FleetInstanceMatchCriteria = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateCapacityReservationFleetResult:
        """Creates a Capacity Reservation Fleet. For more information, see `Create
        a Capacity Reservation
        Fleet <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet>`__
        in the Amazon EC2 User Guide.

        :param instance_type_specifications: Information about the instance types for which to reserve the capacity.
        :param total_target_capacity: The total number of capacity units to be reserved by the Capacity
        Reservation Fleet.
        :param allocation_strategy: The strategy used by the Capacity Reservation Fleet to determine which
        of the specified instance types to use.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param tenancy: Indicates the tenancy of the Capacity Reservation Fleet.
        :param end_date: The date and time at which the Capacity Reservation Fleet expires.
        :param instance_match_criteria: Indicates the type of instance launches that the Capacity Reservation
        Fleet accepts.
        :param tag_specifications: The tags to assign to the Capacity Reservation Fleet.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateCapacityReservationFleetResult
        """
        raise NotImplementedError

    @handler("CreateCarrierGateway")
    def create_carrier_gateway(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
        client_token: String = None,
    ) -> CreateCarrierGatewayResult:
        """Creates a carrier gateway. For more information about carrier gateways,
        see `Carrier
        gateways <https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway>`__
        in the *Amazon Web Services Wavelength Developer Guide*.

        :param vpc_id: The ID of the VPC to associate with the carrier gateway.
        :param tag_specifications: The tags to associate with the carrier gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CreateCarrierGatewayResult
        """
        raise NotImplementedError

    @handler("CreateClientVpnEndpoint")
    def create_client_vpn_endpoint(
        self,
        context: RequestContext,
        client_cidr_block: String,
        server_certificate_arn: String,
        authentication_options: ClientVpnAuthenticationRequestList,
        connection_log_options: ConnectionLogOptions,
        dns_servers: ValueStringList = None,
        transport_protocol: TransportProtocol = None,
        vpn_port: Integer = None,
        description: String = None,
        split_tunnel: Boolean = None,
        dry_run: Boolean = None,
        client_token: String = None,
        tag_specifications: TagSpecificationList = None,
        security_group_ids: ClientVpnSecurityGroupIdSet = None,
        vpc_id: VpcId = None,
        self_service_portal: SelfServicePortal = None,
        client_connect_options: ClientConnectOptions = None,
        session_timeout_hours: Integer = None,
        client_login_banner_options: ClientLoginBannerOptions = None,
    ) -> CreateClientVpnEndpointResult:
        """Creates a Client VPN endpoint. A Client VPN endpoint is the resource you
        create and configure to enable and manage client VPN sessions. It is the
        destination endpoint at which all client VPN sessions are terminated.

        :param client_cidr_block: The IPv4 address range, in CIDR notation, from which to assign client IP
        addresses.
        :param server_certificate_arn: The ARN of the server certificate.
        :param authentication_options: Information about the authentication method to be used to authenticate
        clients.
        :param connection_log_options: Information about the client connection logging options.
        :param dns_servers: Information about the DNS servers to be used for DNS resolution.
        :param transport_protocol: The transport protocol to be used by the VPN session.
        :param vpn_port: The port number to assign to the Client VPN endpoint for TCP and UDP
        traffic.
        :param description: A brief description of the Client VPN endpoint.
        :param split_tunnel: Indicates whether split-tunnel is enabled on the Client VPN endpoint.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param tag_specifications: The tags to apply to the Client VPN endpoint during creation.
        :param security_group_ids: The IDs of one or more security groups to apply to the target network.
        :param vpc_id: The ID of the VPC to associate with the Client VPN endpoint.
        :param self_service_portal: Specify whether to enable the self-service portal for the Client VPN
        endpoint.
        :param client_connect_options: The options for managing connection authorization for new client
        connections.
        :param session_timeout_hours: .
        :param client_login_banner_options: .
        :returns: CreateClientVpnEndpointResult
        """
        raise NotImplementedError

    @handler("CreateClientVpnRoute")
    def create_client_vpn_route(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        destination_cidr_block: String,
        target_vpc_subnet_id: SubnetId,
        description: String = None,
        client_token: String = None,
        dry_run: Boolean = None,
    ) -> CreateClientVpnRouteResult:
        """Adds a route to a network to a Client VPN endpoint. Each Client VPN
        endpoint has a route table that describes the available destination
        network routes. Each route in the route table specifies the path for
        traﬃc to speciﬁc resources or networks.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint to which to add the route.
        :param destination_cidr_block: The IPv4 address range, in CIDR notation, of the route destination.
        :param target_vpc_subnet_id: The ID of the subnet through which you want to route traffic.
        :param description: A brief description of the route.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateClientVpnRouteResult
        """
        raise NotImplementedError

    @handler("CreateCustomerGateway", expand=False)
    def create_customer_gateway(
        self, context: RequestContext, request: CreateCustomerGatewayRequest
    ) -> CreateCustomerGatewayResult:
        """Provides information to Amazon Web Services about your VPN customer
        gateway device. The customer gateway is the appliance at your end of the
        VPN connection. (The device on the Amazon Web Services side of the VPN
        connection is the virtual private gateway.) You must provide the
        internet-routable IP address of the customer gateway's external
        interface. The IP address must be static and can be behind a device
        performing network address translation (NAT).

        For devices that use Border Gateway Protocol (BGP), you can also provide
        the device's BGP Autonomous System Number (ASN). You can use an existing
        ASN assigned to your network. If you don't have an ASN already, you can
        use a private ASN (in the 64512 - 65534 range).

        Amazon EC2 supports all 4-byte ASN numbers in the range of 1 -
        2147483647, with the exception of the following:

        -  7224 - reserved in the ``us-east-1`` Region

        -  9059 - reserved in the ``eu-west-1`` Region

        -  17943 - reserved in the ``ap-southeast-1`` Region

        -  10124 - reserved in the ``ap-northeast-1`` Region

        For more information, see `Amazon Web Services Site-to-Site
        VPN <https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html>`__ in
        the *Amazon Web Services Site-to-Site VPN User Guide*.

        To create more than one customer gateway with the same VPN type, IP
        address, and BGP ASN, specify a unique device name for each customer
        gateway. Identical requests return information about the existing
        customer gateway and do not create new customer gateways.

        :param bgp_asn: For devices that support BGP, the customer gateway's BGP ASN.
        :param type: The type of VPN connection that this customer gateway supports
        (``ipsec.
        :param public_ip: The Internet-routable IP address for the customer gateway's outside
        interface.
        :param certificate_arn: The Amazon Resource Name (ARN) for the customer gateway certificate.
        :param tag_specifications: The tags to apply to the customer gateway.
        :param device_name: A name for the customer gateway device.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateCustomerGatewayResult
        """
        raise NotImplementedError

    @handler("CreateDefaultSubnet")
    def create_default_subnet(
        self,
        context: RequestContext,
        availability_zone: String,
        dry_run: Boolean = None,
        ipv6_native: Boolean = None,
    ) -> CreateDefaultSubnetResult:
        """Creates a default subnet with a size ``/20`` IPv4 CIDR block in the
        specified Availability Zone in your default VPC. You can have only one
        default subnet per Availability Zone. For more information, see
        `Creating a default
        subnet <https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param availability_zone: The Availability Zone in which to create the default subnet.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param ipv6_native: Indicates whether to create an IPv6 only subnet.
        :returns: CreateDefaultSubnetResult
        """
        raise NotImplementedError

    @handler("CreateDefaultVpc")
    def create_default_vpc(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> CreateDefaultVpcResult:
        """Creates a default VPC with a size ``/16`` IPv4 CIDR block and a default
        subnet in each Availability Zone. For more information about the
        components of a default VPC, see `Default VPC and default
        subnets <https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html>`__
        in the *Amazon Virtual Private Cloud User Guide*. You cannot specify the
        components of the default VPC yourself.

        If you deleted your previous default VPC, you can create a default VPC.
        You cannot have more than one default VPC per Region.

        If your account supports EC2-Classic, you cannot use this action to
        create a default VPC in a Region that supports EC2-Classic. If you want
        a default VPC in a Region that supports EC2-Classic, see "I really want
        a default VPC for my existing EC2 account. Is that possible?" in the
        `Default VPCs FAQ <http://aws.amazon.com/vpc/faqs/#Default_VPCs>`__.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateDefaultVpcResult
        """
        raise NotImplementedError

    @handler("CreateDhcpOptions")
    def create_dhcp_options(
        self,
        context: RequestContext,
        dhcp_configurations: NewDhcpConfigurationList,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateDhcpOptionsResult:
        """Creates a set of DHCP options for your VPC. After creating the set, you
        must associate it with the VPC, causing all existing and new instances
        that you launch in the VPC to use this set of DHCP options. The
        following are the individual DHCP options you can specify. For more
        information about the options, see `RFC
        2132 <http://www.ietf.org/rfc/rfc2132.txt>`__.

        -  ``domain-name-servers`` - The IP addresses of up to four domain name
           servers, or AmazonProvidedDNS. The default DHCP option set specifies
           AmazonProvidedDNS. If specifying more than one domain name server,
           specify the IP addresses in a single parameter, separated by commas.
           To have your instance receive a custom DNS hostname as specified in
           ``domain-name``, you must set ``domain-name-servers`` to a custom DNS
           server.

        -  ``domain-name`` - If you're using AmazonProvidedDNS in ``us-east-1``,
           specify ``ec2.internal``. If you're using AmazonProvidedDNS in
           another Region, specify ``region.compute.internal`` (for example,
           ``ap-northeast-1.compute.internal``). Otherwise, specify a domain
           name (for example, ``ExampleCompany.com``). This value is used to
           complete unqualified DNS hostnames. **Important**: Some Linux
           operating systems accept multiple domain names separated by spaces.
           However, Windows and other Linux operating systems treat the value as
           a single domain, which results in unexpected behavior. If your DHCP
           options set is associated with a VPC that has instances with multiple
           operating systems, specify only one domain name.

        -  ``ntp-servers`` - The IP addresses of up to four Network Time
           Protocol (NTP) servers.

        -  ``netbios-name-servers`` - The IP addresses of up to four NetBIOS
           name servers.

        -  ``netbios-node-type`` - The NetBIOS node type (1, 2, 4, or 8). We
           recommend that you specify 2 (broadcast and multicast are not
           currently supported). For more information about these node types,
           see `RFC 2132 <http://www.ietf.org/rfc/rfc2132.txt>`__.

        Your VPC automatically starts out with a set of DHCP options that
        includes only a DNS server that we provide (AmazonProvidedDNS). If you
        create a set of options, and if your VPC has an internet gateway, make
        sure to set the ``domain-name-servers`` option either to
        ``AmazonProvidedDNS`` or to a domain name server of your choice. For
        more information, see `DHCP options
        sets <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param dhcp_configurations: A DHCP configuration option.
        :param tag_specifications: The tags to assign to the DHCP option.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateDhcpOptionsResult
        """
        raise NotImplementedError

    @handler("CreateEgressOnlyInternetGateway")
    def create_egress_only_internet_gateway(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        client_token: String = None,
        dry_run: Boolean = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateEgressOnlyInternetGatewayResult:
        """[IPv6 only] Creates an egress-only internet gateway for your VPC. An
        egress-only internet gateway is used to enable outbound communication
        over IPv6 from instances in your VPC to the internet, and prevents hosts
        outside of your VPC from initiating an IPv6 connection with your
        instance.

        :param vpc_id: The ID of the VPC for which to create the egress-only internet gateway.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param tag_specifications: The tags to assign to the egress-only internet gateway.
        :returns: CreateEgressOnlyInternetGatewayResult
        """
        raise NotImplementedError

    @handler("CreateFleet", expand=False)
    def create_fleet(
        self, context: RequestContext, request: CreateFleetRequest
    ) -> CreateFleetResult:
        """Launches an EC2 Fleet.

        You can create a single EC2 Fleet that includes multiple launch
        specifications that vary by instance type, AMI, Availability Zone, or
        subnet.

        For more information, see `Launching an EC2
        Fleet <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html>`__
        in the *Amazon EC2 User Guide*.

        :param launch_template_configs: The configuration for the EC2 Fleet.
        :param target_capacity_specification: The number of units to request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param spot_options: Describes the configuration of Spot Instances in an EC2 Fleet.
        :param on_demand_options: Describes the configuration of On-Demand Instances in an EC2 Fleet.
        :param excess_capacity_termination_policy: Indicates whether running instances should be terminated if the total
        target capacity of the EC2 Fleet is decreased below the current size of
        the EC2 Fleet.
        :param terminate_instances_with_expiration: Indicates whether running instances should be terminated when the EC2
        Fleet expires.
        :param type: The fleet type.
        :param valid_from: The start date and time of the request, in UTC format (for example,
        *YYYY*-*MM*-*DD* T *HH*:*MM*:*SS* Z).
        :param valid_until: The end date and time of the request, in UTC format (for example,
        *YYYY*-*MM*-*DD* T *HH*:*MM*:*SS* Z).
        :param replace_unhealthy_instances: Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
        :param tag_specifications: The key-value pair for tagging the EC2 Fleet request on creation.
        :param context: Reserved.
        :returns: CreateFleetResult
        """
        raise NotImplementedError

    @handler("CreateFlowLogs")
    def create_flow_logs(
        self,
        context: RequestContext,
        resource_ids: FlowLogResourceIds,
        resource_type: FlowLogsResourceType,
        traffic_type: TrafficType,
        dry_run: Boolean = None,
        client_token: String = None,
        deliver_logs_permission_arn: String = None,
        log_group_name: String = None,
        log_destination_type: LogDestinationType = None,
        log_destination: String = None,
        log_format: String = None,
        tag_specifications: TagSpecificationList = None,
        max_aggregation_interval: Integer = None,
        destination_options: DestinationOptionsRequest = None,
    ) -> CreateFlowLogsResult:
        """Creates one or more flow logs to capture information about IP traffic
        for a specific network interface, subnet, or VPC.

        Flow log data for a monitored network interface is recorded as flow log
        records, which are log events consisting of fields that describe the
        traffic flow. For more information, see `Flow log
        records <https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        When publishing to CloudWatch Logs, flow log records are published to a
        log group, and each network interface has a unique log stream in the log
        group. When publishing to Amazon S3, flow log records for all of the
        monitored network interfaces are published to a single log file object
        that is stored in the specified bucket.

        For more information, see `VPC Flow
        Logs <https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param resource_ids: The ID of the subnet, network interface, or VPC for which you want to
        create a flow log.
        :param resource_type: The type of resource for which to create the flow log.
        :param traffic_type: The type of traffic to log.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param deliver_logs_permission_arn: The ARN for the IAM role that permits Amazon EC2 to publish flow logs to
        a CloudWatch Logs log group in your account.
        :param log_group_name: The name of a new or existing CloudWatch Logs log group where Amazon EC2
        publishes your flow logs.
        :param log_destination_type: The type of destination to which the flow log data is to be published.
        :param log_destination: The destination to which the flow log data is to be published.
        :param log_format: The fields to include in the flow log record, in the order in which they
        should appear.
        :param tag_specifications: The tags to apply to the flow logs.
        :param max_aggregation_interval: The maximum interval of time during which a flow of packets is captured
        and aggregated into a flow log record.
        :param destination_options: The destination options.
        :returns: CreateFlowLogsResult
        """
        raise NotImplementedError

    @handler("CreateFpgaImage")
    def create_fpga_image(
        self,
        context: RequestContext,
        input_storage_location: StorageLocation,
        dry_run: Boolean = None,
        logs_storage_location: StorageLocation = None,
        description: String = None,
        name: String = None,
        client_token: String = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateFpgaImageResult:
        """Creates an Amazon FPGA Image (AFI) from the specified design checkpoint
        (DCP).

        The create operation is asynchronous. To verify that the AFI is ready
        for use, check the output logs.

        An AFI contains the FPGA bitstream that is ready to download to an FPGA.
        You can securely deploy an AFI on multiple FPGA-accelerated instances.
        For more information, see the `Amazon Web Services FPGA Hardware
        Development Kit <https://github.com/aws/aws-fpga/>`__.

        :param input_storage_location: The location of the encrypted design checkpoint in Amazon S3.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param logs_storage_location: The location in Amazon S3 for the output logs.
        :param description: A description for the AFI.
        :param name: A name for the AFI.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param tag_specifications: The tags to apply to the FPGA image during creation.
        :returns: CreateFpgaImageResult
        """
        raise NotImplementedError

    @handler("CreateImage")
    def create_image(
        self,
        context: RequestContext,
        instance_id: InstanceId,
        name: String,
        block_device_mappings: BlockDeviceMappingRequestList = None,
        description: String = None,
        dry_run: Boolean = None,
        no_reboot: Boolean = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateImageResult:
        """Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
        is either running or stopped.

        If you customized your instance with instance store volumes or Amazon
        EBS volumes in addition to the root device volume, the new AMI contains
        block device mapping information for those volumes. When you launch an
        instance from this new AMI, the instance automatically launches with
        those additional volumes.

        For more information, see `Creating Amazon EBS-Backed Linux
        AMIs <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param instance_id: The ID of the instance.
        :param name: A name for the new image.
        :param block_device_mappings: The block device mappings.
        :param description: A description for the new image.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param no_reboot: By default, Amazon EC2 attempts to shut down and reboot the instance
        before creating the image.
        :param tag_specifications: The tags to apply to the AMI and snapshots on creation.
        :returns: CreateImageResult
        """
        raise NotImplementedError

    @handler("CreateInstanceEventWindow")
    def create_instance_event_window(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        name: String = None,
        time_ranges: InstanceEventWindowTimeRangeRequestSet = None,
        cron_expression: InstanceEventWindowCronExpression = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateInstanceEventWindowResult:
        """Creates an event window in which scheduled events for the associated
        Amazon EC2 instances can run.

        You can define either a set of time ranges or a cron expression when
        creating the event window, but not both. All event window times are in
        UTC.

        You can create up to 200 event windows per Amazon Web Services Region.

        When you create the event window, targets (instance IDs, Dedicated Host
        IDs, or tags) are not yet associated with it. To ensure that the event
        window can be used, you must associate one or more targets with it by
        using the AssociateInstanceEventWindow API.

        Event windows are applicable only for scheduled events that stop,
        reboot, or terminate instances.

        Event windows are *not* applicable for:

        -  Expedited scheduled events and network maintenance events.

        -  Unscheduled maintenance such as AutoRecovery and unplanned reboots.

        For more information, see `Define event windows for scheduled
        events <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html>`__
        in the *Amazon EC2 User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param name: The name of the event window.
        :param time_ranges: The time range for the event window.
        :param cron_expression: The cron expression for the event window, for example,
        ``* 0-4,20-23 * * 1,5``.
        :param tag_specifications: The tags to apply to the event window.
        :returns: CreateInstanceEventWindowResult
        """
        raise NotImplementedError

    @handler("CreateInstanceExportTask")
    def create_instance_export_task(
        self,
        context: RequestContext,
        export_to_s3_task: ExportToS3TaskSpecification,
        instance_id: InstanceId,
        target_environment: ExportEnvironment,
        description: String = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateInstanceExportTaskResult:
        """Exports a running or stopped instance to an Amazon S3 bucket.

        For information about the supported operating systems, image formats,
        and known limitations for the types of instances you can export, see
        `Exporting an instance as a VM Using VM
        Import/Export <https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html>`__
        in the *VM Import/Export User Guide*.

        :param export_to_s3_task: The format and location for an export instance task.
        :param instance_id: The ID of the instance.
        :param target_environment: The target virtualization environment.
        :param description: A description for the conversion task or the resource being exported.
        :param tag_specifications: The tags to apply to the export instance task during creation.
        :returns: CreateInstanceExportTaskResult
        """
        raise NotImplementedError

    @handler("CreateInternetGateway")
    def create_internet_gateway(
        self,
        context: RequestContext,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateInternetGatewayResult:
        """Creates an internet gateway for use with a VPC. After creating the
        internet gateway, you attach it to a VPC using AttachInternetGateway.

        For more information about your VPC and internet gateway, see the
        `Amazon Virtual Private Cloud User
        Guide <https://docs.aws.amazon.com/vpc/latest/userguide/>`__.

        :param tag_specifications: The tags to assign to the internet gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateInternetGatewayResult
        """
        raise NotImplementedError

    @handler("CreateIpam")
    def create_ipam(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        description: String = None,
        operating_regions: AddIpamOperatingRegionSet = None,
        tag_specifications: TagSpecificationList = None,
        client_token: String = None,
    ) -> CreateIpamResult:
        """Create an IPAM. Amazon VCP IP Address Manager (IPAM) is a VPC feature
        that you can use to automate your IP address management workflows
        including assigning, tracking, troubleshooting, and auditing IP
        addresses across Amazon Web Services Regions and accounts throughout
        your Amazon Web Services Organization.

        For more information, see `Create an
        IPAM </vpc/latest/ipam/create-ipam.html>`__ in the *Amazon VPC IPAM User
        Guide*.

        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :param description: A description for the IPAM.
        :param operating_regions: The operating Regions for the IPAM.
        :param tag_specifications: The key/value combination of a tag assigned to the resource.
        :param client_token: A unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CreateIpamResult
        """
        raise NotImplementedError

    @handler("CreateIpamPool")
    def create_ipam_pool(
        self,
        context: RequestContext,
        ipam_scope_id: IpamScopeId,
        dry_run: Boolean = None,
        locale: String = None,
        source_ipam_pool_id: IpamPoolId = None,
        description: String = None,
        address_family: AddressFamily = None,
        auto_import: Boolean = None,
        publicly_advertisable: Boolean = None,
        allocation_min_netmask_length: IpamNetmaskLength = None,
        allocation_max_netmask_length: IpamNetmaskLength = None,
        allocation_default_netmask_length: IpamNetmaskLength = None,
        allocation_resource_tags: RequestIpamResourceTagList = None,
        tag_specifications: TagSpecificationList = None,
        client_token: String = None,
        aws_service: IpamPoolAwsService = None,
    ) -> CreateIpamPoolResult:
        """Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In
        IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools
        enable you to organize your IP addresses according to your routing and
        security needs. For example, if you have separate routing and security
        needs for development and production applications, you can create a pool
        for each.

        For more information, see `Create a top-level
        pool </vpc/latest/ipam/create-top-ipam.html>`__ in the *Amazon VPC IPAM
        User Guide*.

        :param ipam_scope_id: The ID of the scope in which you would like to create the IPAM pool.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :param locale: In IPAM, the locale is the Amazon Web Services Region where you want to
        make an IPAM pool available for allocations.
        :param source_ipam_pool_id: The ID of the source IPAM pool.
        :param description: A description for the IPAM pool.
        :param address_family: The IP protocol assigned to this IPAM pool.
        :param auto_import: If selected, IPAM will continuously look for resources within the CIDR
        range of this pool and automatically import them as allocations into
        your IPAM.
        :param publicly_advertisable: Determines if the pool is publicly advertisable.
        :param allocation_min_netmask_length: The minimum netmask length required for CIDR allocations in this IPAM
        pool to be compliant.
        :param allocation_max_netmask_length: The maximum netmask length possible for CIDR allocations in this IPAM
        pool to be compliant.
        :param allocation_default_netmask_length: The default netmask length for allocations added to this pool.
        :param allocation_resource_tags: Tags that are required for resources that use CIDRs from this IPAM pool.
        :param tag_specifications: The key/value combination of a tag assigned to the resource.
        :param client_token: A unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param aws_service: Limits which service in Amazon Web Services that the pool can be used
        in.
        :returns: CreateIpamPoolResult
        """
        raise NotImplementedError

    @handler("CreateIpamScope")
    def create_ipam_scope(
        self,
        context: RequestContext,
        ipam_id: IpamId,
        dry_run: Boolean = None,
        description: String = None,
        tag_specifications: TagSpecificationList = None,
        client_token: String = None,
    ) -> CreateIpamScopeResult:
        """Create an IPAM scope. In IPAM, a scope is the highest-level container
        within IPAM. An IPAM contains two default scopes. Each scope represents
        the IP space for a single network. The private scope is intended for all
        private IP address space. The public scope is intended for all public IP
        address space. Scopes enable you to reuse IP addresses across multiple
        unconnected networks without causing IP address overlap or conflict.

        For more information, see `Add a
        scope </vpc/latest/ipam/add-scope-ipam.html>`__ in the *Amazon VPC IPAM
        User Guide*.

        :param ipam_id: The ID of the IPAM for which you're creating this scope.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :param description: A description for the scope you're creating.
        :param tag_specifications: The key/value combination of a tag assigned to the resource.
        :param client_token: A unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CreateIpamScopeResult
        """
        raise NotImplementedError

    @handler("CreateKeyPair")
    def create_key_pair(
        self,
        context: RequestContext,
        key_name: String,
        dry_run: Boolean = None,
        key_type: KeyType = None,
        tag_specifications: TagSpecificationList = None,
    ) -> KeyPair:
        """Creates an ED25519 or 2048-bit RSA key pair with the specified name.
        Amazon EC2 stores the public key and displays the private key for you to
        save to a file. The private key is returned as an unencrypted PEM
        encoded PKCS#1 private key. If a key with the specified name already
        exists, Amazon EC2 returns an error.

        The key pair returned to you is available only in the Amazon Web
        Services Region in which you create it. If you prefer, you can create
        your own key pair using a third-party tool and upload it to any Region
        using ImportKeyPair.

        You can have up to 5,000 key pairs per Amazon Web Services Region.

        For more information, see `Amazon EC2 key
        pairs <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param key_name: A unique name for the key pair.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param key_type: The type of key pair.
        :param tag_specifications: The tags to apply to the new key pair.
        :returns: KeyPair
        """
        raise NotImplementedError

    @handler("CreateLaunchTemplate")
    def create_launch_template(
        self,
        context: RequestContext,
        launch_template_name: LaunchTemplateName,
        launch_template_data: RequestLaunchTemplateData,
        dry_run: Boolean = None,
        client_token: String = None,
        version_description: VersionDescription = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateLaunchTemplateResult:
        """Creates a launch template. A launch template contains the parameters to
        launch an instance. When you launch an instance using RunInstances, you
        can specify a launch template instead of providing the launch parameters
        in the request. For more information, see `Launching an instance from a
        launch
        template <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param launch_template_name: A name for the launch template.
        :param launch_template_data: The information for the launch template.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier you provide to ensure the idempotency
        of the request.
        :param version_description: A description for the first version of the launch template.
        :param tag_specifications: The tags to apply to the launch template during creation.
        :returns: CreateLaunchTemplateResult
        """
        raise NotImplementedError

    @handler("CreateLaunchTemplateVersion")
    def create_launch_template_version(
        self,
        context: RequestContext,
        launch_template_data: RequestLaunchTemplateData,
        dry_run: Boolean = None,
        client_token: String = None,
        launch_template_id: LaunchTemplateId = None,
        launch_template_name: LaunchTemplateName = None,
        source_version: String = None,
        version_description: VersionDescription = None,
    ) -> CreateLaunchTemplateVersionResult:
        """Creates a new version for a launch template. You can specify an existing
        version of launch template from which to base the new version.

        Launch template versions are numbered in the order in which they are
        created. You cannot specify, change, or replace the numbering of launch
        template versions.

        For more information, see `Managing launch template
        versions <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#manage-launch-template-versions>`__ in
        the *Amazon Elastic Compute Cloud User Guide*.

        :param launch_template_data: The information for the launch template.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier you provide to ensure the idempotency
        of the request.
        :param launch_template_id: The ID of the launch template.
        :param launch_template_name: The name of the launch template.
        :param source_version: The version number of the launch template version on which to base the
        new version.
        :param version_description: A description for the version of the launch template.
        :returns: CreateLaunchTemplateVersionResult
        """
        raise NotImplementedError

    @handler("CreateLocalGatewayRoute")
    def create_local_gateway_route(
        self,
        context: RequestContext,
        destination_cidr_block: String,
        local_gateway_route_table_id: LocalGatewayRoutetableId,
        local_gateway_virtual_interface_group_id: LocalGatewayVirtualInterfaceGroupId,
        dry_run: Boolean = None,
    ) -> CreateLocalGatewayRouteResult:
        """Creates a static route for the specified local gateway route table.

        :param destination_cidr_block: The CIDR range used for destination matches.
        :param local_gateway_route_table_id: The ID of the local gateway route table.
        :param local_gateway_virtual_interface_group_id: The ID of the virtual interface group.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateLocalGatewayRouteResult
        """
        raise NotImplementedError

    @handler("CreateLocalGatewayRouteTableVpcAssociation")
    def create_local_gateway_route_table_vpc_association(
        self,
        context: RequestContext,
        local_gateway_route_table_id: LocalGatewayRoutetableId,
        vpc_id: VpcId,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateLocalGatewayRouteTableVpcAssociationResult:
        """Associates the specified VPC with the specified local gateway route
        table.

        :param local_gateway_route_table_id: The ID of the local gateway route table.
        :param vpc_id: The ID of the VPC.
        :param tag_specifications: The tags to assign to the local gateway route table VPC association.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateLocalGatewayRouteTableVpcAssociationResult
        """
        raise NotImplementedError

    @handler("CreateManagedPrefixList")
    def create_managed_prefix_list(
        self,
        context: RequestContext,
        prefix_list_name: String,
        max_entries: Integer,
        address_family: String,
        dry_run: Boolean = None,
        entries: AddPrefixListEntries = None,
        tag_specifications: TagSpecificationList = None,
        client_token: String = None,
    ) -> CreateManagedPrefixListResult:
        """Creates a managed prefix list. You can specify one or more entries for
        the prefix list. Each entry consists of a CIDR block and an optional
        description.

        :param prefix_list_name: A name for the prefix list.
        :param max_entries: The maximum number of entries for the prefix list.
        :param address_family: The IP address type.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param entries: One or more entries for the prefix list.
        :param tag_specifications: The tags to apply to the prefix list during creation.
        :param client_token: Unique, case-sensitive identifier you provide to ensure the idempotency
        of the request.
        :returns: CreateManagedPrefixListResult
        """
        raise NotImplementedError

    @handler("CreateNatGateway")
    def create_nat_gateway(
        self,
        context: RequestContext,
        subnet_id: SubnetId,
        allocation_id: AllocationId = None,
        client_token: String = None,
        dry_run: Boolean = None,
        tag_specifications: TagSpecificationList = None,
        connectivity_type: ConnectivityType = None,
    ) -> CreateNatGatewayResult:
        """Creates a NAT gateway in the specified subnet. This action creates a
        network interface in the specified subnet with a private IP address from
        the IP address range of the subnet. You can create either a public NAT
        gateway or a private NAT gateway.

        With a public NAT gateway, internet-bound traffic from a private subnet
        can be routed to the NAT gateway, so that instances in a private subnet
        can connect to the internet.

        With a private NAT gateway, private communication is routed across VPCs
        and on-premises networks through a transit gateway or virtual private
        gateway. Common use cases include running large workloads behind a small
        pool of allowlisted IPv4 addresses, preserving private IPv4 addresses,
        and communicating between overlapping networks.

        For more information, see `NAT
        gateways <https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param subnet_id: The subnet in which to create the NAT gateway.
        :param allocation_id: [Public NAT gateways only] The allocation ID of an Elastic IP address to
        associate with the NAT gateway.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param tag_specifications: The tags to assign to the NAT gateway.
        :param connectivity_type: Indicates whether the NAT gateway supports public or private
        connectivity.
        :returns: CreateNatGatewayResult
        """
        raise NotImplementedError

    @handler("CreateNetworkAcl")
    def create_network_acl(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        dry_run: Boolean = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateNetworkAclResult:
        """Creates a network ACL in a VPC. Network ACLs provide an optional layer
        of security (in addition to security groups) for the instances in your
        VPC.

        For more information, see `Network
        ACLs <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param tag_specifications: The tags to assign to the network ACL.
        :returns: CreateNetworkAclResult
        """
        raise NotImplementedError

    @handler("CreateNetworkAclEntry")
    def create_network_acl_entry(
        self,
        context: RequestContext,
        egress: Boolean,
        network_acl_id: NetworkAclId,
        protocol: String,
        rule_action: RuleAction,
        rule_number: Integer,
        cidr_block: String = None,
        dry_run: Boolean = None,
        icmp_type_code: IcmpTypeCode = None,
        ipv6_cidr_block: String = None,
        port_range: PortRange = None,
    ) -> None:
        """Creates an entry (a rule) in a network ACL with the specified rule
        number. Each network ACL has a set of numbered ingress rules and a
        separate set of numbered egress rules. When determining whether a packet
        should be allowed in or out of a subnet associated with the ACL, we
        process the entries in the ACL according to the rule numbers, in
        ascending order. Each network ACL has a set of ingress rules and a
        separate set of egress rules.

        We recommend that you leave room between the rule numbers (for example,
        100, 110, 120, ...), and not number them one right after the other (for
        example, 101, 102, 103, ...). This makes it easier to add a rule between
        existing ones without having to renumber the rules.

        After you add an entry, you can't modify it; you must either replace it,
        or create an entry and delete the old one.

        For more information about network ACLs, see `Network
        ACLs <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param egress: Indicates whether this is an egress rule (rule is applied to traffic
        leaving the subnet).
        :param network_acl_id: The ID of the network ACL.
        :param protocol: The protocol number.
        :param rule_action: Indicates whether to allow or deny the traffic that matches the rule.
        :param rule_number: The rule number for the entry (for example, 100).
        :param cidr_block: The IPv4 network range to allow or deny, in CIDR notation (for example
        ``172.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param icmp_type_code: ICMP protocol: The ICMP or ICMPv6 type and code.
        :param ipv6_cidr_block: The IPv6 network range to allow or deny, in CIDR notation (for example
        ``2001:db8:1234:1a00::/64``).
        :param port_range: TCP or UDP protocols: The range of ports the rule applies to.
        """
        raise NotImplementedError

    @handler("CreateNetworkInsightsAccessScope")
    def create_network_insights_access_scope(
        self,
        context: RequestContext,
        client_token: String,
        match_paths: AccessScopePathListRequest = None,
        exclude_paths: AccessScopePathListRequest = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateNetworkInsightsAccessScopeResult:
        """Creates a Network Access Scope.

        Amazon Web Services Network Access Analyzer enables cloud networking and
        cloud operations teams to verify that their networks on Amazon Web
        Services conform to their network security and governance objectives.
        For more information, see the `Amazon Web Services Network Access
        Analyzer
        Guide <https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/>`__.

        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param match_paths: The paths to match.
        :param exclude_paths: The paths to exclude.
        :param tag_specifications: The tags to apply.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateNetworkInsightsAccessScopeResult
        """
        raise NotImplementedError

    @handler("CreateNetworkInsightsPath")
    def create_network_insights_path(
        self,
        context: RequestContext,
        source: NetworkInsightsResourceId,
        destination: NetworkInsightsResourceId,
        protocol: Protocol,
        client_token: String,
        source_ip: IpAddress = None,
        destination_ip: IpAddress = None,
        destination_port: Port = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateNetworkInsightsPathResult:
        """Creates a path to analyze for reachability.

        Reachability Analyzer enables you to analyze and debug network
        reachability between two resources in your virtual private cloud (VPC).
        For more information, see `What is Reachability
        Analyzer <https://docs.aws.amazon.com/vpc/latest/reachability/>`__.

        :param source: The Amazon Web Services resource that is the source of the path.
        :param destination: The Amazon Web Services resource that is the destination of the path.
        :param protocol: The protocol.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param source_ip: The IP address of the Amazon Web Services resource that is the source of
        the path.
        :param destination_ip: The IP address of the Amazon Web Services resource that is the
        destination of the path.
        :param destination_port: The destination port.
        :param tag_specifications: The tags to add to the path.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateNetworkInsightsPathResult
        """
        raise NotImplementedError

    @handler("CreateNetworkInterface")
    def create_network_interface(
        self,
        context: RequestContext,
        subnet_id: SubnetId,
        description: String = None,
        dry_run: Boolean = None,
        groups: SecurityGroupIdStringList = None,
        ipv6_address_count: Integer = None,
        ipv6_addresses: InstanceIpv6AddressList = None,
        private_ip_address: String = None,
        private_ip_addresses: PrivateIpAddressSpecificationList = None,
        secondary_private_ip_address_count: Integer = None,
        ipv4_prefixes: Ipv4PrefixList = None,
        ipv4_prefix_count: Integer = None,
        ipv6_prefixes: Ipv6PrefixList = None,
        ipv6_prefix_count: Integer = None,
        interface_type: NetworkInterfaceCreationType = None,
        tag_specifications: TagSpecificationList = None,
        client_token: String = None,
    ) -> CreateNetworkInterfaceResult:
        """Creates a network interface in the specified subnet.

        For more information about network interfaces, see `Elastic Network
        Interfaces <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param subnet_id: The ID of the subnet to associate with the network interface.
        :param description: A description for the network interface.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param groups: The IDs of one or more security groups.
        :param ipv6_address_count: The number of IPv6 addresses to assign to a network interface.
        :param ipv6_addresses: One or more specific IPv6 addresses from the IPv6 CIDR block range of
        your subnet.
        :param private_ip_address: The primary private IPv4 address of the network interface.
        :param private_ip_addresses: One or more private IPv4 addresses.
        :param secondary_private_ip_address_count: The number of secondary private IPv4 addresses to assign to a network
        interface.
        :param ipv4_prefixes: One or more IPv4 prefixes assigned to the network interface.
        :param ipv4_prefix_count: The number of IPv4 prefixes that Amazon Web Services automatically
        assigns to the network interface.
        :param ipv6_prefixes: One or more IPv6 prefixes assigned to the network interface.
        :param ipv6_prefix_count: The number of IPv6 prefixes that Amazon Web Services automatically
        assigns to the network interface.
        :param interface_type: Indicates the type of network interface.
        :param tag_specifications: The tags to apply to the new network interface.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CreateNetworkInterfaceResult
        """
        raise NotImplementedError

    @handler("CreateNetworkInterfacePermission")
    def create_network_interface_permission(
        self,
        context: RequestContext,
        network_interface_id: NetworkInterfaceId,
        permission: InterfacePermissionType,
        aws_account_id: String = None,
        aws_service: String = None,
        dry_run: Boolean = None,
    ) -> CreateNetworkInterfacePermissionResult:
        """Grants an Amazon Web Services-authorized account permission to attach
        the specified network interface to an instance in their account.

        You can grant permission to a single Amazon Web Services account only,
        and only one account at a time.

        :param network_interface_id: The ID of the network interface.
        :param permission: The type of permission to grant.
        :param aws_account_id: The Amazon Web Services account ID.
        :param aws_service: The Amazon Web Service.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateNetworkInterfacePermissionResult
        """
        raise NotImplementedError

    @handler("CreatePlacementGroup")
    def create_placement_group(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        group_name: String = None,
        strategy: PlacementStrategy = None,
        partition_count: Integer = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreatePlacementGroupResult:
        """Creates a placement group in which to launch instances. The strategy of
        the placement group determines how the instances are organized within
        the group.

        A ``cluster`` placement group is a logical grouping of instances within
        a single Availability Zone that benefit from low network latency, high
        network throughput. A ``spread`` placement group places instances on
        distinct hardware. A ``partition`` placement group places groups of
        instances in different partitions, where instances in one partition do
        not share the same hardware with instances in another partition.

        For more information, see `Placement
        groups <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html>`__
        in the *Amazon EC2 User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param group_name: A name for the placement group.
        :param strategy: The placement strategy.
        :param partition_count: The number of partitions.
        :param tag_specifications: The tags to apply to the new placement group.
        :returns: CreatePlacementGroupResult
        """
        raise NotImplementedError

    @handler("CreatePublicIpv4Pool")
    def create_public_ipv4_pool(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreatePublicIpv4PoolResult:
        """Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP
        address pool required for the public IPv4 CIDRs that you own and bring
        to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to
        Amazon Web Services, however, use IPAM pools only. To monitor the status
        of pool creation, use
        `DescribePublicIpv4Pools <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html>`__.

        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :param tag_specifications: The key/value combination of a tag assigned to the resource.
        :returns: CreatePublicIpv4PoolResult
        """
        raise NotImplementedError

    @handler("CreateReplaceRootVolumeTask")
    def create_replace_root_volume_task(
        self,
        context: RequestContext,
        instance_id: InstanceId,
        snapshot_id: SnapshotId = None,
        client_token: String = None,
        dry_run: Boolean = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateReplaceRootVolumeTaskResult:
        """Creates a root volume replacement task for an Amazon EC2 instance. The
        root volume can either be restored to its initial launch state, or it
        can be restored using a specific snapshot.

        For more information, see `Replace a root
        volume <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param instance_id: The ID of the instance for which to replace the root volume.
        :param snapshot_id: The ID of the snapshot from which to restore the replacement root
        volume.
        :param client_token: Unique, case-sensitive identifier you provide to ensure the idempotency
        of the request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param tag_specifications: The tags to apply to the root volume replacement task.
        :returns: CreateReplaceRootVolumeTaskResult
        """
        raise NotImplementedError

    @handler("CreateReservedInstancesListing")
    def create_reserved_instances_listing(
        self,
        context: RequestContext,
        client_token: String,
        instance_count: Integer,
        price_schedules: PriceScheduleSpecificationList,
        reserved_instances_id: ReservationId,
    ) -> CreateReservedInstancesListingResult:
        """Creates a listing for Amazon EC2 Standard Reserved Instances to be sold
        in the Reserved Instance Marketplace. You can submit one Standard
        Reserved Instance listing at a time. To get a list of your Standard
        Reserved Instances, you can use the DescribeReservedInstances operation.

        Only Standard Reserved Instances can be sold in the Reserved Instance
        Marketplace. Convertible Reserved Instances cannot be sold.

        The Reserved Instance Marketplace matches sellers who want to resell
        Standard Reserved Instance capacity that they no longer need with buyers
        who want to purchase additional capacity. Reserved Instances bought and
        sold through the Reserved Instance Marketplace work like any other
        Reserved Instances.

        To sell your Standard Reserved Instances, you must first register as a
        seller in the Reserved Instance Marketplace. After completing the
        registration process, you can create a Reserved Instance Marketplace
        listing of some or all of your Standard Reserved Instances, and specify
        the upfront price to receive for them. Your Standard Reserved Instance
        listings then become available for purchase. To view the details of your
        Standard Reserved Instance listing, you can use the
        DescribeReservedInstancesListings operation.

        For more information, see `Reserved Instance
        Marketplace <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html>`__
        in the *Amazon EC2 User Guide*.

        :param client_token: Unique, case-sensitive identifier you provide to ensure idempotency of
        your listings.
        :param instance_count: The number of instances that are a part of a Reserved Instance account
        to be listed in the Reserved Instance Marketplace.
        :param price_schedules: A list specifying the price of the Standard Reserved Instance for each
        month remaining in the Reserved Instance term.
        :param reserved_instances_id: The ID of the active Standard Reserved Instance.
        :returns: CreateReservedInstancesListingResult
        """
        raise NotImplementedError

    @handler("CreateRestoreImageTask")
    def create_restore_image_task(
        self,
        context: RequestContext,
        bucket: String,
        object_key: String,
        name: String = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateRestoreImageTaskResult:
        """Starts a task that restores an AMI from an Amazon S3 object that was
        previously created by using
        `CreateStoreImageTask <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html>`__.

        To use this API, you must have the required permissions. For more
        information, see `Permissions for storing and restoring AMIs using
        Amazon
        S3 <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        For more information, see `Store and restore an AMI using Amazon
        S3 <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param bucket: The name of the Amazon S3 bucket that contains the stored AMI object.
        :param object_key: The name of the stored AMI object in the bucket.
        :param name: The name for the restored AMI.
        :param tag_specifications: The tags to apply to the AMI and snapshots on restoration.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateRestoreImageTaskResult
        """
        raise NotImplementedError

    @handler("CreateRoute")
    def create_route(
        self,
        context: RequestContext,
        route_table_id: RouteTableId,
        destination_cidr_block: String = None,
        destination_ipv6_cidr_block: String = None,
        destination_prefix_list_id: PrefixListResourceId = None,
        dry_run: Boolean = None,
        vpc_endpoint_id: VpcEndpointId = None,
        egress_only_internet_gateway_id: EgressOnlyInternetGatewayId = None,
        gateway_id: RouteGatewayId = None,
        instance_id: InstanceId = None,
        nat_gateway_id: NatGatewayId = None,
        transit_gateway_id: TransitGatewayId = None,
        local_gateway_id: LocalGatewayId = None,
        carrier_gateway_id: CarrierGatewayId = None,
        network_interface_id: NetworkInterfaceId = None,
        vpc_peering_connection_id: VpcPeeringConnectionId = None,
        core_network_arn: CoreNetworkArn = None,
    ) -> CreateRouteResult:
        """Creates a route in a route table within a VPC.

        You must specify one of the following targets: internet gateway or
        virtual private gateway, NAT instance, NAT gateway, VPC peering
        connection, network interface, egress-only internet gateway, or transit
        gateway.

        When determining how to route traffic, we use the route with the most
        specific match. For example, traffic is destined for the IPv4 address
        ``192.0.2.3``, and the route table includes the following two IPv4
        routes:

        -  ``192.0.2.0/24`` (goes to some target A)

        -  ``192.0.2.0/28`` (goes to some target B)

        Both routes apply to the traffic destined for ``192.0.2.3``. However,
        the second route in the list covers a smaller number of IP addresses and
        is therefore more specific, so we use that route to determine where to
        target the traffic.

        For more information about route tables, see `Route
        tables <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param route_table_id: The ID of the route table for the route.
        :param destination_cidr_block: The IPv4 CIDR address block used for the destination match.
        :param destination_ipv6_cidr_block: The IPv6 CIDR block used for the destination match.
        :param destination_prefix_list_id: The ID of a prefix list used for the destination match.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param vpc_endpoint_id: The ID of a VPC endpoint.
        :param egress_only_internet_gateway_id: [IPv6 traffic only] The ID of an egress-only internet gateway.
        :param gateway_id: The ID of an internet gateway or virtual private gateway attached to
        your VPC.
        :param instance_id: The ID of a NAT instance in your VPC.
        :param nat_gateway_id: [IPv4 traffic only] The ID of a NAT gateway.
        :param transit_gateway_id: The ID of a transit gateway.
        :param local_gateway_id: The ID of the local gateway.
        :param carrier_gateway_id: The ID of the carrier gateway.
        :param network_interface_id: The ID of a network interface.
        :param vpc_peering_connection_id: The ID of a VPC peering connection.
        :param core_network_arn: The Amazon Resource Name (ARN) of the core network.
        :returns: CreateRouteResult
        """
        raise NotImplementedError

    @handler("CreateRouteTable")
    def create_route_table(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        dry_run: Boolean = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateRouteTableResult:
        """Creates a route table for the specified VPC. After you create a route
        table, you can add routes and associate the table with a subnet.

        For more information, see `Route
        tables <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param tag_specifications: The tags to assign to the route table.
        :returns: CreateRouteTableResult
        """
        raise NotImplementedError

    @handler("CreateSecurityGroup")
    def create_security_group(
        self,
        context: RequestContext,
        description: String,
        group_name: String,
        vpc_id: VpcId = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateSecurityGroupResult:
        """Creates a security group.

        A security group acts as a virtual firewall for your instance to control
        inbound and outbound traffic. For more information, see `Amazon EC2
        security
        groups <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html>`__
        in the *Amazon Elastic Compute Cloud User Guide* and `Security groups
        for your
        VPC <https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        When you create a security group, you specify a friendly name of your
        choice. You can have a security group for use in EC2-Classic with the
        same name as a security group for use in a VPC. However, you can't have
        two security groups for use in EC2-Classic with the same name or two
        security groups for use in a VPC with the same name.

        You have a default security group for use in EC2-Classic and a default
        security group for use in your VPC. If you don't specify a security
        group when you launch an instance, the instance is launched into the
        appropriate default security group. A default security group includes a
        default rule that grants instances unrestricted network access to each
        other.

        You can add or remove rules from your security groups using
        AuthorizeSecurityGroupIngress, AuthorizeSecurityGroupEgress,
        RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.

        For more information about VPC security group limits, see `Amazon VPC
        Limits <https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html>`__.

        :param description: A description for the security group.
        :param group_name: The name of the security group.
        :param vpc_id: [EC2-VPC] The ID of the VPC.
        :param tag_specifications: The tags to assign to the security group.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateSecurityGroupResult
        """
        raise NotImplementedError

    @handler("CreateSnapshot")
    def create_snapshot(
        self,
        context: RequestContext,
        volume_id: VolumeId,
        description: String = None,
        outpost_arn: String = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> Snapshot:
        """Creates a snapshot of an EBS volume and stores it in Amazon S3. You can
        use snapshots for backups, to make copies of EBS volumes, and to save
        data before shutting down an instance.

        You can create snapshots of volumes in a Region and volumes on an
        Outpost. If you create a snapshot of a volume in a Region, the snapshot
        must be stored in the same Region as the volume. If you create a
        snapshot of a volume on an Outpost, the snapshot can be stored on the
        same Outpost as the volume, or in the Region for that Outpost.

        When a snapshot is created, any Amazon Web Services Marketplace product
        codes that are associated with the source volume are propagated to the
        snapshot.

        You can take a snapshot of an attached volume that is in use. However,
        snapshots only capture data that has been written to your Amazon EBS
        volume at the time the snapshot command is issued; this might exclude
        any data that has been cached by any applications or the operating
        system. If you can pause any file systems on the volume long enough to
        take a snapshot, your snapshot should be complete. However, if you
        cannot pause all file writes to the volume, you should unmount the
        volume from within the instance, issue the snapshot command, and then
        remount the volume to ensure a consistent and complete snapshot. You may
        remount and use your volume while the snapshot status is ``pending``.

        To create a snapshot for Amazon EBS volumes that serve as root devices,
        you should stop the instance before taking the snapshot.

        Snapshots that are taken from encrypted volumes are automatically
        encrypted. Volumes that are created from encrypted snapshots are also
        automatically encrypted. Your encrypted volumes and any associated
        snapshots always remain protected.

        You can tag your snapshots during creation. For more information, see
        `Tag your Amazon EC2
        resources <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        For more information, see `Amazon Elastic Block
        Store <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html>`__
        and `Amazon EBS
        encryption <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param volume_id: The ID of the Amazon EBS volume.
        :param description: A description for the snapshot.
        :param outpost_arn: The Amazon Resource Name (ARN) of the Outpost on which to create a local
        snapshot.
        :param tag_specifications: The tags to apply to the snapshot during creation.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: Snapshot
        """
        raise NotImplementedError

    @handler("CreateSnapshots")
    def create_snapshots(
        self,
        context: RequestContext,
        instance_specification: InstanceSpecification,
        description: String = None,
        outpost_arn: String = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
        copy_tags_from_source: CopyTagsFromSource = None,
    ) -> CreateSnapshotsResult:
        """Creates crash-consistent snapshots of multiple EBS volumes and stores
        the data in S3. Volumes are chosen by specifying an instance. Any
        attached volumes will produce one snapshot each that is crash-consistent
        across the instance. Boot volumes can be excluded by changing the
        parameters.

        You can create multi-volume snapshots of instances in a Region and
        instances on an Outpost. If you create snapshots from an instance in a
        Region, the snapshots must be stored in the same Region as the instance.
        If you create snapshots from an instance on an Outpost, the snapshots
        can be stored on the same Outpost as the instance, or in the Region for
        that Outpost.

        :param instance_specification: The instance to specify which volumes should be included in the
        snapshots.
        :param description: A description propagated to every snapshot specified by the instance.
        :param outpost_arn: The Amazon Resource Name (ARN) of the Outpost on which to create the
        local snapshots.
        :param tag_specifications: Tags to apply to every snapshot specified by the instance.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param copy_tags_from_source: Copies the tags from the specified volume to corresponding snapshot.
        :returns: CreateSnapshotsResult
        """
        raise NotImplementedError

    @handler("CreateSpotDatafeedSubscription")
    def create_spot_datafeed_subscription(
        self,
        context: RequestContext,
        bucket: String,
        dry_run: Boolean = None,
        prefix: String = None,
    ) -> CreateSpotDatafeedSubscriptionResult:
        """Creates a data feed for Spot Instances, enabling you to view Spot
        Instance usage logs. You can create one data feed per Amazon Web
        Services account. For more information, see `Spot Instance data
        feed <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html>`__
        in the *Amazon EC2 User Guide for Linux Instances*.

        :param bucket: The name of the Amazon S3 bucket in which to store the Spot Instance
        data feed.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param prefix: The prefix for the data feed file names.
        :returns: CreateSpotDatafeedSubscriptionResult
        """
        raise NotImplementedError

    @handler("CreateStoreImageTask")
    def create_store_image_task(
        self,
        context: RequestContext,
        image_id: ImageId,
        bucket: String,
        s3_object_tags: S3ObjectTagList = None,
        dry_run: Boolean = None,
    ) -> CreateStoreImageTaskResult:
        """Stores an AMI as a single object in an Amazon S3 bucket.

        To use this API, you must have the required permissions. For more
        information, see `Permissions for storing and restoring AMIs using
        Amazon
        S3 <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        For more information, see `Store and restore an AMI using Amazon
        S3 <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param image_id: The ID of the AMI.
        :param bucket: The name of the Amazon S3 bucket in which the AMI object will be stored.
        :param s3_object_tags: The tags to apply to the AMI object that will be stored in the Amazon S3
        bucket.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateStoreImageTaskResult
        """
        raise NotImplementedError

    @handler("CreateSubnet")
    def create_subnet(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        tag_specifications: TagSpecificationList = None,
        availability_zone: String = None,
        availability_zone_id: String = None,
        cidr_block: String = None,
        ipv6_cidr_block: String = None,
        outpost_arn: String = None,
        dry_run: Boolean = None,
        ipv6_native: Boolean = None,
    ) -> CreateSubnetResult:
        """Creates a subnet in a specified VPC.

        You must specify an IPv4 CIDR block for the subnet. After you create a
        subnet, you can't change its CIDR block. The allowed block size is
        between a /16 netmask (65,536 IP addresses) and /28 netmask (16 IP
        addresses). The CIDR block must not overlap with the CIDR block of an
        existing subnet in the VPC.

        If you've associated an IPv6 CIDR block with your VPC, you can create a
        subnet with an IPv6 CIDR block that uses a /64 prefix length.

        Amazon Web Services reserves both the first four and the last IPv4
        address in each subnet's CIDR block. They're not available for use.

        If you add more than one subnet to a VPC, they're set up in a star
        topology with a logical router in the middle.

        When you stop an instance in a subnet, it retains its private IPv4
        address. It's therefore possible to have a subnet with no running
        instances (they're all stopped), but no remaining IP addresses
        available.

        For more information about subnets, see `Your VPC and
        subnets <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param vpc_id: The ID of the VPC.
        :param tag_specifications: The tags to assign to the subnet.
        :param availability_zone: The Availability Zone or Local Zone for the subnet.
        :param availability_zone_id: The AZ ID or the Local Zone ID of the subnet.
        :param cidr_block: The IPv4 network range for the subnet, in CIDR notation.
        :param ipv6_cidr_block: The IPv6 network range for the subnet, in CIDR notation.
        :param outpost_arn: The Amazon Resource Name (ARN) of the Outpost.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param ipv6_native: Indicates whether to create an IPv6 only subnet.
        :returns: CreateSubnetResult
        """
        raise NotImplementedError

    @handler("CreateSubnetCidrReservation")
    def create_subnet_cidr_reservation(
        self,
        context: RequestContext,
        subnet_id: SubnetId,
        cidr: String,
        reservation_type: SubnetCidrReservationType,
        tag_specifications: TagSpecificationList = None,
        description: String = None,
        dry_run: Boolean = None,
    ) -> CreateSubnetCidrReservationResult:
        """Creates a subnet CIDR reservation. For information about subnet CIDR
        reservations, see `Subnet CIDR
        reservations <https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param subnet_id: The ID of the subnet.
        :param cidr: The IPv4 or IPV6 CIDR range to reserve.
        :param reservation_type: The type of reservation.
        :param tag_specifications: The tags to assign to the subnet CIDR reservation.
        :param description: The description to assign to the subnet CIDR reservation.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateSubnetCidrReservationResult
        """
        raise NotImplementedError

    @handler("CreateTags")
    def create_tags(
        self,
        context: RequestContext,
        resources: ResourceIdList,
        tags: TagList,
        dry_run: Boolean = None,
    ) -> None:
        """Adds or overwrites only the specified tags for the specified Amazon EC2
        resource or resources. When you specify an existing tag key, the value
        is overwritten with the new value. Each resource can have a maximum of
        50 tags. Each tag consists of a key and optional value. Tag keys must be
        unique per resource.

        For more information about tags, see `Tagging Your
        Resources <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*. For more information
        about creating IAM policies that control users' access to resources
        based on tags, see `Supported Resource-Level Permissions for Amazon EC2
        API
        Actions <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param resources: The IDs of the resources, separated by spaces.
        :param tags: The tags.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("CreateTrafficMirrorFilter")
    def create_traffic_mirror_filter(
        self,
        context: RequestContext,
        description: String = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
        client_token: String = None,
    ) -> CreateTrafficMirrorFilterResult:
        """Creates a Traffic Mirror filter.

        A Traffic Mirror filter is a set of rules that defines the traffic to
        mirror.

        By default, no traffic is mirrored. To mirror traffic, use
        `CreateTrafficMirrorFilterRule <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm>`__
        to add Traffic Mirror rules to the filter. The rules you add define what
        traffic gets mirrored. You can also use
        `ModifyTrafficMirrorFilterNetworkServices <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html>`__
        to mirror supported network services.

        :param description: The description of the Traffic Mirror filter.
        :param tag_specifications: The tags to assign to a Traffic Mirror filter.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CreateTrafficMirrorFilterResult
        """
        raise NotImplementedError

    @handler("CreateTrafficMirrorFilterRule")
    def create_traffic_mirror_filter_rule(
        self,
        context: RequestContext,
        traffic_mirror_filter_id: TrafficMirrorFilterId,
        traffic_direction: TrafficDirection,
        rule_number: Integer,
        rule_action: TrafficMirrorRuleAction,
        destination_cidr_block: String,
        source_cidr_block: String,
        destination_port_range: TrafficMirrorPortRangeRequest = None,
        source_port_range: TrafficMirrorPortRangeRequest = None,
        protocol: Integer = None,
        description: String = None,
        dry_run: Boolean = None,
        client_token: String = None,
    ) -> CreateTrafficMirrorFilterRuleResult:
        """Creates a Traffic Mirror filter rule.

        A Traffic Mirror rule defines the Traffic Mirror source traffic to
        mirror.

        You need the Traffic Mirror filter ID when you create the rule.

        :param traffic_mirror_filter_id: The ID of the filter that this rule is associated with.
        :param traffic_direction: The type of traffic.
        :param rule_number: The number of the Traffic Mirror rule.
        :param rule_action: The action to take on the filtered traffic.
        :param destination_cidr_block: The destination CIDR block to assign to the Traffic Mirror rule.
        :param source_cidr_block: The source CIDR block to assign to the Traffic Mirror rule.
        :param destination_port_range: The destination port range.
        :param source_port_range: The source port range.
        :param protocol: The protocol, for example UDP, to assign to the Traffic Mirror rule.
        :param description: The description of the Traffic Mirror rule.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CreateTrafficMirrorFilterRuleResult
        """
        raise NotImplementedError

    @handler("CreateTrafficMirrorSession")
    def create_traffic_mirror_session(
        self,
        context: RequestContext,
        network_interface_id: NetworkInterfaceId,
        traffic_mirror_target_id: TrafficMirrorTargetId,
        traffic_mirror_filter_id: TrafficMirrorFilterId,
        session_number: Integer,
        packet_length: Integer = None,
        virtual_network_id: Integer = None,
        description: String = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
        client_token: String = None,
    ) -> CreateTrafficMirrorSessionResult:
        """Creates a Traffic Mirror session.

        A Traffic Mirror session actively copies packets from a Traffic Mirror
        source to a Traffic Mirror target. Create a filter, and then assign it
        to the session to define a subset of the traffic to mirror, for example
        all TCP traffic.

        The Traffic Mirror source and the Traffic Mirror target (monitoring
        appliances) can be in the same VPC, or in a different VPC connected via
        VPC peering or a transit gateway.

        By default, no traffic is mirrored. Use
        `CreateTrafficMirrorFilter <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm>`__
        to create filter rules that specify the traffic to mirror.

        :param network_interface_id: The ID of the source network interface.
        :param traffic_mirror_target_id: The ID of the Traffic Mirror target.
        :param traffic_mirror_filter_id: The ID of the Traffic Mirror filter.
        :param session_number: The session number determines the order in which sessions are evaluated
        when an interface is used by multiple sessions.
        :param packet_length: The number of bytes in each packet to mirror.
        :param virtual_network_id: The VXLAN ID for the Traffic Mirror session.
        :param description: The description of the Traffic Mirror session.
        :param tag_specifications: The tags to assign to a Traffic Mirror session.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CreateTrafficMirrorSessionResult
        """
        raise NotImplementedError

    @handler("CreateTrafficMirrorTarget")
    def create_traffic_mirror_target(
        self,
        context: RequestContext,
        network_interface_id: NetworkInterfaceId = None,
        network_load_balancer_arn: String = None,
        description: String = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
        client_token: String = None,
    ) -> CreateTrafficMirrorTargetResult:
        """Creates a target for your Traffic Mirror session.

        A Traffic Mirror target is the destination for mirrored traffic. The
        Traffic Mirror source and the Traffic Mirror target (monitoring
        appliances) can be in the same VPC, or in different VPCs connected via
        VPC peering or a transit gateway.

        A Traffic Mirror target can be a network interface, or a Network Load
        Balancer.

        To use the target in a Traffic Mirror session, use
        `CreateTrafficMirrorSession <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm>`__.

        :param network_interface_id: The network interface ID that is associated with the target.
        :param network_load_balancer_arn: The Amazon Resource Name (ARN) of the Network Load Balancer that is
        associated with the target.
        :param description: The description of the Traffic Mirror target.
        :param tag_specifications: The tags to assign to the Traffic Mirror target.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CreateTrafficMirrorTargetResult
        """
        raise NotImplementedError

    @handler("CreateTransitGateway")
    def create_transit_gateway(
        self,
        context: RequestContext,
        description: String = None,
        options: TransitGatewayRequestOptions = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateTransitGatewayResult:
        """Creates a transit gateway.

        You can use a transit gateway to interconnect your virtual private
        clouds (VPC) and on-premises networks. After the transit gateway enters
        the ``available`` state, you can attach your VPCs and VPN connections to
        the transit gateway.

        To attach your VPCs, use CreateTransitGatewayVpcAttachment.

        To attach a VPN connection, use CreateCustomerGateway to create a
        customer gateway and specify the ID of the customer gateway and the ID
        of the transit gateway in a call to CreateVpnConnection.

        When you create a transit gateway, we create a default transit gateway
        route table and use it as the default association route table and the
        default propagation route table. You can use
        CreateTransitGatewayRouteTable to create additional transit gateway
        route tables. If you disable automatic route propagation, we do not
        create a default transit gateway route table. You can use
        EnableTransitGatewayRouteTablePropagation to propagate routes from a
        resource attachment to a transit gateway route table. If you disable
        automatic associations, you can use AssociateTransitGatewayRouteTable to
        associate a resource attachment with a transit gateway route table.

        :param description: A description of the transit gateway.
        :param options: The transit gateway options.
        :param tag_specifications: The tags to apply to the transit gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateTransitGatewayResult
        """
        raise NotImplementedError

    @handler("CreateTransitGatewayConnect")
    def create_transit_gateway_connect(
        self,
        context: RequestContext,
        transport_transit_gateway_attachment_id: TransitGatewayAttachmentId,
        options: CreateTransitGatewayConnectRequestOptions,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateTransitGatewayConnectResult:
        """Creates a Connect attachment from a specified transit gateway
        attachment. A Connect attachment is a GRE-based tunnel attachment that
        you can use to establish a connection between a transit gateway and an
        appliance.

        A Connect attachment uses an existing VPC or Amazon Web Services Direct
        Connect attachment as the underlying transport mechanism.

        :param transport_transit_gateway_attachment_id: The ID of the transit gateway attachment.
        :param options: The Connect attachment options.
        :param tag_specifications: The tags to apply to the Connect attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateTransitGatewayConnectResult
        """
        raise NotImplementedError

    @handler("CreateTransitGatewayConnectPeer")
    def create_transit_gateway_connect_peer(
        self,
        context: RequestContext,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        peer_address: String,
        inside_cidr_blocks: InsideCidrBlocksStringList,
        transit_gateway_address: String = None,
        bgp_options: TransitGatewayConnectRequestBgpOptions = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateTransitGatewayConnectPeerResult:
        """Creates a Connect peer for a specified transit gateway Connect
        attachment between a transit gateway and an appliance.

        The peer address and transit gateway address must be the same IP address
        family (IPv4 or IPv6).

        For more information, see `Connect
        peers <https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer>`__
        in the *Transit Gateways Guide*.

        :param transit_gateway_attachment_id: The ID of the Connect attachment.
        :param peer_address: The peer IP address (GRE outer IP address) on the appliance side of the
        Connect peer.
        :param inside_cidr_blocks: The range of inside IP addresses that are used for BGP peering.
        :param transit_gateway_address: The peer IP address (GRE outer IP address) on the transit gateway side
        of the Connect peer, which must be specified from a transit gateway CIDR
        block.
        :param bgp_options: The BGP options for the Connect peer.
        :param tag_specifications: The tags to apply to the Connect peer.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateTransitGatewayConnectPeerResult
        """
        raise NotImplementedError

    @handler("CreateTransitGatewayMulticastDomain")
    def create_transit_gateway_multicast_domain(
        self,
        context: RequestContext,
        transit_gateway_id: TransitGatewayId,
        options: CreateTransitGatewayMulticastDomainRequestOptions = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateTransitGatewayMulticastDomainResult:
        """Creates a multicast domain using the specified transit gateway.

        The transit gateway must be in the available state before you create a
        domain. Use
        `DescribeTransitGateways <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html>`__
        to see the state of transit gateway.

        :param transit_gateway_id: The ID of the transit gateway.
        :param options: The options for the transit gateway multicast domain.
        :param tag_specifications: The tags for the transit gateway multicast domain.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateTransitGatewayMulticastDomainResult
        """
        raise NotImplementedError

    @handler("CreateTransitGatewayPeeringAttachment")
    def create_transit_gateway_peering_attachment(
        self,
        context: RequestContext,
        transit_gateway_id: TransitGatewayId,
        peer_transit_gateway_id: TransitAssociationGatewayId,
        peer_account_id: String,
        peer_region: String,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateTransitGatewayPeeringAttachmentResult:
        """Requests a transit gateway peering attachment between the specified
        transit gateway (requester) and a peer transit gateway (accepter). The
        transit gateways must be in different Regions. The peer transit gateway
        can be in your account or a different Amazon Web Services account.

        After you create the peering attachment, the owner of the accepter
        transit gateway must accept the attachment request.

        :param transit_gateway_id: The ID of the transit gateway.
        :param peer_transit_gateway_id: The ID of the peer transit gateway with which to create the peering
        attachment.
        :param peer_account_id: The ID of the Amazon Web Services account that owns the peer transit
        gateway.
        :param peer_region: The Region where the peer transit gateway is located.
        :param tag_specifications: The tags to apply to the transit gateway peering attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateTransitGatewayPeeringAttachmentResult
        """
        raise NotImplementedError

    @handler("CreateTransitGatewayPrefixListReference")
    def create_transit_gateway_prefix_list_reference(
        self,
        context: RequestContext,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        prefix_list_id: PrefixListResourceId,
        transit_gateway_attachment_id: TransitGatewayAttachmentId = None,
        blackhole: Boolean = None,
        dry_run: Boolean = None,
    ) -> CreateTransitGatewayPrefixListReferenceResult:
        """Creates a reference (route) to a prefix list in a specified transit
        gateway route table.

        :param transit_gateway_route_table_id: The ID of the transit gateway route table.
        :param prefix_list_id: The ID of the prefix list that is used for destination matches.
        :param transit_gateway_attachment_id: The ID of the attachment to which traffic is routed.
        :param blackhole: Indicates whether to drop traffic that matches this route.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateTransitGatewayPrefixListReferenceResult
        """
        raise NotImplementedError

    @handler("CreateTransitGatewayRoute")
    def create_transit_gateway_route(
        self,
        context: RequestContext,
        destination_cidr_block: String,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        transit_gateway_attachment_id: TransitGatewayAttachmentId = None,
        blackhole: Boolean = None,
        dry_run: Boolean = None,
    ) -> CreateTransitGatewayRouteResult:
        """Creates a static route for the specified transit gateway route table.

        :param destination_cidr_block: The CIDR range used for destination matches.
        :param transit_gateway_route_table_id: The ID of the transit gateway route table.
        :param transit_gateway_attachment_id: The ID of the attachment.
        :param blackhole: Indicates whether to drop traffic that matches this route.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateTransitGatewayRouteResult
        """
        raise NotImplementedError

    @handler("CreateTransitGatewayRouteTable")
    def create_transit_gateway_route_table(
        self,
        context: RequestContext,
        transit_gateway_id: TransitGatewayId,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateTransitGatewayRouteTableResult:
        """Creates a route table for the specified transit gateway.

        :param transit_gateway_id: The ID of the transit gateway.
        :param tag_specifications: The tags to apply to the transit gateway route table.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateTransitGatewayRouteTableResult
        """
        raise NotImplementedError

    @handler("CreateTransitGatewayVpcAttachment")
    def create_transit_gateway_vpc_attachment(
        self,
        context: RequestContext,
        transit_gateway_id: TransitGatewayId,
        vpc_id: VpcId,
        subnet_ids: TransitGatewaySubnetIdList,
        options: CreateTransitGatewayVpcAttachmentRequestOptions = None,
        tag_specifications: TagSpecificationList = None,
        dry_run: Boolean = None,
    ) -> CreateTransitGatewayVpcAttachmentResult:
        """Attaches the specified VPC to the specified transit gateway.

        If you attach a VPC with a CIDR range that overlaps the CIDR range of a
        VPC that is already attached, the new VPC CIDR range is not propagated
        to the default propagation route table.

        To send VPC traffic to an attached transit gateway, add a route to the
        VPC route table using CreateRoute.

        :param transit_gateway_id: The ID of the transit gateway.
        :param vpc_id: The ID of the VPC.
        :param subnet_ids: The IDs of one or more subnets.
        :param options: The VPC attachment options.
        :param tag_specifications: The tags to apply to the VPC attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateTransitGatewayVpcAttachmentResult
        """
        raise NotImplementedError

    @handler("CreateVolume")
    def create_volume(
        self,
        context: RequestContext,
        availability_zone: String,
        encrypted: Boolean = None,
        iops: Integer = None,
        kms_key_id: KmsKeyId = None,
        outpost_arn: String = None,
        size: Integer = None,
        snapshot_id: SnapshotId = None,
        volume_type: VolumeType = None,
        dry_run: Boolean = None,
        tag_specifications: TagSpecificationList = None,
        multi_attach_enabled: Boolean = None,
        throughput: Integer = None,
        client_token: String = None,
    ) -> Volume:
        """Creates an EBS volume that can be attached to an instance in the same
        Availability Zone.

        You can create a new empty volume or restore a volume from an EBS
        snapshot. Any Amazon Web Services Marketplace product codes from the
        snapshot are propagated to the volume.

        You can create encrypted volumes. Encrypted volumes must be attached to
        instances that support Amazon EBS encryption. Volumes that are created
        from encrypted snapshots are also automatically encrypted. For more
        information, see `Amazon EBS
        encryption <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        You can tag your volumes during creation. For more information, see `Tag
        your Amazon EC2
        resources <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        For more information, see `Create an Amazon EBS
        volume <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param availability_zone: The Availability Zone in which to create the volume.
        :param encrypted: Indicates whether the volume should be encrypted.
        :param iops: The number of I/O operations per second (IOPS).
        :param kms_key_id: The identifier of the Key Management Service (KMS) KMS key to use for
        Amazon EBS encryption.
        :param outpost_arn: The Amazon Resource Name (ARN) of the Outpost.
        :param size: The size of the volume, in GiBs.
        :param snapshot_id: The snapshot from which to create the volume.
        :param volume_type: The volume type.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param tag_specifications: The tags to apply to the volume during creation.
        :param multi_attach_enabled: Indicates whether to enable Amazon EBS Multi-Attach.
        :param throughput: The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: Volume
        """
        raise NotImplementedError

    @handler("CreateVpc")
    def create_vpc(
        self,
        context: RequestContext,
        cidr_block: String = None,
        amazon_provided_ipv6_cidr_block: Boolean = None,
        ipv6_pool: Ipv6PoolEc2Id = None,
        ipv6_cidr_block: String = None,
        ipv4_ipam_pool_id: IpamPoolId = None,
        ipv4_netmask_length: NetmaskLength = None,
        ipv6_ipam_pool_id: IpamPoolId = None,
        ipv6_netmask_length: NetmaskLength = None,
        dry_run: Boolean = None,
        instance_tenancy: Tenancy = None,
        ipv6_cidr_block_network_border_group: String = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateVpcResult:
        """Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you
        can create uses a /28 netmask (16 IPv4 addresses), and the largest uses
        a /16 netmask (65,536 IPv4 addresses). For more information about how
        large to make your VPC, see `Your VPC and
        subnets <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        You can optionally request an IPv6 CIDR block for the VPC. You can
        request an Amazon-provided IPv6 CIDR block from Amazon's pool of IPv6
        addresses, or an IPv6 CIDR block from an IPv6 address pool that you
        provisioned through bring your own IP addresses
        (`BYOIP <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html>`__).

        By default, each instance you launch in the VPC has the default DHCP
        options, which include only a default DNS server that we provide
        (AmazonProvidedDNS). For more information, see `DHCP options
        sets <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        You can specify the instance tenancy value for the VPC when you create
        it. You can't change this value for the VPC after you create it. For
        more information, see `Dedicated
        Instances <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param cidr_block: The IPv4 network range for the VPC, in CIDR notation.
        :param amazon_provided_ipv6_cidr_block: Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
        the VPC.
        :param ipv6_pool: The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
        block.
        :param ipv6_cidr_block: The IPv6 CIDR block from the IPv6 address pool.
        :param ipv4_ipam_pool_id: The ID of an IPv4 IPAM pool you want to use for allocating this VPC's
        CIDR.
        :param ipv4_netmask_length: The netmask length of the IPv4 CIDR you want to allocate to this VPC
        from an Amazon VPC IP Address Manager (IPAM) pool.
        :param ipv6_ipam_pool_id: The ID of an IPv6 IPAM pool which will be used to allocate this VPC an
        IPv6 CIDR.
        :param ipv6_netmask_length: The netmask length of the IPv6 CIDR you want to allocate to this VPC
        from an Amazon VPC IP Address Manager (IPAM) pool.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param instance_tenancy: The tenancy options for instances launched into the VPC.
        :param ipv6_cidr_block_network_border_group: The name of the location from which we advertise the IPV6 CIDR block.
        :param tag_specifications: The tags to assign to the VPC.
        :returns: CreateVpcResult
        """
        raise NotImplementedError

    @handler("CreateVpcEndpoint")
    def create_vpc_endpoint(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        service_name: String,
        dry_run: Boolean = None,
        vpc_endpoint_type: VpcEndpointType = None,
        policy_document: String = None,
        route_table_ids: VpcEndpointRouteTableIdList = None,
        subnet_ids: VpcEndpointSubnetIdList = None,
        security_group_ids: VpcEndpointSecurityGroupIdList = None,
        client_token: String = None,
        private_dns_enabled: Boolean = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateVpcEndpointResult:
        """Creates a VPC endpoint for a specified service. An endpoint enables you
        to create a private connection between your VPC and the service. The
        service may be provided by Amazon Web Services, an Amazon Web Services
        Marketplace Partner, or another Amazon Web Services account. For more
        information, see `VPC
        Endpoints <https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        A ``gateway`` endpoint serves as a target for a route in your route
        table for traffic destined for the Amazon Web Service. You can specify
        an endpoint policy to attach to the endpoint, which will control access
        to the service from your VPC. You can also specify the VPC route tables
        that use the endpoint.

        An ``interface`` endpoint is a network interface in your subnet that
        serves as an endpoint for communicating with the specified service. You
        can specify the subnets in which to create an endpoint, and the security
        groups to associate with the endpoint network interface.

        A ``GatewayLoadBalancer`` endpoint is a network interface in your subnet
        that serves an endpoint for communicating with a Gateway Load Balancer
        that you've configured as a VPC endpoint service.

        Use DescribeVpcEndpointServices to get a list of supported services.

        :param vpc_id: The ID of the VPC in which the endpoint will be used.
        :param service_name: The service name.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param vpc_endpoint_type: The type of endpoint.
        :param policy_document: (Interface and gateway endpoints) A policy to attach to the endpoint
        that controls access to the service.
        :param route_table_ids: (Gateway endpoint) One or more route table IDs.
        :param subnet_ids: (Interface and Gateway Load Balancer endpoints) The ID of one or more
        subnets in which to create an endpoint network interface.
        :param security_group_ids: (Interface endpoint) The ID of one or more security groups to associate
        with the endpoint network interface.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param private_dns_enabled: (Interface endpoint) Indicates whether to associate a private hosted
        zone with the specified VPC.
        :param tag_specifications: The tags to associate with the endpoint.
        :returns: CreateVpcEndpointResult
        """
        raise NotImplementedError

    @handler("CreateVpcEndpointConnectionNotification")
    def create_vpc_endpoint_connection_notification(
        self,
        context: RequestContext,
        connection_notification_arn: String,
        connection_events: ValueStringList,
        dry_run: Boolean = None,
        service_id: VpcEndpointServiceId = None,
        vpc_endpoint_id: VpcEndpointId = None,
        client_token: String = None,
    ) -> CreateVpcEndpointConnectionNotificationResult:
        """Creates a connection notification for a specified VPC endpoint or VPC
        endpoint service. A connection notification notifies you of specific
        endpoint events. You must create an SNS topic to receive notifications.
        For more information, see `Create a
        Topic <https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html>`__ in
        the *Amazon Simple Notification Service Developer Guide*.

        You can create a connection notification for interface endpoints only.

        :param connection_notification_arn: The ARN of the SNS topic for the notifications.
        :param connection_events: One or more endpoint events for which to receive notifications.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param service_id: The ID of the endpoint service.
        :param vpc_endpoint_id: The ID of the endpoint.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :returns: CreateVpcEndpointConnectionNotificationResult
        """
        raise NotImplementedError

    @handler("CreateVpcEndpointServiceConfiguration")
    def create_vpc_endpoint_service_configuration(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        acceptance_required: Boolean = None,
        private_dns_name: String = None,
        network_load_balancer_arns: ValueStringList = None,
        gateway_load_balancer_arns: ValueStringList = None,
        client_token: String = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateVpcEndpointServiceConfigurationResult:
        """Creates a VPC endpoint service configuration to which service consumers
        (Amazon Web Services accounts, IAM users, and IAM roles) can connect.

        To create an endpoint service configuration, you must first create one
        of the following for your service:

        -  A `Network Load
           Balancer <https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html>`__.
           Service consumers connect to your service using an interface
           endpoint.

        -  A `Gateway Load
           Balancer <https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/introduction.html>`__.
           Service consumers connect to your service using a Gateway Load
           Balancer endpoint.

        For more information, see `VPC Endpoint
        Services <https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        If you set the private DNS name, you must prove that you own the private
        DNS domain name. For more information, see `VPC Endpoint Service Private
        DNS Name
        Verification <https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param acceptance_required: Indicates whether requests from service consumers to create an endpoint
        to your service must be accepted.
        :param private_dns_name: (Interface endpoint configuration) The private DNS name to assign to the
        VPC endpoint service.
        :param network_load_balancer_arns: The Amazon Resource Names (ARNs) of one or more Network Load Balancers
        for your service.
        :param gateway_load_balancer_arns: The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param tag_specifications: The tags to associate with the service.
        :returns: CreateVpcEndpointServiceConfigurationResult
        """
        raise NotImplementedError

    @handler("CreateVpcPeeringConnection")
    def create_vpc_peering_connection(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        peer_owner_id: String = None,
        peer_vpc_id: String = None,
        vpc_id: VpcId = None,
        peer_region: String = None,
        tag_specifications: TagSpecificationList = None,
    ) -> CreateVpcPeeringConnectionResult:
        """Requests a VPC peering connection between two VPCs: a requester VPC that
        you own and an accepter VPC with which to create the connection. The
        accepter VPC can belong to another Amazon Web Services account and can
        be in a different Region to the requester VPC. The requester VPC and
        accepter VPC cannot have overlapping CIDR blocks.

        Limitations and rules apply to a VPC peering connection. For more
        information, see the
        `limitations <https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations>`__
        section in the *VPC Peering Guide*.

        The owner of the accepter VPC must accept the peering request to
        activate the peering connection. The VPC peering connection request
        expires after 7 days, after which it cannot be accepted or rejected.

        If you create a VPC peering connection request between VPCs with
        overlapping CIDR blocks, the VPC peering connection has a status of
        ``failed``.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param peer_owner_id: The Amazon Web Services account ID of the owner of the accepter VPC.
        :param peer_vpc_id: The ID of the VPC with which you are creating the VPC peering
        connection.
        :param vpc_id: The ID of the requester VPC.
        :param peer_region: The Region code for the accepter VPC, if the accepter VPC is located in
        a Region other than the Region in which you make the request.
        :param tag_specifications: The tags to assign to the peering connection.
        :returns: CreateVpcPeeringConnectionResult
        """
        raise NotImplementedError

    @handler("CreateVpnConnection", expand=False)
    def create_vpn_connection(
        self, context: RequestContext, request: CreateVpnConnectionRequest
    ) -> CreateVpnConnectionResult:
        """Creates a VPN connection between an existing virtual private gateway or
        transit gateway and a customer gateway. The supported connection type is
        ``ipsec.1``.

        The response includes information that you need to give to your network
        administrator to configure your customer gateway.

        We strongly recommend that you use HTTPS when calling this operation
        because the response contains sensitive cryptographic information for
        configuring your customer gateway device.

        If you decide to shut down your VPN connection for any reason and later
        create a new VPN connection, you must reconfigure your customer gateway
        with the new information returned from this call.

        This is an idempotent operation. If you perform the operation more than
        once, Amazon EC2 doesn't return an error.

        For more information, see `Amazon Web Services Site-to-Site
        VPN <https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html>`__ in
        the *Amazon Web Services Site-to-Site VPN User Guide*.

        :param customer_gateway_id: The ID of the customer gateway.
        :param type: The type of VPN connection (``ipsec.
        :param vpn_gateway_id: The ID of the virtual private gateway.
        :param transit_gateway_id: The ID of the transit gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param options: The options for the VPN connection.
        :param tag_specifications: The tags to apply to the VPN connection.
        :returns: CreateVpnConnectionResult
        """
        raise NotImplementedError

    @handler("CreateVpnConnectionRoute")
    def create_vpn_connection_route(
        self,
        context: RequestContext,
        destination_cidr_block: String,
        vpn_connection_id: VpnConnectionId,
    ) -> None:
        """Creates a static route associated with a VPN connection between an
        existing virtual private gateway and a VPN customer gateway. The static
        route allows traffic to be routed from the virtual private gateway to
        the VPN customer gateway.

        For more information, see `Amazon Web Services Site-to-Site
        VPN <https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html>`__ in
        the *Amazon Web Services Site-to-Site VPN User Guide*.

        :param destination_cidr_block: The CIDR block associated with the local subnet of the customer network.
        :param vpn_connection_id: The ID of the VPN connection.
        """
        raise NotImplementedError

    @handler("CreateVpnGateway", expand=False)
    def create_vpn_gateway(
        self, context: RequestContext, request: CreateVpnGatewayRequest
    ) -> CreateVpnGatewayResult:
        """Creates a virtual private gateway. A virtual private gateway is the
        endpoint on the VPC side of your VPN connection. You can create a
        virtual private gateway before creating the VPC itself.

        For more information, see `Amazon Web Services Site-to-Site
        VPN <https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html>`__ in
        the *Amazon Web Services Site-to-Site VPN User Guide*.

        :param type: The type of VPN connection this virtual private gateway supports.
        :param availability_zone: The Availability Zone for the virtual private gateway.
        :param tag_specifications: The tags to apply to the virtual private gateway.
        :param amazon_side_asn: A private Autonomous System Number (ASN) for the Amazon side of a BGP
        session.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: CreateVpnGatewayResult
        """
        raise NotImplementedError

    @handler("DeleteCarrierGateway")
    def delete_carrier_gateway(
        self, context: RequestContext, carrier_gateway_id: CarrierGatewayId, dry_run: Boolean = None
    ) -> DeleteCarrierGatewayResult:
        """Deletes a carrier gateway.

        If you do not delete the route that contains the carrier gateway as the
        Target, the route is a blackhole route. For information about how to
        delete a route, see
        `DeleteRoute <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html>`__.

        :param carrier_gateway_id: The ID of the carrier gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteCarrierGatewayResult
        """
        raise NotImplementedError

    @handler("DeleteClientVpnEndpoint")
    def delete_client_vpn_endpoint(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        dry_run: Boolean = None,
    ) -> DeleteClientVpnEndpointResult:
        """Deletes the specified Client VPN endpoint. You must disassociate all
        target networks before you can delete a Client VPN endpoint.

        :param client_vpn_endpoint_id: The ID of the Client VPN to be deleted.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteClientVpnEndpointResult
        """
        raise NotImplementedError

    @handler("DeleteClientVpnRoute")
    def delete_client_vpn_route(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        destination_cidr_block: String,
        target_vpc_subnet_id: SubnetId = None,
        dry_run: Boolean = None,
    ) -> DeleteClientVpnRouteResult:
        """Deletes a route from a Client VPN endpoint. You can only delete routes
        that you manually added using the **CreateClientVpnRoute** action. You
        cannot delete routes that were automatically added when associating a
        subnet. To remove routes that have been automatically added,
        disassociate the target subnet from the Client VPN endpoint.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint from which the route is to be deleted.
        :param destination_cidr_block: The IPv4 address range, in CIDR notation, of the route to be deleted.
        :param target_vpc_subnet_id: The ID of the target subnet used by the route.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteClientVpnRouteResult
        """
        raise NotImplementedError

    @handler("DeleteCustomerGateway")
    def delete_customer_gateway(
        self,
        context: RequestContext,
        customer_gateway_id: CustomerGatewayId,
        dry_run: Boolean = None,
    ) -> None:
        """Deletes the specified customer gateway. You must delete the VPN
        connection before you can delete the customer gateway.

        :param customer_gateway_id: The ID of the customer gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteDhcpOptions")
    def delete_dhcp_options(
        self, context: RequestContext, dhcp_options_id: DhcpOptionsId, dry_run: Boolean = None
    ) -> None:
        """Deletes the specified set of DHCP options. You must disassociate the set
        of DHCP options before you can delete it. You can disassociate the set
        of DHCP options by associating either a new set of options or the
        default set of options with the VPC.

        :param dhcp_options_id: The ID of the DHCP options set.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteEgressOnlyInternetGateway")
    def delete_egress_only_internet_gateway(
        self,
        context: RequestContext,
        egress_only_internet_gateway_id: EgressOnlyInternetGatewayId,
        dry_run: Boolean = None,
    ) -> DeleteEgressOnlyInternetGatewayResult:
        """Deletes an egress-only internet gateway.

        :param egress_only_internet_gateway_id: The ID of the egress-only internet gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteEgressOnlyInternetGatewayResult
        """
        raise NotImplementedError

    @handler("DeleteFleets")
    def delete_fleets(
        self,
        context: RequestContext,
        fleet_ids: FleetIdSet,
        terminate_instances: Boolean,
        dry_run: Boolean = None,
    ) -> DeleteFleetsResult:
        """Deletes the specified EC2 Fleet.

        After you delete an EC2 Fleet, it launches no new instances.

        You must specify whether a deleted EC2 Fleet should also terminate its
        instances. If you choose to terminate the instances, the EC2 Fleet
        enters the ``deleted_terminating`` state. Otherwise, the EC2 Fleet
        enters the ``deleted_running`` state, and the instances continue to run
        until they are interrupted or you terminate them manually.

        For ``instant`` fleets, EC2 Fleet must terminate the instances when the
        fleet is deleted. A deleted ``instant`` fleet with running instances is
        not supported.

        **Restrictions**

        -  You can delete up to 25 ``instant`` fleets in a single request. If
           you exceed this number, no ``instant`` fleets are deleted and an
           error is returned. There is no restriction on the number of fleets of
           type ``maintain`` or ``request`` that can be deleted in a single
           request.

        -  Up to 1000 instances can be terminated in a single request to delete
           ``instant`` fleets.

        For more information, see `Deleting an EC2
        Fleet <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#delete-fleet>`__
        in the *Amazon EC2 User Guide*.

        :param fleet_ids: The IDs of the EC2 Fleets.
        :param terminate_instances: Indicates whether to terminate the instances when the EC2 Fleet is
        deleted.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteFleetsResult
        """
        raise NotImplementedError

    @handler("DeleteFlowLogs")
    def delete_flow_logs(
        self, context: RequestContext, flow_log_ids: FlowLogIdList, dry_run: Boolean = None
    ) -> DeleteFlowLogsResult:
        """Deletes one or more flow logs.

        :param flow_log_ids: One or more flow log IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteFlowLogsResult
        """
        raise NotImplementedError

    @handler("DeleteFpgaImage")
    def delete_fpga_image(
        self, context: RequestContext, fpga_image_id: FpgaImageId, dry_run: Boolean = None
    ) -> DeleteFpgaImageResult:
        """Deletes the specified Amazon FPGA Image (AFI).

        :param fpga_image_id: The ID of the AFI.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteFpgaImageResult
        """
        raise NotImplementedError

    @handler("DeleteInstanceEventWindow")
    def delete_instance_event_window(
        self,
        context: RequestContext,
        instance_event_window_id: InstanceEventWindowId,
        dry_run: Boolean = None,
        force_delete: Boolean = None,
    ) -> DeleteInstanceEventWindowResult:
        """Deletes the specified event window.

        For more information, see `Define event windows for scheduled
        events <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html>`__
        in the *Amazon EC2 User Guide*.

        :param instance_event_window_id: The ID of the event window.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param force_delete: Specify ``true`` to force delete the event window.
        :returns: DeleteInstanceEventWindowResult
        """
        raise NotImplementedError

    @handler("DeleteInternetGateway")
    def delete_internet_gateway(
        self,
        context: RequestContext,
        internet_gateway_id: InternetGatewayId,
        dry_run: Boolean = None,
    ) -> None:
        """Deletes the specified internet gateway. You must detach the internet
        gateway from the VPC before you can delete it.

        :param internet_gateway_id: The ID of the internet gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteIpam")
    def delete_ipam(
        self, context: RequestContext, ipam_id: IpamId, dry_run: Boolean = None
    ) -> DeleteIpamResult:
        """Delete an IPAM. Deleting an IPAM removes all monitored data associated
        with the IPAM including the historical data for CIDRs.

        You cannot delete an IPAM if there are CIDRs provisioned to pools or if
        there are allocations in the pools within the IPAM. To deprovision pool
        CIDRs, see
        `DeprovisionIpamPoolCidr <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html>`__.
        To release allocations, see
        `ReleaseIpamPoolAllocation <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html>`__.

        For more information, see `Delete an
        IPAM </vpc/latest/ipam/delete-ipam.html>`__ in the *Amazon VPC IPAM User
        Guide*.

        :param ipam_id: The ID of the IPAM to delete.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :returns: DeleteIpamResult
        """
        raise NotImplementedError

    @handler("DeleteIpamPool")
    def delete_ipam_pool(
        self, context: RequestContext, ipam_pool_id: IpamPoolId, dry_run: Boolean = None
    ) -> DeleteIpamPoolResult:
        """Delete an IPAM pool.

        You cannot delete an IPAM pool if there are allocations in it or CIDRs
        provisioned to it. To release allocations, see
        `ReleaseIpamPoolAllocation <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html>`__.
        To deprovision pool CIDRs, see
        `DeprovisionIpamPoolCidr <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html>`__.

        For more information, see `Delete a
        pool </vpc/latest/ipam/delete-pool-ipam.html>`__ in the *Amazon VPC IPAM
        User Guide*.

        :param ipam_pool_id: The ID of the pool to delete.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :returns: DeleteIpamPoolResult
        """
        raise NotImplementedError

    @handler("DeleteIpamScope")
    def delete_ipam_scope(
        self, context: RequestContext, ipam_scope_id: IpamScopeId, dry_run: Boolean = None
    ) -> DeleteIpamScopeResult:
        """Delete the scope for an IPAM. You cannot delete the default scopes.

        For more information, see `Delete a
        scope </vpc/latest/ipam/delete-scope-ipam.html>`__ in the *Amazon VPC
        IPAM User Guide*.

        :param ipam_scope_id: The ID of the scope to delete.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :returns: DeleteIpamScopeResult
        """
        raise NotImplementedError

    @handler("DeleteKeyPair")
    def delete_key_pair(
        self,
        context: RequestContext,
        key_name: KeyPairName = None,
        key_pair_id: KeyPairId = None,
        dry_run: Boolean = None,
    ) -> None:
        """Deletes the specified key pair, by removing the public key from Amazon
        EC2.

        :param key_name: The name of the key pair.
        :param key_pair_id: The ID of the key pair.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteLaunchTemplate")
    def delete_launch_template(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        launch_template_id: LaunchTemplateId = None,
        launch_template_name: LaunchTemplateName = None,
    ) -> DeleteLaunchTemplateResult:
        """Deletes a launch template. Deleting a launch template deletes all of its
        versions.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param launch_template_id: The ID of the launch template.
        :param launch_template_name: The name of the launch template.
        :returns: DeleteLaunchTemplateResult
        """
        raise NotImplementedError

    @handler("DeleteLaunchTemplateVersions")
    def delete_launch_template_versions(
        self,
        context: RequestContext,
        versions: VersionStringList,
        dry_run: Boolean = None,
        launch_template_id: LaunchTemplateId = None,
        launch_template_name: LaunchTemplateName = None,
    ) -> DeleteLaunchTemplateVersionsResult:
        """Deletes one or more versions of a launch template. You cannot delete the
        default version of a launch template; you must first assign a different
        version as the default. If the default version is the only version for
        the launch template, you must delete the entire launch template using
        DeleteLaunchTemplate.

        :param versions: The version numbers of one or more launch template versions to delete.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param launch_template_id: The ID of the launch template.
        :param launch_template_name: The name of the launch template.
        :returns: DeleteLaunchTemplateVersionsResult
        """
        raise NotImplementedError

    @handler("DeleteLocalGatewayRoute")
    def delete_local_gateway_route(
        self,
        context: RequestContext,
        destination_cidr_block: String,
        local_gateway_route_table_id: LocalGatewayRoutetableId,
        dry_run: Boolean = None,
    ) -> DeleteLocalGatewayRouteResult:
        """Deletes the specified route from the specified local gateway route
        table.

        :param destination_cidr_block: The CIDR range for the route.
        :param local_gateway_route_table_id: The ID of the local gateway route table.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteLocalGatewayRouteResult
        """
        raise NotImplementedError

    @handler("DeleteLocalGatewayRouteTableVpcAssociation")
    def delete_local_gateway_route_table_vpc_association(
        self,
        context: RequestContext,
        local_gateway_route_table_vpc_association_id: LocalGatewayRouteTableVpcAssociationId,
        dry_run: Boolean = None,
    ) -> DeleteLocalGatewayRouteTableVpcAssociationResult:
        """Deletes the specified association between a VPC and local gateway route
        table.

        :param local_gateway_route_table_vpc_association_id: The ID of the association.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteLocalGatewayRouteTableVpcAssociationResult
        """
        raise NotImplementedError

    @handler("DeleteManagedPrefixList")
    def delete_managed_prefix_list(
        self, context: RequestContext, prefix_list_id: PrefixListResourceId, dry_run: Boolean = None
    ) -> DeleteManagedPrefixListResult:
        """Deletes the specified managed prefix list. You must first remove all
        references to the prefix list in your resources.

        :param prefix_list_id: The ID of the prefix list.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteManagedPrefixListResult
        """
        raise NotImplementedError

    @handler("DeleteNatGateway")
    def delete_nat_gateway(
        self, context: RequestContext, nat_gateway_id: NatGatewayId, dry_run: Boolean = None
    ) -> DeleteNatGatewayResult:
        """Deletes the specified NAT gateway. Deleting a public NAT gateway
        disassociates its Elastic IP address, but does not release the address
        from your account. Deleting a NAT gateway does not delete any NAT
        gateway routes in your route tables.

        :param nat_gateway_id: The ID of the NAT gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteNatGatewayResult
        """
        raise NotImplementedError

    @handler("DeleteNetworkAcl")
    def delete_network_acl(
        self, context: RequestContext, network_acl_id: NetworkAclId, dry_run: Boolean = None
    ) -> None:
        """Deletes the specified network ACL. You can't delete the ACL if it's
        associated with any subnets. You can't delete the default network ACL.

        :param network_acl_id: The ID of the network ACL.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteNetworkAclEntry")
    def delete_network_acl_entry(
        self,
        context: RequestContext,
        egress: Boolean,
        network_acl_id: NetworkAclId,
        rule_number: Integer,
        dry_run: Boolean = None,
    ) -> None:
        """Deletes the specified ingress or egress entry (rule) from the specified
        network ACL.

        :param egress: Indicates whether the rule is an egress rule.
        :param network_acl_id: The ID of the network ACL.
        :param rule_number: The rule number of the entry to delete.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteNetworkInsightsAccessScope")
    def delete_network_insights_access_scope(
        self,
        context: RequestContext,
        network_insights_access_scope_id: NetworkInsightsAccessScopeId,
        dry_run: Boolean = None,
    ) -> DeleteNetworkInsightsAccessScopeResult:
        """Deletes the specified Network Access Scope.

        :param network_insights_access_scope_id: The ID of the Network Access Scope.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteNetworkInsightsAccessScopeResult
        """
        raise NotImplementedError

    @handler("DeleteNetworkInsightsAccessScopeAnalysis")
    def delete_network_insights_access_scope_analysis(
        self,
        context: RequestContext,
        network_insights_access_scope_analysis_id: NetworkInsightsAccessScopeAnalysisId,
        dry_run: Boolean = None,
    ) -> DeleteNetworkInsightsAccessScopeAnalysisResult:
        """Deletes the specified Network Access Scope analysis.

        :param network_insights_access_scope_analysis_id: The ID of the Network Access Scope analysis.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteNetworkInsightsAccessScopeAnalysisResult
        """
        raise NotImplementedError

    @handler("DeleteNetworkInsightsAnalysis")
    def delete_network_insights_analysis(
        self,
        context: RequestContext,
        network_insights_analysis_id: NetworkInsightsAnalysisId,
        dry_run: Boolean = None,
    ) -> DeleteNetworkInsightsAnalysisResult:
        """Deletes the specified network insights analysis.

        :param network_insights_analysis_id: The ID of the network insights analysis.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteNetworkInsightsAnalysisResult
        """
        raise NotImplementedError

    @handler("DeleteNetworkInsightsPath")
    def delete_network_insights_path(
        self,
        context: RequestContext,
        network_insights_path_id: NetworkInsightsPathId,
        dry_run: Boolean = None,
    ) -> DeleteNetworkInsightsPathResult:
        """Deletes the specified path.

        :param network_insights_path_id: The ID of the path.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteNetworkInsightsPathResult
        """
        raise NotImplementedError

    @handler("DeleteNetworkInterface")
    def delete_network_interface(
        self,
        context: RequestContext,
        network_interface_id: NetworkInterfaceId,
        dry_run: Boolean = None,
    ) -> None:
        """Deletes the specified network interface. You must detach the network
        interface before you can delete it.

        :param network_interface_id: The ID of the network interface.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteNetworkInterfacePermission")
    def delete_network_interface_permission(
        self,
        context: RequestContext,
        network_interface_permission_id: NetworkInterfacePermissionId,
        force: Boolean = None,
        dry_run: Boolean = None,
    ) -> DeleteNetworkInterfacePermissionResult:
        """Deletes a permission for a network interface. By default, you cannot
        delete the permission if the account for which you're removing the
        permission has attached the network interface to an instance. However,
        you can force delete the permission, regardless of any attachment.

        :param network_interface_permission_id: The ID of the network interface permission.
        :param force: Specify ``true`` to remove the permission even if the network interface
        is attached to an instance.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteNetworkInterfacePermissionResult
        """
        raise NotImplementedError

    @handler("DeletePlacementGroup")
    def delete_placement_group(
        self, context: RequestContext, group_name: PlacementGroupName, dry_run: Boolean = None
    ) -> None:
        """Deletes the specified placement group. You must terminate all instances
        in the placement group before you can delete the placement group. For
        more information, see `Placement
        groups <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html>`__
        in the *Amazon EC2 User Guide*.

        :param group_name: The name of the placement group.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeletePublicIpv4Pool")
    def delete_public_ipv4_pool(
        self, context: RequestContext, pool_id: Ipv4PoolEc2Id, dry_run: Boolean = None
    ) -> DeletePublicIpv4PoolResult:
        """Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool
        required for the public IPv4 CIDRs that you own and bring to Amazon Web
        Services to manage with IPAM. IPv6 addresses you bring to Amazon Web
        Services, however, use IPAM pools only.

        :param pool_id: The ID of the public IPv4 pool you want to delete.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :returns: DeletePublicIpv4PoolResult
        """
        raise NotImplementedError

    @handler("DeleteQueuedReservedInstances")
    def delete_queued_reserved_instances(
        self,
        context: RequestContext,
        reserved_instances_ids: DeleteQueuedReservedInstancesIdList,
        dry_run: Boolean = None,
    ) -> DeleteQueuedReservedInstancesResult:
        """Deletes the queued purchases for the specified Reserved Instances.

        :param reserved_instances_ids: The IDs of the Reserved Instances.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteQueuedReservedInstancesResult
        """
        raise NotImplementedError

    @handler("DeleteRoute")
    def delete_route(
        self,
        context: RequestContext,
        route_table_id: RouteTableId,
        destination_cidr_block: String = None,
        destination_ipv6_cidr_block: String = None,
        destination_prefix_list_id: PrefixListResourceId = None,
        dry_run: Boolean = None,
    ) -> None:
        """Deletes the specified route from the specified route table.

        :param route_table_id: The ID of the route table.
        :param destination_cidr_block: The IPv4 CIDR range for the route.
        :param destination_ipv6_cidr_block: The IPv6 CIDR range for the route.
        :param destination_prefix_list_id: The ID of the prefix list for the route.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteRouteTable")
    def delete_route_table(
        self, context: RequestContext, route_table_id: RouteTableId, dry_run: Boolean = None
    ) -> None:
        """Deletes the specified route table. You must disassociate the route table
        from any subnets before you can delete it. You can't delete the main
        route table.

        :param route_table_id: The ID of the route table.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteSecurityGroup")
    def delete_security_group(
        self,
        context: RequestContext,
        group_id: SecurityGroupId = None,
        group_name: SecurityGroupName = None,
        dry_run: Boolean = None,
    ) -> None:
        """Deletes a security group.

        If you attempt to delete a security group that is associated with an
        instance, or is referenced by another security group, the operation
        fails with ``InvalidGroup.InUse`` in EC2-Classic or
        ``DependencyViolation`` in EC2-VPC.

        :param group_id: The ID of the security group.
        :param group_name: [EC2-Classic, default VPC] The name of the security group.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteSnapshot")
    def delete_snapshot(
        self, context: RequestContext, snapshot_id: SnapshotId, dry_run: Boolean = None
    ) -> None:
        """Deletes the specified snapshot.

        When you make periodic snapshots of a volume, the snapshots are
        incremental, and only the blocks on the device that have changed since
        your last snapshot are saved in the new snapshot. When you delete a
        snapshot, only the data not needed for any other snapshot is removed. So
        regardless of which prior snapshots have been deleted, all active
        snapshots will have access to all the information needed to restore the
        volume.

        You cannot delete a snapshot of the root device of an EBS volume used by
        a registered AMI. You must first de-register the AMI before you can
        delete the snapshot.

        For more information, see `Delete an Amazon EBS
        snapshot <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param snapshot_id: The ID of the EBS snapshot.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteSpotDatafeedSubscription")
    def delete_spot_datafeed_subscription(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> None:
        """Deletes the data feed for Spot Instances.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteSubnet")
    def delete_subnet(
        self, context: RequestContext, subnet_id: SubnetId, dry_run: Boolean = None
    ) -> None:
        """Deletes the specified subnet. You must terminate all running instances
        in the subnet before you can delete the subnet.

        :param subnet_id: The ID of the subnet.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteSubnetCidrReservation")
    def delete_subnet_cidr_reservation(
        self,
        context: RequestContext,
        subnet_cidr_reservation_id: SubnetCidrReservationId,
        dry_run: Boolean = None,
    ) -> DeleteSubnetCidrReservationResult:
        """Deletes a subnet CIDR reservation.

        :param subnet_cidr_reservation_id: The ID of the subnet CIDR reservation.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteSubnetCidrReservationResult
        """
        raise NotImplementedError

    @handler("DeleteTags")
    def delete_tags(
        self,
        context: RequestContext,
        resources: ResourceIdList,
        dry_run: Boolean = None,
        tags: TagList = None,
    ) -> None:
        """Deletes the specified set of tags from the specified set of resources.

        To list the current tags, use DescribeTags. For more information about
        tags, see `Tagging Your
        Resources <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param resources: The IDs of the resources, separated by spaces.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param tags: The tags to delete.
        """
        raise NotImplementedError

    @handler("DeleteTrafficMirrorFilter")
    def delete_traffic_mirror_filter(
        self,
        context: RequestContext,
        traffic_mirror_filter_id: TrafficMirrorFilterId,
        dry_run: Boolean = None,
    ) -> DeleteTrafficMirrorFilterResult:
        """Deletes the specified Traffic Mirror filter.

        You cannot delete a Traffic Mirror filter that is in use by a Traffic
        Mirror session.

        :param traffic_mirror_filter_id: The ID of the Traffic Mirror filter.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTrafficMirrorFilterResult
        """
        raise NotImplementedError

    @handler("DeleteTrafficMirrorFilterRule")
    def delete_traffic_mirror_filter_rule(
        self,
        context: RequestContext,
        traffic_mirror_filter_rule_id: TrafficMirrorFilterRuleId,
        dry_run: Boolean = None,
    ) -> DeleteTrafficMirrorFilterRuleResult:
        """Deletes the specified Traffic Mirror rule.

        :param traffic_mirror_filter_rule_id: The ID of the Traffic Mirror rule.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTrafficMirrorFilterRuleResult
        """
        raise NotImplementedError

    @handler("DeleteTrafficMirrorSession")
    def delete_traffic_mirror_session(
        self,
        context: RequestContext,
        traffic_mirror_session_id: TrafficMirrorSessionId,
        dry_run: Boolean = None,
    ) -> DeleteTrafficMirrorSessionResult:
        """Deletes the specified Traffic Mirror session.

        :param traffic_mirror_session_id: The ID of the Traffic Mirror session.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTrafficMirrorSessionResult
        """
        raise NotImplementedError

    @handler("DeleteTrafficMirrorTarget")
    def delete_traffic_mirror_target(
        self,
        context: RequestContext,
        traffic_mirror_target_id: TrafficMirrorTargetId,
        dry_run: Boolean = None,
    ) -> DeleteTrafficMirrorTargetResult:
        """Deletes the specified Traffic Mirror target.

        You cannot delete a Traffic Mirror target that is in use by a Traffic
        Mirror session.

        :param traffic_mirror_target_id: The ID of the Traffic Mirror target.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTrafficMirrorTargetResult
        """
        raise NotImplementedError

    @handler("DeleteTransitGateway")
    def delete_transit_gateway(
        self, context: RequestContext, transit_gateway_id: TransitGatewayId, dry_run: Boolean = None
    ) -> DeleteTransitGatewayResult:
        """Deletes the specified transit gateway.

        :param transit_gateway_id: The ID of the transit gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTransitGatewayResult
        """
        raise NotImplementedError

    @handler("DeleteTransitGatewayConnect")
    def delete_transit_gateway_connect(
        self,
        context: RequestContext,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        dry_run: Boolean = None,
    ) -> DeleteTransitGatewayConnectResult:
        """Deletes the specified Connect attachment. You must first delete any
        Connect peers for the attachment.

        :param transit_gateway_attachment_id: The ID of the Connect attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTransitGatewayConnectResult
        """
        raise NotImplementedError

    @handler("DeleteTransitGatewayConnectPeer")
    def delete_transit_gateway_connect_peer(
        self,
        context: RequestContext,
        transit_gateway_connect_peer_id: TransitGatewayConnectPeerId,
        dry_run: Boolean = None,
    ) -> DeleteTransitGatewayConnectPeerResult:
        """Deletes the specified Connect peer.

        :param transit_gateway_connect_peer_id: The ID of the Connect peer.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTransitGatewayConnectPeerResult
        """
        raise NotImplementedError

    @handler("DeleteTransitGatewayMulticastDomain")
    def delete_transit_gateway_multicast_domain(
        self,
        context: RequestContext,
        transit_gateway_multicast_domain_id: TransitGatewayMulticastDomainId,
        dry_run: Boolean = None,
    ) -> DeleteTransitGatewayMulticastDomainResult:
        """Deletes the specified transit gateway multicast domain.

        :param transit_gateway_multicast_domain_id: The ID of the transit gateway multicast domain.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTransitGatewayMulticastDomainResult
        """
        raise NotImplementedError

    @handler("DeleteTransitGatewayPeeringAttachment")
    def delete_transit_gateway_peering_attachment(
        self,
        context: RequestContext,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        dry_run: Boolean = None,
    ) -> DeleteTransitGatewayPeeringAttachmentResult:
        """Deletes a transit gateway peering attachment.

        :param transit_gateway_attachment_id: The ID of the transit gateway peering attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTransitGatewayPeeringAttachmentResult
        """
        raise NotImplementedError

    @handler("DeleteTransitGatewayPrefixListReference")
    def delete_transit_gateway_prefix_list_reference(
        self,
        context: RequestContext,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        prefix_list_id: PrefixListResourceId,
        dry_run: Boolean = None,
    ) -> DeleteTransitGatewayPrefixListReferenceResult:
        """Deletes a reference (route) to a prefix list in a specified transit
        gateway route table.

        :param transit_gateway_route_table_id: The ID of the route table.
        :param prefix_list_id: The ID of the prefix list.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTransitGatewayPrefixListReferenceResult
        """
        raise NotImplementedError

    @handler("DeleteTransitGatewayRoute")
    def delete_transit_gateway_route(
        self,
        context: RequestContext,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        destination_cidr_block: String,
        dry_run: Boolean = None,
    ) -> DeleteTransitGatewayRouteResult:
        """Deletes the specified route from the specified transit gateway route
        table.

        :param transit_gateway_route_table_id: The ID of the transit gateway route table.
        :param destination_cidr_block: The CIDR range for the route.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTransitGatewayRouteResult
        """
        raise NotImplementedError

    @handler("DeleteTransitGatewayRouteTable")
    def delete_transit_gateway_route_table(
        self,
        context: RequestContext,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        dry_run: Boolean = None,
    ) -> DeleteTransitGatewayRouteTableResult:
        """Deletes the specified transit gateway route table. You must disassociate
        the route table from any transit gateway route tables before you can
        delete it.

        :param transit_gateway_route_table_id: The ID of the transit gateway route table.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTransitGatewayRouteTableResult
        """
        raise NotImplementedError

    @handler("DeleteTransitGatewayVpcAttachment")
    def delete_transit_gateway_vpc_attachment(
        self,
        context: RequestContext,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        dry_run: Boolean = None,
    ) -> DeleteTransitGatewayVpcAttachmentResult:
        """Deletes the specified VPC attachment.

        :param transit_gateway_attachment_id: The ID of the attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteTransitGatewayVpcAttachmentResult
        """
        raise NotImplementedError

    @handler("DeleteVolume")
    def delete_volume(
        self, context: RequestContext, volume_id: VolumeId, dry_run: Boolean = None
    ) -> None:
        """Deletes the specified EBS volume. The volume must be in the
        ``available`` state (not attached to an instance).

        The volume can remain in the ``deleting`` state for several minutes.

        For more information, see `Delete an Amazon EBS
        volume <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param volume_id: The ID of the volume.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteVpc")
    def delete_vpc(self, context: RequestContext, vpc_id: VpcId, dry_run: Boolean = None) -> None:
        """Deletes the specified VPC. You must detach or delete all gateways and
        resources that are associated with the VPC before you can delete it. For
        example, you must terminate all instances running in the VPC, delete all
        security groups associated with the VPC (except the default one), delete
        all route tables associated with the VPC (except the default one), and
        so on.

        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteVpcEndpointConnectionNotifications")
    def delete_vpc_endpoint_connection_notifications(
        self,
        context: RequestContext,
        connection_notification_ids: ConnectionNotificationIdsList,
        dry_run: Boolean = None,
    ) -> DeleteVpcEndpointConnectionNotificationsResult:
        """Deletes one or more VPC endpoint connection notifications.

        :param connection_notification_ids: One or more notification IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteVpcEndpointConnectionNotificationsResult
        """
        raise NotImplementedError

    @handler("DeleteVpcEndpointServiceConfigurations")
    def delete_vpc_endpoint_service_configurations(
        self,
        context: RequestContext,
        service_ids: VpcEndpointServiceIdList,
        dry_run: Boolean = None,
    ) -> DeleteVpcEndpointServiceConfigurationsResult:
        """Deletes one or more VPC endpoint service configurations in your account.
        Before you delete the endpoint service configuration, you must reject
        any ``Available`` or ``PendingAcceptance`` interface endpoint
        connections that are attached to the service.

        :param service_ids: The IDs of one or more services.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteVpcEndpointServiceConfigurationsResult
        """
        raise NotImplementedError

    @handler("DeleteVpcEndpoints")
    def delete_vpc_endpoints(
        self, context: RequestContext, vpc_endpoint_ids: VpcEndpointIdList, dry_run: Boolean = None
    ) -> DeleteVpcEndpointsResult:
        """Deletes one or more specified VPC endpoints. You can delete any of the
        following types of VPC endpoints.

        -  Gateway endpoint,

        -  Gateway Load Balancer endpoint,

        -  Interface endpoint

        The following rules apply when you delete a VPC endpoint:

        -  When you delete a gateway endpoint, we delete the endpoint routes in
           the route tables that are associated with the endpoint.

        -  When you delete a Gateway Load Balancer endpoint, we delete the
           endpoint network interfaces.

           You can only delete Gateway Load Balancer endpoints when the routes
           that are associated with the endpoint are deleted.

        -  When you delete an interface endpoint, we delete the endpoint network
           interfaces.

        :param vpc_endpoint_ids: One or more VPC endpoint IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteVpcEndpointsResult
        """
        raise NotImplementedError

    @handler("DeleteVpcPeeringConnection")
    def delete_vpc_peering_connection(
        self,
        context: RequestContext,
        vpc_peering_connection_id: VpcPeeringConnectionId,
        dry_run: Boolean = None,
    ) -> DeleteVpcPeeringConnectionResult:
        """Deletes a VPC peering connection. Either the owner of the requester VPC
        or the owner of the accepter VPC can delete the VPC peering connection
        if it's in the ``active`` state. The owner of the requester VPC can
        delete a VPC peering connection in the ``pending-acceptance`` state. You
        cannot delete a VPC peering connection that's in the ``failed`` state.

        :param vpc_peering_connection_id: The ID of the VPC peering connection.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeleteVpcPeeringConnectionResult
        """
        raise NotImplementedError

    @handler("DeleteVpnConnection")
    def delete_vpn_connection(
        self, context: RequestContext, vpn_connection_id: VpnConnectionId, dry_run: Boolean = None
    ) -> None:
        """Deletes the specified VPN connection.

        If you're deleting the VPC and its associated components, we recommend
        that you detach the virtual private gateway from the VPC and delete the
        VPC before deleting the VPN connection. If you believe that the tunnel
        credentials for your VPN connection have been compromised, you can
        delete the VPN connection and create a new one that has new keys,
        without needing to delete the VPC or virtual private gateway. If you
        create a new VPN connection, you must reconfigure the customer gateway
        device using the new configuration information returned with the new VPN
        connection ID.

        For certificate-based authentication, delete all Certificate Manager
        (ACM) private certificates used for the Amazon Web Services-side tunnel
        endpoints for the VPN connection before deleting the VPN connection.

        :param vpn_connection_id: The ID of the VPN connection.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeleteVpnConnectionRoute")
    def delete_vpn_connection_route(
        self,
        context: RequestContext,
        destination_cidr_block: String,
        vpn_connection_id: VpnConnectionId,
    ) -> None:
        """Deletes the specified static route associated with a VPN connection
        between an existing virtual private gateway and a VPN customer gateway.
        The static route allows traffic to be routed from the virtual private
        gateway to the VPN customer gateway.

        :param destination_cidr_block: The CIDR block associated with the local subnet of the customer network.
        :param vpn_connection_id: The ID of the VPN connection.
        """
        raise NotImplementedError

    @handler("DeleteVpnGateway")
    def delete_vpn_gateway(
        self, context: RequestContext, vpn_gateway_id: VpnGatewayId, dry_run: Boolean = None
    ) -> None:
        """Deletes the specified virtual private gateway. You must first detach the
        virtual private gateway from the VPC. Note that you don't need to delete
        the virtual private gateway if you plan to delete and recreate the VPN
        connection between your VPC and your network.

        :param vpn_gateway_id: The ID of the virtual private gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeprovisionByoipCidr")
    def deprovision_byoip_cidr(
        self, context: RequestContext, cidr: String, dry_run: Boolean = None
    ) -> DeprovisionByoipCidrResult:
        """Releases the specified address range that you provisioned for use with
        your Amazon Web Services resources through bring your own IP addresses
        (BYOIP) and deletes the corresponding address pool.

        Before you can release an address range, you must stop advertising it
        using WithdrawByoipCidr and you must not have any IP addresses allocated
        from its address range.

        :param cidr: The address range, in CIDR notation.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeprovisionByoipCidrResult
        """
        raise NotImplementedError

    @handler("DeprovisionIpamPoolCidr")
    def deprovision_ipam_pool_cidr(
        self,
        context: RequestContext,
        ipam_pool_id: IpamPoolId,
        dry_run: Boolean = None,
        cidr: String = None,
    ) -> DeprovisionIpamPoolCidrResult:
        """Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a
        CIDR from a pool that has a source pool, the CIDR is recycled back into
        the source pool. For more information, see `Deprovision pool
        CIDRs </vpc/latest/ipam/depro-pool-cidr-ipam.html>`__ in the *Amazon VPC
        IPAM User Guide*.

        :param ipam_pool_id: The ID of the pool that has the CIDR you want to deprovision.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :param cidr: The CIDR which you want to deprovision from the pool.
        :returns: DeprovisionIpamPoolCidrResult
        """
        raise NotImplementedError

    @handler("DeprovisionPublicIpv4PoolCidr")
    def deprovision_public_ipv4_pool_cidr(
        self, context: RequestContext, pool_id: Ipv4PoolEc2Id, cidr: String, dry_run: Boolean = None
    ) -> DeprovisionPublicIpv4PoolCidrResult:
        """Deprovision a CIDR from a public IPv4 pool.

        :param pool_id: The ID of the pool that you want to deprovision the CIDR from.
        :param cidr: The CIDR you want to deprovision from the pool.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :returns: DeprovisionPublicIpv4PoolCidrResult
        """
        raise NotImplementedError

    @handler("DeregisterImage")
    def deregister_image(
        self, context: RequestContext, image_id: ImageId, dry_run: Boolean = None
    ) -> None:
        """Deregisters the specified AMI. After you deregister an AMI, it can't be
        used to launch new instances; however, it doesn't affect any instances
        that you've already launched from the AMI. You'll continue to incur
        usage costs for those instances until you terminate them.

        When you deregister an Amazon EBS-backed AMI, it doesn't affect the
        snapshot that was created for the root volume of the instance during the
        AMI creation process. When you deregister an instance store-backed AMI,
        it doesn't affect the files that you uploaded to Amazon S3 when you
        created the AMI.

        :param image_id: The ID of the AMI.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DeregisterInstanceEventNotificationAttributes")
    def deregister_instance_event_notification_attributes(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        instance_tag_attribute: DeregisterInstanceTagAttributeRequest = None,
    ) -> DeregisterInstanceEventNotificationAttributesResult:
        """c

        Deregisters tag keys to prevent tags that have the specified tag keys
        from being included in scheduled event notifications for resources in
        the Region.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param instance_tag_attribute: Information about the tag keys to deregister.
        :returns: DeregisterInstanceEventNotificationAttributesResult
        """
        raise NotImplementedError

    @handler("DeregisterTransitGatewayMulticastGroupMembers")
    def deregister_transit_gateway_multicast_group_members(
        self,
        context: RequestContext,
        transit_gateway_multicast_domain_id: TransitGatewayMulticastDomainId = None,
        group_ip_address: String = None,
        network_interface_ids: TransitGatewayNetworkInterfaceIdList = None,
        dry_run: Boolean = None,
    ) -> DeregisterTransitGatewayMulticastGroupMembersResult:
        """Deregisters the specified members (network interfaces) from the transit
        gateway multicast group.

        :param transit_gateway_multicast_domain_id: The ID of the transit gateway multicast domain.
        :param group_ip_address: The IP address assigned to the transit gateway multicast group.
        :param network_interface_ids: The IDs of the group members' network interfaces.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeregisterTransitGatewayMulticastGroupMembersResult
        """
        raise NotImplementedError

    @handler("DeregisterTransitGatewayMulticastGroupSources")
    def deregister_transit_gateway_multicast_group_sources(
        self,
        context: RequestContext,
        transit_gateway_multicast_domain_id: TransitGatewayMulticastDomainId = None,
        group_ip_address: String = None,
        network_interface_ids: TransitGatewayNetworkInterfaceIdList = None,
        dry_run: Boolean = None,
    ) -> DeregisterTransitGatewayMulticastGroupSourcesResult:
        """Deregisters the specified sources (network interfaces) from the transit
        gateway multicast group.

        :param transit_gateway_multicast_domain_id: The ID of the transit gateway multicast domain.
        :param group_ip_address: The IP address assigned to the transit gateway multicast group.
        :param network_interface_ids: The IDs of the group sources' network interfaces.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DeregisterTransitGatewayMulticastGroupSourcesResult
        """
        raise NotImplementedError

    @handler("DescribeAccountAttributes")
    def describe_account_attributes(
        self,
        context: RequestContext,
        attribute_names: AccountAttributeNameStringList = None,
        dry_run: Boolean = None,
    ) -> DescribeAccountAttributesResult:
        """Describes attributes of your Amazon Web Services account. The following
        are the supported account attributes:

        -  ``supported-platforms``: Indicates whether your account can launch
           instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.

        -  ``default-vpc``: The ID of the default VPC for your account, or
           ``none``.

        -  ``max-instances``: This attribute is no longer supported. The
           returned value does not reflect your actual vCPU limit for running
           On-Demand Instances. For more information, see `On-Demand Instance
           Limits <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits>`__
           in the *Amazon Elastic Compute Cloud User Guide*.

        -  ``vpc-max-security-groups-per-interface``: The maximum number of
           security groups that you can assign to a network interface.

        -  ``max-elastic-ips``: The maximum number of Elastic IP addresses that
           you can allocate for use with EC2-Classic.

        -  ``vpc-max-elastic-ips``: The maximum number of Elastic IP addresses
           that you can allocate for use with EC2-VPC.

        :param attribute_names: The account attribute names.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeAccountAttributesResult
        """
        raise NotImplementedError

    @handler("DescribeAddresses")
    def describe_addresses(
        self,
        context: RequestContext,
        filters: FilterList = None,
        public_ips: PublicIpStringList = None,
        allocation_ids: AllocationIdList = None,
        dry_run: Boolean = None,
    ) -> DescribeAddressesResult:
        """Describes the specified Elastic IP addresses or all of your Elastic IP
        addresses.

        An Elastic IP address is for use in either the EC2-Classic platform or
        in a VPC. For more information, see `Elastic IP
        Addresses <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param filters: One or more filters.
        :param public_ips: One or more Elastic IP addresses.
        :param allocation_ids: [EC2-VPC] Information about the allocation IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeAddressesResult
        """
        raise NotImplementedError

    @handler("DescribeAddressesAttribute")
    def describe_addresses_attribute(
        self,
        context: RequestContext,
        allocation_ids: AllocationIds = None,
        attribute: AddressAttributeName = None,
        next_token: NextToken = None,
        max_results: AddressMaxResults = None,
        dry_run: Boolean = None,
    ) -> DescribeAddressesAttributeResult:
        """Describes the attributes of the specified Elastic IP addresses. For
        requirements, see `Using reverse DNS for email
        applications <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS>`__.

        :param allocation_ids: [EC2-VPC] The allocation IDs.
        :param attribute: The attribute of the IP address.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeAddressesAttributeResult
        """
        raise NotImplementedError

    @handler("DescribeAggregateIdFormat")
    def describe_aggregate_id_format(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> DescribeAggregateIdFormatResult:
        """Describes the longer ID format settings for all resource types in a
        specific Region. This request is useful for performing a quick audit to
        determine whether a specific Region is fully opted in for longer IDs
        (17-character IDs).

        This request only returns information about resource types that support
        longer IDs.

        The following resource types support longer IDs: ``bundle`` |
        ``conversion-task`` | ``customer-gateway`` | ``dhcp-options`` |
        ``elastic-ip-allocation`` | ``elastic-ip-association`` |
        ``export-task`` | ``flow-log`` | ``image`` | ``import-task`` |
        ``instance`` | ``internet-gateway`` | ``network-acl`` |
        ``network-acl-association`` | ``network-interface`` |
        ``network-interface-attachment`` | ``prefix-list`` | ``reservation``
        | ``route-table`` | ``route-table-association`` | ``security-group``
        | ``snapshot`` | ``subnet`` | ``subnet-cidr-block-association`` |
        ``volume`` | ``vpc`` | ``vpc-cidr-block-association`` |
        ``vpc-endpoint`` | ``vpc-peering-connection`` | ``vpn-connection`` |
        ``vpn-gateway``.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeAggregateIdFormatResult
        """
        raise NotImplementedError

    @handler("DescribeAvailabilityZones")
    def describe_availability_zones(
        self,
        context: RequestContext,
        filters: FilterList = None,
        zone_names: ZoneNameStringList = None,
        zone_ids: ZoneIdStringList = None,
        all_availability_zones: Boolean = None,
        dry_run: Boolean = None,
    ) -> DescribeAvailabilityZonesResult:
        """Describes the Availability Zones, Local Zones, and Wavelength Zones that
        are available to you. If there is an event impacting a zone, you can use
        this request to view the state and any provided messages for that zone.

        For more information about Availability Zones, Local Zones, and
        Wavelength Zones, see `Regions and
        zones <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param filters: The filters.
        :param zone_names: The names of the Availability Zones, Local Zones, and Wavelength Zones.
        :param zone_ids: The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
        :param all_availability_zones: Include all Availability Zones, Local Zones, and Wavelength Zones
        regardless of your opt-in status.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeAvailabilityZonesResult
        """
        raise NotImplementedError

    @handler("DescribeBundleTasks")
    def describe_bundle_tasks(
        self,
        context: RequestContext,
        bundle_ids: BundleIdStringList = None,
        filters: FilterList = None,
        dry_run: Boolean = None,
    ) -> DescribeBundleTasksResult:
        """Describes the specified bundle tasks or all of your bundle tasks.

        Completed bundle tasks are listed for only a limited time. If your
        bundle task is no longer in the list, you can still register an AMI from
        it. Just use ``RegisterImage`` with the Amazon S3 bucket name and image
        manifest name you provided to the bundle task.

        :param bundle_ids: The bundle task IDs.
        :param filters: The filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeBundleTasksResult
        """
        raise NotImplementedError

    @handler("DescribeByoipCidrs")
    def describe_byoip_cidrs(
        self,
        context: RequestContext,
        max_results: DescribeByoipCidrsMaxResults,
        dry_run: Boolean = None,
        next_token: NextToken = None,
    ) -> DescribeByoipCidrsResult:
        """Describes the IP address ranges that were specified in calls to
        ProvisionByoipCidr.

        To describe the address pools that were created when you provisioned the
        address ranges, use DescribePublicIpv4Pools or DescribeIpv6Pools.

        :param max_results: The maximum number of results to return with a single call.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :returns: DescribeByoipCidrsResult
        """
        raise NotImplementedError

    @handler("DescribeCapacityReservationFleets")
    def describe_capacity_reservation_fleets(
        self,
        context: RequestContext,
        capacity_reservation_fleet_ids: CapacityReservationFleetIdSet = None,
        next_token: String = None,
        max_results: DescribeCapacityReservationFleetsMaxResults = None,
        filters: FilterList = None,
        dry_run: Boolean = None,
    ) -> DescribeCapacityReservationFleetsResult:
        """Describes one or more Capacity Reservation Fleets.

        :param capacity_reservation_fleet_ids: The IDs of the Capacity Reservation Fleets to describe.
        :param next_token: The token to use to retrieve the next page of results.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeCapacityReservationFleetsResult
        """
        raise NotImplementedError

    @handler("DescribeCapacityReservations")
    def describe_capacity_reservations(
        self,
        context: RequestContext,
        capacity_reservation_ids: CapacityReservationIdSet = None,
        next_token: String = None,
        max_results: DescribeCapacityReservationsMaxResults = None,
        filters: FilterList = None,
        dry_run: Boolean = None,
    ) -> DescribeCapacityReservationsResult:
        """Describes one or more of your Capacity Reservations. The results
        describe only the Capacity Reservations in the Amazon Web Services
        Region that you're currently using.

        :param capacity_reservation_ids: The ID of the Capacity Reservation.
        :param next_token: The token to use to retrieve the next page of results.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeCapacityReservationsResult
        """
        raise NotImplementedError

    @handler("DescribeCarrierGateways")
    def describe_carrier_gateways(
        self,
        context: RequestContext,
        carrier_gateway_ids: CarrierGatewayIdSet = None,
        filters: FilterList = None,
        max_results: CarrierGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeCarrierGatewaysResult:
        """Describes one or more of your carrier gateways.

        :param carrier_gateway_ids: One or more carrier gateway IDs.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeCarrierGatewaysResult
        """
        raise NotImplementedError

    @handler("DescribeClassicLinkInstances")
    def describe_classic_link_instances(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        instance_ids: InstanceIdStringList = None,
        max_results: DescribeClassicLinkInstancesMaxResults = None,
        next_token: String = None,
    ) -> DescribeClassicLinkInstancesResult:
        """Describes one or more of your linked EC2-Classic instances. This request
        only returns information about EC2-Classic instances linked to a VPC
        through ClassicLink. You cannot use this request to return information
        about other instances.

        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param instance_ids: One or more instance IDs.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :returns: DescribeClassicLinkInstancesResult
        """
        raise NotImplementedError

    @handler("DescribeClientVpnAuthorizationRules")
    def describe_client_vpn_authorization_rules(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        dry_run: Boolean = None,
        next_token: NextToken = None,
        filters: FilterList = None,
        max_results: DescribeClientVpnAuthorizationRulesMaxResults = None,
    ) -> DescribeClientVpnAuthorizationRulesResult:
        """Describes the authorization rules for a specified Client VPN endpoint.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token to retrieve the next page of results.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :returns: DescribeClientVpnAuthorizationRulesResult
        """
        raise NotImplementedError

    @handler("DescribeClientVpnConnections")
    def describe_client_vpn_connections(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        filters: FilterList = None,
        next_token: NextToken = None,
        max_results: DescribeClientVpnConnectionsMaxResults = None,
        dry_run: Boolean = None,
    ) -> DescribeClientVpnConnectionsResult:
        """Describes active client connections and connections that have been
        terminated within the last 60 minutes for the specified Client VPN
        endpoint.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint.
        :param filters: One or more filters.
        :param next_token: The token to retrieve the next page of results.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeClientVpnConnectionsResult
        """
        raise NotImplementedError

    @handler("DescribeClientVpnEndpoints")
    def describe_client_vpn_endpoints(
        self,
        context: RequestContext,
        client_vpn_endpoint_ids: ClientVpnEndpointIdList = None,
        max_results: DescribeClientVpnEndpointMaxResults = None,
        next_token: NextToken = None,
        filters: FilterList = None,
        dry_run: Boolean = None,
    ) -> DescribeClientVpnEndpointsResult:
        """Describes one or more Client VPN endpoints in the account.

        :param client_vpn_endpoint_ids: The ID of the Client VPN endpoint.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to retrieve the next page of results.
        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeClientVpnEndpointsResult
        """
        raise NotImplementedError

    @handler("DescribeClientVpnRoutes")
    def describe_client_vpn_routes(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        filters: FilterList = None,
        max_results: DescribeClientVpnRoutesMaxResults = None,
        next_token: NextToken = None,
        dry_run: Boolean = None,
    ) -> DescribeClientVpnRoutesResult:
        """Describes the routes for the specified Client VPN endpoint.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to retrieve the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeClientVpnRoutesResult
        """
        raise NotImplementedError

    @handler("DescribeClientVpnTargetNetworks")
    def describe_client_vpn_target_networks(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        association_ids: ValueStringList = None,
        max_results: DescribeClientVpnTargetNetworksMaxResults = None,
        next_token: NextToken = None,
        filters: FilterList = None,
        dry_run: Boolean = None,
    ) -> DescribeClientVpnTargetNetworksResult:
        """Describes the target networks associated with the specified Client VPN
        endpoint.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint.
        :param association_ids: The IDs of the target network associations.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to retrieve the next page of results.
        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeClientVpnTargetNetworksResult
        """
        raise NotImplementedError

    @handler("DescribeCoipPools")
    def describe_coip_pools(
        self,
        context: RequestContext,
        pool_ids: CoipPoolIdSet = None,
        filters: FilterList = None,
        max_results: CoipPoolMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeCoipPoolsResult:
        """Describes the specified customer-owned address pools or all of your
        customer-owned address pools.

        :param pool_ids: The IDs of the address pools.
        :param filters: The filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeCoipPoolsResult
        """
        raise NotImplementedError

    @handler("DescribeConversionTasks")
    def describe_conversion_tasks(
        self,
        context: RequestContext,
        conversion_task_ids: ConversionIdStringList = None,
        dry_run: Boolean = None,
    ) -> DescribeConversionTasksResult:
        """Describes the specified conversion tasks or all your conversion tasks.
        For more information, see the `VM Import/Export User
        Guide <https://docs.aws.amazon.com/vm-import/latest/userguide/>`__.

        For information about the import manifest referenced by this API action,
        see `VM Import
        Manifest <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html>`__.

        :param conversion_task_ids: The conversion task IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeConversionTasksResult
        """
        raise NotImplementedError

    @handler("DescribeCustomerGateways")
    def describe_customer_gateways(
        self,
        context: RequestContext,
        customer_gateway_ids: CustomerGatewayIdStringList = None,
        filters: FilterList = None,
        dry_run: Boolean = None,
    ) -> DescribeCustomerGatewaysResult:
        """Describes one or more of your VPN customer gateways.

        For more information, see `Amazon Web Services Site-to-Site
        VPN <https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html>`__ in
        the *Amazon Web Services Site-to-Site VPN User Guide*.

        :param customer_gateway_ids: One or more customer gateway IDs.
        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeCustomerGatewaysResult
        """
        raise NotImplementedError

    @handler("DescribeDhcpOptions")
    def describe_dhcp_options(
        self,
        context: RequestContext,
        dhcp_options_ids: DhcpOptionsIdStringList = None,
        filters: FilterList = None,
        dry_run: Boolean = None,
        next_token: String = None,
        max_results: DescribeDhcpOptionsMaxResults = None,
    ) -> DescribeDhcpOptionsResult:
        """Describes one or more of your DHCP options sets.

        For more information, see `DHCP options
        sets <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param dhcp_options_ids: The IDs of one or more DHCP options sets.
        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :returns: DescribeDhcpOptionsResult
        """
        raise NotImplementedError

    @handler("DescribeEgressOnlyInternetGateways")
    def describe_egress_only_internet_gateways(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        egress_only_internet_gateway_ids: EgressOnlyInternetGatewayIdList = None,
        max_results: DescribeEgressOnlyInternetGatewaysMaxResults = None,
        next_token: String = None,
        filters: FilterList = None,
    ) -> DescribeEgressOnlyInternetGatewaysResult:
        """Describes one or more of your egress-only internet gateways.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param egress_only_internet_gateway_ids: One or more egress-only internet gateway IDs.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param filters: One or more filters.
        :returns: DescribeEgressOnlyInternetGatewaysResult
        """
        raise NotImplementedError

    @handler("DescribeElasticGpus")
    def describe_elastic_gpus(
        self,
        context: RequestContext,
        elastic_gpu_ids: ElasticGpuIdSet = None,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: DescribeElasticGpusMaxResults = None,
        next_token: String = None,
    ) -> DescribeElasticGpusResult:
        """Describes the Elastic Graphics accelerator associated with your
        instances. For more information about Elastic Graphics, see `Amazon
        Elastic
        Graphics <https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html>`__.

        :param elastic_gpu_ids: The Elastic Graphics accelerator IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: The filters.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token to request the next page of results.
        :returns: DescribeElasticGpusResult
        """
        raise NotImplementedError

    @handler("DescribeExportImageTasks")
    def describe_export_image_tasks(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        export_image_task_ids: ExportImageTaskIdList = None,
        max_results: DescribeExportImageTasksMaxResults = None,
        next_token: NextToken = None,
    ) -> DescribeExportImageTasksResult:
        """Describes the specified export image tasks or all of your export image
        tasks.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: Filter tasks using the ``task-state`` filter and one of the following
        values: ``active``, ``completed``, ``deleting``, or ``deleted``.
        :param export_image_task_ids: The IDs of the export image tasks.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: A token that indicates the next page of results.
        :returns: DescribeExportImageTasksResult
        """
        raise NotImplementedError

    @handler("DescribeExportTasks")
    def describe_export_tasks(
        self,
        context: RequestContext,
        export_task_ids: ExportTaskIdStringList = None,
        filters: FilterList = None,
    ) -> DescribeExportTasksResult:
        """Describes the specified export instance tasks or all of your export
        instance tasks.

        :param export_task_ids: The export task IDs.
        :param filters: the filters for the export tasks.
        :returns: DescribeExportTasksResult
        """
        raise NotImplementedError

    @handler("DescribeFastLaunchImages")
    def describe_fast_launch_images(
        self,
        context: RequestContext,
        image_ids: FastLaunchImageIdList = None,
        filters: FilterList = None,
        max_results: DescribeFastLaunchImagesRequestMaxResults = None,
        next_token: NextToken = None,
        dry_run: Boolean = None,
    ) -> DescribeFastLaunchImagesResult:
        """Describe details for Windows AMIs that are configured for faster
        launching.

        :param image_ids: Details for one or more Windows AMI image IDs.
        :param filters: Use the following filters to streamline results.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token for the next set of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeFastLaunchImagesResult
        """
        raise NotImplementedError

    @handler("DescribeFastSnapshotRestores")
    def describe_fast_snapshot_restores(
        self,
        context: RequestContext,
        filters: FilterList = None,
        max_results: DescribeFastSnapshotRestoresMaxResults = None,
        next_token: NextToken = None,
        dry_run: Boolean = None,
    ) -> DescribeFastSnapshotRestoresResult:
        """Describes the state of fast snapshot restores for your snapshots.

        :param filters: The filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeFastSnapshotRestoresResult
        """
        raise NotImplementedError

    @handler("DescribeFleetHistory")
    def describe_fleet_history(
        self,
        context: RequestContext,
        fleet_id: FleetId,
        start_time: DateTime,
        dry_run: Boolean = None,
        event_type: FleetEventType = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeFleetHistoryResult:
        """Describes the events for the specified EC2 Fleet during the specified
        time.

        EC2 Fleet events are delayed by up to 30 seconds before they can be
        described. This ensures that you can query by the last evaluated time
        and not miss a recorded event. EC2 Fleet events are available for 48
        hours.

        For more information, see `Monitor fleet events using Amazon
        EventBridge <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html>`__
        in the *Amazon EC2 User Guide*.

        :param fleet_id: The ID of the EC2 Fleet.
        :param start_time: The start date and time for the events, in UTC format (for example,
        *YYYY*-*MM*-*DD* T *HH*:*MM*:*SS* Z).
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param event_type: The type of events to describe.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token for the next set of results.
        :returns: DescribeFleetHistoryResult
        """
        raise NotImplementedError

    @handler("DescribeFleetInstances")
    def describe_fleet_instances(
        self,
        context: RequestContext,
        fleet_id: FleetId,
        dry_run: Boolean = None,
        max_results: Integer = None,
        next_token: String = None,
        filters: FilterList = None,
    ) -> DescribeFleetInstancesResult:
        """Describes the running instances for the specified EC2 Fleet.

        For more information, see `Monitoring your EC2
        Fleet <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet>`__
        in the *Amazon EC2 User Guide*.

        :param fleet_id: The ID of the EC2 Fleet.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token for the next set of results.
        :param filters: The filters.
        :returns: DescribeFleetInstancesResult
        """
        raise NotImplementedError

    @handler("DescribeFleets")
    def describe_fleets(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        max_results: Integer = None,
        next_token: String = None,
        fleet_ids: FleetIdSet = None,
        filters: FilterList = None,
    ) -> DescribeFleetsResult:
        """Describes the specified EC2 Fleets or all of your EC2 Fleets.

        For more information, see `Monitoring your EC2
        Fleet <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html#monitor-ec2-fleet>`__
        in the *Amazon EC2 User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token for the next set of results.
        :param fleet_ids: The ID of the EC2 Fleets.
        :param filters: The filters.
        :returns: DescribeFleetsResult
        """
        raise NotImplementedError

    @handler("DescribeFlowLogs")
    def describe_flow_logs(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filter: FilterList = None,
        flow_log_ids: FlowLogIdList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeFlowLogsResult:
        """Describes one or more flow logs. To view the information in your flow
        logs (the log streams for the network interfaces), you must use the
        CloudWatch Logs console or the CloudWatch Logs API.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filter: One or more filters.
        :param flow_log_ids: One or more flow log IDs.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :returns: DescribeFlowLogsResult
        """
        raise NotImplementedError

    @handler("DescribeFpgaImageAttribute")
    def describe_fpga_image_attribute(
        self,
        context: RequestContext,
        fpga_image_id: FpgaImageId,
        attribute: FpgaImageAttributeName,
        dry_run: Boolean = None,
    ) -> DescribeFpgaImageAttributeResult:
        """Describes the specified attribute of the specified Amazon FPGA Image
        (AFI).

        :param fpga_image_id: The ID of the AFI.
        :param attribute: The AFI attribute.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeFpgaImageAttributeResult
        """
        raise NotImplementedError

    @handler("DescribeFpgaImages")
    def describe_fpga_images(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        fpga_image_ids: FpgaImageIdList = None,
        owners: OwnerStringList = None,
        filters: FilterList = None,
        next_token: NextToken = None,
        max_results: DescribeFpgaImagesMaxResults = None,
    ) -> DescribeFpgaImagesResult:
        """Describes the Amazon FPGA Images (AFIs) available to you. These include
        public AFIs, private AFIs that you own, and AFIs owned by other Amazon
        Web Services accounts for which you have load permissions.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param fpga_image_ids: The AFI IDs.
        :param owners: Filters the AFI by owner.
        :param filters: The filters.
        :param next_token: The token to retrieve the next page of results.
        :param max_results: The maximum number of results to return in a single call.
        :returns: DescribeFpgaImagesResult
        """
        raise NotImplementedError

    @handler("DescribeHostReservationOfferings")
    def describe_host_reservation_offerings(
        self,
        context: RequestContext,
        filter: FilterList = None,
        max_duration: Integer = None,
        max_results: DescribeHostReservationsMaxResults = None,
        min_duration: Integer = None,
        next_token: String = None,
        offering_id: OfferingId = None,
    ) -> DescribeHostReservationOfferingsResult:
        """Describes the Dedicated Host reservations that are available to
        purchase.

        The results describe all of the Dedicated Host reservation offerings,
        including offerings that might not match the instance family and Region
        of your Dedicated Hosts. When purchasing an offering, ensure that the
        instance family and Region of the offering matches that of the Dedicated
        Hosts with which it is to be associated. For more information about
        supported instance types, see `Dedicated
        Hosts <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html>`__
        in the *Amazon EC2 User Guide*.

        :param filter: The filters.
        :param max_duration: This is the maximum duration of the reservation to purchase, specified
        in seconds.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param min_duration: This is the minimum duration of the reservation you'd like to purchase,
        specified in seconds.
        :param next_token: The token to use to retrieve the next page of results.
        :param offering_id: The ID of the reservation offering.
        :returns: DescribeHostReservationOfferingsResult
        """
        raise NotImplementedError

    @handler("DescribeHostReservations")
    def describe_host_reservations(
        self,
        context: RequestContext,
        filter: FilterList = None,
        host_reservation_id_set: HostReservationIdSet = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeHostReservationsResult:
        """Describes reservations that are associated with Dedicated Hosts in your
        account.

        :param filter: The filters.
        :param host_reservation_id_set: The host reservation IDs.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to use to retrieve the next page of results.
        :returns: DescribeHostReservationsResult
        """
        raise NotImplementedError

    @handler("DescribeHosts")
    def describe_hosts(
        self,
        context: RequestContext,
        filter: FilterList = None,
        host_ids: RequestHostIdList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeHostsResult:
        """Describes the specified Dedicated Hosts or all your Dedicated Hosts.

        The results describe only the Dedicated Hosts in the Region you're
        currently using. All listed instances consume capacity on your Dedicated
        Host. Dedicated Hosts that have recently been released are listed with
        the state ``released``.

        :param filter: The filters.
        :param host_ids: The IDs of the Dedicated Hosts.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to use to retrieve the next page of results.
        :returns: DescribeHostsResult
        """
        raise NotImplementedError

    @handler("DescribeIamInstanceProfileAssociations")
    def describe_iam_instance_profile_associations(
        self,
        context: RequestContext,
        association_ids: AssociationIdList = None,
        filters: FilterList = None,
        max_results: DescribeIamInstanceProfileAssociationsMaxResults = None,
        next_token: NextToken = None,
    ) -> DescribeIamInstanceProfileAssociationsResult:
        """Describes your IAM instance profile associations.

        :param association_ids: The IAM instance profile associations.
        :param filters: The filters.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token to request the next page of results.
        :returns: DescribeIamInstanceProfileAssociationsResult
        """
        raise NotImplementedError

    @handler("DescribeIdFormat")
    def describe_id_format(
        self, context: RequestContext, resource: String = None
    ) -> DescribeIdFormatResult:
        """Describes the ID format settings for your resources on a per-Region
        basis, for example, to view which resource types are enabled for longer
        IDs. This request only returns information about resource types whose ID
        formats can be modified; it does not return information about other
        resource types.

        The following resource types support longer IDs: ``bundle`` |
        ``conversion-task`` | ``customer-gateway`` | ``dhcp-options`` |
        ``elastic-ip-allocation`` | ``elastic-ip-association`` |
        ``export-task`` | ``flow-log`` | ``image`` | ``import-task`` |
        ``instance`` | ``internet-gateway`` | ``network-acl`` |
        ``network-acl-association`` | ``network-interface`` |
        ``network-interface-attachment`` | ``prefix-list`` | ``reservation``
        | ``route-table`` | ``route-table-association`` | ``security-group``
        | ``snapshot`` | ``subnet`` | ``subnet-cidr-block-association`` |
        ``volume`` | ``vpc`` | ``vpc-cidr-block-association`` |
        ``vpc-endpoint`` | ``vpc-peering-connection`` | ``vpn-connection`` |
        ``vpn-gateway``.

        These settings apply to the IAM user who makes the request; they do not
        apply to the entire Amazon Web Services account. By default, an IAM user
        defaults to the same settings as the root user, unless they explicitly
        override the settings by running the ModifyIdFormat command. Resources
        created with longer IDs are visible to all IAM users, regardless of
        these settings and provided that they have permission to use the
        relevant ``Describe`` command for the resource type.

        :param resource: The type of resource: ``bundle`` | ``conversion-task`` |
        ``customer-gateway`` | ``dhcp-options`` | ``elastic-ip-allocation`` |
        ``elastic-ip-association`` | ``export-task`` | ``flow-log`` |
        ``image`` | ``import-task`` | ``instance`` | ``internet-gateway`` |
        ``network-acl`` | ``network-acl-association`` | ``network-interface``
        | ``network-interface-attachment`` | ``prefix-list`` |
        ``reservation`` | ``route-table`` | ``route-table-association`` |
        ``security-group`` | ``snapshot`` | ``subnet`` |
        ``subnet-cidr-block-association`` | ``volume`` | ``vpc`` |
        ``vpc-cidr-block-association`` | ``vpc-endpoint`` |
        ``vpc-peering-connection`` | ``vpn-connection`` | ``vpn-gateway``.
        :returns: DescribeIdFormatResult
        """
        raise NotImplementedError

    @handler("DescribeIdentityIdFormat")
    def describe_identity_id_format(
        self, context: RequestContext, principal_arn: String, resource: String = None
    ) -> DescribeIdentityIdFormatResult:
        """Describes the ID format settings for resources for the specified IAM
        user, IAM role, or root user. For example, you can view the resource
        types that are enabled for longer IDs. This request only returns
        information about resource types whose ID formats can be modified; it
        does not return information about other resource types. For more
        information, see `Resource
        IDs <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        The following resource types support longer IDs: ``bundle`` |
        ``conversion-task`` | ``customer-gateway`` | ``dhcp-options`` |
        ``elastic-ip-allocation`` | ``elastic-ip-association`` |
        ``export-task`` | ``flow-log`` | ``image`` | ``import-task`` |
        ``instance`` | ``internet-gateway`` | ``network-acl`` |
        ``network-acl-association`` | ``network-interface`` |
        ``network-interface-attachment`` | ``prefix-list`` | ``reservation``
        | ``route-table`` | ``route-table-association`` | ``security-group``
        | ``snapshot`` | ``subnet`` | ``subnet-cidr-block-association`` |
        ``volume`` | ``vpc`` | ``vpc-cidr-block-association`` |
        ``vpc-endpoint`` | ``vpc-peering-connection`` | ``vpn-connection`` |
        ``vpn-gateway``.

        These settings apply to the principal specified in the request. They do
        not apply to the principal that makes the request.

        :param principal_arn: The ARN of the principal, which can be an IAM role, IAM user, or the
        root user.
        :param resource: The type of resource: ``bundle`` | ``conversion-task`` |
        ``customer-gateway`` | ``dhcp-options`` | ``elastic-ip-allocation`` |
        ``elastic-ip-association`` | ``export-task`` | ``flow-log`` |
        ``image`` | ``import-task`` | ``instance`` | ``internet-gateway`` |
        ``network-acl`` | ``network-acl-association`` | ``network-interface``
        | ``network-interface-attachment`` | ``prefix-list`` |
        ``reservation`` | ``route-table`` | ``route-table-association`` |
        ``security-group`` | ``snapshot`` | ``subnet`` |
        ``subnet-cidr-block-association`` | ``volume`` | ``vpc`` |
        ``vpc-cidr-block-association`` | ``vpc-endpoint`` |
        ``vpc-peering-connection`` | ``vpn-connection`` | ``vpn-gateway``.
        :returns: DescribeIdentityIdFormatResult
        """
        raise NotImplementedError

    @handler("DescribeImageAttribute")
    def describe_image_attribute(
        self,
        context: RequestContext,
        attribute: ImageAttributeName,
        image_id: ImageId,
        dry_run: Boolean = None,
    ) -> ImageAttribute:
        """Describes the specified attribute of the specified AMI. You can specify
        only one attribute at a time.

        :param attribute: The AMI attribute.
        :param image_id: The ID of the AMI.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: ImageAttribute
        """
        raise NotImplementedError

    @handler("DescribeImages")
    def describe_images(
        self,
        context: RequestContext,
        executable_users: ExecutableByStringList = None,
        filters: FilterList = None,
        image_ids: ImageIdStringList = None,
        owners: OwnerStringList = None,
        include_deprecated: Boolean = None,
        dry_run: Boolean = None,
    ) -> DescribeImagesResult:
        """Describes the specified images (AMIs, AKIs, and ARIs) available to you
        or all of the images available to you.

        The images available to you include public images, private images that
        you own, and private images owned by other Amazon Web Services accounts
        for which you have explicit launch permissions.

        Recently deregistered images appear in the returned results for a short
        interval and then return empty results. After all instances that
        reference a deregistered AMI are terminated, specifying the ID of the
        image will eventually return an error indicating that the AMI ID cannot
        be found.

        :param executable_users: Scopes the images by users with explicit launch permissions.
        :param filters: The filters.
        :param image_ids: The image IDs.
        :param owners: Scopes the results to images with the specified owners.
        :param include_deprecated: If ``true``, all deprecated AMIs are included in the response.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeImagesResult
        """
        raise NotImplementedError

    @handler("DescribeImportImageTasks")
    def describe_import_image_tasks(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        import_task_ids: ImportTaskIdList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeImportImageTasksResult:
        """Displays details about an import virtual machine or import snapshot
        tasks that are already created.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: Filter tasks using the ``task-state`` filter and one of the following
        values: ``active``, ``completed``, ``deleting``, or ``deleted``.
        :param import_task_ids: The IDs of the import image tasks.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: A token that indicates the next page of results.
        :returns: DescribeImportImageTasksResult
        """
        raise NotImplementedError

    @handler("DescribeImportSnapshotTasks")
    def describe_import_snapshot_tasks(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        import_task_ids: ImportSnapshotTaskIdList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeImportSnapshotTasksResult:
        """Describes your import snapshot tasks.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: The filters.
        :param import_task_ids: A list of import snapshot task IDs.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: A token that indicates the next page of results.
        :returns: DescribeImportSnapshotTasksResult
        """
        raise NotImplementedError

    @handler("DescribeInstanceAttribute")
    def describe_instance_attribute(
        self,
        context: RequestContext,
        attribute: InstanceAttributeName,
        instance_id: InstanceId,
        dry_run: Boolean = None,
    ) -> InstanceAttribute:
        """Describes the specified attribute of the specified instance. You can
        specify only one attribute at a time. Valid attribute values are:
        ``instanceType`` | ``kernel`` | ``ramdisk`` | ``userData`` |
        ``disableApiTermination`` | ``instanceInitiatedShutdownBehavior`` |
        ``rootDeviceName`` | ``blockDeviceMapping`` | ``productCodes`` |
        ``sourceDestCheck`` | ``groupSet`` | ``ebsOptimized`` |
        ``sriovNetSupport``

        :param attribute: The instance attribute.
        :param instance_id: The ID of the instance.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: InstanceAttribute
        """
        raise NotImplementedError

    @handler("DescribeInstanceCreditSpecifications")
    def describe_instance_credit_specifications(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        instance_ids: InstanceIdStringList = None,
        max_results: DescribeInstanceCreditSpecificationsMaxResults = None,
        next_token: String = None,
    ) -> DescribeInstanceCreditSpecificationsResult:
        """Describes the credit option for CPU usage of the specified burstable
        performance instances. The credit options are ``standard`` and
        ``unlimited``.

        If you do not specify an instance ID, Amazon EC2 returns burstable
        performance instances with the ``unlimited`` credit option, as well as
        instances that were previously configured as T2, T3, and T3a with the
        ``unlimited`` credit option. For example, if you resize a T2 instance,
        while it is configured as ``unlimited``, to an M4 instance, Amazon EC2
        returns the M4 instance.

        If you specify one or more instance IDs, Amazon EC2 returns the credit
        option (``standard`` or ``unlimited``) of those instances. If you
        specify an instance ID that is not valid, such as an instance that is
        not a burstable performance instance, an error is returned.

        Recently terminated instances might appear in the returned results. This
        interval is usually less than one hour.

        If an Availability Zone is experiencing a service disruption and you
        specify instance IDs in the affected zone, or do not specify any
        instance IDs at all, the call fails. If you specify only instance IDs in
        an unaffected zone, the call works normally.

        For more information, see `Burstable performance
        instances <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html>`__
        in the *Amazon EC2 User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: The filters.
        :param instance_ids: The instance IDs.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token to retrieve the next page of results.
        :returns: DescribeInstanceCreditSpecificationsResult
        """
        raise NotImplementedError

    @handler("DescribeInstanceEventNotificationAttributes")
    def describe_instance_event_notification_attributes(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> DescribeInstanceEventNotificationAttributesResult:
        """Describes the tag keys that are registered to appear in scheduled event
        notifications for resources in the current Region.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeInstanceEventNotificationAttributesResult
        """
        raise NotImplementedError

    @handler("DescribeInstanceEventWindows")
    def describe_instance_event_windows(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        instance_event_window_ids: InstanceEventWindowIdSet = None,
        filters: FilterList = None,
        max_results: ResultRange = None,
        next_token: String = None,
    ) -> DescribeInstanceEventWindowsResult:
        """Describes the specified event windows or all event windows.

        If you specify event window IDs, the output includes information for
        only the specified event windows. If you specify filters, the output
        includes information for only those event windows that meet the filter
        criteria. If you do not specify event windows IDs or filters, the output
        includes information for all event windows, which can affect
        performance. We recommend that you use pagination to ensure that the
        operation returns quickly and successfully.

        For more information, see `Define event windows for scheduled
        events <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html>`__
        in the *Amazon EC2 User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param instance_event_window_ids: The IDs of the event windows.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token to request the next page of results.
        :returns: DescribeInstanceEventWindowsResult
        """
        raise NotImplementedError

    @handler("DescribeInstanceStatus")
    def describe_instance_status(
        self,
        context: RequestContext,
        filters: FilterList = None,
        instance_ids: InstanceIdStringList = None,
        max_results: Integer = None,
        next_token: String = None,
        dry_run: Boolean = None,
        include_all_instances: Boolean = None,
    ) -> DescribeInstanceStatusResult:
        """Describes the status of the specified instances or all of your
        instances. By default, only running instances are described, unless you
        specifically indicate to return the status of all instances.

        Instance status includes the following components:

        -  **Status checks** - Amazon EC2 performs status checks on running EC2
           instances to identify hardware and software issues. For more
           information, see `Status checks for your
           instances <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html>`__
           and `Troubleshoot instances with failed status
           checks <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html>`__
           in the *Amazon EC2 User Guide*.

        -  **Scheduled events** - Amazon EC2 can schedule events (such as
           reboot, stop, or terminate) for your instances related to hardware
           issues, software updates, or system maintenance. For more
           information, see `Scheduled events for your
           instances <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html>`__
           in the *Amazon EC2 User Guide*.

        -  **Instance state** - You can manage your instances from the moment
           you launch them through their termination. For more information, see
           `Instance
           lifecycle <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html>`__
           in the *Amazon EC2 User Guide*.

        :param filters: The filters.
        :param instance_ids: The instance IDs.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token to retrieve the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param include_all_instances: When ``true``, includes the health status for all instances.
        :returns: DescribeInstanceStatusResult
        """
        raise NotImplementedError

    @handler("DescribeInstanceTypeOfferings")
    def describe_instance_type_offerings(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        location_type: LocationType = None,
        filters: FilterList = None,
        max_results: DITOMaxResults = None,
        next_token: NextToken = None,
    ) -> DescribeInstanceTypeOfferingsResult:
        """Returns a list of all instance types offered. The results can be
        filtered by location (Region or Availability Zone). If no location is
        specified, the instance types offered in the current Region are
        returned.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param location_type: The location type.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to retrieve the next page of results.
        :returns: DescribeInstanceTypeOfferingsResult
        """
        raise NotImplementedError

    @handler("DescribeInstanceTypes")
    def describe_instance_types(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        instance_types: RequestInstanceTypeList = None,
        filters: FilterList = None,
        max_results: DITMaxResults = None,
        next_token: NextToken = None,
    ) -> DescribeInstanceTypesResult:
        """Describes the details of the instance types that are offered in a
        location. The results can be filtered by the attributes of the instance
        types.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param instance_types: The instance types.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to retrieve the next page of results.
        :returns: DescribeInstanceTypesResult
        """
        raise NotImplementedError

    @handler("DescribeInstances")
    def describe_instances(
        self,
        context: RequestContext,
        filters: FilterList = None,
        instance_ids: InstanceIdStringList = None,
        dry_run: Boolean = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeInstancesResult:
        """Describes the specified instances or all instances.

        If you specify instance IDs, the output includes information for only
        the specified instances. If you specify filters, the output includes
        information for only those instances that meet the filter criteria. If
        you do not specify instance IDs or filters, the output includes
        information for all instances, which can affect performance. We
        recommend that you use pagination to ensure that the operation returns
        quickly and successfully.

        If you specify an instance ID that is not valid, an error is returned.
        If you specify an instance that you do not own, it is not included in
        the output.

        Recently terminated instances might appear in the returned results. This
        interval is usually less than one hour.

        If you describe instances in the rare case where an Availability Zone is
        experiencing a service disruption and you specify instance IDs that are
        in the affected zone, or do not specify any instance IDs at all, the
        call fails. If you describe instances and specify only instance IDs that
        are in an unaffected zone, the call works normally.

        :param filters: The filters.
        :param instance_ids: The instance IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token to request the next page of results.
        :returns: DescribeInstancesResult
        """
        raise NotImplementedError

    @handler("DescribeInternetGateways")
    def describe_internet_gateways(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        internet_gateway_ids: InternetGatewayIdList = None,
        next_token: String = None,
        max_results: DescribeInternetGatewaysMaxResults = None,
    ) -> DescribeInternetGatewaysResult:
        """Describes one or more of your internet gateways.

        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param internet_gateway_ids: One or more internet gateway IDs.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :returns: DescribeInternetGatewaysResult
        """
        raise NotImplementedError

    @handler("DescribeIpamPools")
    def describe_ipam_pools(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: IpamMaxResults = None,
        next_token: NextToken = None,
        ipam_pool_ids: ValueStringList = None,
    ) -> DescribeIpamPoolsResult:
        """Get information about your IPAM pools.

        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :param filters: One or more filters for the request.
        :param max_results: The maximum number of results to return in the request.
        :param next_token: The token for the next page of results.
        :param ipam_pool_ids: The IDs of the IPAM pools you would like information on.
        :returns: DescribeIpamPoolsResult
        """
        raise NotImplementedError

    @handler("DescribeIpamScopes")
    def describe_ipam_scopes(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: IpamMaxResults = None,
        next_token: NextToken = None,
        ipam_scope_ids: ValueStringList = None,
    ) -> DescribeIpamScopesResult:
        """Get information about your IPAM scopes.

        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :param filters: One or more filters for the request.
        :param max_results: The maximum number of results to return in the request.
        :param next_token: The token for the next page of results.
        :param ipam_scope_ids: The IDs of the scopes you want information on.
        :returns: DescribeIpamScopesResult
        """
        raise NotImplementedError

    @handler("DescribeIpams")
    def describe_ipams(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: IpamMaxResults = None,
        next_token: NextToken = None,
        ipam_ids: ValueStringList = None,
    ) -> DescribeIpamsResult:
        """Get information about your IPAM pools.

        For more information, see `What is
        IPAM? </vpc/latest/ipam/what-is-it-ipam.html>`__ in the *Amazon VPC IPAM
        User Guide*.

        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :param filters: One or more filters for the request.
        :param max_results: The maximum number of results to return in the request.
        :param next_token: The token for the next page of results.
        :param ipam_ids: The IDs of the IPAMs you want information on.
        :returns: DescribeIpamsResult
        """
        raise NotImplementedError

    @handler("DescribeIpv6Pools")
    def describe_ipv6_pools(
        self,
        context: RequestContext,
        pool_ids: Ipv6PoolIdList = None,
        next_token: NextToken = None,
        max_results: Ipv6PoolMaxResults = None,
        dry_run: Boolean = None,
        filters: FilterList = None,
    ) -> DescribeIpv6PoolsResult:
        """Describes your IPv6 address pools.

        :param pool_ids: The IDs of the IPv6 address pools.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: One or more filters.
        :returns: DescribeIpv6PoolsResult
        """
        raise NotImplementedError

    @handler("DescribeKeyPairs")
    def describe_key_pairs(
        self,
        context: RequestContext,
        filters: FilterList = None,
        key_names: KeyNameStringList = None,
        key_pair_ids: KeyPairIdStringList = None,
        dry_run: Boolean = None,
    ) -> DescribeKeyPairsResult:
        """Describes the specified key pairs or all of your key pairs.

        For more information about key pairs, see `Amazon EC2 key
        pairs <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param filters: The filters.
        :param key_names: The key pair names.
        :param key_pair_ids: The IDs of the key pairs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeKeyPairsResult
        """
        raise NotImplementedError

    @handler("DescribeLaunchTemplateVersions")
    def describe_launch_template_versions(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        launch_template_id: LaunchTemplateId = None,
        launch_template_name: LaunchTemplateName = None,
        versions: VersionStringList = None,
        min_version: String = None,
        max_version: String = None,
        next_token: String = None,
        max_results: Integer = None,
        filters: FilterList = None,
    ) -> DescribeLaunchTemplateVersionsResult:
        """Describes one or more versions of a specified launch template. You can
        describe all versions, individual versions, or a range of versions. You
        can also describe all the latest versions or all the default versions of
        all the launch templates in your account.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param launch_template_id: The ID of the launch template.
        :param launch_template_name: The name of the launch template.
        :param versions: One or more versions of the launch template.
        :param min_version: The version number after which to describe launch template versions.
        :param max_version: The version number up to which to describe launch template versions.
        :param next_token: The token to request the next page of results.
        :param max_results: The maximum number of results to return in a single call.
        :param filters: One or more filters.
        :returns: DescribeLaunchTemplateVersionsResult
        """
        raise NotImplementedError

    @handler("DescribeLaunchTemplates")
    def describe_launch_templates(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        launch_template_ids: LaunchTemplateIdStringList = None,
        launch_template_names: LaunchTemplateNameStringList = None,
        filters: FilterList = None,
        next_token: String = None,
        max_results: DescribeLaunchTemplatesMaxResults = None,
    ) -> DescribeLaunchTemplatesResult:
        """Describes one or more launch templates.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param launch_template_ids: One or more launch template IDs.
        :param launch_template_names: One or more launch template names.
        :param filters: One or more filters.
        :param next_token: The token to request the next page of results.
        :param max_results: The maximum number of results to return in a single call.
        :returns: DescribeLaunchTemplatesResult
        """
        raise NotImplementedError

    @handler("DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations")
    def describe_local_gateway_route_table_virtual_interface_group_associations(
        self,
        context: RequestContext,
        local_gateway_route_table_virtual_interface_group_association_ids: LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdSet = None,
        filters: FilterList = None,
        max_results: LocalGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult:
        """Describes the associations between virtual interface groups and local
        gateway route tables.

        :param local_gateway_route_table_virtual_interface_group_association_ids: The IDs of the associations.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult
        """
        raise NotImplementedError

    @handler("DescribeLocalGatewayRouteTableVpcAssociations")
    def describe_local_gateway_route_table_vpc_associations(
        self,
        context: RequestContext,
        local_gateway_route_table_vpc_association_ids: LocalGatewayRouteTableVpcAssociationIdSet = None,
        filters: FilterList = None,
        max_results: LocalGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeLocalGatewayRouteTableVpcAssociationsResult:
        """Describes the specified associations between VPCs and local gateway
        route tables.

        :param local_gateway_route_table_vpc_association_ids: The IDs of the associations.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeLocalGatewayRouteTableVpcAssociationsResult
        """
        raise NotImplementedError

    @handler("DescribeLocalGatewayRouteTables")
    def describe_local_gateway_route_tables(
        self,
        context: RequestContext,
        local_gateway_route_table_ids: LocalGatewayRouteTableIdSet = None,
        filters: FilterList = None,
        max_results: LocalGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeLocalGatewayRouteTablesResult:
        """Describes one or more local gateway route tables. By default, all local
        gateway route tables are described. Alternatively, you can filter the
        results.

        :param local_gateway_route_table_ids: The IDs of the local gateway route tables.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeLocalGatewayRouteTablesResult
        """
        raise NotImplementedError

    @handler("DescribeLocalGatewayVirtualInterfaceGroups")
    def describe_local_gateway_virtual_interface_groups(
        self,
        context: RequestContext,
        local_gateway_virtual_interface_group_ids: LocalGatewayVirtualInterfaceGroupIdSet = None,
        filters: FilterList = None,
        max_results: LocalGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeLocalGatewayVirtualInterfaceGroupsResult:
        """Describes the specified local gateway virtual interface groups.

        :param local_gateway_virtual_interface_group_ids: The IDs of the virtual interface groups.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeLocalGatewayVirtualInterfaceGroupsResult
        """
        raise NotImplementedError

    @handler("DescribeLocalGatewayVirtualInterfaces")
    def describe_local_gateway_virtual_interfaces(
        self,
        context: RequestContext,
        local_gateway_virtual_interface_ids: LocalGatewayVirtualInterfaceIdSet = None,
        filters: FilterList = None,
        max_results: LocalGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeLocalGatewayVirtualInterfacesResult:
        """Describes the specified local gateway virtual interfaces.

        :param local_gateway_virtual_interface_ids: The IDs of the virtual interfaces.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeLocalGatewayVirtualInterfacesResult
        """
        raise NotImplementedError

    @handler("DescribeLocalGateways")
    def describe_local_gateways(
        self,
        context: RequestContext,
        local_gateway_ids: LocalGatewayIdSet = None,
        filters: FilterList = None,
        max_results: LocalGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeLocalGatewaysResult:
        """Describes one or more local gateways. By default, all local gateways are
        described. Alternatively, you can filter the results.

        :param local_gateway_ids: One or more filters.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeLocalGatewaysResult
        """
        raise NotImplementedError

    @handler("DescribeManagedPrefixLists")
    def describe_managed_prefix_lists(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: PrefixListMaxResults = None,
        next_token: NextToken = None,
        prefix_list_ids: ValueStringList = None,
    ) -> DescribeManagedPrefixListsResult:
        """Describes your managed prefix lists and any Amazon Web Services-managed
        prefix lists.

        To view the entries for your prefix list, use
        GetManagedPrefixListEntries.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param prefix_list_ids: One or more prefix list IDs.
        :returns: DescribeManagedPrefixListsResult
        """
        raise NotImplementedError

    @handler("DescribeMovingAddresses")
    def describe_moving_addresses(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        max_results: DescribeMovingAddressesMaxResults = None,
        next_token: String = None,
        public_ips: ValueStringList = None,
    ) -> DescribeMovingAddressesResult:
        """Describes your Elastic IP addresses that are being moved to the EC2-VPC
        platform, or that are being restored to the EC2-Classic platform. This
        request does not return information about any other Elastic IP addresses
        in your account.

        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token for the next page of results.
        :param public_ips: One or more Elastic IP addresses.
        :returns: DescribeMovingAddressesResult
        """
        raise NotImplementedError

    @handler("DescribeNatGateways")
    def describe_nat_gateways(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filter: FilterList = None,
        max_results: DescribeNatGatewaysMaxResults = None,
        nat_gateway_ids: NatGatewayIdStringList = None,
        next_token: String = None,
    ) -> DescribeNatGatewaysResult:
        """Describes one or more of your NAT gateways.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filter: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param nat_gateway_ids: One or more NAT gateway IDs.
        :param next_token: The token for the next page of results.
        :returns: DescribeNatGatewaysResult
        """
        raise NotImplementedError

    @handler("DescribeNetworkAcls")
    def describe_network_acls(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        network_acl_ids: NetworkAclIdStringList = None,
        next_token: String = None,
        max_results: DescribeNetworkAclsMaxResults = None,
    ) -> DescribeNetworkAclsResult:
        """Describes one or more of your network ACLs.

        For more information, see `Network
        ACLs <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param network_acl_ids: One or more network ACL IDs.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :returns: DescribeNetworkAclsResult
        """
        raise NotImplementedError

    @handler("DescribeNetworkInsightsAccessScopeAnalyses")
    def describe_network_insights_access_scope_analyses(
        self,
        context: RequestContext,
        network_insights_access_scope_analysis_ids: NetworkInsightsAccessScopeAnalysisIdList = None,
        network_insights_access_scope_id: NetworkInsightsAccessScopeId = None,
        analysis_start_time_begin: MillisecondDateTime = None,
        analysis_start_time_end: MillisecondDateTime = None,
        filters: FilterList = None,
        max_results: NetworkInsightsMaxResults = None,
        dry_run: Boolean = None,
        next_token: NextToken = None,
    ) -> DescribeNetworkInsightsAccessScopeAnalysesResult:
        """Describes the specified Network Access Scope analyses.

        :param network_insights_access_scope_analysis_ids: The IDs of the Network Access Scope analyses.
        :param network_insights_access_scope_id: The ID of the Network Access Scope.
        :param analysis_start_time_begin: Filters the results based on the start time.
        :param analysis_start_time_end: Filters the results based on the start time.
        :param filters: There are no supported filters.
        :param max_results: The maximum number of results to return with a single call.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :returns: DescribeNetworkInsightsAccessScopeAnalysesResult
        """
        raise NotImplementedError

    @handler("DescribeNetworkInsightsAccessScopes")
    def describe_network_insights_access_scopes(
        self,
        context: RequestContext,
        network_insights_access_scope_ids: NetworkInsightsAccessScopeIdList = None,
        filters: FilterList = None,
        max_results: NetworkInsightsMaxResults = None,
        dry_run: Boolean = None,
        next_token: NextToken = None,
    ) -> DescribeNetworkInsightsAccessScopesResult:
        """Describes the specified Network Access Scopes.

        :param network_insights_access_scope_ids: The IDs of the Network Access Scopes.
        :param filters: There are no supported filters.
        :param max_results: The maximum number of results to return with a single call.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :returns: DescribeNetworkInsightsAccessScopesResult
        """
        raise NotImplementedError

    @handler("DescribeNetworkInsightsAnalyses")
    def describe_network_insights_analyses(
        self,
        context: RequestContext,
        network_insights_analysis_ids: NetworkInsightsAnalysisIdList = None,
        network_insights_path_id: NetworkInsightsPathId = None,
        analysis_start_time: MillisecondDateTime = None,
        analysis_end_time: MillisecondDateTime = None,
        filters: FilterList = None,
        max_results: NetworkInsightsMaxResults = None,
        dry_run: Boolean = None,
        next_token: NextToken = None,
    ) -> DescribeNetworkInsightsAnalysesResult:
        """Describes one or more of your network insights analyses.

        :param network_insights_analysis_ids: The ID of the network insights analyses.
        :param network_insights_path_id: The ID of the path.
        :param analysis_start_time: The time when the network insights analyses started.
        :param analysis_end_time: The time when the network insights analyses ended.
        :param filters: The filters.
        :param max_results: The maximum number of results to return with a single call.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :returns: DescribeNetworkInsightsAnalysesResult
        """
        raise NotImplementedError

    @handler("DescribeNetworkInsightsPaths")
    def describe_network_insights_paths(
        self,
        context: RequestContext,
        network_insights_path_ids: NetworkInsightsPathIdList = None,
        filters: FilterList = None,
        max_results: NetworkInsightsMaxResults = None,
        dry_run: Boolean = None,
        next_token: NextToken = None,
    ) -> DescribeNetworkInsightsPathsResult:
        """Describes one or more of your paths.

        :param network_insights_path_ids: The IDs of the paths.
        :param filters: The filters.
        :param max_results: The maximum number of results to return with a single call.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :returns: DescribeNetworkInsightsPathsResult
        """
        raise NotImplementedError

    @handler("DescribeNetworkInterfaceAttribute")
    def describe_network_interface_attribute(
        self,
        context: RequestContext,
        network_interface_id: NetworkInterfaceId,
        attribute: NetworkInterfaceAttribute = None,
        dry_run: Boolean = None,
    ) -> DescribeNetworkInterfaceAttributeResult:
        """Describes a network interface attribute. You can specify only one
        attribute at a time.

        :param network_interface_id: The ID of the network interface.
        :param attribute: The attribute of the network interface.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeNetworkInterfaceAttributeResult
        """
        raise NotImplementedError

    @handler("DescribeNetworkInterfacePermissions")
    def describe_network_interface_permissions(
        self,
        context: RequestContext,
        network_interface_permission_ids: NetworkInterfacePermissionIdList = None,
        filters: FilterList = None,
        next_token: String = None,
        max_results: DescribeNetworkInterfacePermissionsMaxResults = None,
    ) -> DescribeNetworkInterfacePermissionsResult:
        """Describes the permissions for your network interfaces.

        :param network_interface_permission_ids: One or more network interface permission IDs.
        :param filters: One or more filters.
        :param next_token: The token to request the next page of results.
        :param max_results: The maximum number of results to return in a single call.
        :returns: DescribeNetworkInterfacePermissionsResult
        """
        raise NotImplementedError

    @handler("DescribeNetworkInterfaces")
    def describe_network_interfaces(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        network_interface_ids: NetworkInterfaceIdList = None,
        next_token: String = None,
        max_results: DescribeNetworkInterfacesMaxResults = None,
    ) -> DescribeNetworkInterfacesResult:
        """Describes one or more of your network interfaces.

        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param network_interface_ids: One or more network interface IDs.
        :param next_token: The token to retrieve the next page of results.
        :param max_results: The maximum number of items to return for this request.
        :returns: DescribeNetworkInterfacesResult
        """
        raise NotImplementedError

    @handler("DescribePlacementGroups")
    def describe_placement_groups(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        group_names: PlacementGroupStringList = None,
        group_ids: PlacementGroupIdStringList = None,
    ) -> DescribePlacementGroupsResult:
        """Describes the specified placement groups or all of your placement
        groups. For more information, see `Placement
        groups <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html>`__
        in the *Amazon EC2 User Guide*.

        :param filters: The filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param group_names: The names of the placement groups.
        :param group_ids: The IDs of the placement groups.
        :returns: DescribePlacementGroupsResult
        """
        raise NotImplementedError

    @handler("DescribePrefixLists")
    def describe_prefix_lists(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
        prefix_list_ids: PrefixListResourceIdStringList = None,
    ) -> DescribePrefixListsResult:
        """Describes available Amazon Web Services services in a prefix list
        format, which includes the prefix list name and prefix list ID of the
        service and the IP address range for the service.

        We recommend that you use DescribeManagedPrefixLists instead.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param prefix_list_ids: One or more prefix list IDs.
        :returns: DescribePrefixListsResult
        """
        raise NotImplementedError

    @handler("DescribePrincipalIdFormat")
    def describe_principal_id_format(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        resources: ResourceList = None,
        max_results: DescribePrincipalIdFormatMaxResults = None,
        next_token: String = None,
    ) -> DescribePrincipalIdFormatResult:
        """Describes the ID format settings for the root user and all IAM roles and
        IAM users that have explicitly specified a longer ID (17-character ID)
        preference.

        By default, all IAM roles and IAM users default to the same ID settings
        as the root user, unless they explicitly override the settings. This
        request is useful for identifying those IAM users and IAM roles that
        have overridden the default ID settings.

        The following resource types support longer IDs: ``bundle`` |
        ``conversion-task`` | ``customer-gateway`` | ``dhcp-options`` |
        ``elastic-ip-allocation`` | ``elastic-ip-association`` |
        ``export-task`` | ``flow-log`` | ``image`` | ``import-task`` |
        ``instance`` | ``internet-gateway`` | ``network-acl`` |
        ``network-acl-association`` | ``network-interface`` |
        ``network-interface-attachment`` | ``prefix-list`` | ``reservation``
        | ``route-table`` | ``route-table-association`` | ``security-group``
        | ``snapshot`` | ``subnet`` | ``subnet-cidr-block-association`` |
        ``volume`` | ``vpc`` | ``vpc-cidr-block-association`` |
        ``vpc-endpoint`` | ``vpc-peering-connection`` | ``vpn-connection`` |
        ``vpn-gateway``.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param resources: The type of resource: ``bundle`` | ``conversion-task`` |
        ``customer-gateway`` | ``dhcp-options`` | ``elastic-ip-allocation`` |
        ``elastic-ip-association`` | ``export-task`` | ``flow-log`` |
        ``image`` | ``import-task`` | ``instance`` | ``internet-gateway`` |
        ``network-acl`` | ``network-acl-association`` | ``network-interface``
        | ``network-interface-attachment`` | ``prefix-list`` |
        ``reservation`` | ``route-table`` | ``route-table-association`` |
        ``security-group`` | ``snapshot`` | ``subnet`` |
        ``subnet-cidr-block-association`` | ``volume`` | ``vpc`` |
        ``vpc-cidr-block-association`` | ``vpc-endpoint`` |
        ``vpc-peering-connection`` | ``vpn-connection`` | ``vpn-gateway``.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token to request the next page of results.
        :returns: DescribePrincipalIdFormatResult
        """
        raise NotImplementedError

    @handler("DescribePublicIpv4Pools")
    def describe_public_ipv4_pools(
        self,
        context: RequestContext,
        pool_ids: PublicIpv4PoolIdStringList = None,
        next_token: NextToken = None,
        max_results: PoolMaxResults = None,
        filters: FilterList = None,
    ) -> DescribePublicIpv4PoolsResult:
        """Describes the specified IPv4 address pools.

        :param pool_ids: The IDs of the address pools.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :param filters: One or more filters.
        :returns: DescribePublicIpv4PoolsResult
        """
        raise NotImplementedError

    @handler("DescribeRegions")
    def describe_regions(
        self,
        context: RequestContext,
        filters: FilterList = None,
        region_names: RegionNameStringList = None,
        dry_run: Boolean = None,
        all_regions: Boolean = None,
    ) -> DescribeRegionsResult:
        """Describes the Regions that are enabled for your account, or all Regions.

        For a list of the Regions supported by Amazon EC2, see `Amazon Elastic
        Compute Cloud endpoints and
        quotas <https://docs.aws.amazon.com/general/latest/gr/ec2-service.html>`__.

        For information about enabling and disabling Regions for your account,
        see `Managing Amazon Web Services
        Regions <https://docs.aws.amazon.com/general/latest/gr/rande-manage.html>`__
        in the *Amazon Web Services General Reference*.

        :param filters: The filters.
        :param region_names: The names of the Regions.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param all_regions: Indicates whether to display all Regions, including Regions that are
        disabled for your account.
        :returns: DescribeRegionsResult
        """
        raise NotImplementedError

    @handler("DescribeReplaceRootVolumeTasks")
    def describe_replace_root_volume_tasks(
        self,
        context: RequestContext,
        replace_root_volume_task_ids: ReplaceRootVolumeTaskIds = None,
        filters: FilterList = None,
        max_results: DescribeReplaceRootVolumeTasksMaxResults = None,
        next_token: NextToken = None,
        dry_run: Boolean = None,
    ) -> DescribeReplaceRootVolumeTasksResult:
        """Describes a root volume replacement task. For more information, see
        `Replace a root
        volume <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-restoring-volume.html#replace-root>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param replace_root_volume_task_ids: The ID of the root volume replacement task to view.
        :param filters: Filter to use:

        -  ``instance-id`` - The ID of the instance for which the root volume
           replacement task was created.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeReplaceRootVolumeTasksResult
        """
        raise NotImplementedError

    @handler("DescribeReservedInstances")
    def describe_reserved_instances(
        self,
        context: RequestContext,
        filters: FilterList = None,
        offering_class: OfferingClassType = None,
        reserved_instances_ids: ReservedInstancesIdStringList = None,
        dry_run: Boolean = None,
        offering_type: OfferingTypeValues = None,
    ) -> DescribeReservedInstancesResult:
        """Describes one or more of the Reserved Instances that you purchased.

        For more information about Reserved Instances, see `Reserved
        Instances <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html>`__
        in the *Amazon EC2 User Guide*.

        :param filters: One or more filters.
        :param offering_class: Describes whether the Reserved Instance is Standard or Convertible.
        :param reserved_instances_ids: One or more Reserved Instance IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param offering_type: The Reserved Instance offering type.
        :returns: DescribeReservedInstancesResult
        """
        raise NotImplementedError

    @handler("DescribeReservedInstancesListings")
    def describe_reserved_instances_listings(
        self,
        context: RequestContext,
        filters: FilterList = None,
        reserved_instances_id: ReservationId = None,
        reserved_instances_listing_id: ReservedInstancesListingId = None,
    ) -> DescribeReservedInstancesListingsResult:
        """Describes your account's Reserved Instance listings in the Reserved
        Instance Marketplace.

        The Reserved Instance Marketplace matches sellers who want to resell
        Reserved Instance capacity that they no longer need with buyers who want
        to purchase additional capacity. Reserved Instances bought and sold
        through the Reserved Instance Marketplace work like any other Reserved
        Instances.

        As a seller, you choose to list some or all of your Reserved Instances,
        and you specify the upfront price to receive for them. Your Reserved
        Instances are then listed in the Reserved Instance Marketplace and are
        available for purchase.

        As a buyer, you specify the configuration of the Reserved Instance to
        purchase, and the Marketplace matches what you're searching for with
        what's available. The Marketplace first sells the lowest priced Reserved
        Instances to you, and continues to sell available Reserved Instance
        listings to you until your demand is met. You are charged based on the
        total price of all of the listings that you purchase.

        For more information, see `Reserved Instance
        Marketplace <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html>`__
        in the *Amazon EC2 User Guide*.

        :param filters: One or more filters.
        :param reserved_instances_id: One or more Reserved Instance IDs.
        :param reserved_instances_listing_id: One or more Reserved Instance listing IDs.
        :returns: DescribeReservedInstancesListingsResult
        """
        raise NotImplementedError

    @handler("DescribeReservedInstancesModifications")
    def describe_reserved_instances_modifications(
        self,
        context: RequestContext,
        filters: FilterList = None,
        reserved_instances_modification_ids: ReservedInstancesModificationIdStringList = None,
        next_token: String = None,
    ) -> DescribeReservedInstancesModificationsResult:
        """Describes the modifications made to your Reserved Instances. If no
        parameter is specified, information about all your Reserved Instances
        modification requests is returned. If a modification ID is specified,
        only information about the specific modification is returned.

        For more information, see `Modifying Reserved
        Instances <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html>`__
        in the *Amazon EC2 User Guide*.

        :param filters: One or more filters.
        :param reserved_instances_modification_ids: IDs for the submitted modification request.
        :param next_token: The token to retrieve the next page of results.
        :returns: DescribeReservedInstancesModificationsResult
        """
        raise NotImplementedError

    @handler("DescribeReservedInstancesOfferings")
    def describe_reserved_instances_offerings(
        self,
        context: RequestContext,
        availability_zone: String = None,
        filters: FilterList = None,
        include_marketplace: Boolean = None,
        instance_type: InstanceType = None,
        max_duration: Long = None,
        max_instance_count: Integer = None,
        min_duration: Long = None,
        offering_class: OfferingClassType = None,
        product_description: RIProductDescription = None,
        reserved_instances_offering_ids: ReservedInstancesOfferingIdStringList = None,
        dry_run: Boolean = None,
        instance_tenancy: Tenancy = None,
        max_results: Integer = None,
        next_token: String = None,
        offering_type: OfferingTypeValues = None,
    ) -> DescribeReservedInstancesOfferingsResult:
        """Describes Reserved Instance offerings that are available for purchase.
        With Reserved Instances, you purchase the right to launch instances for
        a period of time. During that time period, you do not receive
        insufficient capacity errors, and you pay a lower usage rate than the
        rate charged for On-Demand instances for the actual time used.

        If you have listed your own Reserved Instances for sale in the Reserved
        Instance Marketplace, they will be excluded from these results. This is
        to ensure that you do not purchase your own Reserved Instances.

        For more information, see `Reserved Instance
        Marketplace <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html>`__
        in the *Amazon EC2 User Guide*.

        :param availability_zone: The Availability Zone in which the Reserved Instance can be used.
        :param filters: One or more filters.
        :param include_marketplace: Include Reserved Instance Marketplace offerings in the response.
        :param instance_type: The instance type that the reservation will cover (for example,
        ``m1.
        :param max_duration: The maximum duration (in seconds) to filter when searching for
        offerings.
        :param max_instance_count: The maximum number of instances to filter when searching for offerings.
        :param min_duration: The minimum duration (in seconds) to filter when searching for
        offerings.
        :param offering_class: The offering class of the Reserved Instance.
        :param product_description: The Reserved Instance product platform description.
        :param reserved_instances_offering_ids: One or more Reserved Instances offering IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param instance_tenancy: The tenancy of the instances covered by the reservation.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to retrieve the next page of results.
        :param offering_type: The Reserved Instance offering type.
        :returns: DescribeReservedInstancesOfferingsResult
        """
        raise NotImplementedError

    @handler("DescribeRouteTables")
    def describe_route_tables(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        route_table_ids: RouteTableIdStringList = None,
        next_token: String = None,
        max_results: DescribeRouteTablesMaxResults = None,
    ) -> DescribeRouteTablesResult:
        """Describes one or more of your route tables.

        Each subnet in your VPC must be associated with a route table. If a
        subnet is not explicitly associated with any route table, it is
        implicitly associated with the main route table. This command does not
        return the subnet ID for implicit associations.

        For more information, see `Route
        tables <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param route_table_ids: One or more route table IDs.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :returns: DescribeRouteTablesResult
        """
        raise NotImplementedError

    @handler("DescribeScheduledInstanceAvailability")
    def describe_scheduled_instance_availability(
        self,
        context: RequestContext,
        first_slot_start_time_range: SlotDateTimeRangeRequest,
        recurrence: ScheduledInstanceRecurrenceRequest,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: DescribeScheduledInstanceAvailabilityMaxResults = None,
        max_slot_duration_in_hours: Integer = None,
        min_slot_duration_in_hours: Integer = None,
        next_token: String = None,
    ) -> DescribeScheduledInstanceAvailabilityResult:
        """Finds available schedules that meet the specified criteria.

        You can search for an available schedule no more than 3 months in
        advance. You must meet the minimum required duration of 1,200 hours per
        year. For example, the minimum daily schedule is 4 hours, the minimum
        weekly schedule is 24 hours, and the minimum monthly schedule is 100
        hours.

        After you find a schedule that meets your needs, call
        PurchaseScheduledInstances to purchase Scheduled Instances with that
        schedule.

        :param first_slot_start_time_range: The time period for the first schedule to start.
        :param recurrence: The schedule recurrence.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: The filters.
        :param max_results: The maximum number of results to return in a single call.
        :param max_slot_duration_in_hours: The maximum available duration, in hours.
        :param min_slot_duration_in_hours: The minimum available duration, in hours.
        :param next_token: The token for the next set of results.
        :returns: DescribeScheduledInstanceAvailabilityResult
        """
        raise NotImplementedError

    @handler("DescribeScheduledInstances")
    def describe_scheduled_instances(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
        scheduled_instance_ids: ScheduledInstanceIdRequestSet = None,
        slot_start_time_range: SlotStartTimeRangeRequest = None,
    ) -> DescribeScheduledInstancesResult:
        """Describes the specified Scheduled Instances or all your Scheduled
        Instances.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: The filters.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token for the next set of results.
        :param scheduled_instance_ids: The Scheduled Instance IDs.
        :param slot_start_time_range: The time period for the first schedule to start.
        :returns: DescribeScheduledInstancesResult
        """
        raise NotImplementedError

    @handler("DescribeSecurityGroupReferences")
    def describe_security_group_references(
        self, context: RequestContext, group_id: GroupIds, dry_run: Boolean = None
    ) -> DescribeSecurityGroupReferencesResult:
        """[VPC only] Describes the VPCs on the other side of a VPC peering
        connection that are referencing the security groups you've specified in
        this request.

        :param group_id: The IDs of the security groups in your account.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeSecurityGroupReferencesResult
        """
        raise NotImplementedError

    @handler("DescribeSecurityGroupRules")
    def describe_security_group_rules(
        self,
        context: RequestContext,
        filters: FilterList = None,
        security_group_rule_ids: SecurityGroupRuleIdList = None,
        dry_run: Boolean = None,
        next_token: String = None,
        max_results: DescribeSecurityGroupRulesMaxResults = None,
    ) -> DescribeSecurityGroupRulesResult:
        """Describes one or more of your security group rules.

        :param filters: One or more filters.
        :param security_group_rule_ids: The IDs of the security group rules.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return in a single call.
        :returns: DescribeSecurityGroupRulesResult
        """
        raise NotImplementedError

    @handler("DescribeSecurityGroups")
    def describe_security_groups(
        self,
        context: RequestContext,
        filters: FilterList = None,
        group_ids: GroupIdStringList = None,
        group_names: GroupNameStringList = None,
        dry_run: Boolean = None,
        next_token: String = None,
        max_results: DescribeSecurityGroupsMaxResults = None,
    ) -> DescribeSecurityGroupsResult:
        """Describes the specified security groups or all of your security groups.

        A security group is for use with instances either in the EC2-Classic
        platform or in a specific VPC. For more information, see `Amazon EC2
        security
        groups <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html>`__
        in the *Amazon Elastic Compute Cloud User Guide* and `Security groups
        for your
        VPC <https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param filters: The filters.
        :param group_ids: The IDs of the security groups.
        :param group_names: [EC2-Classic and default VPC only] The names of the security groups.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token to request the next page of results.
        :param max_results: The maximum number of results to return in a single call.
        :returns: DescribeSecurityGroupsResult
        """
        raise NotImplementedError

    @handler("DescribeSnapshotAttribute")
    def describe_snapshot_attribute(
        self,
        context: RequestContext,
        attribute: SnapshotAttributeName,
        snapshot_id: SnapshotId,
        dry_run: Boolean = None,
    ) -> DescribeSnapshotAttributeResult:
        """Describes the specified attribute of the specified snapshot. You can
        specify only one attribute at a time.

        For more information about EBS snapshots, see `Amazon EBS
        snapshots <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param attribute: The snapshot attribute you would like to view.
        :param snapshot_id: The ID of the EBS snapshot.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeSnapshotAttributeResult
        """
        raise NotImplementedError

    @handler("DescribeSnapshotTierStatus")
    def describe_snapshot_tier_status(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        next_token: String = None,
        max_results: DescribeSnapshotTierStatusMaxResults = None,
    ) -> DescribeSnapshotTierStatusResult:
        """Describes the storage tier status of one or more Amazon EBS snapshots.

        :param filters: The filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :returns: DescribeSnapshotTierStatusResult
        """
        raise NotImplementedError

    @handler("DescribeSnapshots")
    def describe_snapshots(
        self,
        context: RequestContext,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
        owner_ids: OwnerStringList = None,
        restorable_by_user_ids: RestorableByStringList = None,
        snapshot_ids: SnapshotIdStringList = None,
        dry_run: Boolean = None,
    ) -> DescribeSnapshotsResult:
        """Describes the specified EBS snapshots available to you or all of the EBS
        snapshots available to you.

        The snapshots available to you include public snapshots, private
        snapshots that you own, and private snapshots owned by other Amazon Web
        Services accounts for which you have explicit create volume permissions.

        The create volume permissions fall into the following categories:

        -  *public*: The owner of the snapshot granted create volume permissions
           for the snapshot to the ``all`` group. All Amazon Web Services
           accounts have create volume permissions for these snapshots.

        -  *explicit*: The owner of the snapshot granted create volume
           permissions to a specific Amazon Web Services account.

        -  *implicit*: An Amazon Web Services account has implicit create volume
           permissions for all snapshots it owns.

        The list of snapshots returned can be filtered by specifying snapshot
        IDs, snapshot owners, or Amazon Web Services accounts with create volume
        permissions. If no options are specified, Amazon EC2 returns all
        snapshots for which you have create volume permissions.

        If you specify one or more snapshot IDs, only snapshots that have the
        specified IDs are returned. If you specify an invalid snapshot ID, an
        error is returned. If you specify a snapshot ID for which you do not
        have access, it is not included in the returned results.

        If you specify one or more snapshot owners using the ``OwnerIds``
        option, only snapshots from the specified owners and for which you have
        access are returned. The results can include the Amazon Web Services
        account IDs of the specified owners, ``amazon`` for snapshots owned by
        Amazon, or ``self`` for snapshots that you own.

        If you specify a list of restorable users, only snapshots with create
        snapshot permissions for those users are returned. You can specify
        Amazon Web Services account IDs (if you own the snapshots), ``self`` for
        snapshots for which you own or have explicit permissions, or ``all`` for
        public snapshots.

        If you are describing a long list of snapshots, we recommend that you
        paginate the output to make the list more manageable. The ``MaxResults``
        parameter sets the maximum number of results returned in a single page.
        If the list of results exceeds your ``MaxResults`` value, then that
        number of results is returned along with a ``NextToken`` value that can
        be passed to a subsequent ``DescribeSnapshots`` request to retrieve the
        remaining results.

        To get the state of fast snapshot restores for a snapshot, use
        DescribeFastSnapshotRestores.

        For more information about EBS snapshots, see `Amazon EBS
        snapshots <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param filters: The filters.
        :param max_results: The maximum number of snapshot results returned by ``DescribeSnapshots``
        in paginated output.
        :param next_token: The ``NextToken`` value returned from a previous paginated
        ``DescribeSnapshots`` request where ``MaxResults`` was used and the
        results exceeded the value of that parameter.
        :param owner_ids: Scopes the results to snapshots with the specified owners.
        :param restorable_by_user_ids: The IDs of the Amazon Web Services accounts that can create volumes from
        the snapshot.
        :param snapshot_ids: The snapshot IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeSnapshotsResult
        """
        raise NotImplementedError

    @handler("DescribeSpotDatafeedSubscription")
    def describe_spot_datafeed_subscription(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> DescribeSpotDatafeedSubscriptionResult:
        """Describes the data feed for Spot Instances. For more information, see
        `Spot Instance data
        feed <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html>`__
        in the *Amazon EC2 User Guide for Linux Instances*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeSpotDatafeedSubscriptionResult
        """
        raise NotImplementedError

    @handler("DescribeSpotFleetInstances")
    def describe_spot_fleet_instances(
        self,
        context: RequestContext,
        spot_fleet_request_id: SpotFleetRequestId,
        dry_run: Boolean = None,
        max_results: DescribeSpotFleetInstancesMaxResults = None,
        next_token: String = None,
    ) -> DescribeSpotFleetInstancesResponse:
        """Describes the running instances for the specified Spot Fleet.

        :param spot_fleet_request_id: The ID of the Spot Fleet request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token for the next set of results.
        :returns: DescribeSpotFleetInstancesResponse
        """
        raise NotImplementedError

    @handler("DescribeSpotFleetRequestHistory")
    def describe_spot_fleet_request_history(
        self,
        context: RequestContext,
        spot_fleet_request_id: SpotFleetRequestId,
        start_time: DateTime,
        dry_run: Boolean = None,
        event_type: EventType = None,
        max_results: DescribeSpotFleetRequestHistoryMaxResults = None,
        next_token: String = None,
    ) -> DescribeSpotFleetRequestHistoryResponse:
        """Describes the events for the specified Spot Fleet request during the
        specified time.

        Spot Fleet events are delayed by up to 30 seconds before they can be
        described. This ensures that you can query by the last evaluated time
        and not miss a recorded event. Spot Fleet events are available for 48
        hours.

        For more information, see `Monitor fleet events using Amazon
        EventBridge <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/fleet-monitor.html>`__
        in the *Amazon EC2 User Guide for Linux Instances*.

        :param spot_fleet_request_id: The ID of the Spot Fleet request.
        :param start_time: The starting date and time for the events, in UTC format (for example,
        *YYYY*-*MM*-*DD* T *HH*:*MM*:*SS* Z).
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param event_type: The type of events to describe.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token for the next set of results.
        :returns: DescribeSpotFleetRequestHistoryResponse
        """
        raise NotImplementedError

    @handler("DescribeSpotFleetRequests")
    def describe_spot_fleet_requests(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        max_results: Integer = None,
        next_token: String = None,
        spot_fleet_request_ids: SpotFleetRequestIdList = None,
    ) -> DescribeSpotFleetRequestsResponse:
        """Describes your Spot Fleet requests.

        Spot Fleet requests are deleted 48 hours after they are canceled and
        their instances are terminated.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token for the next set of results.
        :param spot_fleet_request_ids: The IDs of the Spot Fleet requests.
        :returns: DescribeSpotFleetRequestsResponse
        """
        raise NotImplementedError

    @handler("DescribeSpotInstanceRequests")
    def describe_spot_instance_requests(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        spot_instance_request_ids: SpotInstanceRequestIdList = None,
        next_token: String = None,
        max_results: Integer = None,
    ) -> DescribeSpotInstanceRequestsResult:
        """Describes the specified Spot Instance requests.

        You can use ``DescribeSpotInstanceRequests`` to find a running Spot
        Instance by examining the response. If the status of the Spot Instance
        is ``fulfilled``, the instance ID appears in the response and contains
        the identifier of the instance. Alternatively, you can use
        `DescribeInstances <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances>`__
        with a filter to look for instances where the instance lifecycle is
        ``spot``.

        We recommend that you set ``MaxResults`` to a value between 5 and 1000
        to limit the number of results returned. This paginates the output,
        which makes the list more manageable and returns the results faster. If
        the list of results exceeds your ``MaxResults`` value, then that number
        of results is returned along with a ``NextToken`` value that can be
        passed to a subsequent ``DescribeSpotInstanceRequests`` request to
        retrieve the remaining results.

        Spot Instance requests are deleted four hours after they are canceled
        and their instances are terminated.

        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param spot_instance_request_ids: One or more Spot Instance request IDs.
        :param next_token: The token to request the next set of results.
        :param max_results: The maximum number of results to return in a single call.
        :returns: DescribeSpotInstanceRequestsResult
        """
        raise NotImplementedError

    @handler("DescribeSpotPriceHistory")
    def describe_spot_price_history(
        self,
        context: RequestContext,
        filters: FilterList = None,
        availability_zone: String = None,
        dry_run: Boolean = None,
        end_time: DateTime = None,
        instance_types: InstanceTypeList = None,
        max_results: Integer = None,
        next_token: String = None,
        product_descriptions: ProductDescriptionList = None,
        start_time: DateTime = None,
    ) -> DescribeSpotPriceHistoryResult:
        """Describes the Spot price history. For more information, see `Spot
        Instance pricing
        history <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html>`__
        in the *Amazon EC2 User Guide for Linux Instances*.

        When you specify a start and end time, the operation returns the prices
        of the instance types within that time range. It also returns the last
        price change before the start time, which is the effective price as of
        the start time.

        :param filters: One or more filters.
        :param availability_zone: Filters the results by the specified Availability Zone.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param end_time: The date and time, up to the current date, from which to stop retrieving
        the price history data, in UTC format (for example,
        *YYYY*-*MM*-*DD* T *HH*:*MM*:*SS* Z).
        :param instance_types: Filters the results by the specified instance types.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token for the next set of results.
        :param product_descriptions: Filters the results by the specified basic product descriptions.
        :param start_time: The date and time, up to the past 90 days, from which to start
        retrieving the price history data, in UTC format (for example,
        *YYYY*-*MM*-*DD* T *HH*:*MM*:*SS* Z).
        :returns: DescribeSpotPriceHistoryResult
        """
        raise NotImplementedError

    @handler("DescribeStaleSecurityGroups")
    def describe_stale_security_groups(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        dry_run: Boolean = None,
        max_results: DescribeStaleSecurityGroupsMaxResults = None,
        next_token: DescribeStaleSecurityGroupsNextToken = None,
    ) -> DescribeStaleSecurityGroupsResult:
        """[VPC only] Describes the stale security group rules for security groups
        in a specified VPC. Rules are stale when they reference a deleted
        security group in the same VPC or in a peer VPC, or if they reference a
        security group in a peer VPC for which the VPC peering connection has
        been deleted.

        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param max_results: The maximum number of items to return for this request.
        :param next_token: The token for the next set of items to return.
        :returns: DescribeStaleSecurityGroupsResult
        """
        raise NotImplementedError

    @handler("DescribeStoreImageTasks")
    def describe_store_image_tasks(
        self,
        context: RequestContext,
        image_ids: ImageIdList = None,
        dry_run: Boolean = None,
        filters: FilterList = None,
        next_token: String = None,
        max_results: DescribeStoreImageTasksRequestMaxResults = None,
    ) -> DescribeStoreImageTasksResult:
        """Describes the progress of the AMI store tasks. You can describe the
        store tasks for specified AMIs. If you don't specify the AMIs, you get a
        paginated list of store tasks from the last 31 days.

        For each AMI task, the response indicates if the task is ``InProgress``,
        ``Completed``, or ``Failed``. For tasks ``InProgress``, the response
        shows the estimated progress as a percentage.

        Tasks are listed in reverse chronological order. Currently, only tasks
        from the past 31 days can be viewed.

        To use this API, you must have the required permissions. For more
        information, see `Permissions for storing and restoring AMIs using
        Amazon
        S3 <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html#ami-s3-permissions>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        For more information, see `Store and restore an AMI using Amazon
        S3 <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param image_ids: The AMI IDs for which to show progress.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: The filters.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return in a single call.
        :returns: DescribeStoreImageTasksResult
        """
        raise NotImplementedError

    @handler("DescribeSubnets")
    def describe_subnets(
        self,
        context: RequestContext,
        filters: FilterList = None,
        subnet_ids: SubnetIdStringList = None,
        dry_run: Boolean = None,
        next_token: String = None,
        max_results: DescribeSubnetsMaxResults = None,
    ) -> DescribeSubnetsResult:
        """Describes one or more of your subnets.

        For more information, see `Your VPC and
        subnets <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param filters: One or more filters.
        :param subnet_ids: One or more subnet IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :returns: DescribeSubnetsResult
        """
        raise NotImplementedError

    @handler("DescribeTags")
    def describe_tags(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeTagsResult:
        """Describes the specified tags for your EC2 resources.

        For more information about tags, see `Tagging Your
        Resources <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: The filters.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token to retrieve the next page of results.
        :returns: DescribeTagsResult
        """
        raise NotImplementedError

    @handler("DescribeTrafficMirrorFilters")
    def describe_traffic_mirror_filters(
        self,
        context: RequestContext,
        traffic_mirror_filter_ids: TrafficMirrorFilterIdList = None,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: TrafficMirroringMaxResults = None,
        next_token: NextToken = None,
    ) -> DescribeTrafficMirrorFiltersResult:
        """Describes one or more Traffic Mirror filters.

        :param traffic_mirror_filter_ids: The ID of the Traffic Mirror filter.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :returns: DescribeTrafficMirrorFiltersResult
        """
        raise NotImplementedError

    @handler("DescribeTrafficMirrorSessions")
    def describe_traffic_mirror_sessions(
        self,
        context: RequestContext,
        traffic_mirror_session_ids: TrafficMirrorSessionIdList = None,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: TrafficMirroringMaxResults = None,
        next_token: NextToken = None,
    ) -> DescribeTrafficMirrorSessionsResult:
        """Describes one or more Traffic Mirror sessions. By default, all Traffic
        Mirror sessions are described. Alternatively, you can filter the
        results.

        :param traffic_mirror_session_ids: The ID of the Traffic Mirror session.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :returns: DescribeTrafficMirrorSessionsResult
        """
        raise NotImplementedError

    @handler("DescribeTrafficMirrorTargets")
    def describe_traffic_mirror_targets(
        self,
        context: RequestContext,
        traffic_mirror_target_ids: TrafficMirrorTargetIdList = None,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: TrafficMirroringMaxResults = None,
        next_token: NextToken = None,
    ) -> DescribeTrafficMirrorTargetsResult:
        """Information about one or more Traffic Mirror targets.

        :param traffic_mirror_target_ids: The ID of the Traffic Mirror targets.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :returns: DescribeTrafficMirrorTargetsResult
        """
        raise NotImplementedError

    @handler("DescribeTransitGatewayAttachments")
    def describe_transit_gateway_attachments(
        self,
        context: RequestContext,
        transit_gateway_attachment_ids: TransitGatewayAttachmentIdStringList = None,
        filters: FilterList = None,
        max_results: TransitGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeTransitGatewayAttachmentsResult:
        """Describes one or more attachments between resources and transit
        gateways. By default, all attachments are described. Alternatively, you
        can filter the results by attachment ID, attachment state, resource ID,
        or resource owner.

        :param transit_gateway_attachment_ids: The IDs of the attachments.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeTransitGatewayAttachmentsResult
        """
        raise NotImplementedError

    @handler("DescribeTransitGatewayConnectPeers")
    def describe_transit_gateway_connect_peers(
        self,
        context: RequestContext,
        transit_gateway_connect_peer_ids: TransitGatewayConnectPeerIdStringList = None,
        filters: FilterList = None,
        max_results: TransitGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeTransitGatewayConnectPeersResult:
        """Describes one or more Connect peers.

        :param transit_gateway_connect_peer_ids: The IDs of the Connect peers.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeTransitGatewayConnectPeersResult
        """
        raise NotImplementedError

    @handler("DescribeTransitGatewayConnects")
    def describe_transit_gateway_connects(
        self,
        context: RequestContext,
        transit_gateway_attachment_ids: TransitGatewayAttachmentIdStringList = None,
        filters: FilterList = None,
        max_results: TransitGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeTransitGatewayConnectsResult:
        """Describes one or more Connect attachments.

        :param transit_gateway_attachment_ids: The IDs of the attachments.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeTransitGatewayConnectsResult
        """
        raise NotImplementedError

    @handler("DescribeTransitGatewayMulticastDomains")
    def describe_transit_gateway_multicast_domains(
        self,
        context: RequestContext,
        transit_gateway_multicast_domain_ids: TransitGatewayMulticastDomainIdStringList = None,
        filters: FilterList = None,
        max_results: TransitGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeTransitGatewayMulticastDomainsResult:
        """Describes one or more transit gateway multicast domains.

        :param transit_gateway_multicast_domain_ids: The ID of the transit gateway multicast domain.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeTransitGatewayMulticastDomainsResult
        """
        raise NotImplementedError

    @handler("DescribeTransitGatewayPeeringAttachments")
    def describe_transit_gateway_peering_attachments(
        self,
        context: RequestContext,
        transit_gateway_attachment_ids: TransitGatewayAttachmentIdStringList = None,
        filters: FilterList = None,
        max_results: TransitGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeTransitGatewayPeeringAttachmentsResult:
        """Describes your transit gateway peering attachments.

        :param transit_gateway_attachment_ids: One or more IDs of the transit gateway peering attachments.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeTransitGatewayPeeringAttachmentsResult
        """
        raise NotImplementedError

    @handler("DescribeTransitGatewayRouteTables")
    def describe_transit_gateway_route_tables(
        self,
        context: RequestContext,
        transit_gateway_route_table_ids: TransitGatewayRouteTableIdStringList = None,
        filters: FilterList = None,
        max_results: TransitGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeTransitGatewayRouteTablesResult:
        """Describes one or more transit gateway route tables. By default, all
        transit gateway route tables are described. Alternatively, you can
        filter the results.

        :param transit_gateway_route_table_ids: The IDs of the transit gateway route tables.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeTransitGatewayRouteTablesResult
        """
        raise NotImplementedError

    @handler("DescribeTransitGatewayVpcAttachments")
    def describe_transit_gateway_vpc_attachments(
        self,
        context: RequestContext,
        transit_gateway_attachment_ids: TransitGatewayAttachmentIdStringList = None,
        filters: FilterList = None,
        max_results: TransitGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeTransitGatewayVpcAttachmentsResult:
        """Describes one or more VPC attachments. By default, all VPC attachments
        are described. Alternatively, you can filter the results.

        :param transit_gateway_attachment_ids: The IDs of the attachments.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeTransitGatewayVpcAttachmentsResult
        """
        raise NotImplementedError

    @handler("DescribeTransitGateways")
    def describe_transit_gateways(
        self,
        context: RequestContext,
        transit_gateway_ids: TransitGatewayIdStringList = None,
        filters: FilterList = None,
        max_results: TransitGatewayMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> DescribeTransitGatewaysResult:
        """Describes one or more transit gateways. By default, all transit gateways
        are described. Alternatively, you can filter the results.

        :param transit_gateway_ids: The IDs of the transit gateways.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeTransitGatewaysResult
        """
        raise NotImplementedError

    @handler("DescribeTrunkInterfaceAssociations")
    def describe_trunk_interface_associations(
        self,
        context: RequestContext,
        association_ids: TrunkInterfaceAssociationIdList = None,
        dry_run: Boolean = None,
        filters: FilterList = None,
        next_token: String = None,
        max_results: DescribeTrunkInterfaceAssociationsMaxResults = None,
    ) -> DescribeTrunkInterfaceAssociationsResult:
        """This API action is currently in **limited preview only**. If you are
        interested in using this feature, contact your account manager.

        Describes one or more network interface trunk associations.

        :param association_ids: The IDs of the associations.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: One or more filters.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :returns: DescribeTrunkInterfaceAssociationsResult
        """
        raise NotImplementedError

    @handler("DescribeVolumeAttribute")
    def describe_volume_attribute(
        self,
        context: RequestContext,
        attribute: VolumeAttributeName,
        volume_id: VolumeId,
        dry_run: Boolean = None,
    ) -> DescribeVolumeAttributeResult:
        """Describes the specified attribute of the specified volume. You can
        specify only one attribute at a time.

        For more information about EBS volumes, see `Amazon EBS
        volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param attribute: The attribute of the volume.
        :param volume_id: The ID of the volume.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeVolumeAttributeResult
        """
        raise NotImplementedError

    @handler("DescribeVolumeStatus")
    def describe_volume_status(
        self,
        context: RequestContext,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
        volume_ids: VolumeIdStringList = None,
        dry_run: Boolean = None,
    ) -> DescribeVolumeStatusResult:
        """Describes the status of the specified volumes. Volume status provides
        the result of the checks performed on your volumes to determine events
        that can impair the performance of your volumes. The performance of a
        volume can be affected if an issue occurs on the volume's underlying
        host. If the volume's underlying host experiences a power outage or
        system issue, after the system is restored, there could be data
        inconsistencies on the volume. Volume events notify you if this occurs.
        Volume actions notify you if any action needs to be taken in response to
        the event.

        The ``DescribeVolumeStatus`` operation provides the following
        information about the specified volumes:

        *Status*: Reflects the current status of the volume. The possible values
        are ``ok``, ``impaired`` , ``warning``, or ``insufficient-data``. If all
        checks pass, the overall status of the volume is ``ok``. If the check
        fails, the overall status is ``impaired``. If the status is
        ``insufficient-data``, then the checks might still be taking place on
        your volume at the time. We recommend that you retry the request. For
        more information about volume status, see `Monitor the status of your
        volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        *Events*: Reflect the cause of a volume status and might require you to
        take action. For example, if your volume returns an ``impaired`` status,
        then the volume event might be ``potential-data-inconsistency``. This
        means that your volume has been affected by an issue with the underlying
        host, has all I/O operations disabled, and might have inconsistent data.

        *Actions*: Reflect the actions you might have to take in response to an
        event. For example, if the status of the volume is ``impaired`` and the
        volume event shows ``potential-data-inconsistency``, then the action
        shows ``enable-volume-io``. This means that you may want to enable the
        I/O operations for the volume by calling the EnableVolumeIO action and
        then check the volume for data consistency.

        Volume status is based on the volume status checks, and does not reflect
        the volume state. Therefore, volume status does not indicate volumes in
        the ``error`` state (for example, when a volume is incapable of
        accepting I/O.)

        :param filters: The filters.
        :param max_results: The maximum number of volume results returned by
        ``DescribeVolumeStatus`` in paginated output.
        :param next_token: The ``NextToken`` value to include in a future ``DescribeVolumeStatus``
        request.
        :param volume_ids: The IDs of the volumes.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeVolumeStatusResult
        """
        raise NotImplementedError

    @handler("DescribeVolumes")
    def describe_volumes(
        self,
        context: RequestContext,
        filters: FilterList = None,
        volume_ids: VolumeIdStringList = None,
        dry_run: Boolean = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeVolumesResult:
        """Describes the specified EBS volumes or all of your EBS volumes.

        If you are describing a long list of volumes, we recommend that you
        paginate the output to make the list more manageable. The ``MaxResults``
        parameter sets the maximum number of results returned in a single page.
        If the list of results exceeds your ``MaxResults`` value, then that
        number of results is returned along with a ``NextToken`` value that can
        be passed to a subsequent ``DescribeVolumes`` request to retrieve the
        remaining results.

        For more information about EBS volumes, see `Amazon EBS
        volumes <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param filters: The filters.
        :param volume_ids: The volume IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param max_results: The maximum number of volume results returned by ``DescribeVolumes`` in
        paginated output.
        :param next_token: The ``NextToken`` value returned from a previous paginated
        ``DescribeVolumes`` request where ``MaxResults`` was used and the
        results exceeded the value of that parameter.
        :returns: DescribeVolumesResult
        """
        raise NotImplementedError

    @handler("DescribeVolumesModifications")
    def describe_volumes_modifications(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        volume_ids: VolumeIdStringList = None,
        filters: FilterList = None,
        next_token: String = None,
        max_results: Integer = None,
    ) -> DescribeVolumesModificationsResult:
        """Describes the most recent volume modification request for the specified
        EBS volumes.

        If a volume has never been modified, some information in the output will
        be null. If a volume has been modified more than once, the output
        includes only the most recent modification request.

        You can also use CloudWatch Events to check the status of a modification
        to an EBS volume. For information about CloudWatch Events, see the
        `Amazon CloudWatch Events User
        Guide <https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/>`__.
        For more information, see `Monitor the progress of volume
        modifications <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-modifications.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param volume_ids: The IDs of the volumes.
        :param filters: The filters.
        :param next_token: The ``nextToken`` value returned by a previous paginated request.
        :param max_results: The maximum number of results (up to a limit of 500) to be returned in a
        paginated request.
        :returns: DescribeVolumesModificationsResult
        """
        raise NotImplementedError

    @handler("DescribeVpcAttribute")
    def describe_vpc_attribute(
        self,
        context: RequestContext,
        attribute: VpcAttributeName,
        vpc_id: VpcId,
        dry_run: Boolean = None,
    ) -> DescribeVpcAttributeResult:
        """Describes the specified attribute of the specified VPC. You can specify
        only one attribute at a time.

        :param attribute: The VPC attribute.
        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeVpcAttributeResult
        """
        raise NotImplementedError

    @handler("DescribeVpcClassicLink")
    def describe_vpc_classic_link(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        vpc_ids: VpcClassicLinkIdList = None,
    ) -> DescribeVpcClassicLinkResult:
        """Describes the ClassicLink status of one or more VPCs.

        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param vpc_ids: One or more VPCs for which you want to describe the ClassicLink status.
        :returns: DescribeVpcClassicLinkResult
        """
        raise NotImplementedError

    @handler("DescribeVpcClassicLinkDnsSupport")
    def describe_vpc_classic_link_dns_support(
        self,
        context: RequestContext,
        max_results: DescribeVpcClassicLinkDnsSupportMaxResults = None,
        next_token: DescribeVpcClassicLinkDnsSupportNextToken = None,
        vpc_ids: VpcClassicLinkIdList = None,
    ) -> DescribeVpcClassicLinkDnsSupportResult:
        """Describes the ClassicLink DNS support status of one or more VPCs. If
        enabled, the DNS hostname of a linked EC2-Classic instance resolves to
        its private IP address when addressed from an instance in the VPC to
        which it's linked. Similarly, the DNS hostname of an instance in a VPC
        resolves to its private IP address when addressed from a linked
        EC2-Classic instance. For more information, see
        `ClassicLink <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param vpc_ids: One or more VPC IDs.
        :returns: DescribeVpcClassicLinkDnsSupportResult
        """
        raise NotImplementedError

    @handler("DescribeVpcEndpointConnectionNotifications")
    def describe_vpc_endpoint_connection_notifications(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        connection_notification_id: ConnectionNotificationId = None,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeVpcEndpointConnectionNotificationsResult:
        """Describes the connection notifications for VPC endpoints and VPC
        endpoint services.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param connection_notification_id: The ID of the notification.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return in a single call.
        :param next_token: The token to request the next page of results.
        :returns: DescribeVpcEndpointConnectionNotificationsResult
        """
        raise NotImplementedError

    @handler("DescribeVpcEndpointConnections")
    def describe_vpc_endpoint_connections(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeVpcEndpointConnectionsResult:
        """Describes the VPC endpoint connections to your VPC endpoint services,
        including any endpoints that are pending your acceptance.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to retrieve the next page of results.
        :returns: DescribeVpcEndpointConnectionsResult
        """
        raise NotImplementedError

    @handler("DescribeVpcEndpointServiceConfigurations")
    def describe_vpc_endpoint_service_configurations(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        service_ids: VpcEndpointServiceIdList = None,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeVpcEndpointServiceConfigurationsResult:
        """Describes the VPC endpoint service configurations in your account (your
        services).

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param service_ids: The IDs of one or more services.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to retrieve the next page of results.
        :returns: DescribeVpcEndpointServiceConfigurationsResult
        """
        raise NotImplementedError

    @handler("DescribeVpcEndpointServicePermissions")
    def describe_vpc_endpoint_service_permissions(
        self,
        context: RequestContext,
        service_id: VpcEndpointServiceId,
        dry_run: Boolean = None,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeVpcEndpointServicePermissionsResult:
        """Describes the principals (service consumers) that are permitted to
        discover your VPC endpoint service.

        :param service_id: The ID of the service.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param filters: One or more filters.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param next_token: The token to retrieve the next page of results.
        :returns: DescribeVpcEndpointServicePermissionsResult
        """
        raise NotImplementedError

    @handler("DescribeVpcEndpointServices")
    def describe_vpc_endpoint_services(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        service_names: ValueStringList = None,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeVpcEndpointServicesResult:
        """Describes available services to which you can create a VPC endpoint.

        When the service provider and the consumer have different accounts in
        multiple Availability Zones, and the consumer views the VPC endpoint
        service information, the response only includes the common Availability
        Zones. For example, when the service provider account uses
        ``us-east-1a`` and ``us-east-1c`` and the consumer uses ``us-east-1a``
        and ``us-east-1b``, the response includes the VPC endpoint services in
        the common Availability Zone, ``us-east-1a``.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param service_names: One or more service names.
        :param filters: One or more filters.
        :param max_results: The maximum number of items to return for this request.
        :param next_token: The token for the next set of items to return.
        :returns: DescribeVpcEndpointServicesResult
        """
        raise NotImplementedError

    @handler("DescribeVpcEndpoints")
    def describe_vpc_endpoints(
        self,
        context: RequestContext,
        dry_run: Boolean = None,
        vpc_endpoint_ids: VpcEndpointIdList = None,
        filters: FilterList = None,
        max_results: Integer = None,
        next_token: String = None,
    ) -> DescribeVpcEndpointsResult:
        """Describes one or more of your VPC endpoints.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param vpc_endpoint_ids: One or more endpoint IDs.
        :param filters: One or more filters.
        :param max_results: The maximum number of items to return for this request.
        :param next_token: The token for the next set of items to return.
        :returns: DescribeVpcEndpointsResult
        """
        raise NotImplementedError

    @handler("DescribeVpcPeeringConnections")
    def describe_vpc_peering_connections(
        self,
        context: RequestContext,
        filters: FilterList = None,
        dry_run: Boolean = None,
        vpc_peering_connection_ids: VpcPeeringConnectionIdList = None,
        next_token: String = None,
        max_results: DescribeVpcPeeringConnectionsMaxResults = None,
    ) -> DescribeVpcPeeringConnectionsResult:
        """Describes one or more of your VPC peering connections.

        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param vpc_peering_connection_ids: One or more VPC peering connection IDs.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :returns: DescribeVpcPeeringConnectionsResult
        """
        raise NotImplementedError

    @handler("DescribeVpcs")
    def describe_vpcs(
        self,
        context: RequestContext,
        filters: FilterList = None,
        vpc_ids: VpcIdStringList = None,
        dry_run: Boolean = None,
        next_token: String = None,
        max_results: DescribeVpcsMaxResults = None,
    ) -> DescribeVpcsResult:
        """Describes one or more of your VPCs.

        :param filters: One or more filters.
        :param vpc_ids: One or more VPC IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :returns: DescribeVpcsResult
        """
        raise NotImplementedError

    @handler("DescribeVpnConnections")
    def describe_vpn_connections(
        self,
        context: RequestContext,
        filters: FilterList = None,
        vpn_connection_ids: VpnConnectionIdStringList = None,
        dry_run: Boolean = None,
    ) -> DescribeVpnConnectionsResult:
        """Describes one or more of your VPN connections.

        For more information, see `Amazon Web Services Site-to-Site
        VPN <https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html>`__ in
        the *Amazon Web Services Site-to-Site VPN User Guide*.

        :param filters: One or more filters.
        :param vpn_connection_ids: One or more VPN connection IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeVpnConnectionsResult
        """
        raise NotImplementedError

    @handler("DescribeVpnGateways")
    def describe_vpn_gateways(
        self,
        context: RequestContext,
        filters: FilterList = None,
        vpn_gateway_ids: VpnGatewayIdStringList = None,
        dry_run: Boolean = None,
    ) -> DescribeVpnGatewaysResult:
        """Describes one or more of your virtual private gateways.

        For more information, see `Amazon Web Services Site-to-Site
        VPN <https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html>`__ in
        the *Amazon Web Services Site-to-Site VPN User Guide*.

        :param filters: One or more filters.
        :param vpn_gateway_ids: One or more virtual private gateway IDs.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DescribeVpnGatewaysResult
        """
        raise NotImplementedError

    @handler("DetachClassicLinkVpc")
    def detach_classic_link_vpc(
        self,
        context: RequestContext,
        instance_id: InstanceId,
        vpc_id: VpcId,
        dry_run: Boolean = None,
    ) -> DetachClassicLinkVpcResult:
        """Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the
        instance has been unlinked, the VPC security groups are no longer
        associated with it. An instance is automatically unlinked from a VPC
        when it's stopped.

        :param instance_id: The ID of the instance to unlink from the VPC.
        :param vpc_id: The ID of the VPC to which the instance is linked.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DetachClassicLinkVpcResult
        """
        raise NotImplementedError

    @handler("DetachInternetGateway")
    def detach_internet_gateway(
        self,
        context: RequestContext,
        internet_gateway_id: InternetGatewayId,
        vpc_id: VpcId,
        dry_run: Boolean = None,
    ) -> None:
        """Detaches an internet gateway from a VPC, disabling connectivity between
        the internet and the VPC. The VPC must not contain any running instances
        with Elastic IP addresses or public IPv4 addresses.

        :param internet_gateway_id: The ID of the internet gateway.
        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DetachNetworkInterface")
    def detach_network_interface(
        self,
        context: RequestContext,
        attachment_id: NetworkInterfaceAttachmentId,
        dry_run: Boolean = None,
        force: Boolean = None,
    ) -> None:
        """Detaches a network interface from an instance.

        :param attachment_id: The ID of the attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param force: Specifies whether to force a detachment.
        """
        raise NotImplementedError

    @handler("DetachVolume")
    def detach_volume(
        self,
        context: RequestContext,
        volume_id: VolumeId,
        device: String = None,
        force: Boolean = None,
        instance_id: InstanceId = None,
        dry_run: Boolean = None,
    ) -> VolumeAttachment:
        """Detaches an EBS volume from an instance. Make sure to unmount any file
        systems on the device within your operating system before detaching the
        volume. Failure to do so can result in the volume becoming stuck in the
        ``busy`` state while detaching. If this happens, detachment can be
        delayed indefinitely until you unmount the volume, force detachment,
        reboot the instance, or all three. If an EBS volume is the root device
        of an instance, it can't be detached while the instance is running. To
        detach the root volume, stop the instance first.

        When a volume with an Amazon Web Services Marketplace product code is
        detached from an instance, the product code is no longer associated with
        the instance.

        For more information, see `Detach an Amazon EBS
        volume <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param volume_id: The ID of the volume.
        :param device: The device name.
        :param force: Forces detachment if the previous detachment attempt did not occur
        cleanly (for example, logging into an instance, unmounting the volume,
        and detaching normally).
        :param instance_id: The ID of the instance.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: VolumeAttachment
        """
        raise NotImplementedError

    @handler("DetachVpnGateway")
    def detach_vpn_gateway(
        self,
        context: RequestContext,
        vpc_id: VpcId,
        vpn_gateway_id: VpnGatewayId,
        dry_run: Boolean = None,
    ) -> None:
        """Detaches a virtual private gateway from a VPC. You do this if you're
        planning to turn off the VPC and not use it anymore. You can confirm a
        virtual private gateway has been completely detached from a VPC by
        describing the virtual private gateway (any attachments to the virtual
        private gateway are also described).

        You must wait for the attachment's state to switch to ``detached``
        before you can delete the VPC or attach a different VPC to the virtual
        private gateway.

        :param vpc_id: The ID of the VPC.
        :param vpn_gateway_id: The ID of the virtual private gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DisableEbsEncryptionByDefault")
    def disable_ebs_encryption_by_default(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> DisableEbsEncryptionByDefaultResult:
        """Disables EBS encryption by default for your account in the current
        Region.

        After you disable encryption by default, you can still create encrypted
        volumes by enabling encryption when you create each volume.

        Disabling encryption by default does not change the encryption status of
        your existing volumes.

        For more information, see `Amazon EBS
        encryption <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisableEbsEncryptionByDefaultResult
        """
        raise NotImplementedError

    @handler("DisableFastLaunch")
    def disable_fast_launch(
        self,
        context: RequestContext,
        image_id: ImageId,
        force: Boolean = None,
        dry_run: Boolean = None,
    ) -> DisableFastLaunchResult:
        """Discontinue faster launching for a Windows AMI, and clean up existing
        pre-provisioned snapshots. When you disable faster launching, the AMI
        uses the standard launch process for each instance. All pre-provisioned
        snapshots must be removed before you can enable faster launching again.

        :param image_id: The ID of the image for which you’re turning off faster launching, and
        removing pre-provisioned snapshots.
        :param force: Forces the image settings to turn off faster launching for your Windows
        AMI.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisableFastLaunchResult
        """
        raise NotImplementedError

    @handler("DisableFastSnapshotRestores")
    def disable_fast_snapshot_restores(
        self,
        context: RequestContext,
        availability_zones: AvailabilityZoneStringList,
        source_snapshot_ids: SnapshotIdStringList,
        dry_run: Boolean = None,
    ) -> DisableFastSnapshotRestoresResult:
        """Disables fast snapshot restores for the specified snapshots in the
        specified Availability Zones.

        :param availability_zones: One or more Availability Zones.
        :param source_snapshot_ids: The IDs of one or more snapshots.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisableFastSnapshotRestoresResult
        """
        raise NotImplementedError

    @handler("DisableImageDeprecation")
    def disable_image_deprecation(
        self, context: RequestContext, image_id: ImageId, dry_run: Boolean = None
    ) -> DisableImageDeprecationResult:
        """Cancels the deprecation of the specified AMI.

        For more information, see `Deprecate an
        AMI <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param image_id: The ID of the AMI.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisableImageDeprecationResult
        """
        raise NotImplementedError

    @handler("DisableIpamOrganizationAdminAccount")
    def disable_ipam_organization_admin_account(
        self, context: RequestContext, delegated_admin_account_id: String, dry_run: Boolean = None
    ) -> DisableIpamOrganizationAdminAccountResult:
        """Disable the IPAM account. For more information, see `Enable integration
        with Organizations </vpc/latest/ipam/enable-integ-ipam.html>`__ in the
        *Amazon VPC IPAM User Guide*.

        :param delegated_admin_account_id: The Organizations member account ID that you want to disable as IPAM
        account.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :returns: DisableIpamOrganizationAdminAccountResult
        """
        raise NotImplementedError

    @handler("DisableSerialConsoleAccess")
    def disable_serial_console_access(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> DisableSerialConsoleAccessResult:
        """Disables access to the EC2 serial console of all instances for your
        account. By default, access to the EC2 serial console is disabled for
        your account. For more information, see `Manage account access to the
        EC2 serial
        console <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access>`__
        in the *Amazon EC2 User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisableSerialConsoleAccessResult
        """
        raise NotImplementedError

    @handler("DisableTransitGatewayRouteTablePropagation")
    def disable_transit_gateway_route_table_propagation(
        self,
        context: RequestContext,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        dry_run: Boolean = None,
    ) -> DisableTransitGatewayRouteTablePropagationResult:
        """Disables the specified resource attachment from propagating routes to
        the specified propagation route table.

        :param transit_gateway_route_table_id: The ID of the propagation route table.
        :param transit_gateway_attachment_id: The ID of the attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisableTransitGatewayRouteTablePropagationResult
        """
        raise NotImplementedError

    @handler("DisableVgwRoutePropagation")
    def disable_vgw_route_propagation(
        self,
        context: RequestContext,
        gateway_id: VpnGatewayId,
        route_table_id: RouteTableId,
        dry_run: Boolean = None,
    ) -> None:
        """Disables a virtual private gateway (VGW) from propagating routes to a
        specified route table of a VPC.

        :param gateway_id: The ID of the virtual private gateway.
        :param route_table_id: The ID of the route table.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DisableVpcClassicLink")
    def disable_vpc_classic_link(
        self, context: RequestContext, vpc_id: VpcId, dry_run: Boolean = None
    ) -> DisableVpcClassicLinkResult:
        """Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC
        that has EC2-Classic instances linked to it.

        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisableVpcClassicLinkResult
        """
        raise NotImplementedError

    @handler("DisableVpcClassicLinkDnsSupport")
    def disable_vpc_classic_link_dns_support(
        self, context: RequestContext, vpc_id: VpcId = None
    ) -> DisableVpcClassicLinkDnsSupportResult:
        """Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames
        resolve to public IP addresses when addressed between a linked
        EC2-Classic instance and instances in the VPC to which it's linked. For
        more information, see
        `ClassicLink <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        You must specify a VPC ID in the request.

        :param vpc_id: The ID of the VPC.
        :returns: DisableVpcClassicLinkDnsSupportResult
        """
        raise NotImplementedError

    @handler("DisassociateAddress")
    def disassociate_address(
        self,
        context: RequestContext,
        association_id: ElasticIpAssociationId = None,
        public_ip: String = None,
        dry_run: Boolean = None,
    ) -> None:
        """Disassociates an Elastic IP address from the instance or network
        interface it's associated with.

        An Elastic IP address is for use in either the EC2-Classic platform or
        in a VPC. For more information, see `Elastic IP
        Addresses <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        This is an idempotent operation. If you perform the operation more than
        once, Amazon EC2 doesn't return an error.

        :param association_id: [EC2-VPC] The association ID.
        :param public_ip: [EC2-Classic] The Elastic IP address.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DisassociateClientVpnTargetNetwork")
    def disassociate_client_vpn_target_network(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        association_id: ClientVpnAssociationId,
        dry_run: Boolean = None,
    ) -> DisassociateClientVpnTargetNetworkResult:
        """Disassociates a target network from the specified Client VPN endpoint.
        When you disassociate the last target network from a Client VPN, the
        following happens:

        -  The route that was automatically added for the VPC is deleted

        -  All active client connections are terminated

        -  New client connections are disallowed

        -  The Client VPN endpoint's status changes to ``pending-associate``

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint from which to disassociate the target
        network.
        :param association_id: The ID of the target network association.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisassociateClientVpnTargetNetworkResult
        """
        raise NotImplementedError

    @handler("DisassociateEnclaveCertificateIamRole")
    def disassociate_enclave_certificate_iam_role(
        self,
        context: RequestContext,
        certificate_arn: ResourceArn = None,
        role_arn: ResourceArn = None,
        dry_run: Boolean = None,
    ) -> DisassociateEnclaveCertificateIamRoleResult:
        """Disassociates an IAM role from an Certificate Manager (ACM) certificate.
        Disassociating an IAM role from an ACM certificate removes the Amazon S3
        object that contains the certificate, certificate chain, and encrypted
        private key from the Amazon S3 bucket. It also revokes the IAM role's
        permission to use the KMS key used to encrypt the private key. This
        effectively revokes the role's permission to use the certificate.

        :param certificate_arn: The ARN of the ACM certificate from which to disassociate the IAM role.
        :param role_arn: The ARN of the IAM role to disassociate.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisassociateEnclaveCertificateIamRoleResult
        """
        raise NotImplementedError

    @handler("DisassociateIamInstanceProfile")
    def disassociate_iam_instance_profile(
        self, context: RequestContext, association_id: IamInstanceProfileAssociationId
    ) -> DisassociateIamInstanceProfileResult:
        """Disassociates an IAM instance profile from a running or stopped
        instance.

        Use DescribeIamInstanceProfileAssociations to get the association ID.

        :param association_id: The ID of the IAM instance profile association.
        :returns: DisassociateIamInstanceProfileResult
        """
        raise NotImplementedError

    @handler("DisassociateInstanceEventWindow")
    def disassociate_instance_event_window(
        self,
        context: RequestContext,
        instance_event_window_id: InstanceEventWindowId,
        association_target: InstanceEventWindowDisassociationRequest,
        dry_run: Boolean = None,
    ) -> DisassociateInstanceEventWindowResult:
        """Disassociates one or more targets from an event window.

        For more information, see `Define event windows for scheduled
        events <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html>`__
        in the *Amazon EC2 User Guide*.

        :param instance_event_window_id: The ID of the event window.
        :param association_target: One or more targets to disassociate from the specified event window.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisassociateInstanceEventWindowResult
        """
        raise NotImplementedError

    @handler("DisassociateRouteTable")
    def disassociate_route_table(
        self,
        context: RequestContext,
        association_id: RouteTableAssociationId,
        dry_run: Boolean = None,
    ) -> None:
        """Disassociates a subnet or gateway from a route table.

        After you perform this action, the subnet no longer uses the routes in
        the route table. Instead, it uses the routes in the VPC's main route
        table. For more information about route tables, see `Route
        tables <https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html>`__
        in the *Amazon Virtual Private Cloud User Guide*.

        :param association_id: The association ID representing the current association between the
        route table and subnet or gateway.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("DisassociateSubnetCidrBlock")
    def disassociate_subnet_cidr_block(
        self, context: RequestContext, association_id: SubnetCidrAssociationId
    ) -> DisassociateSubnetCidrBlockResult:
        """Disassociates a CIDR block from a subnet. Currently, you can
        disassociate an IPv6 CIDR block only. You must detach or delete all
        gateways and resources that are associated with the CIDR block before
        you can disassociate it.

        :param association_id: The association ID for the CIDR block.
        :returns: DisassociateSubnetCidrBlockResult
        """
        raise NotImplementedError

    @handler("DisassociateTransitGatewayMulticastDomain")
    def disassociate_transit_gateway_multicast_domain(
        self,
        context: RequestContext,
        transit_gateway_multicast_domain_id: TransitGatewayMulticastDomainId = None,
        transit_gateway_attachment_id: TransitGatewayAttachmentId = None,
        subnet_ids: TransitGatewaySubnetIdList = None,
        dry_run: Boolean = None,
    ) -> DisassociateTransitGatewayMulticastDomainResult:
        """Disassociates the specified subnets from the transit gateway multicast
        domain.

        :param transit_gateway_multicast_domain_id: The ID of the transit gateway multicast domain.
        :param transit_gateway_attachment_id: The ID of the attachment.
        :param subnet_ids: The IDs of the subnets;.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisassociateTransitGatewayMulticastDomainResult
        """
        raise NotImplementedError

    @handler("DisassociateTransitGatewayRouteTable")
    def disassociate_transit_gateway_route_table(
        self,
        context: RequestContext,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        dry_run: Boolean = None,
    ) -> DisassociateTransitGatewayRouteTableResult:
        """Disassociates a resource attachment from a transit gateway route table.

        :param transit_gateway_route_table_id: The ID of the transit gateway route table.
        :param transit_gateway_attachment_id: The ID of the attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisassociateTransitGatewayRouteTableResult
        """
        raise NotImplementedError

    @handler("DisassociateTrunkInterface")
    def disassociate_trunk_interface(
        self,
        context: RequestContext,
        association_id: TrunkInterfaceAssociationId,
        client_token: String = None,
        dry_run: Boolean = None,
    ) -> DisassociateTrunkInterfaceResult:
        """This API action is currently in **limited preview only**. If you are
        interested in using this feature, contact your account manager.

        Removes an association between a branch network interface with a trunk
        network interface.

        :param association_id: The ID of the association.
        :param client_token: Unique, case-sensitive identifier that you provide to ensure the
        idempotency of the request.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: DisassociateTrunkInterfaceResult
        """
        raise NotImplementedError

    @handler("DisassociateVpcCidrBlock")
    def disassociate_vpc_cidr_block(
        self, context: RequestContext, association_id: VpcCidrAssociationId
    ) -> DisassociateVpcCidrBlockResult:
        """Disassociates a CIDR block from a VPC. To disassociate the CIDR block,
        you must specify its association ID. You can get the association ID by
        using DescribeVpcs. You must detach or delete all gateways and resources
        that are associated with the CIDR block before you can disassociate it.

        You cannot disassociate the CIDR block with which you originally created
        the VPC (the primary CIDR block).

        :param association_id: The association ID for the CIDR block.
        :returns: DisassociateVpcCidrBlockResult
        """
        raise NotImplementedError

    @handler("EnableEbsEncryptionByDefault")
    def enable_ebs_encryption_by_default(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> EnableEbsEncryptionByDefaultResult:
        """Enables EBS encryption by default for your account in the current
        Region.

        After you enable encryption by default, the EBS volumes that you create
        are always encrypted, either using the default KMS key or the KMS key
        that you specified when you created each volume. For more information,
        see `Amazon EBS
        encryption <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        You can specify the default KMS key for encryption by default using
        ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId.

        Enabling encryption by default has no effect on the encryption status of
        your existing volumes.

        After you enable encryption by default, you can no longer launch
        instances using instance types that do not support encryption. For more
        information, see `Supported instance
        types <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances>`__.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: EnableEbsEncryptionByDefaultResult
        """
        raise NotImplementedError

    @handler("EnableFastLaunch")
    def enable_fast_launch(
        self,
        context: RequestContext,
        image_id: ImageId,
        resource_type: String = None,
        snapshot_configuration: FastLaunchSnapshotConfigurationRequest = None,
        launch_template: FastLaunchLaunchTemplateSpecificationRequest = None,
        max_parallel_launches: Integer = None,
        dry_run: Boolean = None,
    ) -> EnableFastLaunchResult:
        """When you enable faster launching for a Windows AMI, images are
        pre-provisioned, using snapshots to launch instances up to 65% faster.
        To create the optimized Windows image, Amazon EC2 launches an instance
        and runs through Sysprep steps, rebooting as required. Then it creates a
        set of reserved snapshots that are used for subsequent launches. The
        reserved snapshots are automatically replenished as they are used,
        depending on your settings for launch frequency.

        :param image_id: The ID of the image for which you’re enabling faster launching.
        :param resource_type: The type of resource to use for pre-provisioning the Windows AMI for
        faster launching.
        :param snapshot_configuration: Configuration settings for creating and managing the snapshots that are
        used for pre-provisioning the Windows AMI for faster launching.
        :param launch_template: The launch template to use when launching Windows instances from
        pre-provisioned snapshots.
        :param max_parallel_launches: The maximum number of parallel instances to launch for creating
        resources.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: EnableFastLaunchResult
        """
        raise NotImplementedError

    @handler("EnableFastSnapshotRestores")
    def enable_fast_snapshot_restores(
        self,
        context: RequestContext,
        availability_zones: AvailabilityZoneStringList,
        source_snapshot_ids: SnapshotIdStringList,
        dry_run: Boolean = None,
    ) -> EnableFastSnapshotRestoresResult:
        """Enables fast snapshot restores for the specified snapshots in the
        specified Availability Zones.

        You get the full benefit of fast snapshot restores after they enter the
        ``enabled`` state. To get the current state of fast snapshot restores,
        use DescribeFastSnapshotRestores. To disable fast snapshot restores, use
        DisableFastSnapshotRestores.

        For more information, see `Amazon EBS fast snapshot
        restore <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-fast-snapshot-restore.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param availability_zones: One or more Availability Zones.
        :param source_snapshot_ids: The IDs of one or more snapshots.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: EnableFastSnapshotRestoresResult
        """
        raise NotImplementedError

    @handler("EnableImageDeprecation")
    def enable_image_deprecation(
        self,
        context: RequestContext,
        image_id: ImageId,
        deprecate_at: MillisecondDateTime,
        dry_run: Boolean = None,
    ) -> EnableImageDeprecationResult:
        """Enables deprecation of the specified AMI at the specified date and time.

        For more information, see `Deprecate an
        AMI <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-deprecate.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param image_id: The ID of the AMI.
        :param deprecate_at: The date and time to deprecate the AMI, in UTC, in the following format:
        *YYYY*-*MM*-*DD* T *HH*:*MM*:*SS* Z.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: EnableImageDeprecationResult
        """
        raise NotImplementedError

    @handler("EnableIpamOrganizationAdminAccount")
    def enable_ipam_organization_admin_account(
        self, context: RequestContext, delegated_admin_account_id: String, dry_run: Boolean = None
    ) -> EnableIpamOrganizationAdminAccountResult:
        """Enable an Organizations member account as the IPAM admin account. You
        cannot select the Organizations management account as the IPAM admin
        account. For more information, see `Enable integration with
        Organizations </vpc/latest/ipam/enable-integ-ipam.html>`__ in the
        *Amazon VPC IPAM User Guide*.

        :param delegated_admin_account_id: The Organizations member account ID that you want to enable as the IPAM
        account.
        :param dry_run: A check for whether you have the required permissions for the action
        without actually making the request and provides an error response.
        :returns: EnableIpamOrganizationAdminAccountResult
        """
        raise NotImplementedError

    @handler("EnableSerialConsoleAccess")
    def enable_serial_console_access(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> EnableSerialConsoleAccessResult:
        """Enables access to the EC2 serial console of all instances for your
        account. By default, access to the EC2 serial console is disabled for
        your account. For more information, see `Manage account access to the
        EC2 serial
        console <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access>`__
        in the *Amazon EC2 User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: EnableSerialConsoleAccessResult
        """
        raise NotImplementedError

    @handler("EnableTransitGatewayRouteTablePropagation")
    def enable_transit_gateway_route_table_propagation(
        self,
        context: RequestContext,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        transit_gateway_attachment_id: TransitGatewayAttachmentId,
        dry_run: Boolean = None,
    ) -> EnableTransitGatewayRouteTablePropagationResult:
        """Enables the specified attachment to propagate routes to the specified
        propagation route table.

        :param transit_gateway_route_table_id: The ID of the propagation route table.
        :param transit_gateway_attachment_id: The ID of the attachment.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: EnableTransitGatewayRouteTablePropagationResult
        """
        raise NotImplementedError

    @handler("EnableVgwRoutePropagation")
    def enable_vgw_route_propagation(
        self,
        context: RequestContext,
        gateway_id: VpnGatewayId,
        route_table_id: RouteTableId,
        dry_run: Boolean = None,
    ) -> None:
        """Enables a virtual private gateway (VGW) to propagate routes to the
        specified route table of a VPC.

        :param gateway_id: The ID of the virtual private gateway that is attached to a VPC.
        :param route_table_id: The ID of the route table.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("EnableVolumeIO")
    def enable_volume_io(
        self, context: RequestContext, volume_id: VolumeId, dry_run: Boolean = None
    ) -> None:
        """Enables I/O operations for a volume that had I/O operations disabled
        because the data on the volume was potentially inconsistent.

        :param volume_id: The ID of the volume.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        """
        raise NotImplementedError

    @handler("EnableVpcClassicLink")
    def enable_vpc_classic_link(
        self, context: RequestContext, vpc_id: VpcId, dry_run: Boolean = None
    ) -> EnableVpcClassicLinkResult:
        """Enables a VPC for ClassicLink. You can then link EC2-Classic instances
        to your ClassicLink-enabled VPC to allow communication over private IP
        addresses. You cannot enable your VPC for ClassicLink if any of your VPC
        route tables have existing routes for address ranges within the
        ``10.0.0.0/8`` IP address range, excluding local routes for VPCs in the
        ``10.0.0.0/16`` and ``10.1.0.0/16`` IP address ranges. For more
        information, see
        `ClassicLink <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param vpc_id: The ID of the VPC.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: EnableVpcClassicLinkResult
        """
        raise NotImplementedError

    @handler("EnableVpcClassicLinkDnsSupport")
    def enable_vpc_classic_link_dns_support(
        self, context: RequestContext, vpc_id: VpcId = None
    ) -> EnableVpcClassicLinkDnsSupportResult:
        """Enables a VPC to support DNS hostname resolution for ClassicLink. If
        enabled, the DNS hostname of a linked EC2-Classic instance resolves to
        its private IP address when addressed from an instance in the VPC to
        which it's linked. Similarly, the DNS hostname of an instance in a VPC
        resolves to its private IP address when addressed from a linked
        EC2-Classic instance. For more information, see
        `ClassicLink <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        You must specify a VPC ID in the request.

        :param vpc_id: The ID of the VPC.
        :returns: EnableVpcClassicLinkDnsSupportResult
        """
        raise NotImplementedError

    @handler("ExportClientVpnClientCertificateRevocationList")
    def export_client_vpn_client_certificate_revocation_list(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        dry_run: Boolean = None,
    ) -> ExportClientVpnClientCertificateRevocationListResult:
        """Downloads the client certificate revocation list for the specified
        Client VPN endpoint.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: ExportClientVpnClientCertificateRevocationListResult
        """
        raise NotImplementedError

    @handler("ExportClientVpnClientConfiguration")
    def export_client_vpn_client_configuration(
        self,
        context: RequestContext,
        client_vpn_endpoint_id: ClientVpnEndpointId,
        dry_run: Boolean = None,
    ) -> ExportClientVpnClientConfigurationResult:
        """Downloads the contents of the Client VPN endpoint configuration file for
        the specified Client VPN endpoint. The Client VPN endpoint configuration
        file includes the Client VPN endpoint and certificate information
        clients need to establish a connection with the Client VPN endpoint.

        :param client_vpn_endpoint_id: The ID of the Client VPN endpoint.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: ExportClientVpnClientConfigurationResult
        """
        raise NotImplementedError

    @handler("ExportImage")
    def export_image(
        self,
        context: RequestContext,
        disk_image_format: DiskImageFormat,
        image_id: ImageId,
        s3_export_location: ExportTaskS3LocationRequest,
        client_token: String = None,
        description: String = None,
        dry_run: Boolean = None,
        role_name: String = None,
        tag_specifications: TagSpecificationList = None,
    ) -> ExportImageResult:
        """Exports an Amazon Machine Image (AMI) to a VM file. For more
        information, see `Exporting a VM directly from an Amazon Machine Image
        (AMI) <https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html>`__
        in the *VM Import/Export User Guide*.

        :param disk_image_format: The disk image format.
        :param image_id: The ID of the image.
        :param s3_export_location: Information about the destination Amazon S3 bucket.
        :param client_token: Token to enable idempotency for export image requests.
        :param description: A description of the image being exported.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param role_name: The name of the role that grants VM Import/Export permission to export
        images to your Amazon S3 bucket.
        :param tag_specifications: The tags to apply to the export image task during creation.
        :returns: ExportImageResult
        """
        raise NotImplementedError

    @handler("ExportTransitGatewayRoutes")
    def export_transit_gateway_routes(
        self,
        context: RequestContext,
        transit_gateway_route_table_id: TransitGatewayRouteTableId,
        s3_bucket: String,
        filters: FilterList = None,
        dry_run: Boolean = None,
    ) -> ExportTransitGatewayRoutesResult:
        """Exports routes from the specified transit gateway route table to the
        specified S3 bucket. By default, all routes are exported. Alternatively,
        you can filter by CIDR range.

        The routes are saved to the specified bucket in a JSON file. For more
        information, see `Export Route Tables to Amazon
        S3 <https://docs.aws.amazon.com/vpc/latest/tgw/tgw-route-tables.html#tgw-export-route-tables>`__
        in *Transit Gateways*.

        :param transit_gateway_route_table_id: The ID of the route table.
        :param s3_bucket: The name of the S3 bucket.
        :param filters: One or more filters.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: ExportTransitGatewayRoutesResult
        """
        raise NotImplementedError

    @handler("GetAssociatedEnclaveCertificateIamRoles")
    def get_associated_enclave_certificate_iam_roles(
        self, context: RequestContext, certificate_arn: ResourceArn = None, dry_run: Boolean = None
    ) -> GetAssociatedEnclaveCertificateIamRolesResult:
        """Returns the IAM roles that are associated with the specified ACM (ACM)
        certificate. It also returns the name of the Amazon S3 bucket and the
        Amazon S3 object key where the certificate, certificate chain, and
        encrypted private key bundle are stored, and the ARN of the KMS key
        that's used to encrypt the private key.

        :param certificate_arn: The ARN of the ACM certificate for which to view the associated IAM
        roles, encryption keys, and Amazon S3 object information.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: GetAssociatedEnclaveCertificateIamRolesResult
        """
        raise NotImplementedError

    @handler("GetAssociatedIpv6PoolCidrs")
    def get_associated_ipv6_pool_cidrs(
        self,
        context: RequestContext,
        pool_id: Ipv6PoolEc2Id,
        next_token: NextToken = None,
        max_results: Ipv6PoolMaxResults = None,
        dry_run: Boolean = None,
    ) -> GetAssociatedIpv6PoolCidrsResult:
        """Gets information about the IPv6 CIDR block associations for a specified
        IPv6 address pool.

        :param pool_id: The ID of the IPv6 address pool.
        :param next_token: The token for the next page of results.
        :param max_results: The maximum number of results to return with a single call.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: GetAssociatedIpv6PoolCidrsResult
        """
        raise NotImplementedError

    @handler("GetCapacityReservationUsage")
    def get_capacity_reservation_usage(
        self,
        context: RequestContext,
        capacity_reservation_id: CapacityReservationId,
        next_token: String = None,
        max_results: GetCapacityReservationUsageRequestMaxResults = None,
        dry_run: Boolean = None,
    ) -> GetCapacityReservationUsageResult:
        """Gets usage information about a Capacity Reservation. If the Capacity
        Reservation is shared, it shows usage information for the Capacity
        Reservation owner and each Amazon Web Services account that is currently
        using the shared capacity. If the Capacity Reservation is not shared, it
        shows only the Capacity Reservation owner's usage.

        :param capacity_reservation_id: The ID of the Capacity Reservation.
        :param next_token: The token to use to retrieve the next page of results.
        :param max_results: The maximum number of results to return for the request in a single
        page.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: GetCapacityReservationUsageResult
        """
        raise NotImplementedError

    @handler("GetCoipPoolUsage")
    def get_coip_pool_usage(
        self,
        context: RequestContext,
        pool_id: CoipPoolId,
        filters: FilterList = None,
        max_results: CoipPoolMaxResults = None,
        next_token: String = None,
        dry_run: Boolean = None,
    ) -> GetCoipPoolUsageResult:
        """Describes the allocations from the specified customer-owned address
        pool.

        :param pool_id: The ID of the address pool.
        :param filters: The filters.
        :param max_results: The maximum number of results to return with a single call.
        :param next_token: The token for the next page of results.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: GetCoipPoolUsageResult
        """
        raise NotImplementedError

    @handler("GetConsoleOutput")
    def get_console_output(
        self,
        context: RequestContext,
        instance_id: InstanceId,
        dry_run: Boolean = None,
        latest: Boolean = None,
    ) -> GetConsoleOutputResult:
        """Gets the console output for the specified instance. For Linux instances,
        the instance console output displays the exact console output that would
        normally be displayed on a physical monitor attached to a computer. For
        Windows instances, the instance console output includes the last three
        system event log errors.

        By default, the console output returns buffered information that was
        posted shortly after an instance transition state (start, stop, reboot,
        or terminate). This information is available for at least one hour after
        the most recent post. Only the most recent 64 KB of console output is
        available.

        You can optionally retrieve the latest serial console output at any time
        during the instance lifecycle. This option is supported on instance
        types that use the Nitro hypervisor.

        For more information, see `Instance console
        output <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html#instance-console-console-output>`__
        in the *Amazon EC2 User Guide*.

        :param instance_id: The ID of the instance.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param latest: When enabled, retrieves the latest console output for the instance.
        :returns: GetConsoleOutputResult
        """
        raise NotImplementedError

    @handler("GetConsoleScreenshot")
    def get_console_screenshot(
        self,
        context: RequestContext,
        instance_id: InstanceId,
        dry_run: Boolean = None,
        wake_up: Boolean = None,
    ) -> GetConsoleScreenshotResult:
        """Retrieve a JPG-format screenshot of a running instance to help with
        troubleshooting.

        The returned content is Base64-encoded.

        :param instance_id: The ID of the instance.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :param wake_up: When set to ``true``, acts as keystroke input and wakes up an instance
        that's in standby or "sleep" mode.
        :returns: GetConsoleScreenshotResult
        """
        raise NotImplementedError

    @handler("GetDefaultCreditSpecification")
    def get_default_credit_specification(
        self,
        context: RequestContext,
        instance_family: UnlimitedSupportedInstanceFamily,
        dry_run: Boolean = None,
    ) -> GetDefaultCreditSpecificationResult:
        """Describes the default credit option for CPU usage of a burstable
        performance instance family.

        For more information, see `Burstable performance
        instances <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html>`__
        in the *Amazon EC2 User Guide*.

        :param instance_family: The instance family.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: GetDefaultCreditSpecificationResult
        """
        raise NotImplementedError

    @handler("GetEbsDefaultKmsKeyId")
    def get_ebs_default_kms_key_id(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> GetEbsDefaultKmsKeyIdResult:
        """Describes the default KMS key for EBS encryption by default for your
        account in this Region. You can change the default KMS key for
        encryption by default using ModifyEbsDefaultKmsKeyId or
        ResetEbsDefaultKmsKeyId.

        For more information, see `Amazon EBS
        encryption <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: GetEbsDefaultKmsKeyIdResult
        """
        raise NotImplementedError

    @handler("GetEbsEncryptionByDefault")
    def get_ebs_encryption_by_default(
        self, context: RequestContext, dry_run: Boolean = None
    ) -> GetEbsEncryptionByDefaultResult:
        """Describes whether EBS encryption by default is enabled for your account
        in the current Region.

        For more information, see `Amazon EBS
        encryption <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html>`__
        in the *Amazon Elastic Compute Cloud User Guide*.

        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: GetEbsEncryptionByDefaultResult
        """
        raise NotImplementedError

    @handler("GetFlowLogsIntegrationTemplate")
    def get_flow_logs_integration_template(
        self,
        context: RequestContext,
        flow_log_id: VpcFlowLogId,
        config_delivery_s3_destination_arn: String,
        integrate_services: IntegrateServices,
        dry_run: Boolean = None,
    ) -> GetFlowLogsIntegrationTemplateResult:
        """Generates a CloudFormation template that streamlines and automates the
        integration of VPC flow logs with Amazon Athena. This make it easier for
        you to query and gain insights from VPC flow logs data. Based on the
        information that you provide, we configure resources in the template to
        do the following:

        -  Create a table in Athena that maps fields to a custom log format

        -  Create a Lambda function that updates the table with new partitions
           on a daily, weekly, or monthly basis

        -  Create a table partitioned between two timestamps in the past

        -  Create a set of named queries in Athena that you can use to get
           started quickly

        :param flow_log_id: The ID of the flow log.
        :param config_delivery_s3_destination_arn: To store the CloudFormation template in Amazon S3, specify the location
        in Amazon S3.
        :param integrate_services: Information about the service integration.
        :param dry_run: Checks whether you have the required permissions for the action, without
        actually making the request, and provides an error response.
        :returns: GetFlowLogsIntegrationTemplateResult
        """
        raise NotImplementedError

    @handler("GetGroupsForCapacityReservation")
    def get_groups_for_capacity_reservation(
        self,
        context: RequestContext,
        capacity_reservation_id: CapacityReservationId,
        next_token: String = None,
        max_results: GetGroupsForCapacityReservationRequestMaxResults = None,
        dry_run: Boolean = None,
    ) -> GetGroupsForCapacityReservationResult:
        """Lists the resource grou