# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2023-06-11T10:00:45+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field, constr


class Statistics(BaseModel):
    parts_packed: Optional[int] = Field(None, description="partition records packed")
    req_time: Optional[int] = Field(None, description="generation time")
    req_time_start: Optional[int] = Field(None, description="data since")
    server_thread_count: Optional[int] = Field(None, description="Server thread count")
    agent_queue_size: Optional[int] = Field(None, description="Agent queue size")
    agent_count: Optional[int] = Field(None, description="Agent count")
    agent_thread_count: Optional[int] = Field(None, description="Agent thread count")
    dbd_agent_queue_size: Optional[int] = Field(
        None, description="DBD Agent queue size"
    )
    gettimeofday_latency: Optional[int] = Field(
        None, description="Latency for 1000 calls to gettimeofday()"
    )
    schedule_cycle_max: Optional[int] = Field(
        None, description="Main Schedule max cycle"
    )
    schedule_cycle_last: Optional[int] = Field(
        None, description="Main Schedule last cycle"
    )
    schedule_cycle_total: Optional[int] = Field(
        None, description="Main Schedule cycle iterations"
    )
    schedule_cycle_mean: Optional[int] = Field(
        None, description="Average time for Schedule Max cycle"
    )
    schedule_cycle_mean_depth: Optional[int] = Field(
        None, description="Average depth for Schedule Max cycle"
    )
    schedule_cycle_per_minute: Optional[int] = Field(
        None, description="Main Schedule Cycles per minute"
    )
    schedule_queue_length: Optional[int] = Field(
        None, description="Main Schedule Last queue length"
    )
    jobs_submitted: Optional[int] = Field(None, description="Job submitted")
    jobs_started: Optional[int] = Field(None, description="Job started")
    jobs_completed: Optional[int] = Field(None, description="Job completed")
    jobs_canceled: Optional[int] = Field(None, description="Job cancelled")
    jobs_failed: Optional[int] = Field(None, description="Job failed")
    jobs_pending: Optional[int] = Field(None, description="Job pending")
    jobs_running: Optional[int] = Field(None, description="Job running")
    job_states_ts: Optional[int] = Field(None, description="Job states timestamp")
    bf_backfilled_jobs: Optional[int] = Field(
        None, description="Total backfilled jobs (since last slurm start)"
    )
    bf_last_backfilled_jobs: Optional[int] = Field(
        None, description="Total backfilled jobs (since last stats cycle start)"
    )
    bf_backfilled_het_jobs: Optional[int] = Field(
        None, description="Total backfilled heterogeneous job components"
    )
    bf_cycle_counter: Optional[int] = Field(
        None, description="Backfill Schedule Total cycles"
    )
    bf_cycle_mean: Optional[int] = Field(
        None, description="Backfill Schedule Mean cycle"
    )
    bf_cycle_max: Optional[int] = Field(
        None, description="Backfill Schedule Max cycle time"
    )
    bf_last_depth: Optional[int] = Field(
        None, description="Backfill Schedule Last depth cycle"
    )
    bf_last_depth_try: Optional[int] = Field(
        None, description="Backfill Schedule Mean cycle (try sched)"
    )
    bf_depth_mean: Optional[int] = Field(
        None, description="Backfill Schedule Depth Mean"
    )
    bf_depth_mean_try: Optional[int] = Field(
        None, description="Backfill Schedule Depth Mean (try sched)"
    )
    bf_cycle_last: Optional[int] = Field(
        None, description="Backfill Schedule Last cycle time"
    )
    bf_queue_len: Optional[int] = Field(
        None, description="Backfill Schedule Last queue length"
    )
    bf_queue_len_mean: Optional[int] = Field(
        None, description="Backfill Schedule Mean queue length"
    )
    bf_when_last_cycle: Optional[int] = Field(None, description="Last cycle timestamp")
    bf_active: Optional[bool] = Field(
        None, description="Backfill Schedule currently active"
    )


class Ping(Enum):
    UP = "UP"
    DOWN = "DOWN"


class Field36Ping(BaseModel):
    hostname: Optional[str] = Field(None, description="slurm controller hostname")
    ping: Optional[Ping] = Field(None, description="slurm controller host up")
    mode: Optional[str] = Field(None, description="slurm controller mode")
    status: Optional[int] = Field(None, description="slurm controller status")


class Field36Partition(BaseModel):
    flags: Optional[List[str]] = Field(None, description="partition options")
    preemption_mode: Optional[str] = Field(None, description="preemption type")
    allowed_allocation_nodes: Optional[str] = Field(
        None, description="list names of allowed allocating nodes"
    )
    allowed_accounts: Optional[str] = Field(
        None, description="comma delimited list of accounts"
    )
    allowed_groups: Optional[str] = Field(
        None, description="comma delimited list of groups"
    )
    allowed_qos: Optional[str] = Field(None, description="comma delimited list of qos")
    alternative: Optional[str] = Field(None, description="name of alternate partition")
    billing_weights: Optional[str] = Field(None, description="TRES billing weights")
    default_memory_per_cpu: Optional[int] = Field(
        None, description="default MB memory per allocated CPU"
    )
    default_time_limit: Optional[int] = Field(
        None, description="default time limit (minutes)"
    )
    denied_accounts: Optional[str] = Field(
        None, description="comma delimited list of denied accounts"
    )
    denied_qos: Optional[str] = Field(
        None, description="comma delimited list of denied qos"
    )
    preemption_grace_time: Optional[int] = Field(
        None, description="preemption grace time (seconds)"
    )
    maximum_cpus_per_node: Optional[int] = Field(
        None, description="maximum allocated CPUs per node"
    )
    maximum_memory_per_node: Optional[int] = Field(
        None, description="maximum memory per allocated CPU (MiB)"
    )
    maximum_nodes_per_job: Optional[int] = Field(None, description="Max nodes per job")
    max_time_limit: Optional[int] = Field(None, description="Max time limit per job")
    min_nodes_per_job: Optional[int] = Field(
        None, description="Min number of nodes per job"
    )
    name: Optional[str] = Field(None, description="Partition name")
    nodes: Optional[str] = Field(None, description="list names of nodes in partition")
    over_time_limit: Optional[int] = Field(
        None,
        description="job's time limit can be exceeded by this number of minutes before cancellation",
    )
    priority_job_factor: Optional[int] = Field(
        None, description="job priority weight factor"
    )
    priority_tier: Optional[int] = Field(
        None, description="tier for scheduling and preemption"
    )
    qos: Optional[str] = Field(None, description="partition QOS name")
    nodes_online: Optional[int] = Field(
        None, description="Nodes online (ready for jobs)"
    )
    total_cpus: Optional[int] = Field(None, description="Total cpus in partition")
    total_nodes: Optional[int] = Field(
        None, description="Total number of nodes in partition"
    )
    tres: Optional[str] = Field(None, description="configured TRES in partition")


class Field36Error(BaseModel):
    error: Optional[str] = Field(None, description="error message")
    errno: Optional[int] = Field(None, description="error number")


class Field36Signal(Enum):
    HUP = "HUP"
    INT = "INT"
    QUIT = "QUIT"
    ABRT = "ABRT"
    KILL = "KILL"
    ALRM = "ALRM"
    TERM = "TERM"
    USR1 = "USR1"
    USR2 = "USR2"
    URG = "URG"
    CONT = "CONT"
    STOP = "STOP"
    TSTP = "TSTP"
    TTIN = "TTIN"
    TTOU = "TTOU"


class Field36JobSubmissionResponse(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="slurm errors")
    job_id: Optional[int] = Field(None, description="new job ID")
    step_id: Optional[str] = Field(None, description="new job step ID")
    job_submit_user_msg: Optional[str] = Field(
        None, description="Message to user from job_submit plugin"
    )


class Field36NodeAllocation(BaseModel):
    memory: Optional[int] = Field(None, description="amount of assigned job memory")
    cpus: Optional[Dict[str, Any]] = Field(
        None, description="amount of assigned job CPUs"
    )
    sockets: Optional[Dict[str, Any]] = Field(
        None, description="assignment status of each socket by socket id"
    )
    cores: Optional[Dict[str, Any]] = Field(
        None, description="assignment status of each core by core id"
    )


class Exclusive(Enum):
    user = "user"
    mcs = "mcs"
    true = "true"
    false = "false"


class GresFlags(Enum):
    disable_binding = "disable-binding"
    enforce_binding = "enforce-binding"


class OpenMode(Enum):
    append = "append"
    truncate = "truncate"


class Field36JobProperties(BaseModel):
    account: Optional[str] = Field(
        None, description="Charge resources used by this job to specified account."
    )
    account_gather_freqency: Optional[str] = Field(
        None, description="Define the job accounting and profiling sampling intervals."
    )
    argv: Optional[List[str]] = Field(None, description="Arguments to the script.")
    array: Optional[str] = Field(
        None,
        description="Submit a job array, multiple jobs to be executed with identical parameters. The indexes specification identifies what array index values should be used.",
    )
    batch_features: Optional[str] = Field(
        None, description="features required for batch script's node"
    )
    begin_time: Optional[str] = Field(
        None,
        description="Submit the batch script to the Slurm controller immediately, like normal, but tell the controller to defer the allocation of the job until the specified time.",
    )
    burst_buffer: Optional[str] = Field(None, description="Burst buffer specification.")
    cluster_constraints: Optional[str] = Field(
        None,
        description="Specifies features that a federated cluster must have to have a sibling job submitted to it.",
    )
    comment: Optional[str] = Field(None, description="An arbitrary comment.")
    constraints: Optional[str] = Field(
        None, description="node features required by job."
    )
    core_specification: Optional[int] = Field(
        None,
        description="Count of specialized threads per node reserved by the job for system operations and not used by the application.",
    )
    cores_per_socket: Optional[int] = Field(
        None,
        description="Restrict node selection to nodes with at least the specified number of cores per socket.",
    )
    cpu_binding: Optional[str] = Field(None, description="Cpu binding")
    cpu_binding_hint: Optional[str] = Field(None, description="Cpu binding hint")
    cpu_frequency: Optional[str] = Field(
        None,
        description="Request that job steps initiated by srun commands inside this sbatch script be run at some requested frequency if possible, on the CPUs selected for the step on the compute node(s).",
    )
    cpus_per_gpu: Optional[str] = Field(
        None, description="Number of CPUs requested per allocated GPU."
    )
    cpus_per_task: Optional[int] = Field(
        None,
        description="Advise the Slurm controller that ensuing job steps will require ncpus number of processors per task.",
    )
    current_working_directory: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard output directly to the file name.",
    )
    deadline: Optional[str] = Field(
        None,
        description="Remove the job if no ending is possible before this deadline (start > (deadline - time[-min])).",
    )
    delay_boot: Optional[int] = Field(
        None,
        description="Do not reboot nodes in order to satisfied this job's feature specification if the job has been eligible to run for less than this time period.",
    )
    dependency: Optional[str] = Field(
        None,
        description="Defer the start of this job until the specified dependencies have been satisfied completed.",
    )
    distribution: Optional[str] = Field(
        None, description="Specify alternate distribution methods for remote processes."
    )
    environment: Optional[Dict[str, Any]] = Field(
        None, description="Dictionary of environment entries."
    )
    exclusive: Optional[Exclusive] = Field(
        None,
        description='The job allocation can share nodes just other users with the "user" option or with the "mcs" option).',
    )
    get_user_environment: Optional[bool] = Field(
        None, description="Load new login environment for user on job node."
    )
    gres: Optional[str] = Field(
        None,
        description="Specifies a comma delimited list of generic consumable resources.",
    )
    gres_flags: Optional[GresFlags] = Field(
        None, description="Specify generic resource task binding options."
    )
    gpu_binding: Optional[str] = Field(
        None, description="Requested binding of tasks to GPU."
    )
    gpu_frequency: Optional[str] = Field(None, description="Requested GPU frequency.")
    gpus: Optional[str] = Field(None, description="GPUs per job.")
    gpus_per_node: Optional[str] = Field(None, description="GPUs per node.")
    gpus_per_socket: Optional[str] = Field(None, description="GPUs per socket.")
    gpus_per_task: Optional[str] = Field(None, description="GPUs per task.")
    hold: Optional[bool] = Field(
        None,
        description="Specify the job is to be submitted in a held state (priority of zero).",
    )
    kill_on_invalid_dependency: Optional[bool] = Field(
        None,
        description="If a job has an invalid dependency, then Slurm is to terminate it.",
    )
    licenses: Optional[str] = Field(
        None,
        description="Specification of licenses (or other resources available on all nodes of the cluster) which must be allocated to this job.",
    )
    mail_type: Optional[str] = Field(
        None, description="Notify user by email when certain event types occur."
    )
    mail_user: Optional[str] = Field(
        None,
        description="User to receive email notification of state changes as defined by mail_type.",
    )
    mcs_label: Optional[str] = Field(
        None, description="This parameter is a group among the groups of the user."
    )
    memory_binding: Optional[str] = Field(None, description="Bind tasks to memory.")
    memory_per_cpu: Optional[int] = Field(
        None, description="Minimum real memory per cpu (MB)."
    )
    memory_per_gpu: Optional[int] = Field(
        None, description="Minimum memory required per allocated GPU."
    )
    memory_per_node: Optional[int] = Field(
        None, description="Minimum real memory per node (MB)."
    )
    minimum_cpus_per_node: Optional[int] = Field(
        None, description="Minimum number of CPUs per node."
    )
    minimum_nodes: Optional[bool] = Field(
        None,
        description="If a range of node counts is given, prefer the smaller count.",
    )
    name: Optional[str] = Field(
        None, description="Specify a name for the job allocation."
    )
    nice: Optional[str] = Field(
        None,
        description="Run the job with an adjusted scheduling priority within Slurm.",
    )
    no_kill: Optional[bool] = Field(
        None,
        description="Do not automatically terminate a job if one of the nodes it has been allocated fails.",
    )
    nodes: Optional[List[int]] = Field(
        None,
        description="Request that a minimum of minnodes nodes and a maximum node count.",
        max_items=2,
        min_items=1,
    )
    open_mode: Optional[OpenMode] = Field(
        "append",
        description="Open the output and error files using append or truncate mode as specified.",
    )
    partition: Optional[str] = Field(
        None, description="Request a specific partition for the resource allocation."
    )
    priority: Optional[str] = Field(
        None, description="Request a specific job priority."
    )
    qos: Optional[str] = Field(
        None, description="Request a quality of service for the job."
    )
    requeue: Optional[bool] = Field(
        None,
        description="Specifies that the batch job should eligible to being requeue.",
    )
    reservation: Optional[str] = Field(
        None, description="Allocate resources for the job from the named reservation."
    )
    signal: Optional[constr(regex=r"(B:|)sig_num(@sig_time|)")] = Field(  # type: ignore
        None,
        description="When a job is within sig_time seconds of its end time, send it the signal sig_num.",
    )
    sockets_per_node: Optional[int] = Field(
        None,
        description="Restrict node selection to nodes with at least the specified number of sockets.",
    )
    spread_job: Optional[bool] = Field(
        None,
        description="Spread the job allocation over as many nodes as possible and attempt to evenly distribute tasks across the allocated nodes.",
    )
    standard_error: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard error directly to the file name.",
    )
    standard_in: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard input directly to the file name specified.",
    )
    standard_out: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard output directly to the file name.",
    )
    tasks: Optional[int] = Field(
        None,
        description="Advises the Slurm controller that job steps run within the allocation will launch a maximum of number tasks and to provide for sufficient resources.",
    )
    tasks_per_core: Optional[int] = Field(
        None, description="Request the maximum ntasks be invoked on each core."
    )
    tasks_per_node: Optional[int] = Field(
        None, description="Request the maximum ntasks be invoked on each node."
    )
    tasks_per_socket: Optional[int] = Field(
        None, description="Request the maximum ntasks be invoked on each socket."
    )
    thread_specification: Optional[int] = Field(
        None,
        description="Count of specialized threads per node reserved by the job for system operations and not used by the application.",
    )
    threads_per_core: Optional[int] = Field(
        None,
        description="Restrict node selection to nodes with at least the specified number of threads per core.",
    )
    time_limit: Optional[int] = Field(None, description="Step time limit.")
    time_minimum: Optional[int] = Field(
        None, description="Minimum run time in minutes."
    )
    wait_all_nodes: Optional[bool] = Field(
        None, description="Do not begin execution until all nodes are ready for use."
    )
    wckey: Optional[str] = Field(None, description="Specify wckey to be used with job.")


class Field36Node(BaseModel):
    architecture: Optional[str] = Field(None, description="computer architecture")
    burstbuffer_network_address: Optional[str] = Field(None, description="BcastAddr")
    boards: Optional[int] = Field(None, description="total number of boards per node")
    boot_time: Optional[int] = Field(None, description="timestamp of node boot")
    comment: Optional[str] = Field(None, description="Arbitrary comment")
    cores: Optional[int] = Field(None, description="number of cores per socket")
    cpu_binding: Optional[int] = Field(None, description="Default task binding")
    cpu_load: Optional[int] = Field(None, description="CPU load * 100")
    free_memory: Optional[int] = Field(None, description="free memory in MiB")
    cpus: Optional[int] = Field(
        None, description="configured count of cpus running on the node"
    )
    features: Optional[str] = Field(None, description="")
    active_features: Optional[str] = Field(
        None, description="list of a node's available features"
    )
    gres: Optional[str] = Field(None, description="list of a node's generic resources")
    gres_drained: Optional[str] = Field(None, description="list of drained GRES")
    gres_used: Optional[str] = Field(None, description="list of GRES in current use")
    mcs_label: Optional[str] = Field(None, description="mcs label if mcs plugin in use")
    name: Optional[str] = Field(None, description="node name to slurm")
    next_state_after_reboot: Optional[str] = Field(None, description="")
    address: Optional[str] = Field(None, description="state after reboot")
    hostname: Optional[str] = Field(None, description="node's hostname")
    state: Optional[str] = Field(None, description="current node state")
    operating_system: Optional[str] = Field(None, description="operating system")
    owner: Optional[str] = Field(None, description="User allowed to use this node")
    port: Optional[int] = Field(None, description="TCP port number of the slurmd")
    real_memory: Optional[int] = Field(
        None, description="configured MB of real memory on the node"
    )
    reason: Optional[str] = Field(
        None, description="reason for node being DOWN or DRAINING"
    )
    reason_changed_at: Optional[int] = Field(
        None, description="Time stamp when reason was set"
    )
    reason_set_by_user: Optional[str] = Field(
        None, description="User that set the reason"
    )
    slurmd_start_time: Optional[int] = Field(
        None, description="timestamp of slurmd startup"
    )
    sockets: Optional[int] = Field(None, description="total number of sockets per node")
    threads: Optional[int] = Field(None, description="number of threads per core")
    temporary_disk: Optional[int] = Field(
        None, description="configured MB of total disk in TMP_FS"
    )
    weight: Optional[int] = Field(
        None, description="arbitrary priority of node for scheduling"
    )
    tres: Optional[str] = Field(None, description="TRES on node")
    slurmd_version: Optional[str] = Field(None, description="Slurmd version")


class Field36NodesResponse(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="slurm errors")
    nodes: Optional[List[Field36Node]] = Field(None, description="nodes info")


class Field37Ping(BaseModel):
    hostname: Optional[str] = Field(None, description="slurm controller hostname")
    ping: Optional[Ping] = Field(None, description="slurm controller host up")
    mode: Optional[str] = Field(None, description="slurm controller mode")
    status: Optional[int] = Field(None, description="slurm controller status")


class Field37Partition(BaseModel):
    flags: Optional[List[str]] = Field(None, description="partition options")
    preemption_mode: Optional[List[str]] = Field(None, description="preemption type")
    allowed_allocation_nodes: Optional[str] = Field(
        None, description="list names of allowed allocating nodes"
    )
    allowed_accounts: Optional[str] = Field(
        None, description="comma delimited list of accounts"
    )
    allowed_groups: Optional[str] = Field(
        None, description="comma delimited list of groups"
    )
    allowed_qos: Optional[str] = Field(None, description="comma delimited list of qos")
    alternative: Optional[str] = Field(None, description="name of alternate partition")
    billing_weights: Optional[str] = Field(None, description="TRES billing weights")
    default_memory_per_cpu: Optional[int] = Field(
        None, description="default MB memory per allocated CPU"
    )
    default_time_limit: Optional[int] = Field(
        None, description="default time limit (minutes)"
    )
    denied_accounts: Optional[str] = Field(
        None, description="comma delimited list of denied accounts"
    )
    denied_qos: Optional[str] = Field(
        None, description="comma delimited list of denied qos"
    )
    preemption_grace_time: Optional[int] = Field(
        None, description="preemption grace time (seconds)"
    )
    maximum_cpus_per_node: Optional[int] = Field(
        None, description="maximum allocated CPUs per node"
    )
    maximum_memory_per_node: Optional[int] = Field(
        None, description="maximum memory per allocated CPU (MiB)"
    )
    maximum_nodes_per_job: Optional[int] = Field(None, description="Max nodes per job")
    max_time_limit: Optional[int] = Field(None, description="Max time limit per job")
    min_nodes_per_job: Optional[int] = Field(
        None, description="Min number of nodes per job"
    )
    name: Optional[str] = Field(None, description="Partition name")
    nodes: Optional[str] = Field(None, description="list names of nodes in partition")
    over_time_limit: Optional[int] = Field(
        None,
        description="job's time limit can be exceeded by this number of minutes before cancellation",
    )
    priority_job_factor: Optional[int] = Field(
        None, description="job priority weight factor"
    )
    priority_tier: Optional[int] = Field(
        None, description="tier for scheduling and preemption"
    )
    qos: Optional[str] = Field(None, description="partition QOS name")
    state: Optional[str] = Field(None, description="Partition state")
    total_cpus: Optional[int] = Field(None, description="Total cpus in partition")
    total_nodes: Optional[int] = Field(
        None, description="Total number of nodes in partition"
    )
    tres: Optional[str] = Field(None, description="configured TRES in partition")


class PurgeCompleted(BaseModel):
    time: Optional[int] = Field(
        None,
        description="amount of seconds this reservation will sit idle until it is revoked",
    )


class Field37Reservation(BaseModel):
    accounts: Optional[str] = Field(None, description="Allowed accounts")
    burst_buffer: Optional[str] = Field(None, description="Reserved burst buffer")
    core_count: Optional[int] = Field(None, description="Number of reserved cores")
    core_spec_cnt: Optional[int] = Field(
        None, description="Number of reserved specialized cores"
    )
    end_time: Optional[int] = Field(None, description="End time of the reservation")
    features: Optional[str] = Field(None, description="List of features")
    flags: Optional[List[str]] = Field(None, description="Reservation options")
    groups: Optional[str] = Field(
        None, description="List of groups permitted to use the reserved nodes"
    )
    licenses: Optional[str] = Field(None, description="List of licenses")
    max_start_delay: Optional[int] = Field(
        None,
        description="Maximum delay in which jobs outside of the reservation will be permitted to overlap once any jobs are queued for the reservation",
    )
    name: Optional[str] = Field(None, description="Reservationn name")
    node_count: Optional[int] = Field(None, description="Count of nodes reserved")
    node_list: Optional[str] = Field(None, description="List of reserved nodes")
    partition: Optional[str] = Field(None, description="Partition")
    purge_completed: Optional[PurgeCompleted] = Field(
        None,
        description="If PURGE_COMP flag is set the amount of seconds this reservation will sit idle until it is revoked",
    )
    start_time: Optional[int] = Field(None, description="Start time of reservation")
    watts: Optional[int] = Field(
        None, description="amount of power to reserve in watts"
    )
    tres: Optional[str] = Field(None, description="List of TRES")
    users: Optional[str] = Field(None, description="List of users")


class Field37Error(BaseModel):
    error: Optional[str] = Field(None, description="error message")
    errno: Optional[int] = Field(None, description="error number")


class Field37Signal(Enum):
    HUP = "HUP"
    INT = "INT"
    QUIT = "QUIT"
    ABRT = "ABRT"
    KILL = "KILL"
    ALRM = "ALRM"
    TERM = "TERM"
    USR1 = "USR1"
    USR2 = "USR2"
    URG = "URG"
    CONT = "CONT"
    STOP = "STOP"
    TSTP = "TSTP"
    TTIN = "TTIN"
    TTOU = "TTOU"


class Field37JobSubmissionResponse(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="slurm errors")
    job_id: Optional[int] = Field(None, description="new job ID")
    step_id: Optional[str] = Field(None, description="new job step ID")
    job_submit_user_msg: Optional[str] = Field(
        None, description="Message to user from job_submit plugin"
    )


class Field37NodeAllocation(BaseModel):
    memory: Optional[int] = Field(None, description="amount of assigned job memory")
    cpus: Optional[Dict[str, Any]] = Field(
        None, description="amount of assigned job CPUs"
    )
    sockets: Optional[Dict[str, Any]] = Field(
        None, description="assignment status of each socket by socket id"
    )
    cores: Optional[Dict[str, Any]] = Field(
        None, description="assignment status of each core by core id"
    )


class Field37JobProperties(BaseModel):
    account: Optional[str] = Field(
        None, description="Charge resources used by this job to specified account."
    )
    account_gather_frequency: Optional[str] = Field(
        None, description="Define the job accounting and profiling sampling intervals."
    )
    argv: Optional[List[str]] = Field(None, description="Arguments to the script.")
    array: Optional[str] = Field(
        None,
        description="Submit a job array, multiple jobs to be executed with identical parameters. The indexes specification identifies what array index values should be used.",
    )
    batch_features: Optional[str] = Field(
        None, description="features required for batch script's node"
    )
    begin_time: Optional[int] = Field(
        None,
        description="Submit the batch script to the Slurm controller immediately, like normal, but tell the controller to defer the allocation of the job until the specified time.",
    )
    burst_buffer: Optional[str] = Field(None, description="Burst buffer specification.")
    cluster_constraint: Optional[str] = Field(
        None,
        description="Specifies features that a federated cluster must have to have a sibling job submitted to it.",
    )
    comment: Optional[str] = Field(None, description="An arbitrary comment.")
    constraints: Optional[str] = Field(
        None, description="node features required by job."
    )
    core_specification: Optional[int] = Field(
        None,
        description="Count of specialized threads per node reserved by the job for system operations and not used by the application.",
    )
    cores_per_socket: Optional[int] = Field(
        None,
        description="Restrict node selection to nodes with at least the specified number of cores per socket.",
    )
    cpu_binding: Optional[str] = Field(None, description="Cpu binding")
    cpu_binding_hint: Optional[str] = Field(None, description="Cpu binding hint")
    cpu_frequency: Optional[str] = Field(
        None,
        description="Request that job steps initiated by srun commands inside this sbatch script be run at some requested frequency if possible, on the CPUs selected for the step on the compute node(s).",
    )
    cpus_per_gpu: Optional[str] = Field(
        None, description="Number of CPUs requested per allocated GPU."
    )
    cpus_per_task: Optional[int] = Field(
        None,
        description="Advise the Slurm controller that ensuing job steps will require ncpus number of processors per task.",
    )
    current_working_directory: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard output directly to the file name.",
    )
    deadline: Optional[str] = Field(
        None,
        description="Remove the job if no ending is possible before this deadline (start > (deadline - time[-min])).",
    )
    delay_boot: Optional[int] = Field(
        None,
        description="Do not reboot nodes in order to satisfied this job's feature specification if the job has been eligible to run for less than this time period.",
    )
    dependency: Optional[str] = Field(
        None,
        description="Defer the start of this job until the specified dependencies have been satisfied completed.",
    )
    distribution: Optional[str] = Field(
        None, description="Specify alternate distribution methods for remote processes."
    )
    environment: Optional[Dict[str, Any]] = Field(
        None, description="Dictionary of environment entries."
    )
    exclusive: Optional[Exclusive] = Field(
        None,
        description='The job allocation can share nodes just other users with the "user" option or with the "mcs" option).',
    )
    get_user_environment: Optional[bool] = Field(
        None, description="Load new login environment for user on job node."
    )
    gres: Optional[str] = Field(
        None,
        description="Specifies a comma delimited list of generic consumable resources.",
    )
    gres_flags: Optional[GresFlags] = Field(
        None, description="Specify generic resource task binding options."
    )
    gpu_binding: Optional[str] = Field(
        None, description="Requested binding of tasks to GPU."
    )
    gpu_frequency: Optional[str] = Field(None, description="Requested GPU frequency.")
    gpus: Optional[str] = Field(None, description="GPUs per job.")
    gpus_per_node: Optional[str] = Field(None, description="GPUs per node.")
    gpus_per_socket: Optional[str] = Field(None, description="GPUs per socket.")
    gpus_per_task: Optional[str] = Field(None, description="GPUs per task.")
    hold: Optional[bool] = Field(
        None,
        description="Specify the job is to be submitted in a held state (priority of zero).",
    )
    kill_on_invalid_dependency: Optional[bool] = Field(
        None,
        description="If a job has an invalid dependency, then Slurm is to terminate it.",
    )
    licenses: Optional[str] = Field(
        None,
        description="Specification of licenses (or other resources available on all nodes of the cluster) which must be allocated to this job.",
    )
    mail_type: Optional[str] = Field(
        None, description="Notify user by email when certain event types occur."
    )
    mail_user: Optional[str] = Field(
        None,
        description="User to receive email notification of state changes as defined by mail_type.",
    )
    mcs_label: Optional[str] = Field(
        None, description="This parameter is a group among the groups of the user."
    )
    memory_binding: Optional[str] = Field(None, description="Bind tasks to memory.")
    memory_per_cpu: Optional[int] = Field(
        None, description="Minimum real memory per cpu (MB)."
    )
    memory_per_gpu: Optional[int] = Field(
        None, description="Minimum memory required per allocated GPU."
    )
    memory_per_node: Optional[int] = Field(
        None, description="Minimum real memory per node (MB)."
    )
    minimum_cpus_per_node: Optional[int] = Field(
        None, description="Minimum number of CPUs per node."
    )
    minimum_nodes: Optional[bool] = Field(
        None,
        description="If a range of node counts is given, prefer the smaller count.",
    )
    name: Optional[str] = Field(
        None, description="Specify a name for the job allocation."
    )
    nice: Optional[str] = Field(
        None,
        description="Run the job with an adjusted scheduling priority within Slurm.",
    )
    no_kill: Optional[bool] = Field(
        None,
        description="Do not automatically terminate a job if one of the nodes it has been allocated fails.",
    )
    nodes: Optional[List[int]] = Field(
        None,
        description="Request that a minimum of minnodes nodes and a maximum node count.",
        max_items=2,
        min_items=1,
    )
    open_mode: Optional[OpenMode] = Field(
        "append",
        description="Open the output and error files using append or truncate mode as specified.",
    )
    partition: Optional[str] = Field(
        None, description="Request a specific partition for the resource allocation."
    )
    priority: Optional[str] = Field(
        None, description="Request a specific job priority."
    )
    qos: Optional[str] = Field(
        None, description="Request a quality of service for the job."
    )
    requeue: Optional[bool] = Field(
        None,
        description="Specifies that the batch job should eligible to being requeue.",
    )
    reservation: Optional[str] = Field(
        None, description="Allocate resources for the job from the named reservation."
    )
    signal: Optional[constr(regex=r"(B:|)sig_num(@sig_time|)")] = Field(  # type: ignore
        None,
        description="When a job is within sig_time seconds of its end time, send it the signal sig_num.",
    )
    sockets_per_node: Optional[int] = Field(
        None,
        description="Restrict node selection to nodes with at least the specified number of sockets.",
    )
    spread_job: Optional[bool] = Field(
        None,
        description="Spread the job allocation over as many nodes as possible and attempt to evenly distribute tasks across the allocated nodes.",
    )
    standard_error: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard error directly to the file name.",
    )
    standard_input: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard input directly to the file name specified.",
    )
    standard_output: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard output directly to the file name.",
    )
    tasks: Optional[int] = Field(
        None,
        description="Advises the Slurm controller that job steps run within the allocation will launch a maximum of number tasks and to provide for sufficient resources.",
    )
    tasks_per_core: Optional[int] = Field(
        None, description="Request the maximum ntasks be invoked on each core."
    )
    tasks_per_node: Optional[int] = Field(
        None, description="Request the maximum ntasks be invoked on each node."
    )
    tasks_per_socket: Optional[int] = Field(
        None, description="Request the maximum ntasks be invoked on each socket."
    )
    thread_specification: Optional[int] = Field(
        None,
        description="Count of specialized threads per node reserved by the job for system operations and not used by the application.",
    )
    threads_per_core: Optional[int] = Field(
        None,
        description="Restrict node selection to nodes with at least the specified number of threads per core.",
    )
    time_limit: Optional[int] = Field(None, description="Step time limit.")
    time_minimum: Optional[int] = Field(
        None, description="Minimum run time in minutes."
    )
    wait_all_nodes: Optional[bool] = Field(
        None, description="Do not begin execution until all nodes are ready for use."
    )
    wckey: Optional[str] = Field(None, description="Specify wckey to be used with job.")


class Field37Node(BaseModel):
    architecture: Optional[str] = Field(None, description="computer architecture")
    burstbuffer_network_address: Optional[str] = Field(None, description="BcastAddr")
    boards: Optional[int] = Field(None, description="total number of boards per node")
    boot_time: Optional[int] = Field(None, description="timestamp of node boot")
    cores: Optional[int] = Field(None, description="number of cores per socket")
    cpu_binding: Optional[int] = Field(None, description="Default task binding")
    cpu_load: Optional[int] = Field(None, description="CPU load * 100")
    free_memory: Optional[int] = Field(None, description="free memory in MiB")
    cpus: Optional[int] = Field(
        None, description="configured count of cpus running on the node"
    )
    features: Optional[str] = Field(None, description="")
    active_features: Optional[str] = Field(
        None, description="list of a node's available features"
    )
    gres: Optional[str] = Field(None, description="list of a node's generic resources")
    gres_drained: Optional[str] = Field(None, description="list of drained GRES")
    gres_used: Optional[str] = Field(None, description="list of GRES in current use")
    mcs_label: Optional[str] = Field(None, description="mcs label if mcs plugin in use")
    name: Optional[str] = Field(None, description="node name to slurm")
    next_state_after_reboot: Optional[str] = Field(
        None, description="state after reboot"
    )
    next_state_after_reboot_flags: Optional[List[str]] = Field(
        None, description="node state flags"
    )
    address: Optional[str] = Field(None, description="state after reboot")
    hostname: Optional[str] = Field(None, description="node's hostname")
    state: Optional[str] = Field(None, description="current node state")
    state_flags: Optional[List[str]] = Field(None, description="node state flags")
    operating_system: Optional[str] = Field(None, description="operating system")
    owner: Optional[str] = Field(None, description="User allowed to use this node")
    partitions: Optional[List[str]] = Field(None, description="assigned partitions")
    port: Optional[int] = Field(None, description="TCP port number of the slurmd")
    real_memory: Optional[int] = Field(
        None, description="configured MB of real memory on the node"
    )
    reason: Optional[str] = Field(
        None, description="reason for node being DOWN or DRAINING"
    )
    reason_changed_at: Optional[int] = Field(
        None, description="Time stamp when reason was set"
    )
    reason_set_by_user: Optional[str] = Field(
        None, description="User that set the reason"
    )
    slurmd_start_time: Optional[int] = Field(
        None, description="timestamp of slurmd startup"
    )
    sockets: Optional[int] = Field(None, description="total number of sockets per node")
    threads: Optional[int] = Field(None, description="number of threads per core")
    temporary_disk: Optional[int] = Field(
        None, description="configured MB of total disk in TMP_FS"
    )
    weight: Optional[int] = Field(
        None, description="arbitrary priority of node for scheduling"
    )
    tres: Optional[str] = Field(None, description="TRES on node")
    tres_used: Optional[str] = Field(None, description="TRES used on node")
    tres_weighted: Optional[float] = Field(None, description="TRES weight used on node")
    slurmd_version: Optional[str] = Field(None, description="Slurmd version")
    alloc_cpus: Optional[int] = Field(None, description="Allocated CPUs")
    idle_cpus: Optional[int] = Field(None, description="Idle CPUs")
    alloc_memory: Optional[int] = Field(None, description="Allocated memory (MB)")


class Field37NodesResponse(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="slurm errors")
    nodes: Optional[List[Field37Node]] = Field(None, description="nodes info")


class Field38DiagRpcm(BaseModel):
    message_type: Optional[str] = Field(None, description="message type")
    type_id: Optional[int] = Field(None, description="message type id")
    count: Optional[int] = Field(None, description="rpc count")
    average_time: Optional[int] = Field(None, description="average time")
    total_time: Optional[int] = Field(None, description="total time")


class Field38DiagRpcu(BaseModel):
    user: Optional[str] = Field(None, description="user")
    user_id: Optional[int] = Field(None, description="user id")
    count: Optional[int] = Field(None, description="rpc count")
    average_time: Optional[int] = Field(None, description="average time")
    total_time: Optional[int] = Field(None, description="total time")


class Field38License(BaseModel):
    LicenseName: Optional[str] = Field(None, description="name of license")
    Total: Optional[int] = Field(None, description="total number of licenses")
    Used: Optional[int] = Field(None, description="number of licenses in use")
    Free: Optional[int] = Field(None, description="number of licenses available")
    Reserved: Optional[int] = Field(None, description="number of licenses reserved")
    Remote: Optional[bool] = Field(None, description="license is remote")


class Field38Ping(BaseModel):
    hostname: Optional[str] = Field(None, description="slurm controller hostname")
    ping: Optional[Ping] = Field(None, description="slurm controller host up")
    mode: Optional[str] = Field(None, description="slurm controller mode")
    status: Optional[int] = Field(None, description="slurm controller status")


class Field38Partition(BaseModel):
    flags: Optional[List[str]] = Field(None, description="partition options")
    preemption_mode: Optional[List[str]] = Field(None, description="preemption type")
    allowed_allocation_nodes: Optional[str] = Field(
        None, description="list names of allowed allocating nodes"
    )
    allowed_accounts: Optional[str] = Field(
        None, description="comma delimited list of accounts"
    )
    allowed_groups: Optional[str] = Field(
        None, description="comma delimited list of groups"
    )
    allowed_qos: Optional[str] = Field(None, description="comma delimited list of qos")
    alternative: Optional[str] = Field(None, description="name of alternate partition")
    billing_weights: Optional[str] = Field(None, description="TRES billing weights")
    default_memory_per_cpu: Optional[int] = Field(
        None, description="default MB memory per allocated CPU"
    )
    default_time_limit: Optional[int] = Field(
        None, description="default time limit (minutes)"
    )
    denied_accounts: Optional[str] = Field(
        None, description="comma delimited list of denied accounts"
    )
    denied_qos: Optional[str] = Field(
        None, description="comma delimited list of denied qos"
    )
    preemption_grace_time: Optional[int] = Field(
        None, description="preemption grace time (seconds)"
    )
    maximum_cpus_per_node: Optional[int] = Field(
        None, description="maximum allocated CPUs per node"
    )
    maximum_memory_per_node: Optional[int] = Field(
        None, description="maximum memory per allocated node (MiB)"
    )
    maximum_nodes_per_job: Optional[int] = Field(None, description="Max nodes per job")
    max_time_limit: Optional[int] = Field(None, description="Max time limit per job")
    min_nodes_per_job: Optional[int] = Field(
        None, description="Min number of nodes per job"
    )
    name: Optional[str] = Field(None, description="Partition name")
    nodes: Optional[str] = Field(None, description="list names of nodes in partition")
    over_time_limit: Optional[int] = Field(
        None,
        description="job's time limit can be exceeded by this number of minutes before cancellation",
    )
    priority_job_factor: Optional[int] = Field(
        None, description="job priority weight factor"
    )
    priority_tier: Optional[int] = Field(
        None, description="tier for scheduling and preemption"
    )
    qos: Optional[str] = Field(None, description="partition QOS name")
    state: Optional[str] = Field(None, description="Partition state")
    total_cpus: Optional[int] = Field(None, description="Total cpus in partition")
    total_nodes: Optional[int] = Field(
        None, description="Total number of nodes in partition"
    )
    tres: Optional[str] = Field(None, description="configured TRES in partition")
    maximum_memory_per_cpu: Optional[int] = Field(
        None, description="maximum memory per allocated CPU (MiB)"
    )
    default_memory_per_node: Optional[int] = Field(
        None, description="default MB memory per allocated node"
    )


class Field38Reservation(BaseModel):
    accounts: Optional[str] = Field(None, description="Allowed accounts")
    burst_buffer: Optional[str] = Field(None, description="Reserved burst buffer")
    core_count: Optional[int] = Field(None, description="Number of reserved cores")
    core_spec_cnt: Optional[int] = Field(
        None, description="Number of reserved specialized cores"
    )
    end_time: Optional[int] = Field(None, description="End time of the reservation")
    features: Optional[str] = Field(None, description="List of features")
    flags: Optional[List[str]] = Field(None, description="Reservation options")
    groups: Optional[str] = Field(
        None, description="List of groups permitted to use the reserved nodes"
    )
    licenses: Optional[str] = Field(None, description="List of licenses")
    max_start_delay: Optional[int] = Field(
        None,
        description="Maximum delay in which jobs outside of the reservation will be permitted to overlap once any jobs are queued for the reservation",
    )
    name: Optional[str] = Field(None, description="Reservationn name")
    node_count: Optional[int] = Field(None, description="Count of nodes reserved")
    node_list: Optional[str] = Field(None, description="List of reserved nodes")
    partition: Optional[str] = Field(None, description="Partition")
    purge_completed: Optional[PurgeCompleted] = Field(
        None,
        description="If PURGE_COMP flag is set the amount of seconds this reservation will sit idle until it is revoked",
    )
    start_time: Optional[int] = Field(None, description="Start time of reservation")
    watts: Optional[int] = Field(
        None, description="amount of power to reserve in watts"
    )
    tres: Optional[str] = Field(None, description="List of TRES")
    users: Optional[str] = Field(None, description="List of users")


class Field38Error(BaseModel):
    error: Optional[str] = Field(None, description="error message")
    error_number: Optional[int] = Field(None, description="Slurm internal error number")


class Field38Signal(Enum):
    HUP = "HUP"
    INT = "INT"
    QUIT = "QUIT"
    ABRT = "ABRT"
    KILL = "KILL"
    ALRM = "ALRM"
    TERM = "TERM"
    USR1 = "USR1"
    USR2 = "USR2"
    URG = "URG"
    CONT = "CONT"
    STOP = "STOP"
    TSTP = "TSTP"
    TTIN = "TTIN"
    TTOU = "TTOU"


class Sockets(BaseModel):
    cores: Optional[Dict[str, Any]] = Field(
        None, description="assignment status of each core by core id in each socket"
    )


class Field38NodeAllocation(BaseModel):
    memory: Optional[int] = Field(None, description="amount of assigned job memory")
    cpus: Optional[int] = Field(None, description="number of assigned job CPUs")
    sockets: Optional[Sockets] = Field(
        None, description="assignment status of each socket by numeric socket id"
    )
    nodename: Optional[str] = Field(None, description="node name")


class Field38JobProperties(BaseModel):
    account: Optional[str] = Field(
        None, description="Charge resources used by this job to specified account."
    )
    account_gather_frequency: Optional[str] = Field(
        None, description="Define the job accounting and profiling sampling intervals."
    )
    argv: Optional[List[str]] = Field(None, description="Arguments to the script.")
    array: Optional[str] = Field(
        None,
        description="Submit a job array, multiple jobs to be executed with identical parameters. The indexes specification identifies what array index values should be used.",
    )
    batch_features: Optional[str] = Field(
        None, description="features required for batch script's node"
    )
    begin_time: Optional[int] = Field(
        None,
        description="Submit the batch script to the Slurm controller immediately, like normal, but tell the controller to defer the allocation of the job until the specified time.",
    )
    burst_buffer: Optional[str] = Field(None, description="Burst buffer specification.")
    cluster_constraint: Optional[str] = Field(
        None,
        description="Specifies features that a federated cluster must have to have a sibling job submitted to it.",
    )
    comment: Optional[str] = Field(None, description="An arbitrary comment.")
    constraints: Optional[str] = Field(
        None, description="node features required by job."
    )
    container: Optional[str] = Field(
        None, description="absolute path to OCI container bundle"
    )
    core_specification: Optional[int] = Field(
        None,
        description="Count of specialized threads per node reserved by the job for system operations and not used by the application.",
    )
    cores_per_socket: Optional[int] = Field(
        None,
        description="Restrict node selection to nodes with at least the specified number of cores per socket.",
    )
    cpu_binding: Optional[str] = Field(None, description="Cpu binding")
    cpu_binding_hint: Optional[str] = Field(None, description="Cpu binding hint")
    cpu_frequency: Optional[str] = Field(
        None,
        description="Request that job steps initiated by srun commands inside this sbatch script be run at some requested frequency if possible, on the CPUs selected for the step on the compute node(s).",
    )
    cpus_per_gpu: Optional[str] = Field(
        None, description="Number of CPUs requested per allocated GPU."
    )
    cpus_per_task: Optional[int] = Field(
        None,
        description="Advise the Slurm controller that ensuing job steps will require ncpus number of processors per task.",
    )
    current_working_directory: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard output directly to the file name.",
    )
    deadline: Optional[str] = Field(
        None,
        description="Remove the job if no ending is possible before this deadline (start > (deadline - time[-min])).",
    )
    delay_boot: Optional[int] = Field(
        None,
        description="Do not reboot nodes in order to satisfied this job's feature specification if the job has been eligible to run for less than this time period.",
    )
    dependency: Optional[str] = Field(
        None,
        description="Defer the start of this job until the specified dependencies have been satisfied completed.",
    )
    distribution: Optional[str] = Field(
        None, description="Specify alternate distribution methods for remote processes."
    )
    environment: Optional[Dict[str, Any]] = Field(
        None, description="Dictionary of environment entries."
    )
    exclusive: Optional[Exclusive] = Field(
        None,
        description='The job allocation can share nodes just other users with the "user" option or with the "mcs" option).',
    )
    get_user_environment: Optional[bool] = Field(
        None, description="Load new login environment for user on job node."
    )
    gres: Optional[str] = Field(
        None,
        description="Specifies a comma delimited list of generic consumable resources.",
    )
    gres_flags: Optional[GresFlags] = Field(
        None, description="Specify generic resource task binding options."
    )
    gpu_binding: Optional[str] = Field(
        None, description="Requested binding of tasks to GPU."
    )
    gpu_frequency: Optional[str] = Field(None, description="Requested GPU frequency.")
    gpus: Optional[str] = Field(None, description="GPUs per job.")
    gpus_per_node: Optional[str] = Field(None, description="GPUs per node.")
    gpus_per_socket: Optional[str] = Field(None, description="GPUs per socket.")
    gpus_per_task: Optional[str] = Field(None, description="GPUs per task.")
    hold: Optional[bool] = Field(
        None,
        description="Specify the job is to be submitted in a held state (priority of zero).",
    )
    kill_on_invalid_dependency: Optional[bool] = Field(
        None,
        description="If a job has an invalid dependency, then Slurm is to terminate it.",
    )
    licenses: Optional[str] = Field(
        None,
        description="Specification of licenses (or other resources available on all nodes of the cluster) which must be allocated to this job.",
    )
    mail_type: Optional[str] = Field(
        None, description="Notify user by email when certain event types occur."
    )
    mail_user: Optional[str] = Field(
        None,
        description="User to receive email notification of state changes as defined by mail_type.",
    )
    mcs_label: Optional[str] = Field(
        None, description="This parameter is a group among the groups of the user."
    )
    memory_binding: Optional[str] = Field(None, description="Bind tasks to memory.")
    memory_per_cpu: Optional[int] = Field(
        None, description="Minimum real memory per cpu (MB)."
    )
    memory_per_gpu: Optional[int] = Field(
        None, description="Minimum memory required per allocated GPU."
    )
    memory_per_node: Optional[int] = Field(
        None, description="Minimum real memory per node (MB)."
    )
    minimum_cpus_per_node: Optional[int] = Field(
        None, description="Minimum number of CPUs per node."
    )
    minimum_nodes: Optional[bool] = Field(
        None,
        description="If a range of node counts is given, prefer the smaller count.",
    )
    name: Optional[str] = Field(
        None, description="Specify a name for the job allocation."
    )
    nice: Optional[int] = Field(
        None,
        description="Run the job with an adjusted scheduling priority within Slurm.",
    )
    no_kill: Optional[bool] = Field(
        None,
        description="Do not automatically terminate a job if one of the nodes it has been allocated fails.",
    )
    nodes: Optional[List[int]] = Field(
        None,
        description="Request that a minimum of minnodes nodes and a maximum node count.",
        max_items=2,
        min_items=1,
    )
    open_mode: Optional[OpenMode] = Field(
        "append",
        description="Open the output and error files using append or truncate mode as specified.",
    )
    oversubscribe: Optional[bool] = Field(
        "false",
        description="The job allocation can over-subscribe resources with other running jobs.",
    )
    partition: Optional[str] = Field(
        None, description="Request a specific partition for the resource allocation."
    )
    prefer: Optional[str] = Field(
        None,
        description="Comma delimited list of features for scheduler to prefer but not a strict requirement like a constraint. Value can be used for job submission but is only displayed for PENDING jobs.",
    )
    priority: Optional[str] = Field(
        None, description="Request a specific job priority."
    )
    qos: Optional[str] = Field(
        None, description="Request a quality of service for the job."
    )
    requeue: Optional[bool] = Field(
        None,
        description="Specifies that the batch job should eligible to being requeue.",
    )
    reservation: Optional[str] = Field(
        None, description="Allocate resources for the job from the named reservation."
    )
    signal: Optional[constr(regex=r"(B:|)sig_num(@sig_time|)")] = Field(  # type: ignore
        None,
        description="When a job is within sig_time seconds of its end time, send it the signal sig_num.",
    )
    sockets_per_node: Optional[int] = Field(
        None,
        description="Restrict node selection to nodes with at least the specified number of sockets.",
    )
    spread_job: Optional[bool] = Field(
        None,
        description="Spread the job allocation over as many nodes as possible and attempt to evenly distribute tasks across the allocated nodes.",
    )
    standard_error: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard error directly to the file name.",
    )
    standard_input: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard input directly to the file name specified.",
    )
    standard_output: Optional[str] = Field(
        None,
        description="Instruct Slurm to connect the batch script's standard output directly to the file name.",
    )
    tasks: Optional[int] = Field(
        None,
        description="Advises the Slurm controller that job steps run within the allocation will launch a maximum of number tasks and to provide for sufficient resources.",
    )
    tasks_per_core: Optional[int] = Field(
        None, description="Request the maximum ntasks be invoked on each core."
    )
    tasks_per_node: Optional[int] = Field(
        None, description="Request the maximum ntasks be invoked on each node."
    )
    tasks_per_socket: Optional[int] = Field(
        None, description="Request the maximum ntasks be invoked on each socket."
    )
    thread_specification: Optional[int] = Field(
        None,
        description="Count of specialized threads per node reserved by the job for system operations and not used by the application.",
    )
    threads_per_core: Optional[int] = Field(
        None,
        description="Restrict node selection to nodes with at least the specified number of threads per core.",
    )
    time_limit: Optional[int] = Field(None, description="Step time limit in minutes.")
    time_minimum: Optional[int] = Field(
        None, description="Minimum run time in minutes."
    )
    wait_all_nodes: Optional[bool] = Field(
        None, description="Do not begin execution until all nodes are ready for use."
    )
    wckey: Optional[str] = Field(None, description="Specify wckey to be used with job.")


class Field38Node(BaseModel):
    architecture: Optional[str] = Field(None, description="computer architecture")
    burstbuffer_network_address: Optional[str] = Field(None, description="BcastAddr")
    boards: Optional[int] = Field(None, description="total number of boards per node")
    boot_time: Optional[int] = Field(None, description="timestamp of node boot")
    cores: Optional[int] = Field(None, description="number of cores per socket")
    cpu_binding: Optional[int] = Field(None, description="Default task binding")
    cpu_load: Optional[int] = Field(None, description="CPU load * 100")
    free_memory: Optional[int] = Field(None, description="free memory in MiB")
    cpus: Optional[int] = Field(
        None, description="configured count of cpus running on the node"
    )
    features: Optional[str] = Field(None, description="")
    active_features: Optional[str] = Field(
        None, description="list of a node's available features"
    )
    gres: Optional[str] = Field(None, description="list of a node's generic resources")
    gres_drained: Optional[str] = Field(None, description="list of drained GRES")
    gres_used: Optional[str] = Field(None, description="list of GRES in current use")
    mcs_label: Optional[str] = Field(None, description="mcs label if mcs plugin in use")
    name: Optional[str] = Field(None, description="node name to slurm")
    next_state_after_reboot: Optional[str] = Field(
        None, description="state after reboot"
    )
    next_state_after_reboot_flags: Optional[List[str]] = Field(
        None, description="node state flags"
    )
    address: Optional[str] = Field(None, description="state after reboot")
    hostname: Optional[str] = Field(None, description="node's hostname")
    state: Optional[str] = Field(None, description="current node state")
    state_flags: Optional[List[str]] = Field(None, description="node state flags")
    operating_system: Optional[str] = Field(None, description="operating system")
    owner: Optional[str] = Field(None, description="User allowed to use this node")
    partitions: Optional[List[str]] = Field(None, description="assigned partitions")
    port: Optional[int] = Field(None, description="TCP port number of the slurmd")
    real_memory: Optional[int] = Field(
        None, description="configured MB of real memory on the node"
    )
    reason: Optional[str] = Field(
        None, description="reason for node being DOWN or DRAINING"
    )
    reason_changed_at: Optional[int] = Field(
        None, description="Time stamp when reason was set"
    )
    reason_set_by_user: Optional[str] = Field(
        None, description="User that set the reason"
    )
    slurmd_start_time: Optional[int] = Field(
        None, description="timestamp of slurmd startup"
    )
    sockets: Optional[int] = Field(None, description="total number of sockets per node")
    threads: Optional[int] = Field(None, description="number of threads per core")
    temporary_disk: Optional[int] = Field(
        None, description="configured MB of total disk in TMP_FS"
    )
    weight: Optional[int] = Field(
        None, description="arbitrary priority of node for scheduling"
    )
    tres: Optional[str] = Field(None, description="TRES on node")
    tres_used: Optional[str] = Field(None, description="TRES used on node")
    tres_weighted: Optional[float] = Field(None, description="TRES weight used on node")
    slurmd_version: Optional[str] = Field(None, description="Slurmd version")
    alloc_cpus: Optional[int] = Field(None, description="Allocated CPUs")
    idle_cpus: Optional[int] = Field(None, description="Idle CPUs")
    alloc_memory: Optional[int] = Field(None, description="Allocated memory (MB)")


class Plugin(BaseModel):
    type: Optional[str] = Field(None, description="")
    name: Optional[str] = Field(None, description="")


class Version(BaseModel):
    major: Optional[str] = Field(None, description="")
    micro: Optional[str] = Field(None, description="")
    minor: Optional[str] = Field(None, description="")


class Slurm(BaseModel):
    version: Optional[Version] = None
    release: Optional[str] = Field(None, description="version specifier")


class Field38Meta(BaseModel):
    plugin: Optional[Plugin] = None
    Slurm: Optional[Slurm] = Field(None, description="Slurm information")


class Field36Diag(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="slurm errors")
    statistics: Optional[Statistics] = Field(None, description="Slurm statistics")


class Field36Pings(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="slurm errors")
    pings: Optional[List[Field36Ping]] = Field(
        None, description="slurm controller pings"
    )


class Field36PartitionsResponse(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="slurm errors")
    partitions: Optional[List[Field36Partition]] = Field(
        None, description="partition info"
    )


class Field36JobSubmission(BaseModel):
    script: Optional[str] = Field(
        None, description="Executable script (full contents) to run in batch step"
    )
    job: Optional[Field36JobProperties] = Field(
        None, description="Properties of an array job or non-HetJob"
    )
    jobs: Optional[List[Field36JobProperties]] = Field(
        None, description="Properties of an HetJob"
    )


class Field36JobResources(BaseModel):
    nodes: Optional[str] = Field(None, description="list of assigned job nodes")
    allocated_cpus: Optional[int] = Field(
        None, description="number of assigned job cpus"
    )
    allocated_hosts: Optional[int] = Field(
        None, description="number of assigned job hosts"
    )
    allocated_nodes: Optional[List[Field36NodeAllocation]] = Field(
        None, description="node allocations"
    )


class Field37Diag(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="slurm errors")
    statistics: Optional[Statistics] = Field(None, description="Slurm statistics")


class Field37Pings(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="slurm errors")
    pings: Optional[List[Field37Ping]] = Field(
        None, description="slurm controller pings"
    )


class Field37PartitionsResponse(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="slurm errors")
    partitions: Optional[List[Field37Partition]] = Field(
        None, description="partition info"
    )


class Field37ReservationsResponse(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="slurm errors")
    reservations: Optional[List[Field37Reservation]] = Field(
        None, description="reservation info"
    )


class Field37JobSubmission(BaseModel):
    script: Optional[str] = Field(
        None, description="Executable script (full contents) to run in batch step"
    )
    job: Optional[Field37JobProperties] = Field(
        None, description="Properties of an array job or non-HetJob"
    )
    jobs: Optional[List[Field37JobProperties]] = Field(
        None, description="Properties of an HetJob"
    )


class Field37JobResources(BaseModel):
    nodes: Optional[str] = Field(None, description="list of assigned job nodes")
    allocated_cpus: Optional[int] = Field(
        None, description="number of assigned job cpus"
    )
    allocated_hosts: Optional[int] = Field(
        None, description="number of assigned job hosts"
    )
    allocated_nodes: Optional[List[Field37NodeAllocation]] = Field(
        None, description="node allocations"
    )


class StatisticsModel(BaseModel):
    parts_packed: Optional[int] = Field(None, description="partition records packed")
    req_time: Optional[int] = Field(None, description="generation time")
    req_time_start: Optional[int] = Field(None, description="data since")
    server_thread_count: Optional[int] = Field(None, description="Server thread count")
    agent_queue_size: Optional[int] = Field(None, description="Agent queue size")
    agent_count: Optional[int] = Field(None, description="Agent count")
    agent_thread_count: Optional[int] = Field(None, description="Agent thread count")
    dbd_agent_queue_size: Optional[int] = Field(
        None, description="DBD Agent queue size"
    )
    gettimeofday_latency: Optional[int] = Field(
        None, description="Latency for 1000 calls to gettimeofday()"
    )
    schedule_cycle_max: Optional[int] = Field(
        None, description="Main Schedule max cycle"
    )
    schedule_cycle_last: Optional[int] = Field(
        None, description="Main Schedule last cycle"
    )
    schedule_cycle_total: Optional[int] = Field(
        None, description="Main Schedule cycle iterations"
    )
    schedule_cycle_mean: Optional[int] = Field(
        None, description="Average time for Schedule Max cycle"
    )
    schedule_cycle_mean_depth: Optional[int] = Field(
        None, description="Average depth for Schedule Max cycle"
    )
    schedule_cycle_per_minute: Optional[int] = Field(
        None, description="Main Schedule Cycles per minute"
    )
    schedule_queue_length: Optional[int] = Field(
        None, description="Main Schedule Last queue length"
    )
    jobs_submitted: Optional[int] = Field(None, description="Job submitted")
    jobs_started: Optional[int] = Field(None, description="Job started")
    jobs_completed: Optional[int] = Field(None, description="Job completed")
    jobs_canceled: Optional[int] = Field(None, description="Job cancelled")
    jobs_failed: Optional[int] = Field(None, description="Job failed")
    jobs_pending: Optional[int] = Field(None, description="Job pending")
    jobs_running: Optional[int] = Field(None, description="Job running")
    job_states_ts: Optional[int] = Field(None, description="Job states timestamp")
    bf_backfilled_jobs: Optional[int] = Field(
        None, description="Total backfilled jobs (since last slurm start)"
    )
    bf_last_backfilled_jobs: Optional[int] = Field(
        None, description="Total backfilled jobs (since last stats cycle start)"
    )
    bf_backfilled_het_jobs: Optional[int] = Field(
        None, description="Total backfilled heterogeneous job components"
    )
    bf_cycle_counter: Optional[int] = Field(
        None, description="Backfill Schedule Total cycles"
    )
    bf_cycle_mean: Optional[int] = Field(
        None, description="Backfill Schedule Mean cycle"
    )
    bf_cycle_max: Optional[int] = Field(
        None, description="Backfill Schedule Max cycle time"
    )
    bf_last_depth: Optional[int] = Field(
        None, description="Backfill Schedule Last depth cycle"
    )
    bf_last_depth_try: Optional[int] = Field(
        None, description="Backfill Schedule Mean cycle (try sched)"
    )
    bf_depth_mean: Optional[int] = Field(
        None, description="Backfill Schedule Depth Mean"
    )
    bf_depth_mean_try: Optional[int] = Field(
        None, description="Backfill Schedule Depth Mean (try sched)"
    )
    bf_cycle_last: Optional[int] = Field(
        None, description="Backfill Schedule Last cycle time"
    )
    bf_queue_len: Optional[int] = Field(
        None, description="Backfill Schedule Last queue length"
    )
    bf_queue_len_mean: Optional[int] = Field(
        None, description="Backfill Schedule Mean queue length"
    )
    bf_table_size: Optional[int] = Field(
        None, description="Backfill Schedule Last table size"
    )
    bf_table_size_mean: Optional[int] = Field(
        None, description="Backfill Schedule Mean table size"
    )
    bf_when_last_cycle: Optional[int] = Field(None, description="Last cycle timestamp")
    bf_active: Optional[bool] = Field(
        None, description="Backfill Schedule currently active"
    )
    rpcs_by_message_type: Optional[List[Field38DiagRpcm]] = Field(
        None, description="Remote Procedure Call statistics by message type"
    )
    rpcs_by_user: Optional[List[Field38DiagRpcu]] = Field(
        None, description="Remote Procedure Call statistics by user"
    )


class Field38Diag(BaseModel):
    meta: Optional[Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="slurm errors")
    statistics: Optional[StatisticsModel] = Field(None, description="Slurm statistics")


class Field38Licenses(BaseModel):
    errors: Optional[List[Field38Error]] = Field(None, description="slurm errors")
    licenses: Optional[List[Field38License]] = Field(None, description="licenses info")


class Field38Pings(BaseModel):
    meta: Optional[Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="slurm errors")
    pings: Optional[List[Field38Ping]] = Field(
        None, description="slurm controller pings"
    )


class Field38PartitionsResponse(BaseModel):
    meta: Optional[Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="slurm errors")
    partitions: Optional[List[Field38Partition]] = Field(
        None, description="partition info"
    )


class Field38ReservationsResponse(BaseModel):
    meta: Optional[Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="slurm errors")
    reservations: Optional[List[Field38Reservation]] = Field(
        None, description="reservation info"
    )


class Field38Errors(BaseModel):
    __root__: Optional[List[Field38Error]] = Field(None, description="Slurm errors")


class Field38JobSubmissionResponse(BaseModel):
    meta: Optional[Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="slurm errors")
    job_id: Optional[int] = Field(None, description="new job ID")
    step_id: Optional[str] = Field(None, description="new job step ID")
    job_submit_user_msg: Optional[str] = Field(
        None, description="Message to user from job_submit plugin"
    )


class Field38JobSubmission(BaseModel):
    script: Optional[str] = Field(
        None, description="Executable script (full contents) to run in batch step"
    )
    job: Optional[Field38JobProperties] = None
    jobs: Optional[List[Field38JobProperties]] = Field(
        None, description="Properties of an HetJob"
    )


class Field38JobResources(BaseModel):
    nodes: Optional[str] = Field(None, description="list of assigned job nodes")
    allocated_cpus: Optional[int] = Field(
        None, description="number of assigned job cpus"
    )
    allocated_hosts: Optional[int] = Field(
        None, description="number of assigned job hosts"
    )
    allocated_nodes: Optional[List[Field38NodeAllocation]] = Field(
        None, description="array of allocated nodes"
    )


class Field38NodesResponse(BaseModel):
    meta: Optional[Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="slurm errors")
    nodes: Optional[List[Field38Node]] = Field(None, description="nodes info")


class Field36JobResponseProperties(BaseModel):
    account: Optional[str] = Field(
        None, description="Charge resources used by this job to specified account"
    )
    accrue_time: Optional[str] = Field(
        None, description="time job is eligible for running"
    )
    admin_comment: Optional[str] = Field(
        None, description="administrator's arbitrary comment"
    )
    array_job_id: Optional[str] = Field(
        None, description="job_id of a job array or 0 if N/A"
    )
    array_task_id: Optional[str] = Field(None, description="task_id of a job array")
    array_max_tasks: Optional[str] = Field(
        None, description="Maximum number of running array tasks"
    )
    array_task_string: Optional[str] = Field(
        None, description="string expression of task IDs in this record"
    )
    association_id: Optional[str] = Field(None, description="association id for job")
    batch_features: Optional[str] = Field(
        None, description="features required for batch script's node"
    )
    batch_flag: Optional[bool] = Field(
        None, description="if batch: queued job with script"
    )
    batch_host: Optional[str] = Field(
        None, description="name of host running batch script"
    )
    flags: Optional[List[str]] = Field(None, description="Job flags")
    burst_buffer: Optional[str] = Field(None, description="burst buffer specifications")
    burst_buffer_state: Optional[str] = Field(
        None, description="burst buffer state info"
    )
    cluster: Optional[str] = Field(
        None, description="name of cluster that the job is on"
    )
    cluster_features: Optional[str] = Field(
        None, description="comma separated list of required cluster features"
    )
    command: Optional[str] = Field(None, description="command to be executed")
    comment: Optional[str] = Field(None, description="arbitrary comment")
    contiguous: Optional[bool] = Field(
        None, description="job requires contiguous nodes"
    )
    core_spec: Optional[str] = Field(None, description="specialized core count")
    thread_spec: Optional[str] = Field(None, description="specialized thread count")
    cores_per_socket: Optional[str] = Field(
        None, description="cores per socket required by job"
    )
    billable_tres: Optional[str] = Field(None, description="billable TRES")
    cpus_per_task: Optional[str] = Field(
        None, description="number of processors required for each task"
    )
    cpu_frequency_minimum: Optional[str] = Field(
        None, description="Minimum cpu frequency"
    )
    cpu_frequency_maximum: Optional[str] = Field(
        None, description="Maximum cpu frequency"
    )
    cpu_frequency_governor: Optional[str] = Field(
        None, description="cpu frequency governor"
    )
    cpus_per_tres: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    deadline: Optional[str] = Field(None, description="job start deadline ")
    delay_boot: Optional[str] = Field(None, description="command to be executed")
    dependency: Optional[str] = Field(
        None, description="synchronize job execution with other jobs"
    )
    derived_exit_code: Optional[str] = Field(
        None, description="highest exit code of all job steps"
    )
    eligible_time: Optional[str] = Field(
        None, description="time job is eligible for running"
    )
    end_time: Optional[str] = Field(
        None, description="time of termination, actual or expected"
    )
    excluded_nodes: Optional[str] = Field(
        None, description="comma separated list of excluded nodes"
    )
    exit_code: Optional[int] = Field(None, description="exit code for job")
    features: Optional[str] = Field(
        None, description="comma separated list of required features"
    )
    federation_origin: Optional[str] = Field(None, description="Origin cluster's name")
    federation_siblings_active: Optional[str] = Field(
        None, description="string of active sibling names"
    )
    federation_siblings_viable: Optional[str] = Field(
        None, description="string of viable sibling names"
    )
    gres_detail: Optional[List[str]] = Field(None, description="Job flags")
    group_id: Optional[str] = Field(None, description="group job submitted as")
    job_id: Optional[str] = Field(None, description="job ID")
    job_resources: Optional[Field36JobResources] = None
    job_state: Optional[str] = Field(None, description="state of the job")
    last_sched_evaluation: Optional[str] = Field(
        None, description="last time job was evaluated for scheduling"
    )
    licenses: Optional[str] = Field(None, description="licenses required by the job")
    max_cpus: Optional[str] = Field(
        None, description="maximum number of cpus usable by job"
    )
    max_nodes: Optional[str] = Field(
        None, description="maximum number of nodes usable by job"
    )
    mcs_label: Optional[str] = Field(None, description="mcs_label if mcs plugin in use")
    memory_per_tres: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    name: Optional[str] = Field(None, description="name of the job")
    nodes: Optional[str] = Field(None, description="list of nodes allocated to job")
    nice: Optional[str] = Field(None, description="requested priority change")
    tasks_per_core: Optional[str] = Field(
        None, description="number of tasks to invoke on each core"
    )
    tasks_per_socket: Optional[str] = Field(
        None, description="number of tasks to invoke on each socket"
    )
    tasks_per_board: Optional[str] = Field(
        None, description="number of tasks to invoke on each board"
    )
    cpus: Optional[str] = Field(
        None, description="minimum number of cpus required by job"
    )
    node_count: Optional[str] = Field(
        None, description="minimum number of nodes required by job"
    )
    tasks: Optional[str] = Field(None, description="requested task count")
    het_job_id: Optional[str] = Field(None, description="job ID of hetjob leader")
    het_job_id_set: Optional[str] = Field(
        None, description="job IDs for all components"
    )
    het_job_offset: Optional[str] = Field(
        None, description="HetJob component offset from leader"
    )
    partition: Optional[str] = Field(None, description="name of assigned partition")
    memory_per_node: Optional[str] = Field(
        None, description="minimum real memory per node"
    )
    memory_per_cpu: Optional[str] = Field(
        None, description="minimum real memory per cpu"
    )
    minimum_cpus_per_node: Optional[str] = Field(
        None, description="minimum # CPUs per node"
    )
    minimum_tmp_disk_per_node: Optional[str] = Field(
        None, description="minimum tmp disk per node"
    )
    preempt_time: Optional[str] = Field(None, description="preemption signal time")
    pre_sus_time: Optional[str] = Field(
        None, description="time job ran prior to last suspend"
    )
    priority: Optional[str] = Field(None, description="relative priority of the job")
    profile: Optional[List[str]] = Field(None, description="Job profiling requested")
    qos: Optional[str] = Field(None, description="Quality of Service")
    reboot: Optional[bool] = Field(
        None, description="node reboot requested before start"
    )
    required_nodes: Optional[str] = Field(
        None, description="comma separated list of required nodes"
    )
    requeue: Optional[bool] = Field(
        None, description="enable or disable job requeue option"
    )
    resize_time: Optional[str] = Field(None, description="time of latest size change")
    restart_cnt: Optional[str] = Field(None, description="count of job restarts")
    resv_name: Optional[str] = Field(None, description="reservation name")
    shared: Optional[str] = Field(
        None, description="type and if job can share nodes with other jobs"
    )
    show_flags: Optional[List[str]] = Field(None, description="details requested")
    sockets_per_board: Optional[str] = Field(
        None, description="sockets per board required by job"
    )
    sockets_per_node: Optional[str] = Field(
        None, description="sockets per node required by job"
    )
    start_time: Optional[str] = Field(
        None, description="time execution begins, actual or expected"
    )
    state_description: Optional[str] = Field(
        None, description="optional details for state_reason"
    )
    state_reason: Optional[str] = Field(
        None, description="reason job still pending or failed"
    )
    standard_error: Optional[str] = Field(
        None, description="pathname of job's stderr file"
    )
    standard_input: Optional[str] = Field(
        None, description="pathname of job's stdin file"
    )
    standard_output: Optional[str] = Field(
        None, description="pathname of job's stdout file"
    )
    submit_time: Optional[str] = Field(None, description="time of job submission")
    suspend_time: Optional[str] = Field(
        None, description="time job last suspended or resumed"
    )
    system_comment: Optional[str] = Field(
        None, description="slurmctld's arbitrary comment"
    )
    time_limit: Optional[str] = Field(None, description="maximum run time in minutes")
    time_minimum: Optional[str] = Field(None, description="minimum run time in minutes")
    threads_per_core: Optional[str] = Field(
        None, description="threads per core required by job"
    )
    tres_bind: Optional[str] = Field(
        None, description="Task to TRES binding directives"
    )
    tres_freq: Optional[str] = Field(None, description="TRES frequency directives")
    tres_per_job: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_per_node: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_per_socket: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_per_task: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_req_str: Optional[str] = Field(None, description="tres reqeusted in the job")
    tres_alloc_str: Optional[str] = Field(None, description="tres used in the job")
    user_id: Optional[str] = Field(None, description="user id the job runs as")
    user_name: Optional[str] = Field(None, description="user the job runs as")
    wckey: Optional[str] = Field(None, description="wckey for job")
    current_working_directory: Optional[str] = Field(
        None, description="pathname of working directory"
    )


class Field37JobResponseProperties(BaseModel):
    account: Optional[str] = Field(
        None, description="Charge resources used by this job to specified account"
    )
    accrue_time: Optional[int] = Field(
        None, description="time job is eligible for running"
    )
    admin_comment: Optional[str] = Field(
        None, description="administrator's arbitrary comment"
    )
    array_job_id: Optional[str] = Field(
        None, description="job_id of a job array or 0 if N/A"
    )
    array_task_id: Optional[str] = Field(None, description="task_id of a job array")
    array_max_tasks: Optional[str] = Field(
        None, description="Maximum number of running array tasks"
    )
    array_task_string: Optional[str] = Field(
        None, description="string expression of task IDs in this record"
    )
    association_id: Optional[str] = Field(None, description="association id for job")
    batch_features: Optional[str] = Field(
        None, description="features required for batch script's node"
    )
    batch_flag: Optional[bool] = Field(
        None, description="if batch: queued job with script"
    )
    batch_host: Optional[str] = Field(
        None, description="name of host running batch script"
    )
    flags: Optional[List[str]] = Field(None, description="Job flags")
    burst_buffer: Optional[str] = Field(None, description="burst buffer specifications")
    burst_buffer_state: Optional[str] = Field(
        None, description="burst buffer state info"
    )
    cluster: Optional[str] = Field(
        None, description="name of cluster that the job is on"
    )
    cluster_features: Optional[str] = Field(
        None, description="comma separated list of required cluster features"
    )
    command: Optional[str] = Field(None, description="command to be executed")
    comment: Optional[str] = Field(None, description="arbitrary comment")
    contiguous: Optional[bool] = Field(
        None, description="job requires contiguous nodes"
    )
    core_spec: Optional[str] = Field(None, description="specialized core count")
    thread_spec: Optional[str] = Field(None, description="specialized thread count")
    cores_per_socket: Optional[str] = Field(
        None, description="cores per socket required by job"
    )
    billable_tres: Optional[str] = Field(None, description="billable TRES")
    cpus_per_task: Optional[str] = Field(
        None, description="number of processors required for each task"
    )
    cpu_frequency_minimum: Optional[str] = Field(
        None, description="Minimum cpu frequency"
    )
    cpu_frequency_maximum: Optional[str] = Field(
        None, description="Maximum cpu frequency"
    )
    cpu_frequency_governor: Optional[str] = Field(
        None, description="cpu frequency governor"
    )
    cpus_per_tres: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    deadline: Optional[str] = Field(None, description="job start deadline ")
    delay_boot: Optional[str] = Field(None, description="command to be executed")
    dependency: Optional[str] = Field(
        None, description="synchronize job execution with other jobs"
    )
    derived_exit_code: Optional[str] = Field(
        None, description="highest exit code of all job steps"
    )
    eligible_time: Optional[int] = Field(
        None, description="time job is eligible for running"
    )
    end_time: Optional[int] = Field(
        None, description="time of termination, actual or expected"
    )
    excluded_nodes: Optional[str] = Field(
        None, description="comma separated list of excluded nodes"
    )
    exit_code: Optional[int] = Field(None, description="exit code for job")
    features: Optional[str] = Field(
        None, description="comma separated list of required features"
    )
    federation_origin: Optional[str] = Field(None, description="Origin cluster's name")
    federation_siblings_active: Optional[str] = Field(
        None, description="string of active sibling names"
    )
    federation_siblings_viable: Optional[str] = Field(
        None, description="string of viable sibling names"
    )
    gres_detail: Optional[List[str]] = Field(None, description="Job flags")
    group_id: Optional[str] = Field(None, description="group job submitted as")
    job_id: Optional[str] = Field(None, description="job ID")
    job_resources: Optional[Field37JobResources] = None
    job_state: Optional[str] = Field(None, description="state of the job")
    last_sched_evaluation: Optional[str] = Field(
        None, description="last time job was evaluated for scheduling"
    )
    licenses: Optional[str] = Field(None, description="licenses required by the job")
    max_cpus: Optional[str] = Field(
        None, description="maximum number of cpus usable by job"
    )
    max_nodes: Optional[str] = Field(
        None, description="maximum number of nodes usable by job"
    )
    mcs_label: Optional[str] = Field(None, description="mcs_label if mcs plugin in use")
    memory_per_tres: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    name: Optional[str] = Field(None, description="name of the job")
    nodes: Optional[str] = Field(None, description="list of nodes allocated to job")
    nice: Optional[str] = Field(None, description="requested priority change")
    tasks_per_core: Optional[str] = Field(
        None, description="number of tasks to invoke on each core"
    )
    tasks_per_socket: Optional[str] = Field(
        None, description="number of tasks to invoke on each socket"
    )
    tasks_per_board: Optional[str] = Field(
        None, description="number of tasks to invoke on each board"
    )
    cpus: Optional[str] = Field(
        None, description="minimum number of cpus required by job"
    )
    node_count: Optional[str] = Field(
        None, description="minimum number of nodes required by job"
    )
    tasks: Optional[str] = Field(None, description="requested task count")
    het_job_id: Optional[str] = Field(None, description="job ID of hetjob leader")
    het_job_id_set: Optional[str] = Field(
        None, description="job IDs for all components"
    )
    het_job_offset: Optional[str] = Field(
        None, description="HetJob component offset from leader"
    )
    partition: Optional[str] = Field(None, description="name of assigned partition")
    memory_per_node: Optional[str] = Field(
        None, description="minimum real memory per node"
    )
    memory_per_cpu: Optional[str] = Field(
        None, description="minimum real memory per cpu"
    )
    minimum_cpus_per_node: Optional[str] = Field(
        None, description="minimum # CPUs per node"
    )
    minimum_tmp_disk_per_node: Optional[str] = Field(
        None, description="minimum tmp disk per node"
    )
    preempt_time: Optional[int] = Field(None, description="preemption signal time")
    pre_sus_time: Optional[int] = Field(
        None, description="time job ran prior to last suspend"
    )
    priority: Optional[str] = Field(None, description="relative priority of the job")
    profile: Optional[List[str]] = Field(None, description="Job profiling requested")
    qos: Optional[str] = Field(None, description="Quality of Service")
    reboot: Optional[bool] = Field(
        None, description="node reboot requested before start"
    )
    required_nodes: Optional[str] = Field(
        None, description="comma separated list of required nodes"
    )
    requeue: Optional[bool] = Field(
        None, description="enable or disable job requeue option"
    )
    resize_time: Optional[int] = Field(None, description="time of latest size change")
    restart_cnt: Optional[str] = Field(None, description="count of job restarts")
    resv_name: Optional[str] = Field(None, description="reservation name")
    shared: Optional[str] = Field(
        None, description="type and if job can share nodes with other jobs"
    )
    show_flags: Optional[List[str]] = Field(None, description="details requested")
    sockets_per_board: Optional[str] = Field(
        None, description="sockets per board required by job"
    )
    sockets_per_node: Optional[str] = Field(
        None, description="sockets per node required by job"
    )
    start_time: Optional[int] = Field(
        None, description="time execution begins, actual or expected"
    )
    state_description: Optional[str] = Field(
        None, description="optional details for state_reason"
    )
    state_reason: Optional[str] = Field(
        None, description="reason job still pending or failed"
    )
    standard_error: Optional[str] = Field(
        None, description="pathname of job's stderr file"
    )
    standard_input: Optional[str] = Field(
        None, description="pathname of job's stdin file"
    )
    standard_output: Optional[str] = Field(
        None, description="pathname of job's stdout file"
    )
    submit_time: Optional[int] = Field(None, description="time of job submission")
    suspend_time: Optional[int] = Field(
        None, description="time job last suspended or resumed"
    )
    system_comment: Optional[str] = Field(
        None, description="slurmctld's arbitrary comment"
    )
    time_limit: Optional[str] = Field(None, description="maximum run time in minutes")
    time_minimum: Optional[str] = Field(None, description="minimum run time in minutes")
    threads_per_core: Optional[str] = Field(
        None, description="threads per core required by job"
    )
    tres_bind: Optional[str] = Field(
        None, description="Task to TRES binding directives"
    )
    tres_freq: Optional[str] = Field(None, description="TRES frequency directives")
    tres_per_job: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_per_node: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_per_socket: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_per_task: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_req_str: Optional[str] = Field(None, description="tres reqeusted in the job")
    tres_alloc_str: Optional[str] = Field(None, description="tres used in the job")
    user_id: Optional[str] = Field(None, description="user id the job runs as")
    user_name: Optional[str] = Field(None, description="user the job runs as")
    wckey: Optional[str] = Field(None, description="wckey for job")
    current_working_directory: Optional[str] = Field(
        None, description="pathname of working directory"
    )


class Field38JobResponseProperties(BaseModel):
    account: Optional[str] = Field(
        None, description="Charge resources used by this job to specified account"
    )
    accrue_time: Optional[int] = Field(
        None, description="time job is eligible for running"
    )
    admin_comment: Optional[str] = Field(
        None, description="administrator's arbitrary comment"
    )
    array_job_id: Optional[int] = Field(
        None, description="job_id of a job array or 0 if N/A"
    )
    array_task_id: Optional[int] = Field(None, description="task_id of a job array")
    array_max_tasks: Optional[int] = Field(
        None, description="Maximum number of running array tasks"
    )
    array_task_string: Optional[str] = Field(
        None, description="string expression of task IDs in this record"
    )
    association_id: Optional[int] = Field(None, description="association id for job")
    batch_features: Optional[str] = Field(
        None, description="features required for batch script's node"
    )
    batch_flag: Optional[bool] = Field(
        None, description="if batch: queued job with script"
    )
    batch_host: Optional[str] = Field(
        None, description="name of host running batch script"
    )
    flags: Optional[List[str]] = Field(None, description="Job flags")
    burst_buffer: Optional[str] = Field(None, description="burst buffer specifications")
    burst_buffer_state: Optional[str] = Field(
        None, description="burst buffer state info"
    )
    cluster: Optional[str] = Field(
        None, description="name of cluster that the job is on"
    )
    cluster_features: Optional[str] = Field(
        None, description="comma separated list of required cluster features"
    )
    command: Optional[str] = Field(None, description="command to be executed")
    comment: Optional[str] = Field(None, description="arbitrary comment")
    container: Optional[str] = Field(
        None, description="absolute path to OCI container bundle"
    )
    contiguous: Optional[bool] = Field(
        None, description="job requires contiguous nodes"
    )
    core_spec: Optional[str] = Field(None, description="specialized core count")
    thread_spec: Optional[str] = Field(None, description="specialized thread count")
    cores_per_socket: Optional[str] = Field(
        None, description="cores per socket required by job"
    )
    billable_tres: Optional[float] = Field(None, description="billable TRES")
    cpus_per_task: Optional[str] = Field(
        None, description="number of processors required for each task"
    )
    cpu_frequency_minimum: Optional[str] = Field(
        None, description="Minimum cpu frequency"
    )
    cpu_frequency_maximum: Optional[str] = Field(
        None, description="Maximum cpu frequency"
    )
    cpu_frequency_governor: Optional[str] = Field(
        None, description="cpu frequency governor"
    )
    cpus_per_tres: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    deadline: Optional[int] = Field(None, description="job start deadline ")
    delay_boot: Optional[int] = Field(None, description="command to be executed")
    dependency: Optional[str] = Field(
        None, description="synchronize job execution with other jobs"
    )
    derived_exit_code: Optional[int] = Field(
        None, description="highest exit code of all job steps"
    )
    eligible_time: Optional[int] = Field(
        None, description="time job is eligible for running"
    )
    end_time: Optional[int] = Field(
        None, description="time of termination, actual or expected"
    )
    excluded_nodes: Optional[str] = Field(
        None, description="comma separated list of excluded nodes"
    )
    exit_code: Optional[int] = Field(None, description="exit code for job")
    features: Optional[str] = Field(
        None, description="comma separated list of required features"
    )
    federation_origin: Optional[str] = Field(None, description="Origin cluster's name")
    federation_siblings_active: Optional[str] = Field(
        None, description="string of active sibling names"
    )
    federation_siblings_viable: Optional[str] = Field(
        None, description="string of viable sibling names"
    )
    gres_detail: Optional[List[str]] = Field(None, description="Job flags")
    group_id: Optional[int] = Field(None, description="group job submitted as")
    job_id: Optional[int] = Field(None, description="job ID")
    job_resources: Optional[Field38JobResources] = None
    job_state: Optional[str] = Field(None, description="state of the job")
    last_sched_evaluation: Optional[int] = Field(
        None, description="last time job was evaluated for scheduling"
    )
    licenses: Optional[str] = Field(None, description="licenses required by the job")
    max_cpus: Optional[int] = Field(
        None, description="maximum number of cpus usable by job"
    )
    max_nodes: Optional[int] = Field(
        None, description="maximum number of nodes usable by job"
    )
    mcs_label: Optional[str] = Field(None, description="mcs_label if mcs plugin in use")
    memory_per_tres: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    name: Optional[str] = Field(None, description="name of the job")
    nodes: Optional[str] = Field(None, description="list of nodes allocated to job")
    nice: Optional[int] = Field(None, description="requested priority change")
    tasks_per_core: Optional[int] = Field(
        None, description="number of tasks to invoke on each core"
    )
    tasks_per_socket: Optional[int] = Field(
        None, description="number of tasks to invoke on each socket"
    )
    tasks_per_board: Optional[int] = Field(
        None, description="number of tasks to invoke on each board"
    )
    cpus: Optional[int] = Field(
        None, description="minimum number of cpus required by job"
    )
    node_count: Optional[int] = Field(
        None, description="minimum number of nodes required by job"
    )
    tasks: Optional[int] = Field(None, description="requested task count")
    het_job_id: Optional[int] = Field(None, description="job ID of hetjob leader")
    het_job_id_set: Optional[str] = Field(
        None, description="job IDs for all components"
    )
    het_job_offset: Optional[int] = Field(
        None, description="HetJob component offset from leader"
    )
    partition: Optional[str] = Field(None, description="name of assigned partition")
    memory_per_node: Optional[int] = Field(
        None, description="minimum real memory per node"
    )
    memory_per_cpu: Optional[int] = Field(
        None, description="minimum real memory per cpu"
    )
    minimum_cpus_per_node: Optional[int] = Field(
        None, description="minimum # CPUs per node"
    )
    minimum_tmp_disk_per_node: Optional[int] = Field(
        None, description="minimum tmp disk per node"
    )
    preempt_time: Optional[int] = Field(None, description="preemption signal time")
    pre_sus_time: Optional[int] = Field(
        None, description="time job ran prior to last suspend"
    )
    priority: Optional[int] = Field(None, description="relative priority of the job")
    profile: Optional[List[str]] = Field(None, description="Job profiling requested")
    qos: Optional[str] = Field(None, description="Quality of Service")
    reboot: Optional[bool] = Field(
        None, description="node reboot requested before start"
    )
    required_nodes: Optional[str] = Field(
        None, description="comma separated list of required nodes"
    )
    requeue: Optional[bool] = Field(
        None, description="enable or disable job requeue option"
    )
    resize_time: Optional[int] = Field(None, description="time of latest size change")
    restart_cnt: Optional[int] = Field(None, description="count of job restarts")
    resv_name: Optional[str] = Field(None, description="reservation name")
    shared: Optional[str] = Field(
        None, description="type and if job can share nodes with other jobs"
    )
    show_flags: Optional[List[str]] = Field(None, description="details requested")
    sockets_per_board: Optional[int] = Field(
        None, description="sockets per board required by job"
    )
    sockets_per_node: Optional[int] = Field(
        None, description="sockets per node required by job"
    )
    start_time: Optional[int] = Field(
        None, description="time execution begins, actual or expected"
    )
    state_description: Optional[str] = Field(
        None, description="optional details for state_reason"
    )
    state_reason: Optional[str] = Field(
        None, description="reason job still pending or failed"
    )
    standard_error: Optional[str] = Field(
        None, description="pathname of job's stderr file"
    )
    standard_input: Optional[str] = Field(
        None, description="pathname of job's stdin file"
    )
    standard_output: Optional[str] = Field(
        None, description="pathname of job's stdout file"
    )
    submit_time: Optional[int] = Field(None, description="time of job submission")
    suspend_time: Optional[int] = Field(
        None, description="time job last suspended or resumed"
    )
    system_comment: Optional[str] = Field(
        None, description="slurmctld's arbitrary comment"
    )
    time_limit: Optional[int] = Field(None, description="maximum run time in minutes")
    time_minimum: Optional[int] = Field(None, description="minimum run time in minutes")
    threads_per_core: Optional[int] = Field(
        None, description="threads per core required by job"
    )
    tres_bind: Optional[str] = Field(
        None, description="Task to TRES binding directives"
    )
    tres_freq: Optional[str] = Field(None, description="TRES frequency directives")
    tres_per_job: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_per_node: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_per_socket: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_per_task: Optional[str] = Field(
        None, description="semicolon delimited list of TRES=# values"
    )
    tres_req_str: Optional[str] = Field(None, description="tres reqeusted in the job")
    tres_alloc_str: Optional[str] = Field(None, description="tres used in the job")
    user_id: Optional[int] = Field(None, description="user id the job runs as")
    user_name: Optional[str] = Field(None, description="user the job runs as")
    wckey: Optional[str] = Field(None, description="wckey for job")
    current_working_directory: Optional[str] = Field(
        None, description="pathname of working directory"
    )


class Field36JobsResponse(BaseModel):
    errors: Optional[List[Field36Error]] = Field(None, description="slurm errors")
    jobs: Optional[List[Field36JobResponseProperties]] = Field(
        None, description="job descriptions"
    )


class Field37JobsResponse(BaseModel):
    errors: Optional[List[Field37Error]] = Field(None, description="slurm errors")
    jobs: Optional[List[Field37JobResponseProperties]] = Field(
        None, description="job descriptions"
    )


class Field38JobsResponse(BaseModel):
    meta: Optional[Field38Meta] = None
    errors: Optional[List[Field38Error]] = Field(None, description="slurm errors")
    jobs: Optional[List[Field38JobResponseProperties]] = Field(
        None, description="job descriptions"
    )
